/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.treatment;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.treatment.GlobalTreatmentManager;
import fr.inra.sad.bagap.apiland.treatment.TreatmentException;
import fr.inra.sad.bagap.apiland.treatment.TreatmentManager;
import fr.inra.sad.bagap.apiland.treatment.TreatmentObserver;
import fr.inra.sad.bagap.apiland.treatment.TreatmentState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Treatment
implements AnalysisObserver {
    private String name;
    private TreatmentManager manager;
    private Map<String, Object> inputs;
    private Map<String, Class<?>> inputsBinding;
    private Map<String, Object> outputs;
    private Map<String, Class<?>> outputsBinding;
    private Set<TreatmentObserver> observers;
    private TreatmentState state;

    public Treatment(String name) {
        this(name, GlobalTreatmentManager.get());
    }

    public Treatment(String name, TreatmentManager manager) {
        this.name = name;
        this.inputs = new HashMap<String, Object>();
        this.inputsBinding = new HashMap();
        this.outputs = new HashMap<String, Object>();
        this.outputsBinding = new HashMap();
        this.state = TreatmentState.IDLE;
        this.observers = new HashSet<TreatmentObserver>();
        manager.addTreatment(this);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public TreatmentManager manager() {
        return this.manager;
    }

    public void setTreatmentManager(TreatmentManager tm) {
        this.manager = tm;
    }

    public void addObserver(TreatmentObserver v) {
        this.observers.add(v);
    }

    public Set<TreatmentObserver> observers() {
        return this.observers;
    }

    private void notifyViews() {
        TreatmentState s = this.state;
        for (TreatmentObserver v : this.observers) {
            v.notify(this, s);
        }
    }

    @Override
    public void updateProgression(Analysis a, int total) {
        for (TreatmentObserver v : this.observers) {
            v.updateProgression(this, total);
        }
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
    }

    public final void init() throws TreatmentException {
        this.state = TreatmentState.SETTING;
        this.notifyViews();
        if (!this.checkInputs()) {
            // empty if block
        }
        this.doInit();
        this.state = TreatmentState.INIT;
        this.notifyViews();
    }

    protected abstract void doInit() throws TreatmentException;

    public final void run() throws TreatmentException {
        this.state = TreatmentState.RUNNING;
        this.notifyViews();
        this.doRun();
        if (!this.checkOutputs()) {
            // empty if block
        }
        for (Map.Entry<String, Object> e : this.outputs.entrySet()) {
            this.manager.flow(this, e.getKey(), e.getValue());
        }
        this.state = TreatmentState.DONE;
        this.notifyViews();
    }

    protected abstract void doRun() throws TreatmentException;

    public final void close() throws TreatmentException {
        this.state = TreatmentState.CLOSING;
        this.notifyViews();
        this.doClose();
        this.state = TreatmentState.FINISH;
    }

    public void clearObservers() {
        this.observers.clear();
    }

    public void clearOutputs() {
        this.outputs.clear();
        this.outputsBinding.clear();
    }

    protected abstract void doClose() throws TreatmentException;

    public final void abort() {
        this.state = TreatmentState.FAILED;
        this.notifyViews();
        this.doAbort();
    }

    protected void doAbort() {
    }

    public void allRun() throws TreatmentException {
        this.init();
        this.run();
        this.close();
    }

    public boolean hasPort(String port) {
        return this.inputs.containsKey(port) || this.outputs.containsKey(port);
    }

    public Class<?> getPortBinding(String port) {
        if (this.inputsBinding.containsKey(port)) {
            return this.inputsBinding.get(port);
        }
        return this.outputsBinding.get(port);
    }

    private boolean checkInputs() {
        for (Map.Entry<String, Object> e : this.inputs.entrySet()) {
            if (e.getValue() != null) continue;
            System.err.println("warning : the input named '" + e.getKey() + "' is not initialized in the treatment '" + this + "'");
            return false;
        }
        return true;
    }

    private boolean checkOutputs() {
        for (Map.Entry<String, Object> e : this.outputs.entrySet()) {
            if (e.getValue() != null) continue;
            System.err.println("warning : the output named '" + e.getKey() + "' is not initialized in the treatment '" + this + "'");
            return false;
        }
        return true;
    }

    protected Map<String, Object> inputs() {
        return this.inputs;
    }

    protected Map<String, Object> outputs() {
        return this.outputs;
    }

    public void setInput(String s, Object o) {
        if (!this.inputs.containsKey(s)) {
            throw new IllegalArgumentException("name error : the input '" + s + "' does not exist in the treatment '" + this.name + "'");
        }
        if (!this.inputsBinding.get(s).isAssignableFrom(o.getClass())) {
            throw new IllegalArgumentException("cast error : the input '" + s + "' has the following cast '" + this.inputsBinding.get(s) + "' and not '" + o.getClass() + "'");
        }
        this.inputs.put(s, o);
    }

    public void setOutput(String s, Object o) {
        if (!this.outputs.containsKey(s)) {
            throw new IllegalArgumentException("name error : the output '" + s + "' does not exist in the treatment '" + this.name + "'");
        }
        if (!this.outputsBinding.get(s).isAssignableFrom(o.getClass())) {
            throw new IllegalArgumentException("cast error : the output '" + s + "' has the following cast '" + this.outputsBinding.get(s) + "' and not '" + o.getClass() + "'");
        }
        this.outputs.put(s, o);
    }

    public Object getInput(String s) {
        return this.inputs.get(s);
    }

    public Object getOutput(String s) {
        return this.outputs.get(s);
    }

    public void defineInput(String input, Class<?> binding) {
        this.inputs.put(input, null);
        this.inputsBinding.put(input, binding);
    }

    public void defineOutput(String output, Class<?> binding) {
        this.outputs.put(output, null);
        this.outputsBinding.put(output, binding);
    }

    public static void defineLink(Treatment t1, String port1, Treatment t2, String port2) {
        GlobalTreatmentManager.get().addLink(t1, port1, t2, port2);
    }

    public void displayPorts() {
        this.displayInputs();
        this.displayOutputs();
    }

    public void displayInputs() {
        System.out.println("inputs of treatment '" + this.name + "':");
        for (Map.Entry<String, Object> e : this.inputs.entrySet()) {
            System.out.println(e.getKey() + " --> " + e.getValue());
        }
    }

    public void displayOutputs() {
        System.out.println("outputs of treatment '" + this.name + "':");
        for (Map.Entry<String, Object> e : this.outputs.entrySet()) {
            System.out.println(e.getKey() + " --> " + e.getValue());
        }
    }
}

