/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul.operation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.geom.prep.PreparedPoint;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringQueenAnalysis;
import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.DynamicFeature;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.space.Geometry;
import fr.inra.sad.bagap.apiland.core.space.GeometryFactory;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.ArrayMatrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.ArrayMatrixFactory;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.structure.Representation;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.simul.operation.OpRasterizationType;
import fr.inra.sad.bagap.apiland.simul.operation.OpTranslation;
import java.util.Iterator;
import java.util.List;

public class OpRasterization
extends OpTranslation {
    private static final long serialVersionUID = 1L;
    private double cellsize;
    private double minX = -1.0;
    private double maxX = -1.0;
    private double minY = -1.0;
    private double maxY = -1.0;
    private String rasterRepresentation = "raster";

    public OpRasterization(OpRasterizationType type) {
        super(type);
        this.cellsize = type.getCellSize();
        if (type.minX() != -1.0 && type.maxX() != -1.0 && type.minY() != -1.0 && type.maxY() != -1.0) {
            this.minX = type.minX();
            this.maxX = type.maxX();
            this.minY = type.minY();
            this.maxY = type.maxY();
        }
        this.rasterRepresentation = type.raster();
    }

    public double getCellSize() {
        return this.cellsize;
    }

    @Override
    public boolean make(Instant t, DynamicElement ... e) {
        if (this.minX != -1.0 && this.maxX != -1.0 && this.minY != -1.0 && this.maxY != -1.0) {
            this.getRasterRepresentation(e[0], e[0].getRepresentation(this.getRepresentation()), t, this.getCellSize(), this.minX, this.maxX, this.minY, this.maxY);
        } else {
            this.getRasterRepresentation(e[0], e[0].getRepresentation(this.getRepresentation()), t, this.getCellSize());
        }
        return true;
    }

    private void getRasterRepresentation(DynamicElement element, Representation vectorRepresentation, Instant t, double cellsize) {
        Iterator ite = ((DynamicLayer)element).deepIterator();
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        while (ite.hasNext()) {
            DynamicFeature f = (DynamicFeature)ite.next();
            minX = Math.min(f.minX(), minX);
            minY = Math.min(f.minY(), minY);
            maxX = Math.max(f.maxX(), maxX);
            maxY = Math.max(f.maxY(), maxY);
        }
        this.getRasterRepresentation(element, vectorRepresentation, t, cellsize, minX, maxX, minY, maxY);
    }

    private void getRasterRepresentation(DynamicElement element, Representation<?> vectorRepresentation, Instant t, double cellsize, double minX, double maxX, double minY, double maxY) {
        DynamicFeature f;
        Raster.setCellSize(cellsize);
        int ncols = new Double(Math.floor((maxX - minX) / Raster.getCellSize()) + 1.0).intValue();
        int nrows = new Double(Math.floor((maxY - minY) / Raster.getCellSize()) + 1.0).intValue();
        ArrayMatrix mt = ArrayMatrixFactory.get().create(ncols, nrows, cellsize, minX, maxX, minY, maxY, Raster.getNoDataValue());
        PreparedPoint p = null;
        List l = null;
        DynamicElement dftemp = null;
        int vtemp = Raster.getNoDataValue();
        int modulo = 1;
        WKTReader wktr = new WKTReader();
        STRtree sIndex = new STRtree();
        Iterator ite = ((DynamicLayer)element).deepIterator();
        while (ite.hasNext()) {
            f = (DynamicFeature)ite.next();
            sIndex.insert(f.getGeometry(t).get().getJTS().getEnvelopeInternal(), (Object)f);
        }
        sIndex.build();
        for (int j = 0; j < nrows; ++j) {
            double x = minX;
            double y = maxY - (double)j * cellsize;
            if (j % modulo == 0) {
                Envelope env = new Envelope(new Coordinate(x, y), new Coordinate(maxX, y - (double)modulo * cellsize));
                l = sIndex.query(env);
            }
            for (int i = 0; i < ncols; ++i) {
                x = minX + (double)i * cellsize;
                boolean ok = false;
                try {
                    p = new PreparedPoint((Puntal)wktr.read("POINT (" + x + " " + y + ")"));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (dftemp != null && p.intersects(dftemp.getGeometry(t).get().getJTS())) {
                    mt.put(i, j, vtemp);
                    ok = true;
                }
                if (!ok) {
                    for (DynamicFeature df : l) {
                        if (!p.intersects(df.getGeometry(t).get().getJTS())) continue;
                        vtemp = new Integer(df.getId().toString());
                        dftemp = df;
                        mt.put(i, j, vtemp);
                        ok = true;
                        break;
                    }
                }
                if (ok) continue;
                mt.put(i, j, Raster.getNoDataValue());
            }
        }
        ClusteringQueenAnalysis ca = new ClusteringQueenAnalysis((Matrix)mt, null);
        ca.allRun();
        RasterComposite raster = (RasterComposite)ca.getResult();
        block6: for (Raster r : raster.getRasters()) {
            String id = new Integer((int)mt.get((Pixel)r.iterator().next())).toString();
            ite = ((DynamicLayer)element).deepIterator();
            while (ite.hasNext()) {
                f = (DynamicFeature)ite.next();
                if (!f.getId().equalsIgnoreCase(id)) continue;
                Geometry g = GeometryFactory.create(r);
                f.getRepresentation(this.rasterRepresentation).setGeometry(t, g);
                continue block6;
            }
        }
    }
}

