/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.util;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.plugin.AscReader;
import ij.plugin.LutLoader;
import ij.process.ImageProcessor;
import java.io.File;
import java.util.StringTokenizer;

public class VisuImageJ {
    public VisuImageJ(String file) {
        String ext;
        ImageJ ij = IJ.getInstance();
        if (ij == null || ij != null && !ij.isShowing()) {
            ij = new ImageJ();
        }
        if ((ext = VisuImageJ.getExtension(file)).equalsIgnoreCase("asc")) {
            VisuImageJ.visualizeAsciiGrid(file);
        } else if (ext.equalsIgnoreCase("tif") || ext.equalsIgnoreCase("tiff")) {
            VisuImageJ.visualizeTiff(file);
        }
        LutLoader ll = new LutLoader();
        ll.run("fire");
    }

    private static void visualizeTiff(String file) {
        ImagePlus img = new ImagePlus(file);
        if (img != null) {
            img.show();
        }
    }

    private static void visualizeAsciiGrid(String file) {
        AscReader tr = new AscReader();
        ImageProcessor ip = tr.open(file);
        if (ip != null) {
            String nom = VisuImageJ.deleteExtension(VisuImageJ.getNomCourt(file));
            ImagePlus imp = new ImagePlus(nom, ip);
            imp.show();
        }
    }

    private static String getExtension(String file) {
        StringTokenizer st = new StringTokenizer(file, ".");
        String last = null;
        while (st.hasMoreTokens()) {
            last = st.nextToken();
        }
        return last;
    }

    private static String deleteExtension(String file) {
        String line = "";
        StringTokenizer st = new StringTokenizer(file, ".");
        String last = "";
        while (st.hasMoreTokens()) {
            last = last + line;
            line = st.nextToken();
        }
        return last;
    }

    private static String getNomCourt(String nom) {
        File f = new File(nom);
        return f.getName();
    }
}

