/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.IteratorMatrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixType;
import fr.inra.sad.bagap.apiland.core.util.Couple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class YaleSparseMatrix
implements Matrix {
    private List<Double> vA;
    private int[] iA;
    private List<Integer> xA;
    private int width;
    private double minX;
    private double maxY;
    private double minY;
    private double maxX;
    private int noDataValue;
    private double cellsize;
    private String file;
    private Set<Integer> values;

    public YaleSparseMatrix(int width, int height, double cellsize, double minX, double maxX, double minY, double maxY, int noDataValue) {
        this.width = width;
        this.cellsize = cellsize;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.noDataValue = noDataValue;
        this.vA = new ArrayList<Double>();
        this.iA = new int[height + 1];
        this.xA = new ArrayList<Integer>();
        this.values = new HashSet<Integer>();
    }

    public YaleSparseMatrix(Matrix matrix) {
        this.width = matrix.width();
        this.cellsize = matrix.cellsize();
        this.minX = matrix.minX();
        this.maxY = matrix.maxY();
        this.noDataValue = matrix.noDataValue();
        this.vA = new ArrayList<Double>();
        this.iA = new int[matrix.height() + 1];
        this.xA = new ArrayList<Integer>();
        this.values = new HashSet<Integer>();
    }

    @Override
    public double getActiveArea() {
        double area = 0.0;
        for (Pixel p : this) {
            if (this.get(p) == (double)this.noDataValue) continue;
            area += Math.pow(this.cellsize, 2.0);
        }
        return area;
    }

    @Override
    public MatrixType getType() {
        return MatrixType.YALE_SPARSE;
    }

    @Override
    public void init(double v) {
        this.noDataValue = new Double(v).intValue();
    }

    @Override
    public void visualize() {
        MatrixManager.visualize(this);
    }

    @Override
    public double cellsize() {
        return this.cellsize;
    }

    @Override
    public void display() {
    }

    @Override
    public double get(int x, int y) {
        try {
            int n = this.iA[y + 1] - this.iA[y];
            for (int i = 0; i < n; ++i) {
                if (this.xA.get(this.iA[y] + i) != x) continue;
                return this.vA.get(this.iA[y] + i);
            }
            return this.noDataValue;
        }
        catch (Exception ex) {
            return this.noDataValue;
        }
    }

    @Override
    public double get(Pixel p) {
        return this.get(p.x(), p.y());
    }

    @Override
    public void put(int x, int y, double value) {
        if (value != (double)this.noDataValue) {
            try {
                int n = this.iA[y + 1] - this.iA[y];
                for (int i = 0; i < n; ++i) {
                    if (this.xA.get(this.iA[y] + i) == x) {
                        this.vA.set(this.iA[y] + i, value);
                        return;
                    }
                    if (this.xA.get(this.iA[y] + i) <= x) continue;
                    this.xA.add(this.iA[y] + i, x);
                    this.vA.add(this.iA[y] + i, value);
                    int j = y + 1;
                    while (j < this.iA.length) {
                        int n2 = j++;
                        this.iA[n2] = this.iA[n2] + 1;
                    }
                    return;
                }
                this.xA.add(this.iA[y] + n, x);
                this.vA.add(this.iA[y] + n, value);
                int j = y + 1;
                while (j < this.iA.length) {
                    int n3 = j++;
                    this.iA[n3] = this.iA[n3] + 1;
                }
                this.values.add(new Double(value).intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void put(Pixel p, double value) {
        this.put(p.x(), p.y(), value);
    }

    @Override
    public void put(Raster r, double value) {
        for (Pixel p : r) {
            this.put(p, value);
        }
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public int height() {
        return this.iA.length - 1;
    }

    @Override
    public double maxX() {
        return this.maxX;
    }

    @Override
    public double maxY() {
        return this.maxY;
    }

    @Override
    public double minX() {
        return this.minX;
    }

    @Override
    public double minY() {
        return this.minY;
    }

    @Override
    public int noDataValue() {
        return this.noDataValue;
    }

    @Override
    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public Set<Integer> values() {
        return this.values;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public Iterator<Pixel> iterator() {
        return new IteratorMatrix(this);
    }

    @Override
    public void getCouples(Matrix horizontals, Matrix verticals) {
        int y;
        for (y = 0; y < this.height() - 1; ++y) {
            for (int x = 0; x < this.width() - 1; ++x) {
                System.out.println(x + " " + y);
                verticals.put(x, y, Couple.get(new Double(this.get(x, y)).intValue(), new Double(this.get(x, y + 1)).intValue()));
                horizontals.put(x, y, Couple.get(new Double(this.get(x, y)).intValue(), new Double(this.get(x + 1, y)).intValue()));
            }
        }
        for (y = 0; y < this.height() - 1; ++y) {
            verticals.put(this.width() - 1, y, Couple.get(new Double(this.get(this.width() - 1, y)).intValue(), new Double(this.get(this.width() - 1, y + 1)).intValue()));
        }
        for (int x = 0; x < this.width() - 1; ++x) {
            horizontals.put(x, this.height() - 1, Couple.get(new Double(this.get(x, this.height() - 1)).intValue(), new Double(this.get(x + 1, this.height() - 1)).intValue()));
        }
    }

    @Override
    public int tileWidth() {
        return this.width();
    }

    @Override
    public int tileHeight() {
        return this.height();
    }

    @Override
    public int numXTiles() {
        return 1;
    }

    @Override
    public int numYTiles() {
        return 1;
    }

    @Override
    public boolean contains(Pixel p) {
        return false;
    }

    @Override
    public double minV() {
        return 0.0;
    }

    @Override
    public double maxV() {
        return 0.0;
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }
}

