/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelManager;
import java.util.Iterator;
import javax.media.jai.PlanarImage;

public class TiledMatrixIterator
implements Iterator<Pixel> {
    private int width;
    private int height;
    private int nbYTile;
    private int nbXTile;
    private int tileWidth;
    private int tileHeight;
    private int xt;
    private int yt;
    private int x;
    private int y;

    public TiledMatrixIterator(PlanarImage pi) {
        this.nbYTile = pi.getNumYTiles();
        this.nbXTile = pi.getNumXTiles();
        this.tileWidth = pi.getTileWidth();
        this.tileHeight = pi.getTileHeight();
        this.width = pi.getWidth();
        this.height = pi.getHeight();
        this.xt = 0;
        this.yt = 0;
        this.x = -1;
        this.y = 0;
    }

    @Override
    public boolean hasNext() {
        return this.y != this.height - 1 || this.x != this.width - 1;
    }

    @Override
    public Pixel next() {
        if (this.x == (this.xt + 1) * this.tileWidth - 1 || this.x == this.width - 1) {
            this.x = this.xt * this.tileWidth;
            if (this.y == (this.yt + 1) * this.tileHeight - 1 || this.y == this.height - 1) {
                if (this.xt == this.nbXTile - 1) {
                    this.xt = 0;
                    this.x = 0;
                    ++this.yt;
                    this.y = this.yt * this.tileHeight;
                } else {
                    ++this.xt;
                    this.x = this.xt * this.tileWidth;
                    this.y = this.yt * this.tileHeight;
                }
            } else {
                ++this.y;
            }
        } else {
            ++this.x;
        }
        return PixelManager.get(this.x, this.y);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

