/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import com.csvreader.CsvReader;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.geom.prep.PreparedPoint;
import com.vividsolutions.jts.geom.prep.PreparedPolygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.DynamicFeature;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.ArrayMatrixFactory;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.JaiMatrixFactory;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.SparseMatrixFactory;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.YaleSparseMatrixFactory;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.List;
import javax.media.jai.PlanarImage;

public abstract class MatrixFactory {
    public static MatrixFactory get(MatrixType type) {
        if (type == MatrixType.ARRAY) {
            return ArrayMatrixFactory.get();
        }
        if (type == MatrixType.SPARSE) {
            return SparseMatrixFactory.get();
        }
        if (type == MatrixType.YALE_SPARSE) {
            return YaleSparseMatrixFactory.get();
        }
        if (type == MatrixType.JAI) {
            return JaiMatrixFactory.get();
        }
        return ArrayMatrixFactory.get();
    }

    public abstract Matrix create(Matrix var1);

    public abstract Matrix create(Matrix var1, int var2);

    public abstract Matrix create(int var1, int var2, double var3, double var5, double var7, double var9, double var11, int var13);

    public abstract Matrix create(int var1, int var2, double var3, double var5, double var7, double var9, double var11, int var13, PlanarImage var14);

    public Matrix init(String in) {
        Matrix m = null;
        try {
            CsvReader cr = new CsvReader(in);
            cr.setDelimiter(' ');
            cr.readRecord();
            int width = new Integer(cr.get(1));
            cr.readRecord();
            int height = new Integer(cr.get(1));
            cr.readRecord();
            double minX = new Double(cr.get(1));
            cr.readRecord();
            double minY = new Double(cr.get(1));
            cr.readRecord();
            double cellsize = new Double(cr.get(1));
            cr.readRecord();
            int noData = new Integer(cr.get(1));
            double maxX = minX + (double)width * cellsize;
            double maxY = minY + (double)height * cellsize;
            m = this.create(width, height, cellsize, minX, maxX, minY, maxY, noData);
            int j = 0;
            while (cr.readRecord()) {
                for (int i = 0; i < width; ++i) {
                    m.put(i, j, new Double(cr.get(i)));
                }
                ++j;
            }
            m.setFile(in);
            cr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    public Matrix init(Matrix mRef, Raster r, double value) {
        Matrix m = this.create(mRef);
        m.init(m.noDataValue());
        for (Pixel p : r) {
            m.put(p, value);
        }
        return m;
    }

    public <E extends DynamicElement> Matrix initWithCentralPoint(DynamicLayer<E> layer, Instant t, String attName, double cellsize, double buffer) {
        return this.initWithCentralPoint(layer, layer.getType().getElementType(), t, attName, cellsize, buffer);
    }

    public <E extends DynamicElement> Matrix initWithCentralPoint(DynamicLayer<E> layer, DynamicElementType type, Instant t, String attName, double cellsize, double buffer) {
        Raster.setCellSize(cellsize);
        if (type.hasAttributeType(attName)) {
            int ncols = new Double(Math.floor((layer.maxX() - layer.minX() + 2.0 * buffer) / cellsize) + 1.0).intValue();
            int nrows = new Double(Math.floor((layer.maxY() - layer.minY() + 2.0 * buffer) / cellsize) + 1.0).intValue();
            Matrix mt = this.create(ncols, nrows, cellsize, layer.minX(), layer.maxX(), layer.minY(), layer.maxY(), Raster.getNoDataValue());
            PreparedPoint p = null;
            List l = null;
            DynamicElement ftemp = null;
            double vtemp = Raster.getNoDataValue();
            int modulo = 1;
            WKTReader r = new WKTReader();
            STRtree sIndex = new STRtree();
            for (DynamicElement f : layer) {
                sIndex.insert(f.getGeometry(t).get().getJTS().getEnvelopeInternal(), (Object)f);
            }
            sIndex.build();
            double yorigin = layer.maxY() - layer.minY() % cellsize == 0.0 ? layer.minY() + buffer + Math.floor((layer.maxY() - layer.minY()) / cellsize) * cellsize : layer.minY() + buffer + (Math.floor((layer.maxY() - layer.minY()) / cellsize) + 1.0) * cellsize;
            for (int j = 0; j < nrows; ++j) {
                double x = layer.minX() - buffer + cellsize / 2.0;
                double y = yorigin - cellsize / 2.0 - (double)j * cellsize;
                if (j % modulo == 0) {
                    Envelope env = new Envelope(new Coordinate(layer.minX(), y + 2.0 * cellsize), new Coordinate(layer.maxX(), y - 2.0 * cellsize));
                    l = sIndex.query(env);
                }
                for (int i = 0; i < ncols; ++i) {
                    x = layer.minX() - buffer + cellsize / 2.0 + (double)i * cellsize;
                    boolean ok = false;
                    try {
                        p = new PreparedPoint((Puntal)r.read("POINT (" + x + " " + y + ")"));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (ftemp != null && p.intersects(ftemp.getGeometry(t).get().getJTS())) {
                        mt.put(i, j, vtemp);
                        ok = true;
                    }
                    if (!ok) {
                        for (DynamicFeature f : l) {
                            if (!p.intersects(f.getGeometry(t).get().getJTS())) continue;
                            vtemp = new Double(f.getAttribute(attName).getValue(t).toString());
                            ftemp = f;
                            mt.put(i, j, vtemp);
                            ok = true;
                            break;
                        }
                    }
                    if (ok) continue;
                    mt.put(i, j, Raster.getNoDataValue());
                }
            }
            return mt;
        }
        throw new IllegalArgumentException("attribute '" + attName + "' does not exist");
    }

    public <E extends DynamicElement> Matrix initWithMajorSurface(DynamicLayer<E> layer, Instant t, String attName, double cellsize) {
        return this.initWithMajorSurface(layer, layer.getType().getElementType(), t, attName, cellsize);
    }

    public <E extends DynamicElement> Matrix initWithMajorSurface(DynamicLayer<E> layer, DynamicElementType type, Instant t, String attName, double cellsize) {
        Raster.setCellSize(cellsize);
        if (type.hasAttributeType(attName)) {
            int ncols = new Double(Math.floor((layer.maxX() - layer.minX()) / cellsize) + 1.0).intValue();
            int nrows = new Double(Math.floor((layer.maxY() - layer.minY()) / cellsize) + 1.0).intValue();
            Matrix mt = this.create(ncols, nrows, cellsize, layer.minX(), layer.maxX(), layer.minY(), layer.maxY(), Raster.getNoDataValue());
            PreparedPolygon p = null;
            Polygon poly = null;
            List l = null;
            DynamicElement ftemp = null;
            double vtemp = Raster.getNoDataValue();
            int modulo = 1;
            WKTReader r = new WKTReader();
            STRtree sIndex = new STRtree();
            for (DynamicElement f : layer) {
                sIndex.insert(f.getGeometry(t).get().getJTS().getEnvelopeInternal(), (Object)f);
            }
            sIndex.build();
            double yorigin = layer.maxY() - layer.minY() % cellsize == 0.0 ? layer.minY() + Math.floor((layer.maxY() - layer.minY()) / cellsize) * cellsize : layer.minY() + (Math.floor((layer.maxY() - layer.minY()) / cellsize) + 1.0) * cellsize;
            for (int j = 0; j < nrows; ++j) {
                double x = layer.minX() + cellsize / 2.0;
                double y = yorigin - cellsize / 2.0 - (double)j * cellsize;
                if (j % modulo == 0) {
                    Envelope env = new Envelope(new Coordinate(layer.minX(), y + 2.0 * cellsize), new Coordinate(layer.maxX(), y - 2.0 * cellsize));
                    l = sIndex.query(env);
                }
                for (int i = 0; i < ncols; ++i) {
                    x = layer.minX() + cellsize / 2.0 + (double)i * cellsize;
                    boolean ok = false;
                    boolean okMax = false;
                    try {
                        poly = (Polygon)r.read("POINT (" + x + " " + y + ")").buffer(cellsize / 2.0);
                        p = new PreparedPolygon((Polygonal)poly);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (ftemp != null && p.intersects(ftemp.getGeometry(t).get().getJTS()) && poly.intersection(ftemp.getGeometry(t).get().getJTS()).getArea() >= Math.PI * cellsize * cellsize / 2.0) {
                        mt.put(i, j, vtemp);
                        ok = true;
                    }
                    if (!ok) {
                        double max = 0.0;
                        for (DynamicFeature f : l) {
                            if (!p.intersects(f.getGeometry(t).get().getJTS())) continue;
                            double area = poly.intersection(f.getGeometry(t).get().getJTS()).getArea();
                            if (area >= Math.PI * cellsize * cellsize / 2.0) {
                                vtemp = new Double(f.getAttribute(attName).getValue(t).toString());
                                ftemp = f;
                                mt.put(i, j, vtemp);
                                ok = true;
                                break;
                            }
                            if (!(area > max)) continue;
                            max = area;
                            ftemp = f;
                            okMax = true;
                        }
                        if (okMax) {
                            vtemp = new Double(ftemp.getAttribute(attName).getValue(t).toString());
                            mt.put(i, j, vtemp);
                            ok = true;
                        }
                    }
                    if (ok) continue;
                    mt.put(i, j, Raster.getNoDataValue());
                }
            }
            return mt;
        }
        throw new IllegalArgumentException("attribute '" + attName + "' does not exist");
    }

    public <E extends DynamicElement> Matrix initLines(DynamicLayer<E> layer, Instant t, String attName, double cellsize, double defaultValue, double ... wantedValue) {
        return this.initLines(layer, layer.getType().getElementType(), t, attName, cellsize, defaultValue, wantedValue);
    }

    public <E extends DynamicElement> Matrix initLines(DynamicLayer<E> layer, DynamicElementType type, Instant t, String attName, double cellsize, double defaultValue, double ... wantedValue) {
        Raster.setCellSize(cellsize);
        if (type.hasAttributeType(attName)) {
            int ncols = new Double(Math.floor((layer.maxX() - layer.minX()) / cellsize) + 1.0).intValue();
            int nrows = new Double(Math.floor((layer.maxY() - layer.minY()) / cellsize) + 1.0).intValue();
            Matrix mt = this.create(ncols, nrows, cellsize, layer.minX(), layer.maxX(), layer.minY(), layer.maxY(), Raster.getNoDataValue());
            Point p = null;
            List l = null;
            int modulo = 2;
            WKTReader r = new WKTReader();
            STRtree sIndex = new STRtree();
            block2: for (DynamicElement f : layer) {
                for (double wv : wantedValue) {
                    if (new Double(f.getAttribute(attName).getValue(t).toString()) != wv) continue;
                    sIndex.insert(f.getGeometry(t).get().getJTS().getEnvelopeInternal(), (Object)f);
                    continue block2;
                }
            }
            sIndex.build();
            double yorigin = layer.maxY() - layer.minY() % cellsize == 0.0 ? layer.minY() + Math.floor((layer.maxY() - layer.minY()) / cellsize) * cellsize : layer.minY() + (Math.floor((layer.maxY() - layer.minY()) / cellsize) + 1.0) * cellsize;
            for (int j = 0; j < nrows; ++j) {
                double x = layer.minX() + cellsize / 2.0;
                double y = yorigin - cellsize / 2.0 - (double)j * cellsize;
                if (j % modulo == 0) {
                    Envelope env = new Envelope(new Coordinate(layer.minX(), y + 2.0 * cellsize), new Coordinate(layer.maxX(), y - 2.0 * cellsize));
                    l = sIndex.query(env);
                }
                for (int i = 0; i < ncols; ++i) {
                    x = layer.minX() + cellsize / 2.0 + (double)i * cellsize;
                    boolean ok = false;
                    try {
                        p = (Point)r.read("POINT (" + x + " " + y + ")");
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (!ok) {
                        int vi = -1;
                        int vIndex = 999999999;
                        boolean okMax = false;
                        for (DynamicFeature f : l) {
                            if (!(p.distance(f.getGeometry(t).get().getJTS()) < cellsize / 2.0)) continue;
                            double v = new Double(f.getAttribute(attName).getValue(t).toString());
                            for (int wi = 0; wi < wantedValue.length; ++wi) {
                                if (v != wantedValue[wi]) continue;
                                vi = wi;
                                break;
                            }
                            if (vi == 0) {
                                mt.put(i, j, v);
                                ok = true;
                                break;
                            }
                            vIndex = Math.min(vIndex, vi);
                            okMax = true;
                        }
                        if (okMax) {
                            mt.put(i, j, wantedValue[vIndex]);
                            ok = true;
                        }
                    }
                    if (ok) continue;
                    mt.put(i, j, defaultValue);
                }
            }
            return mt;
        }
        throw new IllegalArgumentException("attribute '" + attName + "' does not exist");
    }

    public <E extends DynamicElement> Matrix init2(DynamicLayer<E> layer, DynamicLayer<DynamicFeature> layer2, Instant t, String attName, double cellsize) {
        return this.init2(layer, layer2, layer.getType().getElementType(), t, attName, cellsize);
    }

    public <E extends DynamicElement> Matrix init2(DynamicLayer<E> layer, DynamicLayer<DynamicFeature> layer2, DynamicElementType type, Instant t, String attName, double cellsize) {
        Raster.setCellSize(cellsize);
        if (type.hasAttributeType(attName)) {
            int ncols = new Double((layer.maxX() - layer.minX()) / cellsize).intValue();
            int nrows = new Double((layer.maxY() - layer.minY()) / cellsize).intValue();
            Matrix mt = this.create(ncols, nrows, cellsize, layer.minX(), layer.maxX(), layer.minY(), layer.maxY(), -1);
            PreparedPoint p = null;
            List l = null;
            List l2 = null;
            DynamicElement ftemp = null;
            double vtemp = -1.0;
            int modulo = 1;
            WKTReader r = new WKTReader();
            STRtree sIndex = new STRtree();
            for (Object f : layer) {
                sIndex.insert(f.getGeometry(t).get().getJTS().getEnvelopeInternal(), f);
            }
            sIndex.build();
            STRtree sIndex2 = new STRtree();
            for (DynamicFeature f : layer2) {
                sIndex2.insert(f.getGeometry(t).get().getJTS().getEnvelopeInternal(), (Object)f);
            }
            sIndex2.build();
            for (int j = 0; j < nrows; ++j) {
                double x = layer.minX();
                double y = layer.maxY() - (double)j * cellsize;
                if (j % modulo == 0) {
                    Envelope env = new Envelope(new Coordinate(layer.minX(), y + 2.0 * cellsize), new Coordinate(layer.maxX(), y - 2.0 * cellsize));
                    l = sIndex.query(env);
                    l2 = sIndex2.query(env);
                }
                for (int i = 0; i < ncols; ++i) {
                    x = layer.minX() + (double)i * cellsize;
                    boolean ok = false;
                    try {
                        p = new PreparedPoint((Puntal)r.read("POINT (" + x + " " + y + ")"));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (ftemp != null && p.intersects(ftemp.getGeometry(t).get().getJTS())) {
                        mt.put(i, j, vtemp);
                        ok = true;
                    }
                    if (!ok) {
                        for (DynamicFeature f : l) {
                            if (!p.intersects(f.getGeometry(t).get().getJTS())) continue;
                            vtemp = new Double(f.getAttribute(attName).getValue(t).toString());
                            ftemp = f;
                            mt.put(i, j, vtemp);
                            ok = true;
                            break;
                        }
                    }
                    if (!ok) {
                        for (DynamicFeature f : l2) {
                            if (!p.intersects(f.getGeometry(t).get().getJTS())) continue;
                            mt.put(i, j, new Double(f.getAttribute(attName).getValue(t).toString()));
                            ok = true;
                            break;
                        }
                    }
                    if (ok) continue;
                    mt.put(i, j, -1.0);
                }
            }
            return mt;
        }
        throw new IllegalArgumentException("attribute '" + attName + "' does not exist");
    }
}

