/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.JaiMatrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;
import ij.ImagePlus;
import ij.io.FileSaver;
import ij.plugin.AscReader;
import ij.process.ImageProcessor;
import java.awt.RenderingHints;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataSourceException;
import org.geotools.gce.arcgrid.ArcGridReader;

public class JaiMatrixFactory
extends MatrixFactory {
    private static double minx;
    private static double maxx;
    private static double miny;
    private static double maxy;
    private static double cellsize;
    private static int width;
    private static int height;
    private static int noDataValue;
    private static JaiMatrixFactory factory;

    private JaiMatrixFactory() {
    }

    public static JaiMatrixFactory get() {
        return factory;
    }

    @Override
    public Matrix create(Matrix mRef) {
        return new JaiMatrix((JaiMatrix)mRef);
    }

    @Override
    public Matrix create(Matrix mRef, int divisor) {
        return new JaiMatrix((JaiMatrix)mRef, divisor);
    }

    @Override
    public Matrix create(int width, int height, double cellsize, double minX, double maxX, double minY, double maxY, int noData) {
        int[] bands = new int[]{0};
        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(5, width, height, 1, width, bands);
        TiledImage pi = new TiledImage(0, 0, width, height, 0, 0, (SampleModel)sm, null);
        return new JaiMatrix(cellsize, minX, maxX, minY, maxY, (PlanarImage)pi, false);
    }

    @Override
    public Matrix create(int width, int height, double cellsize, double minX, double maxX, double minY, double maxY, int noData, PlanarImage ref) {
        return new JaiMatrix(cellsize, minX, maxX, minY, maxY, (PlanarImage)new TiledImage(0, 0, width, height, 1, 1, ref.getSampleModel(), ref.getColorModel()));
    }

    public Matrix createWithTiff(String tiff, String entete, boolean read) throws NumberFormatException, IOException {
        this.initWithEntete(entete);
        RenderedOp pi = JAI.create((String)"fileload", (Object)tiff);
        JaiMatrix m = new JaiMatrix(cellsize, minx, maxx, miny, maxy, (PlanarImage)pi, read);
        m.setFile(tiff);
        return m;
    }

    public Matrix createWithAsciiGrid(String ascii) throws NumberFormatException, IOException {
        return this.createWithAsciiGrid(ascii, true);
    }

    public Matrix createWithAsciiGrid(String ascii, boolean read) throws NumberFormatException, IOException {
        AscReader tr;
        ImageProcessor ip;
        String tiff = JaiMatrixFactory.deleteExtension(ascii) + ".tif";
        if (!new File(tiff).exists() && (ip = (tr = new AscReader()).open(ascii)) != null) {
            String nom = JaiMatrixFactory.deleteExtension(JaiMatrixFactory.getNomCourt(ascii));
            ImagePlus imp = new ImagePlus(nom, ip);
            FileSaver saver = new FileSaver(imp);
            saver.saveAsTiff(tiff);
        }
        return this.createWithTiff(tiff, ascii, read);
    }

    private static String deleteExtension(String file) {
        String line = "";
        StringTokenizer st = new StringTokenizer(file, ".");
        String last = "";
        while (st.hasMoreTokens()) {
            last = last + line;
            line = st.nextToken();
        }
        return last;
    }

    private static String getNomCourt(String nom) {
        File f = new File(nom);
        return f.getName();
    }

    public Matrix createWithAsciiGridOld(String ascii, boolean read) throws NumberFormatException, IOException {
        this.initWithEntete(ascii);
        PlanarImage pi = (PlanarImage)this.readTiled(ascii, width, 1);
        JaiMatrix m = new JaiMatrix(cellsize, minx, maxx, miny, maxy, pi, read);
        m.setFile(ascii);
        return m;
    }

    public Matrix createWithAsciiGridTest(String asciiref, int width) throws NumberFormatException, IOException {
        this.initWithEntete(asciiref);
        PlanarImage pi = (PlanarImage)this.readTiled(asciiref, width, 1);
        System.out.println(pi.getHeight() + " " + pi.getWidth());
        JaiMatrix m = new JaiMatrix(cellsize, minx, maxx, miny, maxy, pi, true);
        return m;
    }

    private void initWithEntete(String ascii) throws NumberFormatException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(ascii));
            String line = br.readLine();
            String sep = String.valueOf(line.charAt(5));
            String[] s = line.split(sep);
            width = Integer.parseInt(s[s.length - 1]);
            s = br.readLine().split(sep);
            height = Integer.parseInt(s[s.length - 1]);
            s = br.readLine().split(sep);
            minx = Double.parseDouble(s[s.length - 1]);
            s = br.readLine().split(sep);
            miny = Double.parseDouble(s[s.length - 1]);
            s = br.readLine().split(sep);
            cellsize = Double.parseDouble(s[s.length - 1]);
            maxx = minx + (double)width * cellsize;
            maxy = miny + (double)height * cellsize;
            s = br.readLine().split(sep);
            if (!s[0].equalsIgnoreCase("NODATA_value")) {
                noDataValue = Raster.getNoDataValue();
                br.close();
                throw new NumberFormatException();
            }
            noDataValue = Integer.parseInt(s[s.length - 1]);
            Raster.setNoDataValue(noDataValue);
            br.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Set<Integer> findValues(String ascii) {
        HashSet<Integer> values = new HashSet<Integer>();
        try {
            CsvReader cr = new CsvReader(ascii);
            cr.setDelimiter(' ');
            cr.readRecord();
            cr.readRecord();
            cr.readRecord();
            cr.readRecord();
            cr.readRecord();
            cr.readRecord();
            while (cr.readRecord()) {
                for (int i = 0; i < width; ++i) {
                    if (cr.get(i).equalsIgnoreCase("")) continue;
                    try {
                        int v = Integer.parseInt(cr.get(i));
                        if (v == noDataValue) continue;
                        values.add(v);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        values.add(new Double(cr.get(i)).intValue());
                    }
                }
            }
            cr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    private void initWithTfw(String tfw) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(tfw));
            String line = br.readLine();
            System.out.println(line);
            StringTokenizer st = new StringTokenizer(line, " ");
            st.nextToken();
            cellsize = Double.parseDouble(st.nextToken());
            System.out.println(cellsize);
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RenderedImage readTiled(String file, int tileWidth, int tileHeight) throws IOException {
        try {
            ParameterBlockJAI pbj = new ParameterBlockJAI("imageread");
            pbj.setParameter("Input", (Object)ImageIO.createImageInputStream(new File(file)));
            ImageLayout layout = new ImageLayout();
            layout.setTileWidth(tileWidth);
            layout.setTileHeight(tileHeight);
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            return JAI.create((String)"imageread", (ParameterBlock)pbj, (RenderingHints)hints);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderedImage readAsciiFile(String ascii) {
        ArcGridReader agr = null;
        try {
            agr = new ArcGridReader((Object)new File(ascii));
            GridCoverage2D g = agr.read(null);
            RenderedImage renderedImage = g.getRenderedImage();
            return renderedImage;
        }
        catch (DataSourceException ex) {
            ex.printStackTrace();
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        finally {
            agr.dispose();
        }
    }

    static {
        noDataValue = -1;
        factory = new JaiMatrixFactory();
    }
}

