/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class EuclidianDistanceSinglePixelIterator
implements Iterator<Pixel> {
    private Pixel pixel;
    private double distance;
    private Set<Pixel> around;
    private Iterator<Pixel> ite;

    public EuclidianDistanceSinglePixelIterator(Pixel pixel, double distance) {
        this.pixel = pixel;
        this.distance = distance;
        this.init();
    }

    private void init() {
        double cellsize = Raster.getCellSize();
        double drayon = this.distance / cellsize;
        int rayon = (int)(this.distance / cellsize);
        this.around = new TreeSet<Pixel>();
        for (int y = this.pixel.y() - rayon; y <= this.pixel.y() + rayon; ++y) {
            for (int x = this.pixel.x() - rayon; x <= this.pixel.x() + rayon; ++x) {
                if (!(this.distance(this.pixel.x(), this.pixel.y(), x, y) <= drayon)) continue;
                this.around.add(new Pixel(x, y));
            }
        }
        this.ite = this.around.iterator();
    }

    private double distance(int x1, int y1, int x2, int y2) {
        return Math.sqrt(Math.pow(Math.abs(x1 - x2), 2.0) + Math.pow(Math.abs(y1 - y2), 2.0));
    }

    @Override
    public boolean hasNext() {
        return this.ite.hasNext();
    }

    @Override
    public Pixel next() {
        return this.ite.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

