/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space;

import fr.inra.sad.bagap.apiland.core.space.ComplexGeometry;
import fr.inra.sad.bagap.apiland.core.space.Geometry;
import fr.inra.sad.bagap.apiland.core.space.GeometryManager;
import fr.inra.sad.bagap.apiland.core.space.Linear;
import fr.inra.sad.bagap.apiland.core.space.MultiCurve;
import fr.inra.sad.bagap.apiland.core.space.Point;
import fr.inra.sad.bagap.apiland.core.space.Surface;
import fr.inra.sad.bagap.apiland.core.space.impl.GeometryImpl;

public class Curve
extends Geometry
implements Linear {
    private static final long serialVersionUID = 1L;

    protected Curve(GeometryImpl impl) {
        super(impl);
    }

    public String toString() {
        return "curve length = " + this.getLength();
    }

    @Override
    public Curve clone() {
        Curve clone = (Curve)super.clone();
        return clone;
    }

    @Override
    public Curve smooth() {
        if (this.get().isSmooth()) {
            return this;
        }
        return new Curve(this.get().smooth());
    }

    @Override
    public Geometry addGeometry(Geometry g) {
        return g.addCurve(this);
    }

    @Override
    public Geometry addPoint(Point g) {
        return new Curve(GeometryManager.add(this.get(), g.get()));
    }

    @Override
    public Geometry addCurve(Curve g) {
        if (this.intersects(g)) {
            if (this.contains(g)) {
                return this.clone();
            }
            if (this.within(g)) {
                return g.clone();
            }
            return new Curve(GeometryManager.add(this.get(), g.get()));
        }
        if (this.touches(g)) {
            return new Curve(GeometryManager.add(this.get(), g.get()));
        }
        MultiCurve mc = new MultiCurve();
        mc.add(g);
        mc.add(g);
        return mc.smooth();
    }

    @Override
    public Geometry addSurface(Surface g) {
        return g.addCurve(this);
    }

    @Override
    public <G extends Geometry> Geometry addComplexGeometry(ComplexGeometry<G> g) {
        return g.addCurve(this);
    }
}

