/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.element.type;

import fr.inra.sad.bagap.apiland.core.composition.AttributeType;
import fr.inra.sad.bagap.apiland.core.element.DefaultDynamicLayer;
import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementType;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicFeatureType;
import fr.inra.sad.bagap.apiland.core.structure.RepresentationType;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DynamicLayerType
extends DynamicElementType
implements Iterable<DynamicElementType> {
    private static final long serialVersionUID = 1L;
    private Set<DynamicElementType> elementTypes = new HashSet<DynamicElementType>();

    public DynamicLayerType() {
        super("lid", DefaultDynamicLayer.class);
    }

    public DynamicLayerType(Class<? extends DynamicLayer> binding) {
        super("lid", binding);
    }

    public DynamicLayerType(String name) {
        super(name, DefaultDynamicLayer.class);
    }

    public DynamicLayerType(String name, Class<? extends DynamicLayer> binding) {
        super(name, binding);
    }

    public DynamicLayerType(String name, List<AttributeType> attributeTypes, List<RepresentationType> representationTypes) {
        super(name, attributeTypes, representationTypes);
    }

    public DynamicLayerType(String idName, Class<? extends DynamicElement> binding, List<AttributeType> attributeTypes, List<RepresentationType> representationTypes) {
        super(idName, binding, attributeTypes, representationTypes);
    }

    @Override
    public void display() {
        System.out.println(this);
        for (DynamicElementType type : this.elementTypes) {
            type.display();
        }
    }

    public void addElementType(DynamicElementType elementType) {
        this.elementTypes.add(elementType);
        elementType.setLayerType(this);
    }

    public DynamicElementType getElementType() {
        return this.elementTypes.iterator().next();
    }

    @Override
    public DynamicElementType getDeepElementType() {
        return this.elementTypes.iterator().next().getDeepElementType();
    }

    public Set<DynamicElementType> getElementTypes() {
        return this.elementTypes;
    }

    @Override
    public boolean hasElementType(Class<? extends DynamicElement> binding) {
        if (this.isElementType(binding)) {
            return true;
        }
        for (DynamicElementType t : this.elementTypes) {
            if (!t.hasElementType(binding)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DynamicElementType getElementType(Class<? extends DynamicElement> binding) {
        if (this.isElementType(binding)) {
            return this;
        }
        for (DynamicElementType t : this.elementTypes) {
            if (!t.hasElementType(binding)) continue;
            return t.getElementType(binding);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public List<DynamicFeatureType> getFeatureTypes() {
        ArrayList<DynamicFeatureType> types = new ArrayList<DynamicFeatureType>();
        for (DynamicElementType type : this.elementTypes) {
            types.addAll(type.getFeatureTypes());
        }
        return types;
    }

    @Override
    public Iterator<DynamicElementType> iterator() {
        return this.elementTypes.iterator();
    }

    @Override
    public boolean containsIdName(String name) {
        if (this.idName.equalsIgnoreCase(name)) {
            return true;
        }
        for (DynamicElementType type : this.elementTypes) {
            if (!type.containsIdName(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAttributeByName(String name) {
        if (this.hasAttributeType(name)) {
            return true;
        }
        for (DynamicElementType type : this.elementTypes) {
            if (!type.containsAttributeByName(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getLevelBottomUp() {
        int level = 0;
        for (DynamicElementType type : this.elementTypes) {
            level = Math.max(level, type.getLevelBottomUp());
        }
        return level + 1;
    }

    @Override
    public Instant getLastChange() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepresentationType getRepresentationType(String name) {
        if (this.hasRepresentationType(name)) {
            return super.getRepresentationType(name);
        }
        for (DynamicElementType type : this.elementTypes) {
            RepresentationType rt = type.getRepresentationType(name);
            if (rt == null) continue;
            return rt;
        }
        return null;
    }

    @Override
    public AttributeType getAttributeType(String name) {
        if (this.hasAttributeType(name)) {
            return super.getAttributeType(name);
        }
        for (DynamicElementType type : this.elementTypes) {
            AttributeType at = type.getAttributeType(name);
            if (at == null) continue;
            return at;
        }
        return null;
    }

    @Override
    public boolean hasDeepCondition(Object o) {
        if (!this.hasCondition(o)) {
            for (DynamicElementType type : this.elementTypes) {
                if (!type.hasDeepCondition(o)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean containsAttributeType(String name) {
        if (this.hasAttributeType(name)) {
            return true;
        }
        for (DynamicElementType type : this.elementTypes) {
            if (!type.hasAttributeType(name)) continue;
            return true;
        }
        return false;
    }
}

