/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.element.type;

import fr.inra.sad.bagap.apiland.core.composition.AttributeType;
import fr.inra.sad.bagap.apiland.core.composition.AttributeTypeBuilder;
import fr.inra.sad.bagap.apiland.core.element.DefaultDynamicFeature;
import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementType;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementTypeFactory;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicFeatureType;
import fr.inra.sad.bagap.apiland.core.space.Geometry;
import fr.inra.sad.bagap.apiland.core.space.impl.GeometryImplType;
import fr.inra.sad.bagap.apiland.core.structure.RepresentationType;
import fr.inra.sad.bagap.apiland.core.structure.RepresentationTypeBuilder;
import fr.inra.sad.bagap.apiland.core.time.Time;
import java.util.ArrayList;
import java.util.List;

public class DynamicElementTypeBuilder {
    private Class<? extends DynamicElementType> binding;
    private Class<? extends DynamicElement> elementBinding;
    private String idName;
    private AttributeTypeBuilder attributeBuilder;
    private RepresentationTypeBuilder representationBuilder;
    private List<AttributeType> attributeTypes;
    private List<RepresentationType> representationTypes;

    public DynamicElementTypeBuilder(Class<? extends DynamicElementType> binding, Class<? extends DynamicElement> elementBinding) {
        this.binding = binding;
        this.elementBinding = elementBinding;
        this.attributeBuilder = new AttributeTypeBuilder();
        this.representationBuilder = new RepresentationTypeBuilder();
        this.reset();
    }

    public DynamicElementTypeBuilder(Class<? extends DynamicElement> elementBinding) {
        this(DynamicElementType.class, elementBinding);
    }

    public DynamicElementTypeBuilder() {
        this(DynamicFeatureType.class, DefaultDynamicFeature.class);
    }

    public void reset() {
        this.attributeTypes = new ArrayList<AttributeType>();
        this.representationTypes = new ArrayList<RepresentationType>();
    }

    public void setIdName(String idName) {
        this.idName = idName;
    }

    public void addAttributeType(String name, Class<? extends Time> temporal, Class<?> binding) {
        this.attributeBuilder.setName(name);
        this.attributeBuilder.setTemporal(temporal);
        this.attributeBuilder.setBinding(binding);
        this.attributeTypes.add(this.attributeBuilder.build());
    }

    public void addAttributeType(AttributeType attributeType) {
        this.attributeTypes.add(attributeType);
    }

    public void addRepresentationType(String name, Class<? extends Time> temporal, Class<? extends Geometry> spatial, GeometryImplType geometryType) {
        this.representationBuilder.setName(name);
        this.representationBuilder.setTemporal(temporal);
        this.representationBuilder.setSpatial(spatial);
        this.representationBuilder.setGeometryType(geometryType);
        this.representationTypes.add(this.representationBuilder.build());
    }

    public void addRepresentationType(RepresentationType representationType) {
        this.representationTypes.add(representationType);
    }

    public DynamicElementType build() {
        DynamicElementType type = DynamicElementTypeFactory.createDynamicElementType(this.idName, this.attributeTypes, this.representationTypes, this.binding, this.elementBinding);
        this.reset();
        return type;
    }
}

