/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.element.manager;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.ShapefileWriter;

public class Tool {
    public static void main(String[] args) {
        String path = "C:/Hugues/enseignements/AAE/data/Ba/sig/";
        String input = path + "Parcellaire5";
        String output = path + "Parcellaire8";
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.add(8);
        ids.add(37);
        ids.add(38);
        ids.add(39);
        ids.add(42);
        Tool.retrieveUnits(input, output, ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatShapeFile(String input, String output) {
        try (FileOutputStream fos = new FileOutputStream(output + ".dbf");
             FileOutputStream shp = new FileOutputStream(output + ".shp");
             FileOutputStream shx = new FileOutputStream(output + ".shx");){
            ShpFiles sf = new ShpFiles(input + ".shp");
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            dfr.getHeader();
            DbaseFileHeader header = new DbaseFileHeader();
            header.setNumRecords(dfr.getHeader().getNumRecords());
            for (int i = 0; i < dfr.getHeader().getNumFields(); ++i) {
                header.addColumn(dfr.getHeader().getFieldName(i), dfr.getHeader().getFieldType(i), dfr.getHeader().getFieldLength(i), dfr.getHeader().getFieldDecimalCount(i));
            }
            int nb = 0;
            boolean nid = false;
            if (!Tool.hasFieldName(header, "id")) {
                nid = true;
                header.addColumn("id", 'c', 8, 0);
                ++nb;
            }
            boolean nfarm = false;
            if (!Tool.hasFieldName(header, "farm")) {
                nfarm = true;
                header.addColumn("farm", 'c', 8, 0);
                ++nb;
            }
            boolean narea = false;
            if (!Tool.hasFieldName(header, "area")) {
                narea = true;
                header.addColumn("area", 'c', 2, 0);
                ++nb;
            }
            boolean ntype = false;
            if (!Tool.hasFieldName(header, "type")) {
                ntype = true;
                header.addColumn("type", 'c', 8, 0);
                ++nb;
            }
            boolean nfacility = false;
            if (!Tool.hasFieldName(header, "facility")) {
                nfacility = true;
                header.addColumn("facility", 'c', 20, 0);
                ++nb;
            }
            DbaseFileWriter dfw = new DbaseFileWriter(header, (WritableByteChannel)fos.getChannel());
            ShapefileWriter sfw = new ShapefileWriter(shp.getChannel(), shx.getChannel());
            sfw.writeHeaders(new Envelope(sfr.getHeader().minX(), sfr.getHeader().maxX(), sfr.getHeader().minY(), sfr.getHeader().maxY()), ShapeType.POLYGON, dfr.getHeader().getNumRecords() - 1, sfr.getHeader().getFileLength());
            int id = 0;
            while (sfr.hasNext()) {
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                Object[] entry = dfr.readEntry();
                Object[] nentry = new Object[entry.length + nb];
                int i = 0;
                for (Object e : entry) {
                    nentry[i] = entry[i];
                    ++i;
                }
                if (nid) {
                    nentry[i++] = id++;
                }
                if (nfarm) {
                    nentry[i++] = "f0";
                }
                if (narea) {
                    nentry[i++] = "AA";
                }
                if (ntype) {
                    nentry[i++] = "parcel";
                }
                if (nfacility) {
                    nentry[i++] = "";
                }
                dfw.write(nentry);
                sfw.writeGeometry(the_geom);
            }
            sfr.close();
            dfr.close();
            dfw.close();
            sfw.close();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Tool.copy(input + ".prj", output + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean hasFieldName(DbaseFileHeader header, String name) {
        for (int i = 0; i < header.getNumFields(); ++i) {
            if (!header.getFieldName(i).equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void retrieveUnits(String input, String output, List<Integer> ids) {
        try (FileOutputStream fos = new FileOutputStream(output + ".dbf");
             FileOutputStream shp = new FileOutputStream(output + ".shp");
             FileOutputStream shx = new FileOutputStream(output + ".shx");){
            ShpFiles sf = new ShpFiles(input + ".shp");
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            dfr.getHeader();
            DbaseFileHeader header = new DbaseFileHeader();
            header.setNumRecords(dfr.getHeader().getNumRecords() - ids.size());
            for (int i = 0; i < dfr.getHeader().getNumFields(); ++i) {
                header.addColumn(dfr.getHeader().getFieldName(i), dfr.getHeader().getFieldType(i), dfr.getHeader().getFieldLength(i), dfr.getHeader().getFieldDecimalCount(i));
            }
            DbaseFileWriter dfw = new DbaseFileWriter(header, (WritableByteChannel)fos.getChannel());
            ShapefileWriter sfw = new ShapefileWriter(shp.getChannel(), shx.getChannel());
            sfw.writeHeaders(new Envelope(sfr.getHeader().minX(), sfr.getHeader().maxX(), sfr.getHeader().minY(), sfr.getHeader().maxY()), ShapeType.POLYGON, dfr.getHeader().getNumRecords() - ids.size(), sfr.getHeader().getFileLength());
            while (sfr.hasNext()) {
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                Object[] entry = dfr.readEntry();
                int nid = (Integer)entry[0];
                if (ids.contains(nid)) continue;
                dfw.write(entry);
                sfw.writeGeometry(the_geom);
            }
            sfr.close();
            dfr.close();
            dfw.close();
            sfw.close();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Tool.copy(input + ".prj", output + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copy(String sourceFile, String destFile) throws IOException {
        try (FileInputStream input = new FileInputStream(sourceFile);
             FileOutputStream output = new FileOutputStream(destFile);){
            int len;
            byte[] buf = new byte[8192];
            while ((len = ((InputStream)input).read(buf)) >= 0) {
                ((OutputStream)output).write(buf, 0, len);
            }
        }
    }

    public static void copy(InputStream sourceFile, String destFile) throws IOException {
        try (InputStream input = sourceFile;
             FileOutputStream output = new FileOutputStream(destFile);){
            int len;
            byte[] buf = new byte[8192];
            while ((len = input.read(buf)) >= 0) {
                ((OutputStream)output).write(buf, 0, len);
            }
        }
    }
}

