/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.element;

import fr.inra.sad.bagap.apiland.core.element.AbstractDynamicElement;
import fr.inra.sad.bagap.apiland.core.element.DynamicFeature;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicFeatureType;
import fr.inra.sad.bagap.apiland.core.space.Geometry;
import fr.inra.sad.bagap.apiland.core.space.Point;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Time;
import fr.inra.sad.bagap.apiland.core.time.TimeException;
import fr.inra.sad.bagap.apiland.core.time.TimeNulle;

public class DefaultDynamicFeature
extends AbstractDynamicElement
implements DynamicFeature {
    private static final long serialVersionUID = 1L;
    private Time time;

    public DefaultDynamicFeature(DynamicFeatureType type) {
        super(type);
    }

    @Override
    public DynamicFeatureType getType() {
        return (DynamicFeatureType)super.getType();
    }

    @Override
    public DefaultDynamicFeature clone() {
        DefaultDynamicFeature clone = (DefaultDynamicFeature)super.clone();
        return clone;
    }

    @Override
    public Time getTime() {
        return this.time;
    }

    @Override
    public void setTime(Time t) {
        this.time = t;
    }

    @Override
    public void kill(Instant t) throws TimeException {
        this.time = Time.kill(this.time, t);
        super.kill(t);
    }

    @Override
    public int count(Instant t) {
        if (this.isActive(t)) {
            return 1;
        }
        return 0;
    }

    @Override
    public void display() {
        System.out.println("default dynamic feature : " + this.getId());
    }

    @Override
    public double getArea(Instant t) {
        return this.getStructure().getDefaultRepresentation().getArea(t);
    }

    @Override
    public Geometry getGeometry(Instant t) {
        return this.getStructure().getDefaultRepresentation().getGeometry(t);
    }

    @Override
    public double getLength(Instant t) {
        return this.getStructure().getDefaultRepresentation().getLength(t);
    }

    @Override
    public boolean isActive(Instant t, Point g) {
        return this.getStructure().getDefaultRepresentation().isActive(t);
    }

    @Override
    public boolean isActive(Instant t) {
        return this.time.isActive(t);
    }

    @Override
    public Instant getLastChange() {
        Instant t = super.getLastChange();
        Instant n = this.getStructure().getLastChange();
        if (t == null || t instanceof TimeNulle || n != null && n.isAfter(t)) {
            t = n;
        }
        return t;
    }

    @Override
    public void delete() {
        super.delete();
        this.time = null;
    }
}

