/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul.landscape;

import fr.inra.sad.bagap.apiland.capfarm.model.Farm;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.EconomicCoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.OptimizeEconomicCoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.AgriculturalArea;
import fr.inra.sad.bagap.apiland.capfarm.simul.CSPCoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmSimulator;
import fr.inra.sad.bagap.apiland.capfarm.simul.CoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.simul.GlobalCoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.MemoryCoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.landscape.CfmLandscapeManager;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;

public class CfmLandscapeSimulator
extends CfmSimulator {
    private static final long serialVersionUID = 1L;

    public CfmLandscapeSimulator(CfmLandscapeManager manager) {
        super(manager);
    }

    @Override
    public CfmLandscapeManager manager() {
        return (CfmLandscapeManager)super.manager();
    }

    @Override
    protected void initFarms() {
        GlobalCoverLocationModel agriculture = new GlobalCoverLocationModel("agriculture", this);
        agriculture.setTerritory((AgriculturalArea)((DynamicLayer)this.map().get("territory")).get("AA"));
        block9: for (Farm f : this.manager().farms()) {
            switch (this.manager().processMode()) {
                case ACTIVATE: {
                    CoverAllocationProblemFactory factory = null;
                    switch (this.manager().mode()) {
                        case IDLE: {
                            factory = new CoverAllocationProblemFactory();
                            break;
                        }
                        case ECONOMIC: {
                            factory = new EconomicCoverAllocationProblemFactory(this.manager().economicProfil(), this.manager().managmentProfil());
                            break;
                        }
                        case OPTIMIZE: {
                            factory = new OptimizeEconomicCoverAllocationProblemFactory(this.manager().economicProfil());
                        }
                    }
                    agriculture.add(new CSPCoverLocationModel(this, f, factory));
                    continue block9;
                }
                case MEMORY: {
                    f.setMemory(true);
                    agriculture.add(new MemoryCoverLocationModel((CfmSimulator)this, f));
                    continue block9;
                }
            }
            throw new IllegalArgumentException((Object)((Object)this.manager().processMode()) + " not implemented yet");
        }
        this.model().add(agriculture);
    }
}

