/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.economic.csp;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.EconomicProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.SMF;
import org.chocosolver.solver.search.strategy.ISF;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.IntStrategy;
import org.chocosolver.solver.search.strategy.strategy.StrategiesSequencer;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.util.tools.ArrayUtils;

public class OptimizeEconomicCoverAllocationProblem
extends CoverAllocationProblem {
    private EconomicProfil ep;
    private IntVar profit;
    private IntVar unprofit;
    private IntVar[] coverAreas;
    private IntVar[] coverCounts;

    public OptimizeEconomicCoverAllocationProblem(CoverAllocator allocator, Instant t, EconomicProfil ep) {
        super(allocator, t);
        this.ep = ep;
    }

    public EconomicProfil getEconomicProfil() {
        return this.ep;
    }

    public IntVar[] coverAreas() {
        return this.coverAreas;
    }

    @Override
    protected void buildVariables() {
        super.buildVariables();
        this.profit = VF.bounded((String)"profit", (int)0, (int)2000000000, (Solver)this.solver);
        this.unprofit = VF.bounded((String)"unprofit", (int)-2000000000, (int)0, (Solver)this.solver);
        this.coverAreas = new IntVar[this.covers().size()];
        this.coverCounts = new IntVar[this.covers().size()];
    }

    @Override
    protected void structureInitialisation() {
        super.structureInitialisation();
        int totarea = this.allocator().totalParcelsArea();
        int[] areas = new int[this.allocator().parcels().size()];
        int[] counts = new int[this.allocator().parcels().size()];
        for (int i = 0; i < areas.length; ++i) {
            areas[i] = 0;
            counts[i] = 1;
        }
        for (Parcel p : this.parcels().keySet()) {
            areas[this.parcels().get((Object)p).intValue()] = p.getArea() / 100;
        }
        for (CoverUnit c : this.covers().keySet()) {
            int ic = this.covers().get(c);
            this.coverAreas[ic] = VF.bounded((String)("a_cvs_" + ic), (int)0, (int)totarea, (Solver)this.solver());
            this.solver().post(ICF.scalar((IntVar[])this.coversAndParcels(ic), (int[])areas, (IntVar)this.coverAreas[ic]));
            this.coverCounts[ic] = VF.bounded((String)("c_cvs_" + ic), (int)0, (int)100, (Solver)this.solver());
            this.solver().post(ICF.scalar((IntVar[])this.coversAndParcels(ic), (int[])counts, (IntVar)this.coverCounts[ic]));
        }
        this.solver().post(ICF.arithm((IntVar)this.profit, (String)"+", (IntVar)this.unprofit, (String)"=", (int)0));
        this.solver().post(ICF.scalar((IntVar[])this.coverAreas, (int[])this.ep.profits(), (IntVar)this.profit));
    }

    @Override
    protected void configureSearch() {
        long r = new Double(Math.random() * 1.0E9).longValue();
        IntStrategy as1 = ISF.random((IntVar[])((IntVar[])ArrayUtils.append((Object[][])this.coversAndParcels)), (long)r);
        IntStrategy as2 = ISF.random((IntVar[])this.parcelsImplantedCoverContinue, (long)r);
        this.solver.set(new AbstractStrategy[]{ISF.lastConflict((Solver)this.solver, (AbstractStrategy)new StrategiesSequencer(new AbstractStrategy[]{as1, as2}))});
        SMF.limitTime((Solver)this.solver, (long)100L);
    }

    @Override
    protected boolean solve() {
        this.solver.findOptimalSolution(ResolutionPolicy.MINIMIZE, this.profit);
        if (this.solver.findSolution()) {
            try {
                this.solver.restoreLastSolution();
                System.out.println("profit = " + this.profit.getValue());
                this.allocator().getTerritory().getAttribute("profit").setValue(this.time(), Integer.valueOf(this.profit.getValue()));
                block2: for (Parcel p : this.parcels().keySet()) {
                    int ip = this.parcels().get(p);
                    if (this.parcelsImplantedCoverContinue[ip].getValue() != 0) continue;
                    for (Cover cover : this.covers().keySet()) {
                        int ic = this.covers().get(cover);
                        if (this.coversAndParcels(ic, ip).getValue() != 1) continue;
                        p.getAttribute("cover").setValue(this.time(), cover);
                        continue block2;
                    }
                }
                return true;
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

