/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.economic.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.EconomicProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.csp.EconomicCoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import fr.inra.sad.bagap.apiland.core.time.delay.YearDelay;
import java.util.Set;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;

public class ProfitConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;
    private EconomicProfil ep;

    public ProfitConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels, Domain<Integer, Integer> domain) {
        super(code, checkOnly, ConstraintType.Profit, mode, covers, parcels, domain);
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        EconomicCoverAllocationProblem ecap = (EconomicCoverAllocationProblem)cap;
        this.ep = ecap.getEconomicProfil();
        IntVar profit = VF.bounded((String)"profit", (int)0, (int)200000000, (Solver)ecap.solver());
        ecap.solver().post(ICF.scalar((IntVar[])ecap.coverAreas(), (int[])this.ep.profits(), (IntVar)profit));
        switch (this.mode()) {
            case ONLY: {
                this.post(ecap, this.domain(), profit);
                break;
            }
            case NEVER: {
                this.post(ecap, this.domain().inverse(), profit);
                break;
            }
            default: {
                throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
            }
        }
    }

    private void post(CoverAllocationProblem cap, Domain<Integer, Integer> domain, IntVar profit) {
        cap.solver().post(domain.postIntVar(profit));
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        double supermin = Double.MAX_VALUE;
        double supermax = Double.MIN_VALUE;
        YearDelay d = new YearDelay(1);
        Instant t = start;
        while (t.isBefore(end) || t.equals(end)) {
            double profit = 0.0;
            for (Parcel p : this.location()) {
                CoverUnit c = (CoverUnit)p.getAttribute("cover").getValue(t);
                if (!this.covers().contains(c)) continue;
                profit += (double)this.ep.profit(c, p.getArea());
            }
            supermin = Math.min(supermin, profit);
            supermax = Math.max(supermax, profit);
            switch (this.mode()) {
                case ONLY: {
                    if (this.domain().accept(new Double(profit * 100.0).intValue())) break;
                    ok = false;
                    if (verbose) {
                        sb.append("BAD : profit  = " + profit + " not in domain " + this.domain() + "\n");
                        break;
                    }
                    return ok;
                }
                case NEVER: {
                    if (!this.domain().accept(new Double(profit * 100.0).intValue())) break;
                    ok = false;
                    if (verbose) {
                        sb.append("BAD : profit = " + profit + " not in domain " + this.domain() + "\n");
                        break;
                    }
                    return ok;
                }
                default: {
                    throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
                }
            }
            t = ((Delay)d).next(t);
        }
        if (verbose) {
            if (ok) {
                if (supermin == supermax) {
                    sb.append("GOOD : cover " + this.covers().toString() + " has profit = " + new Double(supermin).intValue() + " euros");
                } else {
                    sb.append("GOOD : cover " + this.covers().toString() + " has profit between min = " + new Double(supermin).intValue() + " and max = " + new Double(supermax).intValue());
                }
            }
            System.out.println(sb.toString());
        }
        return ok;
    }
}

