/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import fr.inra.sad.bagap.apiland.core.time.delay.YearDelay;
import java.util.Set;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;

public class TotalAreaConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;

    public TotalAreaConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> location, Domain<Integer, Integer> domain) {
        super(code, checkOnly, ConstraintType.TotalArea, mode, covers, location, domain);
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        int totarea = cap.allocator().totalParcelsArea();
        int[] areas = new int[cap.allocator().parcels().size()];
        for (int i = 0; i < areas.length; ++i) {
            areas[i] = 0;
        }
        for (Parcel p : this.location()) {
            areas[cap.parcels().get((Object)p).intValue()] = p.getArea();
        }
        IntVar coverArea = null;
        if (this.hasSingleCover()) {
            CoverUnit c = this.getSingleCover();
            int ic = cap.covers().get(c);
            coverArea = VF.bounded((String)("a_cv_" + this.code()), (int)0, (int)totarea, (Solver)cap.solver());
            cap.solver().post(ICF.scalar((IntVar[])cap.coversAndParcels(ic), (int[])areas, (IntVar)coverArea));
        } else {
            coverArea = VF.bounded((String)("a_cv_" + this.code()), (int)0, (int)totarea, (Solver)cap.solver());
            IntVar[] coverAreas = new IntVar[this.covers().size()];
            int index = 0;
            for (CoverUnit c : this.covers()) {
                coverAreas[index] = VF.bounded((String)("a_cv_" + this.code() + "_cv_" + cap.covers().get(c)), (int)0, (int)totarea, (Solver)cap.solver());
                if (cap.covers().containsKey(c)) {
                    cap.solver().post(ICF.scalar((IntVar[])cap.coversAndParcels(cap.covers().get(c)), (int[])areas, (IntVar)coverAreas[index]));
                }
                ++index;
            }
            cap.solver().post(ICF.sum((IntVar[])coverAreas, (IntVar)coverArea));
        }
        switch (this.mode()) {
            case ONLY: {
                this.post(cap, this.domain(), coverArea);
                break;
            }
            case NEVER: {
                this.post(cap, this.domain().inverse(), coverArea);
                break;
            }
            default: {
                throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
            }
        }
    }

    private void post(CoverAllocationProblem cap, Domain<Integer, Integer> domain, IntVar coverArea) {
        cap.solver().post(domain.postIntVar(coverArea));
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        YearDelay d = new YearDelay(1);
        int supermin = Integer.MAX_VALUE;
        int supermax = Integer.MIN_VALUE;
        Instant t = start;
        while (t.isBefore(end) || t.equals(end)) {
            int area = 0;
            for (Parcel p : this.location()) {
                if (!this.covers().contains(p.getAttribute("cover").getValue(t))) continue;
                area += p.getArea();
            }
            supermin = Math.min(supermin, area);
            supermax = Math.max(supermax, area);
            switch (this.mode()) {
                case ONLY: {
                    if (this.domain().accept(area)) break;
                    ok = false;
                    if (verbose) {
                        sb.append("BAD  - Total Area : area = " + area + " not in domain " + this.domain() + "\n");
                        break;
                    }
                    return ok;
                }
                case NEVER: {
                    if (!this.domain().accept(area)) break;
                    ok = false;
                    if (verbose) {
                        sb.append("BAD  - Total Area : area = " + area + " not in domain " + this.domain() + "\n");
                        break;
                    }
                    return ok;
                }
                default: {
                    throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
                }
            }
            t = ((Delay)d).next(t);
        }
        if (verbose) {
            if (ok) {
                if (supermin == supermax) {
                    sb.append("GOOD - cover " + this.covers().toString() + " has total area = " + (double)supermin / 10000.0);
                } else {
                    sb.append("GOOD - cover " + this.covers().toString() + " has total area between min = " + (double)supermin / 10000.0 + " and max = " + (double)supermax / 10000.0);
                }
            }
            System.out.println(sb.toString());
        }
        return ok;
    }
}

