/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import java.util.HashSet;
import java.util.Set;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.LCF;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.solver.variables.VariableFactory;

public class SpatialPatternConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;

    public SpatialPatternConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels, Domain<Integer, Integer> domain) {
        super(code, checkOnly, ConstraintType.SpatialPattern, mode, covers, parcels, domain);
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        Cover c2;
        int totlength = cap.allocator().totalEdgesLength();
        int[] edges = cap.allocator().edgesLength();
        Cover c1 = null;
        int ic1 = -1;
        int ic2 = -1;
        for (Cover cover : this.covers()) {
            if (c1 == null) {
                c1 = cover;
                ic1 = cap.covers().get(c1);
                continue;
            }
            c2 = cover;
            ic2 = cap.covers().get(c2);
        }
        if (ic2 == -1) {
            c2 = c1;
            ic2 = ic1;
        }
        BoolVar[] vars = new BoolVar[edges.length];
        HashSet<Parcel> hashSet = new HashSet<Parcel>();
        int i = 0;
        for (Parcel p1 : cap.allocator().parcels()) {
            hashSet.add(p1);
            int ip1 = cap.parcels().get(p1);
            for (Parcel p2 : cap.allocator().parcels()) {
                if (hashSet.contains(p2)) continue;
                if (this.location().contains(p1) && this.location().contains(p2)) {
                    int ip2 = cap.parcels().get(p2);
                    vars[i] = VF.bool((String)("c_" + ic1 + "_c_" + ic2 + "_p_" + ip1 + "_p_" + ip2), (Solver)cap.solver());
                    LCF.ifThenElse((Constraint)LCF.or((Constraint[])new Constraint[]{LCF.and((BoolVar[])new BoolVar[]{cap.coversAndParcels(ic1, ip1), cap.coversAndParcels(ic2, ip2)}), LCF.and((BoolVar[])new BoolVar[]{cap.coversAndParcels(ic1, ip2), cap.coversAndParcels(ic2, ip1)})}), (Constraint)ICF.arithm((IntVar)vars[i], (String)"=", (int)1), (Constraint)ICF.arithm((IntVar)vars[i], (String)"=", (int)0));
                } else {
                    vars[i] = VF.zero((Solver)cap.solver());
                }
                ++i;
            }
        }
        IntVar edgeLength = VariableFactory.bounded((String)("e_c_" + ic1 + "_c_" + ic1), (int)0, (int)totlength, (Solver)cap.solver());
        cap.solver().post(ICF.scalar((IntVar[])vars, (int[])edges, (IntVar)edgeLength));
        switch (this.mode()) {
            case ONLY: {
                this.post(cap, this.domain(), edgeLength);
                break;
            }
            case NEVER: {
                this.post(cap, this.domain().inverse(), edgeLength);
                break;
            }
            default: {
                throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
            }
        }
    }

    private void post(CoverAllocationProblem cap, Domain<Integer, Integer> domain, IntVar edgeLength) {
        cap.solver().post(domain.postSpatialPattern(edgeLength));
    }
}

