/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.csp.ProbaTimeManager;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.composition.DynamicAttribute;
import fr.inra.sad.bagap.apiland.core.composition.TemporalValue;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Set;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.LCF;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public class RepetitionConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;
    private String durationMode;
    private boolean hasMax;

    public RepetitionConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels, Domain<Integer, Integer> domain, String durationMode, boolean hasMax) {
        super(code, checkOnly, ConstraintType.Repetition, mode, covers, parcels, domain);
        this.durationMode = durationMode;
        this.hasMax = hasMax;
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        int min = (Integer)this.domain().minimum();
        int max = (Integer)this.domain().maximum();
        block4: for (Parcel p : this.location()) {
            int ip = cap.parcels().get(p);
            if (cap.previous(ip) == null || !this.covers().contains(cap.previous(ip).getValue())) continue;
            int count = this.countLastOccurencesOfCoverUnits((DynamicAttribute)p.getAttribute("cover"), this.covers()) - 1;
            switch (this.mode()) {
                case ONLY: {
                    int nbyear;
                    int duration;
                    int ic;
                    int i;
                    if (count < min) {
                        if (this.hasSingleCover()) {
                            int ic2 = cap.covers().get(this.getSingleCover());
                            cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic2, ip), (String)"=", (int)1));
                            break;
                        }
                        Constraint[] cons = new Constraint[this.covers().size()];
                        i = 0;
                        for (CoverUnit cu : this.covers()) {
                            ic = cap.covers().get(cu);
                            cons[i++] = ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1);
                        }
                        cap.solver().post(LCF.or((Constraint[])cons));
                        break;
                    }
                    if (!this.hasMax) continue block4;
                    if (count >= max) {
                        if (this.hasSingleCover()) {
                            int ic3 = cap.covers().get(this.getSingleCover());
                            LCF.ifThen((BoolVar)cap.parcelsImplantedCoverContinue(ip).not(), (Constraint)ICF.arithm((IntVar)cap.coversAndParcels(ic3, ip), (String)"=", (int)0));
                            break;
                        }
                        Constraint[] cons = new Constraint[this.covers().size()];
                        i = 0;
                        for (CoverUnit cu : this.covers()) {
                            ic = cap.covers().get(cu);
                            cons[i++] = ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)0);
                        }
                        LCF.ifThen((BoolVar)cap.parcelsImplantedCoverContinue(ip).not(), (Constraint)LCF.and((Constraint[])cons));
                        break;
                    }
                    int rp = (int)(Math.random() * 100.0);
                    if (!((double)rp > ProbaTimeManager.getProba(this.durationMode, duration = max - min + 1, nbyear = count - min) / (100.0 - ProbaTimeManager.getCumul(this.durationMode, duration, nbyear)) * 100.0)) continue block4;
                    if (this.hasSingleCover()) {
                        int ic4 = cap.covers().get(this.getSingleCover());
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic4, ip), (String)"=", (int)1));
                        break;
                    }
                    Constraint[] cons = new Constraint[this.covers().size()];
                    int i2 = 0;
                    for (CoverUnit cu : this.covers()) {
                        int ic5 = cap.covers().get(cu);
                        cons[i2++] = ICF.arithm((IntVar)cap.coversAndParcels(ic5, ip), (String)"=", (int)1);
                    }
                    cap.solver().post(LCF.or((Constraint[])cons));
                    break;
                }
                case NEVER: {
                    int ic;
                    if (!this.domain().accept(count)) continue block4;
                    if (this.hasSingleCover()) {
                        int ic6 = cap.covers().get(this.getSingleCover());
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ic6, ip), (String)"=", (int)1));
                        break;
                    }
                    Constraint[] cons = new Constraint[this.covers().size()];
                    int i = 0;
                    for (CoverUnit cu : this.covers()) {
                        ic = cap.covers().get(cu);
                        cons[i++] = ICF.arithm((IntVar)cap.coversAndParcels(ic, ip), (String)"=", (int)1);
                    }
                    cap.solver().post(LCF.or((Constraint[])cons));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
                }
            }
        }
    }

    private int countLastOccurencesOfCoverUnits(DynamicAttribute<CoverUnit> daCover, Set<CoverUnit> u) {
        int count = 0;
        for (int i = daCover.size() - 1; i >= 0 && u.contains(((TemporalValue)daCover.get(i)).getValue()); --i) {
            ++count;
        }
        return count;
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        int supermin = Integer.MAX_VALUE;
        int supermax = Integer.MIN_VALUE;
        block4: for (Parcel p : this.location()) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            int repet = -1;
            boolean begin = false;
            for (TemporalValue tv : (DynamicAttribute)p.getAttribute("cover")) {
                if (this.covers().contains(tv.getValue())) {
                    ++repet;
                    if (!tv.equals(p.getAttribute("cover").getFirst())) continue;
                    begin = true;
                    continue;
                }
                if (begin) {
                    begin = false;
                    if (repet <= -1) continue;
                    max = Math.max(max, repet);
                    repet = -1;
                    continue;
                }
                if (repet <= -1) continue;
                min = Math.min(min, repet);
                max = Math.max(max, repet);
                repet = -1;
            }
            supermin = Math.min(supermin, min);
            supermax = Math.max(supermax, max);
            switch (this.mode()) {
                case ONLY: {
                    if (min == Integer.MAX_VALUE || this.domain().accept(min) && this.domain().accept(max)) continue block4;
                    ok = false;
                    if (verbose) {
                        sb.append("BAD  : cover has bad repetition time min = " + min + " and max = " + max + "\n");
                        continue block4;
                    }
                    return ok;
                }
                case NEVER: {
                    if (min == Integer.MAX_VALUE || !this.domain().accept(min) && !this.domain().accept(max)) continue block4;
                    ok = false;
                    if (verbose) {
                        sb.append("BAD  : cover has bad repetition time min = " + min + " and max = " + max + "\n");
                        continue block4;
                    }
                    return ok;
                }
            }
            throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
        }
        if (verbose) {
            if (ok) {
                if (supermin == Integer.MAX_VALUE) {
                    sb.append("GOOD - repetition " + (Object)((Object)this.mode()) + " cover " + this.covers().toString() + " has no repetition");
                } else {
                    sb.append("GOOD - repetition " + (Object)((Object)this.mode()) + " cover " + this.covers().toString() + " has repetition between min = " + supermin + " and max = " + supermax);
                }
            }
            System.out.println(sb.toString());
        }
        return ok;
    }
}

