/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import fr.inra.sad.bagap.apiland.core.time.delay.YearDelay;
import java.util.Set;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.LCF;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public class DistanceBetweenCoversConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;
    private Set<CoverUnit> targets;

    public DistanceBetweenCoversConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> location, Domain<Integer, Integer> domain, Set<Cover> targets) {
        super(code, checkOnly, ConstraintType.DistanceBetweenCovers, mode, covers, location, domain);
        this.targets = this.getCoverUnits(targets);
    }

    public boolean targetHasSingleCover() {
        return this.targets.size() == 1;
    }

    public CoverUnit getTargetSingleCover() {
        return this.targets.iterator().next();
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        for (Parcel p1 : this.location()) {
            int ip1 = cap.parcels().get(p1);
            for (Parcel p2 : this.location()) {
                int ip2 = cap.parcels().get(p2);
                if (p1 == p2) continue;
                int distance = p1.getDistance(p2);
                block14: for (CoverUnit c : this.covers()) {
                    int ic1 = cap.covers().get(c);
                    if (this.targetHasSingleCover()) {
                        int ic2 = cap.covers().get(this.getTargetSingleCover());
                        switch (this.mode()) {
                            case ALWAYS: {
                                if (!this.domain().accept(distance)) break;
                                LCF.ifThen((BoolVar)cap.coversAndParcels(ic1, ip1), (Constraint)ICF.arithm((IntVar)cap.coversAndParcels(ic2, ip2), (String)"=", (int)1));
                                break;
                            }
                            case NEVER: {
                                if (!this.domain().accept(distance)) break;
                                LCF.ifThen((BoolVar)cap.coversAndParcels(ic1, ip1), (Constraint)ICF.arithm((IntVar)cap.coversAndParcels(ic2, ip2), (String)"=", (int)0));
                                break;
                            }
                            case AROUND: {
                                if (this.domain().accept(distance)) break;
                                LCF.ifThen((BoolVar)cap.coversAndParcels(ic1, ip1), (Constraint)ICF.arithm((IntVar)cap.coversAndParcels(ic2, ip2), (String)"=", (int)1));
                                break;
                            }
                            case ONLY: {
                                if (this.domain().accept(distance)) break;
                                LCF.ifThen((BoolVar)cap.coversAndParcels(ic1, ip1), (Constraint)ICF.arithm((IntVar)cap.coversAndParcels(ic2, ip2), (String)"=", (int)0));
                            }
                        }
                        continue;
                    }
                    switch (this.mode()) {
                        case ALWAYS: {
                            int ic2;
                            if (!this.domain().accept(distance)) break;
                            Constraint[] ct = new Constraint[this.targets.size()];
                            int i = 0;
                            for (CoverUnit c2 : this.targets) {
                                ic2 = cap.covers().get(c2);
                                ct[i++] = ICF.arithm((IntVar)cap.coversAndParcels(ic2, ip2), (String)"=", (int)1);
                            }
                            LCF.ifThen((BoolVar)cap.coversAndParcels(ic1, ip1), (Constraint)LCF.or((Constraint[])ct));
                            break;
                        }
                        case NEVER: {
                            if (!this.domain().accept(distance)) break;
                            for (CoverUnit c2 : this.targets) {
                                int ic2 = cap.covers().get(c2);
                                LCF.ifThen((BoolVar)cap.coversAndParcels(ic1, ip1), (Constraint)ICF.arithm((IntVar)cap.coversAndParcels(ic2, ip2), (String)"=", (int)0));
                            }
                            continue block14;
                        }
                        case AROUND: {
                            int ic2;
                            if (this.domain().accept(distance)) break;
                            Constraint[] ct = new Constraint[this.targets.size()];
                            int i = 0;
                            for (CoverUnit c2 : this.targets) {
                                ic2 = cap.covers().get(c2);
                                ct[i++] = ICF.arithm((IntVar)cap.coversAndParcels(ic2, ip2), (String)"=", (int)1);
                            }
                            LCF.ifThen((BoolVar)cap.coversAndParcels(ic1, ip1), (Constraint)LCF.or((Constraint[])ct));
                            break;
                        }
                        case ONLY: {
                            if (this.domain().accept(distance)) break;
                            for (CoverUnit c2 : this.targets) {
                                int ic2 = cap.covers().get(c2);
                                LCF.ifThen((BoolVar)cap.coversAndParcels(ic1, ip1), (Constraint)ICF.arithm((IntVar)cap.coversAndParcels(ic2, ip2), (String)"=", (int)0));
                            }
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        sb.append("distance between covers ");
        YearDelay d = new YearDelay(1);
        Instant t = start;
        while (t.isBefore(end) || t.equals(end)) {
            for (Parcel p1 : this.location()) {
                Cover c1 = (Cover)p1.getAttribute("cover").getValue(t);
                if (!this.covers().contains(c1)) continue;
                for (Parcel p2 : this.location()) {
                    if (p1.equals(p2)) continue;
                    int distance = p1.getDistance(p2);
                    Cover c2 = (Cover)p2.getAttribute("cover").getValue(t);
                    switch (this.mode()) {
                        case ALWAYS: {
                            if (!this.domain().accept(distance) || this.targets.contains(c2)) break;
                            ok = false;
                            if (verbose) {
                                sb.append("BAD Distance " + (Object)((Object)this.mode()) + " : " + distance + "\n");
                                break;
                            }
                            return ok;
                        }
                        case NEVER: {
                            if (!this.domain().accept(distance) || !this.targets.contains(c2)) break;
                            ok = false;
                            if (verbose) {
                                sb.append("BAD Distance " + (Object)((Object)this.mode()) + " : " + distance + "\n");
                                break;
                            }
                            return ok;
                        }
                        case ONLY: {
                            if (this.domain().accept(distance) || !this.targets.contains(c2)) break;
                            ok = false;
                            if (verbose) {
                                sb.append("BAD Distance " + (Object)((Object)this.mode()) + " : " + distance + "\n");
                                break;
                            }
                            return ok;
                        }
                        case AROUND: {
                            if (this.domain().accept(distance) || this.targets.contains(c2)) break;
                            ok = false;
                            if (verbose) {
                                sb.append("BAD Distance " + (Object)((Object)this.mode()) + " : " + distance + "\n");
                                break;
                            }
                            return ok;
                        }
                    }
                }
            }
            t = ((Delay)d).next(t);
        }
        if (verbose) {
            System.out.println(sb.toString());
        }
        return ok;
    }
}

