/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model;

import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.Covering;
import fr.inra.sad.bagap.apiland.capfarm.model.Farm;
import fr.inra.sad.bagap.apiland.capfarm.model.GenericFarmingSystem;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

public class FarmingSystem
implements Covering {
    private Farm farm;
    private Set<Cover> covers;
    private Set<CoverAllocationConstraint<?, ?>> constraints;
    private GenericFarmingSystem generic;

    public FarmingSystem(Farm farm) {
        this.farm = farm;
        this.covers = new TreeSet<Cover>();
        this.constraints = new TreeSet();
        this.generic = new GenericFarmingSystem("unknown_" + farm.getCode());
    }

    public String toString() {
        return this.generic.toString();
    }

    public Farm getFarm() {
        return this.farm;
    }

    public GenericFarmingSystem getGenericFarmingSystem() {
        return this.generic;
    }

    public void setGenericFarmingSystem(GenericFarmingSystem generic) {
        this.generic = generic;
    }

    @Override
    public void addCover(Cover c) {
        this.covers.add(c);
        this.generic.addCover(c);
    }

    @Override
    public void addCovers(Collection<Cover> covers) {
        this.covers.addAll(covers);
        this.generic.addCovers(covers);
    }

    public Set<Cover> getCovers() {
        return this.covers;
    }

    public Set<CoverUnit> coverUnits() {
        TreeSet<CoverUnit> cov = new TreeSet<CoverUnit>();
        for (Cover c : this.covers) {
            if (!(c instanceof CoverUnit)) continue;
            cov.add((CoverUnit)c);
        }
        return cov;
    }

    public CoverUnit getCoverUnit(String code) {
        for (Cover c : this.covers) {
            if (!(c instanceof CoverUnit) || !c.getCode().equalsIgnoreCase(code)) continue;
            return (CoverUnit)c;
        }
        throw new IllegalArgumentException("no cover " + code);
    }

    public Set<CoverGroup> coverGroups() {
        TreeSet<CoverGroup> cov = new TreeSet<CoverGroup>();
        for (Cover c : this.covers) {
            if (!(c instanceof CoverGroup)) continue;
            cov.add((CoverGroup)c);
        }
        return cov;
    }

    public int coverUnitsCount() {
        return this.coverUnits().size();
    }

    public int coverGroupsCount() {
        return this.coverGroups().size();
    }

    public Set<CoverAllocationConstraint<?, ?>> getConstraints() {
        return this.constraints;
    }

    public void addConstraint(CoverAllocationConstraint<?, ?> constraint) {
        this.constraints.add(constraint);
    }

    public void display() {
        for (CoverAllocationConstraint<?, ?> fc : this.constraints) {
            System.out.println(fc);
        }
    }

    public CoverAllocationConstraint<?, ?> getConstraint(String code) {
        for (CoverAllocationConstraint<?, ?> c : this.constraints) {
            if (!c.code().equalsIgnoreCase(code)) continue;
            return c;
        }
        return null;
    }
}

