/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.util.Map;
import java.util.TreeMap;

public class ValuesOutput
extends AbstractMetricOutput {
    private Map<String, Double> values = new TreeMap<String, Double>();

    @Override
    public void notify(Metric m, String metric, double value, Process process) {
        this.values.put(metric.replace(".0", ""), value);
    }

    public void display() {
        for (Map.Entry<String, Double> v : this.values.entrySet()) {
            System.out.println(v.getKey() + " --> " + v.getValue());
        }
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
        switch (state) {
            case INIT: {
                this.values.clear();
            }
        }
    }

    public boolean hasValues() {
        return this.values.size() > 0;
    }

    public double get(String metric) {
        if (this.values.containsKey(metric)) {
            return this.values.get(metric);
        }
        return Raster.getNoDataValue();
    }
}

