/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.output;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.vector.process.VectorProcess;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class SharedCsvOutputV
extends AbstractMetricOutput {
    private CsvWriter out;
    private Map<String, Double> values;
    private int nbSimulation;
    private int year;

    public SharedCsvOutputV(CsvWriter cw, int nbSimulation, int year) {
        this.out = cw;
        this.nbSimulation = nbSimulation;
        this.year = year;
        this.values = new TreeMap<String, Double>();
        this.flush();
    }

    public String toString() {
        return "csv";
    }

    private void flush() {
        this.values.clear();
    }

    @Override
    public void notify(Analysis a, AnalysisState state) {
        switch (state) {
            // Empty switch
        }
    }

    @Override
    public void notify(Metric m, String metric, double value, Process process) {
        this.values.put(metric, value);
    }

    @Override
    public void notify(Process p, ProcessState state) {
        switch (state) {
            case DONE: {
                this.notifyProcessDone((VectorProcess)p);
            }
        }
    }

    private void notifyProcessDone(VectorProcess p) {
        try {
            this.out.write(this.nbSimulation + "");
            this.out.write(this.year + "");
            for (String v : this.values.keySet()) {
                this.out.write(this.format(this.values.get(v)));
            }
            this.out.endRecord();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.flush();
    }
}

