/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.shape;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShape;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.CoordinateManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class LocateFunctionalWindow
extends WindowShape {
    private int[] filter;
    private int width;
    private int theoricalSize;

    public LocateFunctionalWindow(int[] f, int theoricalSize) {
        this.filter = f;
        this.theoricalSize = theoricalSize;
        this.width = new Double(Math.sqrt(this.filter.length)).intValue();
    }

    public String getStringFilter() {
        StringBuffer sb = new StringBuffer();
        for (int f : this.filter) {
            sb.append(f);
        }
        return sb.toString();
    }

    protected int[] filters() {
        return this.filter;
    }

    @Override
    public int filter(int wx, int wy) {
        return this.filter[wy * this.width + wx];
    }

    @Override
    public int theoricalSize() {
        return this.theoricalSize;
    }

    @Override
    public void display() {
        int index = 0;
        for (int f : this.filter) {
            System.out.print(f + " ");
            if (++index % this.width != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    @Override
    public void export(int x, int y, Matrix m, String path) {
        try {
            String name = new File(m.getFile()).getName().replace(".asc", "");
            String file = path + name + "_functional_" + this.width + "_" + CoordinateManager.getProjectedX(m, x) + "-" + CoordinateManager.getProjectedY(m, y) + ".asc";
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            double delta = (double)this.width / 2.0;
            double X = CoordinateManager.getProjectedX(m, x);
            double nX = X - delta * Raster.getCellSize();
            double Y = CoordinateManager.getProjectedY(m, y);
            double nY = Y - delta * Raster.getCellSize();
            out.write("ncols ");
            out.write(this.width + "");
            out.newLine();
            out.write("nrows ");
            out.write(this.width + "");
            out.newLine();
            out.write("xllcorner ");
            out.write(nX + "");
            out.newLine();
            out.write("yllcorner ");
            out.write(nY + "");
            out.newLine();
            out.write("cellsize ");
            out.write(Raster.getCellSize() + "");
            out.newLine();
            out.write("NODATA_value  ");
            out.write(Raster.getNoDataValue() + "");
            out.newLine();
            int index = 0;
            for (int j = y - this.width / 2; j < y + 1 + this.width / 2; ++j) {
                for (int i = x - this.width / 2; i < x + 1 + this.width / 2; ++i) {
                    if (this.filter[index++] == 0) {
                        out.write("-1 ");
                        continue;
                    }
                    out.write(m.get(i, j) + " ");
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int width() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int height() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        if (other instanceof LocateFunctionalWindow) {
            LocateFunctionalWindow l = (LocateFunctionalWindow)other;
            for (int s = 0; s < this.filter.length; ++s) {
                if (this.filter[s] == l.filter[s]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        for (int s = 0; s < this.filter.length; ++s) {
            h += this.filter[s];
        }
        return h;
    }

    @Override
    public List<Pixel> removeDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> addDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> removeHorizontalDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> addHorizontalDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> removeVerticalDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> addVerticalDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void infos() {
    }
}

