/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.shape;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShape;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.LinkedList;
import java.util.List;

public class DonutWindow
extends WindowShape {
    private final int min;
    private final int max;
    private final int[] filter;
    private List<Pixel> addDownList;
    private List<Pixel> removeDownList;
    private List<Pixel> addVerticalDownList;
    private List<Pixel> removeVerticalDownList;
    private List<Pixel> addHorizontalDownList;
    private List<Pixel> removeHorizontalDownList;

    public DonutWindow(int min, int max) {
        this.min = min;
        this.max = max;
        this.filter = new int[max * max];
        this.init();
        this.display();
    }

    private void init() {
        double rayon = new Double(this.max) / 2.0;
        double internal = new Double(this.min) / 2.0;
        WKTReader wkt = new WKTReader();
        try {
            Point center = (Point)wkt.read("POINT (" + rayon + " " + rayon + ")");
            int index = 0;
            for (double y = 0.5; y < (double)this.max; y += 1.0) {
                for (double x = 0.5; x < (double)this.max; x += 1.0) {
                    Point p = (Point)wkt.read("POINT (" + x + " " + y + ")");
                    this.filter[index++] = center.distance((Geometry)p) > rayon ? 0 : (center.distance((Geometry)p) < internal ? 0 : 1);
                }
            }
            index = 0;
            for (int x = 0; x < this.max; ++x) {
                if (x == 0) {
                    if (this.filter[index] != 0) {
                        this.filter[index] = 4;
                    }
                } else if (this.filter[index] != 0) {
                    this.filter[index] = this.filter[index - 1] != 0 ? 2 : 4;
                }
                ++index;
            }
            for (int y = 1; y < this.max; ++y) {
                for (int x = 0; x < this.max; ++x) {
                    if (x == 0) {
                        if (this.filter[index] != 0) {
                            this.filter[index] = this.filter[index - this.max] != 0 ? 3 : 4;
                        }
                    } else if (this.filter[index] != 0) {
                        if (this.filter[index - 1] == 0) {
                            this.filter[index] = this.filter[index - this.max] == 0 ? 4 : 3;
                        } else if (this.filter[index - this.max] == 0) {
                            this.filter[index] = 2;
                        }
                    }
                    ++index;
                }
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int width() {
        return this.max;
    }

    @Override
    public int height() {
        return this.max;
    }

    @Override
    public int filter(int wx, int wy) {
        return this.filter[wy * this.width() + wx];
    }

    private Pixel pixelByIndex(int index) {
        return new Pixel(index % this.width(), index / this.width());
    }

    private void initLists() {
        if (this.addDownList == null) {
            Pixel p;
            this.addDownList = new LinkedList<Pixel>();
            this.removeDownList = new LinkedList<Pixel>();
            this.addHorizontalDownList = new LinkedList<Pixel>();
            this.removeHorizontalDownList = new LinkedList<Pixel>();
            this.addVerticalDownList = new LinkedList<Pixel>();
            this.removeVerticalDownList = new LinkedList<Pixel>();
            for (int i = 0; i < this.filter.length; ++i) {
                if (this.filter[i] == 2 || this.filter[i] == 4) {
                    p = this.pixelByIndex(i);
                    this.removeDownList.add(p);
                    if (i < this.filter.length - this.width() && this.filter[i + this.width()] != 0) {
                        this.removeVerticalDownList.add(p);
                    }
                }
                if (i <= this.width() || this.filter[i] != 0 || this.filter[i - this.width()] == 0) continue;
                this.addDownList.add(this.pixelByIndex(i));
                this.addVerticalDownList.add(this.pixelByIndex(i - this.width()));
            }
            for (Pixel r : this.removeDownList) {
                if (r.x() < this.width() - 1 && this.filter(r.x() + 1, r.y()) != 0) {
                    this.removeHorizontalDownList.add(r);
                }
                if (r.x() <= 0 || this.filter(r.x() - 1, r.y()) == 0 || this.removeDownList.contains(p = new Pixel(r.x() - 1, r.y()))) continue;
                this.removeHorizontalDownList.add(p);
            }
            for (Pixel r : this.addDownList) {
                if (r.x() < this.width() - 1 && this.filter(r.x() + 1, r.y() - 1) != 0) {
                    this.addHorizontalDownList.add(r);
                }
                if (r.x() <= 0 || this.filter(r.x() - 1, r.y() - 1) == 0 || this.addDownList.contains(p = new Pixel(r.x() - 1, r.y()))) continue;
                this.addHorizontalDownList.add(p);
            }
        }
    }

    @Override
    public List<Pixel> removeDownList() {
        this.initLists();
        return this.removeDownList;
    }

    @Override
    public List<Pixel> addDownList() {
        this.initLists();
        return this.addDownList;
    }

    @Override
    public List<Pixel> removeHorizontalDownList() {
        this.initLists();
        return this.removeHorizontalDownList;
    }

    @Override
    public List<Pixel> addHorizontalDownList() {
        this.initLists();
        return this.addHorizontalDownList;
    }

    @Override
    public List<Pixel> removeVerticalDownList() {
        this.initLists();
        return this.removeVerticalDownList;
    }

    @Override
    public List<Pixel> addVerticalDownList() {
        this.initLists();
        return this.addVerticalDownList;
    }

    @Override
    public void display() {
        int index = 0;
        for (int f : this.filter) {
            System.out.print(f + " ");
            if (++index % this.max != 0) continue;
            System.out.println();
        }
    }

    @Override
    public void export(int x, int y, Matrix m, String path) {
    }

    @Override
    public void infos() {
    }
}

