/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.shape;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.SimpleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShape;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.List;

public class CornerWindow
extends SimpleWindow {
    public CornerWindow(WindowShape shape) {
        super(shape);
    }

    @Override
    public Pixel getPixel(int wx, int wy) {
        return PixelManager.get(this.pixel().x() + wx, this.pixel().y() + wy);
    }

    @Override
    public Pixel getPixel(Pixel wp) {
        return this.getPixel(wp.x(), wp.y());
    }

    @Override
    public int outXWindow(int wx) {
        return this.pixel().x() + wx;
    }

    @Override
    public int outYWindow(int wy) {
        return this.pixel().y() + wy;
    }

    @Override
    public double get(Matrix m, int wx, int wy) {
        return m.get(this.pixel().x() + wx, this.pixel().y() + wy);
    }

    @Override
    public double get(Matrix m, Pixel wp) {
        return this.get(m, wp.x(), wp.y());
    }

    @Override
    public boolean accept(int x, int y) {
        return x >= this.pixel().x() && x < this.pixel().x() + this.width() && y >= this.pixel().y() && y < this.pixel().y() + this.height();
    }

    @Override
    public boolean accept(Pixel p) {
        return this.accept(p.x(), p.y());
    }

    @Override
    public Pixel toWindow(int x, int y) {
        return PixelManager.get(x - this.pixel().x(), y - this.pixel().y());
    }

    @Override
    public Pixel toWindow(Pixel p) {
        return this.toWindow(p.x(), p.y());
    }

    @Override
    public int toXWindow(int x) {
        return x - this.pixel().x();
    }

    @Override
    public int toYWindow(int y) {
        return y - this.pixel().y();
    }

    @Override
    public int size() {
        return this.shape().size();
    }

    @Override
    public int size(int width, int height) {
        int du = 0 - this.pixel().y();
        int dd = this.pixel().y() + this.height() - height;
        int dl = 0 - this.pixel().x();
        int dr = this.pixel().x() + this.width() - width;
        if (dl < 0) {
            if (dr < 0) {
                if (du < 0) {
                    if (dd < 0) {
                        return this.shape().size();
                    }
                    return this.shape().sizeTrunkDown(dd);
                }
                if (dd < 0) {
                    return this.shape().sizeTrunkUp(du);
                }
                return this.shape().sizeTrunkUpDown(du, dd);
            }
            if (du < 0) {
                if (dd < 0) {
                    return this.shape().sizeTrunkRight(dr);
                }
                return this.shape().sizeTrunkDownRight(dd, dr);
            }
            if (dd < 0) {
                return this.shape().sizeTrunkUpRight(du, dr);
            }
            return this.shape().sizeTrunkUpDownRight(du, dd, dr);
        }
        if (dr < 0) {
            if (du < 0) {
                if (dd < 0) {
                    return this.shape().sizeTrunkLeft(dl);
                }
                return this.shape().sizeTrunkDownLeft(dd, dl);
            }
            if (dd < 0) {
                return this.shape().sizeTrunkUpLeft(du, dl);
            }
            return this.shape().sizeTrunkUpDownLeft(du, dd, dl);
        }
        if (du < 0) {
            if (dd < 0) {
                return this.shape().sizeTrunkLeftRight(dl, dr);
            }
            return this.shape().sizeTrunkDownLeftRight(dd, dl, dr);
        }
        if (dd < 0) {
            return this.shape().sizeTrunkUpLeftRight(du, dl, dr);
        }
        return this.shape().sizeTrunkUpDownLeftRight(du, dd, dl, dr);
    }

    @Override
    public List<Pixel> removeDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> addDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> removeHorizontalDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> addHorizontalDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> removeVerticalDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> addVerticalDownList() {
        throw new UnsupportedOperationException();
    }
}

