/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedLineString;
import com.vividsolutions.jts.geom.prep.PreparedPoint;
import com.vividsolutions.jts.geom.prep.PreparedPolygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.manager.Tool;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.sql.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;

public class ExportAsciiGridFromShapefileAnalysis
extends Analysis {
    private String ascii;
    private String shape;
    private String attribute;
    private double cellsize;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private Map<String, String> map;

    public ExportAsciiGridFromShapefileAnalysis(String ascii, String shape, String attribute, double cellsize, Map<String, String> map) {
        this.ascii = ascii;
        this.shape = shape;
        this.attribute = attribute;
        this.cellsize = cellsize;
        double[] envelope = this.getEnvelopeFromShapefile(this.getShape(shape));
        this.minX = envelope[0];
        this.maxX = envelope[1];
        this.minY = envelope[2];
        this.maxY = envelope[3];
        this.map = map;
    }

    public ExportAsciiGridFromShapefileAnalysis(String ascii, String shape, String attribute, double cellsize, double minX, double maxX, double minY, double maxY, Map<String, String> map) {
        this.ascii = ascii;
        this.shape = shape;
        this.attribute = attribute;
        this.cellsize = cellsize;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.map = map;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doRun() {
        ShpFiles sf = this.getShape(this.shape);
        int nb = this.getNumGeometries(sf);
        if (nb < 100) {
            this.runFewGeometries();
        } else {
            this.runLotGeometries();
        }
    }

    protected void runFewGeometries() {
        ShpFiles sf = this.getShape(this.shape);
        int pos = this.getAttributePosition(sf, this.attribute);
        ShapeType type = this.getShapeType(sf);
        int ncols = (this.maxX - this.minX) % this.cellsize == 0.0 ? new Double(Math.floor((this.maxX - this.minX) / this.cellsize)).intValue() : new Double(Math.floor((this.maxX - this.minX) / this.cellsize) + 1.0).intValue();
        int nrows = (this.maxY - this.minY) % this.cellsize == 0.0 ? new Double(Math.floor((this.maxY - this.minY) / this.cellsize)).intValue() : new Double(Math.floor((this.maxY - this.minY) / this.cellsize) + 1.0).intValue();
        Set<PreparedGeometry> geos = this.getPreparedGeometries(sf, type, pos, this.map);
        PreparedGeometry current = null;
        double yorigin = (this.maxY - this.minY) % this.cellsize == 0.0 ? this.minY + Math.floor((this.maxY - this.minY) / this.cellsize) * this.cellsize : this.minY + (Math.floor((this.maxY - this.minY) / this.cellsize) + 1.0) * this.cellsize;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.ascii));
            bw.write("ncols " + ncols);
            bw.newLine();
            bw.write("nrows " + nrows);
            bw.newLine();
            bw.write("xllcorner " + this.minX);
            bw.newLine();
            bw.write("yllcorner " + this.minY);
            bw.newLine();
            bw.write("cellsize " + this.cellsize);
            bw.newLine();
            bw.write("NODATA_value " + Raster.getNoDataValue());
            bw.newLine();
            GeometryFactory gf = new GeometryFactory();
            double distance = Math.sqrt(2.0) * this.cellsize / 2.0;
            for (int j = 0; j < nrows; ++j) {
                double x = this.minX + this.cellsize / 2.0;
                double y = yorigin - this.cellsize / 2.0 - (double)j * this.cellsize;
                for (int i = 0; i < ncols; ++i) {
                    x = this.minX + this.cellsize / 2.0 + (double)i * this.cellsize;
                    Point p = gf.createPoint(new Coordinate(x, y));
                    if (current != null && type.isPolygonType() && current.intersects((Geometry)p)) {
                        bw.write(current.getGeometry().getUserData() + " ");
                    } else {
                        boolean ok = false;
                        for (PreparedGeometry g : geos) {
                            if ((!type.isPolygonType() || !g.intersects((Geometry)p)) && (!type.isLineType() || !(g.getGeometry().distance((Geometry)p) <= distance))) continue;
                            current = g;
                            bw.write(current.getGeometry().getUserData() + " ");
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            bw.write(Raster.getNoDataValue() + " ");
                        }
                    }
                    this.updateProgression(nrows * ncols);
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void runLotGeometries() {
        ShpFiles sf = this.getShape(this.shape);
        int pos = this.getAttributePosition(sf, this.attribute);
        int nb = this.getNumGeometries(sf);
        ShapeType type = this.getShapeType(sf);
        int ncols = (this.maxX - this.minX) % this.cellsize == 0.0 ? new Double(Math.floor((this.maxX - this.minX) / this.cellsize)).intValue() : new Double(Math.floor((this.maxX - this.minX) / this.cellsize) + 1.0).intValue();
        int nrows = (this.maxY - this.minY) % this.cellsize == 0.0 ? new Double(Math.floor((this.maxY - this.minY) / this.cellsize)).intValue() : new Double(Math.floor((this.maxY - this.minY) / this.cellsize) + 1.0).intValue();
        Geometry current = null;
        STRtree spatialIndex = null;
        int decoup = nb / 1000000 + 1;
        int d = -1;
        double yorigin = (this.maxY - this.minY) % this.cellsize == 0.0 ? this.minY + Math.floor((this.maxY - this.minY) / this.cellsize) * this.cellsize : this.minY + (Math.floor((this.maxY - this.minY) / this.cellsize) + 1.0) * this.cellsize;
        PreparedPoint pp = null;
        try {
            pp = new PreparedPoint((Puntal)new WKTReader().read("POINT (0 0)"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.ascii));
            bw.write("ncols " + ncols);
            bw.newLine();
            bw.write("nrows " + nrows);
            bw.newLine();
            bw.write("xllcorner " + this.minX);
            bw.newLine();
            bw.write("yllcorner " + this.minY);
            bw.newLine();
            bw.write("cellsize " + this.cellsize);
            bw.newLine();
            bw.write("NODATA_value " + Raster.getNoDataValue());
            bw.newLine();
            int delta = 1000;
            for (int j = 0; j < nrows; ++j) {
                double y;
                if (j * decoup / nrows != d) {
                    d = j * decoup / nrows;
                    spatialIndex = this.getSpatialIndex(sf, pos, this.map, new Envelope(this.minX - (double)delta, this.maxX + (double)delta, this.minY - (double)delta + (double)(decoup - d - 1) * ((this.maxY - this.minY) / (double)decoup), this.maxY + (double)delta - (double)d * (this.maxY - this.minY) / (double)decoup));
                }
                double x = this.minX + this.cellsize / 2.0;
                pp.getGeometry().getCoordinate().y = y = yorigin - this.cellsize / 2.0 - (double)j * this.cellsize;
                double distance = Math.sqrt(2.0) * this.cellsize / 2.0;
                for (int i = 0; i < ncols; ++i) {
                    pp.getGeometry().getCoordinate().x = x = this.minX + this.cellsize / 2.0 + (double)i * this.cellsize;
                    pp.getGeometry().geometryChanged();
                    if (current != null && type.isPolygonType() && pp.intersects(current)) {
                        bw.write(current.getUserData() + " ");
                    } else {
                        List geometries = spatialIndex.query(new Envelope(new Coordinate(x - 1.0, y + 1.0), new Coordinate(x + 1.0, y - 1.0)));
                        boolean ok = false;
                        for (Geometry g : geometries) {
                            if ((!type.isPolygonType() || !pp.intersects(g)) && (!type.isLineType() || !(pp.getGeometry().distance(g) <= distance))) continue;
                            current = g;
                            bw.write(g.getUserData() + " ");
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            bw.write(Raster.getNoDataValue() + " ");
                        }
                    }
                    this.updateProgression(nrows * ncols);
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void doClose() {
        try {
            Tool.copy(DynamicLayerFactory.class.getResourceAsStream("lambert93.prj"), this.ascii.replace(".asc", "") + ".prj");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.ascii = null;
        this.shape = null;
        this.attribute = null;
        this.map = null;
    }

    private ShpFiles getShape(String shape) {
        try {
            ShpFiles sf = shape.endsWith(".shp") ? new ShpFiles(shape) : new ShpFiles(shape + ".shp");
            return sf;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException();
        }
    }

    private int getNumGeometries(ShpFiles sf) {
        try {
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            int size = 0;
            while (sfr.hasNext()) {
                GeometryCollection gc = (GeometryCollection)sfr.nextRecord().shape();
                if (gc == null) continue;
                size += gc.getNumGeometries();
            }
            sfr.close();
            return size;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private ShapeType getShapeType(ShpFiles sf) {
        try {
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            ShapeType type = sfr.getHeader().getShapeType();
            sfr.close();
            return type;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private int getAttributePosition(ShpFiles sf, String attribute) {
        try {
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (!dfh.getFieldName(f).equalsIgnoreCase(attribute)) continue;
                dfr.close();
                return f;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private double[] getEnvelopeFromShapefile(ShpFiles sf) {
        try {
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            ShapefileHeader sfh = sfr.getHeader();
            double[] envelope = new double[]{sfh.minX(), sfh.maxX(), sfh.minY(), sfh.maxY()};
            sfr.close();
            return envelope;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private Set<PreparedGeometry> getPreparedGeometries(ShpFiles sf, ShapeType type, int pos, Map<String, String> map) {
        try {
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            HashSet<PreparedGeometry> set = new HashSet<PreparedGeometry>();
            while (sfr.hasNext()) {
                dfr.read();
                GeometryCollection gc = (GeometryCollection)sfr.nextRecord().shape();
                if (gc == null) continue;
                for (int n = 0; n < gc.getNumGeometries(); ++n) {
                    Geometry g = gc.getGeometryN(n);
                    if (map == null) {
                        g.setUserData(dfr.readField(pos));
                    } else {
                        Object f = dfr.readField(pos);
                        if (map.containsKey(f + "")) {
                            g.setUserData((Object)map.get(f + ""));
                        } else {
                            g.setUserData(f);
                        }
                    }
                    if (type.isLineType()) {
                        set.add((PreparedGeometry)new PreparedLineString((Lineal)g));
                        continue;
                    }
                    if (type.isPolygonType()) {
                        set.add((PreparedGeometry)new PreparedPolygon((Polygonal)g));
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
            }
            sfr.close();
            dfr.close();
            return set;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private STRtree getSpatialIndex(ShpFiles sf, int pos, Map<String, String> map, Envelope env) {
        try {
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            STRtree spatialIndex = new STRtree();
            while (sfr.hasNext()) {
                dfr.read();
                GeometryCollection gc = (GeometryCollection)sfr.nextRecord().shape();
                if (gc == null) continue;
                for (int n = 0; n < gc.getNumGeometries(); ++n) {
                    Geometry g = gc.getGeometryN(n);
                    if (!g.getEnvelopeInternal().intersects(env)) continue;
                    if (map == null) {
                        g.setUserData(dfr.readField(pos));
                    } else {
                        Object f = dfr.readField(pos);
                        if (map.containsKey(f + "")) {
                            g.setUserData((Object)map.get(f + ""));
                        } else {
                            g.setUserData(f);
                        }
                    }
                    spatialIndex.insert(g.getEnvelopeInternal(), (Object)g);
                }
            }
            sfr.close();
            dfr.close();
            spatialIndex.build();
            return spatialIndex;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    private Class<?> getAttributeType(ShpFiles sf, String attribute) {
        try {
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (!dfh.getFieldName(f).equalsIgnoreCase(attribute)) continue;
                switch (dfh.getFieldType(f)) {
                    case 'C': {
                        return String.class;
                    }
                    case 'F': {
                        return Double.class;
                    }
                    case 'L': {
                        return Boolean.class;
                    }
                    case 'D': {
                        return Date.class;
                    }
                    case 'N': {
                        if (dfh.getFieldDecimalCount(f) > 0) {
                            return Double.class;
                        }
                        if (dfh.getFieldLength(f) > 10) {
                            return Long.class;
                        }
                        return Integer.class;
                    }
                }
                throw new IllegalArgumentException();
            }
            dfr.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }
}

