/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.qualitative.patch;

import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.PatchMetric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.patch.Envelope;
import fr.inra.sad.bagap.apiland.patch.Patch;

public class HanskiConnectivityClassMetric
extends MatrixMetric
implements PatchMetric {
    private int classMetric;

    public HanskiConnectivityClassMetric(Integer cm) {
        super(VariableManager.get("HC-class_" + cm));
        this.classMetric = cm;
    }

    @Override
    protected void doCalculate(Counting co) {
        this.value = 0.0;
        int nb = 0;
        for (Patch p1 : co.patches().patches()) {
            if (this.classMetric != p1.getValue()) continue;
            ++nb;
            for (Patch p2 : co.patches().patches()) {
                if (this.classMetric != p2.getValue() || p1 == p2) continue;
                double d = Envelope.distance(p1.getEnvelope(), p2.getEnvelope()) * Raster.getCellSize() / 1000.0;
                double a = p2.getArea() / 10000.0;
                this.value += Math.exp(-1.0 * d) * a;
            }
        }
        this.value /= (double)nb;
    }
}

