/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.qualitative.patch;

import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.SimpleWindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.PatchMetric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.patch.Patch;
import fr.inra.sad.bagap.apiland.patch.PatchManager;

public class CentralPatchHanskiConnectivityClassMetric
extends MatrixMetric
implements PatchMetric {
    private int classMetric;

    public CentralPatchHanskiConnectivityClassMetric(Integer cm) {
        super(VariableManager.get("CPHCC_" + cm));
        this.classMetric = cm;
    }

    @Override
    protected void doCalculate(Counting co) {
        Pixel pixel = ((SimpleWindowMatrixProcess)co.process()).window().toWindow(((SimpleWindowMatrixProcess)co.process()).window().pixel());
        Patch patch = null;
        for (Patch p : co.patches().patches()) {
            if (!p.contains(pixel)) continue;
            patch = p;
        }
        if (patch != null) {
            this.value = 0.0;
            for (Patch p : co.patches().patches()) {
                double a;
                double d;
                if (patch != p && p.getValue() == this.classMetric) {
                    d = PatchManager.distance(patch, p) / 1000.0;
                    a = p.getArea() / 10000.0;
                    this.value += Math.exp(-1.0 * d) * a;
                    continue;
                }
                if (patch != p || p.getValue() != this.classMetric) continue;
                d = 0.0;
                a = p.getArea() / 10000.0;
                this.value += Math.exp(-1.0 * d) * a;
            }
        }
    }
}

