/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.MatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.BasicCounting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.ClassCounting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CoupleCounting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.PatchCounting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.QuantitativeCounting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.ValueCounting;
import fr.inra.sad.bagap.apiland.analysis.process.metric.BasicMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.ClassMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.CoupleMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.PatchMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.QuantitativeMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.ValueMetric;

public class CountingFactory {
    public static Counting create(MatrixProcess process) {
        Counting counting = new BasicCounting();
        counting.setProcess(process);
        for (Metric m : process.processType().metrics()) {
            if (m instanceof BasicMetric) {
                // empty if block
            }
            if (m instanceof CoupleMetric && !counting.isBinding(CoupleCounting.class)) {
                counting = new CoupleCounting(counting);
            }
            if (m instanceof ValueMetric && !counting.isBinding(ValueCounting.class)) {
                counting = new ValueCounting(counting);
            }
            if (m instanceof ClassMetric && !counting.isBinding(ClassCounting.class)) {
                counting = new ClassCounting(counting);
            }
            if (m instanceof QuantitativeMetric && !counting.isBinding(QuantitativeCounting.class)) {
                counting = new QuantitativeCounting(counting);
            }
            if (!(m instanceof PatchMetric) || counting.isBinding(PatchCounting.class)) continue;
            counting = new PatchCounting(counting);
        }
        return counting;
    }
}

