/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.MatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.SimpleWindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.Window;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.util.Couple;

public class WindowMatrixProcessType
extends MatrixProcessType {
    private double[] verticals;
    private double[] horizontals;
    private double hc;
    private double vc;

    public WindowMatrixProcessType(Matrix m) {
        super(m);
        this.horizontals = new double[m.width()];
        for (int x = 0; x < m.width(); ++x) {
            this.horizontals[x] = Raster.getNoDataValue();
        }
        this.verticals = new double[m.height()];
        for (int y = 0; y < m.height(); ++y) {
            this.verticals[y] = Raster.getNoDataValue();
        }
    }

    public WindowMatrixProcess create(Window w, Pixel p) {
        return new SimpleWindowMatrixProcess(w, p, this);
    }

    public void setValue(int x, int y, double v, Matrix m) {
        this.vc = Couple.get(v, this.horizontals[x]);
        this.horizontals[x] = v;
        this.hc = Couple.get(v, this.verticals[y]);
        this.verticals[y] = v;
    }

    public double getHorizontal(Matrix m) {
        return this.hc;
    }

    public double getVertical(Matrix m) {
        return this.vc;
    }
}

