/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class HeaderDeltaAsciiGridOutput
extends AbstractMetricOutput {
    private String ascii;
    private int delta;

    public HeaderDeltaAsciiGridOutput(String f, int d) {
        this.ascii = f;
        this.delta = d;
    }

    public String toString() {
        return "ascii_header";
    }

    @Override
    public void notify(Analysis a, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)a);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis wa) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.ascii));
            int nc = new Double(wa.matrix().width() / this.delta).intValue();
            if (wa.matrix().width() % this.delta != 0) {
                ++nc;
            }
            int nr = new Double(wa.matrix().height() / this.delta).intValue();
            if (wa.matrix().height() % this.delta != 0) {
                ++nr;
            }
            double decalage = (double)(this.delta - 1) * Raster.getCellSize() / 2.0;
            double mod = ((double)wa.matrix().height() * Raster.getCellSize() + decalage) % ((double)this.delta * Raster.getCellSize());
            writer.write("ncols " + nc);
            writer.newLine();
            writer.write("nrows " + nr);
            writer.newLine();
            writer.write("xllcorner " + (wa.matrix().minX() - decalage));
            writer.newLine();
            if (mod == 0.0) {
                writer.write("yllcorner " + wa.matrix().minY());
            } else if (mod >= (double)this.delta * Raster.getCellSize() / 2.0) {
                writer.write("yllcorner " + (wa.matrix().minY() - ((double)this.delta * Raster.getCellSize() - mod)));
            } else {
                writer.write("yllcorner " + (wa.matrix().minY() + mod));
            }
            writer.newLine();
            writer.write("cellsize " + (double)this.delta * wa.matrix().cellsize());
            writer.newLine();
            writer.write("NODATA_value " + Raster.getNoDataValue());
            writer.newLine();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void notify(Metric m, String metric, double v, Process wp) {
        m.removeObserver(this);
    }
}

