/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.cluster;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringAnalysis;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import java.io.IOException;
import java.util.Set;
import java.util.TreeMap;

public class ClusteringWithDistanceCsvOutput
implements AnalysisObserver {
    private String csv;
    private Set<Integer> values;

    public ClusteringWithDistanceCsvOutput(String csv, Set<Integer> values) {
        this.csv = csv;
        this.values = values;
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
        ClusteringAnalysis ca = (ClusteringAnalysis)ma;
        switch (state) {
            case DONE: {
                TreeMap<Integer, PixelComposite> map = new TreeMap<Integer, PixelComposite>();
                for (Raster raster : ((RasterComposite)ca.getResult()).getRasters()) {
                    map.put(((PixelComposite)raster).getValue(), (PixelComposite)raster);
                }
                CsvWriter cw = new CsvWriter(this.csv);
                cw.setDelimiter(';');
                try {
                    cw.write("id");
                    cw.write("type");
                    cw.write("count");
                    cw.write("area");
                    for (int v : this.values) {
                        cw.write("idmin_" + v);
                        cw.write("dmin_" + v);
                    }
                    cw.endRecord();
                    for (PixelComposite pc : map.values()) {
                        cw.write(pc.getValue() + "");
                        cw.write((int)pc.getUserData() + "");
                        cw.write(pc.size() + "");
                        cw.write(pc.getArea() + "");
                        System.out.println("calcul de distance \u00e0 partir de " + pc.getValue() + "(" + pc.getUserData() + ")");
                        Set<Pixel> set = pc.getBounds();
                        for (int v : this.values) {
                            double min = Double.MAX_VALUE;
                            int cl = -1;
                            if (v != (int)pc.getUserData()) {
                                for (PixelComposite pc2 : map.values()) {
                                    Set<Pixel> bounds2;
                                    double d;
                                    if ((int)pc2.getUserData() != v || !((d = Raster.distance(set, bounds2 = pc2.getBounds())) < min)) continue;
                                    min = d;
                                    cl = pc2.getValue();
                                }
                            }
                            if (min == Double.MAX_VALUE) {
                                min = -1.0;
                            }
                            cw.write(cl + "");
                            cw.write(min + "");
                        }
                        cw.endRecord();
                    }
                    cw.close();
                    break;
                }
                catch (CsvWriter.FinalizedException | IOException throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    @Override
    public void updateProgression(Analysis a, int total) {
    }
}

