/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.cluster;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringAnalysis;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import java.io.IOException;
import java.util.TreeMap;

public class ClusteringCsvOutput
implements AnalysisObserver {
    private String csv;

    public ClusteringCsvOutput(String csv) {
        this.csv = csv;
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
        ClusteringAnalysis ca = (ClusteringAnalysis)ma;
        switch (state) {
            case DONE: {
                TreeMap<Integer, PixelComposite> map = new TreeMap<Integer, PixelComposite>();
                for (Raster raster : ((RasterComposite)ca.getResult()).getRasters()) {
                    map.put(((PixelComposite)raster).getValue(), (PixelComposite)raster);
                }
                CsvWriter cw = new CsvWriter(this.csv);
                cw.setDelimiter(';');
                try {
                    cw.write("id");
                    cw.write("type");
                    cw.write("count");
                    cw.write("area");
                    cw.endRecord();
                    for (PixelComposite pc : map.values()) {
                        cw.write(pc.getValue() + "");
                        cw.write((int)pc.getUserData() + "");
                        cw.write(pc.size() + "");
                        cw.write(pc.getArea() + "");
                        cw.endRecord();
                    }
                    cw.close();
                    break;
                }
                catch (CsvWriter.FinalizedException | IOException throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    @Override
    public void updateProgression(Analysis a, int total) {
    }
}

