/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixAnalysis;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IdClusteringAnalysis
extends MatrixAnalysis {
    private int value;

    public IdClusteringAnalysis(Matrix m) {
        super(m);
    }

    @Override
    public void doInit() {
        this.value = Raster.getNoDataValue();
    }

    @Override
    public void doRun() {
        RasterComposite r = new RasterComposite();
        Matrix ever = MatrixFactory.get(this.matrix().getType()).create(this.matrix());
        ever.init(0.0);
        for (Pixel p : this.matrix()) {
            if (ever.get(p) != 0.0) continue;
            ever.put(p, 1.0);
            if (!this.condition1(this.matrix(), p)) continue;
            r.addSimplePixelComposite(this.diffuseFromPixel(this.matrix(), p, ever, new ArrayList<Pixel>(), new PixelComposite(p)));
        }
        this.setResult(r.smooth());
    }

    @Override
    public Raster getResult() {
        return (Raster)super.getResult();
    }

    private boolean condition1(Matrix m, Pixel p) {
        if (m.get(p) != (double)Raster.getNoDataValue()) {
            this.value = (int)m.get(p);
            return true;
        }
        return false;
    }

    private PixelComposite diffuseFromPixel(Matrix m, Pixel p, Matrix ever, List<Pixel> next, PixelComposite pc) {
        Iterator<Pixel> ite = p.getMargins();
        while (ite.hasNext()) {
            Pixel np = ite.next();
            if (ever.get(np) != 0.0 || m.get(np) != (double)this.value) continue;
            pc.addSimplePixel(np);
            next.add(np);
            ever.put(np, 1.0);
        }
        if (next.size() == 0) {
            this.value = Raster.getNoDataValue();
            return pc;
        }
        return this.diffuseFromPixel(m, next.remove(0), ever, next, pc);
    }

    @Override
    public void doClose() {
    }
}

