# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CRSTools
                                 A QGIS plugin
 Check, define and convert CRS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-05-25
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Hieu Van
        email                : hieuvan@disroot.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QFileInfo, QFile
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QFileDialog, QTableWidgetItem
from qgis.core import QgsProject, QgsVectorFileWriter,QgsCoordinateReferenceSystem, QgsVectorLayer
from qgis.core import QgsCoordinateReferenceSystem as Hoh

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .crs_tools_dialog import CRSToolsDialog
from .convertDialog import ConvertVN2000Dialog
from .checkDialog import CoordSysCheckerDialog
from .defineDialog import DefineDialog

import os.path


class CheckDefConv:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CheckDefConv_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = CRSToolsDialog()
        self.dlg1 = CoordSysCheckerDialog()
        self.dlg2 = DefineDialog()
        self.dlg3 = ConvertVN2000Dialog()

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Check, Defined and Convert CRS')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'CheckDefConv')
        self.toolbar.setObjectName(u'CheckDefConv')

        # Add SELECT OUTPUT
        self.dlg3.lineEdit.clear()
        self.dlg3.toolButton.clicked.connect(self.select_output)

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CheckDefConv', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/crs_tools/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Kiểm tra, định nghĩa lại HTĐ, chuyển hệ tọa độ VN2000'),
            callback=self.run,
            parent=self.iface.mainWindow())

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Check, Defined and Convert CRS'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    # Select output file
    def select_output(self):
        output_dir = QFileDialog.getExistingDirectory(self.dlg3, "Chọn thư mục để lưu", "")
        self.dlg3.lineEdit.setText(output_dir)

    def run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.dlg.show()

        self.dlg.pushButton.clicked.connect(self.check)
        self.dlg.pushButton_2.clicked.connect(self.define)
        self.dlg.pushButton_3.clicked.connect(self.convert)

    def check(self):
        # Create layer list
        layers = QgsProject.instance().mapLayers().values()

        class LayerInfo:
            name = ""
            crs = ""

        # Generate data table
        self.dlg1.tableWidget.clear()
        self.dlg1.tableWidget.setRowCount(len(layers))
        self.dlg1.tableWidget.setColumnCount(2)
        self.dlg1.tableWidget.setColumnWidth(0, 300)
        self.dlg1.tableWidget.horizontalHeader().setStretchLastSection(True)

        self.dlg1.tableWidget.setHorizontalHeaderItem(0, QTableWidgetItem("Layer name"))
        self.dlg1.tableWidget.setHorizontalHeaderItem(1, QTableWidgetItem("CRS"))

        # Iterate over all loaded layers
        layer_list = []
        layer_count = 0

        for layer in layers:
            layer_count += 1

            layer_list.append(LayerInfo)
            layer_list[layer_count - 1].name = layer.name()
            layer_list[layer_count - 1].crs = self.find_crs(layer)

            self.dlg1.tableWidget.setItem(layer_count - 1, 0, QTableWidgetItem(layer.name()))
            self.dlg1.tableWidget.setItem(layer_count - 1, 1, QTableWidgetItem(self.find_crs(layer)))

        self.dlg1.tableWidget.move(0, 0)

        # def save_to_file():
        #     dialog = QFileDialog()
        #     name = dialog.getSaveFileName(None, "Export result to CSV", "", "CSV file (*.csv)")
        #     if name[0] == "":
        #         return None
        #
        #     save_file = open(name[0], 'w')
        #
        #     for i in layer_list:
        #         save_file.write("%s,%s\n" % (i.name, i.crs))
        #
        #     save_file.close()

        self.dlg1.show()
        # self.dlg1.pushButton.clicked.connect(save_to_file)

    def define(self):
        # Create layer list
        layers = QgsProject.instance().mapLayers().values()

        layer_list = []
        for layer in layers:
            if layer.type() == 0:
                layer_list.append(layer.name())

        self.dlg2.listWidget.clear()
        self.dlg2.listWidget.addItems(layer_list)

        def run():
            htd = self.dlg2.comboBox.currentText()
            for f in layers:
                if f.type() == 0 and self.crs_object(f, htd) != 'System':
                    f.setCrs(self.crs_object(f, htd))

        self.dlg2.show()
        self.dlg2.button_box.accepted.connect(run)

    @staticmethod
    def crs_object(layer, crs_string):
        # CRS (Proj4 format) declaration

        # UTM & WGS 84
        htd_utm_48 = "+proj=utm +zone=48 +datum=WGS84 +units=m +no_defs"
        htd_utm_49 = "+proj=utm +zone=49 +datum=WGS84 +units=m +no_defs"
        htd_4326 = "+proj=longlat +datum=WGS84 +no_defs"

        # VN-2000 Hoi nhap mui 3
        htd_102_hn = "+proj=tmerc +lat_0=0 +lon_0=102 +k=0.9999 +x_0=500000 +y_0=0 " \
                     "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836," \
                     "-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_103_hn = "+proj=tmerc +lat_0=0 +lon_0=103 +k=0.9999 +x_0=500000 +y_0=0 " \
                     "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                     "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_104_hn = "+proj=tmerc +lat_0=0 +lon_0=104 +k=0.9999 +x_0=500000 " \
                     "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                     "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_104_5_hn = "+proj=tmerc +lat_0=0 +lon_0=104.5 +k=0.9999 +x_0=500000 " \
                       "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                       "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_104_75_hn = "+proj=tmerc +lat_0=0 +lon_0=104.75 +k=0.9999 +x_0=500000 " \
                        "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                        "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_105_hn = "+proj=tmerc +lat_0=0 +lon_0=105 +k=0.9999 +x_0=500000 +y_0=0 " \
                     "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                     "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_105_5_hn = "+proj=tmerc +lat_0=0 +lon_0=105.5 +k=0.9999 +x_0=500000 " \
                       "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                       "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_105_75_hn = "+proj=tmerc +lat_0=0 +lon_0=105.75 +k=0.9999 +x_0=500000 " \
                        "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                        "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_106_hn = "+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9999 +x_0=500000 +y_0=0 " \
                     "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                     "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_106_25_hn = "+proj=tmerc +lat_0=0 +lon_0=106.25 +k=0.9999 +x_0=500000 " \
                        "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                        "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_106_5_hn = "+proj=tmerc +lat_0=0 +lon_0=106.5 +k=0.9999 +x_0=500000 +y_0=0 " \
                       "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                       "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_hn = "+proj=tmerc +lat_0=0 +lon_0=107 +k=0.9999 +x_0=500000 +y_0=0 " \
                     "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                     "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_25_hn = "+proj=tmerc +lat_0=0 +lon_0=107.25 +k=0.9999 +x_0=500000" \
                        " +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                        "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_5_hn = "+proj=tmerc +lat_0=0 +lon_0=107.5 +k=0.9999 +x_0=500000 " \
                       "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                       "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_75_hn = "+proj=tmerc +lat_0=0 +lon_0=107.75 +k=0.9999 +x_0=500000" \
                        " +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                        "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_108_hn = "+proj=tmerc +lat_0=0 +lon_0=108 +k=0.9999 +x_0=500000 +y_0=0" \
                     " +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                     "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_108_25_hn = "+proj=tmerc +lat_0=0 +lon_0=108.25 +k=0.9999 +x_0=500000 " \
                        "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                        "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_108_5_hn = "+proj=tmerc +lat_0=0 +lon_0=108.5 +k=0.9999 +x_0=500000 " \
                       "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279," \
                       "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"

        # Create custom CRS objects
        crs_custom_102 = Hoh().fromProj4(htd_102_hn)
        crs_custom_103 = Hoh().fromProj4(htd_103_hn)
        crs_custom_104 = Hoh().fromProj4(htd_104_hn)
        crs_custom_104_5 = Hoh().fromProj4(htd_104_5_hn)
        crs_custom_104_75 = Hoh().fromProj4(htd_104_75_hn)
        crs_custom_105 = Hoh().fromProj4(htd_105_hn)
        crs_custom_105_5 = Hoh().fromProj4(htd_105_5_hn)
        crs_custom_105_75 = Hoh().fromProj4(htd_105_75_hn)
        crs_custom_106 = Hoh().fromProj4(htd_106_hn)
        crs_custom_106_25 = Hoh().fromProj4(htd_106_25_hn)
        crs_custom_106_5 = Hoh().fromProj4(htd_106_5_hn)
        crs_custom_107 = Hoh().fromProj4(htd_107_hn)
        crs_custom_107_25 = Hoh().fromProj4(htd_107_25_hn)
        crs_custom_107_5 = Hoh().fromProj4(htd_107_5_hn)
        crs_custom_107_75 = Hoh().fromProj4(htd_107_75_hn)
        crs_custom_108 = Hoh().fromProj4(htd_108_hn)
        crs_custom_108_25 = Hoh().fromProj4(htd_108_25_hn)
        crs_custom_108_5 = Hoh().fromProj4(htd_108_5_hn)

        if crs_string == "UTM Zone 48N - EPSG:32648":
            return Hoh().fromProj4(htd_utm_48)
        elif crs_string == 'System':
            return layer.crs()
        elif crs_string == "UTM Zone 49N - EPSG:32649":
            return Hoh().fromProj4(htd_utm_49)
        elif crs_string == "WGS 84 Lat/long - EPSG:4326":
            return Hoh().fromProj4(htd_4326)
        elif crs_string == "VN-2000 mui 3 KTT 102" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 102":
            return crs_custom_102
        elif crs_string == "VN-2000 mui 3 KTT 103" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 103":
            return crs_custom_103
        elif crs_string == "VN-2000 mui 3 KTT 104" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 104":
            return crs_custom_104
        elif crs_string == "VN-2000 mui 3 KTT 104.5" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 104.5":
            return crs_custom_104_5
        elif crs_string == "VN-2000 mui 3 KTT 104.75" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 104.75":
            return crs_custom_104_75
        elif crs_string == "VN-2000 mui 3 KTT 105" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 105":
            return crs_custom_105
        elif crs_string == "VN-2000 mui 3 KTT 105.5" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 105.5":
            return crs_custom_105_5
        elif crs_string == "VN-2000 mui 3 KTT 105.75" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 105.75":
            return crs_custom_105_75
        elif crs_string == "VN-2000 mui 3 KTT 106" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 106":
            return crs_custom_106
        elif crs_string == "VN-2000 mui 3 KTT 106.25" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 106.25":
            return crs_custom_106_25
        elif crs_string == "VN-2000 mui 3 KTT 106.5" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 106.5":
            return crs_custom_106_5
        elif crs_string == "VN-2000 mui 3 KTT 107" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 107":
            return crs_custom_107
        elif crs_string == "VN-2000 mui 3 KTT 107.25" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 107.25":
            return crs_custom_107_25
        elif crs_string == "VN-2000 mui 3 KTT 107.5" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 107.5":
            return crs_custom_107_5
        elif crs_string == "VN-2000 mui 3 KTT 107.75" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 107.75":
            return crs_custom_107_75
        elif crs_string == "VN-2000 mui 3 KTT 108" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 108":
            return crs_custom_108
        elif crs_string == "VN-2000 mui 3 KTT 108.25" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 108.25":
            return crs_custom_108_25
        elif crs_string == "VN-2000 mui 3 KTT 108.5" or crs_string == "VN-2000 Hoi nhap mui 3 KTT 108.5":
            return crs_custom_108_5
        else:
            raise Exception("CRS corresponding with passed name is unknown")

    @staticmethod
    def find_crs(layer_object):
        # Declaration of coordinate systems - Taken from checkcoordinatesystem plugin

        # VN2000 Noi bo mui 3
        htd_103_nb = "+proj=tmerc +lat_0=0 +lon_0=103 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                     "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_104_nb = "+proj=tmerc +lat_0=0 +lon_0=104 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                     "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_104_5_nb = "+proj=tmerc +lat_0=0 +lon_0=104.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                       "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_104_75_nb = "+proj=tmerc +lat_0=0 +lon_0=104.75 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                        "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_105_nb = "+proj=tmerc +lat_0=0 +lon_0=105 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                     "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_105_5_nb = "+proj=tmerc +lat_0=0 +lon_0=105.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                       "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_105_75_nb = "+proj=tmerc +lat_0=0 +lon_0=105.75 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                        "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_106_nb = "+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                     "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_106_25_nb = "+proj=tmerc +lat_0=0 +lon_0=106.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                        "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_106_5_nb = "+proj=tmerc +lat_0=0 +lon_0=106.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                       "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_107_nb = "+proj=tmerc +lat_0=0 +lon_0=107 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                     "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_107_25_nb = "+proj=tmerc +lat_0=0 +lon_0=107.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                        "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_107_5_nb = "+proj=tmerc +lat_0=0 +lon_0=107.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                       "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_107_75_nb = "+proj=tmerc +lat_0=0 +lon_0=107.75 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                        "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_108_nb = "+proj=tmerc +lat_0=0 +lon_0=108 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                     "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_108_25_nb = "+proj=tmerc +lat_0=0 +lon_0=108.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                        "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
        htd_108_5_nb = "+proj=tmerc +lat_0=0 +lon_0=108.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                       "+towgs84=0,0,0,0,0,0,0 +units=m +no_defs"

        # VN2000 Hoi nhap mui 3
        htd_103_hn = "+proj=tmerc +lat_0=0 +lon_0=103 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                     "+towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836," \
                     "-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_104_hn = "+proj=tmerc +lat_0=0 +lon_0=104 +k=0.9999 +x_0=500000 +y_0=0 " \
                     "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                     "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_104_5_hn = "+proj=tmerc +lat_0=0 +lon_0=104_5 +k=0.9999 +x_0=500000 +y_0=0 " \
                       "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                       "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_104_75_hn = "+proj=tmerc +lat_0=0 +lon_0=104.75 +k=0.9999 +x_0=500000 +y_0=0 " \
                        "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                        "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_105_hn = "+proj=tmerc +lat_0=0 +lon_0=105 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 " \
                     "+towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836," \
                     "-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_105_5_hn = "+proj=tmerc +lat_0=0 +lon_0=105.5 +k=0.9999 +x_0=500000 +y_0=0 " \
                       "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                       "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_105_75_hn = "+proj=tmerc +lat_0=0 +lon_0=105.75 +k=0.9999 +x_0=500000 +y_0=0 " \
                        "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                        "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_106_hn = "+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9999 +x_0=500000 +y_0=0 " \
                     "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                     "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_106_25_hn = "+proj=tmerc +lat_0=0 +lon_0=106.25 +k=0.9999 +x_0=500000 +y_0=0 " \
                        "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                        "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_106_5_hn = "+proj=tmerc +lat_0=0 +lon_0=106.5 +k=0.9999 +x_0=500000 +y_0=0 " \
                       "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                       "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_hn = "+proj=tmerc +lat_0=0 +lon_0=107 +k=0.9999 +x_0=500000 +y_0=0 " \
                     "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                     "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_25_hn = "+proj=tmerc +lat_0=0 +lon_0=107.25 +k=0.9999 +x_0=500000 +y_0=0 " \
                        "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                        "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_5_hn = "+proj=tmerc +lat_0=0 +lon_0=107.5 +k=0.9999 +x_0=500000 +y_0=0 " \
                       "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                       "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_75_hn = "+proj=tmerc +lat_0=0 +lon_0=107.75 +k=0.9999 +x_0=500000 +y_0=0 " \
                        "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                        "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_108_hn = "+proj=tmerc +lat_0=0 +lon_0=108 +k=0.9999 +x_0=500000 +y_0=0 " \
                     "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                     "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_108_25_hn = "+proj=tmerc +lat_0=0 +lon_0=108.25 +k=0.9999 +x_0=500000 +y_0=0 " \
                        "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                        "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_108_5_hn = "+proj=tmerc +lat_0=0 +lon_0=108.5 +k=0.9999 +x_0=500000 +y_0=0 " \
                       "+ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835," \
                       "0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"

        # UTM 48, 49
        htd_utm_48 = "+proj=utm +zone=48 +datum=WGS84 +units=m +no_defs"
        htd_utm_49 = "+proj=utm +zone=49 +datum=WGS84 +units=m +no_defs"

        # WGS84 Lat/Long - 4326
        htd_latlong_4326 = "+proj=longlat +datum=WGS84 +no_defs"

        if layer_object.crs().toProj4() == htd_103_nb:
            return "VN-2000 Noi bo KTT 103 mui 3"
        elif layer_object.crs().toProj4() == htd_104_nb:
            return "VN-2000 Noi bo KTT 104 mui 3"
        elif layer_object.crs().toProj4() == htd_104_5_nb:
            return "VN-2000 Noi bo KTT 104.5 mui 3"
        elif layer_object.crs().toProj4() == htd_104_75_nb:
            return "VN-2000 Noi bo KTT 104.75 mui 3"
        elif layer_object.crs().toProj4() == htd_105_nb:
            return "VN-2000 Noi bo KTT 105 mui 3"
        elif layer_object.crs().toProj4() == htd_105_5_nb:
            return "VN-2000 Noi bo KTT 105.5 mui 3"
        elif layer_object.crs().toProj4() == htd_105_75_nb:
            return "VN-2000 Noi bo KTT 105.75 mui 3"
        elif layer_object.crs().toProj4() == htd_106_nb:
            return "VN-2000 Noi bo KTT 106 mui 3"
        elif layer_object.crs().toProj4() == htd_106_25_nb:
            return "VN-2000 Noi bo KTT 106.25 mui 3"
        elif layer_object.crs().toProj4() == htd_106_5_nb:
            return "VN-2000 Noi bo KTT 106.5 mui 3"
        elif layer_object.crs().toProj4() == htd_107_nb:
            return "VN-2000 Noi bo KTT 107 mui 3"
        elif layer_object.crs().toProj4() == htd_107_25_nb:
            return "VN-2000 Noi bo KTT 107.25 mui 3"
        elif layer_object.crs().toProj4() == htd_107_5_nb:
            return "VN-2000 Noi bo KTT 107.5 mui 3"
        elif layer_object.crs().toProj4() == htd_107_75_nb:
            return "VN-2000 Noi bo KTT 107.75 mui 3"
        elif layer_object.crs().toProj4() == htd_108_nb:
            return "VN-2000 Noi bo KTT 108 mui 3"
        elif layer_object.crs().toProj4() == htd_108_25_nb:
            return "VN-2000 Noi bo KTT 108.25 mui 3"
        elif layer_object.crs().toProj4() == htd_108_5_nb:
            return "VN-2000 Noi bo KTT 108.5 mui 3"
        elif layer_object.crs().toProj4() == htd_103_hn:
            return "VN-2000 Hoi nhap KTT 103 mui 3"
        elif layer_object.crs().toProj4() == htd_104_hn:
            return "VN-2000 Hoi nhap KTT 104 mui 3"
        elif layer_object.crs().toProj4() == htd_104_5_hn:
            return "VN-2000 Hoi nhap KTT 104.5 mui 3"
        elif layer_object.crs().toProj4() == htd_104_75_hn:
            return "VN-2000 Hoi nhap KTT 104.75 mui 3"
        elif layer_object.crs().toProj4() == htd_105_hn:
            return "VN-2000 Hoi nhap KTT 105 mui 3"
        elif layer_object.crs().toProj4() == htd_105_5_hn:
            return "VN-2000 Hoi nhap KTT 105.5 mui 3"
        elif layer_object.crs().toProj4() == htd_105_75_hn:
            return "VN-2000 Hoi nhap KTT 105.75 mui 3"
        elif layer_object.crs().toProj4() == htd_106_hn:
            return "VN-2000 Hoi nhap KTT 106 mui 3"
        elif layer_object.crs().toProj4() == htd_106_25_hn:
            return "VN-2000 Hoi nhap KTT 106.25 mui 3"
        elif layer_object.crs().toProj4() == htd_106_5_hn:
            return "VN-2000 Hoi nhap KTT 106.5 mui 3"
        elif layer_object.crs().toProj4() == htd_107_hn:
            return "VN-2000 Hoi nhap KTT 107 mui 3"
        elif layer_object.crs().toProj4() == htd_107_25_hn:
            return "VN-2000 Hoi nhap KTT 107.25 mui 3"
        elif layer_object.crs().toProj4() == htd_107_5_hn:
            return "VN-2000 Hoi nhap KTT 107.5 mui 3"
        elif layer_object.crs().toProj4() == htd_107_75_hn:
            return "VN-2000 Hoi nhap KTT 107.75 mui 3"
        elif layer_object.crs().toProj4() == htd_108_hn:
            return "VN-2000 Hoi nhap KTT 108 mui 3"
        elif layer_object.crs().toProj4() == htd_108_25_hn:
            return "VN-2000 Hoi nhap KTT 108.25 mui 3"
        elif layer_object.crs().toProj4() == htd_108_5_hn:
            return "VN-2000 Hoi nhap KTT 108.5 mui 3"
        elif layer_object.crs().toProj4() == htd_utm_48:
            return "UTM Zone 48N - EPSG:32648"
        elif layer_object.crs().toProj4() == htd_utm_49:
            return "UTM Zone 49N - EPSG:32649"
        elif layer_object.crs().toProj4() == htd_latlong_4326:
            return "WGS 84 Lat/Long - EPSG:4326"
        else:
            return "Unknown"

    # CONVERT TOOL

    def convert(self):
        """Run method that performs all the real work"""

        # Select the layers open in the legendInterface and add them to an array
        layers = [layer for layer in QgsProject.instance().mapLayers().values()]  # NEW function on QGIS3
        layer_list = []
        # Append only Vector (type == 0) to the layer_list
        for layer in layers:
            if layer.type() == 0:
                layer_list.append(layer.name())
            else:
                pass
        # Add layer_list array to listWidget, clear layer if removed to layer in tools
        self.dlg3.listWidget.clear()
        self.dlg3.listWidget.addItems(layer_list)

        # show the dialog
        self.dlg3.show()
        # Run the dialog event loop
        result = self.dlg3.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            # pass
            output_dir = self.dlg3.lineEdit.text()

            if not os.path.exists(output_dir):
                self.iface.messageBar().pushMessage("Khong co duong dan den thu muc",
                                                    "Vui long chon thu muc de luu file", 1, 5)
            if os.path.exists(output_dir):
                self.save_layers()

    def getCustom(self, htd_output, f):
        # Coordinate UTM, WGS84
        crs_4326 = QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId)
        htd_utm_48 = QgsCoordinateReferenceSystem(32648, QgsCoordinateReferenceSystem.EpsgCrsId)
        htd_utm_49 = QgsCoordinateReferenceSystem(32649, QgsCoordinateReferenceSystem.EpsgCrsId)

        # VN2000 Hoi nhap mui 3
        htd_102_hn = "+proj=tmerc +lat_0=0 +lon_0=102 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_103_hn = "+proj=tmerc +lat_0=0 +lon_0=103 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_104_hn = "+proj=tmerc +lat_0=0 +lon_0=104 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_104_5_hn = "+proj=tmerc +lat_0=0 +lon_0=104.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_104_75_hn = "+proj=tmerc +lat_0=0 +lon_0=104.75 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_105_hn = "+proj=tmerc +lat_0=0 +lon_0=105 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_105_5_hn = "+proj=tmerc +lat_0=0 +lon_0=105.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_105_75_hn = "+proj=tmerc +lat_0=0 +lon_0=105.75 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_106_hn = "+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_106_25_hn = "+proj=tmerc +lat_0=0 +lon_0=106.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_106_5_hn = "+proj=tmerc +lat_0=0 +lon_0=106.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_hn = "+proj=tmerc +lat_0=0 +lon_0=107 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_25_hn = "+proj=tmerc +lat_0=0 +lon_0=107.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_5_hn = "+proj=tmerc +lat_0=0 +lon_0=107.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_107_75_hn = "+proj=tmerc +lat_0=0 +lon_0=107.75 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_108_hn = "+proj=tmerc +lat_0=0 +lon_0=108 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_108_25_hn = "+proj=tmerc +lat_0=0 +lon_0=108.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"
        htd_108_5_hn = "+proj=tmerc +lat_0=0 +lon_0=108.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906278 +units=m +no_defs"

        if htd_output == "System":
            return f.crs()
        elif htd_output == "UTM Zone 48N - EPGS: 32648":
            return htd_utm_48
        elif htd_output == "UTM Zone 49N - EPGS: 32649":
            return htd_utm_49
        elif htd_output == "WGS84 Lat/long - EPGS: 4326":
            return crs_4326
        elif htd_output == "VN2000 mui 3 KTT 102" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 102":
            custom = htd_102_hn
        elif htd_output == "VN2000 mui 3 KTT 103" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 103":
            custom = htd_103_hn
        elif htd_output == "VN2000 mui 3 KTT 104" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 104":
            custom = htd_104_hn
        elif htd_output == "VN2000 mui 3 KTT 104.5" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 104.5":
            custom = htd_104_5_hn
        elif htd_output == "VN2000 mui 3 KTT 104.75" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 104.75":
            custom = htd_104_75_hn
        elif htd_output == "VN2000 mui 3 KTT 105" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 105":
            custom = htd_105_hn
        elif htd_output == "VN2000 mui 3 KTT 105.5" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 105.5":
            custom = htd_105_5_hn
        elif htd_output == "VN2000 mui 3 KTT 105.75" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 105.75":
            custom = htd_105_75_hn
        elif htd_output == "VN2000 mui 3 KTT 106" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 106":
            custom = htd_106_hn
        elif htd_output == "VN2000 mui 3 KTT 106.25" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 106.25":
            custom = htd_106_25_hn
        elif htd_output == "VN2000 mui 3 KTT 106.5" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 106.5":
            custom = htd_106_5_hn
        elif htd_output == "VN2000 mui 3 KTT 107" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 107":
            custom = htd_107_hn
        elif htd_output == "VN2000 mui 3 KTT 107.25" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 107.25":
            custom = htd_107_25_hn
        elif htd_output == "VN2000 mui 3 KTT 107.5" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 107.5":
            custom = htd_107_5_hn
        elif htd_output == "VN2000 mui 3 KTT 107.75" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 107.75":
            custom = htd_107_75_hn
        elif htd_output == "VN2000 mui 3 KTT 108" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 108":
            custom = htd_108_hn
        elif htd_output == "VN2000 mui 3 KTT 108" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 108":
            custom = htd_108_25_hn
        elif htd_output == "VN2000 mui 3 KTT 108.25" or htd_output == "VN-2000 Hoi nhap mui 3 KTT 108.25":
            custom = htd_108_5_hn
        res = QgsCoordinateReferenceSystem()
        res.createFromProj4(custom)
        return res

    # save file shp
    def save_file(self, type):
        layers = [layer for layer in QgsProject.instance().mapLayers().values()]  # NEW function on QGIS3
        if type == 'shp':
            output_dir = self.dlg3.lineEdit.text() + "/"  # + "/KETQUA_SHP/"
        elif type == 'tab':
            output_dir = self.dlg3.lineEdit.text() + "/"  # + "/KETQUA_TAB/"
        htd = self.dlg3.comboBox.currentText()
        htd_output = self.dlg3.comboBox_output.currentText()
        # create directory if it doesn't exist
        if not os.path.exists(output_dir):
            os.makedirs(output_dir)
        for f in layers:
            if f.type() != 0:
                return False
            temp = self.getCustom(htd, f)
            if htd != "System":
                f.setCrs(temp)
            if type == 'shp':
                ext = '.shp'
                writer = QgsVectorFileWriter.writeAsVectorFormat(f, output_dir + f.name() + ".shp", "System",
                                                                 self.getCustom(htd_output, f), "ESRI Shapefile")
            elif type == 'tab':
                ext = '.tab'
                writer = QgsVectorFileWriter.writeAsVectorFormat(f, output_dir + f.name() + ".tab", "System",
                                                                 self.getCustom(htd_output, f), "MapInfo File")
            if writer == QgsVectorFileWriter.NoError:
                self.iface.messageBar().pushMessage("File duoc luu:", f.name() + ext + " tai " + output_dir, 0, 2)
            # else:
            #     self.iface.messageBar().pushMessage("Loi luu file:", f.name() + ext + " tai " + output_dir, 1, 2)

    def save_layers(self):
        # if checkbox is checked, run the appropriate save function
        if self.dlg3.checkBox_shp.isChecked():
            self.save_file('shp')
        else:
            pass
        if self.dlg3.checkBox_tab.isChecked():
            self.save_file('tab')
        else:
            pass
