# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CTDQ
                                 A QGIS plugin
 A suite of handy QGIS tools for Civil/Geo Engineers and Designers
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-08-18
        copyright            : (C) 2025 by CeeThreeDee
        email                : info@ceethreedee.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'CeeThreeDee'
__date__ = '2025-08-18'
__copyright__ = '(C) 2025 by CeeThreeDee'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from CeeThreeDeeQTools.Processing.ctdq_CatchmentsAndStreams import CatchmentsAndStreams
from qgis.core import QgsProcessingProvider, QgsProcessingAlgorithm, Qgis
from qgis.gui import QgisInterface
from processing.core.ProcessingConfig import ProcessingConfig, Setting
from PyQt5.QtGui import QIcon
from PyQt5.QtCore import QFileInfo
from .ctdq_support import ctdprocessing_settingsdefaults
from CeeThreeDeeQTools.Processing import ctdq_AlgoBase,ctdq_AlgoRun, ExportDataSourcesMap, ExportProjectLayerStyles, FindRasterPonds, CalculateStageStoragePond, CatchmentsAndStreams

import os
import inspect


class CTDQProvider(QgsProcessingProvider):

    def __init__(self, iface: QgisInterface):
        """
        Default constructor.
        """        
        self.iface = iface
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass
    def load(self):
        """
        Loads the provider with its settings.
        """
        ProcessingConfig.settingIcons[self.name()] = self.icon()        
        ProcessingConfig.addSetting(Setting(self.name(), "CTDTOOLS_ACTIVATED", "Activate", True))
        
        # Add global processing settings from ctdprocessing_settingsdefaults
        for setting_key, setting_data in ctdprocessing_settingsdefaults.items():
            setting_name = setting_key.upper()  # Convert to uppercase for consistency
            # Register as global settings - use empty string for group to make them global
            ProcessingConfig.addSetting(Setting(
                self.name(), 
                setting_name, 
                setting_data["display_name"], 
                setting_data["value"]
            ))

        ProcessingConfig.readSettings()
        return super().load()

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        """
        self.iface.messageBar().pushMessage("Loading CeeThreeDeeQTools algorithms...")
        processing_algos = [
            m[1] 
            for m in inspect.getmembers(Processing, inspect.isclass)
            if issubclass(m[1], QgsProcessingAlgorithm)
        ]
        """
        """for alg_class in processing_algos:
            try:
                # Check if the constructor takes only 'self'
                sig = inspect.signature(alg_class.__init__)
                params = list(sig.parameters.values())
                # The first parameter should be 'self', so total length should be 1 for no-arg constructor
                if len(params) == 1:
                    alg_instance = alg_class()
                    self.addAlgorithm(alg_instance)
                    self.iface.messageBar().pushMessage(f"Loaded algorithm: {alg_class.__name__}")
                else:
                    self.iface.messageBar().pushWarning("Warning", f"Skipped algorithm {alg_class.__name__}: constructor requires arguments.")
            except Exception as e:
                self.iface.messageBar().pushCritical("Error", f"Error loading algorithm {alg_class.__name__}: {e}") 
        """
        self.addAlgorithm(ExportDataSourcesMap())
        self.addAlgorithm(CatchmentsAndStreams())
        self.addAlgorithm(ExportProjectLayerStyles())      
        self.addAlgorithm(FindRasterPonds())  
        self.addAlgorithm(CalculateStageStoragePond())
        # add additional algorithms here

        # add additional algorithms here

    def id(self):
        return 'CeeThreeDee Qtools'

    def name(self):
        return self.tr('CeeThreeDee Qtools')

    def icon(self):
        """
        Returns the icon for the provider. Ensures the icon file exists.
        """
        #icon_path = os.path.join(ctdpaths["img"], "CTD_logo.png")
        icon_path = os.path.join(os.path.dirname(__file__), "./Assets/img/CTD_logo.png")
        if QFileInfo(icon_path).exists():
            return QIcon(icon_path)
        else:
            # Fallback to a default icon if the file is missing
            return QIcon()

    def longName(self):
        return self.name()
