# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CTDQ
                                 A QGIS plugin
 A suite of handy QGIS tools for Civil/Geo Engineers and Designers
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-08-18
        copyright            : (C) 2025 by CeeThreeDee
        email                : info@ceethreedee.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'CeeThreeDee'
__date__ = '2025-08-18'
__copyright__ = '(C) 2025 by CeeThreeDee'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication, Qgis
from .ctdq_provider import CTDQProvider
from PyQt5.QtWidgets import QAction, QMenu
from PyQt5.QtGui import QIcon, QDesktopServices
from PyQt5.QtCore import QUrl, QCoreApplication, QSettings, QTranslator, QLocale

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class CTDQPlugin(object):

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        self.provider = CTDQProvider(self.iface)
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale (robust to QVariant / different return types)
        raw_locale = QSettings().value("locale/userLocale", QLocale.system().name())
        try:
            # ensure we have a Python string and take the language part
            locale = str(raw_locale)[0:2]
        except Exception:
            locale = QLocale.system().name()[0:2]
        locale_path = os.path.join(self.plugin_dir, "i18n", f"CeeThreeDeeQTOOLS_{locale}.qm")

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if Qgis.QGIS_VERSION_INT > 40303:
                QCoreApplication.installTranslator(self.translator)

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = CTDQProvider(self.iface)
        QgsApplication.processingRegistry().addProvider(self.provider)

    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate("CeeThreeDeeQTools", message)

    def initGui(self):
        self.initProcessing()

        # Add "CeeThreeDee Qtools" as a submenu under the existing "Plugins" menu
        plugins_menu = None
        for action in self.iface.mainWindow().menuBar().actions():
            if action.text() == self.tr("&Plugins"):
                plugins_menu = action.menu()
                break

        if plugins_menu is not None:
            self.menu = QMenu(self.tr("CeeThreeDee Qtools"), plugins_menu)
            plugins_menu.addMenu(self.menu)
        else:
            # Fallback: create menu at top level if Plugins menu not found
            self.menu = QMenu(self.tr("CeeThreeDee Qtools"), self.iface.mainWindow())
            self.iface.mainWindow().menuBar().addMenu(self.menu)

        # Create action for the validation dialog
        self.validateAction = QAction(
            QIcon(os.path.join(os.path.dirname(__file__), "./Assets/img/CTD_logo.png")),
            self.tr("Validate Project Report"),
            self.iface.mainWindow(),
        )
        self.validateAction.triggered.connect(self.openValidationDialog)
        self.menu.addAction(self.validateAction)

        # Create action that will start plugin help
        self.helpAction = QAction(
            QIcon(os.path.join(os.path.dirname(__file__), "./Assets/img/CTD_logo.png")),
            self.tr("CeeThreeDee Qtools Help"),
            self.iface.mainWindow(),
        )
        self.helpAction.triggered.connect(
            lambda: QDesktopServices.openUrl(
                QUrl("https://github.com/Kapanther/CeeThreeDeeQTools")
            )
        )
        self.menu.addAction(self.helpAction)

    def openValidationDialog(self):
        from .Tools.ValidateProjectReport.ctdq_ValidateProjectReportDialog import ValidateProjectReportDialog
        dialog = ValidateProjectReportDialog()
        dialog.exec_()

    def unload(self):
        """
        Unloads the plugin and removes the provider from the processing registry.
        """
        QgsApplication.processingRegistry().removeProvider(self.provider)

        # Remove the "CeeThreeDee Qtools" menu and its actions
        if self.menu:
            self.menu.clear()
            self.iface.mainWindow().menuBar().removeAction(self.menu.menuAction())
            self.menu = None

        del self.validateAction
        del self.helpAction