# -*- coding: utf-8 -*-
# Fonte: https://github.com/opendatasicilia/comuni-italiani
# Codici catastali (Belfiore) dei comuni italiani con provincia

# COMUNI_BY_PROV: {sigla_prov: [(codice_belfiore, nome_comune), ...]}
COMUNI_BY_PROV = {
    'AG': [('A089', 'AGRIGENTO'), ('A181', 'ALESSANDRIA DELLA ROCCA'), ('A351', 'ARAGONA'), ('A896', 'BIVONA'), ('B275', 'BURGIO'), ('B377', 'CALAMONACI'), ('B427', 'CALTABELLOTTA'), ('B460', 'CAMASTRA'), ('B486', 'CAMMARATA'), ('B520', 'CAMPOBELLO DI LICATA'), ('B602', 'CANICATTÌ'), ('C275', 'CASTELTERMINI'), ('C341', 'CASTROFILIPPO'), ('C356', 'CATTOLICA ERACLEA'), ('C668', 'CIANCIANA'), ('C928', 'COMITINI'), ('D514', 'FAVARA'), ('E209', 'GROTTE'), ('E390', 'JOPPOLO GIANCAXIO'), ('E431', 'LAMPEDUSA E LINOSA'), ('E573', 'LICATA'), ('E714', 'LUCCA SICULA'), ('F126', 'MENFI'), ('F414', 'MONTALLEGRO'), ('F655', 'MONTEVAGO'), ('F845', 'NARO'), ('G282', 'PALMA DI MONTECHIARO'), ('F299', 'PORTO EMPEDOCLE'), ('H148', 'RACALMUTO'), ('H159', 'RAFFADALI'), ('H194', 'RAVANUSA'), ('H205', 'REALMONTE'), ('H269', 'RIBERA'), ('H743', 'SAMBUCA DI SICILIA'), ('H778', 'SAN BIAGIO PLATANI'), ('H914', 'SAN GIOVANNI GEMINI'), ('I290', "SANT'ANGELO MUXARO"), ('I185', 'SANTA ELISABETTA'), ('I224', 'SANTA MARGHERITA DI BELICE'), ('I356', 'SANTO STEFANO QUISQUINA'), ('I533', 'SCIACCA'), ('I723', 'SICULIANA'), ('L944', 'VILLAFRANCA SICULA')],
    'AL': [('A052', 'ACQUI TERME'), ('A146', 'ALBERA LIGURE'), ('A182', 'ALESSANDRIA'), ('A189', 'ALFIANO NATTA'), ('A197', 'ALICE BEL COLLE'), ('M397', 'ALLUVIONI PIOVERA'), ('A227', 'ALTAVILLA MONFERRATO'), ('A245', 'ALZANO SCRIVIA'), ('A436', 'ARQUATA SCRIVIA'), ('A523', 'AVOLASCA'), ('A605', 'BALZOLA'), ('A689', 'BASALUZZO'), ('A708', 'BASSIGNANA'), ('A738', 'BELFORTE MONFERRATO'), ('A793', 'BERGAMASCO'), ('A813', 'BERZANO DI TORTONA'), ('A889', 'BISTAGNO'), ('A998', 'BORGHETTO DI BORBERA'), ('B037', 'BORGO SAN MARTINO'), ('B029', 'BORGORATTO ALESSANDRINO'), ('B071', 'BOSCO MARENGO'), ('B080', 'BOSIO'), ('B109', 'BOZZOLE'), ('B179', 'BRIGNANO-FRASCATA'), ('B311', 'CABELLA LIGURE'), ('B453', 'CAMAGNA MONFERRATO'), ('B482', 'CAMINO'), ('B629', 'CANTALUPO LIGURE'), ('B701', "CAPRIATA D'ORBA"), ('B736', 'CARBONARA SCRIVIA'), ('B765', 'CARENTINO'), ('B769', 'CAREZZANO'), ('B818', 'CARPENETO'), ('B836', 'CARREGA LIGURE'), ('B840', 'CARROSIO'), ('B847', 'CARTOSIO'), ('B870', 'CASAL CERMELLI'), ('B885', 'CASALE MONFERRATO'), ('B882', 'CASALEGGIO BOIRO'), ('B902', 'CASALNOCETO'), ('B941', 'CASASCO'), ('M388', 'CASSANO SPINOLA'), ('C027', 'CASSINE'), ('C030', 'CASSINELLE'), ('C137', 'CASTELLANIA COPPI'), ('C142', 'CASTELLAR GUIDOBONO'), ('C148', 'CASTELLAZZO BORMIDA'), ('C156', "CASTELLETTO D'ERRO"), ('C158', "CASTELLETTO D'ORBA"), ('C160', 'CASTELLETTO MERLI'), ('C162', 'CASTELLETTO MONFERRATO'), ('C229', 'CASTELNUOVO BORMIDA'), ('C243', 'CASTELNUOVO SCRIVIA'), ('C274', 'CASTELSPINA'), ('C387', 'CAVATORE'), ('C432', 'CELLA MONTE'), ('C503', 'CERESETO'), ('C507', 'CERRETO GRUE'), ('C531', 'CERRINA MONFERRATO'), ('C962', 'CONIOLO'), ('C977', 'CONZANO'), ('D102', 'COSTA VESCOVATO'), ('D149', 'CREMOLINO'), ('D272', 'DENICE'), ('D277', 'DERNICE'), ('D447', 'FABBRICA CURONE'), ('D528', 'FELIZZANO'), ('D559', 'FRACONALTO'), ('D759', 'FRANCAVILLA BISIO'), ('D770', 'FRASCARO'), ('D777', 'FRASSINELLO MONFERRATO'), ('D780', 'FRASSINETO PO'), ('D797', 'FRESONARA'), ('D813', 'FRUGAROLO'), ('D814', 'FUBINE MONFERRATO'), ('D835', 'GABIANO'), ('D890', 'GAMALERO'), ('D910', 'GARBAGNA'), ('D944', 'GAVI'), ('E015', 'GIAROLE'), ('E164', 'GREMIASCO'), ('E188', 'GROGNARDO'), ('E191', 'GRONDONA'), ('E255', 'GUAZZORA'), ('E360', "ISOLA SANT'ANTONIO"), ('E543', 'LERMA'), ('M420', 'LU E CUCCARO MONFERRATO'), ('E870', 'MALVICINO'), ('F015', 'MASIO'), ('F096', 'MELAZZO'), ('F131', 'MERANA'), ('F232', 'MIRABELLO MONFERRATO'), ('F281', 'MOLARE'), ('F293', 'MOLINO DEI TORTI'), ('F313', 'MOMBELLO MONFERRATO'), ('F320', 'MOMPERONE'), ('F337', 'MONCESTINO'), ('F365', 'MONGIARDINO LIGURE'), ('F374', 'MONLEALE'), ('F387', 'MONTACUTO'), ('F403', 'MONTALDEO'), ('F404', 'MONTALDO BORMIDA'), ('F455', 'MONTECASTELLO'), ('F469', "MONTECHIARO D'ACQUI"), ('F518', 'MONTEGIOCO'), ('F562', 'MONTEMARZINO'), ('F707', 'MORANO SUL PO'), ('F713', 'MORBELLO'), ('F737', 'MORNESE'), ('F751', 'MORSASCO'), ('F814', 'MURISENGO'), ('F965', 'NOVI LIGURE'), ('F995', 'OCCIMIANO'), ('F997', 'ODALENGO GRANDE'), ('F998', 'ODALENGO PICCOLO'), ('G042', 'OLIVOLA'), ('G124', 'ORSARA BORMIDA'), ('G193', 'OTTIGLIO'), ('G197', 'OVADA'), ('G199', 'OVIGLIO'), ('G204', 'OZZANO MONFERRATO'), ('G215', 'PADERNA'), ('G334', 'PARETO'), ('G338', 'PARODI LIGURE'), ('G367', 'PASTURANA'), ('G397', 'PECETTO DI VALENZA'), ('G619', 'PIETRA MARAZZI'), ('G807', 'POMARO MONFERRATO'), ('G839', 'PONTECURONE'), ('G858', 'PONTESTURA'), ('G861', 'PONTI'), ('G872', 'PONZANO MONFERRATO'), ('G877', 'PONZONE'), ('G960', 'POZZOL GROPPO'), ('G961', 'POZZOLO FORMIGARO'), ('G987', 'PRASCO'), ('H021', 'PREDOSA'), ('H104', 'QUARGNENTO'), ('H121', 'QUATTORDIO'), ('H272', 'RICALDONE'), ('H334', 'RIVALTA BORMIDA'), ('H343', 'RIVARONE'), ('H414', 'ROCCA GRIMALDA'), ('H406', 'ROCCAFORTE LIGURE'), ('H465', 'ROCCHETTA LIGURE'), ('H569', 'ROSIGNANO MONFERRATO'), ('H677', 'SALA MONFERRATO'), ('H694', 'SALE'), ('H810', 'SAN CRISTOFORO'), ('H878', 'SAN GIORGIO MONFERRATO'), ('I144', 'SAN SALVATORE MONFERRATO'), ('I150', 'SAN SEBASTIANO CURONE'), ('I190', "SANT'AGATA FOSSILI"), ('I429', 'SARDIGLIANO'), ('I432', 'SAREZZANO'), ('I645', 'SERRALUNGA DI CREA'), ('I657', 'SERRAVALLE SCRIVIA'), ('I711', 'SEZZADIO'), ('I738', "SILVANO D'ORBA"), ('I798', 'SOLERO'), ('I808', 'SOLONGHELLO'), ('I901', 'SPIGNO MONFERRATO'), ('I911', 'SPINETO SCRIVIA'), ('I941', 'STAZZANO'), ('I977', 'STREVI'), ('L027', 'TAGLIOLO MONFERRATO'), ('L059', 'TASSAROLO'), ('L139', 'TERRUGGIA'), ('L143', 'TERZO'), ('L165', 'TICINETO'), ('L304', 'TORTONA'), ('L403', 'TREVILLE'), ('L432', 'TRISOBBIO'), ('L570', 'VALENZA'), ('L633', 'VALMACCA'), ('L881', 'VIGNALE MONFERRATO'), ('L887', 'VIGNOLE BORBERA'), ('L904', 'VIGUZZOLO'), ('L931', 'VILLADEATI'), ('L963', 'VILLALVERNIA'), ('L970', 'VILLAMIROGLIO'), ('L972', 'VILLANOVA MONFERRATO'), ('M009', 'VILLAROMAGNANO'), ('M077', 'VISONE'), ('M120', 'VOLPEDO'), ('M121', 'VOLPEGLINO'), ('M123', 'VOLTAGGIO')],
    'AN': [('A092', 'AGUGLIANO'), ('A271', 'ANCONA'), ('A366', 'ARCEVIA'), ('A626', 'BARBARA'), ('A769', 'BELVEDERE OSTRENSE'), ('B468', 'CAMERANO'), ('B470', 'CAMERATA PICENA'), ('C060', 'CASTELBELLINO'), ('C100', 'CASTELFIDARDO'), ('C152', 'CASTELLEONE DI SUASA'), ('C248', 'CASTELPLANIO'), ('C524', "CERRETO D'ESI"), ('C615', 'CHIARAVALLE'), ('D007', 'CORINALDO'), ('D211', 'CUPRAMONTANA'), ('D451', 'FABRIANO'), ('D472', 'FALCONARA MARITTIMA'), ('D597', 'FILOTTRANO'), ('D965', 'GENGA'), ('E388', 'JESI'), ('E690', 'LORETO'), ('E837', 'MAIOLATI SPONTINI'), ('F145', 'MERGO'), ('F381', 'MONSANO'), ('F600', 'MONTE ROBERTO'), ('F634', 'MONTE SAN VITO'), ('F453', 'MONTECAROTTO'), ('F560', 'MONTEMARCIANO'), ('F745', "MORRO D'ALBA"), ('F978', 'NUMANA'), ('G003', 'OFFAGNA'), ('G157', 'OSIMO'), ('F401', 'OSTRA'), ('F581', 'OSTRA VETERE'), ('G771', 'POGGIO SAN MARCELLO'), ('G803', 'POLVERIGI'), ('H575', 'ROSORA'), ('H979', 'SAN MARCELLO'), ('I071', 'SAN PAOLO DI JESI'), ('I251', 'SANTA MARIA NUOVA'), ('I461', 'SASSOFERRATO'), ('I608', 'SENIGALLIA'), ('I643', "SERRA DE' CONTI"), ('I653', 'SERRA SAN QUIRICO'), ('I758', 'SIROLO'), ('I932', 'STAFFOLO'), ('M318', 'TRECASTELLI')],
    'AO': [('A205', 'ALLEIN'), ('A305', 'ANTEY-SAINT-ANDRÉ'), ('A326', 'AOSTA'), ('A424', 'ARNAD'), ('A452', 'ARVIER'), ('A521', 'AVISE'), ('A094', 'AYAS'), ('A108', 'AYMAVILLES'), ('A643', 'BARD'), ('A877', 'BIONAZ'), ('B192', 'BRISSOGNE'), ('B230', 'BRUSSON'), ('C593', 'CHALLAND-SAINT-ANSELME'), ('C594', 'CHALLAND-SAINT-VICTOR'), ('C595', 'CHAMBAVE'), ('B491', 'CHAMOIS'), ('C596', 'CHAMPDEPRAZ'), ('B540', 'CHAMPORCHER'), ('C598', 'CHARVENSOD'), ('C294', 'CHÂTILLON'), ('C821', 'COGNE'), ('D012', 'COURMAYEUR'), ('D338', 'DONNAS'), ('D356', 'DOUES'), ('D402', 'EMARÈSE'), ('D444', 'ETROUBLES'), ('D666', 'FONTAINEMORE'), ('D537', 'FÉNIS'), ('D839', 'GABY'), ('E029', 'GIGNOD'), ('E165', 'GRESSAN'), ('E167', 'GRESSONEY-LA-TRINITÉ'), ('E168', 'GRESSONEY-SAINT-JEAN'), ('E273', 'HÔNE'), ('E306', 'INTROD'), ('E369', 'ISSIME'), ('E371', 'ISSOGNE'), ('E391', 'JOVENÇAN'), ('A308', 'LA MAGDELEINE'), ('E458', 'LA SALLE'), ('E470', 'LA THUILE'), ('E587', 'LILLIANES'), ('F367', 'MONTJOVET'), ('F726', 'MORGEX'), ('F987', 'NUS'), ('G045', 'OLLOMONT'), ('G012', 'OYACE'), ('G459', 'PERLOZ'), ('G794', 'POLLEIN'), ('G854', 'PONT-SAINT-MARTIN'), ('G545', 'PONTBOSET'), ('G860', 'PONTEY'), ('H042', 'PRÉ-SAINT-DIDIER'), ('H110', 'QUART'), ('H262', 'RHÊMES-NOTRE-DAME'), ('H263', 'RHÊMES-SAINT-GEORGES'), ('H497', 'ROISAN'), ('H669', 'SAINT-CHRISTOPHE'), ('H670', 'SAINT-DENIS'), ('H671', 'SAINT-MARCEL'), ('H672', 'SAINT-NICOLAS'), ('H673', 'SAINT-OYEN'), ('H674', 'SAINT-PIERRE'), ('H675', 'SAINT-RHÉMY-EN-BOSSES'), ('H676', 'SAINT-VINCENT'), ('I442', 'SARRE'), ('L217', 'TORGNON'), ('L582', 'VALGRISENCHE'), ('L643', 'VALPELLINE'), ('L647', 'VALSAVARENCHE'), ('L654', 'VALTOURNENCHE'), ('L783', 'VERRAYES'), ('C282', 'VERRÈS'), ('L981', 'VILLENEUVE')],
    'AP': [('A044', 'ACQUASANTA TERME'), ('A047', 'ACQUAVIVA PICENA'), ('A335', 'APPIGNANO DEL TRONTO'), ('A437', 'ARQUATA DEL TRONTO'), ('A462', 'ASCOLI PICENO'), ('B727', 'CARASSAI'), ('C093', 'CASTEL DI LAMA'), ('C321', 'CASTIGNANO'), ('C331', 'CASTORANO'), ('C877', 'COLLI DEL TRONTO'), ('C935', 'COMUNANZA'), ('D096', 'COSSIGNANO'), ('D210', 'CUPRA MARITTIMA'), ('D652', 'FOLIGNANO'), ('D691', 'FORCE'), ('E207', 'GROTTAMMARE'), ('E868', 'MALTIGNANO'), ('F044', 'MASSIGNANO'), ('F380', 'MONSAMPOLO DEL TRONTO'), ('F415', 'MONTALTO DELLE MARCHE'), ('F487', 'MONTEDINOVE'), ('F501', "MONTEFIORE DELL'ASO"), ('F516', 'MONTEGALLO'), ('F570', 'MONTEMONACO'), ('F591', 'MONTEPRANDONE'), ('G005', 'OFFIDA'), ('G289', 'PALMIANO'), ('H321', 'RIPATRANSONE'), ('H390', 'ROCCAFLUVIONE'), ('H588', 'ROTELLA'), ('H769', 'SAN BENEDETTO DEL TRONTO'), ('I912', 'SPINETOLI'), ('L728', 'VENAROTTA')],
    'AQ': [('A018', 'ACCIANO'), ('A100', 'AIELLI'), ('A187', 'ALFEDENA'), ('A318', 'ANVERSA DEGLI ABRUZZI'), ('A481', 'ATELETA'), ('A515', 'AVEZZANO'), ('A603', 'BALSORANO'), ('A656', 'BARETE'), ('A667', 'BARISCIANO'), ('A678', 'BARREA'), ('A884', 'BISEGNA'), ('B256', 'BUGNARA'), ('B358', 'CAGNANO AMITERNO'), ('B382', 'CALASCIO'), ('B526', 'CAMPO DI GIOVE'), ('B569', 'CAMPOTOSTO'), ('B606', 'CANISTRO'), ('B624', 'CANSANO'), ('B651', 'CAPESTRANO'), ('B656', 'CAPISTRELLO'), ('B658', 'CAPITIGNANO'), ('B672', 'CAPORCIANO'), ('B677', 'CAPPADOCIA'), ('B725', 'CARAPELLE CALVISIO'), ('B842', 'CARSOLI'), ('C083', 'CASTEL DEL MONTE'), ('C090', 'CASTEL DI IERI'), ('C096', 'CASTEL DI SANGRO'), ('C126', 'CASTELLAFIUME'), ('C278', 'CASTELVECCHIO CALVISIO'), ('C279', 'CASTELVECCHIO SUBEQUO'), ('C426', 'CELANO'), ('C492', 'CERCHIO'), ('C766', "CIVITA D'ANTINO"), ('C778', 'CIVITELLA ALFEDENA'), ('C783', 'CIVITELLA ROVETO'), ('C811', 'COCULLO'), ('C844', 'COLLARMELE'), ('C862', 'COLLELONGO'), ('C866', 'COLLEPIETRO'), ('C999', 'CORFINIO'), ('D465', 'FAGNANO ALTO'), ('D681', 'FONTECCHIO'), ('D736', 'FOSSA'), ('D850', 'GAGLIANO ATERNO'), ('E040', 'GIOIA DEI MARSI'), ('E096', 'GORIANO SICOLI'), ('E307', 'INTRODACQUA'), ('A345', "L'AQUILA"), ('E505', 'LECCE NEI MARSI'), ('E723', 'LUCO DEI MARSI'), ('E724', 'LUCOLI'), ('E811', "MAGLIANO DE' MARSI"), ('F022', "MASSA D'ALBE"), ('M255', 'MOLINA ATERNO'), ('F595', 'MONTEREALE'), ('F732', 'MORINO'), ('F852', 'NAVELLI'), ('F996', 'OCRE'), ('G002', 'OFENA'), ('G079', 'OPI'), ('G102', 'ORICOLA'), ('G142', 'ORTONA DEI MARSI'), ('G145', 'ORTUCCHIO'), ('G200', 'OVINDOLI'), ('G210', 'PACENTRO'), ('G449', 'PERETO'), ('G484', 'PESCASSEROLI'), ('G492', 'PESCINA'), ('G493', 'PESCOCOSTANZO'), ('G524', 'PETTORANO SUL GIZIO'), ('G726', 'PIZZOLI'), ('G766', 'POGGIO PICENZE'), ('G992', "PRATA D'ANSIDONIA"), ('H007', 'PRATOLA PELIGNA'), ('H056', 'PREZZA'), ('H166', 'RAIANO'), ('H353', 'RIVISONDOLI'), ('H399', 'ROCCA DI BOTTE'), ('H400', 'ROCCA DI CAMBIO'), ('H402', 'ROCCA DI MEZZO'), ('H429', 'ROCCA PIA'), ('H389', 'ROCCACASALE'), ('H434', 'ROCCARASO'), ('H772', 'SAN BENEDETTO DEI MARSI'), ('H773', 'SAN BENEDETTO IN PERILLIS'), ('H819', "SAN DEMETRIO NE' VESTINI"), ('I121', 'SAN PIO DELLE CAMERE'), ('I389', 'SAN VINCENZO VALLE ROVETO'), ('I336', "SANT'EUSANIO FORCONESE"), ('I326', 'SANTE MARIE'), ('I360', 'SANTO STEFANO DI SESSANIO'), ('I501', 'SCANNO'), ('I543', 'SCONTRONE'), ('I546', 'SCOPPITO'), ('I553', 'SCURCOLA MARSICANA'), ('I558', 'SECINARO'), ('I804', 'SULMONA'), ('L025', 'TAGLIACOZZO'), ('L173', 'TIONE DEGLI ABRUZZI'), ('L227', 'TORNIMPARTE'), ('L334', 'TRASACCO'), ('M023', "VILLA SANT'ANGELO"), ('M021', 'VILLA SANTA LUCIA DEGLI ABRUZZI'), ('L958', 'VILLALAGO'), ('M031', 'VILLAVALLELONGA'), ('M041', 'VILLETTA BARREA'), ('M090', 'VITTORITO')],
    'AR': [('A291', 'ANGHIARI'), ('A390', 'AREZZO'), ('A541', 'BADIA TEDALDA'), ('A851', 'BIBBIENA'), ('B243', 'BUCINE'), ('B670', 'CAPOLONA'), ('B693', 'CAPRESE MICHELANGELO'), ('C102', 'CASTEL FOCOGNANO'), ('C263', 'CASTEL SAN NICCOLÒ'), ('M322', 'CASTELFRANCO PIANDISCÒ'), ('C318', 'CASTIGLION FIBOCCHI'), ('C319', 'CASTIGLION FIORENTINO'), ('C407', 'CAVRIGLIA'), ('C648', 'CHITIGNANO'), ('C663', 'CHIUSI DELLA VERNA'), ('C774', 'CIVITELLA IN VAL DI CHIANA'), ('D077', 'CORTONA'), ('D649', 'FOIANO DELLA CHIANA'), ('M392', 'LATERINA PERGINE VALDARNO'), ('E693', 'LORO CIUFFENNA'), ('E718', 'LUCIGNANO'), ('E933', 'MARCIANO DELLA CHIANA'), ('F628', 'MONTE SAN SAVINO'), ('F565', 'MONTEMIGNAIO'), ('F594', 'MONTERCHI'), ('F656', 'MONTEVARCHI'), ('G139', 'ORTIGNANO RAGGIOLO'), ('G653', 'PIEVE SANTO STEFANO'), ('G879', 'POPPI'), ('M329', 'PRATOVECCHIO STIA'), ('H901', 'SAN GIOVANNI VALDARNO'), ('I155', 'SANSEPOLCRO'), ('I681', 'SESTINO'), ('I991', 'SUBBIANO'), ('L038', 'TALLA'), ('L123', 'TERRANUOVA BRACCIOLINI')],
    'AT': [('A072', 'AGLIANO TERME'), ('A173', 'ALBUGNANO'), ('A312', 'ANTIGNANO'), ('A352', 'ARAMENGO'), ('A479', 'ASTI'), ('A527', "AZZANO D'ASTI"), ('A588', "BALDICHIERI D'ASTI"), ('A770', 'BELVEGLIO'), ('A812', 'BERZANO DI SAN PIETRO'), ('B221', 'BRUNO'), ('B236', 'BUBBIO'), ('B306', "BUTTIGLIERA D'ASTI"), ('B376', 'CALAMANDRANA'), ('B418', 'CALLIANO'), ('B425', 'CALOSSO'), ('B469', 'CAMERANO CASASCO'), ('B594', 'CANELLI'), ('B633', 'CANTARANA'), ('B707', 'CAPRIGLIO'), ('B991', 'CASORZO MONFERRATO'), ('C022', 'CASSINASCO'), ('C049', 'CASTAGNOLE DELLE LANZE'), ('C047', 'CASTAGNOLE MONFERRATO'), ('C064', 'CASTEL BOGLIONE'), ('C253', 'CASTEL ROCCHERO'), ('C127', "CASTELL'ALFERO"), ('C154', 'CASTELLERO'), ('C161', 'CASTELLETTO MOLINA'), ('A300', 'CASTELLO DI ANNONE'), ('C226', 'CASTELNUOVO BELBO'), ('C230', 'CASTELNUOVO CALCEA'), ('C232', 'CASTELNUOVO DON BOSCO'), ('C438', 'CELLARENGO'), ('C440', 'CELLE ENOMONDO'), ('C528', "CERRETO D'ASTI"), ('C533', 'CERRO TANARO'), ('C583', 'CESSOLE'), ('C658', "CHIUSANO D'ASTI"), ('C701', 'CINAGLIO'), ('C739', "CISTERNA D'ASTI"), ('C804', 'COAZZOLO'), ('C807', 'COCCONATO'), ('D046', 'CORSIONE'), ('D050', 'CORTANDONE'), ('D051', 'CORTANZE'), ('D052', 'CORTAZZONE'), ('D072', 'CORTIGLIONE'), ('D101', 'COSSOMBRATO'), ('D119', "COSTIGLIOLE D'ASTI"), ('D207', 'CUNICO'), ('D388', 'DUSINO SAN MICHELE'), ('D554', 'FERRERE'), ('D678', 'FONTANILE'), ('D802', 'FRINCO'), ('E134', 'GRANA'), ('E159', 'GRAZZANO BADOGLIO'), ('E295', 'INCISA SCAPACCINO'), ('E338', "ISOLA D'ASTI"), ('E633', 'LOAZZOLO'), ('E917', 'MARANZANA'), ('E944', 'MARETTO'), ('F254', 'MOASCA'), ('F308', 'MOMBALDONE'), ('F311', 'MOMBARUZZO'), ('F316', 'MOMBERCELLI'), ('F323', 'MONALE'), ('F325', 'MONASTERO BORMIDA'), ('F336', 'MONCALVO'), ('F343', 'MONCUCCO TORINESE'), ('F361', 'MONGARDINO'), ('F386', 'MONTABONE'), ('F390', 'MONTAFIA'), ('F409', 'MONTALDO SCARAMPI'), ('F468', "MONTECHIARO D'ASTI"), ('F527', "MONTEGROSSO D'ASTI"), ('F556', 'MONTEMAGNO'), ('M302', 'MONTIGLIO MONFERRATO'), ('F709', 'MORANSENGO'), ('F902', 'NIZZA MONFERRATO'), ('G048', 'OLMO GENTILE'), ('G358', 'PASSERANO MARMORITO'), ('G430', 'PENANGO'), ('G593', 'PIEA'), ('G676', "PINO D'ASTI"), ('G692', 'PIOVÀ MASSAIA'), ('G894', 'PORTACOMARO'), ('H102', 'QUARANTI'), ('H219', 'REFRANCORE'), ('H250', "REVIGLIASCO D'ASTI"), ('H366', 'ROATTO'), ('H376', 'ROBELLA'), ('H392', "ROCCA D'ARAZZO"), ('H451', 'ROCCAVERANO'), ('H466', 'ROCCHETTA PALAFEA'), ('H468', 'ROCCHETTA TANARO'), ('H811', "SAN DAMIANO D'ASTI"), ('H899', 'SAN GIORGIO SCARAMPI'), ('H987', 'SAN MARTINO ALFIERI'), ('I017', 'SAN MARZANO OLIVETO'), ('I076', 'SAN PAOLO SOLBRITO'), ('I555', 'SCURZOLENGO'), ('I637', 'SEROLE'), ('I678', 'SESSAME'), ('I698', 'SETTIME'), ('I781', 'SOGLIO'), ('L168', 'TIGLIOLE'), ('L203', 'TONCO'), ('L204', 'TONENGO'), ('L531', 'VAGLIO SERRA'), ('L574', 'VALFENERA'), ('L807', 'VESIME'), ('L829', 'VIALE'), ('L834', 'VIARIGI'), ('L879', "VIGLIANO D'ASTI"), ('M019', 'VILLA SAN SECONDO'), ('L945', "VILLAFRANCA D'ASTI"), ('L984', "VILLANOVA D'ASTI"), ('M058', 'VINCHIO')],
    'AV': [('A101', 'AIELLO DEL SABATO'), ('A228', 'ALTAVILLA IRPINA'), ('A284', 'ANDRETTA'), ('A347', 'AQUILONIA'), ('A399', 'ARIANO IRPINO'), ('A489', 'ATRIPALDA'), ('A508', 'AVELLA'), ('A509', 'AVELLINO'), ('A566', 'BAGNOLI IRPINO'), ('A580', 'BAIANO'), ('A881', 'BISACCIA'), ('A975', 'BONITO'), ('B367', 'CAIRANO'), ('B374', 'CALABRITTO'), ('B415', 'CALITRI'), ('B590', 'CANDIDA'), ('B674', 'CAPOSELE'), ('B706', 'CAPRIGLIA IRPINA'), ('B776', 'CARIFE'), ('B866', 'CASALBORE'), ('B997', 'CASSANO IRPINO'), ('C058', 'CASTEL BARONIA'), ('C105', 'CASTELFRANCI'), ('C283', 'CASTELVETERE SUL CALORE'), ('C557', 'CERVINARA'), ('C576', 'CESINALI'), ('C606', 'CHIANCHE'), ('C659', 'CHIUSANO DI SAN DOMENICO'), ('C971', 'CONTRADA'), ('C976', 'CONZA DELLA CAMPANIA'), ('D331', 'DOMICELLA'), ('D638', 'FLUMERI'), ('D671', 'FONTANAROSA'), ('D701', 'FORINO'), ('D798', 'FRIGENTO'), ('D998', 'GESUALDO'), ('E161', 'GRECI'), ('E206', 'GROTTAMINARDA'), ('E214', 'GROTTOLELLA'), ('E245', 'GUARDIA LOMBARDI'), ('E397', 'LACEDONIA'), ('E448', 'LAPIO'), ('E487', 'LAURO'), ('E605', 'LIONI'), ('E746', 'LUOGOSANO'), ('E891', 'MANOCALZATI'), ('E997', 'MARZANO DI NOLA'), ('F110', 'MELITO IRPINO'), ('F141', 'MERCOGLIANO'), ('F230', 'MIRABELLA ECLANO'), ('F397', 'MONTAGUTO'), ('F448', 'MONTECALVO IRPINO'), ('F491', 'MONTEFALCIONE'), ('F506', 'MONTEFORTE IRPINO'), ('F511', 'MONTEFREDANE'), ('F512', 'MONTEFUSCO'), ('F546', 'MONTELLA'), ('F559', 'MONTEMARANO'), ('F566', 'MONTEMILETTO'), ('F660', 'MONTEVERDE'), ('M330', 'MONTORO'), ('F744', 'MORRA DE SANCTIS'), ('F762', 'MOSCHIANO'), ('F798', 'MUGNANO DEL CARDINALE'), ('F988', 'NUSCO'), ('G165', "OSPEDALETTO D'ALPINOLO"), ('G242', 'PAGO DEL VALLO DI LAURO'), ('G340', 'PAROLISE'), ('G370', 'PATERNOPOLI'), ('G519', 'PETRURO IRPINO'), ('G611', 'PIETRADEFUSI'), ('G629', 'PIETRASTORNINA'), ('G990', 'PRATA DI PRINCIPATO ULTRA'), ('H006', 'PRATOLA SERRA'), ('H097', 'QUADRELLE'), ('H128', 'QUINDICI'), ('H438', 'ROCCA SAN FELICE'), ('H382', 'ROCCABASCERANA'), ('H592', 'ROTONDI'), ('H733', 'SALZA IRPINA'), ('H975', 'SAN MANGO SUL CALORE'), ('I016', 'SAN MARTINO VALLE CAUDINA'), ('I034', 'SAN MICHELE DI SERINO'), ('I061', 'SAN NICOLA BARONIA'), ('I129', 'SAN POTITO ULTRA'), ('I163', 'SAN SOSSIO BARONIA'), ('I264', "SANT'ANDREA DI CONZA"), ('I280', "SANT'ANGELO A SCALA"), ('I279', "SANT'ANGELO ALL'ESCA"), ('I281', "SANT'ANGELO DEI LOMBARDI"), ('I219', 'SANTA LUCIA DI SERINO'), ('I301', 'SANTA PAOLINA'), ('I357', 'SANTO STEFANO DEL SOLE'), ('I471', 'SAVIGNANO IRPINO'), ('I493', 'SCAMPITELLA'), ('I606', 'SENERCHIA'), ('I630', 'SERINO'), ('I756', 'SIRIGNANO'), ('I805', 'SOLOFRA'), ('I843', 'SORBO SERPICO'), ('I893', 'SPERONE'), ('I990', 'STURNO'), ('L004', 'SUMMONTE'), ('L061', 'TAURANO'), ('L062', 'TAURASI'), ('L102', 'TEORA'), ('L214', 'TORELLA DEI LOMBARDI'), ('L272', 'TORRE LE NOCELLE'), ('L301', 'TORRIONI'), ('L399', 'TREVICO'), ('L461', 'TUFO'), ('L589', 'VALLATA'), ('L616', 'VALLESACCARDA'), ('L739', 'VENTICANO'), ('L965', 'VILLAMAINA'), ('L973', 'VILLANOVA DEL BATTISTA'), ('M130', 'VOLTURARA IRPINA'), ('M203', 'ZUNGOLI')],
    'BA': [('A048', 'ACQUAVIVA DELLE FONTI'), ('A055', 'ADELFIA'), ('A149', 'ALBEROBELLO'), ('A225', 'ALTAMURA'), ('A662', 'BARI'), ('A874', 'BINETTO'), ('A892', 'BITETTO'), ('A893', 'BITONTO'), ('A894', 'BITRITTO'), ('B716', 'CAPURSO'), ('B923', 'CASAMASSIMA'), ('B998', 'CASSANO DELLE MURGE'), ('C134', 'CASTELLANA GROTTE'), ('C436', 'CELLAMARE'), ('C975', 'CONVERSANO'), ('C983', 'CORATO'), ('E038', 'GIOIA DEL COLLE'), ('E047', 'GIOVINAZZO'), ('E155', 'GRAVINA IN PUGLIA'), ('E223', 'GRUMO APPULA'), ('E645', 'LOCOROTONDO'), ('F262', 'MODUGNO'), ('F280', 'MOLA DI BARI'), ('F284', 'MOLFETTA'), ('F376', 'MONOPOLI'), ('F915', 'NOCI'), ('F923', 'NOICATTARO'), ('G291', 'PALO DEL COLLE'), ('G769', 'POGGIORSINI'), ('G787', 'POLIGNANO A MARE'), ('H096', 'PUTIGNANO'), ('H643', 'RUTIGLIANO'), ('H645', 'RUVO DI PUGLIA'), ('H749', 'SAMMICHELE DI BARI'), ('I053', 'SANNICANDRO DI BARI'), ('I330', 'SANTERAMO IN COLLE'), ('L109', 'TERLIZZI'), ('L220', 'TORITTO'), ('L425', 'TRIGGIANO'), ('L472', 'TURI'), ('L571', 'VALENZANO')],
    'BG': [('A057', 'ADRARA SAN MARTINO'), ('A058', 'ADRARA SAN ROCCO'), ('A129', "ALBANO SANT'ALESSANDRO"), ('A163', 'ALBINO'), ('A193', 'ALGUA'), ('A216', 'ALMENNO SAN BARTOLOMEO'), ('A217', 'ALMENNO SAN SALVATORE'), ('A214', 'ALMÈ'), ('A246', 'ALZANO LOMBARDO'), ('A259', 'AMBIVERE'), ('A304', 'ANTEGNATE'), ('A365', 'ARCENE'), ('A383', 'ARDESIO'), ('A440', "ARZAGO D'ADDA"), ('A511', 'AVERARA'), ('A517', 'AVIATICO'), ('A528', 'AZZANO SAN PAOLO'), ('A533', 'AZZONE'), ('A557', 'BAGNATICA'), ('A631', 'BARBATA'), ('A664', 'BARIANO'), ('A684', 'BARZANA'), ('A732', 'BEDULITA'), ('A786', 'BERBENNO'), ('A794', 'BERGAMO'), ('A815', 'BERZO SAN FERMO'), ('A846', 'BIANZANO'), ('A903', 'BLELLO'), ('A937', 'BOLGARE'), ('A950', 'BOLTIERE'), ('A963', 'BONATE SOPRA'), ('A962', 'BONATE SOTTO'), ('B010', 'BORGO DI TERZO'), ('B083', 'BOSSICO'), ('B088', 'BOTTANUCO'), ('B112', 'BRACCA'), ('B123', 'BRANZI'), ('B137', 'BREMBATE'), ('B138', 'BREMBATE DI SOPRA'), ('B178', "BRIGNANO GERA D'ADDA"), ('B217', 'BRUMANO'), ('B223', 'BRUSAPORTO'), ('B393', 'CALCINATE'), ('B395', 'CALCIO'), ('B434', "CALUSCO D'ADDA"), ('B442', 'CALVENZANO'), ('B471', 'CAMERATA CORNELLO'), ('B618', "CANONICA D'ADDA"), ('B661', 'CAPIZZONE'), ('B703', 'CAPRIATE SAN GERVASIO'), ('B710', 'CAPRINO BERGAMASCO'), ('B731', 'CARAVAGGIO'), ('B801', 'CAROBBIO DEGLI ANGELI'), ('B803', 'CARONA'), ('B854', 'CARVICO'), ('B947', 'CASAZZA'), ('B971', "CASIRATE D'ADDA"), ('B978', 'CASNIGO'), ('C007', 'CASSIGLIO'), ('C255', 'CASTEL ROZZONE'), ('C079', 'CASTELLI CALEPIO'), ('C324', 'CASTIONE DELLA PRESOLANA'), ('C337', 'CASTRO'), ('C396', 'CAVERNAGO'), ('C410', "CAZZANO SANT'ANDREA"), ('C456', 'CENATE SOPRA'), ('C457', 'CENATE SOTTO'), ('C459', 'CENE'), ('C506', 'CERETE'), ('C635', "CHIGNOLO D'ISOLA"), ('C649', 'CHIUDUNO'), ('C728', 'CISANO BERGAMASCO'), ('C730', 'CISERANO'), ('C759', 'CIVIDATE AL PIANO'), ('C800', 'CLUSONE'), ('C835', 'COLERE'), ('C894', 'COLOGNO AL SERIO'), ('C910', 'COLZATE'), ('C937', 'COMUN NUOVO'), ('D015', 'CORNA IMAGNA'), ('D016', 'CORNALBA'), ('D066', 'CORTENUOVA'), ('D110', 'COSTA DI MEZZATE'), ('D111', 'COSTA SERINA'), ('D103', 'COSTA VALLE IMAGNA'), ('D117', 'COSTA VOLPINO'), ('D126', 'COVO'), ('D139', 'CREDARO'), ('D221', 'CURNO'), ('D233', 'CUSIO'), ('D245', 'DALMINE'), ('D352', 'DOSSENA'), ('D406', 'ENDINE GAIANO'), ('D411', 'ENTRATICO'), ('D490', "FARA GERA D'ADDA"), ('D491', 'FARA OLIVANA CON SOLA'), ('D588', 'FILAGO'), ('D604', 'FINO DEL MONTE'), ('D606', 'FIORANO AL SERIO'), ('D672', 'FONTANELLA'), ('D684', 'FONTENO'), ('D688', 'FOPPOLO'), ('D697', 'FORESTO SPARSO'), ('D727', 'FORNOVO SAN GIOVANNI'), ('D817', 'FUIPIANO VALLE IMAGNA'), ('D903', 'GANDELLINO'), ('D905', 'GANDINO'), ('D906', 'GANDOSSO'), ('D943', 'GAVERINA TERME'), ('D952', 'GAZZANIGA'), ('E006', 'GHISALBA'), ('E100', 'GORLAGO'), ('E103', 'GORLE'), ('E106', 'GORNO'), ('E148', 'GRASSOBBIO'), ('E189', 'GROMO'), ('E192', 'GRONE'), ('E219', 'GRUMELLO DEL MONTE'), ('E353', 'ISOLA DI FONDRA'), ('E370', 'ISSO'), ('E422', 'LALLIO'), ('E509', 'LEFFE'), ('E524', 'LENNA'), ('E562', 'LEVATE'), ('E640', 'LOCATELLO'), ('E704', 'LOVERE'), ('E751', 'LURANO'), ('E770', 'LUZZANA'), ('E794', 'MADONE'), ('E901', 'MAPELLO'), ('E987', 'MARTINENGO'), ('F085', 'MEDOLAGO'), ('F186', 'MEZZOLDO'), ('F243', "MISANO DI GERA D'ADDA"), ('F276', "MOIO DE' CALVI"), ('F328', 'MONASTEROLO DEL CASTELLO'), ('F547', 'MONTELLO'), ('F720', 'MORENGO'), ('F738', 'MORNICO AL SERIO'), ('F786', 'MOZZANICA'), ('F791', 'MOZZO'), ('F864', 'NEMBRO'), ('G049', 'OLMO AL BREMBO'), ('G050', 'OLTRE IL COLLE'), ('G054', 'OLTRESSENDA ALTA'), ('G068', 'ONETA'), ('G075', 'ONORE'), ('G108', 'ORIO AL SERIO'), ('G118', 'ORNICA'), ('G159', 'OSIO SOPRA'), ('G160', 'OSIO SOTTO'), ('G233', 'PAGAZZANO'), ('G249', 'PALADINA'), ('G259', 'PALAZZAGO'), ('G295', 'PALOSCO'), ('G346', 'PARRE'), ('G350', 'PARZANICA'), ('G412', 'PEDRENGO'), ('G418', 'PEIA'), ('G564', 'PIANICO'), ('G574', 'PIARIO'), ('G579', 'PIAZZA BREMBANA'), ('G583', 'PIAZZATORRE'), ('G588', 'PIAZZOLO'), ('G774', 'POGNANO'), ('F941', 'PONTE NOSSA'), ('G856', 'PONTE SAN PIETRO'), ('G853', 'PONTERANICA'), ('G864', 'PONTIDA'), ('G867', 'PONTIROLO NUOVO'), ('G968', 'PRADALUNGA'), ('H020', 'PREDORE'), ('H036', 'PREMOLO'), ('H046', 'PRESEZZO'), ('H091', 'PUMENENGO'), ('H176', 'RANICA'), ('H177', 'RANZANICO'), ('H331', 'RIVA DI SOLTO'), ('H492', 'ROGNO'), ('H509', 'ROMANO DI LOMBARDIA'), ('H535', 'RONCOBELLO'), ('H544', 'RONCOLA'), ('H584', "ROTA D'IMAGNA"), ('H615', 'ROVETTA'), ('H910', 'SAN GIOVANNI BIANCO'), ('B310', "SAN PAOLO D'ARGON"), ('I079', 'SAN PELLEGRINO TERME'), ('M333', "SANT'OMOBONO TERME"), ('I168', 'SANTA BRIGIDA'), ('I437', 'SARNICO'), ('I506', 'SCANZOROSCIATE'), ('I530', 'SCHILPARIO'), ('I567', 'SEDRINA'), ('I597', 'SELVINO'), ('I628', 'SERIATE'), ('I629', 'SERINA'), ('I812', 'SOLTO COLLINA'), ('I813', 'SOLZA'), ('I830', 'SONGAVAZZO'), ('I858', 'SORISOLE'), ('I869', 'SOTTO IL MONTE GIOVANNI XXIII'), ('I873', 'SOVERE'), ('I916', 'SPINONE AL LAGO'), ('I919', 'SPIRANO'), ('I951', 'STEZZANO'), ('I986', 'STROZZA'), ('I997', 'SUISIO'), ('L037', 'TALEGGIO'), ('L073', 'TAVERNOLA BERGAMASCA'), ('L087', 'TELGATE'), ('L118', "TERNO D'ISOLA"), ('L251', 'TORRE BOLDONE'), ('L257', "TORRE DE' BUSI"), ('L265', "TORRE DE' ROVERI"), ('L276', 'TORRE PALLAVICINA'), ('L388', 'TRESCORE BALNEARIO'), ('L400', 'TREVIGLIO'), ('L404', 'TREVIOLO'), ('C789', 'UBIALE CLANEZZO'), ('L502', 'URGNANO'), ('M334', 'VAL BREMBILLA'), ('L544', 'VALBONDIONE'), ('L545', 'VALBREMBO'), ('L579', 'VALGOGLIO'), ('L623', 'VALLEVE'), ('L642', 'VALNEGRA'), ('L655', 'VALTORTA'), ('L707', 'VEDESETA'), ('L752', 'VERDELLINO'), ('L753', 'VERDELLO'), ('L795', 'VERTOVA'), ('L827', 'VIADANICA'), ('L865', 'VIGANO SAN MARTINO'), ('L894', 'VIGOLO'), ('L929', "VILLA D'ADDA"), ('A215', "VILLA D'ALMÈ"), ('L938', "VILLA D'OGNA"), ('L936', 'VILLA DI SERIO'), ('M045', 'VILLONGO'), ('M050', 'VILMINORE DI SCALVE'), ('M144', 'ZANDOBBIO'), ('M147', 'ZANICA'), ('M184', 'ZOGNO')],
    'BI': [('A107', 'AILOCHE'), ('A280', 'ANDORNO MICCA'), ('A784', 'BENNA'), ('A859', 'BIELLA'), ('A876', 'BIOGLIO'), ('B058', 'BORRIANA'), ('B229', 'BRUSNENGO'), ('B417', 'CALLABIANA'), ('B457', 'CAMANDONA'), ('B465', 'CAMBURZANO'), ('M373', 'CAMPIGLIA CERVO'), ('B586', 'CANDELO'), ('B708', 'CAPRILE'), ('B933', 'CASAPINTA'), ('C155', 'CASTELLETTO CERVO'), ('C363', 'CAVAGLIÀ'), ('C532', 'CERRIONE'), ('C819', 'COGGIOLA'), ('D094', 'COSSATO'), ('D165', 'CREVACUORE'), ('D219', 'CURINO'), ('D339', 'DONATO'), ('D350', 'DORZANO'), ('D848', 'GAGLIANICO'), ('E024', 'GIFFLENGA'), ('E130', 'GRAGLIA'), ('M371', 'LESSONA'), ('E821', 'MAGNANO'), ('F037', 'MASSAZZA'), ('F042', 'MASSERANO'), ('F167', 'MEZZANA MORTIGLIENGO'), ('F189', 'MIAGLIANO'), ('F369', 'MONGRANDO'), ('F776', 'MOTTALCIATA'), ('F833', 'MUZZANO'), ('F878', 'NETRO'), ('F992', 'OCCHIEPPO INFERIORE'), ('F993', 'OCCHIEPPO SUPERIORE'), ('G521', 'PETTINENGO'), ('G577', 'PIATTO'), ('G594', 'PIEDICAVALLO'), ('G798', 'POLLONE'), ('G820', 'PONDERANO'), ('G927', 'PORTULA'), ('G980', 'PRALUNGO'), ('G974', 'PRAY'), ('M414', 'QUAREGNA CERRETO'), ('H538', 'RONCO BIELLESE'), ('H553', 'ROPPOLO'), ('H561', 'ROSAZZA'), ('H662', 'SAGLIANO MICCA'), ('H681', 'SALA BIELLESE'), ('H726', 'SALUSSOLA'), ('H821', 'SANDIGLIANO'), ('I847', 'SORDEVOLO'), ('I868', 'SOSTEGNO'), ('I980', 'STRONA'), ('L075', 'TAVIGLIANO'), ('L116', 'TERNENGO'), ('L193', 'TOLLEGNO'), ('L239', 'TORRAZZO'), ('L556', 'VALDENGO'), ('M417', 'VALDILANA'), ('L586', 'VALLANZENGO'), ('L620', 'VALLE SAN NICOLAO'), ('L712', 'VEGLIO'), ('L785', 'VERRONE'), ('L880', 'VIGLIANO BIELLESE'), ('L933', 'VILLA DEL BOSCO'), ('L978', 'VILLANOVA BIELLESE'), ('M098', 'VIVERONE'), ('M179', 'ZIMONE'), ('M196', 'ZUBIENA'), ('M201', 'ZUMAGLIA')],
    'BL': [('A083', 'AGORDO'), ('A121', 'ALANO DI PIAVE'), ('A206', 'ALLEGHE'), ('M375', 'ALPAGO'), ('A443', 'ARSIÈ'), ('A501', 'AURONZO DI CADORE'), ('A757', 'BELLUNO'), ('A982', 'BORCA DI CADORE'), ('M421', 'BORGO VALBELLUNA'), ('B375', 'CALALZO DI CADORE'), ('B574', "CANALE D'AGORDO"), ('C458', 'CENCENIGHE AGORDINO'), ('C577', 'CESIOMAGGIORE'), ('C630', "CHIES D'ALPAGO"), ('C672', 'CIBIANA DI CADORE'), ('C872', 'COLLE SANTA LUCIA'), ('C920', 'COMELICO SUPERIORE'), ('A266', "CORTINA D'AMPEZZO"), ('D247', 'DANTA DI CADORE'), ('D330', 'DOMEGGE DI CADORE'), ('D470', 'FALCADE'), ('D530', 'FELTRE'), ('D686', 'FONZASO'), ('E113', 'GOSALDO'), ('E490', 'LA VALLE AGORDINA'), ('E429', 'LAMON'), ('E588', 'LIMANA'), ('E622', 'LIVINALLONGO DEL COL DI LANA'), ('M342', 'LONGARONE'), ('E687', 'LORENZAGO DI CADORE'), ('E708', 'LOZZO DI CADORE'), ('G169', 'OSPITALE DI CADORE'), ('G404', 'PEDAVENA'), ('G442', 'PERAROLO DI CADORE'), ('G642', 'PIEVE DI CADORE'), ('B662', 'PONTE NELLE ALPI'), ('M332', 'QUERO VAS'), ('H327', 'RIVAMONTE AGORDINO'), ('H379', 'ROCCA PIETORE'), ('H938', 'SAN GREGORIO NELLE ALPI'), ('I063', 'SAN NICOLÒ DI COMELICO'), ('I088', 'SAN PIETRO DI CADORE'), ('I347', 'SAN TOMASO AGORDINO'), ('I392', 'SAN VITO DI CADORE'), ('I206', 'SANTA GIUSTINA'), ('C919', 'SANTO STEFANO DI CADORE'), ('I563', 'SEDICO'), ('I592', 'SELVA DI CADORE'), ('I626', 'SEREN DEL GRAPPA'), ('I866', 'SOSPIROLO'), ('I876', 'SOVERZENE'), ('I673', 'SOVRAMONTE'), ('L030', 'TAIBON AGORDINO'), ('L040', 'TAMBRE'), ('M374', 'VAL DI ZOLDO'), ('L584', 'VALLADA AGORDINA'), ('L590', 'VALLE DI CADORE'), ('L890', 'VIGO DI CADORE'), ('M108', 'VODO CADORE'), ('M124', 'VOLTAGO AGORDINO'), ('M189', 'ZOPPÈ DI CADORE')],
    'BN': [('A110', 'AIROLA'), ('A265', 'AMOROSI'), ('A328', 'APICE'), ('A330', 'APOLLOSA'), ('A431', 'ARPAIA'), ('A432', 'ARPAISE'), ('A696', 'BASELICE'), ('A783', 'BENEVENTO'), ('A970', 'BONEA'), ('B239', 'BUCCIANO'), ('B267', 'BUONALBERGO'), ('B444', 'CALVI'), ('B541', 'CAMPOLATTARO'), ('B542', 'CAMPOLI DEL MONTE TABURNO'), ('B873', 'CASALDUNI'), ('C106', 'CASTELFRANCO IN MISCANO'), ('C245', 'CASTELPAGANO'), ('C250', 'CASTELPOTO'), ('C280', 'CASTELVENERE'), ('C284', 'CASTELVETERE IN VAL FORTORE'), ('C359', 'CAUTANO'), ('C476', 'CEPPALONI'), ('C525', 'CERRETO SANNITA'), ('C719', 'CIRCELLO'), ('C846', 'COLLE SANNITA'), ('D230', 'CUSANO MUTRI'), ('D380', 'DUGENTA'), ('D386', 'DURAZZANO'), ('D469', 'FAICCHIO'), ('D644', 'FOGLIANISE'), ('D650', 'FOIANO DI VAL FORTORE'), ('D693', 'FORCHIA'), ('D755', "FRAGNETO L'ABATE"), ('D756', 'FRAGNETO MONFORTE'), ('D784', 'FRASSO TELESINO'), ('E034', 'GINESTRA DEGLI SCHIAVONI'), ('E249', 'GUARDIA SANFRAMONDI'), ('E589', 'LIMATOLA'), ('F113', 'MELIZZANO'), ('F274', 'MOIANO'), ('F287', 'MOLINARA'), ('F494', 'MONTEFALCONE DI VAL FORTORE'), ('F636', 'MONTESARCHIO'), ('F717', 'MORCONE'), ('G227', 'PADULI'), ('G243', 'PAGO VEIANO'), ('G311', 'PANNARANO'), ('G318', 'PAOLISI'), ('G386', 'PAUPISI'), ('G494', 'PESCO SANNITA'), ('G626', 'PIETRAROJA'), ('G631', 'PIETRELCINA'), ('G827', 'PONTE'), ('G848', 'PONTELANDOLFO'), ('H087', 'PUGLIANELLO'), ('H227', 'REINO'), ('H764', 'SAN BARTOLOMEO IN GALDO'), ('H894', 'SAN GIORGIO DEL SANNIO'), ('H898', 'SAN GIORGIO LA MOLARA'), ('H953', 'SAN LEUCIO DEL SANNIO'), ('H955', 'SAN LORENZELLO'), ('H967', 'SAN LORENZO MAGGIORE'), ('H973', 'SAN LUPO'), ('H984', 'SAN MARCO DEI CAVOTI'), ('I002', 'SAN MARTINO SANNITA'), ('I049', 'SAN NAZZARO'), ('I062', 'SAN NICOLA MANFREDI'), ('I145', 'SAN SALVATORE TELESINO'), ('I197', "SANT'AGATA DE' GOTI"), ('I277', "SANT'ANGELO A CUPOLO"), ('F557', "SANT'ARCANGELO TRIMONTE"), ('I179', 'SANTA CROCE DEL SANNIO'), ('I455', 'SASSINORO'), ('I809', 'SOLOPACA'), ('L086', 'TELESE TERME'), ('L185', 'TOCCO CAUDIO'), ('L254', 'TORRECUSO'), ('M093', 'VITULANO')],
    'BO': [('M369', 'ALTO RENO TERME'), ('A324', "ANZOLA DELL'EMILIA"), ('A392', 'ARGELATO'), ('A665', 'BARICELLA'), ('A785', 'BENTIVOGLIO'), ('A944', 'BOLOGNA'), ('B044', 'BORGO TOSSIGNANO'), ('B249', 'BUDRIO'), ('B399', 'CALDERARA DI RENO'), ('B572', 'CAMUGNANO'), ('B880', 'CASALECCHIO DI RENO'), ('B892', 'CASALFIUMANESE'), ('C075', "CASTEL D'AIANO"), ('C086', 'CASTEL DEL RIO'), ('B969', 'CASTEL DI CASIO'), ('C121', 'CASTEL GUELFO DI BOLOGNA'), ('C204', 'CASTEL MAGGIORE'), ('C265', 'CASTEL SAN PIETRO TERME'), ('C185', "CASTELLO D'ARGILE"), ('C292', 'CASTENASO'), ('C296', 'CASTIGLIONE DEI PEPOLI'), ('D166', 'CREVALCORE'), ('D360', 'DOZZA'), ('D668', 'FONTANELICE'), ('D847', 'GAGGIO MONTANO'), ('D878', 'GALLIERA'), ('E136', "GRANAROLO DELL'EMILIA"), ('E187', 'GRIZZANA MORANDI'), ('E289', 'IMOLA'), ('A771', 'LIZZANO IN BELVEDERE'), ('E655', 'LOIANO'), ('E844', 'MALALBERGO'), ('B689', 'MARZABOTTO'), ('F083', 'MEDICINA'), ('F219', 'MINERBIO'), ('F288', 'MOLINELLA'), ('F363', 'MONGHIDORO'), ('F627', 'MONTE SAN PIETRO'), ('F597', 'MONTERENZIO'), ('F706', 'MONZUNO'), ('F718', 'MORDANO'), ('G205', "OZZANO DELL'EMILIA"), ('G570', 'PIANORO'), ('G643', 'PIEVE DI CENTO'), ('H678', 'SALA BOLOGNESE'), ('G566', 'SAN BENEDETTO VAL DI SAMBRO'), ('H896', 'SAN GIORGIO DI PIANO'), ('G467', 'SAN GIOVANNI IN PERSICETO'), ('H945', 'SAN LAZZARO DI SAVENA'), ('I110', 'SAN PIETRO IN CASALE'), ('I191', "SANT'AGATA BOLOGNESE"), ('G972', 'SASSO MARCONI'), ('M320', 'VALSAMOGGIA'), ('L762', 'VERGATO'), ('M185', 'ZOLA PREDOSA')],
    'BR': [('B180', 'BRINDISI'), ('B809', 'CAROVIGNO'), ('C424', 'CEGLIE MESSAPICA'), ('C448', 'CELLINO SAN MARCO'), ('C741', 'CISTERNINO'), ('D422', 'ERCHIE'), ('D508', 'FASANO'), ('D761', 'FRANCAVILLA FONTANA'), ('E471', 'LATIANO'), ('F152', 'MESAGNE'), ('G098', 'ORIA'), ('G187', 'OSTUNI'), ('H822', 'SAN DONACI'), ('I045', 'SAN MICHELE SALENTINO'), ('I066', 'SAN PANCRAZIO SALENTINO'), ('I119', 'SAN PIETRO VERNOTICO'), ('I396', 'SAN VITO DEI NORMANNI'), ('L213', 'TORCHIAROLO'), ('L280', 'TORRE SANTA SUSANNA'), ('L920', 'VILLA CASTELLI')],
    'BS': [('A034', 'ACQUAFREDDA'), ('A060', 'ADRO'), ('A082', 'AGNOSINE'), ('A188', 'ALFIANELLO'), ('A288', 'ANFO'), ('A293', 'ANGOLO TERME'), ('A451', 'ARTOGNE'), ('A529', 'AZZANO MELLA'), ('A569', 'BAGNOLO MELLA'), ('A578', 'BAGOLINO'), ('A630', 'BARBARIGA'), ('A661', 'BARGHE'), ('A702', 'BASSANO BRESCIANO'), ('A729', 'BEDIZZOLE'), ('A799', 'BERLINGO'), ('A816', 'BERZO DEMO'), ('A817', 'BERZO INFERIORE'), ('A861', 'BIENNO'), ('A878', 'BIONE'), ('B035', 'BORGO SAN GIACOMO'), ('B040', 'BORGOSATOLLO'), ('B054', 'BORNO'), ('B091', 'BOTTICINO'), ('B100', 'BOVEGNO'), ('B102', 'BOVEZZO'), ('B120', 'BRANDICO'), ('B124', 'BRAONE'), ('B149', 'BRENO'), ('B157', 'BRESCIA'), ('B184', 'BRIONE'), ('B365', 'CAINO'), ('B394', 'CALCINATO'), ('B436', 'CALVAGESE DELLA RIVIERA'), ('B450', 'CALVISANO'), ('B664', 'CAPO DI PONTE'), ('B676', 'CAPOVALLE'), ('B698', 'CAPRIANO DEL COLLE'), ('B711', 'CAPRIOLO'), ('B817', 'CARPENEDOLO'), ('C055', 'CASTEGNATO'), ('C208', 'CASTEL MELLA'), ('C072', 'CASTELCOVATI'), ('C293', 'CASTENEDOLO'), ('C330', 'CASTO'), ('C332', 'CASTREZZATO'), ('C408', 'CAZZAGO SAN MARTINO'), ('C417', 'CEDEGOLO'), ('C439', 'CELLATICA'), ('C549', 'CERVENO'), ('C585', 'CETO'), ('C591', 'CEVO'), ('C618', 'CHIARI'), ('C685', 'CIGOLE'), ('C691', 'CIMBERGO'), ('C760', 'CIVIDATE CAMUNO'), ('C806', 'COCCAGLIO'), ('C850', 'COLLEBEATO'), ('C883', 'COLLIO'), ('C893', 'COLOGNE'), ('C925', 'COMEZZANO-CIZZAGO'), ('C948', 'CONCESIO'), ('D058', 'CORTE FRANCA'), ('D064', 'CORTENO GOLGI'), ('D082', 'CORZANO'), ('D251', 'DARFO BOARIO TERME'), ('D270', 'DELLO'), ('D284', 'DESENZANO DEL GARDA'), ('D391', 'EDOLO'), ('D421', 'ERBUSCO'), ('D434', 'ESINE'), ('D576', 'FIESSE'), ('D634', 'FLERO'), ('D891', 'GAMBARA'), ('D917', 'GARDONE RIVIERA'), ('D918', 'GARDONE VAL TROMPIA'), ('D924', 'GARGNANO'), ('D940', 'GAVARDO'), ('D999', 'GHEDI'), ('E010', 'GIANICO'), ('E116', 'GOTTOLENGO'), ('E271', 'GUSSAGO'), ('E280', 'IDRO'), ('E297', 'INCUDINE'), ('E325', 'IRMA'), ('E333', 'ISEO'), ('E364', 'ISORELLA'), ('E497', 'LAVENONE'), ('E526', 'LENO'), ('E596', 'LIMONE SUL GARDA'), ('E652', 'LODRINO'), ('E654', 'LOGRATO'), ('M312', 'LONATO DEL GARDA'), ('E673', 'LONGHENA'), ('E698', 'LOSINE'), ('E706', 'LOZIO'), ('E738', 'LUMEZZANE'), ('E787', 'MACLODIO'), ('E800', 'MAGASA'), ('E841', 'MAIRANO'), ('E851', 'MALEGNO'), ('E865', 'MALONNO'), ('E883', 'MANERBA DEL GARDA'), ('E884', 'MANERBIO'), ('E928', 'MARCHENO'), ('E961', 'MARMENTINO'), ('E967', 'MARONE'), ('F063', 'MAZZANO'), ('F216', 'MILZANO'), ('F373', 'MONIGA DEL GARDA'), ('F375', 'MONNO'), ('F532', 'MONTE ISOLA'), ('F672', 'MONTICELLI BRUSATI'), ('F471', 'MONTICHIARI'), ('F680', 'MONTIRONE'), ('F806', 'MURA'), ('F820', 'MUSCOLINE'), ('F851', 'NAVE'), ('F884', 'NIARDO'), ('F989', 'NUVOLENTO'), ('F990', 'NUVOLERA'), ('G001', 'ODOLO'), ('G006', 'OFFLAGA'), ('G061', 'OME'), ('G074', 'ONO SAN PIETRO'), ('G149', 'ORZINUOVI'), ('G150', 'ORZIVECCHI'), ('G170', 'OSPITALETTO'), ('G179', 'OSSIMO'), ('G213', 'PADENGHE SUL GARDA'), ('G217', 'PADERNO FRANCIACORTA'), ('G247', 'PAISCO LOVENO'), ('G248', 'PAITONE'), ('G264', "PALAZZOLO SULL'OGLIO"), ('G327', 'PARATICO'), ('G354', 'PASPARDO'), ('G361', 'PASSIRANO'), ('G391', 'PAVONE DEL MELLA'), ('G474', 'PERTICA ALTA'), ('G475', 'PERTICA BASSA'), ('G529', 'PEZZAZE'), ('G546', 'PIAN CAMUNO'), ('G549', 'PIANCOGNO'), ('G710', 'PISOGNE'), ('G779', 'POLAVENO'), ('G801', 'POLPENAZZE DEL GARDA'), ('G815', 'POMPIANO'), ('G818', 'PONCARALE'), ('G844', 'PONTE DI LEGNO'), ('G859', 'PONTEVICO'), ('G869', 'PONTOGLIO'), ('G959', 'POZZOLENGO'), ('G977', 'PRALBOINO'), ('H043', 'PRESEGLIE'), ('H055', 'PREVALLE'), ('H078', "PROVAGLIO D'ISEO"), ('H077', 'PROVAGLIO VAL SABBIA'), ('H086', 'PUEGNAGO DEL GARDA'), ('H140', "QUINZANO D'OGLIO"), ('H230', 'REMEDELLO'), ('H256', 'REZZATO'), ('H410', 'ROCCAFRANCA'), ('H477', 'RODENGO SAIANO'), ('H525', 'RONCADELLE'), ('H598', 'ROVATO'), ('H484', 'ROÈ VOLCIANO'), ('H630', 'RUDIANO'), ('H650', 'SABBIO CHIESE'), ('H699', 'SALE MARASINO'), ('H717', 'SALÒ'), ('H838', 'SAN FELICE DEL BENACO'), ('H865', 'SAN GERVASIO BRESCIANO'), ('G407', 'SAN PAOLO'), ('I412', 'SAN ZENO NAVIGLIO'), ('I433', 'SAREZZO'), ('I476', "SAVIORE DELL'ADAMELLO"), ('I588', 'SELLERO'), ('I607', 'SENIGA'), ('I631', 'SERLE'), ('I633', 'SIRMIONE'), ('I782', 'SOIANO DEL LAGO'), ('I831', 'SONICO'), ('L002', 'SULZANO'), ('C698', 'TAVERNOLE SUL MELLA'), ('L094', 'TEMÙ'), ('L169', 'TIGNALE'), ('L210', 'TORBOLE CASAGLIA'), ('L312', 'TOSCOLANO-MADERNO'), ('L339', 'TRAVAGLIATO'), ('L372', 'TREMOSINE SUL GARDA'), ('L380', 'TRENZANO'), ('L406', 'TREVISO BRESCIANO'), ('L494', "URAGO D'OGLIO"), ('L626', 'VALLIO TERME'), ('L468', 'VALVESTINO'), ('L777', 'VEROLANUOVA'), ('L778', 'VEROLAVECCHIA'), ('L812', 'VESTONE'), ('L816', "VEZZA D'OGLIO"), ('L919', 'VILLA CARCINA'), ('L923', 'VILLACHIARA'), ('L995', 'VILLANUOVA SUL CLISI'), ('M065', 'VIONE'), ('M070', 'VISANO'), ('M104', 'VOBARNO'), ('M188', 'ZONE')],
    'BT': [('A285', 'ANDRIA'), ('A669', 'BARLETTA'), ('A883', 'BISCEGLIE'), ('B619', 'CANOSA DI PUGLIA'), ('E946', 'MARGHERITA DI SAVOIA'), ('F220', 'MINERVINO MURGE'), ('H839', 'SAN FERDINANDO DI PUGLIA'), ('I907', 'SPINAZZOLA'), ('L328', 'TRANI'), ('B915', 'TRINITAPOLI')],
    'BZ': [('A179', 'ALDINO/ALDEIN'), ('A286', 'ANDRIANO/ANDRIAN'), ('A306', 'ANTERIVO/ALTREI'), ('A332', 'APPIANO SULLA STRADA DEL VINO/EPPAN AN DER WEINSTRASSE'), ('A507', 'AVELENGO/HAFLING'), ('A537', 'BADIA/ABTEI'), ('A635', 'BARBIANO/BARBIAN'), ('A952', 'BOLZANO/BOZEN'), ('B116', 'BRAIES/PRAGS'), ('B145', 'BRENNERO/BRENNER'), ('B160', 'BRESSANONE/BRIXEN'), ('B203', 'BRONZOLO/BRANZOLL'), ('B220', 'BRUNICO/BRUNECK'), ('B364', 'CAINES/KUENS'), ('B397', 'CALDARO SULLA STRADA DEL VINO/KALTERN AN DER WEINSTRASSE'), ('B529', 'CAMPO DI TRENS/FREIENFELD'), ('B570', 'CAMPO TURES/SAND IN TAUFERS'), ('C062', 'CASTELBELLO-CIARDES/KASTELBELL-TSCHARS'), ('C254', 'CASTELROTTO/KASTELRUTH'), ('A022', 'CERMES/TSCHERMS'), ('C625', 'CHIENES/KIENS'), ('C652', 'CHIUSA/KLAUSEN'), ('B799', "CORNEDO ALL'ISARCO/KARNEID"), ('D048', 'CORTACCIA SULLA STRADA DEL VINO/KURTATSCH AN DER WEINSTRASSE'), ('D075', 'CORTINA SULLA STRADA DEL VINO/KURTINIG AN DER WEINSTRASSE'), ('D079', 'CORVARA IN BADIA/CORVARA'), ('D222', 'CURON VENOSTA/GRAUN IM VINSCHGAU'), ('D311', 'DOBBIACO/TOBLACH'), ('D392', 'EGNA/NEUMARKT'), ('D484', 'FALZES/PFALZEN'), ('D571', 'FIÈ ALLO SCILIAR/VÖLS AM SCHLERN'), ('D731', 'FORTEZZA/FRANZENSFESTE'), ('D821', 'FUNES/VILLNÖSS'), ('D860', 'GAIS/GAIS'), ('D923', 'GARGAZZONE/GARGAZON'), ('E069', 'GLORENZA/GLURNS'), ('E491', 'LA VALLE/WENGEN'), ('E398', 'LACES/LATSCH'), ('E412', 'LAGUNDO/ALGUND'), ('E420', 'LAION/LAJEN'), ('E421', 'LAIVES/LEIFERS'), ('E434', 'LANA/LANA'), ('E457', 'LASA/LAAS'), ('E481', 'LAUREGNO/LAUREIN'), ('E764', 'LUSON/LÜSEN'), ('E829', 'MAGRÈ SULLA STRADA DEL VINO/MARGREID AN DER WEINSTRASSE'), ('E862', 'MALLES VENOSTA/MALS'), ('E938', 'MAREBBE/ENNEBERG'), ('E959', 'MARLENGO/MARLING'), ('E981', 'MARTELLO/MARTELL'), ('F118', 'MELTINA/MÖLTEN'), ('F132', 'MERANO/MERAN'), ('F371', 'MONGUELFO-TESIDO/WELSBERG-TAISTEN'), ('F392', 'MONTAGNA/MONTAN'), ('F766', 'MOSO IN PASSIRIA/MOOS IN PASSEIER'), ('F836', 'NALLES/NALS'), ('F849', 'NATURNO/NATURNS'), ('F856', 'NAZ-SCIAVES/NATZ-SCHABS'), ('F949', 'NOVA LEVANTE/WELSCHNOFEN'), ('F950', 'NOVA PONENTE/DEUTSCHNOFEN'), ('G083', 'ORA/AUER'), ('G140', 'ORTISEI/ST. ULRICH'), ('G328', 'PARCINES/PARTSCHINS'), ('G443', 'PERCA/PERCHA'), ('G299', 'PLAUS/PLAUS'), ('G830', 'PONTE GARDENA/WAIDBRUCK'), ('G936', 'POSTAL/BURGSTALL'), ('H004', 'PRATO ALLO STELVIO/PRAD AM STILFSERJOCH'), ('H019', 'PREDOI/PRETTAU'), ('H081', 'PROVES/PROVEIS'), ('H152', 'RACINES/RATSCHINGS'), ('H189', 'RASUN-ANTERSELVA/RASEN-ANTHOLZ'), ('H236', 'RENON/RITTEN'), ('H284', 'RIFIANO/RIFFIAN'), ('H299', 'RIO DI PUSTERIA/MÜHLBACH'), ('H475', 'RODENGO/RODENECK'), ('H719', 'SALORNO SULLA STRADA DEL VINO/SALURN AN DER WEINSTRASSE'), ('H786', 'SAN CANDIDO/INNICHEN'), ('H858', 'SAN GENESIO ATESINO/JENESIEN'), ('H952', 'SAN LEONARDO IN PASSIRIA/ST. LEONHARD IN PASSEIER'), ('H956', 'SAN LORENZO DI SEBATO/ST. LORENZEN'), ('H988', 'SAN MARTINO IN BADIA/ST. MARTIN IN THURN'), ('H989', 'SAN MARTINO IN PASSIRIA/ST. MARTIN IN PASSEIER'), ('I065', 'SAN PANCRAZIO/ST. PANKRAZ'), ('I173', 'SANTA CRISTINA VALGARDENA/ST. CHRISTINA IN GRÖDEN'), ('I431', 'SARENTINO/SARNTAL'), ('I519', 'SCENA/SCHENNA'), ('I593', 'SELVA DEI MOLINI/MÜHLWALD'), ('I591', 'SELVA DI VAL GARDENA/WOLKENSTEIN IN GRÖDEN'), ('I603', 'SENALE-SAN FELICE/UNSERE LIEBE FRAU IM WALDE-ST. FELIX'), ('I604', 'SENALES/SCHNALS'), ('I687', 'SESTO/SEXTEN'), ('I729', 'SILANDRO/SCHLANDERS'), ('I771', 'SLUDERNO/SCHLUDERNS'), ('I948', 'STELVIO/STILFS'), ('L106', 'TERENTO/TERENTEN'), ('L108', 'TERLANO/TERLAN'), ('L111', 'TERMENO SULLA STRADA DEL VINO/TRAMIN AN DER WEINSTRASSE'), ('L149', 'TESIMO/TISENS'), ('L176', 'TIRES/TIERS'), ('L178', 'TIROLO/TIROL'), ('L444', 'TRODENA NEL PARCO NATURALE/TRUDEN IM NATURPARK'), ('L455', 'TUBRE/TAUFERS IM MÜNSTERTAL'), ('L490', 'ULTIMO/ULTEN'), ('L527', 'VADENA/PFATTEN'), ('L564', 'VAL DI VIZZE/PFITSCH'), ('L552', 'VALDAORA/OLANG'), ('L595', 'VALLE AURINA/AHRNTAL'), ('L601', 'VALLE DI CASIES/GSIES'), ('L660', 'VANDOIES/VINTL'), ('L687', 'VARNA/VAHRN'), ('L724', 'VELTURNO/FELDTHURNS'), ('L745', 'VERANO/VÖRAN'), ('L915', 'VILLABASSA/NIEDERDORF'), ('L971', 'VILLANDRO/VILLANDERS'), ('M067', 'VIPITENO/STERZING')],
    'CA': [('A474', 'ASSEMINI'), ('B354', 'CAGLIARI'), ('B675', 'CAPOTERRA'), ('D259', 'DECIMOMANNU'), ('D399', 'ELMAS'), ('E903', 'MARACALAGONIS'), ('F383', 'MONSERRATO'), ('H088', 'PULA'), ('H118', "QUARTU SANT'ELENA"), ('H119', 'QUARTUCCIU'), ('I443', 'SARROCH'), ('I580', 'SELARGIUS'), ('I695', 'SESTU'), ('I699', 'SETTIMO SAN PIETRO'), ('I752', 'SINNAI'), ('L521', 'UTA'), ('I118', 'VILLA SAN PIETRO')],
    'CB': [('A050', 'ACQUAVIVA COLLECROCE'), ('A616', 'BARANELLO'), ('A930', 'BOJANO'), ('A971', 'BONEFRO'), ('B295', 'BUSSO'), ('B519', 'CAMPOBASSO'), ('B522', 'CAMPOCHIARO'), ('B528', 'CAMPODIPIETRA'), ('B544', 'CAMPOLIETO'), ('B550', 'CAMPOMARINO'), ('B858', 'CASACALENDA'), ('B871', 'CASALCIPRANO'), ('C066', 'CASTELBOTTACCIO'), ('C175', 'CASTELLINO DEL BIFERNO'), ('C197', 'CASTELMAURO'), ('C346', 'CASTROPIGNANO'), ('C486', 'CERCEMAGGIORE'), ('C488', 'CERCEPICCOLA'), ('C764', 'CIVITACAMPOMARANO'), ('C854', "COLLE D'ANCHISE"), ('C875', 'COLLETORTO'), ('C772', 'DURONIA'), ('D550', 'FERRAZZANO'), ('D737', 'FOSSALTO'), ('D896', 'GAMBATESA'), ('E030', 'GILDONE'), ('E244', 'GUARDIALFIERA'), ('E248', 'GUARDIAREGIA'), ('E259', 'GUGLIONESI'), ('E381', 'JELSI'), ('E456', 'LARINO'), ('E599', 'LIMOSANO'), ('E722', 'LUCITO'), ('E748', 'LUPARA'), ('E780', 'MACCHIA VALFORTORE'), ('E799', 'MAFALDA'), ('F055', 'MATRICE'), ('F233', 'MIRABELLO SANNITICO'), ('F294', 'MOLISE'), ('F322', 'MONACILIONI'), ('F391', 'MONTAGANO'), ('F475', 'MONTECILFONE'), ('F495', 'MONTEFALCONE NEL SANNIO'), ('F548', 'MONTELONGO'), ('F569', 'MONTEMITRO'), ('F576', 'MONTENERO DI BISACCIA'), ('F689', 'MONTORIO NEI FRENTANI'), ('F748', 'MORRONE DEL SANNIO'), ('G086', 'ORATINO'), ('G257', 'PALATA'), ('G506', 'PETACCIATO'), ('G512', 'PETRELLA TIFERNINA'), ('G609', 'PIETRACATELLA'), ('G610', 'PIETRACUPA'), ('G910', 'PORTOCANNONE'), ('H083', 'PROVVIDENTI'), ('H273', 'RICCIA'), ('H311', 'RIPABOTTONI'), ('H313', 'RIPALIMOSANI'), ('H454', 'ROCCAVIVARA'), ('H589', 'ROTELLO'), ('H693', 'SALCITO'), ('H782', 'SAN BIASE'), ('H833', 'SAN FELICE DEL MOLISE'), ('H867', 'SAN GIACOMO DEGLI SCHIAVONI'), ('H920', 'SAN GIOVANNI IN GALDO'), ('H928', 'SAN GIULIANO DEL SANNIO'), ('H929', 'SAN GIULIANO DI PUGLIA'), ('H990', 'SAN MARTINO IN PENSILIS'), ('I023', 'SAN MASSIMO'), ('I122', 'SAN POLO MATESE'), ('I289', "SANT'ANGELO LIMOSANO"), ('I320', "SANT'ELIA A PIANISI"), ('I181', 'SANTA CROCE DI MAGLIANO'), ('I618', 'SEPINO'), ('I910', 'SPINETE'), ('L069', 'TAVENNA'), ('L113', 'TERMOLI'), ('L215', 'TORELLA DEL SANNIO'), ('L230', 'TORO'), ('L435', 'TRIVENTO'), ('L458', 'TUFARA'), ('L505', 'URURI'), ('M057', 'VINCHIATURO')],
    'CE': [('A106', 'AILANO'), ('A200', 'ALIFE'), ('A243', 'ALVIGNANO'), ('A403', 'ARIENZO'), ('A512', 'AVERSA'), ('A579', 'BAIA E LATINA'), ('A755', 'BELLONA'), ('B361', 'CAIANELLO'), ('B362', 'CAIAZZO'), ('B445', 'CALVI RISORTA'), ('B477', 'CAMIGLIANO'), ('B581', 'CANCELLO ED ARNONE'), ('B667', 'CAPODRISE'), ('B704', 'CAPRIATI A VOLTURNO'), ('B715', 'CAPUA'), ('B779', 'CARINARO'), ('B781', 'CARINOLA'), ('B860', 'CASAGIOVE'), ('B872', 'CASAL DI PRINCIPE'), ('B916', 'CASALUCE'), ('M260', 'CASAPESENNA'), ('B935', 'CASAPULLA'), ('B963', 'CASERTA'), ('B494', 'CASTEL CAMPAGNANO'), ('C097', 'CASTEL DI SASSO'), ('C211', 'CASTEL MORRONE'), ('C291', 'CASTEL VOLTURNO'), ('C178', 'CASTELLO DEL MATESE'), ('M262', 'CELLOLE'), ('C558', 'CERVINO'), ('C561', 'CESA'), ('C716', 'CIORLANO'), ('C939', 'CONCA DELLA CAMPANIA'), ('D228', 'CURTI'), ('D361', 'DRAGONI'), ('D471', 'FALCIANO DEL MASSICO'), ('D683', 'FONTEGRECA'), ('D709', 'FORMICOLA'), ('D769', 'FRANCOLISE'), ('D799', 'FRIGNANO'), ('D884', 'GALLO MATESE'), ('D886', 'GALLUCCIO'), ('E011', 'GIANO VETUSTO'), ('E039', 'GIOIA SANNITICA'), ('E158', 'GRAZZANISE'), ('E173', 'GRICIGNANO DI AVERSA'), ('E554', 'LETINO'), ('E570', 'LIBERI'), ('E754', 'LUSCIANO'), ('E784', 'MACERATA CAMPANIA'), ('E791', 'MADDALONI'), ('E932', 'MARCIANISE'), ('E998', 'MARZANO APPIO'), ('F203', 'MIGNANO MONTE LUNGO'), ('F352', 'MONDRAGONE'), ('G130', 'ORTA DI ATELLA'), ('G333', 'PARETE'), ('G364', 'PASTORANO'), ('G541', 'PIANA DI MONTE VERNA'), ('G596', 'PIEDIMONTE MATESE'), ('G620', 'PIETRAMELARA'), ('G630', 'PIETRAVAIRANO'), ('G661', 'PIGNATARO MAGGIORE'), ('G849', 'PONTELATONE'), ('G903', 'PORTICO DI CASERTA'), ('G991', 'PRATA SANNITA'), ('G995', 'PRATELLA'), ('H045', 'PRESENZANO'), ('H202', 'RAVISCANINA'), ('H210', 'RECALE'), ('H268', 'RIARDO'), ('H398', "ROCCA D'EVANDRO"), ('H423', 'ROCCAMONFINA'), ('H436', 'ROCCAROMANA'), ('H459', 'ROCCHETTA E CROCE'), ('H165', 'RUVIANO'), ('H798', "SAN CIPRIANO D'AVERSA"), ('H834', 'SAN FELICE A CANCELLO'), ('H939', 'SAN GREGORIO MATESE'), ('H978', 'SAN MARCELLINO'), ('F043', 'SAN MARCO EVANGELISTA'), ('I056', 'SAN NICOLA LA STRADA'), ('I113', 'SAN PIETRO INFINE'), ('I130', 'SAN POTITO SANNITICO'), ('I131', 'SAN PRISCO'), ('I261', 'SAN TAMMARO'), ('I273', "SANT'ANGELO D'ALIFE"), ('I306', "SANT'ARPINO"), ('I233', 'SANTA MARIA A VICO'), ('I234', 'SANTA MARIA CAPUA VETERE'), ('I247', 'SANTA MARIA LA FOSSA'), ('I676', 'SESSA AURUNCA'), ('I885', 'SPARANISE'), ('I993', 'SUCCIVO'), ('L083', 'TEANO'), ('L155', 'TEVEROLA'), ('L205', 'TORA E PICCILLI'), ('L379', 'TRENTOLA DUCENTA'), ('L540', 'VAIRANO PATENORA'), ('L594', 'VALLE AGRICOLA'), ('L591', 'VALLE DI MADDALONI'), ('D801', 'VILLA DI BRIANO'), ('L844', 'VILLA LITERNO'), ('M092', 'VITULAZIO')],
    'CH': [('A235', 'ALTINO'), ('A367', 'ARCHI'), ('A398', 'ARI'), ('A402', 'ARIELLI'), ('A485', 'ATESSA'), ('A956', 'BOMBA'), ('B057', 'BORRELLO'), ('B238', 'BUCCHIANICO'), ('B620', 'CANOSA SANNITA'), ('B826', 'CARPINETO SINELLO'), ('B853', 'CARUNCHIO'), ('B859', 'CASACANDITELLA'), ('B861', 'CASALANGUIDA'), ('B865', 'CASALBORDINO'), ('B896', 'CASALINCONTRADA'), ('B985', 'CASOLI'), ('C114', 'CASTEL FRENTANO'), ('C123', 'CASTELGUIDONE'), ('C298', 'CASTIGLIONE MESSER MARINO'), ('C428', 'CELENZA SUL TRIGNO'), ('C632', 'CHIETI'), ('C768', 'CIVITALUPARELLA'), ('C776', 'CIVITELLA MESSER RAIMONDO'), ('C855', 'COLLEDIMACINE'), ('C856', 'COLLEDIMEZZO'), ('D137', 'CRECCHIO'), ('D209', 'CUPELLO'), ('D315', 'DOGLIOLA'), ('D480', 'FALLO'), ('D494', 'FARA FILIORUM PETRI'), ('D495', 'FARA SAN MARTINO'), ('D592', 'FILETTO'), ('D738', 'FOSSACESIA'), ('D757', 'FRAINE'), ('D763', 'FRANCAVILLA AL MARE'), ('D796', 'FRESAGRANDINARIA'), ('D803', 'FRISA'), ('D823', 'FURCI'), ('D898', 'GAMBERALE'), ('D996', 'GESSOPALENA'), ('E052', 'GISSI'), ('E056', 'GIULIANO TEATINO'), ('E243', 'GUARDIAGRELE'), ('E266', 'GUILMI'), ('E424', 'LAMA DEI PELIGNI'), ('E435', 'LANCIANO'), ('E531', 'LENTELLA'), ('E559', 'LETTOPALENA'), ('E611', 'LISCIA'), ('F196', 'MIGLIANICO'), ('F433', 'MONTAZZOLI'), ('B268', 'MONTEBELLO SUL SANGRO'), ('F498', 'MONTEFERRANTE'), ('F535', 'MONTELAPIANO'), ('F578', 'MONTENERODOMO'), ('F582', 'MONTEODORISIO'), ('F785', 'MOZZAGROGNA'), ('G128', 'ORSOGNA'), ('G141', 'ORTONA'), ('G237', 'PAGLIETA'), ('G271', 'PALENA'), ('G290', 'PALMOLI'), ('G294', 'PALOMBARO'), ('G434', 'PENNADOMO'), ('G435', 'PENNAPIEDIMONTE'), ('G441', 'PERANO'), ('G613', 'PIETRAFERRAZZANA'), ('G724', 'PIZZOFERRATO'), ('G760', 'POGGIOFIORITO'), ('G799', 'POLLUTRI'), ('H052', 'PRETORO'), ('H098', 'QUADRI'), ('H184', 'RAPINO'), ('H320', 'RIPA TEATINA'), ('H439', 'ROCCA SAN GIOVANNI'), ('H424', 'ROCCAMONTEPIANO'), ('H442', 'ROCCASCALEGNA'), ('H448', 'ROCCASPINALVETI'), ('H495', 'ROIO DEL SANGRO'), ('H566', 'ROSELLO'), ('H784', 'SAN BUONO'), ('H923', 'SAN GIOVANNI LIPIONI'), ('D690', 'SAN GIOVANNI TEATINO'), ('H991', 'SAN MARTINO SULLA MARRUCINA'), ('I148', 'SAN SALVO'), ('I394', 'SAN VITO CHIETINO'), ('I335', "SANT'EUSANIO DEL SANGRO"), ('I244', 'SANTA MARIA IMBARO'), ('I520', 'SCERNI'), ('I526', 'SCHIAVI DI ABRUZZO'), ('L047', 'TARANTA PELIGNA'), ('L194', 'TOLLO'), ('L218', 'TORINO DI SANGRO'), ('L224', 'TORNARECCIO'), ('L253', 'TORREBRUNA'), ('L284', 'TORREVECCHIA TEATINA'), ('L291', 'TORRICELLA PELIGNA'), ('L363', 'TREGLIO'), ('L459', 'TUFILLO'), ('L526', 'VACRI'), ('E372', 'VASTO'), ('M022', 'VILLA SANTA MARIA'), ('L961', 'VILLALFONSINA'), ('L964', 'VILLAMAGNA')],
    'CL': [('A049', 'ACQUAVIVA PLATANI'), ('A957', 'BOMPENSIERE'), ('B302', 'BUTERA'), ('B429', 'CALTANISSETTA'), ('B537', 'CAMPOFRANCO'), ('D267', 'DELIA'), ('D960', 'GELA'), ('E953', 'MARIANOPOLI'), ('F065', 'MAZZARINO'), ('E618', 'MILENA'), ('F489', 'MONTEDORO'), ('F830', 'MUSSOMELI'), ('F899', 'NISCEMI'), ('H245', 'RESUTTANO'), ('H281', 'RIESI'), ('H792', 'SAN CATALDO'), ('I169', 'SANTA CATERINA VILLARMOSA'), ('I644', 'SERRADIFALCO'), ('I824', 'SOMMATINO'), ('L016', 'SUTERA'), ('L609', 'VALLELUNGA PRATAMENO'), ('L959', 'VILLALBA')],
    'CN': [('A016', 'ACCEGLIO'), ('A113', 'AISONE'), ('A124', 'ALBA'), ('A139', 'ALBARETTO DELLA TORRE'), ('A238', 'ALTO'), ('A394', 'ARGENTERA'), ('A396', 'ARGUELLO'), ('A555', 'BAGNASCO'), ('A571', 'BAGNOLO PIEMONTE'), ('A589', "BALDISSERO D'ALBA"), ('A629', 'BARBARESCO'), ('A660', 'BARGE'), ('A671', 'BAROLO'), ('A709', 'BASTIA MONDOVÌ'), ('A716', 'BATTIFOLLO'), ('A735', 'BEINETTE'), ('A750', 'BELLINO'), ('A774', 'BELVEDERE LANGHE'), ('A779', 'BENE VAGIENNA'), ('A782', 'BENEVELLO'), ('A798', 'BERGOLO'), ('A805', 'BERNEZZO'), ('A979', 'BONVICINO'), ('B033', 'BORGO SAN DALMAZZO'), ('B018', 'BORGOMALE'), ('B079', 'BOSIA'), ('B084', 'BOSSOLASCO'), ('B101', 'BOVES'), ('B111', 'BRA'), ('B167', 'BRIAGLIA'), ('B175', 'BRIGA ALTA'), ('B200', 'BRONDELLO'), ('B204', 'BROSSASCO'), ('B285', 'BUSCA'), ('B467', 'CAMERANA'), ('B573', 'CANALE'), ('B621', 'CANOSIO'), ('B692', 'CAPRAUNA'), ('B719', 'CARAGLIO'), ('B720', 'CARAMAGNA PIEMONTE'), ('B755', 'CARDÈ'), ('B841', 'CARRÙ'), ('B845', 'CARTIGNANO'), ('B894', 'CASALGRASSO'), ('C046', 'CASTAGNITO'), ('C081', 'CASTELDELFINO'), ('C165', 'CASTELLETTO STURA'), ('C167', 'CASTELLETTO UZZONE'), ('C173', "CASTELLINALDO D'ALBA"), ('C176', 'CASTELLINO TANARO'), ('C205', 'CASTELMAGNO'), ('C214', 'CASTELNUOVO DI CEVA'), ('C314', 'CASTIGLIONE FALLETTO'), ('C317', 'CASTIGLIONE TINELLA'), ('C323', 'CASTINO'), ('C375', 'CAVALLERLEONE'), ('C376', 'CAVALLERMAGGIORE'), ('C441', 'CELLE DI MACRA'), ('C466', 'CENTALLO'), ('C504', 'CERESOLE ALBA'), ('C530', 'CERRETTO LANGHE'), ('C547', 'CERVASCA'), ('C550', 'CERVERE'), ('C589', 'CEVA'), ('C599', 'CHERASCO'), ('C653', 'CHIUSA DI PESIO'), ('C681', 'CIGLIÈ'), ('C738', 'CISSONE'), ('C792', 'CLAVESANA'), ('D022', "CORNELIANO D'ALBA"), ('D062', 'CORTEMILIA'), ('D093', 'COSSANO BELBO'), ('D120', 'COSTIGLIOLE SALUZZO'), ('D133', 'CRAVANZANA'), ('D172', 'CRISSOLO'), ('D205', 'CUNEO'), ('D271', 'DEMONTE'), ('D291', "DIANO D'ALBA"), ('D314', 'DOGLIANI'), ('D372', 'DRONERO'), ('D401', 'ELVA'), ('D410', 'ENTRACQUE'), ('D412', 'ENVIE'), ('D499', 'FARIGLIANO'), ('D511', 'FAULE'), ('D523', 'FEISOGLIO'), ('D742', 'FOSSANO'), ('D751', 'FRABOSA SOPRANA'), ('D752', 'FRABOSA SOTTANA'), ('D782', 'FRASSINO'), ('D856', 'GAIOLA'), ('D894', 'GAMBASCA'), ('D920', 'GARESSIO'), ('D967', 'GENOLA'), ('E111', 'GORZEGNO'), ('E115', 'GOTTASECCA'), ('E118', 'GOVONE'), ('E182', 'GRINZANE CAVOUR'), ('E251', 'GUARENE'), ('E282', 'IGLIANO'), ('E327', 'ISASCA'), ('E430', 'LA MORRA'), ('E406', 'LAGNASCO'), ('E540', 'LEQUIO BERRIA'), ('E539', 'LEQUIO TANARO'), ('E546', 'LESEGNO'), ('E564', 'LEVICE'), ('E597', 'LIMONE PIEMONTE'), ('E615', 'LISIO'), ('E789', 'MACRA'), ('E809', 'MAGLIANO ALFIERI'), ('E808', 'MAGLIANO ALPI'), ('E887', 'MANGO'), ('E894', 'MANTA'), ('E939', 'MARENE'), ('E945', 'MARGARITA'), ('E963', 'MARMORA'), ('E973', 'MARSAGLIA'), ('E988', 'MARTINIANA PO'), ('F114', 'MELLE'), ('F279', 'MOIOLA'), ('F309', 'MOMBARCARO'), ('F312', 'MOMBASIGLIO'), ('F326', 'MONASTERO DI VASCO'), ('F329', 'MONASTEROLO CASOTTO'), ('F330', 'MONASTEROLO DI SAVIGLIANO'), ('F338', 'MONCHIERO'), ('F351', 'MONDOVÌ'), ('F355', 'MONESIGLIO'), ('F358', "MONFORTE D'ALBA"), ('F405', 'MONTALDO DI MONDOVÌ'), ('F408', 'MONTALDO ROERO'), ('F424', 'MONTANERA'), ('F550', 'MONTELUPO ALBESE'), ('F558', 'MONTEMALE DI CUNEO'), ('F608', 'MONTEROSSO GRANA'), ('F654', 'MONTEU ROERO'), ('F666', 'MONTEZEMOLO'), ('F669', "MONTICELLO D'ALBA"), ('F385', 'MONTÀ'), ('F723', 'MORETTA'), ('F743', 'MOROZZO'), ('F809', 'MURAZZANO'), ('F811', 'MURELLO'), ('F846', 'NARZOLE'), ('F863', 'NEIVE'), ('F883', 'NEVIGLIE'), ('F894', 'NIELLA BELBO'), ('F895', 'NIELLA TANARO'), ('F961', 'NOVELLO'), ('F972', 'NUCETTO'), ('G066', 'ONCINO'), ('G114', 'ORMEA'), ('G183', 'OSTANA'), ('G228', 'PAESANA'), ('G240', 'PAGNO'), ('G302', 'PAMPARATO'), ('G339', 'PAROLDO'), ('G457', 'PERLETTO'), ('G458', 'PERLO'), ('G526', 'PEVERAGNO'), ('G532', 'PEZZOLO VALLE UZZONE'), ('G561', 'PIANFEI'), ('G575', 'PIASCO'), ('G625', 'PIETRAPORZIO'), ('G683', "PIOBESI D'ALBA"), ('G697', 'PIOZZO'), ('G742', 'POCAPAGLIA'), ('G800', 'POLONGHERA'), ('G837', 'PONTECHIANALE'), ('G970', 'PRADLEVES'), ('H011', 'PRAZZO'), ('H059', 'PRIERO'), ('H068', 'PRIOCCA'), ('H069', 'PRIOLA'), ('H085', 'PRUNETTO'), ('H150', 'RACCONIGI'), ('H247', 'REVELLO'), ('H285', 'RIFREDDO'), ('H326', 'RITTANA'), ('H362', 'ROASCHIA'), ('H363', 'ROASCIO'), ('H377', 'ROBILANTE'), ('H378', 'ROBURENT'), ('H391', 'ROCCA CIGLIÈ'), ('H395', "ROCCA DE' BALDI"), ('H385', 'ROCCABRUNA'), ('H407', 'ROCCAFORTE MONDOVÌ'), ('H447', 'ROCCASPARVERA'), ('H453', 'ROCCAVIONE'), ('H462', 'ROCCHETTA BELBO'), ('H472', 'RODDI'), ('H473', 'RODDINO'), ('H474', 'RODELLO'), ('H578', 'ROSSANA'), ('H633', 'RUFFIA'), ('H695', 'SALE DELLE LANGHE'), ('H704', 'SALE SAN GIOVANNI'), ('H710', 'SALICETO'), ('H716', 'SALMOUR'), ('H727', 'SALUZZO'), ('H746', 'SAMBUCO'), ('H755', 'SAMPEYRE'), ('H770', 'SAN BENEDETTO BELBO'), ('H812', 'SAN DAMIANO MACRA'), ('I037', 'SAN MICHELE MONDOVÌ'), ('H852', 'SANFRONT'), ('H851', 'SANFRÈ'), ('I210', "SANT'ALBANO STURA"), ('I316', "SANTA VITTORIA D'ALBA"), ('I367', 'SANTO STEFANO BELBO'), ('I372', 'SANTO STEFANO ROERO'), ('I470', 'SAVIGLIANO'), ('I484', 'SCAGNELLO'), ('I512', 'SCARNAFIGI'), ('I646', "SERRALUNGA D'ALBA"), ('I659', 'SERRAVALLE LANGHE'), ('I750', 'SINIO'), ('I817', 'SOMANO'), ('I822', 'SOMMARIVA DEL BOSCO'), ('I823', 'SOMMARIVA PERNO'), ('I985', 'STROPPO'), ('L048', 'TARANTASCA'), ('L252', 'TORRE BORMIDA'), ('L241', 'TORRE MONDOVÌ'), ('L278', 'TORRE SAN GIORGIO'), ('L281', 'TORRESINA'), ('L367', 'TREISO'), ('L410', 'TREZZO TINELLA'), ('L427', 'TRINITÀ'), ('L558', 'VALDIERI'), ('L580', 'VALGRANA'), ('L631', 'VALLORIATE'), ('L729', 'VENASCA'), ('L758', 'VERDUNO'), ('L771', 'VERNANTE'), ('L804', 'VERZUOLO'), ('L817', "VEZZA D'ALBA"), ('L841', 'VICOFORTE'), ('L888', 'VIGNOLO'), ('L942', 'VILLAFALLETTO'), ('L974', 'VILLANOVA MONDOVÌ'), ('L990', 'VILLANOVA SOLARO'), ('M015', 'VILLAR SAN COSTANZO'), ('M055', 'VINADIO'), ('M063', 'VIOLA'), ('M136', 'VOTTIGNASCO')],
    'CO': [('A143', 'ALBAVILLA'), ('A153', 'ALBESE CON CASSANO'), ('A164', 'ALBIOLO'), ('A224', 'ALSERIO'), ('M383', 'ALTA VALLE INTELVI'), ('A249', 'ALZATE BRIANZA'), ('A319', 'ANZANO DEL PARCO'), ('A333', 'APPIANO GENTILE'), ('A391', 'ARGEGNO'), ('A430', 'AROSIO'), ('A476', 'ASSO'), ('A670', 'BARNI'), ('M335', 'BELLAGIO'), ('A778', 'BENE LARIO'), ('A791', 'BEREGAZZO CON FIGLIARO'), ('A870', 'BINAGO'), ('A898', 'BIZZARONE'), ('A904', 'BLESSAGNO'), ('A905', 'BLEVIO'), ('B134', 'BREGNANO'), ('B144', 'BRENNA'), ('B172', 'BRIENNO'), ('B218', 'BRUNATE'), ('B262', 'BULGAROGRASSO'), ('B313', 'CABIATE'), ('B346', 'CADORAGO'), ('B355', 'CAGLIO'), ('B513', "CAMPIONE D'ITALIA"), ('B639', 'CANTÙ'), ('B641', 'CANZO'), ('B653', 'CAPIAGO INTIMIANO'), ('B730', 'CARATE URIO'), ('B742', 'CARBONATE'), ('B778', 'CARIMATE'), ('B785', 'CARLAZZO'), ('B851', 'CARUGO'), ('B974', "CASLINO D'ERBA"), ('B977', 'CASNATE CON BERNATE'), ('C020', 'CASSINA RIZZARDI'), ('C206', 'CASTELMARTE'), ('C220', 'CASTELNUOVO BOZZENTE'), ('C381', 'CAVARGNA'), ('M394', 'CENTRO VALLE INTELVI'), ('C482', "CERANO D'INTELVI"), ('C516', 'CERMENATE'), ('C520', 'CERNOBBIO'), ('C724', 'CIRIMIDO'), ('C787', 'CLAINO CON OSTENO'), ('C902', 'COLONNO'), ('M336', 'COLVERDE'), ('C933', 'COMO'), ('D041', 'CORRIDO'), ('D147', 'CREMIA'), ('D196', 'CUCCIAGO'), ('D232', 'CUSINO'), ('D310', 'DIZZASCO'), ('D329', 'DOMASO'), ('D341', 'DONGO'), ('D355', 'DOSSO DEL LIRO'), ('D416', 'ERBA'), ('D445', 'EUPILIO'), ('D462', 'FAGGETO LARIO'), ('D482', 'FALOPPIO'), ('D531', 'FENEGRÒ'), ('D579', 'FIGINO SERENZA'), ('D605', 'FINO MORNASCO'), ('D930', 'GARZENO'), ('D974', 'GERA LARIO'), ('E139', 'GRANDATE'), ('E141', 'GRANDOLA ED UNITI'), ('M315', 'GRAVEDONA ED UNITI'), ('E172', 'GRIANTE'), ('E235', 'GUANZATE'), ('E309', 'INVERIGO'), ('E405', 'LAGLIO'), ('E416', 'LAINO'), ('E428', 'LAMBRUGO'), ('E462', 'LASNIGO'), ('E569', 'LEZZENO'), ('E593', 'LIMIDO COMASCO'), ('E607', 'LIPOMO'), ('E623', 'LIVO'), ('E638', 'LOCATE VARESINO'), ('E659', 'LOMAZZO'), ('E679', 'LONGONE AL SEGRINO'), ('E735', 'LUISAGO'), ('E749', "LURAGO D'ERBA"), ('E750', 'LURAGO MARINONE'), ('E753', 'LURATE CACCIVIO'), ('E830', 'MAGREGLIO'), ('E951', 'MARIANO COMENSE'), ('F017', 'MASLIANICO'), ('F120', 'MENAGGIO'), ('F151', 'MERONE'), ('F305', 'MOLTRASIO'), ('F372', 'MONGUZZO'), ('F427', 'MONTANO LUCINO'), ('F564', 'MONTEMEZZO'), ('F688', 'MONTORFANO'), ('F788', 'MOZZATE'), ('F828', 'MUSSO'), ('F877', 'NESSO'), ('F958', 'NOVEDRATE'), ('G025', 'OLGIATE COMASCO'), ('G056', 'OLTRONA DI SAN MAMETTE'), ('G126', 'ORSENIGO'), ('G415', 'PEGLIO'), ('G556', 'PIANELLO DEL LARIO'), ('G665', 'PIGRA'), ('G737', 'PLESIO'), ('G773', 'POGNANA LARIO'), ('G821', 'PONNA'), ('G847', 'PONTE LAMBRO'), ('G889', 'PORLEZZA'), ('H074', 'PROSERPIO'), ('H094', 'PUSIANO'), ('H255', 'REZZAGO'), ('H478', 'RODERO'), ('H521', 'RONAGO'), ('H601', 'ROVELLASCA'), ('H602', 'ROVELLO PORRO'), ('H679', 'SALA COMACINA'), ('H760', 'SAN BARTOLOMEO VAL CAVARGNA'), ('H840', 'SAN FERMO DELLA BATTAGLIA'), ('I051', 'SAN NAZZARO VAL CAVARGNA'), ('I162', 'SAN SIRO'), ('I529', 'SCHIGNANO'), ('I611', 'SENNA COMASCO'), ('M412', 'SOLBIATE CON CAGNO'), ('I856', 'SORICO'), ('I860', 'SORMANO'), ('I943', 'STAZZONA'), ('L071', 'TAVERNERIO'), ('L228', 'TORNO'), ('M341', 'TREMEZZINA'), ('L413', 'TREZZONE'), ('L470', 'TURATE'), ('L487', 'UGGIATE-TREVANO'), ('H259', 'VAL REZZO'), ('L547', 'VALBRONA'), ('L640', 'VALMOREA'), ('C936', 'VALSOLDA'), ('L715', 'VELESO'), ('L737', 'VENIANO'), ('L748', 'VERCANA'), ('L792', 'VERTEMATE CON MINOPRIO'), ('L956', 'VILLA GUARDIA'), ('M156', 'ZELBIO')],
    'CR': [('A039', 'ACQUANEGRA CREMONESE'), ('A076', 'AGNADELLO'), ('A299', 'ANNICCO'), ('A526', 'AZZANELLO'), ('A570', 'BAGNOLO CREMASCO'), ('A972', 'BONEMERSE'), ('A986', 'BORDOLANO'), ('B439', 'CALVATONE'), ('B484', 'CAMISANO'), ('B498', 'CAMPAGNOLA CREMASCA'), ('B650', 'CAPERGNANICA'), ('B679', 'CAPPELLA CANTONE'), ('B680', "CAPPELLA DE' PICENARDI"), ('B686', 'CAPRALBA'), ('B869', 'CASALBUTTANO ED UNITI'), ('B881', 'CASALE CREMASCO-VIDOLASCO'), ('B889', 'CASALETTO CEREDANO'), ('B890', 'CASALETTO DI SOPRA'), ('B891', 'CASALETTO VAPRIO'), ('B898', 'CASALMAGGIORE'), ('B900', 'CASALMORANO'), ('C115', 'CASTEL GABBIANO'), ('C089', 'CASTELDIDONE'), ('C153', 'CASTELLEONE'), ('B129', 'CASTELVERDE'), ('C290', 'CASTELVISCONTI'), ('C435', 'CELLA DATI'), ('C634', 'CHIEVE'), ('C678', 'CICOGNOLO'), ('C703', "CINGIA DE' BOTTI"), ('D056', "CORTE DE' CORTESI CON CIGNONE"), ('D057', "CORTE DE' FRATI"), ('D141', 'CREDERA RUBBIANO'), ('D142', 'CREMA'), ('D150', 'CREMONA'), ('D151', 'CREMOSANO'), ('D186', "CROTTA D'ADDA"), ('D203', 'CUMIGNANO SUL NAVIGLIO'), ('D278', 'DEROVERE'), ('D358', 'DOVERA'), ('D574', 'FIESCO'), ('D710', 'FORMIGARA'), ('D834', 'GABBIONETA-BINANUOVA'), ('D841', 'GADESCO-PIEVE DELMONA'), ('D966', 'GENIVOLTA'), ('D993', "GERRE DE' CAPRIOLI"), ('E082', 'GOMBITO'), ('E193', 'GRONTARDO'), ('E217', 'GRUMELLO CREMONESE ED UNITI'), ('E272', 'GUSSOLA'), ('E356', 'ISOLA DOVARESE'), ('E380', 'IZANO'), ('E793', 'MADIGNANO'), ('E843', 'MALAGNINO'), ('E983', 'MARTIGNANA DI PO'), ('F434', 'MONTE CREMASCO'), ('F681', 'MONTODINE'), ('F761', 'MOSCAZZANO'), ('F771', 'MOTTA BALUFFI'), ('G004', 'OFFANENGO'), ('G047', 'OLMENETA'), ('G185', 'OSTIANO'), ('G222', 'PADERNO PONCHIELLI'), ('G260', 'PALAZZO PIGNANO'), ('G306', 'PANDINO'), ('G469', 'PERSICO DOSIMO'), ('G483', 'PESCAROLO ED UNITI'), ('G504', 'PESSINA CREMONESE'), ('M418', 'PIADENA DRIZZONA'), ('G558', 'PIANENGO'), ('G603', 'PIERANICA'), ('G647', "PIEVE D'OLMI"), ('G651', 'PIEVE SAN GIACOMO'), ('G721', 'PIZZIGHETTONE'), ('B914', 'POZZAGLIO ED UNITI'), ('H130', 'QUINTANO'), ('H276', 'RICENGO'), ('H314', 'RIPALTA ARPINA'), ('H315', 'RIPALTA CREMASCA'), ('H316', 'RIPALTA GUERINA'), ('H341', 'RIVAROLO DEL RE ED UNITI'), ('H357', "RIVOLTA D'ADDA"), ('H372', "ROBECCO D'OGLIO"), ('H508', 'ROMANENGO'), ('H731', 'SALVIROLA'), ('H767', 'SAN BASSANO'), ('H815', 'SAN DANIELE PO'), ('H918', 'SAN GIOVANNI IN CROCE'), ('I007', 'SAN MARTINO DEL LAGO'), ('I497', 'SCANDOLARA RAVARA'), ('I498', "SCANDOLARA RIPA D'OGLIO"), ('I627', 'SERGNANO'), ('I683', 'SESTO ED UNITI'), ('I790', 'SOLAROLO RAINERIO'), ('I827', 'SONCINO'), ('I849', 'SORESINA'), ('I865', 'SOSPIRO'), ('I906', 'SPINADESCO'), ('I909', 'SPINEDA'), ('I914', "SPINO D'ADDA"), ('I935', 'STAGNO LOMBARDO'), ('L164', 'TICENGO'), ('L221', 'TORLINO VIMERCATI'), ('L225', 'TORNATA'), ('L258', "TORRE DE' PICENARDI"), ('L296', 'TORRICELLA DEL PIZZO'), ('L389', 'TRESCORE CREMASCO'), ('L426', 'TRIGOLO'), ('L535', 'VAIANO CREMASCO'), ('L539', 'VAILATE'), ('L806', 'VESCOVATO'), ('M116', 'VOLONGO'), ('M127', 'VOLTIDO')],
    'CS': [('A033', 'ACQUAFORMOSA'), ('A041', 'ACQUAPPESA'), ('A053', 'ACRI'), ('A102', 'AIELLO CALABRO'), ('A105', 'AIETA'), ('A160', 'ALBIDONA'), ('A183', 'ALESSANDRIA DEL CARRETTO'), ('A234', 'ALTILIA'), ('A240', 'ALTOMONTE'), ('A253', 'AMANTEA'), ('A263', 'AMENDOLARA'), ('A340', 'APRIGLIANO'), ('A762', 'BELMONTE CALABRO'), ('A768', 'BELSITO'), ('A773', 'BELVEDERE MARITTIMO'), ('A842', 'BIANCHI'), ('A887', 'BISIGNANO'), ('A912', 'BOCCHIGLIERO'), ('A973', 'BONIFATI'), ('B270', 'BUONVICINO'), ('B424', 'CALOPEZZATI'), ('B426', 'CALOVETO'), ('B500', 'CAMPANA'), ('B607', 'CANNA'), ('B774', 'CARIATI'), ('B802', 'CAROLEI'), ('B813', 'CARPANZANO'), ('M385', 'CASALI DEL MANCO'), ('C002', "CASSANO ALL'IONIO"), ('C301', 'CASTIGLIONE COSENTINO'), ('C108', 'CASTROLIBERO'), ('C348', 'CASTROREGIO'), ('C349', 'CASTROVILLARI'), ('C430', 'CELICO'), ('C437', 'CELLARA'), ('C489', 'CERCHIARA DI CALABRIA'), ('C515', 'CERISANO'), ('C554', 'CERVICATI'), ('C560', 'CERZETO'), ('C588', 'CETRARO'), ('C763', 'CIVITA'), ('C795', 'CLETO'), ('C905', 'COLOSIMI'), ('M403', 'CORIGLIANO-ROSSANO'), ('D086', 'COSENZA'), ('D180', 'CROPALATI'), ('D184', 'CROSIA'), ('D289', 'DIAMANTE'), ('D304', 'DIPIGNANO'), ('D328', 'DOMANICO'), ('D464', 'FAGNANO CASTELLO'), ('D473', 'FALCONARA ALBANESE'), ('D582', 'FIGLINE VEGLIATURO'), ('D614', 'FIRMO'), ('D624', 'FIUMEFREDDO BRUZIO'), ('D764', 'FRANCAVILLA MARITTIMA'), ('D774', 'FRASCINETO'), ('D828', 'FUSCALDO'), ('E180', 'GRIMALDI'), ('E185', 'GRISOLIA'), ('E242', 'GUARDIA PIEMONTESE'), ('E407', 'LAGO'), ('E417', 'LAINO BORGO'), ('E419', 'LAINO CASTELLO'), ('E450', 'LAPPANO'), ('E475', 'LATTARICO'), ('E677', 'LONGOBARDI'), ('E678', 'LONGOBUCCO'), ('E745', 'LUNGRO'), ('E773', 'LUZZI'), ('E835', 'MAIERÀ'), ('E859', 'MALITO'), ('E872', 'MALVITO'), ('E878', 'MANDATORICCIO'), ('E888', 'MANGONE'), ('E914', 'MARANO MARCHESATO'), ('E915', 'MARANO PRINCIPATO'), ('F001', 'MARZI'), ('F125', 'MENDICINO'), ('F370', 'MONGRASSANO'), ('F416', 'MONTALTO UFFUGO'), ('F519', 'MONTEGIORDANO'), ('F708', 'MORANO CALABRO'), ('F735', 'MORMANNO'), ('F775', 'MOTTAFOLLONE'), ('F907', 'NOCARA'), ('G110', 'ORIOLO'), ('G129', 'ORSOMARSO'), ('G298', 'PALUDI'), ('G307', 'PANETTIERI'), ('G317', 'PAOLA'), ('G320', 'PAPASIDERO'), ('G331', 'PARENTI'), ('G372', 'PATERNO CALABRO'), ('G411', 'PEDIVIGLIANO'), ('G553', 'PIANE CRATI'), ('G615', 'PIETRAFITTA'), ('G622', 'PIETRAPAOLA'), ('G733', 'PLATACI'), ('G975', 'PRAIA A MARE'), ('H235', 'RENDE'), ('H416', 'ROCCA IMPERIALE'), ('H488', 'ROGGIANO GRAVINA'), ('H490', 'ROGLIANO'), ('H565', 'ROSE'), ('H572', 'ROSETO CAPO SPULICO'), ('H585', 'ROTA GRECA'), ('H621', 'ROVITO'), ('H765', 'SAN BASILE'), ('H774', 'SAN BENEDETTO ULLANO'), ('H806', 'SAN COSMO ALBANESE'), ('H818', 'SAN DEMETRIO CORONE'), ('H825', 'SAN DONATO DI NINEA'), ('H841', 'SAN FILI'), ('H881', 'SAN GIORGIO ALBANESE'), ('H919', 'SAN GIOVANNI IN FIORE'), ('H961', 'SAN LORENZO BELLIZZI'), ('H962', 'SAN LORENZO DEL VALLO'), ('H971', 'SAN LUCIDO'), ('H981', 'SAN MARCO ARGENTANO'), ('H992', 'SAN MARTINO DI FINITA'), ('I060', 'SAN NICOLA ARCELLA'), ('I108', 'SAN PIETRO IN AMANTEA'), ('I114', 'SAN PIETRO IN GUARANO'), ('I165', 'SAN SOSTI'), ('I388', 'SAN VINCENZO LA COSTA'), ('H877', 'SANGINETO'), ('I192', "SANT'AGATA DI ESARO"), ('I171', 'SANTA CATERINA ALBANESE'), ('I183', 'SANTA DOMENICA TALAO'), ('C717', 'SANTA MARIA DEL CEDRO'), ('I309', "SANTA SOFIA D'EPIRO"), ('I359', 'SANTO STEFANO DI ROGLIANO'), ('I423', 'SARACENA'), ('I485', 'SCALA COELI'), ('I489', 'SCALEA'), ('D290', 'SCIGLIANO'), ('I642', "SERRA D'AIELLO"), ('I895', 'SPEZZANO ALBANESE'), ('I896', 'SPEZZANO DELLA SILA'), ('L055', 'TARSIA'), ('L124', 'TERRANOVA DA SIBARI'), ('L134', 'TERRAVECCHIA'), ('L206', 'TORANO CASTELLO'), ('L305', 'TORTORA'), ('L353', 'TREBISACCE'), ('L524', 'VACCARIZZO ALBANESE'), ('L747', 'VERBICARO'), ('B903', 'VILLAPIANA'), ('M202', 'ZUMPANO')],
    'CT': [('A025', 'ACI BONACCORSI'), ('A026', 'ACI CASTELLO'), ('A027', 'ACI CATENA'), ('A029', "ACI SANT'ANTONIO"), ('A028', 'ACIREALE'), ('A056', 'ADRANO'), ('A766', 'BELPASSO'), ('A841', 'BIANCAVILLA'), ('B202', 'BRONTE'), ('B384', 'CALATABIANO'), ('B428', 'CALTAGIRONE'), ('B561', 'CAMPOROTONDO ETNEO'), ('C091', 'CASTEL DI IUDICA'), ('C297', 'CASTIGLIONE DI SICILIA'), ('C351', 'CATANIA'), ('D623', 'FIUMEFREDDO DI SICILIA'), ('E017', 'GIARRE'), ('E133', 'GRAMMICHELE'), ('E156', 'GRAVINA DI CATANIA'), ('E578', 'LICODIA EUBEA'), ('E602', 'LINGUAGLOSSA'), ('E854', 'MALETTO'), ('M283', 'MANIACE'), ('F004', 'MASCALI'), ('F005', 'MASCALUCIA'), ('M271', 'MAZZARRONE'), ('F209', 'MILITELLO IN VAL DI CATANIA'), ('F214', 'MILO'), ('F217', 'MINEO'), ('F231', 'MIRABELLA IMBACCARI'), ('F250', 'MISTERBIANCO'), ('F781', "MOTTA SANT'ANASTASIA"), ('F890', 'NICOLOSI'), ('G253', 'PALAGONIA'), ('G371', 'PATERNÒ'), ('G402', 'PEDARA'), ('G597', 'PIEDIMONTE ETNEO'), ('H154', 'RADDUSA'), ('M287', 'RAGALNA'), ('H168', 'RAMACCA'), ('H175', 'RANDAZZO'), ('H325', 'RIPOSTO'), ('H805', 'SAN CONO'), ('H922', 'SAN GIOVANNI LA PUNTA'), ('H940', 'SAN GREGORIO DI CATANIA'), ('I035', 'SAN MICHELE DI GANZARIA'), ('I098', 'SAN PIETRO CLARENZA'), ('I202', "SANT'AGATA LI BATTIATI"), ('I216', "SANT'ALFIO"), ('I240', 'SANTA MARIA DI LICODIA'), ('I314', 'SANTA VENERINA'), ('I548', 'SCORDIA'), ('L355', 'TRECASTAGNI'), ('L369', 'TREMESTIERI ETNEO'), ('L658', 'VALVERDE'), ('L828', 'VIAGRANDE'), ('M100', 'VIZZINI'), ('M139', 'ZAFFERANA ETNEA')],
    'CZ': [('A155', 'ALBI'), ('A255', 'AMARONI'), ('A257', 'AMATO'), ('A272', 'ANDALI'), ('A397', 'ARGUSTO'), ('A542', 'BADOLATO'), ('A736', 'BELCASTRO'), ('B002', 'BORGIA'), ('B085', 'BOTRICELLO'), ('B717', 'CARAFFA DI CATANZARO'), ('B758', 'CARDINALE'), ('B790', 'CARLOPOLI'), ('C352', 'CATANZARO'), ('C453', 'CENADI'), ('C472', 'CENTRACHE'), ('C542', 'CERVA'), ('C616', 'CHIARAVALLE CENTRALE'), ('C674', 'CICALA'), ('C960', 'CONFLENTI'), ('D049', 'CORTALE'), ('D181', 'CROPANI'), ('D218', 'CURINGA'), ('D257', 'DAVOLI'), ('D261', 'DECOLLATURA'), ('D476', 'FALERNA'), ('D544', 'FEROLETO ANTICO'), ('D744', 'FOSSATO SERRALTA'), ('D852', 'GAGLIATO'), ('D932', 'GASPERINA'), ('E031', 'GIMIGLIANO'), ('E050', 'GIRIFALCO'), ('E068', 'GIZZERIA'), ('E239', 'GUARDAVALLE'), ('E328', 'ISCA SULLO IONIO'), ('E274', 'JACURSO'), ('M208', 'LAMEZIA TERME'), ('E806', 'MAGISANO'), ('E834', 'MAIDA'), ('E923', 'MARCEDUSA'), ('E925', 'MARCELLINARA'), ('E990', 'MARTIRANO'), ('E991', 'MARTIRANO LOMBARDO'), ('F200', 'MIGLIERINA'), ('F432', 'MONTAURO'), ('F586', 'MONTEPAONE'), ('F780', 'MOTTA SANTA LUCIA'), ('F910', 'NOCERA TERINESE'), ('G034', 'OLIVADI'), ('G272', 'PALERMITI'), ('G439', 'PENTONE'), ('G517', 'PETRIZZI'), ('G518', 'PETRONÀ'), ('D546', 'PIANOPOLI'), ('G734', 'PLATANIA'), ('H846', 'SAN FLORO'), ('H976', "SAN MANGO D'AQUINO"), ('I093', 'SAN PIETRO A MAIDA'), ('I095', 'SAN PIETRO APOSTOLO'), ('I164', 'SAN SOSTENE'), ('I393', 'SAN VITO SULLO IONIO'), ('I266', "SANT'ANDREA APOSTOLO DELLO IONIO"), ('I170', 'SANTA CATERINA DELLO IONIO'), ('I463', 'SATRIANO'), ('I589', 'SELLIA'), ('I590', 'SELLIA MARINA'), ('I655', 'SERRASTRETTA'), ('I671', 'SERSALE'), ('I704', 'SETTINGIANO'), ('I745', 'SIMERI CRICHI'), ('I844', 'SORBO SAN BASILE'), ('I872', 'SOVERATO'), ('I874', 'SOVERIA MANNELLI'), ('I875', 'SOVERIA SIMERI'), ('I929', 'SQUILLACE'), ('I937', 'STALETTÌ'), ('L070', 'TAVERNA'), ('L177', 'TIRIOLO'), ('L240', 'TORRE DI RUGGIERO'), ('I322', 'VALLEFIORITA'), ('M140', 'ZAGARISE')],
    'EN': [('A070', 'AGIRA'), ('A098', 'AIDONE'), ('A478', 'ASSORO'), ('A676', 'BARRAFRANCA'), ('B381', 'CALASCIBETTA'), ('C353', 'CATENANUOVA'), ('C471', 'CENTURIPE'), ('C480', 'CERAMI'), ('C342', 'ENNA'), ('D849', 'GAGLIANO CASTELFERRATO'), ('E536', 'LEONFORTE'), ('F892', 'NICOSIA'), ('F900', 'NISSORIA'), ('G580', 'PIAZZA ARMERINA'), ('G624', 'PIETRAPERZIA'), ('H221', 'REGALBUTO'), ('I891', 'SPERLINGA'), ('L448', 'TROINA'), ('L583', 'VALGUARNERA CAROPEPE'), ('M011', 'VILLAROSA')],
    'FC': [('A565', 'BAGNO DI ROMAGNA'), ('A809', 'BERTINORO'), ('B001', 'BORGHI'), ('C339', 'CASTROCARO TERME E TERRA DEL SOLE'), ('C573', 'CESENA'), ('C574', 'CESENATICO'), ('C777', 'CIVITELLA DI ROMAGNA'), ('D357', 'DOVADOLA'), ('D705', 'FORLIMPOPOLI'), ('D704', 'FORLÌ'), ('D867', 'GALEATA'), ('D899', 'GAMBETTOLA'), ('D935', 'GATTEO'), ('E675', 'LONGIANO'), ('F097', 'MELDOLA'), ('F139', 'MERCATO SARACENO'), ('F259', 'MODIGLIANA'), ('F668', 'MONTIANO'), ('G904', 'PORTICO E SAN BENEDETTO'), ('H017', 'PREDAPPIO'), ('H034', 'PREMILCUORE'), ('H437', 'ROCCA SAN CASCIANO'), ('H542', 'RONCOFREDDO'), ('I027', 'SAN MAURO PASCOLI'), ('I310', 'SANTA SOFIA'), ('I444', 'SARSINA'), ('I472', 'SAVIGNANO SUL RUBICONE'), ('I779', 'SOGLIANO AL RUBICONE'), ('L361', 'TREDOZIO'), ('L764', 'VERGHERETO')],
    'FE': [('A393', 'ARGENTA'), ('A965', 'BONDENO'), ('C469', 'CENTO'), ('C814', 'CODIGORO'), ('C912', 'COMACCHIO'), ('C980', 'COPPARO'), ('D548', 'FERRARA'), ('M323', 'FISCAGLIA'), ('E107', 'GORO'), ('E320', 'JOLANDA DI SAVOIA'), ('E410', 'LAGOSANTO'), ('F016', 'MASI TORELLO'), ('F156', 'MESOLA'), ('G184', 'OSTELLATO'), ('G768', 'POGGIO RENATICO'), ('G916', 'PORTOMAGGIORE'), ('M410', 'RIVA DEL PO'), ('M381', 'TERRE DEL RENO'), ('M409', 'TRESIGNANA'), ('L868', 'VIGARANO MAINARDA'), ('M110', 'VOGHIERA')],
    'FG': [('A015', 'ACCADIA'), ('A150', 'ALBERONA'), ('A320', 'ANZANO DI PUGLIA'), ('A339', 'APRICENA'), ('A463', 'ASCOLI SATRIANO'), ('A854', 'BICCARI'), ('B104', 'BOVINO'), ('B357', 'CAGNANO VARANO'), ('B584', 'CANDELA'), ('B724', 'CARAPELLE'), ('B784', 'CARLANTINO'), ('B829', 'CARPINO'), ('B904', 'CASALNUOVO MONTEROTARO'), ('B917', 'CASALVECCHIO DI PUGLIA'), ('C198', 'CASTELLUCCIO DEI SAURI'), ('C202', 'CASTELLUCCIO VALMAGGIORE'), ('C222', 'CASTELNUOVO DELLA DAUNIA'), ('C429', 'CELENZA VALFORTORE'), ('C442', 'CELLE DI SAN VITO'), ('C514', 'CERIGNOLA'), ('C633', 'CHIEUTI'), ('D269', 'DELICETO'), ('D459', 'FAETO'), ('D643', 'FOGGIA'), ('E332', 'ISCHITELLA'), ('E363', 'ISOLE TREMITI'), ('E549', 'LESINA'), ('E716', 'LUCERA'), ('E885', 'MANFREDONIA'), ('F059', 'MATTINATA'), ('F631', "MONTE SANT'ANGELO"), ('F538', 'MONTELEONE DI PUGLIA'), ('F777', 'MOTTA MONTECORVINO'), ('M266', 'ORDONA'), ('G125', 'ORSARA DI PUGLIA'), ('G131', 'ORTA NOVA'), ('G312', 'PANNI'), ('G487', 'PESCHICI'), ('G604', 'PIETRAMONTECORVINO'), ('G761', 'POGGIO IMPERIALE'), ('H287', 'RIGNANO GARGANICO'), ('H467', "ROCCHETTA SANT'ANTONIO"), ('H480', 'RODI GARGANICO'), ('H568', 'ROSETO VALFORTORE'), ('H926', 'SAN GIOVANNI ROTONDO'), ('H985', 'SAN MARCO IN LAMIS'), ('H986', 'SAN MARCO LA CATOLA'), ('I054', 'SAN NICANDRO GARGANICO'), ('I072', 'SAN PAOLO DI CIVITATE'), ('I158', 'SAN SEVERO'), ('I193', "SANT'AGATA DI PUGLIA"), ('I641', 'SERRACAPRIOLA'), ('I962', 'STORNARA'), ('I963', 'STORNARELLA'), ('L273', 'TORREMAGGIORE'), ('L447', 'TROIA'), ('L842', 'VICO DEL GARGANO'), ('L858', 'VIESTE'), ('M131', 'VOLTURARA APPULA'), ('M132', 'VOLTURINO'), ('M267', 'ZAPPONETA')],
    'FI': [('A564', 'BAGNO A RIPOLI'), ('A632', 'BARBERINO DI MUGELLO'), ('M408', 'BARBERINO TAVARNELLE'), ('B036', 'BORGO SAN LORENZO'), ('B406', 'CALENZANO'), ('B507', 'CAMPI BISENZIO'), ('B684', 'CAPRAIA E LIMITE'), ('C101', 'CASTELFIORENTINO'), ('C529', 'CERRETO GUIDI'), ('C540', 'CERTALDO'), ('D299', 'DICOMANO'), ('D403', 'EMPOLI'), ('D575', 'FIESOLE'), ('M321', 'FIGLINE E INCISA VALDARNO'), ('D612', 'FIRENZE'), ('D613', 'FIRENZUOLA'), ('D815', 'FUCECCHIO'), ('D895', 'GAMBASSI TERME'), ('E169', 'GREVE IN CHIANTI'), ('E291', 'IMPRUNETA'), ('E466', 'LASTRA A SIGNA'), ('E668', 'LONDA'), ('E971', 'MARRADI'), ('F398', 'MONTAIONE'), ('F551', 'MONTELUPO FIORENTINO'), ('F648', 'MONTESPERTOLI'), ('G270', 'PALAZZUOLO SUL SENIO'), ('G420', 'PELAGO'), ('G825', 'PONTASSIEVE'), ('H222', 'REGGELLO'), ('H286', "RIGNANO SULL'ARNO"), ('H635', 'RUFINA'), ('H791', 'SAN CASCIANO IN VAL DI PESA'), ('H937', 'SAN GODENZO'), ('B962', 'SCANDICCI'), ('M326', 'SCARPERIA E SAN PIERO'), ('I684', 'SESTO FIORENTINO'), ('I728', 'SIGNA'), ('L529', 'VAGLIA'), ('L838', 'VICCHIO'), ('M059', 'VINCI')],
    'FM': [('A233', 'ALTIDONA'), ('A252', 'AMANDOLA'), ('A760', 'BELMONTE PICENO'), ('B534', 'CAMPOFILONE'), ('D477', 'FALERONE'), ('D542', 'FERMO'), ('D760', "FRANCAVILLA D'ETE"), ('E208', 'GROTTAZZOLINA'), ('E447', 'LAPEDONA'), ('E807', 'MAGLIANO DI TENNA'), ('F021', 'MASSA FERMANA'), ('F379', 'MONSAMPIETRO MORICO'), ('F428', 'MONTAPPONE'), ('F517', 'MONTE GIBERTO'), ('F599', 'MONTE RINALDO'), ('F626', 'MONTE SAN PIETRANGELI'), ('F653', 'MONTE URANO'), ('F664', 'MONTE VIDON COMBATTE'), ('F665', 'MONTE VIDON CORRADO'), ('F493', 'MONTEFALCONE APPENNINO'), ('F509', 'MONTEFORTINO'), ('F520', 'MONTEGIORGIO'), ('F522', 'MONTEGRANARO'), ('F536', 'MONTELEONE DI FERMO'), ('F549', 'MONTELPARO'), ('F614', 'MONTERUBBIANO'), ('F697', 'MONTOTTONE'), ('F722', 'MORESCO'), ('G137', 'ORTEZZANO'), ('G403', 'PEDASO'), ('G516', 'PETRITOLI'), ('G873', 'PONZANO DI FERMO'), ('G920', 'PORTO SAN GIORGIO'), ('G921', "PORTO SANT'ELPIDIO"), ('H182', 'RAPAGNANO'), ('I324', "SANT'ELPIDIO A MARE"), ('I315', 'SANTA VITTORIA IN MATENANO'), ('C070', 'SERVIGLIANO'), ('I774', 'SMERILLO'), ('L279', 'TORRE SAN PATRIZIO')],
    'FR': [('A032', 'ACQUAFONDATA'), ('A054', 'ACUTO'), ('A123', 'ALATRI'), ('A244', 'ALVITO'), ('A256', 'AMASENO'), ('A269', 'ANAGNI'), ('A348', 'AQUINO'), ('A363', 'ARCE'), ('A421', 'ARNARA'), ('A433', 'ARPINO'), ('A486', 'ATINA'), ('A502', 'AUSONIA'), ('A763', 'BELMONTE CASTELLO'), ('A720', 'BOVILLE ERNICA'), ('B195', 'BROCCOSTELLA'), ('B543', 'CAMPOLI APPENNINO'), ('B862', 'CASALATTICO'), ('B919', 'CASALVIERI'), ('C034', 'CASSINO'), ('C177', 'CASTELLIRI'), ('C223', 'CASTELNUOVO PARANO'), ('C338', 'CASTRO DEI VOLSCI'), ('C340', 'CASTROCIELO'), ('C413', 'CECCANO'), ('C479', 'CEPRANO'), ('C545', 'CERVARO'), ('C836', 'COLFELICE'), ('C870', 'COLLE SAN MAGNO'), ('C864', 'COLLEPARDO'), ('C998', 'CORENO AUSONIO'), ('D440', 'ESPERIA'), ('D483', 'FALVATERRA'), ('D539', 'FERENTINO'), ('D591', 'FILETTINO'), ('A310', 'FIUGGI'), ('D667', 'FONTANA LIRI'), ('D682', 'FONTECHIARI'), ('D810', 'FROSINONE'), ('D819', 'FUMONE'), ('D881', 'GALLINARO'), ('E057', 'GIULIANO DI ROMA'), ('E236', 'GUARCINO'), ('E340', 'ISOLA DEL LIRI'), ('F620', 'MONTE SAN GIOVANNI CAMPANO'), ('F740', 'MOROLO'), ('G276', 'PALIANO'), ('G362', 'PASTENA'), ('G374', 'PATRICA'), ('G500', 'PESCOSOLIDO'), ('G591', 'PICINISCO'), ('G592', 'PICO'), ('G598', 'PIEDIMONTE SAN GERMANO'), ('G659', 'PIGLIO'), ('G662', 'PIGNATARO INTERAMNA'), ('G749', 'POFI'), ('G838', 'PONTECORVO'), ('G935', 'POSTA FIBRENO'), ('H324', 'RIPI'), ('H393', "ROCCA D'ARCE"), ('H443', 'ROCCASECCA'), ('H779', 'SAN BIAGIO SARACINISCO'), ('H824', 'SAN DONATO VAL DI COMINO'), ('H880', 'SAN GIORGIO A LIRI'), ('H917', 'SAN GIOVANNI INCARICO'), ('I408', 'SAN VITTORE DEL LAZIO'), ('I256', "SANT'AMBROGIO SUL GARIGLIANO"), ('I265', "SANT'ANDREA DEL GARIGLIANO"), ('I302', "SANT'APOLLINARE"), ('I321', "SANT'ELIA FIUMERAPIDO"), ('I351', 'SANTOPADRE'), ('I669', 'SERRONE'), ('I697', 'SETTEFRATI'), ('I716', 'SGURGOLA'), ('I838', 'SORA'), ('I973', 'STRANGOLAGALLI'), ('L009', 'SUPINO'), ('L105', 'TERELLE'), ('L243', 'TORRE CAJETANI'), ('L290', 'TORRICE'), ('L398', 'TREVI NEL LAZIO'), ('L437', 'TRIVIGLIANO'), ('L598', 'VALLECORSA'), ('L605', 'VALLEMAIO'), ('L614', 'VALLEROTONDA'), ('L780', 'VEROLI'), ('L836', 'VICALVI'), ('L843', 'VICO NEL LAZIO'), ('A081', 'VILLA LATINA'), ('L905', 'VILLA SANTA LUCIA'), ('I364', 'VILLA SANTO STEFANO'), ('M083', 'VITICUSO')],
    'GE': [('A388', 'ARENZANO'), ('A506', 'AVEGNO'), ('A658', 'BARGAGLI'), ('A922', 'BOGLIASCO'), ('B067', 'BORZONASCA'), ('B282', 'BUSALLA'), ('B490', 'CAMOGLI'), ('B538', 'CAMPO LIGURE'), ('B551', 'CAMPOMORONE'), ('B726', 'CARASCO'), ('B939', 'CASARZA LIGURE'), ('B956', 'CASELLA'), ('C302', 'CASTIGLIONE CHIAVARESE'), ('C481', 'CERANESI'), ('C621', 'CHIAVARI'), ('C673', 'CICAGNA'), ('C823', 'COGOLETO'), ('C826', 'COGORNO'), ('C995', 'COREGLIA LIGURE'), ('D175', 'CROCEFIESCHI'), ('D255', 'DAVAGNA'), ('D509', 'FASCIA'), ('D512', 'FAVALE DI MALVARO'), ('D677', 'FONTANIGORDA'), ('D969', 'GENOVA'), ('E109', 'GORRETO'), ('E341', 'ISOLA DEL CANTONE'), ('E488', 'LAVAGNA'), ('E519', 'LEIVI'), ('E695', 'LORSICA'), ('E737', 'LUMARZO'), ('F020', 'MASONE'), ('F098', 'MELE'), ('F173', 'MEZZANEGO'), ('F202', 'MIGNANEGO'), ('F256', 'MOCONESI'), ('F354', 'MONEGLIA'), ('F445', 'MONTEBRUNO'), ('F682', 'MONTOGGIO'), ('F858', 'NE'), ('F862', 'NEIRONE'), ('G093', 'ORERO'), ('G646', 'PIEVE LIGURE'), ('G913', 'PORTOFINO'), ('H073', 'PROPATA'), ('H183', 'RAPALLO'), ('H212', 'RECCO'), ('H258', 'REZZOAGLIO'), ('H536', 'RONCO SCRIVIA'), ('H546', 'RONDANINA'), ('H581', 'ROSSIGLIONE'), ('H599', 'ROVEGNO'), ('H802', 'SAN COLOMBANO CERTENOLI'), ('I346', "SANT'OLCESE"), ('I225', 'SANTA MARGHERITA LIGURE'), ('I368', "SANTO STEFANO D'AVETO"), ('I475', 'SAVIGNONE'), ('I640', 'SERRA RICCÒ'), ('I693', 'SESTRI LEVANTE'), ('I852', 'SORI'), ('L167', 'TIGLIETO'), ('L298', 'TORRIGLIA'), ('L416', 'TRIBOGNA'), ('L507', 'USCIO'), ('L546', 'VALBREVENNA'), ('M105', 'VOBBIA'), ('M182', 'ZOAGLI')],
    'GO': [('B712', 'CAPRIVA DEL FRIULI'), ('D014', 'CORMONS'), ('D312', 'DOBERDÒ DEL LAGO-DOBERDOB'), ('D321', 'DOLEGNA DEL COLLIO'), ('D504', "FARRA D'ISONZO"), ('D645', 'FOGLIANO REDIPUGLIA'), ('E098', 'GORIZIA'), ('E124', "GRADISCA D'ISONZO"), ('E125', 'GRADO'), ('E952', 'MARIANO DEL FRIULI'), ('F081', 'MEDEA'), ('F356', 'MONFALCONE'), ('F710', 'MORARO'), ('F767', 'MOSSA'), ('H514', "ROMANS D'ISONZO"), ('H531', 'RONCHI DEI LEGIONARI'), ('H665', 'SAGRADO'), ('H787', "SAN CANZIAN D'ISONZO"), ('H845', 'SAN FLORIANO DEL COLLIO-ŠTEVERJAN'), ('H964', 'SAN LORENZO ISONTINO'), ('I082', "SAN PIER D'ISONZO"), ('I479', "SAVOGNA D'ISONZO-SOVODNJE OB SO?I"), ('I939', 'STARANZANO'), ('L474', 'TURRIACO'), ('M043', 'VILLESSE')],
    'GR': [('A369', 'ARCIDOSSO'), ('B497', 'CAMPAGNATICO'), ('B646', 'CAPALBIO'), ('C085', 'CASTEL DEL PIANO'), ('C147', "CASTELL'AZZARA"), ('C310', 'CASTIGLIONE DELLA PESCAIA'), ('C705', 'CINIGIANO'), ('C782', 'CIVITELLA PAGANICO'), ('D656', 'FOLLONICA'), ('D948', 'GAVORRANO'), ('E202', 'GROSSETO'), ('E348', 'ISOLA DEL GIGLIO'), ('E810', 'MAGLIANO IN TOSCANA'), ('E875', 'MANCIANO'), ('F032', 'MASSA MARITTIMA'), ('F437', 'MONTE ARGENTARIO'), ('F612', 'MONTEROTONDO MARITTIMO'), ('F677', 'MONTIERI'), ('G088', 'ORBETELLO'), ('G716', 'PITIGLIANO'), ('H417', 'ROCCALBEGNA'), ('H449', 'ROCCASTRADA'), ('I187', 'SANTA FIORA'), ('I504', 'SCANSANO'), ('I510', 'SCARLINO'), ('I571', 'SEGGIANO'), ('I601', 'SEMPRONIANO'), ('I841', 'SORANO')],
    'IM': [('A111', 'AIROLE'), ('A338', 'APRICALE'), ('A344', "AQUILA D'ARROSCIA"), ('A418', 'ARMO'), ('A499', 'AURIGO'), ('A536', 'BADALUCCO'), ('A581', 'BAJARDO'), ('A984', 'BORDIGHERA'), ('A993', "BORGHETTO D'ARROSCIA"), ('B020', 'BORGOMARO'), ('B559', 'CAMPOROSSO'), ('B734', 'CARAVONICA'), ('C110', 'CASTEL VITTORIO'), ('C143', 'CASTELLARO'), ('C511', 'CERIANA'), ('C559', 'CERVO'), ('C578', 'CESIO'), ('C657', 'CHIUSANICO'), ('C660', 'CHIUSAVECCHIA'), ('C718', 'CIPRESSA'), ('C755', 'CIVEZZA'), ('D087', "COSIO D'ARROSCIA"), ('D114', 'COSTARAINERA'), ('D293', 'DIANO ARENTINO'), ('D296', 'DIANO CASTELLO'), ('D297', 'DIANO MARINA'), ('D298', 'DIANO SAN PIETRO'), ('D318', 'DOLCEACQUA'), ('D319', 'DOLCEDO'), ('E290', 'IMPERIA'), ('E346', 'ISOLABONA'), ('E719', 'LUCINASCO'), ('F123', 'MENDATICA'), ('F290', 'MOLINI DI TRIORA'), ('M387', 'MONTALTO CARPASIO'), ('F528', 'MONTEGROSSO PIAN LATTE'), ('G041', 'OLIVETTA SAN MICHELE'), ('G164', 'OSPEDALETTI'), ('G454', 'PERINALDO'), ('G607', 'PIETRABRUNA'), ('G632', 'PIEVE DI TECO'), ('G660', 'PIGNA'), ('G814', 'POMPEIANA'), ('G840', 'PONTEDASSIO'), ('G890', 'PORNASSIO'), ('H027', 'PRELÀ'), ('H180', 'RANZO'), ('H257', 'REZZO'), ('H328', 'RIVA LIGURE'), ('H460', 'ROCCHETTA NERVINA'), ('H763', 'SAN BARTOLOMEO AL MARE'), ('H780', 'SAN BIAGIO DELLA CIMA'), ('H957', 'SAN LORENZO AL MARE'), ('I138', 'SANREMO'), ('I365', 'SANTO STEFANO AL MARE'), ('I556', 'SEBORGA'), ('I796', 'SOLDANO'), ('L024', 'TAGGIA'), ('L146', 'TERZORIO'), ('L430', 'TRIORA'), ('L596', 'VALLEBONA'), ('L599', 'VALLECROSIA'), ('L693', 'VASIA'), ('L741', 'VENTIMIGLIA'), ('L809', 'VESSALICO'), ('L943', 'VILLA FARALDI')],
    'IS': [('A051', "ACQUAVIVA D'ISERNIA"), ('A080', 'AGNONE'), ('A567', 'BAGNOLI DEL TRIGNO'), ('A761', 'BELMONTE DEL SANNIO'), ('B630', 'CANTALUPO NEL SANNIO'), ('B682', 'CAPRACOTTA'), ('B810', 'CAROVILLI'), ('B830', 'CARPINONE'), ('C082', 'CASTEL DEL GIUDICE'), ('C270', 'CASTEL SAN VINCENZO'), ('C246', 'CASTELPETROSO'), ('C247', 'CASTELPIZZUTO'), ('C200', 'CASTELVERRINO'), ('C534', 'CERRO AL VOLTURNO'), ('C620', 'CHIAUCI'), ('C769', 'CIVITANOVA DEL SANNIO'), ('C878', 'COLLI A VOLTURNO'), ('C941', 'CONCA CASALE'), ('D595', 'FILIGNANO'), ('D703', 'FORLÌ DEL SANNIO'), ('D715', 'FORNELLI'), ('D811', 'FROSOLONE'), ('E335', 'ISERNIA'), ('E669', 'LONGANO'), ('E778', "MACCHIA D'ISERNIA"), ('E779', 'MACCHIAGODENA'), ('F239', 'MIRANDA'), ('F429', 'MONTAQUILA'), ('F580', 'MONTENERO VAL COCCHIARA'), ('F601', 'MONTERODUNI'), ('G486', 'PESCHE'), ('G495', 'PESCOLANCIANO'), ('G497', 'PESCOPENNATARO'), ('G523', 'PETTORANELLO DEL MOLISE'), ('G606', 'PIETRABBONDANTE'), ('G727', 'PIZZONE'), ('B317', 'POGGIO SANNITA'), ('G954', 'POZZILLI'), ('H308', 'RIONERO SANNITICO'), ('H420', 'ROCCAMANDOLFI'), ('H445', 'ROCCASICURA'), ('H458', 'ROCCHETTA A VOLTURNO'), ('I096', 'SAN PIETRO AVELLANA'), ('I189', "SANT'AGAPITO"), ('I282', "SANT'ANGELO DEL PESCO"), ('B466', "SANT'ELENA SANNITA"), ('I238', 'SANTA MARIA DEL MOLISE'), ('I507', 'SCAPOLI'), ('I679', 'SESSANO DEL MOLISE'), ('I682', 'SESTO CAMPANO'), ('L696', 'VASTOGIRARDI'), ('L725', 'VENAFRO')],
    'KR': [('A772', 'BELVEDERE DI SPINELLO'), ('B319', 'CACCURI'), ('B771', 'CARFIZZI'), ('B857', 'CASABONA'), ('B968', 'CASTELSILANO'), ('C501', 'CERENZIA'), ('C725', 'CIRÒ'), ('C726', 'CIRÒ MARINA'), ('D123', 'COTRONEI'), ('D122', 'CROTONE'), ('D189', 'CRUCOLI'), ('D236', 'CUTRO'), ('E339', 'ISOLA DI CAPO RIZZUTO'), ('F108', 'MELISSA'), ('F157', 'MESORACA'), ('G278', 'PALLAGORIO'), ('G508', 'PETILIA POLICASTRO'), ('H403', 'ROCCA DI NETO'), ('H383', 'ROCCABERNARDA'), ('I026', 'SAN MAURO MARCHESATO'), ('I057', "SAN NICOLA DELL'ALTO"), ('I308', 'SANTA SEVERINA'), ('I468', 'SAVELLI'), ('I494', 'SCANDALE'), ('I982', 'STRONGOLI'), ('L492', 'UMBRIATICO'), ('L802', 'VERZINO')],
    'LC': [('A005', 'ABBADIA LARIANA'), ('A112', 'AIRUNO'), ('A301', 'ANNONE DI BRIANZA'), ('A594', 'BALLABIO'), ('A683', 'BARZAGO'), ('A686', 'BARZANÒ'), ('A687', 'BARZIO'), ('A745', 'BELLANO'), ('B081', 'BOSISIO PARINI'), ('B194', 'BRIVIO'), ('B261', 'BULCIAGO'), ('B396', 'CALCO'), ('B423', 'CALOLZIOCORTE'), ('B763', 'CARENNO'), ('B937', 'CASARGO'), ('B943', 'CASATENOVO'), ('B996', 'CASSAGO BRIANZA'), ('C024', 'CASSINA VALSASSINA'), ('C187', 'CASTELLO DI BRIANZA'), ('C521', 'CERNUSCO LOMBARDONE'), ('C563', 'CESANA BRIANZA'), ('C752', 'CIVATE'), ('C839', 'COLICO'), ('C851', 'COLLE BRIANZA'), ('D065', 'CORTENOVA'), ('D112', 'COSTA MASNAGA'), ('D131', 'CRANDOLA VALSASSINA'), ('D143', 'CREMELLA'), ('D145', 'CREMENO'), ('D280', 'DERVIO'), ('D327', 'DOLZAGO'), ('D346', 'DORIO'), ('D398', 'ELLO'), ('D428', 'ERVE'), ('D436', 'ESINO LARIO'), ('D865', 'GALBIATE'), ('D913', 'GARBAGNATE MONASTERO'), ('D926', 'GARLATE'), ('E287', 'IMBERSAGO'), ('E305', 'INTROBIO'), ('M348', 'LA VALLETTA BRIANZA'), ('E507', 'LECCO'), ('E581', 'LIERNA'), ('E656', 'LOMAGNA'), ('E858', 'MALGRATE'), ('E879', 'MANDELLO DEL LARIO'), ('E947', 'MARGNO'), ('F133', 'MERATE'), ('F248', 'MISSAGLIA'), ('F265', 'MOGGIO'), ('F304', 'MOLTENO'), ('F561', 'MONTE MARENZO'), ('F657', 'MONTEVECCHIA'), ('F674', 'MONTICELLO BRIANZA'), ('F758', 'MORTERONE'), ('F887', 'NIBIONNO'), ('G009', 'OGGIONO'), ('G026', 'OLGIATE MOLGORA'), ('G030', 'OLGINATE'), ('G040', 'OLIVETO LARIO'), ('G161', 'OSNAGO'), ('G218', "PADERNO D'ADDA"), ('G241', 'PAGNONA'), ('G336', 'PARLASCO'), ('G368', 'PASTURO'), ('G456', 'PERLEDO'), ('G485', 'PESCATE'), ('H028', 'PREMANA'), ('H063', 'PRIMALUNA'), ('G223', 'ROBBIATE'), ('H486', 'ROGENO'), ('I243', 'SANTA MARIA HOÈ'), ('I759', 'SIRONE'), ('I761', 'SIRTORI'), ('I994', 'SUEGLIO'), ('I996', 'SUELLO'), ('L022', 'TACENO'), ('L581', 'VALGREGHENTINO'), ('L634', 'VALMADRERA'), ('M395', 'VALVARRONE'), ('L680', 'VARENNA'), ('L751', 'VERCURAGO'), ('M337', 'VERDERIO'), ('L866', 'VIGANÒ')],
    'LE': [('A184', 'ALESSANO'), ('A185', 'ALEZIO'), ('A208', 'ALLISTE'), ('A281', 'ANDRANO'), ('A350', 'ARADEO'), ('A425', 'ARNESANO'), ('A572', 'BAGNOLO DEL SALENTO'), ('B086', 'BOTRUGNO'), ('B413', 'CALIMERA'), ('B506', 'CAMPI SALENTINA'), ('B616', 'CANNOLE'), ('B690', 'CAPRARICA DI LECCE'), ('B792', 'CARMIANO'), ('B822', 'CARPIGNANO SALENTINO'), ('B936', 'CASARANO'), ('C334', 'CASTRI DI LECCE'), ('C335', "CASTRIGNANO DE' GRECI"), ('C336', 'CASTRIGNANO DEL CAPO'), ('M261', 'CASTRO'), ('C377', 'CAVALLINO'), ('C865', 'COLLEPASSO'), ('C978', 'COPERTINO'), ('D006', "CORIGLIANO D'OTRANTO"), ('D044', 'CORSANO'), ('D223', 'CURSI'), ('D237', 'CUTROFIANO'), ('D305', 'DISO'), ('D851', 'GAGLIANO DEL CAPO'), ('D862', 'GALATINA'), ('D863', 'GALATONE'), ('D883', 'GALLIPOLI'), ('E053', 'GIUGGIANELLO'), ('E061', 'GIURDIGNANO'), ('E227', 'GUAGNANO'), ('E506', 'LECCE'), ('E538', 'LEQUILE'), ('E563', 'LEVERANO'), ('E629', 'LIZZANELLO'), ('E815', 'MAGLIE'), ('E979', 'MARTANO'), ('E984', 'MARTIGNANO'), ('F054', 'MATINO'), ('F101', 'MELENDUGNO'), ('F109', 'MELISSANO'), ('F117', 'MELPIGNANO'), ('F194', 'MIGGIANO'), ('F221', 'MINERVINO DI LECCE'), ('F604', 'MONTERONI DI LECCE'), ('F623', 'MONTESANO SALENTINO'), ('F716', 'MORCIANO DI LEUCA'), ('F816', 'MURO LECCESE'), ('F842', 'NARDÒ'), ('F881', 'NEVIANO'), ('F916', 'NOCIGLIA'), ('F970', 'NOVOLI'), ('G136', 'ORTELLE'), ('G188', 'OTRANTO'), ('G285', 'PALMARIGGI'), ('G325', 'PARABITA'), ('G378', 'PATÙ'), ('G751', 'POGGIARDO'), ('M263', 'PORTO CESAREO'), ('M428', 'PRESICCE-ACQUARICA'), ('H147', 'RACALE'), ('H632', 'RUFFANO'), ('H708', 'SALICE SALENTINO'), ('H729', 'SALVE'), ('M264', 'SAN CASSIANO'), ('H793', 'SAN CESARIO DI LECCE'), ('H826', 'SAN DONATO DI LECCE'), ('I115', 'SAN PIETRO IN LAMA'), ('H757', 'SANARICA'), ('I059', 'SANNICOLA'), ('I172', 'SANTA CESAREA TERME'), ('I549', 'SCORRANO'), ('I559', 'SECLÌ'), ('I780', 'SOGLIANO CAVOUR'), ('I800', 'SOLETO'), ('I887', 'SPECCHIA'), ('I923', 'SPONGANO'), ('I930', 'SQUINZANO'), ('I950', 'STERNATIA'), ('L008', 'SUPERSANO'), ('L010', 'SURANO'), ('L011', 'SURBO'), ('L064', 'TAURISANO'), ('L074', 'TAVIANO'), ('L166', 'TIGGIANO'), ('L383', 'TREPUZZI'), ('L419', 'TRICASE'), ('L462', 'TUGLIE'), ('L484', 'UGENTO'), ('L485', 'UGGIANO LA CHIESA'), ('L711', 'VEGLIE'), ('L776', 'VERNOLE'), ('M187', 'ZOLLINO')],
    'LI': [('A852', 'BIBBONA'), ('B509', 'CAMPIGLIA MARITTIMA'), ('B553', "CAMPO NELL'ELBA"), ('B669', 'CAPOLIVERI'), ('B685', 'CAPRAIA ISOLA'), ('C044', 'CASTAGNETO CARDUCCI'), ('C415', 'CECINA'), ('C869', 'COLLESALVETTI'), ('E625', 'LIVORNO'), ('E930', 'MARCIANA'), ('E931', 'MARCIANA MARINA'), ('G687', 'PIOMBINO'), ('E680', 'PORTO AZZURRO'), ('G912', 'PORTOFERRAIO'), ('M391', 'RIO'), ('H570', 'ROSIGNANO MARITTIMO'), ('I390', 'SAN VINCENZO'), ('I454', 'SASSETTA'), ('L019', 'SUVERETO')],
    'LO': [('A004', 'ABBADIA CERRETO'), ('A811', 'BERTONICO'), ('A919', "BOFFALORA D'ADDA"), ('A995', 'BORGHETTO LODIGIANO'), ('B017', 'BORGO SAN GIOVANNI'), ('B141', 'BREMBIO'), ('B887', 'CASALETTO LODIGIANO'), ('B899', 'CASALMAIOCCO'), ('B910', 'CASALPUSTERLENGO'), ('B961', 'CASELLE LANDI'), ('B958', 'CASELLE LURANI'), ('M393', 'CASTELGERUNDO'), ('C228', "CASTELNUOVO BOCCA D'ADDA"), ('C304', "CASTIGLIONE D'ADDA"), ('C329', 'CASTIRAGA VIDARDO'), ('C394', "CAVENAGO D'ADDA"), ('C555', "CERVIGNANO D'ADDA"), ('C816', 'CODOGNO'), ('C917', 'COMAZZO'), ('D021', 'CORNEGLIANO LAUDENSE'), ('D028', 'CORNO GIOVINE'), ('D029', 'CORNOVECCHIO'), ('D068', 'CORTE PALASIO'), ('D159', 'CRESPIATICA'), ('D660', 'FOMBIO'), ('D868', 'GALGAGNANO'), ('E127', 'GRAFFIGNANA'), ('E238', 'GUARDAMIGLIO'), ('E627', 'LIVRAGA'), ('E648', 'LODI'), ('E651', 'LODI VECCHIO'), ('E777', 'MACCASTORNA'), ('E840', 'MAIRAGO'), ('E852', 'MALEO'), ('E994', 'MARUDO'), ('F028', 'MASSALENGO'), ('F102', 'MELETI'), ('F149', 'MERLINO'), ('F423', 'MONTANASO LOMBARDO'), ('F801', 'MULAZZANO'), ('G107', 'ORIO LITTA'), ('G166', 'OSPEDALETTO LODIGIANO'), ('G171', 'OSSAGO LODIGIANO'), ('G096', 'PIEVE FISSIRAGA'), ('H701', 'SALERANO SUL LAMBRO'), ('H844', 'SAN FIORANO'), ('I012', 'SAN MARTINO IN STRADA'), ('I140', 'SAN ROCCO AL PORTO'), ('I274', "SANT'ANGELO LODIGIANO"), ('I362', 'SANTO STEFANO LODIGIANO'), ('I561', 'SECUGNAGO'), ('I612', 'SENNA LODIGIANA'), ('I815', 'SOMAGLIA'), ('I848', 'SORDIO'), ('F260', 'TAVAZZANO CON VILLAVESCO'), ('L125', 'TERRANOVA DEI PASSERINI'), ('L469', 'TURANO LODIGIANO'), ('L572', 'VALERA FRATTA'), ('L977', 'VILLANOVA DEL SILLARO'), ('M158', 'ZELO BUON PERSICO')],
    'LT': [('A341', 'APRILIA'), ('A707', 'BASSIANO'), ('B527', 'CAMPODIMELE'), ('C104', 'CASTELFORTE'), ('C740', 'CISTERNA DI LATINA'), ('D003', 'CORI'), ('D662', 'FONDI'), ('D708', 'FORMIA'), ('D843', 'GAETA'), ('E375', 'ITRI'), ('E472', 'LATINA'), ('E527', 'LENOLA'), ('E798', 'MAENZA'), ('F224', 'MINTURNO'), ('F616', 'MONTE SAN BIAGIO'), ('F937', 'NORMA'), ('G865', 'PONTINIA'), ('G871', 'PONZA'), ('G698', 'PRIVERNO'), ('H076', 'PROSSEDI'), ('H421', 'ROCCA MASSIMA'), ('H413', 'ROCCAGORGA'), ('H444', 'ROCCASECCA DEI VOLSCI'), ('H647', 'SABAUDIA'), ('H836', 'SAN FELICE CIRCEO'), ('I339', 'SANTI COSMA E DAMIANO'), ('I634', 'SERMONETA'), ('I712', 'SEZZE'), ('I832', 'SONNINO'), ('I892', 'SPERLONGA'), ('I902', 'SPIGNO SATURNIA'), ('L120', 'TERRACINA'), ('L742', 'VENTOTENE')],
    'LU': [('A241', 'ALTOPASCIO'), ('A560', 'BAGNI DI LUCCA'), ('A657', 'BARGA'), ('B007', 'BORGO A MOZZANO'), ('B455', 'CAMAIORE'), ('B557', 'CAMPORGIANO'), ('B648', 'CAPANNORI'), ('B760', 'CAREGGINE'), ('C236', 'CASTELNUOVO DI GARFAGNANA'), ('C303', 'CASTIGLIONE DI GARFAGNANA'), ('C996', 'COREGLIA ANTELMINELLI'), ('M319', 'FABBRICHE DI VERGEMOLI'), ('D730', 'FORTE DEI MARMI'), ('D734', 'FOSCIANDORA'), ('D874', 'GALLICANO'), ('E715', 'LUCCA'), ('F035', 'MASSAROSA'), ('F225', 'MINUCCIANO'), ('F283', 'MOLAZZANA'), ('F452', 'MONTECARLO'), ('G480', 'PESCAGLIA'), ('G582', 'PIAZZA AL SERCHIO'), ('G628', 'PIETRASANTA'), ('G648', 'PIEVE FOSCIANA'), ('G882', 'PORCARI'), ('I142', 'SAN ROMANO IN GARFAGNANA'), ('I622', 'SERAVEZZA'), ('M347', 'SILLANO GIUNCUGNANO'), ('I942', 'STAZZEMA'), ('L533', 'VAGLI SOTTO'), ('L833', 'VIAREGGIO'), ('L913', 'VILLA BASILICA'), ('L926', 'VILLA COLLEMANDINA')],
    'MB': [('A087', 'AGRATE BRIANZA'), ('A096', 'AICURZIO'), ('A159', 'ALBIATE'), ('A376', 'ARCORE'), ('A668', 'BARLASSINA'), ('A759', 'BELLUSCO'), ('A802', 'BERNAREGGIO'), ('A818', 'BESANA IN BRIANZA'), ('A849', 'BIASSONO'), ('B105', 'BOVISIO-MASCIAGO'), ('B187', 'BRIOSCO'), ('B212', 'BRUGHERIO'), ('B272', 'BURAGO DI MOLGORA'), ('B289', 'BUSNAGO'), ('B501', 'CAMPARADA'), ('B671', 'CAPONAGO'), ('B729', 'CARATE BRIANZA'), ('B798', 'CARNATE'), ('C395', 'CAVENAGO DI BRIANZA'), ('C512', 'CERIANO LAGHETTO'), ('C566', 'CESANO MADERNO'), ('C820', 'COGLIATE'), ('C952', 'CONCOREZZO'), ('D019', "CORNATE D'ADDA"), ('D038', 'CORREZZANA'), ('D286', 'DESIO'), ('E063', 'GIUSSANO'), ('E504', 'LAZZATE'), ('E530', 'LENTATE SUL SEVESO'), ('E550', 'LESMO'), ('E591', 'LIMBIATE'), ('E617', 'LISSONE'), ('E786', 'MACHERIO'), ('F078', 'MEDA'), ('F165', 'MEZZAGO'), ('F247', 'MISINTO'), ('F704', 'MONZA'), ('F797', 'MUGGIÒ'), ('F944', 'NOVA MILANESE'), ('G116', 'ORNAGO'), ('H233', 'RENATE'), ('H529', 'RONCELLO'), ('H537', 'RONCO BRIANTINO'), ('I625', 'SEREGNO'), ('I709', 'SEVESO'), ('I878', 'SOVICO'), ('I998', 'SULBIATE'), ('L434', 'TRIUGGIO'), ('L511', 'USMATE VELATE'), ('L677', 'VAREDO'), ('L704', 'VEDANO AL LAMBRO'), ('L709', 'VEDUGGIO CON COLZANO'), ('L744', 'VERANO BRIANZA'), ('M017', 'VILLASANTA'), ('M052', 'VIMERCATE')],
    'MC': [('A329', 'APIRO'), ('A334', 'APPIGNANO'), ('A739', 'BELFORTE DEL CHIENTI'), ('A947', 'BOLOGNOLA'), ('B398', 'CALDAROLA'), ('B474', 'CAMERINO'), ('B562', 'CAMPOROTONDO DI FIASTRONE'), ('C251', 'CASTELRAIMONDO'), ('C267', 'CASTELSANTANGELO SUL NERA'), ('C582', 'CESSAPALOMBO'), ('C704', 'CINGOLI'), ('C770', 'CIVITANOVA MARCHE'), ('C886', 'COLMURANO'), ('D042', 'CORRIDONIA'), ('D429', 'ESANATOGLIA'), ('D564', 'FIASTRA'), ('D628', 'FIUMINATA'), ('D853', 'GAGLIOLE'), ('E228', 'GUALDO'), ('E694', 'LORO PICENO'), ('E783', 'MACERATA'), ('F051', 'MATELICA'), ('F268', 'MOGLIANO'), ('F460', 'MONTE CAVALLO'), ('F621', 'MONTE SAN GIUSTO'), ('F622', 'MONTE SAN MARTINO'), ('F454', 'MONTECASSIANO'), ('F482', 'MONTECOSARO'), ('F496', 'MONTEFANO'), ('F552', 'MONTELUPONE'), ('F749', 'MORROVALLE'), ('F793', 'MUCCIA'), ('G436', 'PENNA SAN GIOVANNI'), ('G515', 'PETRIOLO'), ('G657', 'PIEVE TORINA'), ('G690', 'PIORACO'), ('D566', 'POGGIO SAN VICINO'), ('F567', 'POLLENZA'), ('G919', 'PORTO RECANATI'), ('F632', 'POTENZA PICENA'), ('H211', 'RECANATI'), ('H323', 'RIPE SAN GINESIO'), ('H876', 'SAN GINESIO'), ('I156', 'SAN SEVERINO MARCHE'), ('I286', "SANT'ANGELO IN PONTANO"), ('I436', 'SARNANO'), ('I569', 'SEFRO'), ('I651', 'SERRAPETRONA'), ('I661', 'SERRAVALLE DI CHIENTI'), ('L191', 'TOLENTINO'), ('L366', 'TREIA'), ('L501', 'URBISAGLIA'), ('L517', 'USSITA'), ('M382', 'VALFORNACE'), ('M078', 'VISSO')],
    'ME': [('M211', 'ACQUEDOLCI'), ('A177', 'ALCARA LI FUSI'), ('A194', 'ALÌ'), ('A201', 'ALÌ TERME'), ('A313', 'ANTILLO'), ('A638', 'BARCELLONA POZZO DI GOTTO'), ('A698', 'BASICÒ'), ('B198', 'BROLO'), ('B660', 'CAPIZZI'), ('B666', "CAPO D'ORLANDO"), ('B695', 'CAPRI LEONE'), ('B804', 'CARONIA'), ('B918', 'CASALVECCHIO SICULO'), ('C094', 'CASTEL DI LUCIO'), ('C051', "CASTELL'UMBERTO"), ('C210', 'CASTELMOLA'), ('C347', 'CASTROREALE'), ('C568', 'CESARÒ'), ('C956', 'CONDRÒ'), ('D474', 'FALCONE'), ('D569', 'FICARRA'), ('D622', 'FIUMEDINISI'), ('D635', 'FLORESTA'), ('D661', 'FONDACHELLI-FANTINA'), ('D733', "FORZA D'AGRÒ"), ('D765', 'FRANCAVILLA DI SICILIA'), ('D793', 'FRAZZANÒ'), ('D824', 'FURCI SICULO'), ('D825', 'FURNARI'), ('D844', 'GAGGI'), ('D861', 'GALATI MAMERTINO'), ('D885', 'GALLODORO'), ('E014', 'GIARDINI-NAXOS'), ('E043', 'GIOIOSA MAREA'), ('E142', 'GRANITI'), ('E233', 'GUALTIERI SICAMINÒ'), ('E374', 'ITALA'), ('E523', 'LENI'), ('E555', 'LETOJANNI'), ('E571', 'LIBRIZZI'), ('E594', 'LIMINA'), ('E606', 'LIPARI'), ('E674', 'LONGI'), ('E855', 'MALFA'), ('E869', 'MALVAGNA'), ('E876', 'MANDANICI'), ('F066', "MAZZARRÀ SANT'ANDREA"), ('F147', 'MERÌ'), ('F158', 'MESSINA'), ('F206', 'MILAZZO'), ('F210', 'MILITELLO ROSMARINO'), ('F242', 'MIRTO'), ('F251', 'MISTRETTA'), ('F277', 'MOIO ALCANTARA'), ('F359', 'MONFORTE SAN GIORGIO'), ('F368', 'MONGIUFFI MELIA'), ('F395', 'MONTAGNAREALE'), ('F400', 'MONTALBANO ELICONA'), ('F772', 'MOTTA CAMASTRA'), ('F773', "MOTTA D'AFFERMO"), ('F848', 'NASO'), ('F901', 'NIZZA DI SICILIA'), ('F951', 'NOVARA DI SICILIA'), ('G036', 'OLIVERI'), ('G209', 'PACE DEL MELA'), ('G234', 'PAGLIARA'), ('G377', 'PATTI'), ('G522', 'PETTINEO'), ('G699', 'PIRAINO'), ('H151', 'RACCUJA'), ('H228', 'REITANO'), ('H405', 'ROCCAFIORITA'), ('H418', 'ROCCALUMERA'), ('H380', 'ROCCAVALDINA'), ('H455', 'ROCCELLA VALDEMONE'), ('H479', 'RODÌ MILICI'), ('H519', 'ROMETTA'), ('H842', 'SAN FILIPPO DEL MELA'), ('H850', 'SAN FRATELLO'), ('H982', "SAN MARCO D'ALUNZIO"), ('I084', 'SAN PIER NICETO'), ('I086', 'SAN PIERO PATTI'), ('I147', 'SAN SALVATORE DI FITALIA'), ('I328', 'SAN TEODORO'), ('I199', "SANT'AGATA DI MILITELLO"), ('I215', "SANT'ALESSIO SICULO"), ('I283', "SANT'ANGELO DI BROLO"), ('I184', 'SANTA DOMENICA VITTORIA'), ('I220', 'SANTA LUCIA DEL MELA'), ('I254', 'SANTA MARINA SALINA'), ('I311', 'SANTA TERESA DI RIVA'), ('I370', 'SANTO STEFANO DI CAMASTRA'), ('I420', 'SAPONARA'), ('I477', 'SAVOCA'), ('I492', 'SCALETTA ZANCLEA'), ('I747', 'SINAGRA'), ('I881', 'SPADAFORA'), ('L042', 'TAORMINA'), ('M210', 'TERME VIGLIATORE'), ('L271', 'TORREGROTTA'), ('M286', 'TORRENOVA'), ('L308', 'TORTORICI'), ('L431', 'TRIPI'), ('L478', 'TUSA'), ('L482', 'UCRIA'), ('L561', 'VALDINA'), ('L735', 'VENETICO'), ('L950', 'VILLAFRANCA TIRRENA')],
    'MI': [('A010', 'ABBIATEGRASSO'), ('A127', 'ALBAIRATE'), ('A375', 'ARCONATE'), ('A389', 'ARESE'), ('A413', 'ARLUNO'), ('A473', 'ASSAGO'), ('A618', 'BARANZATE'), ('A652', 'BAREGGIO'), ('A697', 'BASIANO'), ('A699', 'BASIGLIO'), ('A751', 'BELLINZAGO LOMBARDO'), ('A804', 'BERNATE TICINO'), ('A820', 'BESATE'), ('A872', 'BINASCO'), ('A920', 'BOFFALORA SOPRA TICINO'), ('A940', 'BOLLATE'), ('B162', 'BRESSO'), ('B235', 'BUBBIANO'), ('B240', 'BUCCINASCO'), ('B286', 'BUSCATE'), ('B292', 'BUSSERO'), ('B301', 'BUSTO GAROLFO'), ('B448', 'CALVIGNASCO'), ('B461', 'CAMBIAGO'), ('B593', 'CANEGRATE'), ('B820', 'CARPIANO'), ('B850', 'CARUGATE'), ('B938', 'CASARILE'), ('B989', 'CASOREZZO'), ('C003', "CASSANO D'ADDA"), ('C014', "CASSINA DE' PECCHI"), ('C033', 'CASSINETTA DI LUGAGNANO'), ('C052', 'CASTANO PRIMO'), ('C523', 'CERNUSCO SUL NAVIGLIO'), ('C536', 'CERRO AL LAMBRO'), ('C537', 'CERRO MAGGIORE'), ('C565', 'CESANO BOSCONE'), ('C569', 'CESATE'), ('C707', 'CINISELLO BALSAMO'), ('C733', 'CISLIANO'), ('C895', 'COLOGNO MONZESE'), ('C908', 'COLTURANO'), ('C986', 'CORBETTA'), ('D013', 'CORMANO'), ('D018', 'CORNAREDO'), ('D045', 'CORSICO'), ('D198', 'CUGGIONO'), ('D229', 'CUSAGO'), ('D231', 'CUSANO MILANINO'), ('D244', 'DAIRAGO'), ('D367', 'DRESANO'), ('D845', 'GAGGIANO'), ('D912', 'GARBAGNATE MILANESE'), ('D995', 'GESSATE'), ('E094', 'GORGONZOLA'), ('E170', 'GREZZAGO'), ('E258', 'GUDO VISCONTI'), ('E313', 'INVERUNO'), ('E317', 'INZAGO'), ('E395', 'LACCHIARELLA'), ('E415', 'LAINATE'), ('E514', 'LEGNANO'), ('E610', 'LISCATE'), ('E639', 'LOCATE DI TRIULZI'), ('E801', 'MAGENTA'), ('E819', 'MAGNAGO'), ('E921', 'MARCALLO CON CASONE'), ('F003', 'MASATE'), ('F084', 'MEDIGLIA'), ('F100', 'MELEGNANO'), ('F119', 'MELZO'), ('F155', 'MESERO'), ('F205', 'MILANO'), ('D033', 'MORIMONDO'), ('F783', 'MOTTA VISCONTI'), ('F874', 'NERVIANO'), ('F939', 'NOSATE'), ('F955', 'NOVATE MILANESE'), ('F968', 'NOVIGLIO'), ('G078', 'OPERA'), ('G181', 'OSSONA'), ('G206', 'OZZERO'), ('G220', 'PADERNO DUGNANO'), ('G316', 'PANTIGLIATE'), ('G324', 'PARABIAGO'), ('G385', 'PAULLO'), ('C013', 'PERO'), ('G488', 'PESCHIERA BORROMEO'), ('G502', 'PESSANO CON BORNAGO'), ('G634', 'PIEVE EMANUELE'), ('G686', 'PIOLTELLO'), ('G772', 'POGLIANO MILANESE'), ('G955', "POZZO D'ADDA"), ('G965', 'POZZUOLO MARTESANA'), ('H026', 'PREGNANA MILANESE'), ('H240', 'RESCALDINA'), ('H264', 'RHO'), ('H371', 'ROBECCHETTO CON INDUNO'), ('H373', 'ROBECCO SUL NAVIGLIO'), ('H470', 'RODANO'), ('H560', 'ROSATE'), ('H623', 'ROZZANO'), ('H803', 'SAN COLOMBANO AL LAMBRO'), ('H827', 'SAN DONATO MILANESE'), ('H884', 'SAN GIORGIO SU LEGNANO'), ('H930', 'SAN GIULIANO MILANESE'), ('I409', 'SAN VITTORE OLONA'), ('I415', 'SAN ZENONE AL LAMBRO'), ('I361', 'SANTO STEFANO TICINO'), ('I566', 'SEDRIANO'), ('I577', 'SEGRATE'), ('I602', 'SENAGO'), ('I690', 'SESTO SAN GIOVANNI'), ('I696', 'SETTALA'), ('I700', 'SETTIMO MILANESE'), ('I786', 'SOLARO'), ('L408', 'TREZZANO ROSA'), ('L409', 'TREZZANO SUL NAVIGLIO'), ('L411', "TREZZO SULL'ADDA"), ('L415', 'TRIBIANO'), ('L454', 'TRUCCAZZANO'), ('L471', 'TURBIGO'), ('L664', 'VANZAGHELLO'), ('L665', 'VANZAGO'), ('L667', "VAPRIO D'ADDA"), ('M424', 'VERMEZZO CON ZELO'), ('L773', 'VERNATE'), ('L883', 'VIGNATE'), ('L928', 'VILLA CORTESE'), ('M053', 'VIMODRONE'), ('M091', 'VITTUONE'), ('M102', 'VIZZOLO PREDABISSI'), ('M176', 'ZIBIDO SAN GIACOMO')],
    'MN': [('A038', 'ACQUANEGRA SUL CHIESE'), ('A470', 'ASOLA'), ('A575', 'BAGNOLO SAN VITO'), ('M396', 'BORGO MANTOVANO'), ('M340', 'BORGO VIRGILIO'), ('M406', 'BORGOCARBONARA'), ('B110', 'BOZZOLO'), ('B612', "CANNETO SULL'OGLIO"), ('B901', 'CASALMORO'), ('B907', 'CASALOLDO'), ('B911', 'CASALROMANO'), ('C076', "CASTEL D'ARIO"), ('C118', 'CASTEL GOFFREDO'), ('C059', 'CASTELBELFORTE'), ('C195', 'CASTELLUCCHIO'), ('C312', 'CASTIGLIONE DELLE STIVIERE'), ('C406', 'CAVRIANA'), ('C502', 'CERESARA'), ('C930', 'COMMESSAGGIO'), ('D227', 'CURTATONE'), ('D351', 'DOSOLO'), ('D949', 'GAZOLDO DEGLI IPPOLITI'), ('D959', 'GAZZUOLO'), ('E078', 'GOITO'), ('E089', 'GONZAGA'), ('E261', 'GUIDIZZOLO'), ('E818', 'MAGNACAVALLO'), ('E897', 'MANTOVA'), ('E922', 'MARCARIA'), ('E949', 'MARIANA MANTOVANA'), ('E962', 'MARMIROLO'), ('F086', 'MEDOLE'), ('F267', 'MOGLIA'), ('F705', 'MONZAMBANO'), ('B012', 'MOTTEGGIANA'), ('G186', 'OSTIGLIA'), ('G417', 'PEGOGNAGA'), ('G717', 'PIUBEGA'), ('G753', 'POGGIO RUSCO'), ('G816', 'POMPONESCO'), ('G862', 'PONTI SUL MINCIO'), ('G917', 'PORTO MANTOVANO'), ('H129', 'QUINGENTOLE'), ('H143', 'QUISTELLO'), ('H218', 'REDONDESCO'), ('H342', 'RIVAROLO MANTOVANO'), ('H481', 'RODIGO'), ('H541', 'RONCOFERRARO'), ('H604', 'ROVERBELLA'), ('H652', 'SABBIONETA'), ('H771', 'SAN BENEDETTO PO'), ('H870', 'SAN GIACOMO DELLE SEGNATE'), ('H883', 'SAN GIORGIO BIGARELLO'), ('H912', 'SAN GIOVANNI DEL DOSSO'), ('I005', "SAN MARTINO DALL'ARGINE"), ('I532', 'SCHIVENOGLIA'), ('I632', 'SERMIDE E FELONICA'), ('I662', 'SERRAVALLE A PO'), ('I801', 'SOLFERINO'), ('L015', 'SUSTINENTE'), ('L020', 'SUZZARA'), ('L826', 'VIADANA'), ('M044', 'VILLIMPENTA'), ('M125', 'VOLTA MANTOVANA')],
    'MO': [('A713', 'BASTIGLIA'), ('A959', 'BOMPORTO'), ('B539', 'CAMPOGALLIANO'), ('B566', 'CAMPOSANTO'), ('B819', 'CARPI'), ('C107', 'CASTELFRANCO EMILIA'), ('C242', 'CASTELNUOVO RANGONE'), ('C287', 'CASTELVETRO DI MODENA'), ('C398', 'CAVEZZO'), ('C951', 'CONCORDIA SULLA SECCHIA'), ('D486', 'FANANO'), ('D599', 'FINALE EMILIA'), ('D607', 'FIORANO MODENESE'), ('D617', 'FIUMALBO'), ('D711', 'FORMIGINE'), ('D783', 'FRASSINORO'), ('E264', 'GUIGLIA'), ('E426', 'LAMA MOCOGNO'), ('E904', 'MARANELLO'), ('E905', 'MARANO SUL PANARO'), ('F087', 'MEDOLLA'), ('F240', 'MIRANDOLA'), ('F257', 'MODENA'), ('F484', 'MONTECRETO'), ('F503', 'MONTEFIORINO'), ('F642', 'MONTESE'), ('F930', 'NONANTOLA'), ('F966', 'NOVI DI MODENA'), ('G250', 'PALAGANO'), ('G393', 'PAVULLO NEL FRIGNANO'), ('G649', 'PIEVEPELAGO'), ('G789', 'POLINAGO'), ('H061', 'PRIGNANO SULLA SECCHIA'), ('H195', 'RAVARINO'), ('H303', 'RIOLUNATO'), ('H794', 'SAN CESARIO SUL PANARO'), ('H835', 'SAN FELICE SUL PANARO'), ('I128', 'SAN POSSIDONIO'), ('I133', 'SAN PROSPERO'), ('I462', 'SASSUOLO'), ('I473', 'SAVIGNANO SUL PANARO'), ('F357', 'SERRAMAZZONI'), ('I689', 'SESTOLA'), ('I802', 'SOLIERA'), ('I903', 'SPILAMBERTO'), ('L885', 'VIGNOLA'), ('M183', 'ZOCCA')],
    'MS': [('A496', 'AULLA'), ('A576', 'BAGNONE'), ('B832', 'CARRARA'), ('B979', 'CASOLA IN LUNIGIANA'), ('C914', 'COMANO'), ('D590', 'FILATTIERA'), ('D629', 'FIVIZZANO'), ('D735', 'FOSDINOVO'), ('E574', 'LICCIANA NARDI'), ('F023', 'MASSA'), ('F679', 'MONTIGNOSO'), ('F802', 'MULAZZO'), ('G746', 'PODENZANA'), ('G870', 'PONTREMOLI'), ('L386', 'TRESANA'), ('L946', 'VILLAFRANCA IN LUNIGIANA'), ('M169', 'ZERI')],
    'MT': [('A017', 'ACCETTURA'), ('A196', 'ALIANO'), ('A801', 'BERNALDA'), ('B391', 'CALCIANO'), ('C723', 'CIRIGLIANO'), ('C888', 'COLOBRARO'), ('D128', 'CRACO'), ('D547', 'FERRANDINA'), ('D909', 'GARAGUSO'), ('E093', 'GORGOGLIONE'), ('E147', 'GRASSANO'), ('E213', 'GROTTOLE'), ('E326', 'IRSINA'), ('F052', 'MATERA'), ('F201', 'MIGLIONICO'), ('F399', 'MONTALBANO JONICO'), ('F637', 'MONTESCAGLIOSO'), ('A942', 'NOVA SIRI'), ('G037', 'OLIVETO LUCANO'), ('G712', 'PISTICCI'), ('G786', 'POLICORO'), ('G806', 'POMARICO'), ('H591', 'ROTONDELLA'), ('H687', 'SALANDRA'), ('H888', 'SAN GIORGIO LUCANO'), ('I029', 'SAN MAURO FORTE'), ('M256', 'SCANZANO JONICO'), ('I954', 'STIGLIANO'), ('L418', 'TRICARICO'), ('L477', 'TURSI'), ('D513', 'VALSINNI')],
    'NA': [('A024', 'ACERRA'), ('A064', 'AFRAGOLA'), ('A068', 'AGEROLA'), ('A268', 'ANACAPRI'), ('A455', 'ARZANO'), ('A535', 'BACOLI'), ('A617', "BARANO D'ISCHIA"), ('B076', 'BOSCOREALE'), ('B077', 'BOSCOTRECASE'), ('B227', 'BRUSCIANO'), ('B371', 'CAIVANO'), ('B452', 'CALVIZZANO'), ('B565', 'CAMPOSANO'), ('B696', 'CAPRI'), ('B740', 'CARBONARA DI NOLA'), ('B759', 'CARDITO'), ('B905', 'CASALNUOVO DI NAPOLI'), ('B922', 'CASAMARCIANO'), ('B924', 'CASAMICCIOLA TERME'), ('B925', 'CASANDRINO'), ('B946', 'CASAVATORE'), ('B980', 'CASOLA DI NAPOLI'), ('B990', 'CASORIA'), ('C129', 'CASTELLAMMARE DI STABIA'), ('C188', 'CASTELLO DI CISTERNA'), ('C495', 'CERCOLA'), ('C675', 'CICCIANO'), ('C697', 'CIMITILE'), ('C929', 'COMIZIANO'), ('D170', 'CRISPANO'), ('H243', 'ERCOLANO'), ('D702', 'FORIO'), ('D789', 'FRATTAMAGGIORE'), ('D790', 'FRATTAMINORE'), ('E054', 'GIUGLIANO IN CAMPANIA'), ('E131', 'GRAGNANO'), ('E224', 'GRUMO NEVANO'), ('E329', 'ISCHIA'), ('E396', 'LACCO AMENO'), ('E557', 'LETTERE'), ('E620', 'LIVERI'), ('E906', 'MARANO DI NAPOLI'), ('E954', 'MARIGLIANELLA'), ('E955', 'MARIGLIANO'), ('M289', 'MASSA DI SOMMA'), ('F030', 'MASSA LUBRENSE'), ('F111', 'MELITO DI NAPOLI'), ('F162', 'META'), ('F488', 'MONTE DI PROCIDA'), ('F799', 'MUGNANO DI NAPOLI'), ('F839', 'NAPOLI'), ('F924', 'NOLA'), ('G190', 'OTTAVIANO'), ('G283', 'PALMA CAMPANIA'), ('G568', 'PIANO DI SORRENTO'), ('G670', 'PIMONTE'), ('G762', 'POGGIOMARINO'), ('G795', 'POLLENA TROCCHIA'), ('G812', "POMIGLIANO D'ARCO"), ('G813', 'POMPEI'), ('G902', 'PORTICI'), ('G964', 'POZZUOLI'), ('H072', 'PROCIDA'), ('H101', 'QUALIANO'), ('H114', 'QUARTO'), ('H433', 'ROCCARAINOLA'), ('H860', 'SAN GENNARO VESUVIANO'), ('H892', 'SAN GIORGIO A CREMANO'), ('H931', 'SAN GIUSEPPE VESUVIANO'), ('I073', 'SAN PAOLO BEL SITO'), ('I151', 'SAN SEBASTIANO AL VESUVIO'), ('I391', 'SAN VITALIANO'), ('I208', "SANT'AGNELLO"), ('I262', "SANT'ANASTASIA"), ('I293', "SANT'ANTIMO"), ('I300', "SANT'ANTONIO ABATE"), ('M273', 'SANTA MARIA LA CARITÀ'), ('I469', 'SAVIANO'), ('I540', 'SCISCIANO'), ('I652', 'SERRARA FONTANA'), ('I820', 'SOMMA VESUVIANA'), ('I862', 'SORRENTO'), ('I978', 'STRIANO'), ('L142', 'TERZIGNO'), ('L245', 'TORRE ANNUNZIATA'), ('L259', 'TORRE DEL GRECO'), ('M280', 'TRECASE'), ('L460', 'TUFINO'), ('L845', 'VICO EQUENSE'), ('G309', 'VILLARICCA'), ('M072', 'VISCIANO'), ('M115', 'VOLLA')],
    'NO': [('A088', 'AGRATE CONTURBIA'), ('A264', 'AMENO'), ('A414', 'ARMENO'), ('A429', 'ARONA'), ('A653', 'BARENGO'), ('A752', 'BELLINZAGO NOVARESE'), ('A844', 'BIANDRATE'), ('A911', 'BOCA'), ('A929', 'BOGOGNO'), ('A953', 'BOLZANO NOVARESE'), ('B043', 'BORGO TICINO'), ('B016', 'BORGOLAVEZZARO'), ('B019', 'BORGOMANERO'), ('B176', 'BRIGA NOVARESE'), ('B183', 'BRIONA'), ('B431', 'CALTIGNAGA'), ('B473', 'CAMERI'), ('B823', 'CARPIGNANO SESIA'), ('B864', 'CASALBELTRAME'), ('B883', 'CASALEGGIO NOVARA'), ('B897', 'CASALINO'), ('B920', 'CASALVOLONE'), ('C149', 'CASTELLAZZO NOVARESE'), ('C166', 'CASTELLETTO SOPRA TICINO'), ('C364', 'CAVAGLIETTO'), ('C365', "CAVAGLIO D'AGOGNA"), ('C378', 'CAVALLIRIO'), ('C483', 'CERANO'), ('C829', 'COLAZZA'), ('C926', 'COMIGNAGO'), ('D162', 'CRESSA'), ('D216', 'CUREGGIO'), ('D309', 'DIVIGNANO'), ('D347', 'DORMELLETTO'), ('D492', 'FARA NOVARESE'), ('D675', "FONTANETO D'AGOGNA"), ('D872', 'GALLIATE'), ('D911', 'GARBAGNA NOVARESE'), ('D921', 'GARGALLO'), ('M416', 'GATTICO-VERUNO'), ('E001', 'GHEMME'), ('E120', 'GOZZANO'), ('E143', 'GRANOZZO CON MONTICELLO'), ('E177', 'GRIGNASCO'), ('E314', 'INVORIO'), ('E436', 'LANDIONA'), ('E544', 'LESA'), ('E803', 'MAGGIORA'), ('E880', 'MANDELLO VITTA'), ('E907', 'MARANO TICINO'), ('F047', 'MASSINO VISCONTI'), ('F093', 'MEINA'), ('F188', 'MEZZOMERICO'), ('F191', 'MIASINO'), ('F317', 'MOMO'), ('F859', 'NEBBIUNO'), ('F886', 'NIBBIOLA'), ('F952', 'NOVARA'), ('G019', 'OLEGGIO'), ('G020', 'OLEGGIO CASTELLO'), ('G134', 'ORTA SAN GIULIO'), ('G349', 'PARUZZARO'), ('G421', 'PELLA'), ('G520', 'PETTENASCO'), ('G703', 'PISANO'), ('G775', 'POGNO'), ('G809', 'POMBIA'), ('H001', 'PRATO SESIA'), ('H213', 'RECETTO'), ('H502', 'ROMAGNANO SESIA'), ('H518', 'ROMENTINO'), ('I025', "SAN MAURIZIO D'OPAGLIO"), ('I052', 'SAN NAZZARO SESIA'), ('I116', 'SAN PIETRO MOSEZZO'), ('I736', 'SILLAVENGO'), ('I767', 'SIZZANO'), ('I857', 'SORISO'), ('I880', 'SOZZAGO'), ('L007', 'SUNO'), ('L104', 'TERDOBBIATE'), ('L223', 'TORNACO'), ('L356', 'TRECATE'), ('L668', "VAPRIO D'AGOGNA"), ('L670', 'VARALLO POMBIA'), ('L808', 'VESPOLATE'), ('L847', 'VICOLUNGO'), ('M062', 'VINZAGLIO')],
    'NU': [('A407', 'ARITZO'), ('A454', 'ARZANA'), ('A492', 'ATZARA'), ('A503', 'AUSTIS'), ('A663', 'BARI SARDO'), ('A722', 'BAUNEI'), ('A776', 'BELVÌ'), ('A880', 'BIRORI'), ('A895', 'BITTI'), ('A948', 'BOLOTANA'), ('B056', 'BORORE'), ('B062', 'BORTIGALI'), ('M285', 'CARDEDU'), ('D287', 'DESULO'), ('D345', 'DORGALI'), ('D376', 'DUALCHI'), ('D395', 'ELINI'), ('D665', 'FONNI'), ('D842', 'GADONI'), ('D859', 'GAIRO'), ('D888', 'GALTELLÌ'), ('D947', 'GAVOI'), ('E049', 'GIRASOLE'), ('E283', 'ILBONO'), ('E323', 'IRGOLI'), ('E387', 'JERZU'), ('E441', 'LANUSEI'), ('E517', 'LEI'), ('E644', 'LOCERI'), ('E646', 'LOCULI'), ('E649', 'LODINE'), ('E647', 'LODÈ'), ('E700', 'LOTZORAI'), ('E736', 'LULA'), ('E788', 'MACOMER'), ('E874', 'MAMOIADA'), ('F073', 'MEANA SARDO'), ('F933', 'NORAGUGUME'), ('F979', 'NUORO'), ('G031', 'OLIENA'), ('G044', 'OLLOLAI'), ('G058', 'OLZAI'), ('G064', 'ONANÌ'), ('G070', 'ONIFAI'), ('G071', 'ONIFERI'), ('G084', 'ORANI'), ('G097', 'ORGOSOLO'), ('G119', 'OROSEI'), ('G120', 'OROTELLI'), ('G146', 'ORTUERI'), ('G147', 'ORUNE'), ('G154', 'OSIDDA'), ('G158', 'OSINI'), ('G191', 'OTTANA'), ('G201', 'OVODDA'), ('G445', 'PERDASDEFOGU'), ('G929', 'POSADA'), ('I448', 'SARULE'), ('I730', 'SILANUS'), ('I748', 'SINDIA'), ('I751', 'SINISCOLA'), ('I851', 'SORGONO'), ('L036', 'TALANA'), ('L140', 'TERTENIA'), ('L153', 'TETI'), ('L160', 'TIANA'), ('L202', 'TONARA'), ('L231', 'TORPÈ'), ('A355', 'TORTOLÌ'), ('L423', 'TRIEI'), ('L489', 'ULASSAI'), ('L506', 'URZULEI'), ('L514', 'USSASSAI'), ('L953', 'VILLAGRANDE STRISAILI')],
    'OR': [('A007', 'ABBASANTA'), ('A097', 'AIDOMAGGIORE'), ('A126', 'ALBAGIARA'), ('A180', 'ALES'), ('A204', 'ALLAI'), ('A357', 'ARBOREA'), ('A380', 'ARDAULI'), ('A477', 'ASSOLO'), ('A480', 'ASUNI'), ('A614', 'BARADILI'), ('A621', 'BARATILI SAN PIETRO'), ('A655', 'BARESSA'), ('A721', 'BAULADU'), ('A856', 'BIDONÌ'), ('A960', 'BONARCADO'), ('B055', 'BORONEDDU'), ('B068', 'BOSA'), ('B281', 'BUSACHI'), ('B314', 'CABRAS'), ('D200', 'CUGLIERI'), ('D214', 'CURCURIS'), ('D640', 'FLUSSIO'), ('D695', 'FORDONGIANUS'), ('E004', 'GHILARZA'), ('E087', 'GONNOSCODINA'), ('D585', 'GONNOSNÒ'), ('E088', 'GONNOSTRAMATZA'), ('E400', 'LACONI'), ('E825', 'MAGOMADAS'), ('E972', 'MARRUBIU'), ('F050', 'MASULLAS'), ('F208', 'MILIS'), ('F261', 'MODOLO'), ('F270', 'MOGORELLA'), ('F272', 'MOGORO'), ('F698', 'MONTRESTA'), ('F727', 'MORGONGIORI'), ('F840', 'NARBOLIA'), ('F867', 'NEONELI'), ('F934', 'NORBELLO'), ('F974', 'NUGHEDU SANTA VITTORIA'), ('F980', 'NURACHI'), ('F985', 'NURECI'), ('G043', 'OLLASTRA'), ('G113', 'ORISTANO'), ('G286', 'PALMAS ARBOREA'), ('G379', 'PAU'), ('G384', 'PAULILATINO'), ('G817', 'POMPU'), ('H301', 'RIOLA SARDO'), ('F271', 'RUINAS'), ('H661', 'SAGAMA'), ('H756', 'SAMUGHEO'), ('A368', "SAN NICOLÒ D'ARCIDANO"), ('I384', 'SAN VERO MILIS'), ('I205', 'SANTA GIUSTA'), ('I374', 'SANTU LUSSURGIU'), ('I503', 'SCANO DI MONTIFERRO'), ('I564', 'SEDILO'), ('I605', 'SENEGHE'), ('I609', 'SENIS'), ('I613', 'SENNARIOLO'), ('I717', 'SIAMAGGIORE'), ('I718', 'SIAMANNA'), ('I721', 'SIAPICCIA'), ('I742', 'SIMALA'), ('I743', 'SIMAXIS'), ('I749', 'SINI'), ('I757', 'SIRIS'), ('I778', 'SODDÌ'), ('I791', 'SOLARUSSA'), ('I861', 'SORRADILE'), ('L006', 'SUNI'), ('L023', 'TADASUNI'), ('L122', 'TERRALBA'), ('L172', 'TINNURA'), ('L321', 'TRAMATZA'), ('L393', 'TRESNURAGHES'), ('L488', 'ULÀ TIRSO'), ('L496', 'URAS'), ('L508', 'USELLUS'), ('I298', "VILLA SANT'ANTONIO"), ('A609', 'VILLA VERDE'), ('L991', 'VILLANOVA TRUSCHEDU'), ('M030', 'VILLAURBANA'), ('M153', 'ZEDDIANI'), ('M168', 'ZERFALIU')],
    'PA': [('A195', 'ALIA'), ('A202', 'ALIMENA'), ('A203', 'ALIMINUSA'), ('A229', 'ALTAVILLA MILICIA'), ('A239', 'ALTOFONTE'), ('A546', 'BAGHERIA'), ('A592', 'BALESTRATE'), ('A719', 'BAUCINA'), ('A764', 'BELMONTE MEZZAGNO'), ('A882', 'BISACQUINO'), ('M268', 'BLUFI'), ('A946', 'BOLOGNETTA'), ('A958', 'BOMPIETRO'), ('A991', 'BORGETTO'), ('B315', 'CACCAMO'), ('B430', 'CALTAVUTURO'), ('B533', 'CAMPOFELICE DI FITALIA'), ('B532', 'CAMPOFELICE DI ROCCELLA'), ('B535', 'CAMPOFIORITO'), ('B556', 'CAMPOREALE'), ('B645', 'CAPACI'), ('B780', 'CARINI'), ('C067', 'CASTELBUONO'), ('C074', 'CASTELDACCIA'), ('C135', 'CASTELLANA SICULA'), ('C344', 'CASTRONOVO DI SICILIA'), ('C420', 'CEFALÀ DIANA'), ('C421', 'CEFALÙ'), ('C496', 'CERDA'), ('C654', 'CHIUSA SCLAFANI'), ('C696', 'CIMINNA'), ('C708', 'CINISI'), ('C871', 'COLLESANO'), ('C968', 'CONTESSA ENTELLINA'), ('D009', 'CORLEONE'), ('D567', 'FICARAZZI'), ('D907', 'GANGI'), ('D977', 'GERACI SICULO'), ('E013', 'GIARDINELLO'), ('E055', 'GIULIANA'), ('E074', 'GODRANO'), ('E149', 'GRATTERI'), ('E337', 'ISNELLO'), ('E350', 'ISOLA DELLE FEMMINE'), ('E459', 'LASCARI'), ('E541', 'LERCARA FRIDDI'), ('E957', 'MARINEO'), ('F184', 'MEZZOJUSO'), ('F246', 'MISILMERI'), ('F377', 'MONREALE'), ('F544', 'MONTELEPRE'), ('F553', 'MONTEMAGGIORE BELSITO'), ('G263', 'PALAZZO ADRIANO'), ('G273', 'PALERMO'), ('G348', 'PARTINICO'), ('G510', 'PETRALIA SOPRANA'), ('G511', 'PETRALIA SOTTANA'), ('G543', 'PIANA DEGLI ALBANESI'), ('G792', 'POLIZZI GENEROSA'), ('G797', 'POLLINA'), ('H070', 'PRIZZI'), ('H422', 'ROCCAMENA'), ('H428', 'ROCCAPALUMBA'), ('H797', 'SAN CIPIRELLO'), ('H933', 'SAN GIUSEPPE JATO'), ('I028', 'SAN MAURO CASTELVERDE'), ('I174', 'SANTA CRISTINA GELA'), ('I188', 'SANTA FLAVIA'), ('I534', 'SCIARA'), ('I538', 'SCILLATO'), ('I541', 'SCLAFANI BAGNI'), ('L112', 'TERMINI IMERESE'), ('L131', 'TERRASINI'), ('L282', 'TORRETTA'), ('L317', 'TRABIA'), ('L332', 'TRAPPETO'), ('L519', 'USTICA'), ('L603', 'VALLEDOLMO'), ('L740', 'VENTIMIGLIA DI SICILIA'), ('L837', 'VICARI'), ('L916', 'VILLABATE'), ('L951', 'VILLAFRATI')],
    'PC': [('A067', 'AGAZZANO'), ('A223', 'ALSENO'), ('M386', 'ALTA VAL TIDONE'), ('A823', 'BESENZONE'), ('A831', 'BETTOLA'), ('A909', 'BOBBIO'), ('B025', 'BORGONOVO VAL TIDONE'), ('B332', 'CADEO'), ('B405', 'CALENDASCO'), ('B643', 'CAORSO'), ('B812', 'CARPANETO PIACENTINO'), ('C261', 'CASTEL SAN GIOVANNI'), ('C145', "CASTELL'ARQUATO"), ('C288', 'CASTELVETRO PIACENTINO'), ('C513', 'CERIGNALE'), ('C838', 'COLI'), ('D054', 'CORTE BRUGNATELLA'), ('D061', 'CORTEMAGGIORE'), ('D502', 'FARINI'), ('D555', 'FERRIERE'), ('D611', "FIORENZUOLA D'ARDA"), ('D958', 'GAZZOLA'), ('E114', 'GOSSOLENGO'), ('E132', 'GRAGNANO TREBBIENSE'), ('E196', 'GROPPARELLO'), ('E726', "LUGAGNANO VAL D'ARDA"), ('F671', "MONTICELLI D'ONGINA"), ('F724', 'MORFASSO'), ('G195', 'OTTONE'), ('G535', 'PIACENZA'), ('G557', 'PIANELLO VAL TIDONE'), ('G696', 'PIOZZANO'), ('G747', 'PODENZANO'), ('G842', "PONTE DELL'OLIO"), ('G852', 'PONTENURE'), ('H350', 'RIVERGARO'), ('H593', 'ROTTOFRENO'), ('H887', 'SAN GIORGIO PIACENTINO'), ('G788', 'SAN PIETRO IN CERRO'), ('I434', 'SARMATO'), ('L348', 'TRAVO'), ('L772', 'VERNASCA'), ('L897', 'VIGOLZONE'), ('L980', "VILLANOVA SULL'ARDA"), ('M165', 'ZERBA'), ('L848', 'ZIANO PIACENTINO')],
    'PD': [('A001', 'ABANO TERME'), ('A075', 'AGNA'), ('A161', 'ALBIGNASEGO'), ('A296', 'ANGUILLARA VENETA'), ('A434', 'ARQUÀ PETRARCA'), ('A438', 'ARRE'), ('A458', 'ARZERGRANDE'), ('A568', 'BAGNOLI DI SOPRA'), ('A613', 'BAONE'), ('A637', 'BARBONA'), ('A714', 'BATTAGLIA TERME'), ('A906', 'BOARA PISANI'), ('M402', 'BORGO VENETO'), ('B031', 'BORGORICCO'), ('B106', 'BOVOLENTA'), ('B213', 'BRUGINE'), ('B345', 'CADONEGHE'), ('B564', 'CAMPO SAN MARTINO'), ('B524', 'CAMPODARSEGO'), ('B531', 'CAMPODORO'), ('B563', 'CAMPOSAMPIERO'), ('B589', 'CANDIANA'), ('B749', 'CARCERI'), ('B795', 'CARMIGNANO DI BRENTA'), ('B848', 'CARTURA'), ('B877', 'CASALE DI SCODOSIA'), ('B912', 'CASALSERUGO'), ('C057', 'CASTELBALDO'), ('C544', 'CERVARESE SANTA CROCE'), ('C713', 'CINTO EUGANEO'), ('C743', 'CITTADELLA'), ('C812', 'CODEVIGO'), ('C964', 'CONSELVE'), ('D040', 'CORREZZOLA'), ('D226', 'CURTAROLO'), ('M300', 'DUE CARRARE'), ('D442', 'ESTE'), ('D679', 'FONTANIVA'), ('D879', 'GALLIERA VENETA'), ('D889', 'GALZIGNANO TERME'), ('D956', 'GAZZO'), ('E145', 'GRANTORTO'), ('E146', 'GRANZE'), ('E515', 'LEGNARO'), ('E592', 'LIMENA'), ('E684', 'LOREGGIA'), ('E709', 'LOZZO ATESTINO'), ('F011', 'MASERÀ DI PADOVA'), ('F013', 'MASI'), ('F033', 'MASSANZAGO'), ('F092', 'MEGLIADINO SAN VITALE'), ('F148', 'MERLARA'), ('F161', 'MESTRINO'), ('F382', 'MONSELICE'), ('F394', 'MONTAGNANA'), ('F529', 'MONTEGROTTO TERME'), ('F962', 'NOVENTA PADOVANA'), ('G167', 'OSPEDALETTO EUGANEO'), ('G224', 'PADOVA'), ('G461', 'PERNUMIA'), ('G534', "PIACENZA D'ADIGE"), ('G587', 'PIAZZOLA SUL BRENTA'), ('G688', 'PIOMBINO DESE'), ('G693', 'PIOVE DI SACCO'), ('G802', 'POLVERARA'), ('G823', 'PONSO'), ('G855', 'PONTE SAN NICOLÒ'), ('G850', 'PONTELONGO'), ('G963', 'POZZONOVO'), ('H622', 'ROVOLON'), ('H625', 'RUBANO'), ('H655', 'SACCOLONGO'), ('H893', 'SAN GIORGIO DELLE PERTICHE'), ('H897', 'SAN GIORGIO IN BOSCO'), ('I008', 'SAN MARTINO DI LUPARI'), ('I107', 'SAN PIETRO IN GU'), ('I120', 'SAN PIETRO VIMINARIO'), ('I275', "SANT'ANGELO DI PIOVE DI SACCO"), ('I319', "SANT'ELENA"), ('I375', "SANT'URBANO"), ('I207', 'SANTA GIUSTINA IN COLLE'), ('I418', 'SAONARA'), ('I595', 'SELVAZZANO DENTRO'), ('I799', 'SOLESINO'), ('I938', 'STANGHELLA'), ('L100', 'TEOLO'), ('L132', 'TERRASSA PADOVANA'), ('L199', 'TOMBOLO'), ('L270', 'TORREGLIA'), ('L349', 'TREBASELEGHE'), ('L414', 'TRIBANO'), ('L497', 'URBANA'), ('L710', 'VEGGIANO'), ('L805', 'VESCOVANA'), ('L878', "VIGHIZZOLO D'ESTE"), ('L892', 'VIGODARZERE'), ('L900', 'VIGONZA'), ('L934', 'VILLA DEL CONTE'), ('L937', 'VILLA ESTENSE'), ('L947', 'VILLAFRANCA PADOVANA'), ('L979', 'VILLANOVA DI CAMPOSAMPIERO'), ('M103', "VO'")],
    'PE': [('A008', 'ABBATEGGIO'), ('A120', 'ALANNO'), ('A945', 'BOLOGNANO'), ('B193', 'BRITTOLI'), ('B294', 'BUSSI SUL TIRINO'), ('B681', 'CAPPELLE SUL TAVO'), ('B722', 'CARAMANICO TERME'), ('B827', 'CARPINETO DELLA NORA'), ('C308', 'CASTIGLIONE A CASAURIA'), ('C354', 'CATIGNANO'), ('C474', 'CEPAGATTI'), ('C750', "CITTÀ SANT'ANGELO"), ('C771', 'CIVITAQUANA'), ('C779', 'CIVITELLA CASANOVA'), ('C853', 'COLLECORVINO'), ('D078', 'CORVARA'), ('D201', 'CUGNOLI'), ('D394', 'ELICE'), ('D501', 'FARINDOLA'), ('E558', 'LETTOMANOPPELLO'), ('E691', 'LORETO APRUTINO'), ('E892', 'MANOPPELLO'), ('F441', 'MONTEBELLO DI BERTONA'), ('F646', 'MONTESILVANO'), ('F765', 'MOSCUFO'), ('F908', 'NOCCIANO'), ('G438', 'PENNE'), ('G482', 'PESCARA'), ('G499', 'PESCOSANSONESCO'), ('G555', 'PIANELLA'), ('G589', 'PICCIANO'), ('G621', 'PIETRANICO'), ('G878', 'POPOLI'), ('H425', 'ROCCAMORICE'), ('H562', 'ROSCIANO'), ('H715', 'SALLE'), ('I376', 'SAN VALENTINO IN ABRUZZO CITERIORE'), ('I332', "SANT'EUFEMIA A MAIELLA"), ('I482', 'SCAFA'), ('I649', 'SERRAMONACESCA'), ('I922', 'SPOLTORE'), ('L186', 'TOCCO DA CASAURIA'), ('L263', "TORRE DE' PASSERI"), ('L475', 'TURRIVALIGNANI'), ('L846', 'VICOLI'), ('L922', 'VILLA CELIERA')],
    'PG': [('A475', 'ASSISI'), ('A710', 'BASTIA UMBRA'), ('A832', 'BETTONA'), ('A835', 'BEVAGNA'), ('B504', 'CAMPELLO SUL CLITUNNO'), ('B609', 'CANNARA'), ('B948', 'CASCIA'), ('C252', 'CASTEL RITALDI'), ('C309', 'CASTIGLIONE DEL LAGO'), ('C527', 'CERRETO DI SPOLETO'), ('C742', 'CITERNA'), ('C744', 'CITTÀ DELLA PIEVE'), ('C745', 'CITTÀ DI CASTELLO'), ('C845', 'COLLAZZONE'), ('C990', 'CORCIANO'), ('D108', 'COSTACCIARO'), ('D279', 'DERUTA'), ('D653', 'FOLIGNO'), ('D745', 'FOSSATO DI VICO'), ('D787', 'FRATTA TODINA'), ('E012', "GIANO DELL'UMBRIA"), ('E229', 'GUALDO CATTANEO'), ('E230', 'GUALDO TADINO'), ('E256', 'GUBBIO'), ('E613', 'LISCIANO NICCONE'), ('E805', 'MAGIONE'), ('E975', 'MARSCIANO'), ('F024', 'MASSA MARTANA'), ('F456', 'MONTE CASTELLO DI VIBIO'), ('F629', 'MONTE SANTA MARIA TIBERINA'), ('F492', 'MONTEFALCO'), ('F540', 'MONTELEONE DI SPOLETO'), ('F685', 'MONTONE'), ('F911', 'NOCERA UMBRA'), ('F935', 'NORCIA'), ('G212', 'PACIANO'), ('G308', 'PANICALE'), ('G359', 'PASSIGNANO SUL TRASIMENO'), ('G478', 'PERUGIA'), ('G601', 'PIEGARO'), ('G618', 'PIETRALUNGA'), ('G758', 'POGGIODOMO'), ('H015', 'PRECI'), ('H935', 'SAN GIUSTINO'), ('I263', "SANT'ANATOLIA DI NARCO"), ('I522', 'SCHEGGIA E PASCELUPO'), ('I523', 'SCHEGGINO'), ('I585', 'SELLANO'), ('I727', 'SIGILLO'), ('I888', 'SPELLO'), ('I921', 'SPOLETO'), ('L188', 'TODI'), ('L216', 'TORGIANO'), ('L397', 'TREVI'), ('L466', 'TUORO SUL TRASIMENO'), ('D786', 'UMBERTIDE'), ('L573', 'VALFABBRICA'), ('L627', 'VALLO DI NERA'), ('L653', 'VALTOPINA')],
    'PI': [('A864', 'BIENTINA'), ('B303', 'BUTI'), ('B390', 'CALCI'), ('B392', 'CALCINAIA'), ('B647', 'CAPANNOLI'), ('B878', 'CASALE MARITTIMO'), ('M327', 'CASCIANA TERME LARI'), ('B950', 'CASCINA'), ('C113', 'CASTELFRANCO DI SOTTO'), ('C174', 'CASTELLINA MARITTIMA'), ('C244', 'CASTELNUOVO DI VAL DI CECINA'), ('C609', 'CHIANNI'), ('M328', 'CRESPINA LORENZANA'), ('D510', 'FAUGLIA'), ('E250', 'GUARDISTALLO'), ('E413', 'LAJATICO'), ('F458', 'MONTECATINI VAL DI CECINA'), ('F640', 'MONTESCUDAIO'), ('F661', 'MONTEVERDI MARITTIMO'), ('F686', "MONTOPOLI IN VAL D'ARNO"), ('G090', 'ORCIANO PISANO'), ('G254', 'PALAIA'), ('G395', 'PECCIOLI'), ('G702', 'PISA'), ('G804', 'POMARANCE'), ('G822', 'PONSACCO'), ('G843', 'PONTEDERA'), ('H319', 'RIPARBELLA'), ('A562', 'SAN GIULIANO TERME'), ('I046', 'SAN MINIATO'), ('I177', "SANTA CROCE SULL'ARNO"), ('I217', 'SANTA LUCE'), ('I232', 'SANTA MARIA A MONTE'), ('L138', 'TERRICCIOLA'), ('L702', 'VECCHIANO'), ('L850', 'VICOPISANO'), ('M126', 'VOLTERRA')],
    'PN': [('A283', 'ANDREIS'), ('A354', 'ARBA'), ('A516', 'AVIANO'), ('A530', 'AZZANO DECIMO'), ('A640', 'BARCIS'), ('B215', 'BRUGNERA'), ('B247', 'BUDOIA'), ('B598', 'CANEVA'), ('B940', 'CASARSA DELLA DELIZIA'), ('C217', 'CASTELNOVO DEL FRIULI'), ('C385', 'CAVASSO NUOVO'), ('C640', 'CHIONS'), ('C699', 'CIMOLAIS'), ('C790', 'CLAUT'), ('C791', 'CLAUZETTO'), ('C991', 'CORDENONS'), ('C993', 'CORDOVADO'), ('D426', 'ERTO E CASSO'), ('D487', 'FANNA'), ('D621', 'FIUME VENETO'), ('D670', 'FONTANAFREDDA'), ('D804', 'FRISANCO'), ('E889', 'MANIAGO'), ('F089', 'MEDUNO'), ('F596', 'MONTEREALE VALCELLINA'), ('F750', 'MORSANO AL TAGLIAMENTO'), ('G353', 'PASIANO DI PORDENONE'), ('G680', 'PINZANO AL TAGLIAMENTO'), ('G780', 'POLCENIGO'), ('G886', 'PORCIA'), ('G888', 'PORDENONE'), ('G994', 'PRATA DI PORDENONE'), ('H010', 'PRAVISDOMINI'), ('H609', 'ROVEREDO IN PIANO'), ('H657', 'SACILE'), ('H891', 'SAN GIORGIO DELLA RICHINVELDA'), ('H999', 'SAN MARTINO AL TAGLIAMENTO'), ('I136', 'SAN QUIRINO'), ('I403', 'SAN VITO AL TAGLIAMENTO'), ('I621', 'SEQUALS'), ('I686', 'SESTO AL REGHENA'), ('I904', 'SPILIMBERGO'), ('L324', 'TRAMONTI DI SOPRA'), ('L325', 'TRAMONTI DI SOTTO'), ('L347', 'TRAVESIO'), ('M265', 'VAJONT'), ('M346', 'VALVASONE ARZENE'), ('M085', "VITO D'ASIO"), ('M096', 'VIVARO'), ('M190', 'ZOPPOLA')],
    'PO': [('B626', 'CANTAGALLO'), ('B794', 'CARMIGNANO'), ('F572', 'MONTEMURLO'), ('G754', 'POGGIO A CAIANO'), ('G999', 'PRATO'), ('L537', 'VAIANO'), ('L775', 'VERNIO')],
    'PR': [('A138', 'ALBARETO'), ('A646', 'BARDI'), ('A731', 'BEDONIA'), ('A788', 'BERCETO'), ('A987', 'BORE'), ('B042', 'BORGO VAL DI TARO'), ('B293', 'BUSSETO'), ('B408', 'CALESTANO'), ('C852', 'COLLECCHIO'), ('C904', 'COLORNO'), ('C934', 'COMPIANO'), ('D026', 'CORNIGLIO'), ('D526', 'FELINO'), ('B034', 'FIDENZA'), ('D673', 'FONTANELLATO'), ('D685', 'FONTEVIVO'), ('D728', 'FORNOVO DI TARO'), ('E438', 'LANGHIRANO'), ('E547', "LESIGNANO DE' BAGNI"), ('F082', 'MEDESANO'), ('F340', 'MONCHIO DELLE CORTI'), ('F473', 'MONTECHIARUGOLO'), ('F882', 'NEVIANO DEGLI ARDUINI'), ('F914', 'NOCETO'), ('G255', 'PALANZANO'), ('G337', 'PARMA'), ('G424', 'PELLEGRINO PARMENSE'), ('M367', 'POLESINE ZIBELLO'), ('H384', 'ROCCABIANCA'), ('H682', 'SALA BAGANZA'), ('H720', 'SALSOMAGGIORE TERME'), ('I153', 'SAN SECONDO PARMENSE'), ('M325', 'SISSA TRECASALI'), ('I803', 'SOLIGNANO'), ('I840', 'SORAGNA'), ('M411', 'SORBOLO MEZZANI'), ('E548', 'TERENZO'), ('L183', 'TIZZANO VAL PARMA'), ('L229', 'TORNOLO'), ('L299', 'TORRILE'), ('L346', 'TRAVERSETOLO'), ('L641', 'VALMOZZOLA'), ('L672', "VARANO DE' MELEGARI"), ('L689', 'VARSI')],
    'PT': [('M376', 'ABETONE CUTIGLIANO'), ('A071', 'AGLIANA'), ('B251', 'BUGGIANO'), ('C631', 'CHIESINA UZZANESE'), ('E432', 'LAMPORECCHIO'), ('E451', 'LARCIANO'), ('E960', 'MARLIANA'), ('F025', 'MASSA E COZZILE'), ('F384', 'MONSUMMANO TERME'), ('F410', 'MONTALE'), ('A561', 'MONTECATINI-TERME'), ('G491', 'PESCIA'), ('G636', 'PIEVE A NIEVOLE'), ('G713', 'PISTOIA'), ('G833', 'PONTE BUGGIANESE'), ('H109', 'QUARRATA'), ('H744', 'SAMBUCA PISTOIESE'), ('M377', 'SAN MARCELLO PITEGLIO'), ('I660', 'SERRAVALLE PISTOIESE'), ('L522', 'UZZANO')],
    'PU': [('A035', 'ACQUALAGNA'), ('A327', 'APECCHIO'), ('A740', "BELFORTE ALL'ISAURO"), ('B026', 'BORGO PACE'), ('B352', 'CAGLI'), ('B636', 'CANTIANO'), ('B816', 'CARPEGNA'), ('B846', 'CARTOCETO'), ('M380', 'COLLI AL METAURO'), ('D488', 'FANO'), ('D541', 'FERMIGNANO'), ('D749', 'FOSSOMBRONE'), ('D791', 'FRATTE ROSA'), ('D807', 'FRONTINO'), ('D808', 'FRONTONE'), ('D836', 'GABICCE MARE'), ('E122', 'GRADARA'), ('E351', 'ISOLA DEL PIANO'), ('E743', 'LUNANO'), ('E785', 'MACERATA FELTRIA'), ('F135', 'MERCATELLO SUL METAURO'), ('F136', 'MERCATINO CONCA'), ('F310', 'MOMBAROCCIO'), ('F347', 'MONDAVIO'), ('F348', 'MONDOLFO'), ('F467', 'MONTE CERIGNONE'), ('F524', 'MONTE GRIMANO TERME'), ('F589', 'MONTE PORZIO'), ('F450', 'MONTECALVO IN FOGLIA'), ('F497', 'MONTEFELCINO'), ('F533', 'MONTELABBATE'), ('G416', 'PEGLIO'), ('G453', 'PERGOLA'), ('G479', 'PESARO'), ('G514', 'PETRIANO'), ('G551', 'PIANDIMELETO'), ('G627', 'PIETRARUBBIA'), ('G682', 'PIOBBICO'), ('H809', 'SAN COSTANZO'), ('H958', 'SAN LORENZO IN CAMPO'), ('I287', "SANT'ANGELO IN VADO"), ('I344', "SANT'IPPOLITO"), ('M413', 'SASSOCORVARO AUDITORE'), ('I654', "SERRA SANT'ABBONDIO"), ('L078', 'TAVOLETO'), ('L081', 'TAVULLIA'), ('M379', 'TERRE ROVERESCHE'), ('L498', 'URBANIA'), ('L500', 'URBINO'), ('M331', 'VALLEFOGLIA')],
    'PV': [('A118', 'ALAGNA'), ('A134', 'ALBAREDO ARNABOLDI'), ('A171', 'ALBONESE'), ('A175', 'ALBUZZANO'), ('A387', 'ARENA PO'), ('A538', 'BADIA PAVESE'), ('A550', 'BAGNARIA'), ('A634', 'BARBIANELLO'), ('A690', 'BASCAPÈ'), ('A712', 'BASTIDA PANCARANA'), ('A718', 'BATTUDA'), ('A741', 'BELGIOIOSO'), ('A792', 'BEREGUARDO'), ('A989', 'BORGARELLO'), ('B028', 'BORGO PRIOLO'), ('B038', 'BORGO SAN SIRO'), ('B030', 'BORGORATTO MORMOROLO'), ('B051', 'BORNASCO'), ('B082', 'BOSNASCO'), ('B117', 'BRALLO DI PREGOLA'), ('B142', 'BREME'), ('B159', 'BRESSANA BOTTARONE'), ('B201', 'BRONI'), ('B447', 'CALVIGNANO'), ('B567', 'CAMPOSPINOSO'), ('B587', 'CANDIA LOMELLINA'), ('B613', 'CANNETO PAVESE'), ('B741', 'CARBONARA AL TICINO'), ('B929', 'CASANOVA LONATI'), ('B945', 'CASATISMA'), ('B954', 'CASEI GEROLA'), ('B988', 'CASORATE PRIMO'), ('C038', 'CASSOLNOVO'), ('C050', 'CASTANA'), ('C053', 'CASTEGGIO'), ('C157', 'CASTELLETTO DI BRANDUZZO'), ('C184', "CASTELLO D'AGOGNA"), ('C213', 'CASTELNOVETTO'), ('C360', 'CAVA MANARA'), ('C414', 'CECIMA'), ('C484', 'CERANOVA'), ('C508', 'CERETTO LOMELLINA'), ('C509', 'CERGNAGO'), ('C541', 'CERTOSA DI PAVIA'), ('C551', 'CERVESINA'), ('C637', 'CHIGNOLO PO'), ('C684', 'CIGOGNOLA'), ('C686', 'CILAVEGNA'), ('C813', 'CODEVILLA'), ('M419', 'COLLI VERDI'), ('C958', 'CONFIENZA'), ('C979', 'COPIANO'), ('C982', 'CORANA'), ('M338', 'CORNALE E BASTIDA'), ('M372', 'CORTEOLONA E GENZONE'), ('D081', 'CORVINO SAN QUIRICO'), ('D109', "COSTA DE' NOBILI"), ('D127', 'COZZO'), ('B824', 'CURA CARPIGNANO'), ('D348', 'DORNO'), ('D552', 'FERRERA ERBOGNONE'), ('D594', 'FILIGHERA'), ('D732', 'FORTUNAGO'), ('D771', 'FRASCAROLO'), ('D873', 'GALLIAVOLA'), ('D892', 'GAMBARANA'), ('D901', 'GAMBOLÒ'), ('D925', 'GARLASCO'), ('D980', 'GERENZAGO'), ('E062', 'GIUSSAGO'), ('E072', 'GODIASCO SALICE TERME'), ('E081', 'GOLFERENZO'), ('E152', 'GRAVELLONA LOMELLINA'), ('E195', 'GROPELLO CAIROLI'), ('E310', 'INVERNO E MONTELEONE'), ('E437', 'LANDRIANO'), ('E439', 'LANGOSCO'), ('E454', 'LARDIRAGO'), ('E600', 'LINAROLO'), ('E608', 'LIRIO'), ('E662', 'LOMELLO'), ('B387', 'LUNGAVILLA'), ('E804', 'MAGHERNO'), ('E934', 'MARCIGNAGO'), ('E999', 'MARZANO'), ('F080', 'MEDE'), ('F122', 'MENCONICO'), ('F170', 'MEZZANA BIGLI'), ('F171', 'MEZZANA RABATTONE'), ('F175', 'MEZZANINO'), ('F238', 'MIRADOLO TERME'), ('F417', 'MONTALTO PAVESE'), ('F440', 'MONTEBELLO DELLA BATTAGLIA'), ('F449', 'MONTECALVO VERSIGGIA'), ('F638', 'MONTESCANO'), ('F644', 'MONTESEGALE'), ('F670', 'MONTICELLI PAVESE'), ('F701', 'MONTÙ BECCARIA'), ('F739', 'MORNICO LOSANA'), ('F754', 'MORTARA'), ('F891', 'NICORVO'), ('G021', 'OLEVANO DI LOMELLINA'), ('G032', 'OLIVA GESSI'), ('G194', 'OTTOBIANO'), ('G275', 'PALESTRO'), ('G304', 'PANCARANA'), ('G342', 'PARONA'), ('G388', 'PAVIA'), ('G612', "PIETRA DE' GIORGI"), ('G635', 'PIEVE ALBIGNOLA'), ('G639', 'PIEVE DEL CAIRO'), ('G650', 'PIEVE PORTO MORONE'), ('G671', 'PINAROLO PO'), ('G720', 'PIZZALE'), ('G851', 'PONTE NIZZA'), ('G895', 'PORTALBERA'), ('H204', 'REA'), ('H216', 'REDAVALLE'), ('H246', 'RETORBIDO'), ('H336', 'RIVANAZZANO TERME'), ('H369', 'ROBBIO'), ('H375', 'ROBECCO PAVESE'), ('H396', "ROCCA DE' GIORGI"), ('H450', 'ROCCA SUSELLA'), ('H491', 'ROGNANO'), ('H505', 'ROMAGNESE'), ('H527', 'RONCARO'), ('H559', 'ROSASCO'), ('H614', 'ROVESCALA'), ('H799', 'SAN CIPRIANO PO'), ('H814', 'SAN DAMIANO AL COLLE'), ('H859', 'SAN GENESIO ED UNITI'), ('H885', 'SAN GIORGIO DI LOMELLINA'), ('I014', 'SAN MARTINO SICCOMARIO'), ('I416', 'SAN ZENONE AL PO'), ('I048', "SANNAZZARO DE' BURGONDI"), ('I213', "SANT'ALESSIO CON VIALONE"), ('I276', "SANT'ANGELO LOMELLINA"), ('I175', 'SANTA CRISTINA E BISSONE'), ('I203', 'SANTA GIULETTA'), ('I230', 'SANTA MARGHERITA DI STAFFORA'), ('I237', 'SANTA MARIA DELLA VERSA'), ('I447', 'SARTIRANA LOMELLINA'), ('I487', 'SCALDASOLE'), ('I599', 'SEMIANA'), ('I739', 'SILVANO PIETRA'), ('E265', 'SIZIANO'), ('I825', 'SOMMO'), ('I894', 'SPESSA'), ('I968', 'STRADELLA'), ('B014', 'SUARDI'), ('L237', 'TORRAZZA COSTE'), ('L250', 'TORRE BERETTI E CASTELLARO'), ('L256', "TORRE D'ARESE"), ('L269', "TORRE D'ISOLA"), ('L262', "TORRE DE' NEGRI"), ('L285', 'TORREVECCHIA PIA'), ('L292', 'TORRICELLA VERZATE'), ('I236', 'TRAVACÒ SICCOMARIO'), ('L440', 'TRIVOLZIO'), ('L449', 'TROMELLO'), ('L453', 'TROVO'), ('L562', 'VAL DI NIZZA'), ('L568', 'VALEGGIO'), ('L593', 'VALLE LOMELLINA'), ('L617', 'VALLE SALIMBENE'), ('L690', 'VARZI'), ('L716', 'VELEZZO LOMELLINA'), ('L720', 'VELLEZZO BELLINI'), ('L784', 'VERRETTO'), ('L788', 'VERRUA PO'), ('L854', 'VIDIGULFO'), ('L872', 'VIGEVANO'), ('L917', 'VILLA BISCOSSI'), ('L983', "VILLANOVA D'ARDENGHI"), ('L994', 'VILLANTERIO'), ('M079', 'VISTARINO'), ('M109', 'VOGHERA'), ('M119', 'VOLPARA'), ('M150', 'ZAVATTARELLO'), ('M152', 'ZECCONE'), ('M161', 'ZEME'), ('M162', 'ZENEVREDO'), ('M166', 'ZERBO'), ('M167', 'ZERBOLÒ'), ('M180', 'ZINASCO')],
    'PZ': [('A013', 'ABRIOLA'), ('A020', 'ACERENZA'), ('A131', 'ALBANO DI LUCANIA'), ('A321', 'ANZI'), ('A415', 'ARMENTO'), ('A482', 'ATELLA'), ('A519', 'AVIGLIANO'), ('A604', 'BALVANO'), ('A612', 'BANZI'), ('A615', 'BARAGIANO'), ('A666', 'BARILE'), ('A743', 'BELLA'), ('B173', 'BRIENZA'), ('B181', 'BRINDISI MONTAGNA'), ('B440', 'CALVELLO'), ('B443', 'CALVERA'), ('B549', 'CAMPOMAGGIORE'), ('B580', 'CANCELLARA'), ('B743', 'CARBONE'), ('C120', 'CASTELGRANDE'), ('C199', 'CASTELLUCCIO INFERIORE'), ('C201', 'CASTELLUCCIO SUPERIORE'), ('C209', 'CASTELMEZZANO'), ('C271', 'CASTELSARACENO'), ('C345', "CASTRONUOVO DI SANT'ANDREA"), ('C539', 'CERSOSIMO'), ('C619', 'CHIAROMONTE'), ('D010', 'CORLETO PERTICARA'), ('D414', 'EPISCOPIA'), ('D497', 'FARDELLA'), ('D593', 'FILIANO'), ('D696', 'FORENZA'), ('D766', 'FRANCAVILLA IN SINNI'), ('D876', 'GALLICCHIO'), ('D971', 'GENZANO DI LUCANIA'), ('E033', 'GINESTRA'), ('E221', 'GRUMENTO NOVA'), ('E246', 'GUARDIA PERTICARA'), ('E409', 'LAGONEGRO'), ('E474', 'LATRONICO'), ('E482', 'LAURENZANA'), ('E483', 'LAURIA'), ('E493', 'LAVELLO'), ('E919', 'MARATEA'), ('E976', 'MARSICO NUOVO'), ('E977', 'MARSICOVETERE'), ('F006', 'MASCHITO'), ('F104', 'MELFI'), ('F249', 'MISSANELLO'), ('F295', 'MOLITERNO'), ('F568', 'MONTEMILONE'), ('F573', 'MONTEMURRO'), ('F817', 'MURO LUCANO'), ('F866', 'NEMOLI'), ('F917', 'NOEPOLI'), ('G081', 'OPPIDO LUCANO'), ('G261', 'PALAZZO SAN GERVASIO'), ('M269', 'PATERNO'), ('G496', 'PESCOPAGANO'), ('G590', 'PICERNO'), ('G616', 'PIETRAGALLA'), ('G623', 'PIETRAPERTOSA'), ('G663', 'PIGNOLA'), ('G942', 'POTENZA'), ('H186', 'RAPOLLA'), ('H187', 'RAPONE'), ('H307', 'RIONERO IN VULTURE'), ('H312', 'RIPACANDIDA'), ('H348', 'RIVELLO'), ('H426', 'ROCCANOVA'), ('H590', 'ROTONDA'), ('H641', 'RUOTI'), ('H646', 'RUVO DEL MONTE'), ('H795', 'SAN CHIRICO NUOVO'), ('H796', 'SAN CHIRICO RAPARO'), ('H808', 'SAN COSTANTINO ALBANESE'), ('H831', 'SAN FELE'), ('H994', "SAN MARTINO D'AGRI"), ('B906', 'SAN PAOLO ALBANESE'), ('I157', 'SAN SEVERINO LUCANO'), ('I288', "SANT'ANGELO LE FRATTE"), ('I305', "SANT'ARCANGELO"), ('I426', 'SARCONI'), ('I457', 'SASSO DI CASTALDA'), ('G614', 'SATRIANO DI LUCANIA'), ('H730', 'SAVOIA DI LUCANIA'), ('I610', 'SENISE'), ('I917', 'SPINOSO'), ('L082', 'TEANA'), ('L126', 'TERRANOVA DI POLLINO'), ('L181', 'TITO'), ('L197', 'TOLVE'), ('L326', 'TRAMUTOLA'), ('L357', 'TRECCHINA'), ('L439', 'TRIVIGNO'), ('L532', 'VAGLIO BASILICATA'), ('L738', 'VENOSA'), ('L859', 'VIETRI DI POTENZA'), ('L873', 'VIGGIANELLO'), ('L874', 'VIGGIANO')],
    'RA': [('A191', 'ALFONSINE'), ('A547', 'BAGNACAVALLO'), ('A551', 'BAGNARA DI ROMAGNA'), ('B188', 'BRISIGHELLA'), ('B982', 'CASOLA VALSENIO'), ('C065', 'CASTEL BOLOGNESE'), ('C553', 'CERVIA'), ('C963', 'CONSELICE'), ('D121', 'COTIGNOLA'), ('D458', 'FAENZA'), ('D829', 'FUSIGNANO'), ('E730', 'LUGO'), ('F029', 'MASSA LOMBARDA'), ('H199', 'RAVENNA'), ('H302', 'RIOLO TERME'), ('H642', 'RUSSI'), ('I196', "SANT'AGATA SUL SANTERNO"), ('I787', 'SOLAROLO')],
    'RC': [('A065', 'AFRICO'), ('A077', 'AGNANA CALABRA'), ('A303', 'ANOIA'), ('A314', 'ANTONIMINA'), ('A385', 'ARDORE'), ('A544', 'BAGALADI'), ('A552', 'BAGNARA CALABRA'), ('A780', 'BENESTARE'), ('A843', 'BIANCO'), ('A897', 'BIVONGI'), ('B097', 'BOVA'), ('B099', 'BOVA MARINA'), ('B098', 'BOVALINO'), ('B118', 'BRANCALEONE'), ('B234', 'BRUZZANO ZEFFIRIO'), ('B379', 'CALANNA'), ('B481', 'CAMINI'), ('B516', 'CAMPO CALABRO'), ('B591', 'CANDIDONI'), ('B617', 'CANOLO'), ('B718', 'CARAFFA DEL BIANCO'), ('B756', 'CARDETO'), ('B766', 'CARERI'), ('B966', 'CASIGNANA'), ('C285', 'CAULONIA'), ('C695', 'CIMINÀ'), ('C710', 'CINQUEFRONDI'), ('C747', 'CITTANOVA'), ('C954', 'CONDOFURI'), ('D089', 'COSOLETO'), ('D268', 'DELIANUOVA'), ('D545', 'FEROLETO DELLA CHIESA'), ('D557', 'FERRUZZANO'), ('D619', 'FIUMARA'), ('D864', 'GALATRO'), ('D975', 'GERACE'), ('E025', 'GIFFONE'), ('E041', 'GIOIA TAURO'), ('E044', 'GIOIOSA IONICA'), ('E212', 'GROTTERIA'), ('E402', 'LAGANADI'), ('E479', 'LAUREANA DI BORRELLO'), ('D976', 'LOCRI'), ('E873', 'MAMMOLA'), ('E956', 'MARINA DI GIOIOSA IONICA'), ('E968', 'MAROPATI'), ('E993', 'MARTONE'), ('F106', 'MELICUCCO'), ('F105', 'MELICUCCÀ'), ('F112', 'MELITO DI PORTO SALVO'), ('F301', 'MOLOCHIO'), ('F324', 'MONASTERACE'), ('D746', 'MONTEBELLO JONICO'), ('F779', 'MOTTA SAN GIOVANNI'), ('G082', 'OPPIDO MAMERTINA'), ('G277', 'PALIZZI'), ('G288', 'PALMI'), ('G394', 'PAZZANO'), ('G729', 'PLACANICA'), ('G735', 'PLATÌ'), ('G791', 'POLISTENA'), ('G905', 'PORTIGLIOLA'), ('H224', 'REGGIO DI CALABRIA'), ('H265', 'RIACE'), ('H359', 'RIZZICONI'), ('H408', 'ROCCAFORTE DEL GRECO'), ('H456', 'ROCCELLA IONICA'), ('H489', 'ROGHUDI'), ('H558', 'ROSARNO'), ('H013', 'SAMO'), ('M277', 'SAN FERDINANDO'), ('H889', 'SAN GIORGIO MORGETO'), ('H903', 'SAN GIOVANNI DI GERACE'), ('H959', 'SAN LORENZO'), ('H970', 'SAN LUCA'), ('I102', 'SAN PIETRO DI CARIDÀ'), ('I132', 'SAN PROCOPIO'), ('I139', 'SAN ROBERTO'), ('I198', "SANT'AGATA DEL BIANCO"), ('I214', "SANT'ALESSIO IN ASPROMONTE"), ('I333', "SANT'EUFEMIA D'ASPROMONTE"), ('I341', "SANT'ILARIO DELLO IONIO"), ('I176', "SANTA CRISTINA D'ASPROMONTE"), ('I371', 'SANTO STEFANO IN ASPROMONTE'), ('I536', 'SCIDO'), ('I537', 'SCILLA'), ('I600', 'SEMINARA'), ('I656', 'SERRATA'), ('I725', 'SIDERNO'), ('I753', 'SINOPOLI'), ('I936', 'STAITI'), ('I955', 'STIGNANO'), ('I956', 'STILO'), ('L063', 'TAURIANOVA'), ('L127', 'TERRANOVA SAPPO MINULIO'), ('L673', 'VARAPODIO'), ('M018', 'VILLA SAN GIOVANNI')],
    'RE': [('A162', 'ALBINEA'), ('A573', 'BAGNOLO IN PIANO'), ('A586', 'BAISO'), ('A850', 'BIBBIANO'), ('A988', 'BORETTO'), ('B156', 'BRESCELLO'), ('B328', 'CADELBOSCO DI SOPRA'), ('B499', 'CAMPAGNOLA EMILIA'), ('B502', 'CAMPEGINE'), ('C669', 'CANOSSA'), ('B825', 'CARPINETI'), ('B893', 'CASALGRANDE'), ('B967', 'CASINA'), ('C141', 'CASTELLARANO'), ('C218', 'CASTELNOVO DI SOTTO'), ('C219', "CASTELNOVO NE' MONTI"), ('C405', 'CAVRIAGO'), ('D037', 'CORREGGIO'), ('D450', 'FABBRICO'), ('D934', 'GATTATICO'), ('E232', 'GUALTIERI'), ('E253', 'GUASTALLA'), ('E772', 'LUZZARA'), ('F463', 'MONTECCHIO EMILIA'), ('F960', 'NOVELLARA'), ('G947', 'POVIGLIO'), ('H122', 'QUATTRO CASTELLA'), ('H223', "REGGIO NELL'EMILIA"), ('H225', 'REGGIOLO'), ('H298', 'RIO SALICETO'), ('H500', 'ROLO'), ('H628', 'RUBIERA'), ('I011', 'SAN MARTINO IN RIO'), ('I123', "SAN POLO D'ENZA"), ('I342', "SANT'ILARIO D'ENZA"), ('I496', 'SCANDIANO'), ('L184', 'TOANO'), ('M364', 'VENTASSO'), ('L815', 'VETTO'), ('L820', 'VEZZANO SUL CROSTOLO'), ('L831', 'VIANO'), ('L969', 'VILLA MINOZZO')],
    'RG': [('A014', 'ACATE'), ('C612', 'CHIARAMONTE GULFI'), ('C927', 'COMISO'), ('E016', 'GIARRATANA'), ('E366', 'ISPICA'), ('F258', 'MODICA'), ('F610', 'MONTEROSSO ALMO'), ('G953', 'POZZALLO'), ('H163', 'RAGUSA'), ('I178', 'SANTA CROCE CAMERINA'), ('I535', 'SCICLI'), ('M088', 'VITTORIA')],
    'RI': [('A019', 'ACCUMOLI'), ('A258', 'AMATRICE'), ('A315', 'ANTRODOCO'), ('A464', 'ASCREA'), ('A765', 'BELMONTE IN SABINA'), ('A981', 'BORBONA'), ('A996', 'BORGO VELINO'), ('B008', 'BORGOROSE'), ('B627', 'CANTALICE'), ('B631', 'CANTALUPO IN SABINA'), ('B934', 'CASAPROTA'), ('A472', 'CASPERIA'), ('C098', 'CASTEL DI TORA'), ('C268', "CASTEL SANT'ANGELO"), ('C224', 'CASTELNUOVO DI FARFA'), ('C746', 'CITTADUCALE'), ('C749', 'CITTAREALE'), ('C841', 'COLLALTO SABINO'), ('C857', 'COLLE DI TORA'), ('C859', 'COLLEGIOVE'), ('C876', 'COLLEVECCHIO'), ('C880', 'COLLI SUL VELINO'), ('C946', 'CONCERVIANO'), ('C959', 'CONFIGNI'), ('C969', 'CONTIGLIANO'), ('D124', 'COTTANELLO'), ('D493', 'FARA IN SABINA'), ('D560', 'FIAMIGNANO'), ('D689', 'FORANO'), ('D785', 'FRASSO SABINO'), ('E160', 'GRECCIO'), ('E393', 'LABRO'), ('E535', 'LEONESSA'), ('E681', 'LONGONE SABINO'), ('E812', 'MAGLIANO SABINA'), ('E927', 'MARCETELLI'), ('F193', 'MICIGLIANO'), ('F319', 'MOMPEO'), ('F430', 'MONTASOLA'), ('F619', 'MONTE SAN GIOVANNI IN SABINA'), ('F446', 'MONTEBUONO'), ('F541', 'MONTELEONE SABINO'), ('F579', 'MONTENERO SABINO'), ('F687', 'MONTOPOLI DI SABINA'), ('F746', 'MORRO REATINO'), ('F876', 'NESPOLO'), ('B595', 'ORVINIO'), ('G232', 'PAGANICO SABINO'), ('G498', 'PESCOROCCHIANO'), ('G513', 'PETRELLA SALTO'), ('G756', 'POGGIO BUSTONE'), ('G757', 'POGGIO CATINO'), ('G763', 'POGGIO MIRTETO'), ('G764', 'POGGIO MOIANO'), ('G765', 'POGGIO NATIVO'), ('G770', 'POGGIO SAN LORENZO'), ('G934', 'POSTA'), ('G951', 'POZZAGLIA SABINA'), ('H282', 'RIETI'), ('H354', 'RIVODUTRI'), ('H446', 'ROCCA SINIBALDA'), ('H427', 'ROCCANTICA'), ('H713', 'SALISANO'), ('I499', 'SCANDRIGLIA'), ('I581', 'SELCI'), ('I959', 'STIMIGLIANO'), ('L046', 'TARANO'), ('L189', 'TOFFIA'), ('L286', 'TORRI IN SABINA'), ('L293', 'TORRICELLA IN SABINA'), ('G507', 'TURANIA'), ('L525', 'VACONE'), ('L676', 'VARCO SABINO')],
    'RM': [('A062', 'AFFILE'), ('A084', 'AGOSTA'), ('A132', 'ALBANO LAZIALE'), ('A210', 'ALLUMIERE'), ('A297', 'ANGUILLARA SABAZIA'), ('A309', 'ANTICOLI CORRADO'), ('A323', 'ANZIO'), ('A370', 'ARCINAZZO ROMANO'), ('M213', 'ARDEA'), ('A401', 'ARICCIA'), ('A446', 'ARSOLI'), ('A449', 'ARTENA'), ('A749', 'BELLEGRA'), ('B114', 'BRACCIANO'), ('B472', 'CAMERATA NUOVA'), ('B496', 'CAMPAGNANO DI ROMA'), ('B576', 'CANALE MONTERANO'), ('B635', 'CANTERANO'), ('B649', 'CAPENA'), ('B687', 'CAPRANICA PRENESTINA'), ('B828', 'CARPINETO ROMANO'), ('B932', 'CASAPE'), ('C116', 'CASTEL GANDOLFO'), ('C203', 'CASTEL MADAMA'), ('C266', 'CASTEL SAN PIETRO ROMANO'), ('C237', 'CASTELNUOVO DI PORTO'), ('C390', 'CAVE'), ('C518', 'CERRETO LAZIALE'), ('C543', 'CERVARA DI ROMA'), ('C552', 'CERVETERI'), ('M272', 'CIAMPINO'), ('C677', 'CICILIANO'), ('C702', 'CINETO ROMANO'), ('C773', 'CIVITAVECCHIA'), ('C784', 'CIVITELLA SAN PAOLO'), ('C858', 'COLLEFERRO'), ('C900', 'COLONNA'), ('D561', 'FIANO ROMANO'), ('D586', 'FILACCIANO'), ('M297', 'FIUMICINO'), ('M309', 'FONTE NUOVA'), ('D707', 'FORMELLO'), ('D773', 'FRASCATI'), ('D875', 'GALLICANO NEL LAZIO'), ('D945', 'GAVIGNANO'), ('D964', 'GENAZZANO'), ('D972', 'GENZANO DI ROMA'), ('D978', 'GERANO'), ('E091', 'GORGA'), ('E204', 'GROTTAFERRATA'), ('E263', 'GUIDONIA MONTECELIO'), ('E382', 'JENNE'), ('E392', 'LABICO'), ('M212', 'LADISPOLI'), ('C767', 'LANUVIO'), ('M207', 'LARIANO'), ('E576', 'LICENZA'), ('E813', 'MAGLIANO ROMANO'), ('B632', 'MANDELA'), ('E900', 'MANZIANA'), ('E908', 'MARANO EQUO'), ('E924', 'MARCELLINA'), ('E958', 'MARINO'), ('F064', 'MAZZANO ROMANO'), ('F127', 'MENTANA'), ('F477', 'MONTE COMPATRI'), ('F590', 'MONTE PORZIO CATONE'), ('F504', 'MONTEFLAVIO'), ('F534', 'MONTELANICO'), ('F545', 'MONTELIBRETTI'), ('F611', 'MONTEROTONDO'), ('F692', 'MONTORIO ROMANO'), ('F730', 'MORICONE'), ('F734', 'MORLUPO'), ('F857', 'NAZZANO'), ('F865', 'NEMI'), ('F871', 'NEROLA'), ('F880', 'NETTUNO'), ('G022', 'OLEVANO ROMANO'), ('G274', 'PALESTRINA'), ('G293', 'PALOMBARA SABINA'), ('G444', 'PERCILE'), ('G704', 'PISONIANO'), ('G784', 'POLI'), ('G811', 'POMEZIA'), ('G874', 'PONZANO ROMANO'), ('H267', 'RIANO'), ('H288', 'RIGNANO FLAMINIO'), ('H300', 'RIOFREDDO'), ('H387', 'ROCCA CANTERANO'), ('H401', 'ROCCA DI CAVE'), ('H404', 'ROCCA DI PAPA'), ('H432', 'ROCCA PRIORA'), ('H441', 'ROCCA SANTO STEFANO'), ('H411', 'ROCCAGIOVINE'), ('H494', 'ROIATE'), ('H501', 'ROMA'), ('H618', 'ROVIANO'), ('H658', 'SACROFANO'), ('H745', 'SAMBUCI'), ('M295', 'SAN CESAREO'), ('H942', 'SAN GREGORIO DA SASSOLA'), ('I125', 'SAN POLO DEI CAVALIERI'), ('I400', 'SAN VITO ROMANO'), ('I284', "SANT'ANGELO ROMANO"), ('I352', "SANT'ORESTE"), ('I255', 'SANTA MARINELLA'), ('I424', 'SARACINESCO'), ('I573', 'SEGNI'), ('I992', 'SUBIACO'), ('L182', 'TIVOLI'), ('L192', 'TOLFA'), ('L302', 'TORRITA TIBERINA'), ('L401', 'TREVIGNANO ROMANO'), ('L611', 'VALLEPIETRA'), ('L625', 'VALLINFREDA'), ('L639', 'VALMONTONE'), ('L719', 'VELLETRI'), ('L851', 'VICOVARO'), ('M095', 'VIVARO ROMANO'), ('M141', 'ZAGAROLO')],
    'RN': [('A747', 'BELLARIA-IGEA MARINA'), ('C080', 'CASTELDELCI'), ('C357', 'CATTOLICA'), ('D004', 'CORIANO'), ('D961', 'GEMMANO'), ('E838', 'MAIOLO'), ('F244', 'MISANO ADRIATICO'), ('F346', 'MONDAINO'), ('F478', 'MONTECOPIOLO'), ('F502', 'MONTEFIORE CONCA'), ('F523', 'MONTEGRIDOLFO'), ('M368', 'MONTESCUDO-MONTE COLOMBO'), ('F715', 'MORCIANO DI ROMAGNA'), ('F137', 'NOVAFELTRIA'), ('G433', 'PENNABILLI'), ('M324', 'POGGIO TORRIANA'), ('H274', 'RICCIONE'), ('H294', 'RIMINI'), ('H724', 'SALUDECIO'), ('H801', 'SAN CLEMENTE'), ('H921', 'SAN GIOVANNI IN MARIGNANO'), ('H949', 'SAN LEO'), ('I201', "SANT'AGATA FELTRIA"), ('I304', 'SANTARCANGELO DI ROMAGNA'), ('I460', 'SASSOFELTRIO'), ('L034', 'TALAMELLO'), ('L797', 'VERUCCHIO')],
    'RO': [('A059', 'ADRIA'), ('A400', 'ARIANO NEL POLESINE'), ('A435', 'ARQUÀ POLESINE'), ('A539', 'BADIA POLESINE'), ('A574', 'BAGNOLO DI PO'), ('A795', 'BERGANTINO'), ('B069', 'BOSARO'), ('B432', 'CALTO'), ('B578', 'CANARO'), ('B582', 'CANDA'), ('C122', 'CASTELGUGLIELMO'), ('C207', 'CASTELMASSA'), ('C215', 'CASTELNOVO BARIANO'), ('C461', 'CENESELLI'), ('C500', 'CEREGNANO'), ('C987', 'CORBOLA'), ('D105', 'COSTA DI ROVIGO'), ('D161', 'CRESPINO'), ('D568', 'FICAROLO'), ('D577', 'FIESSO UMBERTIANO'), ('D776', 'FRASSINELLE POLESINE'), ('D788', 'FRATTA POLESINE'), ('D855', 'GAIBA'), ('D942', 'GAVELLO'), ('E008', 'GIACCIANO CON BARUCHELLA'), ('E240', 'GUARDA VENETA'), ('E522', 'LENDINARA'), ('E689', 'LOREO'), ('E761', 'LUSIA'), ('F095', 'MELARA'), ('F994', 'OCCHIOBELLO'), ('G323', 'PAPOZZE'), ('G525', 'PETTORAZZA GRIMANI'), ('G673', 'PINCARA'), ('G782', 'POLESELLA'), ('G836', 'PONTECCHIO POLESINE'), ('G923', 'PORTO TOLLE'), ('G926', 'PORTO VIRO'), ('H573', 'ROSOLINA'), ('H620', 'ROVIGO'), ('H689', 'SALARA'), ('H768', 'SAN BELLINO'), ('H996', 'SAN MARTINO DI VENEZZE'), ('I953', 'STIENTA'), ('L026', 'TAGLIO DI PO'), ('L359', 'TRECENTA'), ('L939', 'VILLADOSE'), ('L967', 'VILLAMARZANA'), ('L985', 'VILLANOVA DEL GHEBBO'), ('L988', 'VILLANOVA MARCHESANA')],
    'SA': [('A023', 'ACERNO'), ('A091', 'AGROPOLI'), ('A128', 'ALBANELLA'), ('A186', 'ALFANO'), ('A230', 'ALTAVILLA SILENTINA'), ('A251', 'AMALFI'), ('A294', 'ANGRI'), ('A343', 'AQUARA'), ('A460', 'ASCEA'), ('A484', 'ATENA LUCANA'), ('A487', 'ATRANI'), ('A495', 'AULETTA'), ('A674', 'BARONISSI'), ('A717', 'BATTIPAGLIA'), ('M294', 'BELLIZZI'), ('A756', 'BELLOSGUARDO'), ('B115', 'BRACIGLIANO'), ('B242', 'BUCCINO'), ('B266', 'BUONABITACOLO'), ('B351', 'CAGGIANO'), ('B437', 'CALVANICO'), ('B476', 'CAMEROTA'), ('B492', 'CAMPAGNA'), ('B555', 'CAMPORA'), ('B608', 'CANNALONGA'), ('B644', 'CAPACCIO PAESTUM'), ('B895', 'CASAL VELINO'), ('B868', 'CASALBUONO'), ('B888', 'CASALETTO SPARTANO'), ('B959', 'CASELLE IN PITTARI'), ('C259', 'CASTEL SAN GIORGIO'), ('C262', 'CASTEL SAN LORENZO'), ('C069', 'CASTELCIVITA'), ('C125', 'CASTELLABATE'), ('C231', 'CASTELNUOVO CILENTO'), ('C235', 'CASTELNUOVO DI CONZA'), ('C306', 'CASTIGLIONE DEL GENOVESI'), ('C361', "CAVA DE' TIRRENI"), ('C444', 'CELLE DI BULGHERIA'), ('C470', 'CENTOLA'), ('C485', 'CERASO'), ('C584', 'CETARA'), ('C676', 'CICERALE'), ('C879', 'COLLIANO'), ('C940', 'CONCA DEI MARINI'), ('C973', 'CONTRONE'), ('C974', 'CONTURSI TERME'), ('C984', 'CORBARA'), ('D011', 'CORLETO MONFORTE'), ('D195', 'CUCCARO VETERE'), ('D390', 'EBOLI'), ('D527', 'FELITTO'), ('D615', 'FISCIANO'), ('D826', 'FURORE'), ('D832', 'FUTANI'), ('E026', 'GIFFONI SEI CASALI'), ('E027', 'GIFFONI VALLE PIANA'), ('E037', 'GIOI'), ('E060', 'GIUNGANO'), ('E365', 'ISPANI'), ('E480', 'LAUREANA CILENTO'), ('E485', 'LAURINO'), ('E486', 'LAURITO'), ('E498', 'LAVIANO'), ('E767', 'LUSTRA'), ('E814', 'MAGLIANO VETERE'), ('E839', 'MAIORI'), ('F138', 'MERCATO SAN SEVERINO'), ('F223', 'MINORI'), ('F278', 'MOIO DELLA CIVITELLA'), ('F426', 'MONTANO ANTILIA'), ('F618', 'MONTE SAN GIACOMO'), ('F479', 'MONTECORICE'), ('F480', 'MONTECORVINO PUGLIANO'), ('F481', 'MONTECORVINO ROVELLA'), ('F507', 'MONTEFORTE CILENTO'), ('F625', 'MONTESANO SULLA MARCELLANA'), ('F731', 'MORIGERATI'), ('F912', 'NOCERA INFERIORE'), ('F913', 'NOCERA SUPERIORE'), ('F967', 'NOVI VELIA'), ('G011', 'OGLIASTRO CILENTO'), ('G023', 'OLEVANO SUL TUSCIANO'), ('G039', 'OLIVETO CITRA'), ('G063', 'OMIGNANO'), ('G121', 'ORRIA'), ('G192', 'OTTATI'), ('G226', 'PADULA'), ('G230', 'PAGANI'), ('G292', 'PALOMONTE'), ('G426', 'PELLEZZANO'), ('G447', 'PERDIFUMO'), ('G455', 'PERITO'), ('G476', 'PERTOSA'), ('G509', 'PETINA'), ('G538', 'PIAGGINE'), ('G707', 'PISCIOTTA'), ('G793', 'POLLA'), ('G796', 'POLLICA'), ('G834', 'PONTECAGNANO FAIANO'), ('G932', 'POSITANO'), ('G939', 'POSTIGLIONE'), ('G976', 'PRAIANO'), ('H062', 'PRIGNANO CILENTO'), ('H198', 'RAVELLO'), ('H277', 'RICIGLIANO'), ('H394', 'ROCCADASPIDE'), ('H412', 'ROCCAGLORIOSA'), ('H431', 'ROCCAPIEMONTE'), ('H485', 'ROFRANO'), ('H503', 'ROMAGNANO AL MONTE'), ('H564', 'ROSCIGNO'), ('H644', 'RUTINO'), ('H654', 'SACCO'), ('H683', 'SALA CONSILINA'), ('H686', 'SALENTO'), ('H703', 'SALERNO'), ('H732', 'SALVITELLE'), ('H800', 'SAN CIPRIANO PICENTINO'), ('H907', 'SAN GIOVANNI A PIRO'), ('H943', 'SAN GREGORIO MAGNO'), ('H977', 'SAN MANGO PIEMONTE'), ('I019', 'SAN MARZANO SUL SARNO'), ('I031', 'SAN MAURO CILENTO'), ('I032', 'SAN MAURO LA BRUCA'), ('I089', 'SAN PIETRO AL TANAGRO'), ('I143', 'SAN RUFO'), ('I377', 'SAN VALENTINO TORIO'), ('I278', "SANT'ANGELO A FASANELLA"), ('I307', "SANT'ARSENIO"), ('I317', "SANT'EGIDIO DEL MONTE ALBINO"), ('I253', 'SANTA MARINA'), ('I260', 'SANTOMENNA'), ('I410', 'SANZA'), ('I422', 'SAPRI'), ('I438', 'SARNO'), ('I451', 'SASSANO'), ('I483', 'SCAFATI'), ('I486', 'SCALA'), ('I648', 'SERRAMEZZANA'), ('I666', 'SERRE'), ('I677', 'SESSA CILENTO'), ('I720', 'SIANO'), ('M253', 'SICIGNANO DEGLI ALBURNI'), ('G887', 'STELLA CILENTO'), ('I960', 'STIO'), ('D292', 'TEGGIANO'), ('L212', 'TORCHIARA'), ('L233', 'TORRACA'), ('L274', 'TORRE ORSAIA'), ('L306', 'TORTORELLA'), ('L323', 'TRAMONTI'), ('L377', 'TRENTINARA'), ('G540', "VALLE DELL'ANGELO"), ('L628', 'VALLO DELLA LUCANIA'), ('L656', 'VALVA'), ('L835', 'VIBONATI'), ('L860', 'VIETRI SUL MARE')],
    'SI': [('A006', 'ABBADIA SAN SALVATORE'), ('A461', 'ASCIANO'), ('B269', 'BUONCONVENTO'), ('B984', "CASOLE D'ELSA"), ('C172', 'CASTELLINA IN CHIANTI'), ('C227', 'CASTELNUOVO BERARDENGA'), ('C313', "CASTIGLIONE D'ORCIA"), ('C587', 'CETONA'), ('C608', 'CHIANCIANO TERME'), ('C661', 'CHIUSDINO'), ('C662', 'CHIUSI'), ('C847', "COLLE DI VAL D'ELSA"), ('D858', 'GAIOLE IN CHIANTI'), ('M378', 'MONTALCINO'), ('F592', 'MONTEPULCIANO'), ('F598', 'MONTERIGGIONI'), ('F605', "MONTERONI D'ARBIA"), ('F676', 'MONTICIANO'), ('F815', 'MURLO'), ('G547', 'PIANCASTAGNAIO'), ('G602', 'PIENZA'), ('G752', 'POGGIBONSI'), ('H153', 'RADDA IN CHIANTI'), ('H156', 'RADICOFANI'), ('H157', 'RADICONDOLI'), ('H185', 'RAPOLANO TERME'), ('H790', 'SAN CASCIANO DEI BAGNI'), ('H875', 'SAN GIMIGNANO'), ('I135', "SAN QUIRICO D'ORCIA"), ('I445', 'SARTEANO'), ('I726', 'SIENA'), ('A468', 'SINALUNGA'), ('I877', 'SOVICILLE'), ('L303', 'TORRITA DI SIENA'), ('L384', 'TREQUANDA')],
    'SO': [('A135', 'ALBAREDO PER SAN MARCO'), ('A172', 'ALBOSAGGIA'), ('A273', 'ANDALO VALTELLINO'), ('A337', 'APRICA'), ('A382', 'ARDENNO'), ('A777', 'BEMA'), ('A787', 'BERBENNO DI VALTELLINA'), ('A848', 'BIANZONE'), ('B049', 'BORMIO'), ('B255', 'BUGLIO IN MONTE'), ('B366', 'CAIOLO'), ('B530', 'CAMPODOLCINO'), ('B993', 'CASPOGGIO'), ('C186', "CASTELLO DELL'ACQUA"), ('C325', 'CASTIONE ANDEVENNO'), ('C418', 'CEDRASCO'), ('C493', 'CERCINO'), ('C623', 'CHIAVENNA'), ('C628', 'CHIESA IN VALMALENCO'), ('C651', 'CHIURO'), ('C709', 'CINO'), ('C785', 'CIVO'), ('C903', 'COLORINA'), ('D088', 'COSIO VALTELLINO'), ('D258', 'DAZIO'), ('D266', 'DELEBIO'), ('D377', 'DUBINO'), ('D456', 'FAEDO VALTELLINO'), ('D694', 'FORCOLA'), ('D830', 'FUSINE'), ('D990', 'GEROLA ALTA'), ('E090', 'GORDONA'), ('E200', 'GROSIO'), ('E201', 'GROSOTTO'), ('E443', 'LANZADA'), ('E621', 'LIVIGNO'), ('E705', 'LOVERO'), ('E342', 'MADESIMO'), ('E896', 'MANTELLO'), ('F070', 'MAZZO DI VALTELLINA'), ('F115', 'MELLO'), ('F153', 'MESE'), ('F393', 'MONTAGNA IN VALTELLINA'), ('F712', 'MORBEGNO'), ('F956', 'NOVATE MEZZOLA'), ('G410', 'PEDESINA'), ('G572', 'PIANTEDO'), ('G576', 'PIATEDA'), ('G718', 'PIURO'), ('G431', 'POGGIRIDENTI'), ('G829', 'PONTE IN VALTELLINA'), ('G937', 'POSTALESIO'), ('G993', 'PRATA CAMPORTACCIO'), ('H192', 'RASURA'), ('H493', 'ROGOLO'), ('H752', 'SAMOLACO'), ('H868', 'SAN GIACOMO FILIPPO'), ('I636', 'SERNIO'), ('I828', 'SONDALO'), ('I829', 'SONDRIO'), ('I928', 'SPRIANA'), ('L035', 'TALAMONA'), ('L056', 'TARTANO'), ('L084', 'TEGLIO'), ('L175', 'TIRANO'), ('L244', 'TORRE DI SANTA MARIA'), ('L316', "TOVO DI SANT'AGATA"), ('L330', 'TRAONA'), ('L392', 'TRESIVIO'), ('L638', 'VAL MASINO'), ('L557', 'VALDIDENTRO'), ('L563', 'VALDISOTTO'), ('L576', 'VALFURVA'), ('L749', 'VERCEIA'), ('L799', 'VERVIO'), ('L907', 'VILLA DI CHIAVENNA'), ('L908', 'VILLA DI TIRANO')],
    'SP': [('A261', 'AMEGLIA'), ('A373', 'ARCOLA'), ('A836', 'BEVERINO'), ('A932', 'BOLANO'), ('A961', 'BONASSOLA'), ('A992', 'BORGHETTO DI VARA'), ('B214', 'BRUGNATO'), ('B410', 'CALICE AL CORNOVIGLIO'), ('B838', 'CARRO'), ('B839', 'CARRODANO'), ('C240', 'CASTELNUOVO MAGRA'), ('D265', 'DEIVA MARINA'), ('D655', 'FOLLO'), ('D758', 'FRAMURA'), ('E463', 'LA SPEZIA'), ('E542', 'LERICI'), ('E560', 'LEVANTO'), ('G143', 'LUNI'), ('E842', 'MAISSANA'), ('F609', 'MONTEROSSO AL MARE'), ('G664', 'PIGNONE'), ('G925', 'PORTOVENERE'), ('H275', 'RICCÒ DEL GOLFO DI SPEZIA'), ('H304', 'RIOMAGGIORE'), ('H461', 'ROCCHETTA DI VARA'), ('I363', 'SANTO STEFANO DI MAGRA'), ('I449', 'SARZANA'), ('E070', 'SESTA GODANO'), ('L681', 'VARESE LIGURE'), ('L774', 'VERNAZZA'), ('L819', 'VEZZANO LIGURE'), ('M177', 'ZIGNAGO')],
    'SR': [('A494', 'AUGUSTA'), ('A522', 'AVOLA'), ('B237', 'BUCCHERI'), ('B287', 'BUSCEMI'), ('B603', 'CANICATTINI BAGNI'), ('B787', 'CARLENTINI'), ('C006', 'CASSARO'), ('D540', 'FERLA'), ('D636', 'FLORIDIA'), ('D768', 'FRANCOFONTE'), ('E532', 'LENTINI'), ('F107', 'MELILLI'), ('F943', 'NOTO'), ('G211', 'PACHINO'), ('G267', 'PALAZZOLO ACREIDE'), ('M257', 'PORTOPALO DI CAPO PASSERO'), ('M279', 'PRIOLO GARGALLO'), ('H574', 'ROSOLINI'), ('I754', 'SIRACUSA'), ('I785', 'SOLARINO'), ('I864', 'SORTINO')],
    'SS': [('A069', 'AGGIUS'), ('H848', 'AGLIENTU'), ('A192', 'ALGHERO'), ('A115', 'ALÀ DEI SARDI'), ('A287', 'ANELA'), ('A379', 'ARDARA'), ('A453', 'ARZACHENA'), ('M214', 'BADESI'), ('A606', 'BANARI'), ('A781', 'BENETUTTI'), ('A789', 'BERCHIDDA'), ('A827', 'BESSUDE'), ('A976', 'BONNANARO'), ('A977', 'BONO'), ('A978', 'BONORVA'), ('B063', 'BORTIGIADAS'), ('B064', 'BORUTTA'), ('B094', 'BOTTIDDA'), ('B246', 'BUDDUSÒ'), ('B248', 'BUDONI'), ('B264', 'BULTEI'), ('B265', 'BULZI'), ('B276', 'BURGOS'), ('B378', 'CALANGIANUS'), ('B772', 'CARGEGHE'), ('C272', 'CASTELSARDO'), ('C600', 'CHEREMULE'), ('C613', 'CHIARAMONTI'), ('C818', 'CODRONGIANOS'), ('D100', 'COSSOINE'), ('M292', 'ERULA'), ('D441', 'ESPORLATU'), ('D637', 'FLORINAS'), ('E019', 'GIAVE'), ('M274', 'GOLFO ARANCI'), ('E285', 'ILLORAI'), ('E376', 'ITTIREDDU'), ('E377', 'ITTIRI'), ('E425', 'LA MADDALENA'), ('E401', 'LAERRU'), ('M275', 'LOIRI PORTO SAN PAOLO'), ('E747', 'LUOGOSANTO'), ('E752', 'LURAS'), ('E902', 'MARA'), ('E992', 'MARTIS'), ('F542', 'MONTELEONE ROCCA DORIA'), ('F667', 'MONTI'), ('F721', 'MORES'), ('F818', 'MUROS'), ('F975', 'NUGHEDU SAN NICOLÒ'), ('F976', 'NULE'), ('F977', 'NULVI'), ('G015', 'OLBIA'), ('G046', 'OLMEDO'), ('G153', 'OSCHIRI'), ('G156', 'OSILO'), ('G178', 'OSSI'), ('G203', 'OZIERI'), ('G225', 'PADRIA'), ('M301', 'PADRU'), ('G258', 'PALAU'), ('G376', 'PATTADA'), ('G450', 'PERFUGAS'), ('G740', 'PLOAGHE'), ('G924', 'PORTO TORRES'), ('G962', 'POZZOMAGGIORE'), ('H095', 'PUTIFIGARI'), ('H507', 'ROMANA'), ('I329', 'SAN TEODORO'), ('M276', "SANT'ANTONIO DI GALLURA"), ('M284', 'SANTA MARIA COGHINAS'), ('I312', 'SANTA TERESA GALLURA'), ('I452', 'SASSARI'), ('I565', 'SEDINI'), ('I598', 'SEMESTENE'), ('I614', 'SENNORI'), ('I732', 'SILIGO'), ('I863', 'SORSO'), ('M290', 'STINTINO'), ('L088', 'TELTI'), ('L093', 'TEMPIO PAUSANIA'), ('M282', 'TERGU'), ('L158', 'THIESI'), ('L180', 'TISSI'), ('L235', 'TORRALBA'), ('L428', "TRINITÀ D'AGULTU E VIGNOLA"), ('L464', 'TULA'), ('L503', 'URI'), ('L509', 'USINI'), ('L604', 'VALLEDORIA'), ('M259', 'VIDDALBA'), ('L989', 'VILLANOVA MONTELEONE')],
    'SU': [('A359', 'ARBUS'), ('A419', 'ARMUNGIA'), ('A597', 'BALLAO'), ('A677', 'BARRALI'), ('A681', 'BARUMINI'), ('B250', 'BUGGERRU'), ('B274', 'BURCEI'), ('B383', 'CALASETTA'), ('B745', 'CARBONIA'), ('B789', 'CARLOFORTE'), ('M288', 'CASTIADAS'), ('C882', 'COLLINAS'), ('D260', 'DECIMOPUTZU'), ('D323', 'DOLIANOVA'), ('D333', 'DOMUS DE MARIA'), ('D334', 'DOMUSNOVAS'), ('D344', 'DONORI'), ('D430', 'ESCALAPLANO'), ('D431', 'ESCOLCA'), ('D443', 'ESTERZILI'), ('D639', 'FLUMINIMAGGIORE'), ('D827', 'FURTEI'), ('D968', 'GENONI'), ('D970', 'GENURI'), ('D982', 'GERGEI'), ('D994', 'GESICO'), ('D997', 'GESTURI'), ('E022', 'GIBA'), ('E084', 'GONI'), ('E086', 'GONNESA'), ('E085', 'GONNOSFANADIGA'), ('E234', 'GUAMAGGIORE'), ('E252', 'GUASILA'), ('E270', 'GUSPINI'), ('E281', 'IGLESIAS'), ('E336', 'ISILI'), ('E464', 'LAS PLASSAS'), ('E742', 'LUNAMATRONA'), ('E877', 'MANDAS'), ('M270', 'MASAINAS'), ('F333', 'MONASTIR'), ('F808', 'MURAVERA'), ('F822', 'MUSEI'), ('F841', 'NARCAO'), ('F981', 'NURAGUS'), ('F982', 'NURALLAO'), ('F983', 'NURAMINIS'), ('F986', 'NURRI'), ('F991', 'NUXIS'), ('G122', 'ORROLI'), ('G133', 'ORTACESUS'), ('G207', 'PABILLONIS'), ('G382', 'PAULI ARBAREI'), ('G446', 'PERDAXIUS'), ('G669', 'PIMENTEL'), ('M291', 'PISCINAS'), ('G922', 'PORTOSCUSO'), ('H659', 'SADALI'), ('H738', 'SAMASSI'), ('H739', 'SAMATZAI'), ('H766', 'SAN BASILIO'), ('H856', 'SAN GAVINO MONREALE'), ('G287', 'SAN GIOVANNI SUERGIU'), ('G383', 'SAN NICOLÒ GERREI'), ('I166', 'SAN SPERATE'), ('I402', 'SAN VITO'), ('H974', 'SANLURI'), ('I271', "SANT'ANDREA FRIUS"), ('M209', "SANT'ANNA ARRESI"), ('I294', "SANT'ANTIOCO"), ('I182', 'SANTADI'), ('I428', 'SARDARA'), ('I570', 'SEGARIU'), ('I582', 'SELEGAS'), ('I615', 'SENORBÌ'), ('I624', 'SERDIANA'), ('I647', 'SERRAMANNA'), ('I667', 'SERRENTI'), ('I668', 'SERRI'), ('I705', 'SETZU'), ('I706', 'SEUI'), ('I707', 'SEULO'), ('I724', 'SIDDI'), ('I734', 'SILIQUA'), ('I735', 'SILIUS'), ('I765', 'SIURGUS DONIGALA'), ('I797', 'SOLEMINIS'), ('I995', 'SUELLI'), ('L154', 'TEULADA'), ('L337', 'TRATALIAS'), ('L463', 'TUILI'), ('L473', 'TURRI'), ('L512', 'USSANA'), ('L513', 'USSARAMANNA'), ('L613', 'VALLERMOSA'), ('L924', 'VILLACIDRO'), ('L966', 'VILLAMAR'), ('L968', 'VILLAMASSARGIA'), ('L992', 'VILLANOVA TULO'), ('L986', 'VILLANOVAFORRU'), ('L987', 'VILLANOVAFRANCA'), ('M278', 'VILLAPERUCCIO'), ('L998', 'VILLAPUTZU'), ('M016', 'VILLASALTO'), ('B738', 'VILLASIMIUS'), ('M025', 'VILLASOR'), ('M026', 'VILLASPECIOSA')],
    'SV': [('A122', 'ALASSIO'), ('A145', 'ALBENGA'), ('A166', 'ALBISOLA SUPERIORE'), ('A165', 'ALBISSOLA MARINA'), ('A226', 'ALTARE'), ('A278', 'ANDORA'), ('A422', 'ARNASCO'), ('A593', 'BALESTRINO'), ('A647', 'BARDINETO'), ('A796', 'BERGEGGI'), ('A931', 'BOISSANO'), ('A999', 'BORGHETTO SANTO SPIRITO'), ('B005', 'BORGIO VEREZZI'), ('B048', 'BORMIDA'), ('B369', 'CAIRO MONTENOTTE'), ('B409', 'CALICE LIGURE'), ('B416', 'CALIZZANO'), ('B748', 'CARCARE'), ('B927', 'CASANOVA LERRONE'), ('C063', 'CASTELBIANCO'), ('C276', 'CASTELVECCHIO DI ROCCA BARBENA'), ('C443', 'CELLE LIGURE'), ('C463', 'CENGIO'), ('C510', 'CERIALE'), ('C729', 'CISANO SUL NEVA'), ('D095', 'COSSERIA'), ('D264', 'DEGO'), ('D424', 'ERLI'), ('D600', 'FINALE LIGURE'), ('D927', 'GARLENDA'), ('E064', 'GIUSTENICE'), ('E066', 'GIUSVALLA'), ('E414', 'LAIGUEGLIA'), ('E632', 'LOANO'), ('E816', 'MAGLIOLO'), ('E860', 'MALLARE'), ('F046', 'MASSIMINO'), ('F213', 'MILLESIMO'), ('F226', 'MIOGLIA'), ('F813', 'MURIALDO'), ('F847', 'NASINO'), ('F926', 'NOLI'), ('G076', 'ONZO'), ('D522', 'ORCO FEGLINO'), ('G144', 'ORTOVERO'), ('G155', 'OSIGLIA'), ('G281', 'PALLARE'), ('G542', 'PIANA CRIXIA'), ('G605', 'PIETRA LIGURE'), ('G741', 'PLODIO'), ('G866', 'PONTINVREA'), ('H126', 'QUILIANO'), ('H266', 'RIALTO'), ('H452', 'ROCCAVIGNALE'), ('I453', 'SASSELLO'), ('I480', 'SAVONA'), ('I926', 'SPOTORNO'), ('I946', 'STELLA'), ('I947', 'STELLANELLO'), ('L152', 'TESTICO'), ('L190', 'TOIRANO'), ('L315', 'TOVO SAN GIACOMO'), ('L499', 'URBE'), ('L528', 'VADO LIGURE'), ('L675', 'VARAZZE'), ('L730', 'VENDONE'), ('L823', 'VEZZI PORTIO'), ('L975', "VILLANOVA D'ALBENGA"), ('M197', 'ZUCCARELLO')],
    'TA': [('A514', 'AVETRANA'), ('B808', 'CAROSINO'), ('C136', 'CASTELLANETA'), ('D171', 'CRISPIANO'), ('D463', 'FAGGIANO'), ('D754', 'FRAGAGNANO'), ('E036', 'GINOSA'), ('E205', 'GROTTAGLIE'), ('E469', 'LATERZA'), ('E537', 'LEPORANO'), ('E630', 'LIZZANO'), ('E882', 'MANDURIA'), ('E986', 'MARTINA FRANCA'), ('E995', 'MARUGGIO'), ('F027', 'MASSAFRA'), ('F531', 'MONTEIASI'), ('F563', 'MONTEMESOLA'), ('F587', 'MONTEPARANO'), ('F784', 'MOTTOLA'), ('G251', 'PALAGIANELLO'), ('G252', 'PALAGIANO'), ('H090', 'PULSANO'), ('H409', 'ROCCAFORZATA'), ('H882', 'SAN GIORGIO IONICO'), ('I018', 'SAN MARZANO DI SAN GIUSEPPE'), ('I467', 'SAVA'), ('M298', 'STATTE'), ('L049', 'TARANTO'), ('L294', 'TORRICELLA')],
    'TE': [('A125', 'ALBA ADRIATICA'), ('A270', 'ANCARANO'), ('A445', 'ARSITA'), ('A488', 'ATRI'), ('A692', 'BASCIANO'), ('A746', 'BELLANTE'), ('A885', 'BISENTI'), ('B515', 'CAMPLI'), ('B640', 'CANZANO'), ('C040', 'CASTEL CASTAGNA'), ('C128', 'CASTELLALTO'), ('C169', 'CASTELLI'), ('C316', 'CASTIGLIONE MESSER RAIMONDO'), ('C322', 'CASTILENTI'), ('C449', 'CELLINO ATTANASIO'), ('C517', 'CERMIGNANO'), ('C781', 'CIVITELLA DEL TRONTO'), ('C311', 'COLLEDARA'), ('C901', 'COLONNELLA'), ('C972', 'CONTROGUERRA'), ('D043', 'CORROPOLI'), ('D076', 'CORTINO'), ('D179', 'CROGNALETO'), ('D489', 'FANO ADRIANO'), ('E058', 'GIULIANOVA'), ('E343', "ISOLA DEL GRAN SASSO D'ITALIA"), ('E989', 'MARTINSICURO'), ('F500', 'MONTEFINO'), ('F690', 'MONTORIO AL VOMANO'), ('F747', "MORRO D'ORO"), ('F764', "MOSCIANO SANT'ANGELO"), ('F870', 'NERETO'), ('F942', 'NOTARESCO'), ('G437', "PENNA SANT'ANDREA"), ('G608', 'PIETRACAMELA'), ('F831', 'PINETO'), ('H440', 'ROCCA SANTA MARIA'), ('F585', 'ROSETO DEGLI ABRUZZI'), ('I318', "SANT'EGIDIO ALLA VIBRATA"), ('I348', "SANT'OMERO"), ('I741', 'SILVI'), ('L103', 'TERAMO'), ('L207', 'TORANO NUOVO'), ('L295', 'TORRICELLA SICURA'), ('L307', 'TORTORETO'), ('L314', 'TOSSICIA'), ('L597', 'VALLE CASTELLANA')],
    'TN': [('A116', 'ALA'), ('A158', 'ALBIANO'), ('A178', 'ALDENO'), ('M349', 'ALTAVALLE'), ('M350', 'ALTOPIANO DELLA VIGOLANA'), ('M351', 'AMBLAR-DON'), ('A274', 'ANDALO'), ('A372', 'ARCO'), ('A520', 'AVIO'), ('A694', 'BASELGA DI PINÈ'), ('A730', 'BEDOLLO'), ('A821', 'BESENELLO'), ('A863', 'BIENO'), ('A902', 'BLEGGIO SUPERIORE'), ('A916', 'BOCENAGO'), ('A968', 'BONDONE'), ('M352', 'BORGO CHIESE'), ('M429', "BORGO D'ANAUNIA"), ('M353', 'BORGO LARES'), ('B006', 'BORGO VALSUGANA'), ('B153', 'BRENTONICO'), ('B158', 'BRESIMO'), ('B335', 'CADERZONE TERME'), ('B389', 'CALCERANICA AL LAGO'), ('B400', 'CALDES'), ('B404', 'CALDONAZZO'), ('B419', 'CALLIANO'), ('B514', 'CAMPITELLO DI FASSA'), ('B525', 'CAMPODENNO'), ('B577', 'CANAL SAN BOVO'), ('B579', 'CANAZEI'), ('B697', 'CAPRIANA'), ('B783', 'CARISOLO'), ('B856', 'CARZANO'), ('C183', 'CASTEL CONDINO'), ('M354', 'CASTEL IVANO'), ('C194', 'CASTELLO TESINO'), ('C189', 'CASTELLO-MOLINA DI FIEMME'), ('C216', 'CASTELNUOVO'), ('C372', 'CAVALESE'), ('C380', 'CAVARENO'), ('C392', 'CAVEDAGO'), ('C393', 'CAVEDINE'), ('C400', 'CAVIZZANA'), ('M355', 'CEMBRA LISIGNAGO'), ('C700', 'CIMONE'), ('C712', 'CINTE TESINO'), ('C727', 'CIS'), ('C756', 'CIVEZZANO'), ('C794', 'CLES'), ('M314', 'COMANO TERME'), ('C931', 'COMMEZZADURA'), ('M356', 'CONTÀ'), ('D188', 'CROVIANA'), ('D246', 'DAMBEL'), ('D273', 'DENNO'), ('M366', 'DIMARO FOLGARIDA'), ('D365', 'DRENA'), ('D371', 'DRO'), ('D468', 'FAI DELLA PAGANELLA'), ('D565', 'FIAVÈ'), ('D573', 'FIEROZZO'), ('D651', 'FOLGARIA'), ('D714', 'FORNACE'), ('D775', 'FRASSILONGO'), ('D928', 'GARNIGA TERME'), ('E048', 'GIOVO'), ('E065', 'GIUSTINO'), ('E178', 'GRIGNO'), ('E288', 'IMER'), ('E334', 'ISERA'), ('E492', 'LAVARONE'), ('E500', 'LAVIS'), ('M313', 'LEDRO'), ('E565', 'LEVICO TERME'), ('E624', 'LIVO'), ('E664', 'LONA-LASES'), ('E757', 'LUSERNA'), ('M357', 'MADRUZZO'), ('E850', 'MALÉ'), ('F045', 'MASSIMENO'), ('F068', 'MAZZIN'), ('F168', 'MEZZANA'), ('F176', 'MEZZANO'), ('F183', 'MEZZOCORONA'), ('F187', 'MEZZOLOMBARDO'), ('F263', 'MOENA'), ('F307', 'MOLVENO'), ('F728', 'MORI'), ('F835', 'NAGO-TORBOLE'), ('F920', 'NOGAREDO'), ('F929', 'NOMI'), ('F947', 'NOVALEDO'), ('M430', 'NOVELLA'), ('G168', 'OSPEDALETTO'), ('G173', 'OSSANA'), ('G296', 'PALÙ DEL FERSINA'), ('G305', 'PANCHIÀ'), ('G419', 'PEIO'), ('G428', 'PELLIZZANO'), ('G429', 'PELUGO'), ('G452', 'PERGINE VALSUGANA'), ('M365', 'PIEVE DI BONO-PREZZO'), ('G656', 'PIEVE TESINO'), ('G681', 'PINZOLO'), ('G808', 'POMAROLO'), ('M358', 'PORTE DI RENDENA'), ('M344', 'PREDAIA'), ('H018', 'PREDAZZO'), ('M359', 'PRIMIERO SAN MARTINO DI CASTROZZA'), ('H146', 'RABBI'), ('H330', 'RIVA DEL GARDA'), ('H517', 'ROMENO'), ('H528', 'RONCEGNO TERME'), ('H532', 'RONCHI VALSUGANA'), ('M303', 'RONZO-CHIENIS'), ('H552', 'RONZONE'), ('H612', 'ROVERETO'), ('H607', 'ROVERÈ DELLA LUNA'), ('H634', 'RUFFRÈ-MENDOLA'), ('H639', 'RUMO'), ('H666', 'SAGRON MIS'), ('H754', 'SAMONE'), ('M390', 'SAN GIOVANNI DI FASSA-SÈN JAN'), ('M345', 'SAN LORENZO DORSINO'), ('I042', "SAN MICHELE ALL'ADIGE"), ('I354', "SANT'ORSOLA TERME"), ('I411', 'SANZENO'), ('I439', 'SARNONICO'), ('I554', 'SCURELLE'), ('I576', 'SEGONZANO'), ('M360', 'SELLA GIUDICARIE'), ('I714', 'SFRUZ'), ('I839', 'SORAGA DI FASSA'), ('I871', 'SOVER'), ('I899', 'SPIAZZO'), ('I924', 'SPORMAGGIORE'), ('I925', 'SPORMINORE'), ('I949', 'STENICO'), ('I964', 'STORO'), ('I975', 'STREMBO'), ('L089', 'TELVE'), ('L090', 'TELVE DI SOPRA'), ('L096', 'TENNA'), ('L097', 'TENNO'), ('L121', 'TERRAGNOLO'), ('M407', "TERRE D'ADIGE"), ('L145', 'TERZOLAS'), ('L147', 'TESERO'), ('L174', 'TIONE DI TRENTO'), ('L200', 'TON'), ('L211', 'TORCEGNO'), ('L322', 'TRAMBILENO'), ('M361', 'TRE VILLE'), ('L378', 'TRENTO'), ('M343', 'VALDAONE'), ('L575', 'VALFLORIANA'), ('L588', 'VALLARSA'), ('M362', 'VALLELAGHI'), ('L769', 'VERMIGLIO'), ('L886', 'VIGNOLA-FALESINA'), ('L957', 'VILLA LAGARINA'), ('M363', "VILLE D'ANAUNIA"), ('M431', 'VILLE DI FIEMME'), ('M113', 'VOLANO'), ('M173', 'ZIANO DI FIEMME')],
    'TO': [('A074', 'AGLIÈ'), ('A109', 'AIRASCA'), ('A117', 'ALA DI STURA'), ('A157', "ALBIANO D'IVREA"), ('A218', 'ALMESE'), ('A221', 'ALPETTE'), ('A222', 'ALPIGNANO'), ('A275', 'ANDEZENO'), ('A282', 'ANDRATE'), ('A295', 'ANGROGNA'), ('A405', 'ARIGNANO'), ('A518', 'AVIGLIANA'), ('A525', 'AZEGLIO'), ('A584', 'BAIRO'), ('A587', 'BALANGERO'), ('A590', 'BALDISSERO CANAVESE'), ('A591', 'BALDISSERO TORINESE'), ('A599', 'BALME'), ('A607', 'BANCHETTE'), ('A625', 'BARBANIA'), ('A651', 'BARDONECCHIA'), ('A673', 'BARONE CANAVESE'), ('A734', 'BEINASCO'), ('A853', 'BIBIANA'), ('A910', 'BOBBIO PELLICE'), ('A941', 'BOLLENGO'), ('A990', 'BORGARO TORINESE'), ('B003', 'BORGIALLO'), ('B015', "BORGOFRANCO D'IVREA"), ('B021', 'BORGOMASINO'), ('B024', 'BORGONE SUSA'), ('B075', 'BOSCONERO'), ('B121', 'BRANDIZZO'), ('B171', 'BRICHERASIO'), ('B205', 'BROSSO'), ('B209', 'BROZOLO'), ('B216', 'BRUINO'), ('B225', 'BRUSASCO'), ('B232', 'BRUZOLO'), ('B278', 'BURIASCO'), ('B279', 'BUROLO'), ('B284', 'BUSANO'), ('B297', 'BUSSOLENO'), ('B305', 'BUTTIGLIERA ALTA'), ('B350', 'CAFASSE'), ('B435', 'CALUSO'), ('B462', 'CAMBIANO'), ('B512', 'CAMPIGLIONE FENILE'), ('B588', 'CANDIA CANAVESE'), ('B592', 'CANDIOLO'), ('B605', 'CANISCHIO'), ('B628', 'CANTALUPA'), ('B637', 'CANTOIRA'), ('B705', 'CAPRIE'), ('B733', 'CARAVINO'), ('B762', 'CAREMA'), ('B777', 'CARIGNANO'), ('B791', 'CARMAGNOLA'), ('B867', 'CASALBORGONE'), ('B953', "CASCINETTE D'IVREA"), ('B955', 'CASELETTE'), ('B960', 'CASELLE TORINESE'), ('C045', 'CASTAGNETO PO'), ('C048', 'CASTAGNOLE PIEMONTE'), ('C133', 'CASTELLAMONTE'), ('C241', 'CASTELNUOVO NIGRA'), ('C307', 'CASTIGLIONE TORINESE'), ('C369', 'CAVAGNOLO'), ('C404', 'CAVOUR'), ('C487', 'CERCENASCO'), ('C497', 'CERES'), ('C505', 'CERESOLE REALE'), ('C564', 'CESANA TORINESE'), ('C604', 'CHIALAMBERTO'), ('C610', 'CHIANOCCO'), ('C624', 'CHIAVERANO'), ('C627', 'CHIERI'), ('C629', 'CHIESANUOVA'), ('C639', 'CHIOMONTE'), ('C655', 'CHIUSA DI SAN MICHELE'), ('C665', 'CHIVASSO'), ('C679', 'CICONIO'), ('C711', 'CINTANO'), ('C715', 'CINZANO'), ('C722', 'CIRIÈ'), ('C793', 'CLAVIERE'), ('C801', 'COASSOLO TORINESE'), ('C803', 'COAZZE'), ('C860', 'COLLEGNO'), ('C867', 'COLLERETTO CASTELNUOVO'), ('C868', 'COLLERETTO GIACOSA'), ('C955', 'CONDOVE'), ('D008', 'CORIO'), ('D092', 'COSSANO CANAVESE'), ('D197', 'CUCEGLIO'), ('D202', 'CUMIANA'), ('D208', 'CUORGNÈ'), ('D373', 'DRUENTO'), ('D433', 'EXILLES'), ('D520', 'FAVRIA'), ('D524', 'FELETTO'), ('D532', 'FENESTRELLE'), ('D562', 'FIANO'), ('D608', 'FIORANO CANAVESE'), ('D646', 'FOGLIZZO'), ('D725', 'FORNO CANAVESE'), ('D781', 'FRASSINETTO'), ('D805', 'FRONT'), ('D812', 'FROSSASCO'), ('D931', 'GARZIGLIANA'), ('D933', 'GASSINO TORINESE'), ('D983', 'GERMAGNANO'), ('E009', 'GIAGLIONE'), ('E020', 'GIAVENO'), ('E067', 'GIVOLETTO'), ('E154', 'GRAVERE'), ('E199', 'GROSCAVALLO'), ('E203', 'GROSSO'), ('E216', 'GRUGLIASCO'), ('E301', 'INGRIA'), ('E311', 'INVERSO PINASCA'), ('E345', 'ISOLABELLA'), ('E368', 'ISSIGLIO'), ('E379', 'IVREA'), ('E394', 'LA CASSA'), ('E423', 'LA LOGGIA'), ('E445', 'LANZO TORINESE'), ('E484', 'LAURIANO'), ('E518', 'LEINI'), ('E520', 'LEMIE'), ('E551', 'LESSOLO'), ('E566', 'LEVONE'), ('E635', 'LOCANA'), ('E660', 'LOMBARDORE'), ('E661', 'LOMBRIASCO'), ('E683', 'LORANZÈ'), ('E758', 'LUSERNA SAN GIOVANNI'), ('E759', 'LUSERNETTA'), ('E763', 'LUSIGLIÈ'), ('E782', 'MACELLO'), ('E817', 'MAGLIONE'), ('M316', 'MAPPANO'), ('E941', 'MARENTINO'), ('F041', 'MASSELLO'), ('F053', 'MATHI'), ('F058', 'MATTIE'), ('F067', 'MAZZÈ'), ('F074', 'MEANA DI SUSA'), ('F140', 'MERCENASCO'), ('F182', 'MEZZENILE'), ('F315', 'MOMBELLO DI TORINO'), ('F318', 'MOMPANTERO'), ('F327', 'MONASTERO DI LANZO'), ('F335', 'MONCALIERI'), ('D553', 'MONCENISIO'), ('F407', 'MONTALDO TORINESE'), ('F411', 'MONTALENGHE'), ('F420', 'MONTALTO DORA'), ('F422', 'MONTANARO'), ('F651', 'MONTEU DA PO'), ('F733', 'MORIONDO TORINESE'), ('F889', 'NICHELINO'), ('F906', 'NOASCA'), ('F925', 'NOLE'), ('F927', 'NOMAGLIO'), ('F931', 'NONE'), ('F948', 'NOVALESA'), ('G010', 'OGLIANICO'), ('G087', 'ORBASSANO'), ('G109', 'ORIO CANAVESE'), ('G151', 'OSASCO'), ('G152', 'OSASIO'), ('G196', 'OULX'), ('G202', 'OZEGNA'), ('G262', 'PALAZZO CANAVESE'), ('G303', 'PANCALIERI'), ('G330', 'PARELLA'), ('G387', 'PAVAROLO'), ('G392', 'PAVONE CANAVESE'), ('G398', 'PECETTO TORINESE'), ('G463', 'PEROSA ARGENTINA'), ('G462', 'PEROSA CANAVESE'), ('G465', 'PERRERO'), ('G477', 'PERTUSIO'), ('G505', 'PESSINETTO'), ('G559', 'PIANEZZA'), ('G672', 'PINASCA'), ('G674', 'PINEROLO'), ('G678', 'PINO TORINESE'), ('G684', 'PIOBESI TORINESE'), ('G691', 'PIOSSASCO'), ('G705', 'PISCINA'), ('G719', 'PIVERONE'), ('G777', 'POIRINO'), ('G805', 'POMARETTO'), ('G826', 'PONT CANAVESE'), ('G900', 'PORTE'), ('G973', 'PRAGELATO'), ('G978', 'PRALI'), ('G979', 'PRALORMO'), ('G982', 'PRAMOLLO'), ('G986', 'PRAROSTINO'), ('G988', 'PRASCORSANO'), ('G997', 'PRATIGLIONE'), ('H100', 'QUAGLIUZZO'), ('H120', 'QUASSOLO'), ('H127', 'QUINCINETTO'), ('H207', 'REANO'), ('H270', 'RIBORDONE'), ('H337', 'RIVA PRESSO CHIERI'), ('H333', 'RIVALBA'), ('H335', 'RIVALTA DI TORINO'), ('H338', 'RIVARA'), ('H340', 'RIVAROLO CANAVESE'), ('H344', 'RIVAROSSA'), ('H355', 'RIVOLI'), ('H367', 'ROBASSOMERO'), ('H386', 'ROCCA CANAVESE'), ('H498', 'ROLETTO'), ('H511', 'ROMANO CANAVESE'), ('H539', 'RONCO CANAVESE'), ('H547', 'RONDISSONE'), ('H554', 'RORÀ'), ('H583', 'ROSTA'), ('H555', 'ROURE'), ('H627', 'RUBIANA'), ('H631', 'RUEGLIO'), ('H691', 'SALASSA'), ('H684', 'SALBERTRAND'), ('H702', 'SALERANO CANAVESE'), ('H734', 'SALZA DI PINEROLO'), ('H753', 'SAMONE'), ('H775', 'SAN BENIGNO CANAVESE'), ('H789', 'SAN CARLO CANAVESE'), ('H804', 'SAN COLOMBANO BELMONTE'), ('H820', 'SAN DIDERO'), ('H847', 'SAN FRANCESCO AL CAMPO'), ('H862', 'SAN GERMANO CHISONE'), ('H873', 'SAN GILLIO'), ('H890', 'SAN GIORGIO CANAVESE'), ('H900', 'SAN GIORIO DI SUSA'), ('H936', 'SAN GIUSTO CANAVESE'), ('H997', 'SAN MARTINO CANAVESE'), ('I024', 'SAN MAURIZIO CANAVESE'), ('I030', 'SAN MAURO TORINESE'), ('I090', 'SAN PIETRO VAL LEMINA'), ('I126', 'SAN PONSO'), ('I137', 'SAN RAFFAELE CIMENA'), ('I152', 'SAN SEBASTIANO DA PO'), ('I154', 'SAN SECONDO DI PINEROLO'), ('H855', 'SANGANO'), ('I258', "SANT'AMBROGIO DI TORINO"), ('I296', "SANT'ANTONINO DI SUSA"), ('I327', 'SANTENA'), ('I466', "SAUZE D'OULX"), ('I465', 'SAUZE DI CESANA'), ('I490', 'SCALENGHE'), ('I511', 'SCARMAGNO'), ('I539', 'SCIOLZE'), ('I692', 'SESTRIERE'), ('I701', 'SETTIMO ROTTARO'), ('I703', 'SETTIMO TORINESE'), ('I702', 'SETTIMO VITTONE'), ('I886', 'SPARONE'), ('I969', 'STRAMBINELLO'), ('I970', 'STRAMBINO'), ('L013', 'SUSA'), ('L066', 'TAVAGNASCO'), ('L219', 'TORINO'), ('L238', 'TORRAZZA PIEMONTE'), ('L247', 'TORRE CANAVESE'), ('L277', 'TORRE PELLICE'), ('L327', 'TRANA'), ('L345', 'TRAVERSELLA'), ('L340', 'TRAVES'), ('L445', 'TROFARELLO'), ('L515', 'USSEAUX'), ('L516', 'USSEGLIO'), ('L538', 'VAIE'), ('L555', 'VAL DELLA TORRE'), ('M405', 'VAL DI CHY'), ('M415', 'VALCHIUSA'), ('L578', 'VALGIOIE'), ('L629', 'VALLO TORINESE'), ('L644', 'VALPERGA'), ('B510', 'VALPRATO SOANA'), ('L685', 'VARISELLA'), ('L698', 'VAUDA CANAVESE'), ('L727', 'VENARIA REALE'), ('L726', 'VENAUS'), ('L779', 'VEROLENGO'), ('L787', 'VERRUA SAVOIA'), ('L811', 'VESTIGNÈ'), ('L830', 'VIALFRÈ'), ('L857', 'VIDRACCO'), ('L898', 'VIGONE'), ('L948', 'VILLAFRANCA PIEMONTE'), ('L982', 'VILLANOVA CANAVESE'), ('L999', 'VILLAR DORA'), ('M007', 'VILLAR FOCCHIARDO'), ('M013', 'VILLAR PELLICE'), ('M014', 'VILLAR PEROSA'), ('M002', 'VILLARBASSE'), ('M004', 'VILLAREGGIA'), ('M027', 'VILLASTELLONE'), ('M060', 'VINOVO'), ('M069', 'VIRLE PIEMONTE'), ('M071', 'VISCHE'), ('M080', 'VISTRORIO'), ('M094', 'VIÙ'), ('M122', 'VOLPIANO'), ('M133', 'VOLVERA')],
    'TP': [('A176', 'ALCAMO'), ('B288', 'BUSETO PALIZZOLO'), ('B385', 'CALATAFIMI-SEGESTA'), ('B521', 'CAMPOBELLO DI MAZARA'), ('C130', 'CASTELLAMMARE DEL GOLFO'), ('C286', 'CASTELVETRANO'), ('D234', 'CUSTONACI'), ('D423', 'ERICE'), ('D518', 'FAVIGNANA'), ('E023', 'GIBELLINA'), ('E974', 'MARSALA'), ('F061', 'MAZARA DEL VALLO'), ('M432', 'MISILISCEMI'), ('G208', 'PACECO'), ('G315', 'PANTELLERIA'), ('G347', 'PARTANNA'), ('M281', 'PETROSINO'), ('G767', 'POGGIOREALE'), ('H688', 'SALAPARUTA'), ('H700', 'SALEMI'), ('I407', 'SAN VITO LO CAPO'), ('I291', 'SANTA NINFA'), ('L331', 'TRAPANI'), ('G319', 'VALDERICE'), ('M081', 'VITA')],
    'TR': [('A045', 'ACQUASPARTA'), ('A207', 'ALLERONA'), ('A242', 'ALVIANO'), ('A262', 'AMELIA'), ('A439', 'ARRONE'), ('A490', 'ATTIGLIANO'), ('M258', 'AVIGLIANO UMBRO'), ('A691', 'BASCHI'), ('B446', "CALVI DELL'UMBRIA"), ('C117', 'CASTEL GIORGIO'), ('C289', 'CASTEL VISCARDO'), ('D454', 'FABRO'), ('D538', 'FERENTILLO'), ('D570', 'FICULLE'), ('E045', 'GIOVE'), ('E241', 'GUARDEA'), ('E729', 'LUGNANO IN TEVERINA'), ('F457', 'MONTECASTRILLI'), ('F462', 'MONTECCHIO'), ('F510', 'MONTEFRANCO'), ('F513', 'MONTEGABBIONE'), ('F543', "MONTELEONE D'ORVIETO"), ('F844', 'NARNI'), ('G148', 'ORVIETO'), ('G189', 'OTRICOLI'), ('G344', 'PARRANO'), ('G432', 'PENNA IN TEVERINA'), ('G790', 'POLINO'), ('G881', 'PORANO'), ('H857', 'SAN GEMINI'), ('I381', 'SAN VENANZO'), ('I981', 'STRONCONE'), ('L117', 'TERNI')],
    'TS': [('D383', 'DUINO AURISINA-DEVIN NABREŽINA'), ('F378', 'MONRUPINO-REPENTABOR'), ('F795', 'MUGGIA'), ('D324', 'SAN DORLIGO DELLA VALLE-DOLINA'), ('I715', 'SGONICO-ZGONIK'), ('L424', 'TRIESTE')],
    'TV': [('A237', 'ALTIVOLE'), ('A360', 'ARCADE'), ('A471', 'ASOLO'), ('B061', 'BORSO DEL GRAPPA'), ('B128', 'BREDA DI PIAVE'), ('B349', 'CAERANO DI SAN MARCO'), ('B678', 'CAPPELLA MAGGIORE'), ('B744', 'CARBONERA'), ('B879', 'CASALE SUL SILE'), ('B965', 'CASIER'), ('C073', 'CASTELCUCCO'), ('C111', 'CASTELFRANCO VENETO'), ('C190', 'CASTELLO DI GODEGO'), ('C384', 'CAVASO DEL TOMBA'), ('C580', 'CESSALTO'), ('C614', 'CHIARANO'), ('C689', 'CIMADOLMO'), ('C735', 'CISON DI VALMARINO'), ('C815', 'CODOGNÈ'), ('C848', 'COLLE UMBERTO'), ('C957', 'CONEGLIANO'), ('C992', 'CORDIGNANO'), ('D030', 'CORNUDA'), ('C670', 'CROCETTA DEL MONTELLO'), ('D505', 'FARRA DI SOLIGO'), ('D654', 'FOLLINA'), ('D674', 'FONTANELLE'), ('D680', 'FONTE'), ('D794', 'FREGONA'), ('D854', 'GAIARINE'), ('E021', 'GIAVERA DEL MONTELLO'), ('E071', "GODEGA DI SANT'URBANO"), ('E092', 'GORGO AL MONTICANO'), ('E373', 'ISTRANA'), ('E692', 'LORIA'), ('E893', 'MANSUÈ'), ('E940', 'MARENO DI PIAVE'), ('F009', 'MASER'), ('F012', 'MASERADA SUL PIAVE'), ('F088', 'MEDUNA DI LIVENZA'), ('F190', 'MIANE'), ('F269', 'MOGLIANO VENETO'), ('F332', 'MONASTIER DI TREVISO'), ('F360', 'MONFUMO'), ('F443', 'MONTEBELLUNA'), ('F725', 'MORGANO'), ('F729', 'MORIAGO DELLA BATTAGLIA'), ('F770', 'MOTTA DI LIVENZA'), ('F872', 'NERVESA DELLA BATTAGLIA'), ('F999', 'ODERZO'), ('G115', 'ORMELLE'), ('G123', 'ORSAGO'), ('G229', 'PAESE'), ('G408', 'PEDEROBBA'), ('M422', 'PIEVE DEL GRAPPA'), ('G645', 'PIEVE DI SOLIGO'), ('G846', 'PONTE DI PIAVE'), ('G875', 'PONZANO VENETO'), ('G909', 'PORTOBUFFOLÈ'), ('G933', 'POSSAGNO'), ('G944', 'POVEGLIANO'), ('H022', 'PREGANZIOL'), ('H131', 'QUINTO DI TREVISO'), ('H220', 'REFRONTOLO'), ('H238', 'RESANA'), ('H253', 'REVINE LAGO'), ('H280', 'RIESE PIO X'), ('H523', 'RONCADE'), ('H706', 'SALGAREDA'), ('H781', 'SAN BIAGIO DI CALLALTA'), ('H843', 'SAN FIOR'), ('I103', 'SAN PIETRO DI FELETTO'), ('I124', 'SAN POLO DI PIAVE'), ('I382', 'SAN VENDEMIANO'), ('I417', 'SAN ZENONE DEGLI EZZELINI'), ('I221', 'SANTA LUCIA DI PIAVE'), ('I435', 'SARMEDE'), ('I578', 'SEGUSINO'), ('I635', 'SERNAGLIA DELLA BATTAGLIA'), ('F116', 'SILEA'), ('I927', 'SPRESIANO'), ('L014', 'SUSEGANA'), ('L058', 'TARZO'), ('L402', 'TREVIGNANO'), ('L407', 'TREVISO'), ('L565', 'VALDOBBIADENE'), ('L700', 'VAZZOLA'), ('L706', 'VEDELAGO'), ('L856', 'VIDOR'), ('M048', 'VILLORBA'), ('M089', 'VITTORIO VENETO'), ('M118', 'VOLPAGO DEL MONTELLO'), ('M163', 'ZENSON DI PIAVE'), ('M171', 'ZERO BRANCO')],
    'UD': [('A103', 'AIELLO DEL FRIULI'), ('A254', 'AMARO'), ('A267', 'AMPEZZO'), ('A346', 'AQUILEIA'), ('A447', 'ARTA TERME'), ('A448', 'ARTEGNA'), ('A491', 'ATTIMIS'), ('A553', 'BAGNARIA ARSA'), ('A700', 'BASILIANO'), ('A810', 'BERTIOLO'), ('A855', 'BICINICCO'), ('A983', 'BORDANO'), ('B259', 'BUJA'), ('B309', 'BUTTRIO'), ('B483', 'CAMINO AL TAGLIAMENTO'), ('B536', 'CAMPOFORMIDO'), ('M311', 'CAMPOLONGO TAPOGLIANO'), ('B788', 'CARLINO'), ('B994', 'CASSACCO'), ('C327', 'CASTIONS DI STRADA'), ('C389', 'CAVAZZO CARNICO'), ('C494', 'CERCIVENTO'), ('C556', 'CERVIGNANO DEL FRIULI'), ('C641', 'CHIOPRIS-VISCONE'), ('C656', 'CHIUSAFORTE'), ('C758', 'CIVIDALE DEL FRIULI'), ('C817', 'CODROIPO'), ('C885', 'COLLOREDO DI MONTE ALBANO'), ('C918', 'COMEGLIANS'), ('D027', 'CORNO DI ROSAZZO'), ('D085', 'COSEANO'), ('D300', 'DIGNANO'), ('D316', 'DOGNA'), ('D366', 'DRENCHIA'), ('D408', 'ENEMONZO'), ('D455', 'FAEDIS'), ('D461', 'FAGAGNA'), ('M400', 'FIUMICELLO VILLA VICENTINA'), ('D630', 'FLAIBANO'), ('D700', 'FORGARIA NEL FRIULI'), ('D718', 'FORNI AVOLTRI'), ('D719', 'FORNI DI SOPRA'), ('D720', 'FORNI DI SOTTO'), ('D962', 'GEMONA DEL FRIULI'), ('E083', 'GONARS'), ('E179', 'GRIMACCO'), ('E473', 'LATISANA'), ('E476', 'LAUCO'), ('E553', 'LESTIZZA'), ('E584', 'LIGNANO SABBIADORO'), ('E760', 'LUSEVERA'), ('E820', 'MAGNANO IN RIVIERA'), ('E833', 'MAJANO'), ('E847', 'MALBORGHETTO VALBRUNA'), ('E899', 'MANZANO'), ('E910', 'MARANO LAGUNARE'), ('E982', 'MARTIGNACCO'), ('F144', 'MERETO DI TOMBA'), ('F266', 'MOGGIO UDINESE'), ('F275', 'MOIMACCO'), ('F574', 'MONTENARS'), ('F756', 'MORTEGLIANO'), ('F760', 'MORUZZO'), ('F832', 'MUZZANA DEL TURGNANO'), ('F898', 'NIMIS'), ('G163', 'OSOPPO'), ('G198', 'OVARO'), ('G238', 'PAGNACCO'), ('G268', 'PALAZZOLO DELLO STELLA'), ('G284', 'PALMANOVA'), ('G300', 'PALUZZA'), ('G352', 'PASIAN DI PRATO'), ('G381', 'PAULARO'), ('G389', 'PAVIA DI UDINE'), ('G743', 'POCENIA'), ('G831', 'PONTEBBA'), ('G891', 'PORPETTO'), ('G949', 'POVOLETTO'), ('G966', 'POZZUOLO DEL FRIULI'), ('G969', 'PRADAMANO'), ('H002', 'PRATO CARNICO'), ('H014', 'PRECENICCO'), ('H029', 'PREMARIACCO'), ('H038', 'PREONE'), ('H040', 'PREPOTTO'), ('H089', 'PULFERO'), ('H161', 'RAGOGNA'), ('H196', 'RAVASCLETTO'), ('H200', 'RAVEO'), ('H206', 'REANA DEL ROJALE'), ('H229', 'REMANZACCO'), ('H242', 'RESIA'), ('H244', 'RESIUTTA'), ('H289', 'RIGOLATO'), ('H347', "RIVE D'ARCANO"), ('M317', 'RIVIGNANO TEOR'), ('H533', 'RONCHIS'), ('H629', 'RUDA'), ('H816', 'SAN DANIELE DEL FRIULI'), ('H895', 'SAN GIORGIO DI NOGARO'), ('H906', 'SAN GIOVANNI AL NATISONE'), ('H951', 'SAN LEONARDO'), ('I092', 'SAN PIETRO AL NATISONE'), ('I404', 'SAN VITO AL TORRE'), ('I405', 'SAN VITO DI FAGAGNA'), ('I248', 'SANTA MARIA LA LONGA'), ('I421', 'SAPPADA'), ('I464', 'SAURIS'), ('I478', 'SAVOGNA'), ('I562', 'SEDEGLIANO'), ('I777', 'SOCCHIEVE'), ('I974', 'STREGNA'), ('L018', 'SUTRIO'), ('G736', 'TAIPANA'), ('L039', 'TALMASSONS'), ('L050', 'TARCENTO'), ('L057', 'TARVISIO'), ('L065', 'TAVAGNACCO'), ('L144', "TERZO D'AQUILEIA"), ('L195', 'TOLMEZZO'), ('L246', 'TORREANO'), ('L309', 'TORVISCOSA'), ('L335', 'TRASAGHIS'), ('L382', 'TREPPO GRANDE'), ('M399', 'TREPPO LIGOSULLO'), ('L421', 'TRICESIMO'), ('L438', 'TRIVIGNANO UDINESE'), ('L483', 'UDINE'), ('L686', 'VARMO'), ('L743', 'VENZONE'), ('L801', 'VERZEGNIS'), ('L909', 'VILLA SANTINA'), ('M073', 'VISCO'), ('M200', 'ZUGLIO')],
    'VA': [('A085', 'AGRA'), ('A167', 'ALBIZZATE'), ('A290', 'ANGERA'), ('A371', 'ARCISATE'), ('A441', 'ARSAGO SEPRIO'), ('A531', 'AZZATE'), ('A532', 'AZZIO'), ('A619', 'BARASSO'), ('A645', 'BARDELLO'), ('A728', 'BEDERO VALCUVIA'), ('A819', 'BESANO'), ('A825', 'BESNATE'), ('A826', 'BESOZZO'), ('A845', 'BIANDRONNO'), ('A891', 'BISUSCHIO'), ('A918', 'BODIO LOMNAGO'), ('B126', 'BREBBIA'), ('B131', 'BREGANO'), ('B150', 'BRENTA'), ('B166', 'BREZZO DI BEDERO'), ('B182', 'BRINZIO'), ('B191', 'BRISSAGO-VALTRAVAGLIA'), ('B219', 'BRUNELLO'), ('B228', 'BRUSIMPIANO'), ('B258', 'BUGUGGIATE'), ('B300', 'BUSTO ARSIZIO'), ('B326', 'CADEGLIANO-VICONAGO'), ('M425', 'CADREZZATE CON OSMATE'), ('B368', 'CAIRATE'), ('B634', 'CANTELLO'), ('B732', 'CARAVATE'), ('B754', 'CARDANO AL CAMPO'), ('B796', 'CARNAGO'), ('B805', 'CARONNO PERTUSELLA'), ('B807', 'CARONNO VARESINO'), ('B875', 'CASALE LITTA'), ('B921', 'CASALZUIGNO'), ('B949', 'CASCIAGO'), ('B987', 'CASORATE SEMPIONE'), ('C004', 'CASSANO MAGNAGO'), ('B999', 'CASSANO VALCUVIA'), ('C139', 'CASTELLANZA'), ('B312', 'CASTELLO CABIAGLIO'), ('C273', 'CASTELSEPRIO'), ('C181', 'CASTELVECCANA'), ('C300', 'CASTIGLIONE OLONA'), ('C343', 'CASTRONNO'), ('C382', 'CAVARIA CON PREMEZZO'), ('C409', 'CAZZAGO BRABBIA'), ('C732', 'CISLAGO'), ('C751', 'CITTIGLIO'), ('C796', 'CLIVIO'), ('C810', 'COCQUIO-TREVISAGO'), ('C911', 'COMABBIO'), ('C922', 'COMERIO'), ('D144', 'CREMENAGA'), ('D185', 'CROSIO DELLA VALLE'), ('D192', 'CUASSO AL MONTE'), ('D199', 'CUGLIATE-FABIASCO'), ('D204', 'CUNARDO'), ('D217', 'CURIGLIA CON MONTEVIASCO'), ('D238', 'CUVEGLIO'), ('D239', 'CUVIO'), ('D256', 'DAVERIO'), ('D384', 'DUMENZA'), ('D385', 'DUNO'), ('D467', 'FAGNANO OLONA'), ('D543', 'FERNO'), ('D551', 'FERRERA DI VARESE'), ('D869', 'GALLARATE'), ('D871', 'GALLIATE LOMBARDO'), ('D946', 'GAVIRATE'), ('D951', 'GAZZADA SCHIANNO'), ('D963', 'GEMONIO'), ('D981', 'GERENZANO'), ('D987', 'GERMIGNAGA'), ('E079', 'GOLASECCA'), ('E101', 'GORLA MAGGIORE'), ('E102', 'GORLA MINORE'), ('E104', 'GORNATE OLONA'), ('E144', 'GRANTOLA'), ('E292', 'INARZO'), ('E299', 'INDUNO OLONA'), ('E367', 'ISPRA'), ('E386', 'JERAGO CON ORAGO'), ('E494', 'LAVENA PONTE TRESA'), ('E496', 'LAVENO-MOMBELLO'), ('E510', 'LEGGIUNO'), ('E665', 'LONATE CEPPINO'), ('E666', 'LONATE POZZOLO'), ('E707', 'LOZZA'), ('E734', 'LUINO'), ('E769', 'LUVINATE'), ('M339', 'MACCAGNO CON PINO E VEDDASCA'), ('E856', 'MALGESSO'), ('E863', 'MALNATE'), ('E929', 'MARCHIROLO'), ('E965', 'MARNATE'), ('F002', 'MARZIO'), ('F007', 'MASCIAGO PRIMO'), ('F134', 'MERCALLO'), ('F154', 'MESENZANA'), ('F526', 'MONTEGRINO VALTRAVAGLIA'), ('F703', 'MONVALLE'), ('F711', 'MORAZZONE'), ('F736', 'MORNAGO'), ('G008', 'OGGIONA CON SANTO STEFANO'), ('G028', 'OLGIATE OLONA'), ('G103', 'ORIGGIO'), ('G105', 'ORINO'), ('G906', 'PORTO CERESIO'), ('G907', 'PORTO VALTRAVAGLIA'), ('H173', 'RANCIO VALCUVIA'), ('H174', 'RANCO'), ('H723', 'SALTRIO'), ('H736', 'SAMARATE'), ('H872', 'SANGIANO'), ('I441', 'SARONNO'), ('I688', 'SESTO CALENDE'), ('I793', 'SOLBIATE ARNO'), ('I794', 'SOLBIATE OLONA'), ('I819', 'SOMMA LOMBARDO'), ('L003', 'SUMIRAGO'), ('L032', 'TAINO'), ('L115', 'TERNATE'), ('L319', 'TRADATE'), ('L342', 'TRAVEDONA-MONATE'), ('A705', 'TRONZANO LAGO MAGGIORE'), ('L480', 'UBOLDO'), ('L577', 'VALGANNA'), ('L671', 'VARANO BORGHI'), ('L682', 'VARESE'), ('L703', 'VEDANO OLONA'), ('L733', 'VENEGONO INFERIORE'), ('L734', 'VENEGONO SUPERIORE'), ('L765', 'VERGIATE'), ('L876', 'VIGGIÙ'), ('M101', 'VIZZOLA TICINO')],
    'VB': [('A317', 'ANTRONA SCHIERANCO'), ('A325', "ANZOLA D'OSSOLA"), ('A409', 'ARIZZANO'), ('A427', 'AROLA'), ('A497', 'AURANO'), ('A534', 'BACENO'), ('A610', 'BANNIO ANZINO'), ('A725', 'BAVENO'), ('A733', 'BEE'), ('A742', 'BELGIRATE'), ('A834', 'BEURA-CARDEZZA'), ('A925', 'BOGNANCO'), ('M370', 'BORGOMEZZAVALLE'), ('B207', 'BROVELLO-CARPUGNINO'), ('B380', 'CALASCA-CASTIGLIONE'), ('B463', 'CAMBIASCA'), ('B610', 'CANNERO RIVIERA'), ('B615', 'CANNOBIO'), ('B694', 'CAPREZZO'), ('B876', 'CASALE CORTE CERRO'), ('C478', 'CEPPO MORELLI'), ('C567', 'CESARA'), ('D099', 'COSSOGNO'), ('D134', 'CRAVEGGIA'), ('D168', 'CREVOLADOSSOLA'), ('D177', 'CRODO'), ('D332', 'DOMODOSSOLA'), ('D374', 'DRUOGNO'), ('D706', 'FORMAZZA'), ('D984', 'GERMAGNO'), ('E003', 'GHIFFA'), ('E028', 'GIGNESE'), ('E153', 'GRAVELLONA TOCE'), ('E269', 'GURRO'), ('E304', 'INTRAGNA'), ('E685', 'LOREGLIA'), ('E790', 'MACUGNAGA'), ('E795', 'MADONNA DEL SASSO'), ('E853', 'MALESCO'), ('F010', 'MASERA'), ('F048', 'MASSIOLA'), ('F146', 'MERGOZZO'), ('F192', 'MIAZZINA'), ('F483', 'MONTECRESTESE'), ('F639', 'MONTESCHENO'), ('F932', 'NONIO'), ('G007', 'OGGEBBIO'), ('G062', 'OMEGNA'), ('G117', 'ORNAVASSO'), ('G280', 'PALLANZENO'), ('G600', 'PIEDIMULERA'), ('G658', 'PIEVE VERGONTE'), ('H030', 'PREMENO'), ('H033', 'PREMIA'), ('H037', 'PREMOSELLO-CHIOVENDA'), ('H106', 'QUARNA SOPRA'), ('H107', 'QUARNA SOTTO'), ('H203', 'RE'), ('H777', 'SAN BERNARDINO VERBANO'), ('I249', 'SANTA MARIA MAGGIORE'), ('I976', 'STRESA'), ('L187', 'TOCENO'), ('L333', 'TRAREGO VIGGIONA'), ('L336', 'TRASQUERA'), ('L450', 'TRONTANO'), ('M404', 'VALLE CANNOBINA'), ('L651', 'VALSTRONA'), ('L666', 'VANZONE CON SAN CARLO'), ('L691', 'VARZO'), ('L746', 'VERBANIA'), ('L889', 'VIGNONE'), ('L906', 'VILLADOSSOLA'), ('M042', 'VILLETTE'), ('M111', 'VOGOGNA')],
    'VC': [('A119', 'ALAGNA VALSESIA'), ('A130', 'ALBANO VERCELLESE'), ('A198', 'ALICE CASTELLO'), ('M389', 'ALTO SERMENZA'), ('A358', 'ARBORIO'), ('A466', 'ASIGLIANO VERCELLESE'), ('A600', 'BALMUCCIA'), ('A601', 'BALOCCO'), ('A847', 'BIANZÈ'), ('A914', 'BOCCIOLETO'), ('B009', "BORGO D'ALE"), ('B046', 'BORGO VERCELLI'), ('B041', 'BORGOSESIA'), ('B280', 'BURONZO'), ('B505', 'CAMPERTOGNO'), ('B752', 'CARCOFORO'), ('B767', 'CARESANA'), ('B768', 'CARESANABLOT'), ('B782', 'CARISIO'), ('B928', 'CASANOVA ELVO'), ('M398', 'CELLIO CON BREIA'), ('C548', 'CERVATTO'), ('C680', 'CIGLIANO'), ('C757', 'CIVIASCO'), ('C884', 'COLLOBIANO'), ('D113', 'COSTANZANA'), ('D132', 'CRAVAGLIANA'), ('D154', 'CRESCENTINO'), ('D187', 'CROVA'), ('D281', 'DESANA'), ('D641', 'FOBELLO'), ('D676', 'FONTANETTO PO'), ('D712', 'FORMIGLIANA'), ('D938', 'GATTINARA'), ('E007', 'GHISLARENGO'), ('E163', 'GREGGIO'), ('E237', 'GUARDABOSONE'), ('E433', 'LAMPORO'), ('E528', 'LENTA'), ('E583', 'LIGNANA'), ('E626', 'LIVORNO FERRARIS'), ('E711', 'LOZZOLO'), ('F297', 'MOLLIA'), ('F342', 'MONCRIVELLO'), ('F774', "MOTTA DE' CONTI"), ('G016', 'OLCENENGO'), ('G018', 'OLDENICO'), ('G266', 'PALAZZOLO VERCELLESE'), ('G471', 'PERTENGO'), ('G528', 'PEZZANA'), ('G666', 'PILA'), ('G685', 'PIODE'), ('G940', 'POSTUA'), ('G985', 'PRAROLO'), ('H108', 'QUARONA'), ('H132', 'QUINTO VERCELLESE'), ('H188', 'RASSA'), ('H293', 'RIMELLA'), ('H346', 'RIVE'), ('H365', 'ROASIO'), ('H549', 'RONSECCO'), ('H577', 'ROSSA'), ('H364', 'ROVASENDA'), ('H690', 'SALASCO'), ('H707', 'SALI VERCELLESE'), ('H725', 'SALUGGIA'), ('H861', 'SAN GERMANO VERCELLESE'), ('B952', 'SAN GIACOMO VERCELLESE'), ('I337', 'SANTHIÀ'), ('I544', 'SCOPA'), ('I545', 'SCOPELLO'), ('I663', 'SERRAVALLE SESIA'), ('I984', 'STROPPIANA'), ('L420', 'TRICERRO'), ('L429', 'TRINO'), ('L451', 'TRONZANO VERCELLESE'), ('L566', 'VALDUGGIA'), ('L669', 'VARALLO'), ('L750', 'VERCELLI'), ('M003', 'VILLARBOIT'), ('M028', 'VILLATA'), ('M106', 'VOCCA')],
    'VE': [('A302', 'ANNONE VENETO'), ('B493', 'CAMPAGNA LUPIA'), ('B546', 'CAMPOLONGO MAGGIORE'), ('B554', 'CAMPONOGARA'), ('B642', 'CAORLE'), ('M308', 'CAVALLINO-TREPORTI'), ('C383', 'CAVARZERE'), ('C422', 'CEGGIA'), ('C638', 'CHIOGGIA'), ('C714', 'CINTO CAOMAGGIORE'), ('C938', 'CONA'), ('C950', 'CONCORDIA SAGITTARIA'), ('D325', 'DOLO'), ('D415', 'ERACLEA'), ('D578', "FIESSO D'ARTICO"), ('D740', 'FOSSALTA DI PIAVE'), ('D741', 'FOSSALTA DI PORTOGRUARO'), ('D748', 'FOSSÒ'), ('E215', 'GRUARO'), ('C388', 'JESOLO'), ('E936', 'MARCON'), ('E980', 'MARTELLAGO'), ('F130', 'MEOLO'), ('F229', 'MIRA'), ('F241', 'MIRANO'), ('F826', 'MUSILE DI PIAVE'), ('F904', 'NOALE'), ('F963', 'NOVENTA DI PIAVE'), ('G565', 'PIANIGA'), ('G914', 'PORTOGRUARO'), ('G981', 'PRAMAGGIORE'), ('H117', "QUARTO D'ALTINO"), ('H735', 'SALZANO'), ('H823', 'SAN DONÀ DI PIAVE'), ('I040', 'SAN MICHELE AL TAGLIAMENTO'), ('I373', 'SAN STINO DI LIVENZA'), ('I242', 'SANTA MARIA DI SALA'), ('I551', 'SCORZÈ'), ('I908', 'SPINEA'), ('I965', 'STRA'), ('L085', 'TEGLIO VENETO'), ('L267', 'TORRE DI MOSTO'), ('L736', 'VENEZIA'), ('L899', 'VIGONOVO')],
    'VI': [('A093', 'AGUGLIARO'), ('A154', 'ALBETTONE'), ('A220', 'ALONTE'), ('A231', 'ALTAVILLA VICENTINA'), ('A236', 'ALTISSIMO'), ('A377', 'ARCUGNANO'), ('A444', 'ARSIERO'), ('A459', 'ARZIGNANO'), ('A465', 'ASIAGO'), ('A467', 'ASIGLIANO VENETO'), ('M401', 'BARBARANO MOSSANO'), ('A703', 'BASSANO DEL GRAPPA'), ('A954', 'BOLZANO VICENTINO'), ('B132', 'BREGANZE'), ('B143', 'BRENDOLA'), ('B161', 'BRESSANVIDO'), ('B196', 'BROGLIANO'), ('B403', 'CALDOGNO'), ('B433', 'CALTRANO'), ('B441', 'CALVENE'), ('B485', 'CAMISANO VICENTINO'), ('B511', 'CAMPIGLIA DEI BERICI'), ('B835', 'CARRÈ'), ('B844', 'CARTIGLIANO'), ('C037', 'CASSOLA'), ('C056', 'CASTEGNERO'), ('C119', 'CASTELGOMBERTO'), ('C605', 'CHIAMPO'), ('C650', 'CHIUPPANO'), ('C824', 'COGOLLO DEL CENGIO'), ('M426', 'COLCERESA'), ('D020', 'CORNEDO VICENTINO'), ('D107', 'COSTABISSARA'), ('D136', 'CREAZZO'), ('D156', 'CRESPADORO'), ('D379', 'DUEVILLE'), ('D407', 'ENEGO'), ('D496', 'FARA VICENTINO'), ('D750', 'FOZA'), ('D882', 'GALLIO'), ('D897', 'GAMBELLARA'), ('D902', 'GAMBUGLIANO'), ('E184', 'GRISIGNANO DI ZOCCO'), ('E226', 'GRUMOLO DELLE ABBADESSE'), ('E354', 'ISOLA VICENTINA'), ('E403', 'LAGHI'), ('E465', 'LASTEBASSE'), ('E671', 'LONGARE'), ('E682', 'LONIGO'), ('E731', 'LUGO DI VICENZA'), ('M427', 'LUSIANA CONCO'), ('E864', 'MALO'), ('E912', 'MARANO VICENTINO'), ('E970', 'MAROSTICA'), ('F486', 'MONTE DI MALO'), ('F442', 'MONTEBELLO VICENTINO'), ('F464', 'MONTECCHIO MAGGIORE'), ('F465', 'MONTECCHIO PRECALCINO'), ('F514', 'MONTEGALDA'), ('F515', 'MONTEGALDELLA'), ('F662', 'MONTEVIALE'), ('F675', 'MONTICELLO CONTE OTTO'), ('F696', 'MONTORSO VICENTINO'), ('F829', 'MUSSOLENTE'), ('F838', 'NANTO'), ('F922', 'NOGAROLE VICENTINO'), ('F957', 'NOVE'), ('F964', 'NOVENTA VICENTINA'), ('G095', 'ORGIANO'), ('G406', 'PEDEMONTE'), ('G560', 'PIANEZZE'), ('G694', 'PIOVENE ROCCHETTE'), ('G776', 'POJANA MAGGIORE'), ('G931', 'POSINA'), ('G943', 'POVE DEL GRAPPA'), ('G957', 'POZZOLEONE'), ('H134', 'QUINTO VICENTINO'), ('H214', 'RECOARO TERME'), ('H361', 'ROANA'), ('H512', "ROMANO D'EZZELINO"), ('H580', 'ROSSANO VENETO'), ('H556', 'ROSÀ'), ('H594', 'ROTZO'), ('F810', 'SALCEDO'), ('I117', 'SAN PIETRO MUSSOLINO'), ('I401', 'SAN VITO DI LEGUZZANO'), ('H829', 'SANDRIGO'), ('I353', 'SANTORSO'), ('I425', 'SARCEDO'), ('I430', 'SAREGO'), ('I527', 'SCHIAVON'), ('I531', 'SCHIO'), ('I783', 'SOLAGNA'), ('I867', 'SOSSANO'), ('I879', 'SOVIZZO'), ('L156', 'TEZZE SUL BRENTA'), ('L157', 'THIENE'), ('D717', 'TONEZZA DEL CIMONE'), ('L248', 'TORREBELVICINO'), ('L297', 'TORRI DI QUARTESOLO'), ('L433', 'TRISSINO'), ('M384', 'VAL LIONA'), ('M423', 'VALBRENTA'), ('L551', 'VALDAGNO'), ('L554', 'VALDASTICO'), ('L624', 'VALLI DEL PASUBIO'), ('L723', "VELO D'ASTICO"), ('L840', 'VICENZA'), ('L952', 'VILLAGA'), ('M032', 'VILLAVERLA'), ('M145', 'ZANÈ'), ('M170', 'ZERMEGHEDO'), ('M194', 'ZOVENCEDO'), ('M199', 'ZUGLIANO')],
    'VR': [('A061', 'AFFI'), ('A137', "ALBAREDO D'ADIGE"), ('A292', 'ANGIARI'), ('A374', 'ARCOLE'), ('A540', 'BADIA CALAVENA'), ('A650', 'BARDOLINO'), ('A737', 'BELFIORE'), ('A837', 'BEVILACQUA'), ('A964', 'BONAVIGO'), ('B070', "BOSCHI SANT'ANNA"), ('B073', 'BOSCO CHIESANUOVA'), ('B107', 'BOVOLONE'), ('B152', 'BRENTINO BELLUNO'), ('B154', 'BRENZONE SUL GARDA'), ('B296', 'BUSSOLENGO'), ('B304', 'BUTTAPIETRA'), ('B402', 'CALDIERO'), ('B709', 'CAPRINO VERONESE'), ('B886', 'CASALEONE'), ('C041', 'CASTAGNARO'), ('C078', "CASTEL D'AZZANO"), ('C225', 'CASTELNUOVO DEL GARDA'), ('C370', 'CAVAION VERONESE'), ('C412', 'CAZZANO DI TRAMIGNA'), ('C498', 'CEREA'), ('C538', 'CERRO VERONESE'), ('C890', 'COLOGNA VENETA'), ('C897', 'COLOGNOLA AI COLLI'), ('C943', 'CONCAMARISE'), ('D118', 'COSTERMANO SUL GARDA'), ('D317', 'DOLCÈ'), ('D420', 'ERBEZZO'), ('D419', 'ERBÈ'), ('D549', 'FERRARA DI MONTE BALDO'), ('D818', 'FUMANE'), ('D915', 'GARDA'), ('D957', 'GAZZO VERONESE'), ('E171', 'GREZZANA'), ('E284', 'ILLASI'), ('E349', 'ISOLA DELLA SCALA'), ('E358', 'ISOLA RIZZA'), ('E489', 'LAVAGNO'), ('E502', 'LAZISE'), ('E512', 'LEGNAGO'), ('E848', 'MALCESINE'), ('E911', 'MARANO DI VALPOLICELLA'), ('F172', 'MEZZANE DI SOTTO'), ('F218', 'MINERBE'), ('F461', 'MONTECCHIA DI CROSARA'), ('F508', "MONTEFORTE D'ALPONE"), ('F789', 'MOZZECANE'), ('F861', 'NEGRAR DI VALPOLICELLA'), ('F918', 'NOGARA'), ('F921', 'NOGAROLE ROCCA'), ('G080', 'OPPEANO'), ('G297', 'PALÙ'), ('G365', 'PASTRENGO'), ('G481', 'PESCANTINA'), ('G489', 'PESCHIERA DEL GARDA'), ('G945', 'POVEGLIANO VERONESE'), ('H048', 'PRESSANA'), ('H356', 'RIVOLI VERONESE'), ('H540', "RONCO ALL'ADIGE"), ('H522', 'RONCÀ'), ('H606', 'ROVERCHIARA'), ('H610', 'ROVEREDO DI GUÀ'), ('H608', 'ROVERÈ VERONESE'), ('H714', 'SALIZZOLE'), ('H783', 'SAN BONIFACIO'), ('H916', 'SAN GIOVANNI ILARIONE'), ('H924', 'SAN GIOVANNI LUPATOTO'), ('I003', 'SAN MARTINO BUON ALBERGO'), ('H712', 'SAN MAURO DI SALINE'), ('I105', 'SAN PIETRO DI MORUBIO'), ('I109', 'SAN PIETRO IN CARIANO'), ('I414', 'SAN ZENO DI MONTAGNA'), ('H944', 'SANGUINETTO'), ('I259', "SANT'AMBROGIO DI VALPOLICELLA"), ('I292', "SANT'ANNA D'ALFAEDO"), ('I594', 'SELVA DI PROGNO'), ('I775', 'SOAVE'), ('I821', 'SOMMACAMPAGNA'), ('I826', 'SONA'), ('I850', 'SORGÀ'), ('L136', 'TERRAZZO'), ('L287', 'TORRI DEL BENACO'), ('L364', 'TREGNAGO'), ('L396', 'TREVENZUOLO'), ('L567', 'VALEGGIO SUL MINCIO'), ('L722', 'VELO VERONESE'), ('L781', 'VERONA'), ('D193', 'VERONELLA'), ('L810', 'VESTENANOVA'), ('L869', 'VIGASIO'), ('L912', 'VILLA BARTOLOMEA'), ('L949', 'VILLAFRANCA DI VERONA'), ('M172', 'ZEVIO'), ('M178', 'ZIMELLA')],
    'VT': [('A040', 'ACQUAPENDENTE'), ('A412', 'ARLENA DI CASTRO'), ('A577', 'BAGNOREGIO'), ('A628', 'BARBARANO ROMANO'), ('A706', 'BASSANO IN TEVERINA'), ('A704', 'BASSANO ROMANO'), ('A857', 'BLERA'), ('A949', 'BOLSENA'), ('A955', 'BOMARZO'), ('B388', 'CALCATA'), ('B597', 'CANEPINA'), ('B604', 'CANINO'), ('B663', 'CAPODIMONTE'), ('B688', 'CAPRANICA'), ('B691', 'CAPRAROLA'), ('B735', 'CARBOGNANO'), ('C269', "CASTEL SANT'ELIA"), ('C315', 'CASTIGLIONE IN TEVERINA'), ('C446', 'CELLENO'), ('C447', 'CELLERE'), ('C765', 'CIVITA CASTELLANA'), ('C780', "CIVITELLA D'AGLIANO"), ('C988', 'CORCHIANO'), ('D452', 'FABRICA DI ROMA'), ('D475', 'FALERIA'), ('D503', 'FARNESE'), ('D870', 'GALLESE'), ('E126', 'GRADOLI'), ('E128', 'GRAFFIGNANO'), ('E210', 'GROTTE DI CASTRO'), ('E330', 'ISCHIA DI CASTRO'), ('E467', 'LATERA'), ('E713', 'LUBRIANO'), ('E978', 'MARTA'), ('F419', 'MONTALTO DI CASTRO'), ('F603', 'MONTE ROMANO'), ('F499', 'MONTEFIASCONE'), ('F606', 'MONTEROSI'), ('F868', 'NEPI'), ('G065', 'ONANO'), ('G111', 'ORIOLO ROMANO'), ('G135', 'ORTE'), ('G571', 'PIANSANO'), ('H071', 'PROCENO'), ('H534', 'RONCIGLIONE'), ('H969', 'SAN LORENZO NUOVO'), ('I855', 'SORIANO NEL CIMINO'), ('L017', 'SUTRI'), ('D024', 'TARQUINIA'), ('L150', 'TESSENNANO'), ('L310', 'TUSCANIA'), ('L569', 'VALENTANO'), ('L612', 'VALLERANO'), ('A701', 'VASANELLO'), ('L713', 'VEJANO'), ('L814', 'VETRALLA'), ('L882', 'VIGNANELLO'), ('H913', 'VILLA SAN GIOVANNI IN TUSCIA'), ('M082', 'VITERBO'), ('M086', 'VITORCHIANO')],
    'VV': [('A043', 'ACQUARO'), ('A386', 'ARENA'), ('B169', 'BRIATICO'), ('B197', 'BROGNATURO'), ('B655', 'CAPISTRANO'), ('C581', 'CESSANITI'), ('D253', 'DASÀ'), ('D303', 'DINAMI'), ('D364', 'DRAPIA'), ('D453', 'FABRIZIA'), ('D587', 'FILADELFIA'), ('D589', 'FILANDARI'), ('D596', 'FILOGASO'), ('D762', 'FRANCAVILLA ANGITOLA'), ('D767', 'FRANCICA'), ('D988', 'GEROCARNE'), ('E321', 'IONADI'), ('E389', 'JOPPOLO'), ('E590', 'LIMBADI'), ('E836', 'MAIERATO'), ('F207', 'MILETO'), ('F364', 'MONGIANA'), ('F607', 'MONTEROSSO CALABRO'), ('F843', 'NARDODIPACE'), ('F893', 'NICOTERA'), ('G335', 'PARGHELIA'), ('G722', 'PIZZO'), ('G728', 'PIZZONI'), ('G785', 'POLIA'), ('H271', 'RICADI'), ('H516', 'ROMBIOLO'), ('H785', 'SAN CALOGERO'), ('H807', 'SAN COSTANTINO CALABRO'), ('H941', "SAN GREGORIO D'IPPONA"), ('I058', 'SAN NICOLA DA CRISSA'), ('I350', "SANT'ONOFRIO"), ('I639', 'SERRA SAN BRUNO'), ('I744', 'SIMBARIO'), ('I853', 'SORIANELLO'), ('I854', 'SORIANO CALABRO'), ('I884', 'SPADOLA'), ('I905', 'SPILINGA'), ('I945', 'STEFANACONI'), ('L452', 'TROPEA'), ('L607', 'VALLELONGA'), ('L699', 'VAZZANO'), ('F537', 'VIBO VALENTIA'), ('M138', 'ZACCANOPOLI'), ('M143', 'ZAMBRONE'), ('M204', 'ZUNGRI')],
}

# COMUNI_BY_CODE: {codice_belfiore: (nome_comune, sigla_prov)}
COMUNI_BY_CODE = {
    'A001': ('ABANO TERME', 'PD'),
    'A004': ('ABBADIA CERRETO', 'LO'),
    'A005': ('ABBADIA LARIANA', 'LC'),
    'A006': ('ABBADIA SAN SALVATORE', 'SI'),
    'A007': ('ABBASANTA', 'OR'),
    'A008': ('ABBATEGGIO', 'PE'),
    'A010': ('ABBIATEGRASSO', 'MI'),
    'A013': ('ABRIOLA', 'PZ'),
    'A014': ('ACATE', 'RG'),
    'A015': ('ACCADIA', 'FG'),
    'A016': ('ACCEGLIO', 'CN'),
    'A017': ('ACCETTURA', 'MT'),
    'A018': ('ACCIANO', 'AQ'),
    'A019': ('ACCUMOLI', 'RI'),
    'A020': ('ACERENZA', 'PZ'),
    'A022': ('CERMES/TSCHERMS', 'BZ'),
    'A023': ('ACERNO', 'SA'),
    'A024': ('ACERRA', 'NA'),
    'A025': ('ACI BONACCORSI', 'CT'),
    'A026': ('ACI CASTELLO', 'CT'),
    'A027': ('ACI CATENA', 'CT'),
    'A028': ('ACIREALE', 'CT'),
    'A029': ("ACI SANT'ANTONIO", 'CT'),
    'A032': ('ACQUAFONDATA', 'FR'),
    'A033': ('ACQUAFORMOSA', 'CS'),
    'A034': ('ACQUAFREDDA', 'BS'),
    'A035': ('ACQUALAGNA', 'PU'),
    'A038': ('ACQUANEGRA SUL CHIESE', 'MN'),
    'A039': ('ACQUANEGRA CREMONESE', 'CR'),
    'A040': ('ACQUAPENDENTE', 'VT'),
    'A041': ('ACQUAPPESA', 'CS'),
    'A043': ('ACQUARO', 'VV'),
    'A044': ('ACQUASANTA TERME', 'AP'),
    'A045': ('ACQUASPARTA', 'TR'),
    'A047': ('ACQUAVIVA PICENA', 'AP'),
    'A048': ('ACQUAVIVA DELLE FONTI', 'BA'),
    'A049': ('ACQUAVIVA PLATANI', 'CL'),
    'A050': ('ACQUAVIVA COLLECROCE', 'CB'),
    'A051': ("ACQUAVIVA D'ISERNIA", 'IS'),
    'A052': ('ACQUI TERME', 'AL'),
    'A053': ('ACRI', 'CS'),
    'A054': ('ACUTO', 'FR'),
    'A055': ('ADELFIA', 'BA'),
    'A056': ('ADRANO', 'CT'),
    'A057': ('ADRARA SAN MARTINO', 'BG'),
    'A058': ('ADRARA SAN ROCCO', 'BG'),
    'A059': ('ADRIA', 'RO'),
    'A060': ('ADRO', 'BS'),
    'A061': ('AFFI', 'VR'),
    'A062': ('AFFILE', 'RM'),
    'A064': ('AFRAGOLA', 'NA'),
    'A065': ('AFRICO', 'RC'),
    'A067': ('AGAZZANO', 'PC'),
    'A068': ('AGEROLA', 'NA'),
    'A069': ('AGGIUS', 'SS'),
    'A070': ('AGIRA', 'EN'),
    'A071': ('AGLIANA', 'PT'),
    'A072': ('AGLIANO TERME', 'AT'),
    'A074': ('AGLIÈ', 'TO'),
    'A075': ('AGNA', 'PD'),
    'A076': ('AGNADELLO', 'CR'),
    'A077': ('AGNANA CALABRA', 'RC'),
    'A080': ('AGNONE', 'IS'),
    'A081': ('VILLA LATINA', 'FR'),
    'A082': ('AGNOSINE', 'BS'),
    'A083': ('AGORDO', 'BL'),
    'A084': ('AGOSTA', 'RM'),
    'A085': ('AGRA', 'VA'),
    'A087': ('AGRATE BRIANZA', 'MB'),
    'A088': ('AGRATE CONTURBIA', 'NO'),
    'A089': ('AGRIGENTO', 'AG'),
    'A091': ('AGROPOLI', 'SA'),
    'A092': ('AGUGLIANO', 'AN'),
    'A093': ('AGUGLIARO', 'VI'),
    'A094': ('AYAS', 'AO'),
    'A096': ('AICURZIO', 'MB'),
    'A097': ('AIDOMAGGIORE', 'OR'),
    'A098': ('AIDONE', 'EN'),
    'A100': ('AIELLI', 'AQ'),
    'A101': ('AIELLO DEL SABATO', 'AV'),
    'A102': ('AIELLO CALABRO', 'CS'),
    'A103': ('AIELLO DEL FRIULI', 'UD'),
    'A105': ('AIETA', 'CS'),
    'A106': ('AILANO', 'CE'),
    'A107': ('AILOCHE', 'BI'),
    'A108': ('AYMAVILLES', 'AO'),
    'A109': ('AIRASCA', 'TO'),
    'A110': ('AIROLA', 'BN'),
    'A111': ('AIROLE', 'IM'),
    'A112': ('AIRUNO', 'LC'),
    'A113': ('AISONE', 'CN'),
    'A115': ('ALÀ DEI SARDI', 'SS'),
    'A116': ('ALA', 'TN'),
    'A117': ('ALA DI STURA', 'TO'),
    'A118': ('ALAGNA', 'PV'),
    'A119': ('ALAGNA VALSESIA', 'VC'),
    'A120': ('ALANNO', 'PE'),
    'A121': ('ALANO DI PIAVE', 'BL'),
    'A122': ('ALASSIO', 'SV'),
    'A123': ('ALATRI', 'FR'),
    'A124': ('ALBA', 'CN'),
    'A125': ('ALBA ADRIATICA', 'TE'),
    'A126': ('ALBAGIARA', 'OR'),
    'A127': ('ALBAIRATE', 'MI'),
    'A128': ('ALBANELLA', 'SA'),
    'A129': ("ALBANO SANT'ALESSANDRO", 'BG'),
    'A130': ('ALBANO VERCELLESE', 'VC'),
    'A131': ('ALBANO DI LUCANIA', 'PZ'),
    'A132': ('ALBANO LAZIALE', 'RM'),
    'A134': ('ALBAREDO ARNABOLDI', 'PV'),
    'A135': ('ALBAREDO PER SAN MARCO', 'SO'),
    'A137': ("ALBAREDO D'ADIGE", 'VR'),
    'A138': ('ALBARETO', 'PR'),
    'A139': ('ALBARETTO DELLA TORRE', 'CN'),
    'A143': ('ALBAVILLA', 'CO'),
    'A145': ('ALBENGA', 'SV'),
    'A146': ('ALBERA LIGURE', 'AL'),
    'A149': ('ALBEROBELLO', 'BA'),
    'A150': ('ALBERONA', 'FG'),
    'A153': ('ALBESE CON CASSANO', 'CO'),
    'A154': ('ALBETTONE', 'VI'),
    'A155': ('ALBI', 'CZ'),
    'A157': ("ALBIANO D'IVREA", 'TO'),
    'A158': ('ALBIANO', 'TN'),
    'A159': ('ALBIATE', 'MB'),
    'A160': ('ALBIDONA', 'CS'),
    'A161': ('ALBIGNASEGO', 'PD'),
    'A162': ('ALBINEA', 'RE'),
    'A163': ('ALBINO', 'BG'),
    'A164': ('ALBIOLO', 'CO'),
    'A165': ('ALBISSOLA MARINA', 'SV'),
    'A166': ('ALBISOLA SUPERIORE', 'SV'),
    'A167': ('ALBIZZATE', 'VA'),
    'A171': ('ALBONESE', 'PV'),
    'A172': ('ALBOSAGGIA', 'SO'),
    'A173': ('ALBUGNANO', 'AT'),
    'A175': ('ALBUZZANO', 'PV'),
    'A176': ('ALCAMO', 'TP'),
    'A177': ('ALCARA LI FUSI', 'ME'),
    'A178': ('ALDENO', 'TN'),
    'A179': ('ALDINO/ALDEIN', 'BZ'),
    'A180': ('ALES', 'OR'),
    'A181': ('ALESSANDRIA DELLA ROCCA', 'AG'),
    'A182': ('ALESSANDRIA', 'AL'),
    'A183': ('ALESSANDRIA DEL CARRETTO', 'CS'),
    'A184': ('ALESSANO', 'LE'),
    'A185': ('ALEZIO', 'LE'),
    'A186': ('ALFANO', 'SA'),
    'A187': ('ALFEDENA', 'AQ'),
    'A188': ('ALFIANELLO', 'BS'),
    'A189': ('ALFIANO NATTA', 'AL'),
    'A191': ('ALFONSINE', 'RA'),
    'A192': ('ALGHERO', 'SS'),
    'A193': ('ALGUA', 'BG'),
    'A194': ('ALÌ', 'ME'),
    'A195': ('ALIA', 'PA'),
    'A196': ('ALIANO', 'MT'),
    'A197': ('ALICE BEL COLLE', 'AL'),
    'A198': ('ALICE CASTELLO', 'VC'),
    'A200': ('ALIFE', 'CE'),
    'A201': ('ALÌ TERME', 'ME'),
    'A202': ('ALIMENA', 'PA'),
    'A203': ('ALIMINUSA', 'PA'),
    'A204': ('ALLAI', 'OR'),
    'A205': ('ALLEIN', 'AO'),
    'A206': ('ALLEGHE', 'BL'),
    'A207': ('ALLERONA', 'TR'),
    'A208': ('ALLISTE', 'LE'),
    'A210': ('ALLUMIERE', 'RM'),
    'A214': ('ALMÈ', 'BG'),
    'A215': ("VILLA D'ALMÈ", 'BG'),
    'A216': ('ALMENNO SAN BARTOLOMEO', 'BG'),
    'A217': ('ALMENNO SAN SALVATORE', 'BG'),
    'A218': ('ALMESE', 'TO'),
    'A220': ('ALONTE', 'VI'),
    'A221': ('ALPETTE', 'TO'),
    'A222': ('ALPIGNANO', 'TO'),
    'A223': ('ALSENO', 'PC'),
    'A224': ('ALSERIO', 'CO'),
    'A225': ('ALTAMURA', 'BA'),
    'A226': ('ALTARE', 'SV'),
    'A227': ('ALTAVILLA MONFERRATO', 'AL'),
    'A228': ('ALTAVILLA IRPINA', 'AV'),
    'A229': ('ALTAVILLA MILICIA', 'PA'),
    'A230': ('ALTAVILLA SILENTINA', 'SA'),
    'A231': ('ALTAVILLA VICENTINA', 'VI'),
    'A233': ('ALTIDONA', 'FM'),
    'A234': ('ALTILIA', 'CS'),
    'A235': ('ALTINO', 'CH'),
    'A236': ('ALTISSIMO', 'VI'),
    'A237': ('ALTIVOLE', 'TV'),
    'A238': ('ALTO', 'CN'),
    'A239': ('ALTOFONTE', 'PA'),
    'A240': ('ALTOMONTE', 'CS'),
    'A241': ('ALTOPASCIO', 'LU'),
    'A242': ('ALVIANO', 'TR'),
    'A243': ('ALVIGNANO', 'CE'),
    'A244': ('ALVITO', 'FR'),
    'A245': ('ALZANO SCRIVIA', 'AL'),
    'A246': ('ALZANO LOMBARDO', 'BG'),
    'A249': ('ALZATE BRIANZA', 'CO'),
    'A251': ('AMALFI', 'SA'),
    'A252': ('AMANDOLA', 'FM'),
    'A253': ('AMANTEA', 'CS'),
    'A254': ('AMARO', 'UD'),
    'A255': ('AMARONI', 'CZ'),
    'A256': ('AMASENO', 'FR'),
    'A257': ('AMATO', 'CZ'),
    'A258': ('AMATRICE', 'RI'),
    'A259': ('AMBIVERE', 'BG'),
    'A261': ('AMEGLIA', 'SP'),
    'A262': ('AMELIA', 'TR'),
    'A263': ('AMENDOLARA', 'CS'),
    'A264': ('AMENO', 'NO'),
    'A265': ('AMOROSI', 'BN'),
    'A266': ("CORTINA D'AMPEZZO", 'BL'),
    'A267': ('AMPEZZO', 'UD'),
    'A268': ('ANACAPRI', 'NA'),
    'A269': ('ANAGNI', 'FR'),
    'A270': ('ANCARANO', 'TE'),
    'A271': ('ANCONA', 'AN'),
    'A272': ('ANDALI', 'CZ'),
    'A273': ('ANDALO VALTELLINO', 'SO'),
    'A274': ('ANDALO', 'TN'),
    'A275': ('ANDEZENO', 'TO'),
    'A278': ('ANDORA', 'SV'),
    'A280': ('ANDORNO MICCA', 'BI'),
    'A281': ('ANDRANO', 'LE'),
    'A282': ('ANDRATE', 'TO'),
    'A283': ('ANDREIS', 'PN'),
    'A284': ('ANDRETTA', 'AV'),
    'A285': ('ANDRIA', 'BT'),
    'A286': ('ANDRIANO/ANDRIAN', 'BZ'),
    'A287': ('ANELA', 'SS'),
    'A288': ('ANFO', 'BS'),
    'A290': ('ANGERA', 'VA'),
    'A291': ('ANGHIARI', 'AR'),
    'A292': ('ANGIARI', 'VR'),
    'A293': ('ANGOLO TERME', 'BS'),
    'A294': ('ANGRI', 'SA'),
    'A295': ('ANGROGNA', 'TO'),
    'A296': ('ANGUILLARA VENETA', 'PD'),
    'A297': ('ANGUILLARA SABAZIA', 'RM'),
    'A299': ('ANNICCO', 'CR'),
    'A300': ('CASTELLO DI ANNONE', 'AT'),
    'A301': ('ANNONE DI BRIANZA', 'LC'),
    'A302': ('ANNONE VENETO', 'VE'),
    'A303': ('ANOIA', 'RC'),
    'A304': ('ANTEGNATE', 'BG'),
    'A305': ('ANTEY-SAINT-ANDRÉ', 'AO'),
    'A306': ('ANTERIVO/ALTREI', 'BZ'),
    'A308': ('LA MAGDELEINE', 'AO'),
    'A309': ('ANTICOLI CORRADO', 'RM'),
    'A310': ('FIUGGI', 'FR'),
    'A312': ('ANTIGNANO', 'AT'),
    'A313': ('ANTILLO', 'ME'),
    'A314': ('ANTONIMINA', 'RC'),
    'A315': ('ANTRODOCO', 'RI'),
    'A317': ('ANTRONA SCHIERANCO', 'VB'),
    'A318': ('ANVERSA DEGLI ABRUZZI', 'AQ'),
    'A319': ('ANZANO DEL PARCO', 'CO'),
    'A320': ('ANZANO DI PUGLIA', 'FG'),
    'A321': ('ANZI', 'PZ'),
    'A323': ('ANZIO', 'RM'),
    'A324': ("ANZOLA DELL'EMILIA", 'BO'),
    'A325': ("ANZOLA D'OSSOLA", 'VB'),
    'A326': ('AOSTA', 'AO'),
    'A327': ('APECCHIO', 'PU'),
    'A328': ('APICE', 'BN'),
    'A329': ('APIRO', 'MC'),
    'A330': ('APOLLOSA', 'BN'),
    'A332': ('APPIANO SULLA STRADA DEL VINO/EPPAN AN DER WEINSTRASSE', 'BZ'),
    'A333': ('APPIANO GENTILE', 'CO'),
    'A334': ('APPIGNANO', 'MC'),
    'A335': ('APPIGNANO DEL TRONTO', 'AP'),
    'A337': ('APRICA', 'SO'),
    'A338': ('APRICALE', 'IM'),
    'A339': ('APRICENA', 'FG'),
    'A340': ('APRIGLIANO', 'CS'),
    'A341': ('APRILIA', 'LT'),
    'A343': ('AQUARA', 'SA'),
    'A344': ("AQUILA D'ARROSCIA", 'IM'),
    'A345': ("L'AQUILA", 'AQ'),
    'A346': ('AQUILEIA', 'UD'),
    'A347': ('AQUILONIA', 'AV'),
    'A348': ('AQUINO', 'FR'),
    'A350': ('ARADEO', 'LE'),
    'A351': ('ARAGONA', 'AG'),
    'A352': ('ARAMENGO', 'AT'),
    'A354': ('ARBA', 'PN'),
    'A355': ('TORTOLÌ', 'NU'),
    'A357': ('ARBOREA', 'OR'),
    'A358': ('ARBORIO', 'VC'),
    'A359': ('ARBUS', 'SU'),
    'A360': ('ARCADE', 'TV'),
    'A363': ('ARCE', 'FR'),
    'A365': ('ARCENE', 'BG'),
    'A366': ('ARCEVIA', 'AN'),
    'A367': ('ARCHI', 'CH'),
    'A368': ("SAN NICOLÒ D'ARCIDANO", 'OR'),
    'A369': ('ARCIDOSSO', 'GR'),
    'A370': ('ARCINAZZO ROMANO', 'RM'),
    'A371': ('ARCISATE', 'VA'),
    'A372': ('ARCO', 'TN'),
    'A373': ('ARCOLA', 'SP'),
    'A374': ('ARCOLE', 'VR'),
    'A375': ('ARCONATE', 'MI'),
    'A376': ('ARCORE', 'MB'),
    'A377': ('ARCUGNANO', 'VI'),
    'A379': ('ARDARA', 'SS'),
    'A380': ('ARDAULI', 'OR'),
    'A382': ('ARDENNO', 'SO'),
    'A383': ('ARDESIO', 'BG'),
    'A385': ('ARDORE', 'RC'),
    'A386': ('ARENA', 'VV'),
    'A387': ('ARENA PO', 'PV'),
    'A388': ('ARENZANO', 'GE'),
    'A389': ('ARESE', 'MI'),
    'A390': ('AREZZO', 'AR'),
    'A391': ('ARGEGNO', 'CO'),
    'A392': ('ARGELATO', 'BO'),
    'A393': ('ARGENTA', 'FE'),
    'A394': ('ARGENTERA', 'CN'),
    'A396': ('ARGUELLO', 'CN'),
    'A397': ('ARGUSTO', 'CZ'),
    'A398': ('ARI', 'CH'),
    'A399': ('ARIANO IRPINO', 'AV'),
    'A400': ('ARIANO NEL POLESINE', 'RO'),
    'A401': ('ARICCIA', 'RM'),
    'A402': ('ARIELLI', 'CH'),
    'A403': ('ARIENZO', 'CE'),
    'A405': ('ARIGNANO', 'TO'),
    'A407': ('ARITZO', 'NU'),
    'A409': ('ARIZZANO', 'VB'),
    'A412': ('ARLENA DI CASTRO', 'VT'),
    'A413': ('ARLUNO', 'MI'),
    'A414': ('ARMENO', 'NO'),
    'A415': ('ARMENTO', 'PZ'),
    'A418': ('ARMO', 'IM'),
    'A419': ('ARMUNGIA', 'SU'),
    'A421': ('ARNARA', 'FR'),
    'A422': ('ARNASCO', 'SV'),
    'A424': ('ARNAD', 'AO'),
    'A425': ('ARNESANO', 'LE'),
    'A427': ('AROLA', 'VB'),
    'A429': ('ARONA', 'NO'),
    'A430': ('AROSIO', 'CO'),
    'A431': ('ARPAIA', 'BN'),
    'A432': ('ARPAISE', 'BN'),
    'A433': ('ARPINO', 'FR'),
    'A434': ('ARQUÀ PETRARCA', 'PD'),
    'A435': ('ARQUÀ POLESINE', 'RO'),
    'A436': ('ARQUATA SCRIVIA', 'AL'),
    'A437': ('ARQUATA DEL TRONTO', 'AP'),
    'A438': ('ARRE', 'PD'),
    'A439': ('ARRONE', 'TR'),
    'A440': ("ARZAGO D'ADDA", 'BG'),
    'A441': ('ARSAGO SEPRIO', 'VA'),
    'A443': ('ARSIÈ', 'BL'),
    'A444': ('ARSIERO', 'VI'),
    'A445': ('ARSITA', 'TE'),
    'A446': ('ARSOLI', 'RM'),
    'A447': ('ARTA TERME', 'UD'),
    'A448': ('ARTEGNA', 'UD'),
    'A449': ('ARTENA', 'RM'),
    'A451': ('ARTOGNE', 'BS'),
    'A452': ('ARVIER', 'AO'),
    'A453': ('ARZACHENA', 'SS'),
    'A454': ('ARZANA', 'NU'),
    'A455': ('ARZANO', 'NA'),
    'A458': ('ARZERGRANDE', 'PD'),
    'A459': ('ARZIGNANO', 'VI'),
    'A460': ('ASCEA', 'SA'),
    'A461': ('ASCIANO', 'SI'),
    'A462': ('ASCOLI PICENO', 'AP'),
    'A463': ('ASCOLI SATRIANO', 'FG'),
    'A464': ('ASCREA', 'RI'),
    'A465': ('ASIAGO', 'VI'),
    'A466': ('ASIGLIANO VERCELLESE', 'VC'),
    'A467': ('ASIGLIANO VENETO', 'VI'),
    'A468': ('SINALUNGA', 'SI'),
    'A470': ('ASOLA', 'MN'),
    'A471': ('ASOLO', 'TV'),
    'A472': ('CASPERIA', 'RI'),
    'A473': ('ASSAGO', 'MI'),
    'A474': ('ASSEMINI', 'CA'),
    'A475': ('ASSISI', 'PG'),
    'A476': ('ASSO', 'CO'),
    'A477': ('ASSOLO', 'OR'),
    'A478': ('ASSORO', 'EN'),
    'A479': ('ASTI', 'AT'),
    'A480': ('ASUNI', 'OR'),
    'A481': ('ATELETA', 'AQ'),
    'A482': ('ATELLA', 'PZ'),
    'A484': ('ATENA LUCANA', 'SA'),
    'A485': ('ATESSA', 'CH'),
    'A486': ('ATINA', 'FR'),
    'A487': ('ATRANI', 'SA'),
    'A488': ('ATRI', 'TE'),
    'A489': ('ATRIPALDA', 'AV'),
    'A490': ('ATTIGLIANO', 'TR'),
    'A491': ('ATTIMIS', 'UD'),
    'A492': ('ATZARA', 'NU'),
    'A494': ('AUGUSTA', 'SR'),
    'A495': ('AULETTA', 'SA'),
    'A496': ('AULLA', 'MS'),
    'A497': ('AURANO', 'VB'),
    'A499': ('AURIGO', 'IM'),
    'A501': ('AURONZO DI CADORE', 'BL'),
    'A502': ('AUSONIA', 'FR'),
    'A503': ('AUSTIS', 'NU'),
    'A506': ('AVEGNO', 'GE'),
    'A507': ('AVELENGO/HAFLING', 'BZ'),
    'A508': ('AVELLA', 'AV'),
    'A509': ('AVELLINO', 'AV'),
    'A511': ('AVERARA', 'BG'),
    'A512': ('AVERSA', 'CE'),
    'A514': ('AVETRANA', 'TA'),
    'A515': ('AVEZZANO', 'AQ'),
    'A516': ('AVIANO', 'PN'),
    'A517': ('AVIATICO', 'BG'),
    'A518': ('AVIGLIANA', 'TO'),
    'A519': ('AVIGLIANO', 'PZ'),
    'A520': ('AVIO', 'TN'),
    'A521': ('AVISE', 'AO'),
    'A522': ('AVOLA', 'SR'),
    'A523': ('AVOLASCA', 'AL'),
    'A525': ('AZEGLIO', 'TO'),
    'A526': ('AZZANELLO', 'CR'),
    'A527': ("AZZANO D'ASTI", 'AT'),
    'A528': ('AZZANO SAN PAOLO', 'BG'),
    'A529': ('AZZANO MELLA', 'BS'),
    'A530': ('AZZANO DECIMO', 'PN'),
    'A531': ('AZZATE', 'VA'),
    'A532': ('AZZIO', 'VA'),
    'A533': ('AZZONE', 'BG'),
    'A534': ('BACENO', 'VB'),
    'A535': ('BACOLI', 'NA'),
    'A536': ('BADALUCCO', 'IM'),
    'A537': ('BADIA/ABTEI', 'BZ'),
    'A538': ('BADIA PAVESE', 'PV'),
    'A539': ('BADIA POLESINE', 'RO'),
    'A540': ('BADIA CALAVENA', 'VR'),
    'A541': ('BADIA TEDALDA', 'AR'),
    'A542': ('BADOLATO', 'CZ'),
    'A544': ('BAGALADI', 'RC'),
    'A546': ('BAGHERIA', 'PA'),
    'A547': ('BAGNACAVALLO', 'RA'),
    'A550': ('BAGNARIA', 'PV'),
    'A551': ('BAGNARA DI ROMAGNA', 'RA'),
    'A552': ('BAGNARA CALABRA', 'RC'),
    'A553': ('BAGNARIA ARSA', 'UD'),
    'A555': ('BAGNASCO', 'CN'),
    'A557': ('BAGNATICA', 'BG'),
    'A560': ('BAGNI DI LUCCA', 'LU'),
    'A561': ('MONTECATINI-TERME', 'PT'),
    'A562': ('SAN GIULIANO TERME', 'PI'),
    'A564': ('BAGNO A RIPOLI', 'FI'),
    'A565': ('BAGNO DI ROMAGNA', 'FC'),
    'A566': ('BAGNOLI IRPINO', 'AV'),
    'A567': ('BAGNOLI DEL TRIGNO', 'IS'),
    'A568': ('BAGNOLI DI SOPRA', 'PD'),
    'A569': ('BAGNOLO MELLA', 'BS'),
    'A570': ('BAGNOLO CREMASCO', 'CR'),
    'A571': ('BAGNOLO PIEMONTE', 'CN'),
    'A572': ('BAGNOLO DEL SALENTO', 'LE'),
    'A573': ('BAGNOLO IN PIANO', 'RE'),
    'A574': ('BAGNOLO DI PO', 'RO'),
    'A575': ('BAGNOLO SAN VITO', 'MN'),
    'A576': ('BAGNONE', 'MS'),
    'A577': ('BAGNOREGIO', 'VT'),
    'A578': ('BAGOLINO', 'BS'),
    'A579': ('BAIA E LATINA', 'CE'),
    'A580': ('BAIANO', 'AV'),
    'A581': ('BAJARDO', 'IM'),
    'A584': ('BAIRO', 'TO'),
    'A586': ('BAISO', 'RE'),
    'A587': ('BALANGERO', 'TO'),
    'A588': ("BALDICHIERI D'ASTI", 'AT'),
    'A589': ("BALDISSERO D'ALBA", 'CN'),
    'A590': ('BALDISSERO CANAVESE', 'TO'),
    'A591': ('BALDISSERO TORINESE', 'TO'),
    'A592': ('BALESTRATE', 'PA'),
    'A593': ('BALESTRINO', 'SV'),
    'A594': ('BALLABIO', 'LC'),
    'A597': ('BALLAO', 'SU'),
    'A599': ('BALME', 'TO'),
    'A600': ('BALMUCCIA', 'VC'),
    'A601': ('BALOCCO', 'VC'),
    'A603': ('BALSORANO', 'AQ'),
    'A604': ('BALVANO', 'PZ'),
    'A605': ('BALZOLA', 'AL'),
    'A606': ('BANARI', 'SS'),
    'A607': ('BANCHETTE', 'TO'),
    'A609': ('VILLA VERDE', 'OR'),
    'A610': ('BANNIO ANZINO', 'VB'),
    'A612': ('BANZI', 'PZ'),
    'A613': ('BAONE', 'PD'),
    'A614': ('BARADILI', 'OR'),
    'A615': ('BARAGIANO', 'PZ'),
    'A616': ('BARANELLO', 'CB'),
    'A617': ("BARANO D'ISCHIA", 'NA'),
    'A618': ('BARANZATE', 'MI'),
    'A619': ('BARASSO', 'VA'),
    'A621': ('BARATILI SAN PIETRO', 'OR'),
    'A625': ('BARBANIA', 'TO'),
    'A626': ('BARBARA', 'AN'),
    'A628': ('BARBARANO ROMANO', 'VT'),
    'A629': ('BARBARESCO', 'CN'),
    'A630': ('BARBARIGA', 'BS'),
    'A631': ('BARBATA', 'BG'),
    'A632': ('BARBERINO DI MUGELLO', 'FI'),
    'A634': ('BARBIANELLO', 'PV'),
    'A635': ('BARBIANO/BARBIAN', 'BZ'),
    'A637': ('BARBONA', 'PD'),
    'A638': ('BARCELLONA POZZO DI GOTTO', 'ME'),
    'A640': ('BARCIS', 'PN'),
    'A643': ('BARD', 'AO'),
    'A645': ('BARDELLO', 'VA'),
    'A646': ('BARDI', 'PR'),
    'A647': ('BARDINETO', 'SV'),
    'A650': ('BARDOLINO', 'VR'),
    'A651': ('BARDONECCHIA', 'TO'),
    'A652': ('BAREGGIO', 'MI'),
    'A653': ('BARENGO', 'NO'),
    'A655': ('BARESSA', 'OR'),
    'A656': ('BARETE', 'AQ'),
    'A657': ('BARGA', 'LU'),
    'A658': ('BARGAGLI', 'GE'),
    'A660': ('BARGE', 'CN'),
    'A661': ('BARGHE', 'BS'),
    'A662': ('BARI', 'BA'),
    'A663': ('BARI SARDO', 'NU'),
    'A664': ('BARIANO', 'BG'),
    'A665': ('BARICELLA', 'BO'),
    'A666': ('BARILE', 'PZ'),
    'A667': ('BARISCIANO', 'AQ'),
    'A668': ('BARLASSINA', 'MB'),
    'A669': ('BARLETTA', 'BT'),
    'A670': ('BARNI', 'CO'),
    'A671': ('BAROLO', 'CN'),
    'A673': ('BARONE CANAVESE', 'TO'),
    'A674': ('BARONISSI', 'SA'),
    'A676': ('BARRAFRANCA', 'EN'),
    'A677': ('BARRALI', 'SU'),
    'A678': ('BARREA', 'AQ'),
    'A681': ('BARUMINI', 'SU'),
    'A683': ('BARZAGO', 'LC'),
    'A684': ('BARZANA', 'BG'),
    'A686': ('BARZANÒ', 'LC'),
    'A687': ('BARZIO', 'LC'),
    'A689': ('BASALUZZO', 'AL'),
    'A690': ('BASCAPÈ', 'PV'),
    'A691': ('BASCHI', 'TR'),
    'A692': ('BASCIANO', 'TE'),
    'A694': ('BASELGA DI PINÈ', 'TN'),
    'A696': ('BASELICE', 'BN'),
    'A697': ('BASIANO', 'MI'),
    'A698': ('BASICÒ', 'ME'),
    'A699': ('BASIGLIO', 'MI'),
    'A700': ('BASILIANO', 'UD'),
    'A701': ('VASANELLO', 'VT'),
    'A702': ('BASSANO BRESCIANO', 'BS'),
    'A703': ('BASSANO DEL GRAPPA', 'VI'),
    'A704': ('BASSANO ROMANO', 'VT'),
    'A705': ('TRONZANO LAGO MAGGIORE', 'VA'),
    'A706': ('BASSANO IN TEVERINA', 'VT'),
    'A707': ('BASSIANO', 'LT'),
    'A708': ('BASSIGNANA', 'AL'),
    'A709': ('BASTIA MONDOVÌ', 'CN'),
    'A710': ('BASTIA UMBRA', 'PG'),
    'A712': ('BASTIDA PANCARANA', 'PV'),
    'A713': ('BASTIGLIA', 'MO'),
    'A714': ('BATTAGLIA TERME', 'PD'),
    'A716': ('BATTIFOLLO', 'CN'),
    'A717': ('BATTIPAGLIA', 'SA'),
    'A718': ('BATTUDA', 'PV'),
    'A719': ('BAUCINA', 'PA'),
    'A720': ('BOVILLE ERNICA', 'FR'),
    'A721': ('BAULADU', 'OR'),
    'A722': ('BAUNEI', 'NU'),
    'A725': ('BAVENO', 'VB'),
    'A728': ('BEDERO VALCUVIA', 'VA'),
    'A729': ('BEDIZZOLE', 'BS'),
    'A730': ('BEDOLLO', 'TN'),
    'A731': ('BEDONIA', 'PR'),
    'A732': ('BEDULITA', 'BG'),
    'A733': ('BEE', 'VB'),
    'A734': ('BEINASCO', 'TO'),
    'A735': ('BEINETTE', 'CN'),
    'A736': ('BELCASTRO', 'CZ'),
    'A737': ('BELFIORE', 'VR'),
    'A738': ('BELFORTE MONFERRATO', 'AL'),
    'A739': ('BELFORTE DEL CHIENTI', 'MC'),
    'A740': ("BELFORTE ALL'ISAURO", 'PU'),
    'A741': ('BELGIOIOSO', 'PV'),
    'A742': ('BELGIRATE', 'VB'),
    'A743': ('BELLA', 'PZ'),
    'A745': ('BELLANO', 'LC'),
    'A746': ('BELLANTE', 'TE'),
    'A747': ('BELLARIA-IGEA MARINA', 'RN'),
    'A749': ('BELLEGRA', 'RM'),
    'A750': ('BELLINO', 'CN'),
    'A751': ('BELLINZAGO LOMBARDO', 'MI'),
    'A752': ('BELLINZAGO NOVARESE', 'NO'),
    'A755': ('BELLONA', 'CE'),
    'A756': ('BELLOSGUARDO', 'SA'),
    'A757': ('BELLUNO', 'BL'),
    'A759': ('BELLUSCO', 'MB'),
    'A760': ('BELMONTE PICENO', 'FM'),
    'A761': ('BELMONTE DEL SANNIO', 'IS'),
    'A762': ('BELMONTE CALABRO', 'CS'),
    'A763': ('BELMONTE CASTELLO', 'FR'),
    'A764': ('BELMONTE MEZZAGNO', 'PA'),
    'A765': ('BELMONTE IN SABINA', 'RI'),
    'A766': ('BELPASSO', 'CT'),
    'A768': ('BELSITO', 'CS'),
    'A769': ('BELVEDERE OSTRENSE', 'AN'),
    'A770': ('BELVEGLIO', 'AT'),
    'A771': ('LIZZANO IN BELVEDERE', 'BO'),
    'A772': ('BELVEDERE DI SPINELLO', 'KR'),
    'A773': ('BELVEDERE MARITTIMO', 'CS'),
    'A774': ('BELVEDERE LANGHE', 'CN'),
    'A776': ('BELVÌ', 'NU'),
    'A777': ('BEMA', 'SO'),
    'A778': ('BENE LARIO', 'CO'),
    'A779': ('BENE VAGIENNA', 'CN'),
    'A780': ('BENESTARE', 'RC'),
    'A781': ('BENETUTTI', 'SS'),
    'A782': ('BENEVELLO', 'CN'),
    'A783': ('BENEVENTO', 'BN'),
    'A784': ('BENNA', 'BI'),
    'A785': ('BENTIVOGLIO', 'BO'),
    'A786': ('BERBENNO', 'BG'),
    'A787': ('BERBENNO DI VALTELLINA', 'SO'),
    'A788': ('BERCETO', 'PR'),
    'A789': ('BERCHIDDA', 'SS'),
    'A791': ('BEREGAZZO CON FIGLIARO', 'CO'),
    'A792': ('BEREGUARDO', 'PV'),
    'A793': ('BERGAMASCO', 'AL'),
    'A794': ('BERGAMO', 'BG'),
    'A795': ('BERGANTINO', 'RO'),
    'A796': ('BERGEGGI', 'SV'),
    'A798': ('BERGOLO', 'CN'),
    'A799': ('BERLINGO', 'BS'),
    'A801': ('BERNALDA', 'MT'),
    'A802': ('BERNAREGGIO', 'MB'),
    'A804': ('BERNATE TICINO', 'MI'),
    'A805': ('BERNEZZO', 'CN'),
    'A809': ('BERTINORO', 'FC'),
    'A810': ('BERTIOLO', 'UD'),
    'A811': ('BERTONICO', 'LO'),
    'A812': ('BERZANO DI SAN PIETRO', 'AT'),
    'A813': ('BERZANO DI TORTONA', 'AL'),
    'A815': ('BERZO SAN FERMO', 'BG'),
    'A816': ('BERZO DEMO', 'BS'),
    'A817': ('BERZO INFERIORE', 'BS'),
    'A818': ('BESANA IN BRIANZA', 'MB'),
    'A819': ('BESANO', 'VA'),
    'A820': ('BESATE', 'MI'),
    'A821': ('BESENELLO', 'TN'),
    'A823': ('BESENZONE', 'PC'),
    'A825': ('BESNATE', 'VA'),
    'A826': ('BESOZZO', 'VA'),
    'A827': ('BESSUDE', 'SS'),
    'A831': ('BETTOLA', 'PC'),
    'A832': ('BETTONA', 'PG'),
    'A834': ('BEURA-CARDEZZA', 'VB'),
    'A835': ('BEVAGNA', 'PG'),
    'A836': ('BEVERINO', 'SP'),
    'A837': ('BEVILACQUA', 'VR'),
    'A841': ('BIANCAVILLA', 'CT'),
    'A842': ('BIANCHI', 'CS'),
    'A843': ('BIANCO', 'RC'),
    'A844': ('BIANDRATE', 'NO'),
    'A845': ('BIANDRONNO', 'VA'),
    'A846': ('BIANZANO', 'BG'),
    'A847': ('BIANZÈ', 'VC'),
    'A848': ('BIANZONE', 'SO'),
    'A849': ('BIASSONO', 'MB'),
    'A850': ('BIBBIANO', 'RE'),
    'A851': ('BIBBIENA', 'AR'),
    'A852': ('BIBBONA', 'LI'),
    'A853': ('BIBIANA', 'TO'),
    'A854': ('BICCARI', 'FG'),
    'A855': ('BICINICCO', 'UD'),
    'A856': ('BIDONÌ', 'OR'),
    'A857': ('BLERA', 'VT'),
    'A859': ('BIELLA', 'BI'),
    'A861': ('BIENNO', 'BS'),
    'A863': ('BIENO', 'TN'),
    'A864': ('BIENTINA', 'PI'),
    'A870': ('BINAGO', 'CO'),
    'A872': ('BINASCO', 'MI'),
    'A874': ('BINETTO', 'BA'),
    'A876': ('BIOGLIO', 'BI'),
    'A877': ('BIONAZ', 'AO'),
    'A878': ('BIONE', 'BS'),
    'A880': ('BIRORI', 'NU'),
    'A881': ('BISACCIA', 'AV'),
    'A882': ('BISACQUINO', 'PA'),
    'A883': ('BISCEGLIE', 'BT'),
    'A884': ('BISEGNA', 'AQ'),
    'A885': ('BISENTI', 'TE'),
    'A887': ('BISIGNANO', 'CS'),
    'A889': ('BISTAGNO', 'AL'),
    'A891': ('BISUSCHIO', 'VA'),
    'A892': ('BITETTO', 'BA'),
    'A893': ('BITONTO', 'BA'),
    'A894': ('BITRITTO', 'BA'),
    'A895': ('BITTI', 'NU'),
    'A896': ('BIVONA', 'AG'),
    'A897': ('BIVONGI', 'RC'),
    'A898': ('BIZZARONE', 'CO'),
    'A902': ('BLEGGIO SUPERIORE', 'TN'),
    'A903': ('BLELLO', 'BG'),
    'A904': ('BLESSAGNO', 'CO'),
    'A905': ('BLEVIO', 'CO'),
    'A906': ('BOARA PISANI', 'PD'),
    'A909': ('BOBBIO', 'PC'),
    'A910': ('BOBBIO PELLICE', 'TO'),
    'A911': ('BOCA', 'NO'),
    'A912': ('BOCCHIGLIERO', 'CS'),
    'A914': ('BOCCIOLETO', 'VC'),
    'A916': ('BOCENAGO', 'TN'),
    'A918': ('BODIO LOMNAGO', 'VA'),
    'A919': ("BOFFALORA D'ADDA", 'LO'),
    'A920': ('BOFFALORA SOPRA TICINO', 'MI'),
    'A922': ('BOGLIASCO', 'GE'),
    'A925': ('BOGNANCO', 'VB'),
    'A929': ('BOGOGNO', 'NO'),
    'A930': ('BOJANO', 'CB'),
    'A931': ('BOISSANO', 'SV'),
    'A932': ('BOLANO', 'SP'),
    'A937': ('BOLGARE', 'BG'),
    'A940': ('BOLLATE', 'MI'),
    'A941': ('BOLLENGO', 'TO'),
    'A942': ('NOVA SIRI', 'MT'),
    'A944': ('BOLOGNA', 'BO'),
    'A945': ('BOLOGNANO', 'PE'),
    'A946': ('BOLOGNETTA', 'PA'),
    'A947': ('BOLOGNOLA', 'MC'),
    'A948': ('BOLOTANA', 'NU'),
    'A949': ('BOLSENA', 'VT'),
    'A950': ('BOLTIERE', 'BG'),
    'A952': ('BOLZANO/BOZEN', 'BZ'),
    'A953': ('BOLZANO NOVARESE', 'NO'),
    'A954': ('BOLZANO VICENTINO', 'VI'),
    'A955': ('BOMARZO', 'VT'),
    'A956': ('BOMBA', 'CH'),
    'A957': ('BOMPENSIERE', 'CL'),
    'A958': ('BOMPIETRO', 'PA'),
    'A959': ('BOMPORTO', 'MO'),
    'A960': ('BONARCADO', 'OR'),
    'A961': ('BONASSOLA', 'SP'),
    'A962': ('BONATE SOTTO', 'BG'),
    'A963': ('BONATE SOPRA', 'BG'),
    'A964': ('BONAVIGO', 'VR'),
    'A965': ('BONDENO', 'FE'),
    'A968': ('BONDONE', 'TN'),
    'A970': ('BONEA', 'BN'),
    'A971': ('BONEFRO', 'CB'),
    'A972': ('BONEMERSE', 'CR'),
    'A973': ('BONIFATI', 'CS'),
    'A975': ('BONITO', 'AV'),
    'A976': ('BONNANARO', 'SS'),
    'A977': ('BONO', 'SS'),
    'A978': ('BONORVA', 'SS'),
    'A979': ('BONVICINO', 'CN'),
    'A981': ('BORBONA', 'RI'),
    'A982': ('BORCA DI CADORE', 'BL'),
    'A983': ('BORDANO', 'UD'),
    'A984': ('BORDIGHERA', 'IM'),
    'A986': ('BORDOLANO', 'CR'),
    'A987': ('BORE', 'PR'),
    'A988': ('BORETTO', 'RE'),
    'A989': ('BORGARELLO', 'PV'),
    'A990': ('BORGARO TORINESE', 'TO'),
    'A991': ('BORGETTO', 'PA'),
    'A992': ('BORGHETTO DI VARA', 'SP'),
    'A993': ("BORGHETTO D'ARROSCIA", 'IM'),
    'A995': ('BORGHETTO LODIGIANO', 'LO'),
    'A996': ('BORGO VELINO', 'RI'),
    'A998': ('BORGHETTO DI BORBERA', 'AL'),
    'A999': ('BORGHETTO SANTO SPIRITO', 'SV'),
    'B001': ('BORGHI', 'FC'),
    'B002': ('BORGIA', 'CZ'),
    'B003': ('BORGIALLO', 'TO'),
    'B005': ('BORGIO VEREZZI', 'SV'),
    'B006': ('BORGO VALSUGANA', 'TN'),
    'B007': ('BORGO A MOZZANO', 'LU'),
    'B008': ('BORGOROSE', 'RI'),
    'B009': ("BORGO D'ALE", 'VC'),
    'B010': ('BORGO DI TERZO', 'BG'),
    'B012': ('MOTTEGGIANA', 'MN'),
    'B014': ('SUARDI', 'PV'),
    'B015': ("BORGOFRANCO D'IVREA", 'TO'),
    'B016': ('BORGOLAVEZZARO', 'NO'),
    'B017': ('BORGO SAN GIOVANNI', 'LO'),
    'B018': ('BORGOMALE', 'CN'),
    'B019': ('BORGOMANERO', 'NO'),
    'B020': ('BORGOMARO', 'IM'),
    'B021': ('BORGOMASINO', 'TO'),
    'B024': ('BORGONE SUSA', 'TO'),
    'B025': ('BORGONOVO VAL TIDONE', 'PC'),
    'B026': ('BORGO PACE', 'PU'),
    'B028': ('BORGO PRIOLO', 'PV'),
    'B029': ('BORGORATTO ALESSANDRINO', 'AL'),
    'B030': ('BORGORATTO MORMOROLO', 'PV'),
    'B031': ('BORGORICCO', 'PD'),
    'B033': ('BORGO SAN DALMAZZO', 'CN'),
    'B034': ('FIDENZA', 'PR'),
    'B035': ('BORGO SAN GIACOMO', 'BS'),
    'B036': ('BORGO SAN LORENZO', 'FI'),
    'B037': ('BORGO SAN MARTINO', 'AL'),
    'B038': ('BORGO SAN SIRO', 'PV'),
    'B040': ('BORGOSATOLLO', 'BS'),
    'B041': ('BORGOSESIA', 'VC'),
    'B042': ('BORGO VAL DI TARO', 'PR'),
    'B043': ('BORGO TICINO', 'NO'),
    'B044': ('BORGO TOSSIGNANO', 'BO'),
    'B046': ('BORGO VERCELLI', 'VC'),
    'B048': ('BORMIDA', 'SV'),
    'B049': ('BORMIO', 'SO'),
    'B051': ('BORNASCO', 'PV'),
    'B054': ('BORNO', 'BS'),
    'B055': ('BORONEDDU', 'OR'),
    'B056': ('BORORE', 'NU'),
    'B057': ('BORRELLO', 'CH'),
    'B058': ('BORRIANA', 'BI'),
    'B061': ('BORSO DEL GRAPPA', 'TV'),
    'B062': ('BORTIGALI', 'NU'),
    'B063': ('BORTIGIADAS', 'SS'),
    'B064': ('BORUTTA', 'SS'),
    'B067': ('BORZONASCA', 'GE'),
    'B068': ('BOSA', 'OR'),
    'B069': ('BOSARO', 'RO'),
    'B070': ("BOSCHI SANT'ANNA", 'VR'),
    'B071': ('BOSCO MARENGO', 'AL'),
    'B073': ('BOSCO CHIESANUOVA', 'VR'),
    'B075': ('BOSCONERO', 'TO'),
    'B076': ('BOSCOREALE', 'NA'),
    'B077': ('BOSCOTRECASE', 'NA'),
    'B079': ('BOSIA', 'CN'),
    'B080': ('BOSIO', 'AL'),
    'B081': ('BOSISIO PARINI', 'LC'),
    'B082': ('BOSNASCO', 'PV'),
    'B083': ('BOSSICO', 'BG'),
    'B084': ('BOSSOLASCO', 'CN'),
    'B085': ('BOTRICELLO', 'CZ'),
    'B086': ('BOTRUGNO', 'LE'),
    'B088': ('BOTTANUCO', 'BG'),
    'B091': ('BOTTICINO', 'BS'),
    'B094': ('BOTTIDDA', 'SS'),
    'B097': ('BOVA', 'RC'),
    'B098': ('BOVALINO', 'RC'),
    'B099': ('BOVA MARINA', 'RC'),
    'B100': ('BOVEGNO', 'BS'),
    'B101': ('BOVES', 'CN'),
    'B102': ('BOVEZZO', 'BS'),
    'B104': ('BOVINO', 'FG'),
    'B105': ('BOVISIO-MASCIAGO', 'MB'),
    'B106': ('BOVOLENTA', 'PD'),
    'B107': ('BOVOLONE', 'VR'),
    'B109': ('BOZZOLE', 'AL'),
    'B110': ('BOZZOLO', 'MN'),
    'B111': ('BRA', 'CN'),
    'B112': ('BRACCA', 'BG'),
    'B114': ('BRACCIANO', 'RM'),
    'B115': ('BRACIGLIANO', 'SA'),
    'B116': ('BRAIES/PRAGS', 'BZ'),
    'B117': ('BRALLO DI PREGOLA', 'PV'),
    'B118': ('BRANCALEONE', 'RC'),
    'B120': ('BRANDICO', 'BS'),
    'B121': ('BRANDIZZO', 'TO'),
    'B123': ('BRANZI', 'BG'),
    'B124': ('BRAONE', 'BS'),
    'B126': ('BREBBIA', 'VA'),
    'B128': ('BREDA DI PIAVE', 'TV'),
    'B129': ('CASTELVERDE', 'CR'),
    'B131': ('BREGANO', 'VA'),
    'B132': ('BREGANZE', 'VI'),
    'B134': ('BREGNANO', 'CO'),
    'B137': ('BREMBATE', 'BG'),
    'B138': ('BREMBATE DI SOPRA', 'BG'),
    'B141': ('BREMBIO', 'LO'),
    'B142': ('BREME', 'PV'),
    'B143': ('BRENDOLA', 'VI'),
    'B144': ('BRENNA', 'CO'),
    'B145': ('BRENNERO/BRENNER', 'BZ'),
    'B149': ('BRENO', 'BS'),
    'B150': ('BRENTA', 'VA'),
    'B152': ('BRENTINO BELLUNO', 'VR'),
    'B153': ('BRENTONICO', 'TN'),
    'B154': ('BRENZONE SUL GARDA', 'VR'),
    'B156': ('BRESCELLO', 'RE'),
    'B157': ('BRESCIA', 'BS'),
    'B158': ('BRESIMO', 'TN'),
    'B159': ('BRESSANA BOTTARONE', 'PV'),
    'B160': ('BRESSANONE/BRIXEN', 'BZ'),
    'B161': ('BRESSANVIDO', 'VI'),
    'B162': ('BRESSO', 'MI'),
    'B166': ('BREZZO DI BEDERO', 'VA'),
    'B167': ('BRIAGLIA', 'CN'),
    'B169': ('BRIATICO', 'VV'),
    'B171': ('BRICHERASIO', 'TO'),
    'B172': ('BRIENNO', 'CO'),
    'B173': ('BRIENZA', 'PZ'),
    'B175': ('BRIGA ALTA', 'CN'),
    'B176': ('BRIGA NOVARESE', 'NO'),
    'B178': ("BRIGNANO GERA D'ADDA", 'BG'),
    'B179': ('BRIGNANO-FRASCATA', 'AL'),
    'B180': ('BRINDISI', 'BR'),
    'B181': ('BRINDISI MONTAGNA', 'PZ'),
    'B182': ('BRINZIO', 'VA'),
    'B183': ('BRIONA', 'NO'),
    'B184': ('BRIONE', 'BS'),
    'B187': ('BRIOSCO', 'MB'),
    'B188': ('BRISIGHELLA', 'RA'),
    'B191': ('BRISSAGO-VALTRAVAGLIA', 'VA'),
    'B192': ('BRISSOGNE', 'AO'),
    'B193': ('BRITTOLI', 'PE'),
    'B194': ('BRIVIO', 'LC'),
    'B195': ('BROCCOSTELLA', 'FR'),
    'B196': ('BROGLIANO', 'VI'),
    'B197': ('BROGNATURO', 'VV'),
    'B198': ('BROLO', 'ME'),
    'B200': ('BRONDELLO', 'CN'),
    'B201': ('BRONI', 'PV'),
    'B202': ('BRONTE', 'CT'),
    'B203': ('BRONZOLO/BRANZOLL', 'BZ'),
    'B204': ('BROSSASCO', 'CN'),
    'B205': ('BROSSO', 'TO'),
    'B207': ('BROVELLO-CARPUGNINO', 'VB'),
    'B209': ('BROZOLO', 'TO'),
    'B212': ('BRUGHERIO', 'MB'),
    'B213': ('BRUGINE', 'PD'),
    'B214': ('BRUGNATO', 'SP'),
    'B215': ('BRUGNERA', 'PN'),
    'B216': ('BRUINO', 'TO'),
    'B217': ('BRUMANO', 'BG'),
    'B218': ('BRUNATE', 'CO'),
    'B219': ('BRUNELLO', 'VA'),
    'B220': ('BRUNICO/BRUNECK', 'BZ'),
    'B221': ('BRUNO', 'AT'),
    'B223': ('BRUSAPORTO', 'BG'),
    'B225': ('BRUSASCO', 'TO'),
    'B227': ('BRUSCIANO', 'NA'),
    'B228': ('BRUSIMPIANO', 'VA'),
    'B229': ('BRUSNENGO', 'BI'),
    'B230': ('BRUSSON', 'AO'),
    'B232': ('BRUZOLO', 'TO'),
    'B234': ('BRUZZANO ZEFFIRIO', 'RC'),
    'B235': ('BUBBIANO', 'MI'),
    'B236': ('BUBBIO', 'AT'),
    'B237': ('BUCCHERI', 'SR'),
    'B238': ('BUCCHIANICO', 'CH'),
    'B239': ('BUCCIANO', 'BN'),
    'B240': ('BUCCINASCO', 'MI'),
    'B242': ('BUCCINO', 'SA'),
    'B243': ('BUCINE', 'AR'),
    'B246': ('BUDDUSÒ', 'SS'),
    'B247': ('BUDOIA', 'PN'),
    'B248': ('BUDONI', 'SS'),
    'B249': ('BUDRIO', 'BO'),
    'B250': ('BUGGERRU', 'SU'),
    'B251': ('BUGGIANO', 'PT'),
    'B255': ('BUGLIO IN MONTE', 'SO'),
    'B256': ('BUGNARA', 'AQ'),
    'B258': ('BUGUGGIATE', 'VA'),
    'B259': ('BUJA', 'UD'),
    'B261': ('BULCIAGO', 'LC'),
    'B262': ('BULGAROGRASSO', 'CO'),
    'B264': ('BULTEI', 'SS'),
    'B265': ('BULZI', 'SS'),
    'B266': ('BUONABITACOLO', 'SA'),
    'B267': ('BUONALBERGO', 'BN'),
    'B268': ('MONTEBELLO SUL SANGRO', 'CH'),
    'B269': ('BUONCONVENTO', 'SI'),
    'B270': ('BUONVICINO', 'CS'),
    'B272': ('BURAGO DI MOLGORA', 'MB'),
    'B274': ('BURCEI', 'SU'),
    'B275': ('BURGIO', 'AG'),
    'B276': ('BURGOS', 'SS'),
    'B278': ('BURIASCO', 'TO'),
    'B279': ('BUROLO', 'TO'),
    'B280': ('BURONZO', 'VC'),
    'B281': ('BUSACHI', 'OR'),
    'B282': ('BUSALLA', 'GE'),
    'B284': ('BUSANO', 'TO'),
    'B285': ('BUSCA', 'CN'),
    'B286': ('BUSCATE', 'MI'),
    'B287': ('BUSCEMI', 'SR'),
    'B288': ('BUSETO PALIZZOLO', 'TP'),
    'B289': ('BUSNAGO', 'MB'),
    'B292': ('BUSSERO', 'MI'),
    'B293': ('BUSSETO', 'PR'),
    'B294': ('BUSSI SUL TIRINO', 'PE'),
    'B295': ('BUSSO', 'CB'),
    'B296': ('BUSSOLENGO', 'VR'),
    'B297': ('BUSSOLENO', 'TO'),
    'B300': ('BUSTO ARSIZIO', 'VA'),
    'B301': ('BUSTO GAROLFO', 'MI'),
    'B302': ('BUTERA', 'CL'),
    'B303': ('BUTI', 'PI'),
    'B304': ('BUTTAPIETRA', 'VR'),
    'B305': ('BUTTIGLIERA ALTA', 'TO'),
    'B306': ("BUTTIGLIERA D'ASTI", 'AT'),
    'B309': ('BUTTRIO', 'UD'),
    'B310': ("SAN PAOLO D'ARGON", 'BG'),
    'B311': ('CABELLA LIGURE', 'AL'),
    'B312': ('CASTELLO CABIAGLIO', 'VA'),
    'B313': ('CABIATE', 'CO'),
    'B314': ('CABRAS', 'OR'),
    'B315': ('CACCAMO', 'PA'),
    'B317': ('POGGIO SANNITA', 'IS'),
    'B319': ('CACCURI', 'KR'),
    'B326': ('CADEGLIANO-VICONAGO', 'VA'),
    'B328': ('CADELBOSCO DI SOPRA', 'RE'),
    'B332': ('CADEO', 'PC'),
    'B335': ('CADERZONE TERME', 'TN'),
    'B345': ('CADONEGHE', 'PD'),
    'B346': ('CADORAGO', 'CO'),
    'B349': ('CAERANO DI SAN MARCO', 'TV'),
    'B350': ('CAFASSE', 'TO'),
    'B351': ('CAGGIANO', 'SA'),
    'B352': ('CAGLI', 'PU'),
    'B354': ('CAGLIARI', 'CA'),
    'B355': ('CAGLIO', 'CO'),
    'B357': ('CAGNANO VARANO', 'FG'),
    'B358': ('CAGNANO AMITERNO', 'AQ'),
    'B361': ('CAIANELLO', 'CE'),
    'B362': ('CAIAZZO', 'CE'),
    'B364': ('CAINES/KUENS', 'BZ'),
    'B365': ('CAINO', 'BS'),
    'B366': ('CAIOLO', 'SO'),
    'B367': ('CAIRANO', 'AV'),
    'B368': ('CAIRATE', 'VA'),
    'B369': ('CAIRO MONTENOTTE', 'SV'),
    'B371': ('CAIVANO', 'NA'),
    'B374': ('CALABRITTO', 'AV'),
    'B375': ('CALALZO DI CADORE', 'BL'),
    'B376': ('CALAMANDRANA', 'AT'),
    'B377': ('CALAMONACI', 'AG'),
    'B378': ('CALANGIANUS', 'SS'),
    'B379': ('CALANNA', 'RC'),
    'B380': ('CALASCA-CASTIGLIONE', 'VB'),
    'B381': ('CALASCIBETTA', 'EN'),
    'B382': ('CALASCIO', 'AQ'),
    'B383': ('CALASETTA', 'SU'),
    'B384': ('CALATABIANO', 'CT'),
    'B385': ('CALATAFIMI-SEGESTA', 'TP'),
    'B387': ('LUNGAVILLA', 'PV'),
    'B388': ('CALCATA', 'VT'),
    'B389': ('CALCERANICA AL LAGO', 'TN'),
    'B390': ('CALCI', 'PI'),
    'B391': ('CALCIANO', 'MT'),
    'B392': ('CALCINAIA', 'PI'),
    'B393': ('CALCINATE', 'BG'),
    'B394': ('CALCINATO', 'BS'),
    'B395': ('CALCIO', 'BG'),
    'B396': ('CALCO', 'LC'),
    'B397': ('CALDARO SULLA STRADA DEL VINO/KALTERN AN DER WEINSTRASSE', 'BZ'),
    'B398': ('CALDAROLA', 'MC'),
    'B399': ('CALDERARA DI RENO', 'BO'),
    'B400': ('CALDES', 'TN'),
    'B402': ('CALDIERO', 'VR'),
    'B403': ('CALDOGNO', 'VI'),
    'B404': ('CALDONAZZO', 'TN'),
    'B405': ('CALENDASCO', 'PC'),
    'B406': ('CALENZANO', 'FI'),
    'B408': ('CALESTANO', 'PR'),
    'B409': ('CALICE LIGURE', 'SV'),
    'B410': ('CALICE AL CORNOVIGLIO', 'SP'),
    'B413': ('CALIMERA', 'LE'),
    'B415': ('CALITRI', 'AV'),
    'B416': ('CALIZZANO', 'SV'),
    'B417': ('CALLABIANA', 'BI'),
    'B418': ('CALLIANO', 'AT'),
    'B419': ('CALLIANO', 'TN'),
    'B423': ('CALOLZIOCORTE', 'LC'),
    'B424': ('CALOPEZZATI', 'CS'),
    'B425': ('CALOSSO', 'AT'),
    'B426': ('CALOVETO', 'CS'),
    'B427': ('CALTABELLOTTA', 'AG'),
    'B428': ('CALTAGIRONE', 'CT'),
    'B429': ('CALTANISSETTA', 'CL'),
    'B430': ('CALTAVUTURO', 'PA'),
    'B431': ('CALTIGNAGA', 'NO'),
    'B432': ('CALTO', 'RO'),
    'B433': ('CALTRANO', 'VI'),
    'B434': ("CALUSCO D'ADDA", 'BG'),
    'B435': ('CALUSO', 'TO'),
    'B436': ('CALVAGESE DELLA RIVIERA', 'BS'),
    'B437': ('CALVANICO', 'SA'),
    'B439': ('CALVATONE', 'CR'),
    'B440': ('CALVELLO', 'PZ'),
    'B441': ('CALVENE', 'VI'),
    'B442': ('CALVENZANO', 'BG'),
    'B443': ('CALVERA', 'PZ'),
    'B444': ('CALVI', 'BN'),
    'B445': ('CALVI RISORTA', 'CE'),
    'B446': ("CALVI DELL'UMBRIA", 'TR'),
    'B447': ('CALVIGNANO', 'PV'),
    'B448': ('CALVIGNASCO', 'MI'),
    'B450': ('CALVISANO', 'BS'),
    'B452': ('CALVIZZANO', 'NA'),
    'B453': ('CAMAGNA MONFERRATO', 'AL'),
    'B455': ('CAMAIORE', 'LU'),
    'B457': ('CAMANDONA', 'BI'),
    'B460': ('CAMASTRA', 'AG'),
    'B461': ('CAMBIAGO', 'MI'),
    'B462': ('CAMBIANO', 'TO'),
    'B463': ('CAMBIASCA', 'VB'),
    'B465': ('CAMBURZANO', 'BI'),
    'B466': ("SANT'ELENA SANNITA", 'IS'),
    'B467': ('CAMERANA', 'CN'),
    'B468': ('CAMERANO', 'AN'),
    'B469': ('CAMERANO CASASCO', 'AT'),
    'B470': ('CAMERATA PICENA', 'AN'),
    'B471': ('CAMERATA CORNELLO', 'BG'),
    'B472': ('CAMERATA NUOVA', 'RM'),
    'B473': ('CAMERI', 'NO'),
    'B474': ('CAMERINO', 'MC'),
    'B476': ('CAMEROTA', 'SA'),
    'B477': ('CAMIGLIANO', 'CE'),
    'B481': ('CAMINI', 'RC'),
    'B482': ('CAMINO', 'AL'),
    'B483': ('CAMINO AL TAGLIAMENTO', 'UD'),
    'B484': ('CAMISANO', 'CR'),
    'B485': ('CAMISANO VICENTINO', 'VI'),
    'B486': ('CAMMARATA', 'AG'),
    'B490': ('CAMOGLI', 'GE'),
    'B491': ('CHAMOIS', 'AO'),
    'B492': ('CAMPAGNA', 'SA'),
    'B493': ('CAMPAGNA LUPIA', 'VE'),
    'B494': ('CASTEL CAMPAGNANO', 'CE'),
    'B496': ('CAMPAGNANO DI ROMA', 'RM'),
    'B497': ('CAMPAGNATICO', 'GR'),
    'B498': ('CAMPAGNOLA CREMASCA', 'CR'),
    'B499': ('CAMPAGNOLA EMILIA', 'RE'),
    'B500': ('CAMPANA', 'CS'),
    'B501': ('CAMPARADA', 'MB'),
    'B502': ('CAMPEGINE', 'RE'),
    'B504': ('CAMPELLO SUL CLITUNNO', 'PG'),
    'B505': ('CAMPERTOGNO', 'VC'),
    'B506': ('CAMPI SALENTINA', 'LE'),
    'B507': ('CAMPI BISENZIO', 'FI'),
    'B509': ('CAMPIGLIA MARITTIMA', 'LI'),
    'B510': ('VALPRATO SOANA', 'TO'),
    'B511': ('CAMPIGLIA DEI BERICI', 'VI'),
    'B512': ('CAMPIGLIONE FENILE', 'TO'),
    'B513': ("CAMPIONE D'ITALIA", 'CO'),
    'B514': ('CAMPITELLO DI FASSA', 'TN'),
    'B515': ('CAMPLI', 'TE'),
    'B516': ('CAMPO CALABRO', 'RC'),
    'B519': ('CAMPOBASSO', 'CB'),
    'B520': ('CAMPOBELLO DI LICATA', 'AG'),
    'B521': ('CAMPOBELLO DI MAZARA', 'TP'),
    'B522': ('CAMPOCHIARO', 'CB'),
    'B524': ('CAMPODARSEGO', 'PD'),
    'B525': ('CAMPODENNO', 'TN'),
    'B526': ('CAMPO DI GIOVE', 'AQ'),
    'B527': ('CAMPODIMELE', 'LT'),
    'B528': ('CAMPODIPIETRA', 'CB'),
    'B529': ('CAMPO DI TRENS/FREIENFELD', 'BZ'),
    'B530': ('CAMPODOLCINO', 'SO'),
    'B531': ('CAMPODORO', 'PD'),
    'B532': ('CAMPOFELICE DI ROCCELLA', 'PA'),
    'B533': ('CAMPOFELICE DI FITALIA', 'PA'),
    'B534': ('CAMPOFILONE', 'FM'),
    'B535': ('CAMPOFIORITO', 'PA'),
    'B536': ('CAMPOFORMIDO', 'UD'),
    'B537': ('CAMPOFRANCO', 'CL'),
    'B538': ('CAMPO LIGURE', 'GE'),
    'B539': ('CAMPOGALLIANO', 'MO'),
    'B540': ('CHAMPORCHER', 'AO'),
    'B541': ('CAMPOLATTARO', 'BN'),
    'B542': ('CAMPOLI DEL MONTE TABURNO', 'BN'),
    'B543': ('CAMPOLI APPENNINO', 'FR'),
    'B544': ('CAMPOLIETO', 'CB'),
    'B546': ('CAMPOLONGO MAGGIORE', 'VE'),
    'B549': ('CAMPOMAGGIORE', 'PZ'),
    'B550': ('CAMPOMARINO', 'CB'),
    'B551': ('CAMPOMORONE', 'GE'),
    'B553': ("CAMPO NELL'ELBA", 'LI'),
    'B554': ('CAMPONOGARA', 'VE'),
    'B555': ('CAMPORA', 'SA'),
    'B556': ('CAMPOREALE', 'PA'),
    'B557': ('CAMPORGIANO', 'LU'),
    'B559': ('CAMPOROSSO', 'IM'),
    'B561': ('CAMPOROTONDO ETNEO', 'CT'),
    'B562': ('CAMPOROTONDO DI FIASTRONE', 'MC'),
    'B563': ('CAMPOSAMPIERO', 'PD'),
    'B564': ('CAMPO SAN MARTINO', 'PD'),
    'B565': ('CAMPOSANO', 'NA'),
    'B566': ('CAMPOSANTO', 'MO'),
    'B567': ('CAMPOSPINOSO', 'PV'),
    'B569': ('CAMPOTOSTO', 'AQ'),
    'B570': ('CAMPO TURES/SAND IN TAUFERS', 'BZ'),
    'B572': ('CAMUGNANO', 'BO'),
    'B573': ('CANALE', 'CN'),
    'B574': ("CANALE D'AGORDO", 'BL'),
    'B576': ('CANALE MONTERANO', 'RM'),
    'B577': ('CANAL SAN BOVO', 'TN'),
    'B578': ('CANARO', 'RO'),
    'B579': ('CANAZEI', 'TN'),
    'B580': ('CANCELLARA', 'PZ'),
    'B581': ('CANCELLO ED ARNONE', 'CE'),
    'B582': ('CANDA', 'RO'),
    'B584': ('CANDELA', 'FG'),
    'B586': ('CANDELO', 'BI'),
    'B587': ('CANDIA LOMELLINA', 'PV'),
    'B588': ('CANDIA CANAVESE', 'TO'),
    'B589': ('CANDIANA', 'PD'),
    'B590': ('CANDIDA', 'AV'),
    'B591': ('CANDIDONI', 'RC'),
    'B592': ('CANDIOLO', 'TO'),
    'B593': ('CANEGRATE', 'MI'),
    'B594': ('CANELLI', 'AT'),
    'B595': ('ORVINIO', 'RI'),
    'B597': ('CANEPINA', 'VT'),
    'B598': ('CANEVA', 'PN'),
    'B602': ('CANICATTÌ', 'AG'),
    'B603': ('CANICATTINI BAGNI', 'SR'),
    'B604': ('CANINO', 'VT'),
    'B605': ('CANISCHIO', 'TO'),
    'B606': ('CANISTRO', 'AQ'),
    'B607': ('CANNA', 'CS'),
    'B608': ('CANNALONGA', 'SA'),
    'B609': ('CANNARA', 'PG'),
    'B610': ('CANNERO RIVIERA', 'VB'),
    'B612': ("CANNETO SULL'OGLIO", 'MN'),
    'B613': ('CANNETO PAVESE', 'PV'),
    'B615': ('CANNOBIO', 'VB'),
    'B616': ('CANNOLE', 'LE'),
    'B617': ('CANOLO', 'RC'),
    'B618': ("CANONICA D'ADDA", 'BG'),
    'B619': ('CANOSA DI PUGLIA', 'BT'),
    'B620': ('CANOSA SANNITA', 'CH'),
    'B621': ('CANOSIO', 'CN'),
    'B624': ('CANSANO', 'AQ'),
    'B626': ('CANTAGALLO', 'PO'),
    'B627': ('CANTALICE', 'RI'),
    'B628': ('CANTALUPA', 'TO'),
    'B629': ('CANTALUPO LIGURE', 'AL'),
    'B630': ('CANTALUPO NEL SANNIO', 'IS'),
    'B631': ('CANTALUPO IN SABINA', 'RI'),
    'B632': ('MANDELA', 'RM'),
    'B633': ('CANTARANA', 'AT'),
    'B634': ('CANTELLO', 'VA'),
    'B635': ('CANTERANO', 'RM'),
    'B636': ('CANTIANO', 'PU'),
    'B637': ('CANTOIRA', 'TO'),
    'B639': ('CANTÙ', 'CO'),
    'B640': ('CANZANO', 'TE'),
    'B641': ('CANZO', 'CO'),
    'B642': ('CAORLE', 'VE'),
    'B643': ('CAORSO', 'PC'),
    'B644': ('CAPACCIO PAESTUM', 'SA'),
    'B645': ('CAPACI', 'PA'),
    'B646': ('CAPALBIO', 'GR'),
    'B647': ('CAPANNOLI', 'PI'),
    'B648': ('CAPANNORI', 'LU'),
    'B649': ('CAPENA', 'RM'),
    'B650': ('CAPERGNANICA', 'CR'),
    'B651': ('CAPESTRANO', 'AQ'),
    'B653': ('CAPIAGO INTIMIANO', 'CO'),
    'B655': ('CAPISTRANO', 'VV'),
    'B656': ('CAPISTRELLO', 'AQ'),
    'B658': ('CAPITIGNANO', 'AQ'),
    'B660': ('CAPIZZI', 'ME'),
    'B661': ('CAPIZZONE', 'BG'),
    'B662': ('PONTE NELLE ALPI', 'BL'),
    'B663': ('CAPODIMONTE', 'VT'),
    'B664': ('CAPO DI PONTE', 'BS'),
    'B666': ("CAPO D'ORLANDO", 'ME'),
    'B667': ('CAPODRISE', 'CE'),
    'B669': ('CAPOLIVERI', 'LI'),
    'B670': ('CAPOLONA', 'AR'),
    'B671': ('CAPONAGO', 'MB'),
    'B672': ('CAPORCIANO', 'AQ'),
    'B674': ('CAPOSELE', 'AV'),
    'B675': ('CAPOTERRA', 'CA'),
    'B676': ('CAPOVALLE', 'BS'),
    'B677': ('CAPPADOCIA', 'AQ'),
    'B678': ('CAPPELLA MAGGIORE', 'TV'),
    'B679': ('CAPPELLA CANTONE', 'CR'),
    'B680': ("CAPPELLA DE' PICENARDI", 'CR'),
    'B681': ('CAPPELLE SUL TAVO', 'PE'),
    'B682': ('CAPRACOTTA', 'IS'),
    'B684': ('CAPRAIA E LIMITE', 'FI'),
    'B685': ('CAPRAIA ISOLA', 'LI'),
    'B686': ('CAPRALBA', 'CR'),
    'B687': ('CAPRANICA PRENESTINA', 'RM'),
    'B688': ('CAPRANICA', 'VT'),
    'B689': ('MARZABOTTO', 'BO'),
    'B690': ('CAPRARICA DI LECCE', 'LE'),
    'B691': ('CAPRAROLA', 'VT'),
    'B692': ('CAPRAUNA', 'CN'),
    'B693': ('CAPRESE MICHELANGELO', 'AR'),
    'B694': ('CAPREZZO', 'VB'),
    'B695': ('CAPRI LEONE', 'ME'),
    'B696': ('CAPRI', 'NA'),
    'B697': ('CAPRIANA', 'TN'),
    'B698': ('CAPRIANO DEL COLLE', 'BS'),
    'B701': ("CAPRIATA D'ORBA", 'AL'),
    'B703': ('CAPRIATE SAN GERVASIO', 'BG'),
    'B704': ('CAPRIATI A VOLTURNO', 'CE'),
    'B705': ('CAPRIE', 'TO'),
    'B706': ('CAPRIGLIA IRPINA', 'AV'),
    'B707': ('CAPRIGLIO', 'AT'),
    'B708': ('CAPRILE', 'BI'),
    'B709': ('CAPRINO VERONESE', 'VR'),
    'B710': ('CAPRINO BERGAMASCO', 'BG'),
    'B711': ('CAPRIOLO', 'BS'),
    'B712': ('CAPRIVA DEL FRIULI', 'GO'),
    'B715': ('CAPUA', 'CE'),
    'B716': ('CAPURSO', 'BA'),
    'B717': ('CARAFFA DI CATANZARO', 'CZ'),
    'B718': ('CARAFFA DEL BIANCO', 'RC'),
    'B719': ('CARAGLIO', 'CN'),
    'B720': ('CARAMAGNA PIEMONTE', 'CN'),
    'B722': ('CARAMANICO TERME', 'PE'),
    'B724': ('CARAPELLE', 'FG'),
    'B725': ('CARAPELLE CALVISIO', 'AQ'),
    'B726': ('CARASCO', 'GE'),
    'B727': ('CARASSAI', 'AP'),
    'B729': ('CARATE BRIANZA', 'MB'),
    'B730': ('CARATE URIO', 'CO'),
    'B731': ('CARAVAGGIO', 'BG'),
    'B732': ('CARAVATE', 'VA'),
    'B733': ('CARAVINO', 'TO'),
    'B734': ('CARAVONICA', 'IM'),
    'B735': ('CARBOGNANO', 'VT'),
    'B736': ('CARBONARA SCRIVIA', 'AL'),
    'B738': ('VILLASIMIUS', 'SU'),
    'B740': ('CARBONARA DI NOLA', 'NA'),
    'B741': ('CARBONARA AL TICINO', 'PV'),
    'B742': ('CARBONATE', 'CO'),
    'B743': ('CARBONE', 'PZ'),
    'B744': ('CARBONERA', 'TV'),
    'B745': ('CARBONIA', 'SU'),
    'B748': ('CARCARE', 'SV'),
    'B749': ('CARCERI', 'PD'),
    'B752': ('CARCOFORO', 'VC'),
    'B754': ('CARDANO AL CAMPO', 'VA'),
    'B755': ('CARDÈ', 'CN'),
    'B756': ('CARDETO', 'RC'),
    'B758': ('CARDINALE', 'CZ'),
    'B759': ('CARDITO', 'NA'),
    'B760': ('CAREGGINE', 'LU'),
    'B762': ('CAREMA', 'TO'),
    'B763': ('CARENNO', 'LC'),
    'B765': ('CARENTINO', 'AL'),
    'B766': ('CARERI', 'RC'),
    'B767': ('CARESANA', 'VC'),
    'B768': ('CARESANABLOT', 'VC'),
    'B769': ('CAREZZANO', 'AL'),
    'B771': ('CARFIZZI', 'KR'),
    'B772': ('CARGEGHE', 'SS'),
    'B774': ('CARIATI', 'CS'),
    'B776': ('CARIFE', 'AV'),
    'B777': ('CARIGNANO', 'TO'),
    'B778': ('CARIMATE', 'CO'),
    'B779': ('CARINARO', 'CE'),
    'B780': ('CARINI', 'PA'),
    'B781': ('CARINOLA', 'CE'),
    'B782': ('CARISIO', 'VC'),
    'B783': ('CARISOLO', 'TN'),
    'B784': ('CARLANTINO', 'FG'),
    'B785': ('CARLAZZO', 'CO'),
    'B787': ('CARLENTINI', 'SR'),
    'B788': ('CARLINO', 'UD'),
    'B789': ('CARLOFORTE', 'SU'),
    'B790': ('CARLOPOLI', 'CZ'),
    'B791': ('CARMAGNOLA', 'TO'),
    'B792': ('CARMIANO', 'LE'),
    'B794': ('CARMIGNANO', 'PO'),
    'B795': ('CARMIGNANO DI BRENTA', 'PD'),
    'B796': ('CARNAGO', 'VA'),
    'B798': ('CARNATE', 'MB'),
    'B799': ("CORNEDO ALL'ISARCO/KARNEID", 'BZ'),
    'B801': ('CAROBBIO DEGLI ANGELI', 'BG'),
    'B802': ('CAROLEI', 'CS'),
    'B803': ('CARONA', 'BG'),
    'B804': ('CARONIA', 'ME'),
    'B805': ('CARONNO PERTUSELLA', 'VA'),
    'B807': ('CARONNO VARESINO', 'VA'),
    'B808': ('CAROSINO', 'TA'),
    'B809': ('CAROVIGNO', 'BR'),
    'B810': ('CAROVILLI', 'IS'),
    'B812': ('CARPANETO PIACENTINO', 'PC'),
    'B813': ('CARPANZANO', 'CS'),
    'B816': ('CARPEGNA', 'PU'),
    'B817': ('CARPENEDOLO', 'BS'),
    'B818': ('CARPENETO', 'AL'),
    'B819': ('CARPI', 'MO'),
    'B820': ('CARPIANO', 'MI'),
    'B822': ('CARPIGNANO SALENTINO', 'LE'),
    'B823': ('CARPIGNANO SESIA', 'NO'),
    'B824': ('CURA CARPIGNANO', 'PV'),
    'B825': ('CARPINETI', 'RE'),
    'B826': ('CARPINETO SINELLO', 'CH'),
    'B827': ('CARPINETO DELLA NORA', 'PE'),
    'B828': ('CARPINETO ROMANO', 'RM'),
    'B829': ('CARPINO', 'FG'),
    'B830': ('CARPINONE', 'IS'),
    'B832': ('CARRARA', 'MS'),
    'B835': ('CARRÈ', 'VI'),
    'B836': ('CARREGA LIGURE', 'AL'),
    'B838': ('CARRO', 'SP'),
    'B839': ('CARRODANO', 'SP'),
    'B840': ('CARROSIO', 'AL'),
    'B841': ('CARRÙ', 'CN'),
    'B842': ('CARSOLI', 'AQ'),
    'B844': ('CARTIGLIANO', 'VI'),
    'B845': ('CARTIGNANO', 'CN'),
    'B846': ('CARTOCETO', 'PU'),
    'B847': ('CARTOSIO', 'AL'),
    'B848': ('CARTURA', 'PD'),
    'B850': ('CARUGATE', 'MI'),
    'B851': ('CARUGO', 'CO'),
    'B853': ('CARUNCHIO', 'CH'),
    'B854': ('CARVICO', 'BG'),
    'B856': ('CARZANO', 'TN'),
    'B857': ('CASABONA', 'KR'),
    'B858': ('CASACALENDA', 'CB'),
    'B859': ('CASACANDITELLA', 'CH'),
    'B860': ('CASAGIOVE', 'CE'),
    'B861': ('CASALANGUIDA', 'CH'),
    'B862': ('CASALATTICO', 'FR'),
    'B864': ('CASALBELTRAME', 'NO'),
    'B865': ('CASALBORDINO', 'CH'),
    'B866': ('CASALBORE', 'AV'),
    'B867': ('CASALBORGONE', 'TO'),
    'B868': ('CASALBUONO', 'SA'),
    'B869': ('CASALBUTTANO ED UNITI', 'CR'),
    'B870': ('CASAL CERMELLI', 'AL'),
    'B871': ('CASALCIPRANO', 'CB'),
    'B872': ('CASAL DI PRINCIPE', 'CE'),
    'B873': ('CASALDUNI', 'BN'),
    'B875': ('CASALE LITTA', 'VA'),
    'B876': ('CASALE CORTE CERRO', 'VB'),
    'B877': ('CASALE DI SCODOSIA', 'PD'),
    'B878': ('CASALE MARITTIMO', 'PI'),
    'B879': ('CASALE SUL SILE', 'TV'),
    'B880': ('CASALECCHIO DI RENO', 'BO'),
    'B881': ('CASALE CREMASCO-VIDOLASCO', 'CR'),
    'B882': ('CASALEGGIO BOIRO', 'AL'),
    'B883': ('CASALEGGIO NOVARA', 'NO'),
    'B885': ('CASALE MONFERRATO', 'AL'),
    'B886': ('CASALEONE', 'VR'),
    'B887': ('CASALETTO LODIGIANO', 'LO'),
    'B888': ('CASALETTO SPARTANO', 'SA'),
    'B889': ('CASALETTO CEREDANO', 'CR'),
    'B890': ('CASALETTO DI SOPRA', 'CR'),
    'B891': ('CASALETTO VAPRIO', 'CR'),
    'B892': ('CASALFIUMANESE', 'BO'),
    'B893': ('CASALGRANDE', 'RE'),
    'B894': ('CASALGRASSO', 'CN'),
    'B895': ('CASAL VELINO', 'SA'),
    'B896': ('CASALINCONTRADA', 'CH'),
    'B897': ('CASALINO', 'NO'),
    'B898': ('CASALMAGGIORE', 'CR'),
    'B899': ('CASALMAIOCCO', 'LO'),
    'B900': ('CASALMORANO', 'CR'),
    'B901': ('CASALMORO', 'MN'),
    'B902': ('CASALNOCETO', 'AL'),
    'B903': ('VILLAPIANA', 'CS'),
    'B904': ('CASALNUOVO MONTEROTARO', 'FG'),
    'B905': ('CASALNUOVO DI NAPOLI', 'NA'),
    'B906': ('SAN PAOLO ALBANESE', 'PZ'),
    'B907': ('CASALOLDO', 'MN'),
    'B910': ('CASALPUSTERLENGO', 'LO'),
    'B911': ('CASALROMANO', 'MN'),
    'B912': ('CASALSERUGO', 'PD'),
    'B914': ('POZZAGLIO ED UNITI', 'CR'),
    'B915': ('TRINITAPOLI', 'BT'),
    'B916': ('CASALUCE', 'CE'),
    'B917': ('CASALVECCHIO DI PUGLIA', 'FG'),
    'B918': ('CASALVECCHIO SICULO', 'ME'),
    'B919': ('CASALVIERI', 'FR'),
    'B920': ('CASALVOLONE', 'NO'),
    'B921': ('CASALZUIGNO', 'VA'),
    'B922': ('CASAMARCIANO', 'NA'),
    'B923': ('CASAMASSIMA', 'BA'),
    'B924': ('CASAMICCIOLA TERME', 'NA'),
    'B925': ('CASANDRINO', 'NA'),
    'B927': ('CASANOVA LERRONE', 'SV'),
    'B928': ('CASANOVA ELVO', 'VC'),
    'B929': ('CASANOVA LONATI', 'PV'),
    'B932': ('CASAPE', 'RM'),
    'B933': ('CASAPINTA', 'BI'),
    'B934': ('CASAPROTA', 'RI'),
    'B935': ('CASAPULLA', 'CE'),
    'B936': ('CASARANO', 'LE'),
    'B937': ('CASARGO', 'LC'),
    'B938': ('CASARILE', 'MI'),
    'B939': ('CASARZA LIGURE', 'GE'),
    'B940': ('CASARSA DELLA DELIZIA', 'PN'),
    'B941': ('CASASCO', 'AL'),
    'B943': ('CASATENOVO', 'LC'),
    'B945': ('CASATISMA', 'PV'),
    'B946': ('CASAVATORE', 'NA'),
    'B947': ('CASAZZA', 'BG'),
    'B948': ('CASCIA', 'PG'),
    'B949': ('CASCIAGO', 'VA'),
    'B950': ('CASCINA', 'PI'),
    'B952': ('SAN GIACOMO VERCELLESE', 'VC'),
    'B953': ("CASCINETTE D'IVREA", 'TO'),
    'B954': ('CASEI GEROLA', 'PV'),
    'B955': ('CASELETTE', 'TO'),
    'B956': ('CASELLA', 'GE'),
    'B958': ('CASELLE LURANI', 'LO'),
    'B959': ('CASELLE IN PITTARI', 'SA'),
    'B960': ('CASELLE TORINESE', 'TO'),
    'B961': ('CASELLE LANDI', 'LO'),
    'B962': ('SCANDICCI', 'FI'),
    'B963': ('CASERTA', 'CE'),
    'B965': ('CASIER', 'TV'),
    'B966': ('CASIGNANA', 'RC'),
    'B967': ('CASINA', 'RE'),
    'B968': ('CASTELSILANO', 'KR'),
    'B969': ('CASTEL DI CASIO', 'BO'),
    'B971': ("CASIRATE D'ADDA", 'BG'),
    'B974': ("CASLINO D'ERBA", 'CO'),
    'B977': ('CASNATE CON BERNATE', 'CO'),
    'B978': ('CASNIGO', 'BG'),
    'B979': ('CASOLA IN LUNIGIANA', 'MS'),
    'B980': ('CASOLA DI NAPOLI', 'NA'),
    'B982': ('CASOLA VALSENIO', 'RA'),
    'B984': ("CASOLE D'ELSA", 'SI'),
    'B985': ('CASOLI', 'CH'),
    'B987': ('CASORATE SEMPIONE', 'VA'),
    'B988': ('CASORATE PRIMO', 'PV'),
    'B989': ('CASOREZZO', 'MI'),
    'B990': ('CASORIA', 'NA'),
    'B991': ('CASORZO MONFERRATO', 'AT'),
    'B993': ('CASPOGGIO', 'SO'),
    'B994': ('CASSACCO', 'UD'),
    'B996': ('CASSAGO BRIANZA', 'LC'),
    'B997': ('CASSANO IRPINO', 'AV'),
    'B998': ('CASSANO DELLE MURGE', 'BA'),
    'B999': ('CASSANO VALCUVIA', 'VA'),
    'C002': ("CASSANO ALL'IONIO", 'CS'),
    'C003': ("CASSANO D'ADDA", 'MI'),
    'C004': ('CASSANO MAGNAGO', 'VA'),
    'C006': ('CASSARO', 'SR'),
    'C007': ('CASSIGLIO', 'BG'),
    'C013': ('PERO', 'MI'),
    'C014': ("CASSINA DE' PECCHI", 'MI'),
    'C020': ('CASSINA RIZZARDI', 'CO'),
    'C022': ('CASSINASCO', 'AT'),
    'C024': ('CASSINA VALSASSINA', 'LC'),
    'C027': ('CASSINE', 'AL'),
    'C030': ('CASSINELLE', 'AL'),
    'C033': ('CASSINETTA DI LUGAGNANO', 'MI'),
    'C034': ('CASSINO', 'FR'),
    'C037': ('CASSOLA', 'VI'),
    'C038': ('CASSOLNOVO', 'PV'),
    'C040': ('CASTEL CASTAGNA', 'TE'),
    'C041': ('CASTAGNARO', 'VR'),
    'C044': ('CASTAGNETO CARDUCCI', 'LI'),
    'C045': ('CASTAGNETO PO', 'TO'),
    'C046': ('CASTAGNITO', 'CN'),
    'C047': ('CASTAGNOLE MONFERRATO', 'AT'),
    'C048': ('CASTAGNOLE PIEMONTE', 'TO'),
    'C049': ('CASTAGNOLE DELLE LANZE', 'AT'),
    'C050': ('CASTANA', 'PV'),
    'C051': ("CASTELL'UMBERTO", 'ME'),
    'C052': ('CASTANO PRIMO', 'MI'),
    'C053': ('CASTEGGIO', 'PV'),
    'C055': ('CASTEGNATO', 'BS'),
    'C056': ('CASTEGNERO', 'VI'),
    'C057': ('CASTELBALDO', 'PD'),
    'C058': ('CASTEL BARONIA', 'AV'),
    'C059': ('CASTELBELFORTE', 'MN'),
    'C060': ('CASTELBELLINO', 'AN'),
    'C062': ('CASTELBELLO-CIARDES/KASTELBELL-TSCHARS', 'BZ'),
    'C063': ('CASTELBIANCO', 'SV'),
    'C064': ('CASTEL BOGLIONE', 'AT'),
    'C065': ('CASTEL BOLOGNESE', 'RA'),
    'C066': ('CASTELBOTTACCIO', 'CB'),
    'C067': ('CASTELBUONO', 'PA'),
    'C069': ('CASTELCIVITA', 'SA'),
    'C070': ('SERVIGLIANO', 'FM'),
    'C072': ('CASTELCOVATI', 'BS'),
    'C073': ('CASTELCUCCO', 'TV'),
    'C074': ('CASTELDACCIA', 'PA'),
    'C075': ("CASTEL D'AIANO", 'BO'),
    'C076': ("CASTEL D'ARIO", 'MN'),
    'C078': ("CASTEL D'AZZANO", 'VR'),
    'C079': ('CASTELLI CALEPIO', 'BG'),
    'C080': ('CASTELDELCI', 'RN'),
    'C081': ('CASTELDELFINO', 'CN'),
    'C082': ('CASTEL DEL GIUDICE', 'IS'),
    'C083': ('CASTEL DEL MONTE', 'AQ'),
    'C085': ('CASTEL DEL PIANO', 'GR'),
    'C086': ('CASTEL DEL RIO', 'BO'),
    'C089': ('CASTELDIDONE', 'CR'),
    'C090': ('CASTEL DI IERI', 'AQ'),
    'C091': ('CASTEL DI IUDICA', 'CT'),
    'C093': ('CASTEL DI LAMA', 'AP'),
    'C094': ('CASTEL DI LUCIO', 'ME'),
    'C096': ('CASTEL DI SANGRO', 'AQ'),
    'C097': ('CASTEL DI SASSO', 'CE'),
    'C098': ('CASTEL DI TORA', 'RI'),
    'C100': ('CASTELFIDARDO', 'AN'),
    'C101': ('CASTELFIORENTINO', 'FI'),
    'C102': ('CASTEL FOCOGNANO', 'AR'),
    'C104': ('CASTELFORTE', 'LT'),
    'C105': ('CASTELFRANCI', 'AV'),
    'C106': ('CASTELFRANCO IN MISCANO', 'BN'),
    'C107': ('CASTELFRANCO EMILIA', 'MO'),
    'C108': ('CASTROLIBERO', 'CS'),
    'C110': ('CASTEL VITTORIO', 'IM'),
    'C111': ('CASTELFRANCO VENETO', 'TV'),
    'C113': ('CASTELFRANCO DI SOTTO', 'PI'),
    'C114': ('CASTEL FRENTANO', 'CH'),
    'C115': ('CASTEL GABBIANO', 'CR'),
    'C116': ('CASTEL GANDOLFO', 'RM'),
    'C117': ('CASTEL GIORGIO', 'TR'),
    'C118': ('CASTEL GOFFREDO', 'MN'),
    'C119': ('CASTELGOMBERTO', 'VI'),
    'C120': ('CASTELGRANDE', 'PZ'),
    'C121': ('CASTEL GUELFO DI BOLOGNA', 'BO'),
    'C122': ('CASTELGUGLIELMO', 'RO'),
    'C123': ('CASTELGUIDONE', 'CH'),
    'C125': ('CASTELLABATE', 'SA'),
    'C126': ('CASTELLAFIUME', 'AQ'),
    'C127': ("CASTELL'ALFERO", 'AT'),
    'C128': ('CASTELLALTO', 'TE'),
    'C129': ('CASTELLAMMARE DI STABIA', 'NA'),
    'C130': ('CASTELLAMMARE DEL GOLFO', 'TP'),
    'C133': ('CASTELLAMONTE', 'TO'),
    'C134': ('CASTELLANA GROTTE', 'BA'),
    'C135': ('CASTELLANA SICULA', 'PA'),
    'C136': ('CASTELLANETA', 'TA'),
    'C137': ('CASTELLANIA COPPI', 'AL'),
    'C139': ('CASTELLANZA', 'VA'),
    'C141': ('CASTELLARANO', 'RE'),
    'C142': ('CASTELLAR GUIDOBONO', 'AL'),
    'C143': ('CASTELLARO', 'IM'),
    'C145': ("CASTELL'ARQUATO", 'PC'),
    'C147': ("CASTELL'AZZARA", 'GR'),
    'C148': ('CASTELLAZZO BORMIDA', 'AL'),
    'C149': ('CASTELLAZZO NOVARESE', 'NO'),
    'C152': ('CASTELLEONE DI SUASA', 'AN'),
    'C153': ('CASTELLEONE', 'CR'),
    'C154': ('CASTELLERO', 'AT'),
    'C155': ('CASTELLETTO CERVO', 'BI'),
    'C156': ("CASTELLETTO D'ERRO", 'AL'),
    'C157': ('CASTELLETTO DI BRANDUZZO', 'PV'),
    'C158': ("CASTELLETTO D'ORBA", 'AL'),
    'C160': ('CASTELLETTO MERLI', 'AL'),
    'C161': ('CASTELLETTO MOLINA', 'AT'),
    'C162': ('CASTELLETTO MONFERRATO', 'AL'),
    'C165': ('CASTELLETTO STURA', 'CN'),
    'C166': ('CASTELLETTO SOPRA TICINO', 'NO'),
    'C167': ('CASTELLETTO UZZONE', 'CN'),
    'C169': ('CASTELLI', 'TE'),
    'C172': ('CASTELLINA IN CHIANTI', 'SI'),
    'C173': ("CASTELLINALDO D'ALBA", 'CN'),
    'C174': ('CASTELLINA MARITTIMA', 'PI'),
    'C175': ('CASTELLINO DEL BIFERNO', 'CB'),
    'C176': ('CASTELLINO TANARO', 'CN'),
    'C177': ('CASTELLIRI', 'FR'),
    'C178': ('CASTELLO DEL MATESE', 'CE'),
    'C181': ('CASTELVECCANA', 'VA'),
    'C183': ('CASTEL CONDINO', 'TN'),
    'C184': ("CASTELLO D'AGOGNA", 'PV'),
    'C185': ("CASTELLO D'ARGILE", 'BO'),
    'C186': ("CASTELLO DELL'ACQUA", 'SO'),
    'C187': ('CASTELLO DI BRIANZA', 'LC'),
    'C188': ('CASTELLO DI CISTERNA', 'NA'),
    'C189': ('CASTELLO-MOLINA DI FIEMME', 'TN'),
    'C190': ('CASTELLO DI GODEGO', 'TV'),
    'C194': ('CASTELLO TESINO', 'TN'),
    'C195': ('CASTELLUCCHIO', 'MN'),
    'C197': ('CASTELMAURO', 'CB'),
    'C198': ('CASTELLUCCIO DEI SAURI', 'FG'),
    'C199': ('CASTELLUCCIO INFERIORE', 'PZ'),
    'C200': ('CASTELVERRINO', 'IS'),
    'C201': ('CASTELLUCCIO SUPERIORE', 'PZ'),
    'C202': ('CASTELLUCCIO VALMAGGIORE', 'FG'),
    'C203': ('CASTEL MADAMA', 'RM'),
    'C204': ('CASTEL MAGGIORE', 'BO'),
    'C205': ('CASTELMAGNO', 'CN'),
    'C206': ('CASTELMARTE', 'CO'),
    'C207': ('CASTELMASSA', 'RO'),
    'C208': ('CASTEL MELLA', 'BS'),
    'C209': ('CASTELMEZZANO', 'PZ'),
    'C210': ('CASTELMOLA', 'ME'),
    'C211': ('CASTEL MORRONE', 'CE'),
    'C213': ('CASTELNOVETTO', 'PV'),
    'C214': ('CASTELNUOVO DI CEVA', 'CN'),
    'C215': ('CASTELNOVO BARIANO', 'RO'),
    'C216': ('CASTELNUOVO', 'TN'),
    'C217': ('CASTELNOVO DEL FRIULI', 'PN'),
    'C218': ('CASTELNOVO DI SOTTO', 'RE'),
    'C219': ("CASTELNOVO NE' MONTI", 'RE'),
    'C220': ('CASTELNUOVO BOZZENTE', 'CO'),
    'C222': ('CASTELNUOVO DELLA DAUNIA', 'FG'),
    'C223': ('CASTELNUOVO PARANO', 'FR'),
    'C224': ('CASTELNUOVO DI FARFA', 'RI'),
    'C225': ('CASTELNUOVO DEL GARDA', 'VR'),
    'C226': ('CASTELNUOVO BELBO', 'AT'),
    'C227': ('CASTELNUOVO BERARDENGA', 'SI'),
    'C228': ("CASTELNUOVO BOCCA D'ADDA", 'LO'),
    'C229': ('CASTELNUOVO BORMIDA', 'AL'),
    'C230': ('CASTELNUOVO CALCEA', 'AT'),
    'C231': ('CASTELNUOVO CILENTO', 'SA'),
    'C232': ('CASTELNUOVO DON BOSCO', 'AT'),
    'C235': ('CASTELNUOVO DI CONZA', 'SA'),
    'C236': ('CASTELNUOVO DI GARFAGNANA', 'LU'),
    'C237': ('CASTELNUOVO DI PORTO', 'RM'),
    'C240': ('CASTELNUOVO MAGRA', 'SP'),
    'C241': ('CASTELNUOVO NIGRA', 'TO'),
    'C242': ('CASTELNUOVO RANGONE', 'MO'),
    'C243': ('CASTELNUOVO SCRIVIA', 'AL'),
    'C244': ('CASTELNUOVO DI VAL DI CECINA', 'PI'),
    'C245': ('CASTELPAGANO', 'BN'),
    'C246': ('CASTELPETROSO', 'IS'),
    'C247': ('CASTELPIZZUTO', 'IS'),
    'C248': ('CASTELPLANIO', 'AN'),
    'C250': ('CASTELPOTO', 'BN'),
    'C251': ('CASTELRAIMONDO', 'MC'),
    'C252': ('CASTEL RITALDI', 'PG'),
    'C253': ('CASTEL ROCCHERO', 'AT'),
    'C254': ('CASTELROTTO/KASTELRUTH', 'BZ'),
    'C255': ('CASTEL ROZZONE', 'BG'),
    'C259': ('CASTEL SAN GIORGIO', 'SA'),
    'C261': ('CASTEL SAN GIOVANNI', 'PC'),
    'C262': ('CASTEL SAN LORENZO', 'SA'),
    'C263': ('CASTEL SAN NICCOLÒ', 'AR'),
    'C265': ('CASTEL SAN PIETRO TERME', 'BO'),
    'C266': ('CASTEL SAN PIETRO ROMANO', 'RM'),
    'C267': ('CASTELSANTANGELO SUL NERA', 'MC'),
    'C268': ("CASTEL SANT'ANGELO", 'RI'),
    'C269': ("CASTEL SANT'ELIA", 'VT'),
    'C270': ('CASTEL SAN VINCENZO', 'IS'),
    'C271': ('CASTELSARACENO', 'PZ'),
    'C272': ('CASTELSARDO', 'SS'),
    'C273': ('CASTELSEPRIO', 'VA'),
    'C274': ('CASTELSPINA', 'AL'),
    'C275': ('CASTELTERMINI', 'AG'),
    'C276': ('CASTELVECCHIO DI ROCCA BARBENA', 'SV'),
    'C278': ('CASTELVECCHIO CALVISIO', 'AQ'),
    'C279': ('CASTELVECCHIO SUBEQUO', 'AQ'),
    'C280': ('CASTELVENERE', 'BN'),
    'C282': ('VERRÈS', 'AO'),
    'C283': ('CASTELVETERE SUL CALORE', 'AV'),
    'C284': ('CASTELVETERE IN VAL FORTORE', 'BN'),
    'C285': ('CAULONIA', 'RC'),
    'C286': ('CASTELVETRANO', 'TP'),
    'C287': ('CASTELVETRO DI MODENA', 'MO'),
    'C288': ('CASTELVETRO PIACENTINO', 'PC'),
    'C289': ('CASTEL VISCARDO', 'TR'),
    'C290': ('CASTELVISCONTI', 'CR'),
    'C291': ('CASTEL VOLTURNO', 'CE'),
    'C292': ('CASTENASO', 'BO'),
    'C293': ('CASTENEDOLO', 'BS'),
    'C294': ('CHÂTILLON', 'AO'),
    'C296': ('CASTIGLIONE DEI PEPOLI', 'BO'),
    'C297': ('CASTIGLIONE DI SICILIA', 'CT'),
    'C298': ('CASTIGLIONE MESSER MARINO', 'CH'),
    'C300': ('CASTIGLIONE OLONA', 'VA'),
    'C301': ('CASTIGLIONE COSENTINO', 'CS'),
    'C302': ('CASTIGLIONE CHIAVARESE', 'GE'),
    'C303': ('CASTIGLIONE DI GARFAGNANA', 'LU'),
    'C304': ("CASTIGLIONE D'ADDA", 'LO'),
    'C306': ('CASTIGLIONE DEL GENOVESI', 'SA'),
    'C307': ('CASTIGLIONE TORINESE', 'TO'),
    'C308': ('CASTIGLIONE A CASAURIA', 'PE'),
    'C309': ('CASTIGLIONE DEL LAGO', 'PG'),
    'C310': ('CASTIGLIONE DELLA PESCAIA', 'GR'),
    'C311': ('COLLEDARA', 'TE'),
    'C312': ('CASTIGLIONE DELLE STIVIERE', 'MN'),
    'C313': ("CASTIGLIONE D'ORCIA", 'SI'),
    'C314': ('CASTIGLIONE FALLETTO', 'CN'),
    'C315': ('CASTIGLIONE IN TEVERINA', 'VT'),
    'C316': ('CASTIGLIONE MESSER RAIMONDO', 'TE'),
    'C317': ('CASTIGLIONE TINELLA', 'CN'),
    'C318': ('CASTIGLION FIBOCCHI', 'AR'),
    'C319': ('CASTIGLION FIORENTINO', 'AR'),
    'C321': ('CASTIGNANO', 'AP'),
    'C322': ('CASTILENTI', 'TE'),
    'C323': ('CASTINO', 'CN'),
    'C324': ('CASTIONE DELLA PRESOLANA', 'BG'),
    'C325': ('CASTIONE ANDEVENNO', 'SO'),
    'C327': ('CASTIONS DI STRADA', 'UD'),
    'C329': ('CASTIRAGA VIDARDO', 'LO'),
    'C330': ('CASTO', 'BS'),
    'C331': ('CASTORANO', 'AP'),
    'C332': ('CASTREZZATO', 'BS'),
    'C334': ('CASTRI DI LECCE', 'LE'),
    'C335': ("CASTRIGNANO DE' GRECI", 'LE'),
    'C336': ('CASTRIGNANO DEL CAPO', 'LE'),
    'C337': ('CASTRO', 'BG'),
    'C338': ('CASTRO DEI VOLSCI', 'FR'),
    'C339': ('CASTROCARO TERME E TERRA DEL SOLE', 'FC'),
    'C340': ('CASTROCIELO', 'FR'),
    'C341': ('CASTROFILIPPO', 'AG'),
    'C342': ('ENNA', 'EN'),
    'C343': ('CASTRONNO', 'VA'),
    'C344': ('CASTRONOVO DI SICILIA', 'PA'),
    'C345': ("CASTRONUOVO DI SANT'ANDREA", 'PZ'),
    'C346': ('CASTROPIGNANO', 'CB'),
    'C347': ('CASTROREALE', 'ME'),
    'C348': ('CASTROREGIO', 'CS'),
    'C349': ('CASTROVILLARI', 'CS'),
    'C351': ('CATANIA', 'CT'),
    'C352': ('CATANZARO', 'CZ'),
    'C353': ('CATENANUOVA', 'EN'),
    'C354': ('CATIGNANO', 'PE'),
    'C356': ('CATTOLICA ERACLEA', 'AG'),
    'C357': ('CATTOLICA', 'RN'),
    'C359': ('CAUTANO', 'BN'),
    'C360': ('CAVA MANARA', 'PV'),
    'C361': ("CAVA DE' TIRRENI", 'SA'),
    'C363': ('CAVAGLIÀ', 'BI'),
    'C364': ('CAVAGLIETTO', 'NO'),
    'C365': ("CAVAGLIO D'AGOGNA", 'NO'),
    'C369': ('CAVAGNOLO', 'TO'),
    'C370': ('CAVAION VERONESE', 'VR'),
    'C372': ('CAVALESE', 'TN'),
    'C375': ('CAVALLERLEONE', 'CN'),
    'C376': ('CAVALLERMAGGIORE', 'CN'),
    'C377': ('CAVALLINO', 'LE'),
    'C378': ('CAVALLIRIO', 'NO'),
    'C380': ('CAVARENO', 'TN'),
    'C381': ('CAVARGNA', 'CO'),
    'C382': ('CAVARIA CON PREMEZZO', 'VA'),
    'C383': ('CAVARZERE', 'VE'),
    'C384': ('CAVASO DEL TOMBA', 'TV'),
    'C385': ('CAVASSO NUOVO', 'PN'),
    'C387': ('CAVATORE', 'AL'),
    'C388': ('JESOLO', 'VE'),
    'C389': ('CAVAZZO CARNICO', 'UD'),
    'C390': ('CAVE', 'RM'),
    'C392': ('CAVEDAGO', 'TN'),
    'C393': ('CAVEDINE', 'TN'),
    'C394': ("CAVENAGO D'ADDA", 'LO'),
    'C395': ('CAVENAGO DI BRIANZA', 'MB'),
    'C396': ('CAVERNAGO', 'BG'),
    'C398': ('CAVEZZO', 'MO'),
    'C400': ('CAVIZZANA', 'TN'),
    'C404': ('CAVOUR', 'TO'),
    'C405': ('CAVRIAGO', 'RE'),
    'C406': ('CAVRIANA', 'MN'),
    'C407': ('CAVRIGLIA', 'AR'),
    'C408': ('CAZZAGO SAN MARTINO', 'BS'),
    'C409': ('CAZZAGO BRABBIA', 'VA'),
    'C410': ("CAZZANO SANT'ANDREA", 'BG'),
    'C412': ('CAZZANO DI TRAMIGNA', 'VR'),
    'C413': ('CECCANO', 'FR'),
    'C414': ('CECIMA', 'PV'),
    'C415': ('CECINA', 'LI'),
    'C417': ('CEDEGOLO', 'BS'),
    'C418': ('CEDRASCO', 'SO'),
    'C420': ('CEFALÀ DIANA', 'PA'),
    'C421': ('CEFALÙ', 'PA'),
    'C422': ('CEGGIA', 'VE'),
    'C424': ('CEGLIE MESSAPICA', 'BR'),
    'C426': ('CELANO', 'AQ'),
    'C428': ('CELENZA SUL TRIGNO', 'CH'),
    'C429': ('CELENZA VALFORTORE', 'FG'),
    'C430': ('CELICO', 'CS'),
    'C432': ('CELLA MONTE', 'AL'),
    'C435': ('CELLA DATI', 'CR'),
    'C436': ('CELLAMARE', 'BA'),
    'C437': ('CELLARA', 'CS'),
    'C438': ('CELLARENGO', 'AT'),
    'C439': ('CELLATICA', 'BS'),
    'C440': ('CELLE ENOMONDO', 'AT'),
    'C441': ('CELLE DI MACRA', 'CN'),
    'C442': ('CELLE DI SAN VITO', 'FG'),
    'C443': ('CELLE LIGURE', 'SV'),
    'C444': ('CELLE DI BULGHERIA', 'SA'),
    'C446': ('CELLENO', 'VT'),
    'C447': ('CELLERE', 'VT'),
    'C448': ('CELLINO SAN MARCO', 'BR'),
    'C449': ('CELLINO ATTANASIO', 'TE'),
    'C453': ('CENADI', 'CZ'),
    'C456': ('CENATE SOPRA', 'BG'),
    'C457': ('CENATE SOTTO', 'BG'),
    'C458': ('CENCENIGHE AGORDINO', 'BL'),
    'C459': ('CENE', 'BG'),
    'C461': ('CENESELLI', 'RO'),
    'C463': ('CENGIO', 'SV'),
    'C466': ('CENTALLO', 'CN'),
    'C469': ('CENTO', 'FE'),
    'C470': ('CENTOLA', 'SA'),
    'C471': ('CENTURIPE', 'EN'),
    'C472': ('CENTRACHE', 'CZ'),
    'C474': ('CEPAGATTI', 'PE'),
    'C476': ('CEPPALONI', 'BN'),
    'C478': ('CEPPO MORELLI', 'VB'),
    'C479': ('CEPRANO', 'FR'),
    'C480': ('CERAMI', 'EN'),
    'C481': ('CERANESI', 'GE'),
    'C482': ("CERANO D'INTELVI", 'CO'),
    'C483': ('CERANO', 'NO'),
    'C484': ('CERANOVA', 'PV'),
    'C485': ('CERASO', 'SA'),
    'C486': ('CERCEMAGGIORE', 'CB'),
    'C487': ('CERCENASCO', 'TO'),
    'C488': ('CERCEPICCOLA', 'CB'),
    'C489': ('CERCHIARA DI CALABRIA', 'CS'),
    'C492': ('CERCHIO', 'AQ'),
    'C493': ('CERCINO', 'SO'),
    'C494': ('CERCIVENTO', 'UD'),
    'C495': ('CERCOLA', 'NA'),
    'C496': ('CERDA', 'PA'),
    'C497': ('CERES', 'TO'),
    'C498': ('CEREA', 'VR'),
    'C500': ('CEREGNANO', 'RO'),
    'C501': ('CERENZIA', 'KR'),
    'C502': ('CERESARA', 'MN'),
    'C503': ('CERESETO', 'AL'),
    'C504': ('CERESOLE ALBA', 'CN'),
    'C505': ('CERESOLE REALE', 'TO'),
    'C506': ('CERETE', 'BG'),
    'C507': ('CERRETO GRUE', 'AL'),
    'C508': ('CERETTO LOMELLINA', 'PV'),
    'C509': ('CERGNAGO', 'PV'),
    'C510': ('CERIALE', 'SV'),
    'C511': ('CERIANA', 'IM'),
    'C512': ('CERIANO LAGHETTO', 'MB'),
    'C513': ('CERIGNALE', 'PC'),
    'C514': ('CERIGNOLA', 'FG'),
    'C515': ('CERISANO', 'CS'),
    'C516': ('CERMENATE', 'CO'),
    'C517': ('CERMIGNANO', 'TE'),
    'C518': ('CERRETO LAZIALE', 'RM'),
    'C520': ('CERNOBBIO', 'CO'),
    'C521': ('CERNUSCO LOMBARDONE', 'LC'),
    'C523': ('CERNUSCO SUL NAVIGLIO', 'MI'),
    'C524': ("CERRETO D'ESI", 'AN'),
    'C525': ('CERRETO SANNITA', 'BN'),
    'C527': ('CERRETO DI SPOLETO', 'PG'),
    'C528': ("CERRETO D'ASTI", 'AT'),
    'C529': ('CERRETO GUIDI', 'FI'),
    'C530': ('CERRETTO LANGHE', 'CN'),
    'C531': ('CERRINA MONFERRATO', 'AL'),
    'C532': ('CERRIONE', 'BI'),
    'C533': ('CERRO TANARO', 'AT'),
    'C534': ('CERRO AL VOLTURNO', 'IS'),
    'C536': ('CERRO AL LAMBRO', 'MI'),
    'C537': ('CERRO MAGGIORE', 'MI'),
    'C538': ('CERRO VERONESE', 'VR'),
    'C539': ('CERSOSIMO', 'PZ'),
    'C540': ('CERTALDO', 'FI'),
    'C541': ('CERTOSA DI PAVIA', 'PV'),
    'C542': ('CERVA', 'CZ'),
    'C543': ('CERVARA DI ROMA', 'RM'),
    'C544': ('CERVARESE SANTA CROCE', 'PD'),
    'C545': ('CERVARO', 'FR'),
    'C547': ('CERVASCA', 'CN'),
    'C548': ('CERVATTO', 'VC'),
    'C549': ('CERVENO', 'BS'),
    'C550': ('CERVERE', 'CN'),
    'C551': ('CERVESINA', 'PV'),
    'C552': ('CERVETERI', 'RM'),
    'C553': ('CERVIA', 'RA'),
    'C554': ('CERVICATI', 'CS'),
    'C555': ("CERVIGNANO D'ADDA", 'LO'),
    'C556': ('CERVIGNANO DEL FRIULI', 'UD'),
    'C557': ('CERVINARA', 'AV'),
    'C558': ('CERVINO', 'CE'),
    'C559': ('CERVO', 'IM'),
    'C560': ('CERZETO', 'CS'),
    'C561': ('CESA', 'CE'),
    'C563': ('CESANA BRIANZA', 'LC'),
    'C564': ('CESANA TORINESE', 'TO'),
    'C565': ('CESANO BOSCONE', 'MI'),
    'C566': ('CESANO MADERNO', 'MB'),
    'C567': ('CESARA', 'VB'),
    'C568': ('CESARÒ', 'ME'),
    'C569': ('CESATE', 'MI'),
    'C573': ('CESENA', 'FC'),
    'C574': ('CESENATICO', 'FC'),
    'C576': ('CESINALI', 'AV'),
    'C577': ('CESIOMAGGIORE', 'BL'),
    'C578': ('CESIO', 'IM'),
    'C580': ('CESSALTO', 'TV'),
    'C581': ('CESSANITI', 'VV'),
    'C582': ('CESSAPALOMBO', 'MC'),
    'C583': ('CESSOLE', 'AT'),
    'C584': ('CETARA', 'SA'),
    'C585': ('CETO', 'BS'),
    'C587': ('CETONA', 'SI'),
    'C588': ('CETRARO', 'CS'),
    'C589': ('CEVA', 'CN'),
    'C591': ('CEVO', 'BS'),
    'C593': ('CHALLAND-SAINT-ANSELME', 'AO'),
    'C594': ('CHALLAND-SAINT-VICTOR', 'AO'),
    'C595': ('CHAMBAVE', 'AO'),
    'C596': ('CHAMPDEPRAZ', 'AO'),
    'C598': ('CHARVENSOD', 'AO'),
    'C599': ('CHERASCO', 'CN'),
    'C600': ('CHEREMULE', 'SS'),
    'C604': ('CHIALAMBERTO', 'TO'),
    'C605': ('CHIAMPO', 'VI'),
    'C606': ('CHIANCHE', 'AV'),
    'C608': ('CHIANCIANO TERME', 'SI'),
    'C609': ('CHIANNI', 'PI'),
    'C610': ('CHIANOCCO', 'TO'),
    'C612': ('CHIARAMONTE GULFI', 'RG'),
    'C613': ('CHIARAMONTI', 'SS'),
    'C614': ('CHIARANO', 'TV'),
    'C615': ('CHIARAVALLE', 'AN'),
    'C616': ('CHIARAVALLE CENTRALE', 'CZ'),
    'C618': ('CHIARI', 'BS'),
    'C619': ('CHIAROMONTE', 'PZ'),
    'C620': ('CHIAUCI', 'IS'),
    'C621': ('CHIAVARI', 'GE'),
    'C623': ('CHIAVENNA', 'SO'),
    'C624': ('CHIAVERANO', 'TO'),
    'C625': ('CHIENES/KIENS', 'BZ'),
    'C627': ('CHIERI', 'TO'),
    'C628': ('CHIESA IN VALMALENCO', 'SO'),
    'C629': ('CHIESANUOVA', 'TO'),
    'C630': ("CHIES D'ALPAGO", 'BL'),
    'C631': ('CHIESINA UZZANESE', 'PT'),
    'C632': ('CHIETI', 'CH'),
    'C633': ('CHIEUTI', 'FG'),
    'C634': ('CHIEVE', 'CR'),
    'C635': ("CHIGNOLO D'ISOLA", 'BG'),
    'C637': ('CHIGNOLO PO', 'PV'),
    'C638': ('CHIOGGIA', 'VE'),
    'C639': ('CHIOMONTE', 'TO'),
    'C640': ('CHIONS', 'PN'),
    'C641': ('CHIOPRIS-VISCONE', 'UD'),
    'C648': ('CHITIGNANO', 'AR'),
    'C649': ('CHIUDUNO', 'BG'),
    'C650': ('CHIUPPANO', 'VI'),
    'C651': ('CHIURO', 'SO'),
    'C652': ('CHIUSA/KLAUSEN', 'BZ'),
    'C653': ('CHIUSA DI PESIO', 'CN'),
    'C654': ('CHIUSA SCLAFANI', 'PA'),
    'C655': ('CHIUSA DI SAN MICHELE', 'TO'),
    'C656': ('CHIUSAFORTE', 'UD'),
    'C657': ('CHIUSANICO', 'IM'),
    'C658': ("CHIUSANO D'ASTI", 'AT'),
    'C659': ('CHIUSANO DI SAN DOMENICO', 'AV'),
    'C660': ('CHIUSAVECCHIA', 'IM'),
    'C661': ('CHIUSDINO', 'SI'),
    'C662': ('CHIUSI', 'SI'),
    'C663': ('CHIUSI DELLA VERNA', 'AR'),
    'C665': ('CHIVASSO', 'TO'),
    'C668': ('CIANCIANA', 'AG'),
    'C669': ('CANOSSA', 'RE'),
    'C670': ('CROCETTA DEL MONTELLO', 'TV'),
    'C672': ('CIBIANA DI CADORE', 'BL'),
    'C673': ('CICAGNA', 'GE'),
    'C674': ('CICALA', 'CZ'),
    'C675': ('CICCIANO', 'NA'),
    'C676': ('CICERALE', 'SA'),
    'C677': ('CICILIANO', 'RM'),
    'C678': ('CICOGNOLO', 'CR'),
    'C679': ('CICONIO', 'TO'),
    'C680': ('CIGLIANO', 'VC'),
    'C681': ('CIGLIÈ', 'CN'),
    'C684': ('CIGOGNOLA', 'PV'),
    'C685': ('CIGOLE', 'BS'),
    'C686': ('CILAVEGNA', 'PV'),
    'C689': ('CIMADOLMO', 'TV'),
    'C691': ('CIMBERGO', 'BS'),
    'C695': ('CIMINÀ', 'RC'),
    'C696': ('CIMINNA', 'PA'),
    'C697': ('CIMITILE', 'NA'),
    'C698': ('TAVERNOLE SUL MELLA', 'BS'),
    'C699': ('CIMOLAIS', 'PN'),
    'C700': ('CIMONE', 'TN'),
    'C701': ('CINAGLIO', 'AT'),
    'C702': ('CINETO ROMANO', 'RM'),
    'C703': ("CINGIA DE' BOTTI", 'CR'),
    'C704': ('CINGOLI', 'MC'),
    'C705': ('CINIGIANO', 'GR'),
    'C707': ('CINISELLO BALSAMO', 'MI'),
    'C708': ('CINISI', 'PA'),
    'C709': ('CINO', 'SO'),
    'C710': ('CINQUEFRONDI', 'RC'),
    'C711': ('CINTANO', 'TO'),
    'C712': ('CINTE TESINO', 'TN'),
    'C713': ('CINTO EUGANEO', 'PD'),
    'C714': ('CINTO CAOMAGGIORE', 'VE'),
    'C715': ('CINZANO', 'TO'),
    'C716': ('CIORLANO', 'CE'),
    'C717': ('SANTA MARIA DEL CEDRO', 'CS'),
    'C718': ('CIPRESSA', 'IM'),
    'C719': ('CIRCELLO', 'BN'),
    'C722': ('CIRIÈ', 'TO'),
    'C723': ('CIRIGLIANO', 'MT'),
    'C724': ('CIRIMIDO', 'CO'),
    'C725': ('CIRÒ', 'KR'),
    'C726': ('CIRÒ MARINA', 'KR'),
    'C727': ('CIS', 'TN'),
    'C728': ('CISANO BERGAMASCO', 'BG'),
    'C729': ('CISANO SUL NEVA', 'SV'),
    'C730': ('CISERANO', 'BG'),
    'C732': ('CISLAGO', 'VA'),
    'C733': ('CISLIANO', 'MI'),
    'C735': ('CISON DI VALMARINO', 'TV'),
    'C738': ('CISSONE', 'CN'),
    'C739': ("CISTERNA D'ASTI", 'AT'),
    'C740': ('CISTERNA DI LATINA', 'LT'),
    'C741': ('CISTERNINO', 'BR'),
    'C742': ('CITERNA', 'PG'),
    'C743': ('CITTADELLA', 'PD'),
    'C744': ('CITTÀ DELLA PIEVE', 'PG'),
    'C745': ('CITTÀ DI CASTELLO', 'PG'),
    'C746': ('CITTADUCALE', 'RI'),
    'C747': ('CITTANOVA', 'RC'),
    'C749': ('CITTAREALE', 'RI'),
    'C750': ("CITTÀ SANT'ANGELO", 'PE'),
    'C751': ('CITTIGLIO', 'VA'),
    'C752': ('CIVATE', 'LC'),
    'C755': ('CIVEZZA', 'IM'),
    'C756': ('CIVEZZANO', 'TN'),
    'C757': ('CIVIASCO', 'VC'),
    'C758': ('CIVIDALE DEL FRIULI', 'UD'),
    'C759': ('CIVIDATE AL PIANO', 'BG'),
    'C760': ('CIVIDATE CAMUNO', 'BS'),
    'C763': ('CIVITA', 'CS'),
    'C764': ('CIVITACAMPOMARANO', 'CB'),
    'C765': ('CIVITA CASTELLANA', 'VT'),
    'C766': ("CIVITA D'ANTINO", 'AQ'),
    'C767': ('LANUVIO', 'RM'),
    'C768': ('CIVITALUPARELLA', 'CH'),
    'C769': ('CIVITANOVA DEL SANNIO', 'IS'),
    'C770': ('CIVITANOVA MARCHE', 'MC'),
    'C771': ('CIVITAQUANA', 'PE'),
    'C772': ('DURONIA', 'CB'),
    'C773': ('CIVITAVECCHIA', 'RM'),
    'C774': ('CIVITELLA IN VAL DI CHIANA', 'AR'),
    'C776': ('CIVITELLA MESSER RAIMONDO', 'CH'),
    'C777': ('CIVITELLA DI ROMAGNA', 'FC'),
    'C778': ('CIVITELLA ALFEDENA', 'AQ'),
    'C779': ('CIVITELLA CASANOVA', 'PE'),
    'C780': ("CIVITELLA D'AGLIANO", 'VT'),
    'C781': ('CIVITELLA DEL TRONTO', 'TE'),
    'C782': ('CIVITELLA PAGANICO', 'GR'),
    'C783': ('CIVITELLA ROVETO', 'AQ'),
    'C784': ('CIVITELLA SAN PAOLO', 'RM'),
    'C785': ('CIVO', 'SO'),
    'C787': ('CLAINO CON OSTENO', 'CO'),
    'C789': ('UBIALE CLANEZZO', 'BG'),
    'C790': ('CLAUT', 'PN'),
    'C791': ('CLAUZETTO', 'PN'),
    'C792': ('CLAVESANA', 'CN'),
    'C793': ('CLAVIERE', 'TO'),
    'C794': ('CLES', 'TN'),
    'C795': ('CLETO', 'CS'),
    'C796': ('CLIVIO', 'VA'),
    'C800': ('CLUSONE', 'BG'),
    'C801': ('COASSOLO TORINESE', 'TO'),
    'C803': ('COAZZE', 'TO'),
    'C804': ('COAZZOLO', 'AT'),
    'C806': ('COCCAGLIO', 'BS'),
    'C807': ('COCCONATO', 'AT'),
    'C810': ('COCQUIO-TREVISAGO', 'VA'),
    'C811': ('COCULLO', 'AQ'),
    'C812': ('CODEVIGO', 'PD'),
    'C813': ('CODEVILLA', 'PV'),
    'C814': ('CODIGORO', 'FE'),
    'C815': ('CODOGNÈ', 'TV'),
    'C816': ('CODOGNO', 'LO'),
    'C817': ('CODROIPO', 'UD'),
    'C818': ('CODRONGIANOS', 'SS'),
    'C819': ('COGGIOLA', 'BI'),
    'C820': ('COGLIATE', 'MB'),
    'C821': ('COGNE', 'AO'),
    'C823': ('COGOLETO', 'GE'),
    'C824': ('COGOLLO DEL CENGIO', 'VI'),
    'C826': ('COGORNO', 'GE'),
    'C829': ('COLAZZA', 'NO'),
    'C835': ('COLERE', 'BG'),
    'C836': ('COLFELICE', 'FR'),
    'C838': ('COLI', 'PC'),
    'C839': ('COLICO', 'LC'),
    'C841': ('COLLALTO SABINO', 'RI'),
    'C844': ('COLLARMELE', 'AQ'),
    'C845': ('COLLAZZONE', 'PG'),
    'C846': ('COLLE SANNITA', 'BN'),
    'C847': ("COLLE DI VAL D'ELSA", 'SI'),
    'C848': ('COLLE UMBERTO', 'TV'),
    'C850': ('COLLEBEATO', 'BS'),
    'C851': ('COLLE BRIANZA', 'LC'),
    'C852': ('COLLECCHIO', 'PR'),
    'C853': ('COLLECORVINO', 'PE'),
    'C854': ("COLLE D'ANCHISE", 'CB'),
    'C855': ('COLLEDIMACINE', 'CH'),
    'C856': ('COLLEDIMEZZO', 'CH'),
    'C857': ('COLLE DI TORA', 'RI'),
    'C858': ('COLLEFERRO', 'RM'),
    'C859': ('COLLEGIOVE', 'RI'),
    'C860': ('COLLEGNO', 'TO'),
    'C862': ('COLLELONGO', 'AQ'),
    'C864': ('COLLEPARDO', 'FR'),
    'C865': ('COLLEPASSO', 'LE'),
    'C866': ('COLLEPIETRO', 'AQ'),
    'C867': ('COLLERETTO CASTELNUOVO', 'TO'),
    'C868': ('COLLERETTO GIACOSA', 'TO'),
    'C869': ('COLLESALVETTI', 'LI'),
    'C870': ('COLLE SAN MAGNO', 'FR'),
    'C871': ('COLLESANO', 'PA'),
    'C872': ('COLLE SANTA LUCIA', 'BL'),
    'C875': ('COLLETORTO', 'CB'),
    'C876': ('COLLEVECCHIO', 'RI'),
    'C877': ('COLLI DEL TRONTO', 'AP'),
    'C878': ('COLLI A VOLTURNO', 'IS'),
    'C879': ('COLLIANO', 'SA'),
    'C880': ('COLLI SUL VELINO', 'RI'),
    'C882': ('COLLINAS', 'SU'),
    'C883': ('COLLIO', 'BS'),
    'C884': ('COLLOBIANO', 'VC'),
    'C885': ('COLLOREDO DI MONTE ALBANO', 'UD'),
    'C886': ('COLMURANO', 'MC'),
    'C888': ('COLOBRARO', 'MT'),
    'C890': ('COLOGNA VENETA', 'VR'),
    'C893': ('COLOGNE', 'BS'),
    'C894': ('COLOGNO AL SERIO', 'BG'),
    'C895': ('COLOGNO MONZESE', 'MI'),
    'C897': ('COLOGNOLA AI COLLI', 'VR'),
    'C900': ('COLONNA', 'RM'),
    'C901': ('COLONNELLA', 'TE'),
    'C902': ('COLONNO', 'CO'),
    'C903': ('COLORINA', 'SO'),
    'C904': ('COLORNO', 'PR'),
    'C905': ('COLOSIMI', 'CS'),
    'C908': ('COLTURANO', 'MI'),
    'C910': ('COLZATE', 'BG'),
    'C911': ('COMABBIO', 'VA'),
    'C912': ('COMACCHIO', 'FE'),
    'C914': ('COMANO', 'MS'),
    'C917': ('COMAZZO', 'LO'),
    'C918': ('COMEGLIANS', 'UD'),
    'C919': ('SANTO STEFANO DI CADORE', 'BL'),
    'C920': ('COMELICO SUPERIORE', 'BL'),
    'C922': ('COMERIO', 'VA'),
    'C925': ('COMEZZANO-CIZZAGO', 'BS'),
    'C926': ('COMIGNAGO', 'NO'),
    'C927': ('COMISO', 'RG'),
    'C928': ('COMITINI', 'AG'),
    'C929': ('COMIZIANO', 'NA'),
    'C930': ('COMMESSAGGIO', 'MN'),
    'C931': ('COMMEZZADURA', 'TN'),
    'C933': ('COMO', 'CO'),
    'C934': ('COMPIANO', 'PR'),
    'C935': ('COMUNANZA', 'AP'),
    'C936': ('VALSOLDA', 'CO'),
    'C937': ('COMUN NUOVO', 'BG'),
    'C938': ('CONA', 'VE'),
    'C939': ('CONCA DELLA CAMPANIA', 'CE'),
    'C940': ('CONCA DEI MARINI', 'SA'),
    'C941': ('CONCA CASALE', 'IS'),
    'C943': ('CONCAMARISE', 'VR'),
    'C946': ('CONCERVIANO', 'RI'),
    'C948': ('CONCESIO', 'BS'),
    'C950': ('CONCORDIA SAGITTARIA', 'VE'),
    'C951': ('CONCORDIA SULLA SECCHIA', 'MO'),
    'C952': ('CONCOREZZO', 'MB'),
    'C954': ('CONDOFURI', 'RC'),
    'C955': ('CONDOVE', 'TO'),
    'C956': ('CONDRÒ', 'ME'),
    'C957': ('CONEGLIANO', 'TV'),
    'C958': ('CONFIENZA', 'PV'),
    'C959': ('CONFIGNI', 'RI'),
    'C960': ('CONFLENTI', 'CZ'),
    'C962': ('CONIOLO', 'AL'),
    'C963': ('CONSELICE', 'RA'),
    'C964': ('CONSELVE', 'PD'),
    'C968': ('CONTESSA ENTELLINA', 'PA'),
    'C969': ('CONTIGLIANO', 'RI'),
    'C971': ('CONTRADA', 'AV'),
    'C972': ('CONTROGUERRA', 'TE'),
    'C973': ('CONTRONE', 'SA'),
    'C974': ('CONTURSI TERME', 'SA'),
    'C975': ('CONVERSANO', 'BA'),
    'C976': ('CONZA DELLA CAMPANIA', 'AV'),
    'C977': ('CONZANO', 'AL'),
    'C978': ('COPERTINO', 'LE'),
    'C979': ('COPIANO', 'PV'),
    'C980': ('COPPARO', 'FE'),
    'C982': ('CORANA', 'PV'),
    'C983': ('CORATO', 'BA'),
    'C984': ('CORBARA', 'SA'),
    'C986': ('CORBETTA', 'MI'),
    'C987': ('CORBOLA', 'RO'),
    'C988': ('CORCHIANO', 'VT'),
    'C990': ('CORCIANO', 'PG'),
    'C991': ('CORDENONS', 'PN'),
    'C992': ('CORDIGNANO', 'TV'),
    'C993': ('CORDOVADO', 'PN'),
    'C995': ('COREGLIA LIGURE', 'GE'),
    'C996': ('COREGLIA ANTELMINELLI', 'LU'),
    'C998': ('CORENO AUSONIO', 'FR'),
    'C999': ('CORFINIO', 'AQ'),
    'D003': ('CORI', 'LT'),
    'D004': ('CORIANO', 'RN'),
    'D006': ("CORIGLIANO D'OTRANTO", 'LE'),
    'D007': ('CORINALDO', 'AN'),
    'D008': ('CORIO', 'TO'),
    'D009': ('CORLEONE', 'PA'),
    'D010': ('CORLETO PERTICARA', 'PZ'),
    'D011': ('CORLETO MONFORTE', 'SA'),
    'D012': ('COURMAYEUR', 'AO'),
    'D013': ('CORMANO', 'MI'),
    'D014': ('CORMONS', 'GO'),
    'D015': ('CORNA IMAGNA', 'BG'),
    'D016': ('CORNALBA', 'BG'),
    'D018': ('CORNAREDO', 'MI'),
    'D019': ("CORNATE D'ADDA", 'MB'),
    'D020': ('CORNEDO VICENTINO', 'VI'),
    'D021': ('CORNEGLIANO LAUDENSE', 'LO'),
    'D022': ("CORNELIANO D'ALBA", 'CN'),
    'D024': ('TARQUINIA', 'VT'),
    'D026': ('CORNIGLIO', 'PR'),
    'D027': ('CORNO DI ROSAZZO', 'UD'),
    'D028': ('CORNO GIOVINE', 'LO'),
    'D029': ('CORNOVECCHIO', 'LO'),
    'D030': ('CORNUDA', 'TV'),
    'D033': ('MORIMONDO', 'MI'),
    'D037': ('CORREGGIO', 'RE'),
    'D038': ('CORREZZANA', 'MB'),
    'D040': ('CORREZZOLA', 'PD'),
    'D041': ('CORRIDO', 'CO'),
    'D042': ('CORRIDONIA', 'MC'),
    'D043': ('CORROPOLI', 'TE'),
    'D044': ('CORSANO', 'LE'),
    'D045': ('CORSICO', 'MI'),
    'D046': ('CORSIONE', 'AT'),
    'D048': ('CORTACCIA SULLA STRADA DEL VINO/KURTATSCH AN DER WEINSTRASSE', 'BZ'),
    'D049': ('CORTALE', 'CZ'),
    'D050': ('CORTANDONE', 'AT'),
    'D051': ('CORTANZE', 'AT'),
    'D052': ('CORTAZZONE', 'AT'),
    'D054': ('CORTE BRUGNATELLA', 'PC'),
    'D056': ("CORTE DE' CORTESI CON CIGNONE", 'CR'),
    'D057': ("CORTE DE' FRATI", 'CR'),
    'D058': ('CORTE FRANCA', 'BS'),
    'D061': ('CORTEMAGGIORE', 'PC'),
    'D062': ('CORTEMILIA', 'CN'),
    'D064': ('CORTENO GOLGI', 'BS'),
    'D065': ('CORTENOVA', 'LC'),
    'D066': ('CORTENUOVA', 'BG'),
    'D068': ('CORTE PALASIO', 'LO'),
    'D072': ('CORTIGLIONE', 'AT'),
    'D075': ('CORTINA SULLA STRADA DEL VINO/KURTINIG AN DER WEINSTRASSE', 'BZ'),
    'D076': ('CORTINO', 'TE'),
    'D077': ('CORTONA', 'AR'),
    'D078': ('CORVARA', 'PE'),
    'D079': ('CORVARA IN BADIA/CORVARA', 'BZ'),
    'D081': ('CORVINO SAN QUIRICO', 'PV'),
    'D082': ('CORZANO', 'BS'),
    'D085': ('COSEANO', 'UD'),
    'D086': ('COSENZA', 'CS'),
    'D087': ("COSIO D'ARROSCIA", 'IM'),
    'D088': ('COSIO VALTELLINO', 'SO'),
    'D089': ('COSOLETO', 'RC'),
    'D092': ('COSSANO CANAVESE', 'TO'),
    'D093': ('COSSANO BELBO', 'CN'),
    'D094': ('COSSATO', 'BI'),
    'D095': ('COSSERIA', 'SV'),
    'D096': ('COSSIGNANO', 'AP'),
    'D099': ('COSSOGNO', 'VB'),
    'D100': ('COSSOINE', 'SS'),
    'D101': ('COSSOMBRATO', 'AT'),
    'D102': ('COSTA VESCOVATO', 'AL'),
    'D103': ('COSTA VALLE IMAGNA', 'BG'),
    'D105': ('COSTA DI ROVIGO', 'RO'),
    'D107': ('COSTABISSARA', 'VI'),
    'D108': ('COSTACCIARO', 'PG'),
    'D109': ("COSTA DE' NOBILI", 'PV'),
    'D110': ('COSTA DI MEZZATE', 'BG'),
    'D111': ('COSTA SERINA', 'BG'),
    'D112': ('COSTA MASNAGA', 'LC'),
    'D113': ('COSTANZANA', 'VC'),
    'D114': ('COSTARAINERA', 'IM'),
    'D117': ('COSTA VOLPINO', 'BG'),
    'D118': ('COSTERMANO SUL GARDA', 'VR'),
    'D119': ("COSTIGLIOLE D'ASTI", 'AT'),
    'D120': ('COSTIGLIOLE SALUZZO', 'CN'),
    'D121': ('COTIGNOLA', 'RA'),
    'D122': ('CROTONE', 'KR'),
    'D123': ('COTRONEI', 'KR'),
    'D124': ('COTTANELLO', 'RI'),
    'D126': ('COVO', 'BG'),
    'D127': ('COZZO', 'PV'),
    'D128': ('CRACO', 'MT'),
    'D131': ('CRANDOLA VALSASSINA', 'LC'),
    'D132': ('CRAVAGLIANA', 'VC'),
    'D133': ('CRAVANZANA', 'CN'),
    'D134': ('CRAVEGGIA', 'VB'),
    'D136': ('CREAZZO', 'VI'),
    'D137': ('CRECCHIO', 'CH'),
    'D139': ('CREDARO', 'BG'),
    'D141': ('CREDERA RUBBIANO', 'CR'),
    'D142': ('CREMA', 'CR'),
    'D143': ('CREMELLA', 'LC'),
    'D144': ('CREMENAGA', 'VA'),
    'D145': ('CREMENO', 'LC'),
    'D147': ('CREMIA', 'CO'),
    'D149': ('CREMOLINO', 'AL'),
    'D150': ('CREMONA', 'CR'),
    'D151': ('CREMOSANO', 'CR'),
    'D154': ('CRESCENTINO', 'VC'),
    'D156': ('CRESPADORO', 'VI'),
    'D159': ('CRESPIATICA', 'LO'),
    'D161': ('CRESPINO', 'RO'),
    'D162': ('CRESSA', 'NO'),
    'D165': ('CREVACUORE', 'BI'),
    'D166': ('CREVALCORE', 'BO'),
    'D168': ('CREVOLADOSSOLA', 'VB'),
    'D170': ('CRISPANO', 'NA'),
    'D171': ('CRISPIANO', 'TA'),
    'D172': ('CRISSOLO', 'CN'),
    'D175': ('CROCEFIESCHI', 'GE'),
    'D177': ('CRODO', 'VB'),
    'D179': ('CROGNALETO', 'TE'),
    'D180': ('CROPALATI', 'CS'),
    'D181': ('CROPANI', 'CZ'),
    'D184': ('CROSIA', 'CS'),
    'D185': ('CROSIO DELLA VALLE', 'VA'),
    'D186': ("CROTTA D'ADDA", 'CR'),
    'D187': ('CROVA', 'VC'),
    'D188': ('CROVIANA', 'TN'),
    'D189': ('CRUCOLI', 'KR'),
    'D192': ('CUASSO AL MONTE', 'VA'),
    'D193': ('VERONELLA', 'VR'),
    'D195': ('CUCCARO VETERE', 'SA'),
    'D196': ('CUCCIAGO', 'CO'),
    'D197': ('CUCEGLIO', 'TO'),
    'D198': ('CUGGIONO', 'MI'),
    'D199': ('CUGLIATE-FABIASCO', 'VA'),
    'D200': ('CUGLIERI', 'OR'),
    'D201': ('CUGNOLI', 'PE'),
    'D202': ('CUMIANA', 'TO'),
    'D203': ('CUMIGNANO SUL NAVIGLIO', 'CR'),
    'D204': ('CUNARDO', 'VA'),
    'D205': ('CUNEO', 'CN'),
    'D207': ('CUNICO', 'AT'),
    'D208': ('CUORGNÈ', 'TO'),
    'D209': ('CUPELLO', 'CH'),
    'D210': ('CUPRA MARITTIMA', 'AP'),
    'D211': ('CUPRAMONTANA', 'AN'),
    'D214': ('CURCURIS', 'OR'),
    'D216': ('CUREGGIO', 'NO'),
    'D217': ('CURIGLIA CON MONTEVIASCO', 'VA'),
    'D218': ('CURINGA', 'CZ'),
    'D219': ('CURINO', 'BI'),
    'D221': ('CURNO', 'BG'),
    'D222': ('CURON VENOSTA/GRAUN IM VINSCHGAU', 'BZ'),
    'D223': ('CURSI', 'LE'),
    'D226': ('CURTAROLO', 'PD'),
    'D227': ('CURTATONE', 'MN'),
    'D228': ('CURTI', 'CE'),
    'D229': ('CUSAGO', 'MI'),
    'D230': ('CUSANO MUTRI', 'BN'),
    'D231': ('CUSANO MILANINO', 'MI'),
    'D232': ('CUSINO', 'CO'),
    'D233': ('CUSIO', 'BG'),
    'D234': ('CUSTONACI', 'TP'),
    'D236': ('CUTRO', 'KR'),
    'D237': ('CUTROFIANO', 'LE'),
    'D238': ('CUVEGLIO', 'VA'),
    'D239': ('CUVIO', 'VA'),
    'D244': ('DAIRAGO', 'MI'),
    'D245': ('DALMINE', 'BG'),
    'D246': ('DAMBEL', 'TN'),
    'D247': ('DANTA DI CADORE', 'BL'),
    'D251': ('DARFO BOARIO TERME', 'BS'),
    'D253': ('DASÀ', 'VV'),
    'D255': ('DAVAGNA', 'GE'),
    'D256': ('DAVERIO', 'VA'),
    'D257': ('DAVOLI', 'CZ'),
    'D258': ('DAZIO', 'SO'),
    'D259': ('DECIMOMANNU', 'CA'),
    'D260': ('DECIMOPUTZU', 'SU'),
    'D261': ('DECOLLATURA', 'CZ'),
    'D264': ('DEGO', 'SV'),
    'D265': ('DEIVA MARINA', 'SP'),
    'D266': ('DELEBIO', 'SO'),
    'D267': ('DELIA', 'CL'),
    'D268': ('DELIANUOVA', 'RC'),
    'D269': ('DELICETO', 'FG'),
    'D270': ('DELLO', 'BS'),
    'D271': ('DEMONTE', 'CN'),
    'D272': ('DENICE', 'AL'),
    'D273': ('DENNO', 'TN'),
    'D277': ('DERNICE', 'AL'),
    'D278': ('DEROVERE', 'CR'),
    'D279': ('DERUTA', 'PG'),
    'D280': ('DERVIO', 'LC'),
    'D281': ('DESANA', 'VC'),
    'D284': ('DESENZANO DEL GARDA', 'BS'),
    'D286': ('DESIO', 'MB'),
    'D287': ('DESULO', 'NU'),
    'D289': ('DIAMANTE', 'CS'),
    'D290': ('SCIGLIANO', 'CS'),
    'D291': ("DIANO D'ALBA", 'CN'),
    'D292': ('TEGGIANO', 'SA'),
    'D293': ('DIANO ARENTINO', 'IM'),
    'D296': ('DIANO CASTELLO', 'IM'),
    'D297': ('DIANO MARINA', 'IM'),
    'D298': ('DIANO SAN PIETRO', 'IM'),
    'D299': ('DICOMANO', 'FI'),
    'D300': ('DIGNANO', 'UD'),
    'D303': ('DINAMI', 'VV'),
    'D304': ('DIPIGNANO', 'CS'),
    'D305': ('DISO', 'LE'),
    'D309': ('DIVIGNANO', 'NO'),
    'D310': ('DIZZASCO', 'CO'),
    'D311': ('DOBBIACO/TOBLACH', 'BZ'),
    'D312': ('DOBERDÒ DEL LAGO-DOBERDOB', 'GO'),
    'D314': ('DOGLIANI', 'CN'),
    'D315': ('DOGLIOLA', 'CH'),
    'D316': ('DOGNA', 'UD'),
    'D317': ('DOLCÈ', 'VR'),
    'D318': ('DOLCEACQUA', 'IM'),
    'D319': ('DOLCEDO', 'IM'),
    'D321': ('DOLEGNA DEL COLLIO', 'GO'),
    'D323': ('DOLIANOVA', 'SU'),
    'D324': ('SAN DORLIGO DELLA VALLE-DOLINA', 'TS'),
    'D325': ('DOLO', 'VE'),
    'D327': ('DOLZAGO', 'LC'),
    'D328': ('DOMANICO', 'CS'),
    'D329': ('DOMASO', 'CO'),
    'D330': ('DOMEGGE DI CADORE', 'BL'),
    'D331': ('DOMICELLA', 'AV'),
    'D332': ('DOMODOSSOLA', 'VB'),
    'D333': ('DOMUS DE MARIA', 'SU'),
    'D334': ('DOMUSNOVAS', 'SU'),
    'D338': ('DONNAS', 'AO'),
    'D339': ('DONATO', 'BI'),
    'D341': ('DONGO', 'CO'),
    'D344': ('DONORI', 'SU'),
    'D345': ('DORGALI', 'NU'),
    'D346': ('DORIO', 'LC'),
    'D347': ('DORMELLETTO', 'NO'),
    'D348': ('DORNO', 'PV'),
    'D350': ('DORZANO', 'BI'),
    'D351': ('DOSOLO', 'MN'),
    'D352': ('DOSSENA', 'BG'),
    'D355': ('DOSSO DEL LIRO', 'CO'),
    'D356': ('DOUES', 'AO'),
    'D357': ('DOVADOLA', 'FC'),
    'D358': ('DOVERA', 'CR'),
    'D360': ('DOZZA', 'BO'),
    'D361': ('DRAGONI', 'CE'),
    'D364': ('DRAPIA', 'VV'),
    'D365': ('DRENA', 'TN'),
    'D366': ('DRENCHIA', 'UD'),
    'D367': ('DRESANO', 'MI'),
    'D371': ('DRO', 'TN'),
    'D372': ('DRONERO', 'CN'),
    'D373': ('DRUENTO', 'TO'),
    'D374': ('DRUOGNO', 'VB'),
    'D376': ('DUALCHI', 'NU'),
    'D377': ('DUBINO', 'SO'),
    'D379': ('DUEVILLE', 'VI'),
    'D380': ('DUGENTA', 'BN'),
    'D383': ('DUINO AURISINA-DEVIN NABREŽINA', 'TS'),
    'D384': ('DUMENZA', 'VA'),
    'D385': ('DUNO', 'VA'),
    'D386': ('DURAZZANO', 'BN'),
    'D388': ('DUSINO SAN MICHELE', 'AT'),
    'D390': ('EBOLI', 'SA'),
    'D391': ('EDOLO', 'BS'),
    'D392': ('EGNA/NEUMARKT', 'BZ'),
    'D394': ('ELICE', 'PE'),
    'D395': ('ELINI', 'NU'),
    'D398': ('ELLO', 'LC'),
    'D399': ('ELMAS', 'CA'),
    'D401': ('ELVA', 'CN'),
    'D402': ('EMARÈSE', 'AO'),
    'D403': ('EMPOLI', 'FI'),
    'D406': ('ENDINE GAIANO', 'BG'),
    'D407': ('ENEGO', 'VI'),
    'D408': ('ENEMONZO', 'UD'),
    'D410': ('ENTRACQUE', 'CN'),
    'D411': ('ENTRATICO', 'BG'),
    'D412': ('ENVIE', 'CN'),
    'D414': ('EPISCOPIA', 'PZ'),
    'D415': ('ERACLEA', 'VE'),
    'D416': ('ERBA', 'CO'),
    'D419': ('ERBÈ', 'VR'),
    'D420': ('ERBEZZO', 'VR'),
    'D421': ('ERBUSCO', 'BS'),
    'D422': ('ERCHIE', 'BR'),
    'D423': ('ERICE', 'TP'),
    'D424': ('ERLI', 'SV'),
    'D426': ('ERTO E CASSO', 'PN'),
    'D428': ('ERVE', 'LC'),
    'D429': ('ESANATOGLIA', 'MC'),
    'D430': ('ESCALAPLANO', 'SU'),
    'D431': ('ESCOLCA', 'SU'),
    'D433': ('EXILLES', 'TO'),
    'D434': ('ESINE', 'BS'),
    'D436': ('ESINO LARIO', 'LC'),
    'D440': ('ESPERIA', 'FR'),
    'D441': ('ESPORLATU', 'SS'),
    'D442': ('ESTE', 'PD'),
    'D443': ('ESTERZILI', 'SU'),
    'D444': ('ETROUBLES', 'AO'),
    'D445': ('EUPILIO', 'CO'),
    'D447': ('FABBRICA CURONE', 'AL'),
    'D450': ('FABBRICO', 'RE'),
    'D451': ('FABRIANO', 'AN'),
    'D452': ('FABRICA DI ROMA', 'VT'),
    'D453': ('FABRIZIA', 'VV'),
    'D454': ('FABRO', 'TR'),
    'D455': ('FAEDIS', 'UD'),
    'D456': ('FAEDO VALTELLINO', 'SO'),
    'D458': ('FAENZA', 'RA'),
    'D459': ('FAETO', 'FG'),
    'D461': ('FAGAGNA', 'UD'),
    'D462': ('FAGGETO LARIO', 'CO'),
    'D463': ('FAGGIANO', 'TA'),
    'D464': ('FAGNANO CASTELLO', 'CS'),
    'D465': ('FAGNANO ALTO', 'AQ'),
    'D467': ('FAGNANO OLONA', 'VA'),
    'D468': ('FAI DELLA PAGANELLA', 'TN'),
    'D469': ('FAICCHIO', 'BN'),
    'D470': ('FALCADE', 'BL'),
    'D471': ('FALCIANO DEL MASSICO', 'CE'),
    'D472': ('FALCONARA MARITTIMA', 'AN'),
    'D473': ('FALCONARA ALBANESE', 'CS'),
    'D474': ('FALCONE', 'ME'),
    'D475': ('FALERIA', 'VT'),
    'D476': ('FALERNA', 'CZ'),
    'D477': ('FALERONE', 'FM'),
    'D480': ('FALLO', 'CH'),
    'D482': ('FALOPPIO', 'CO'),
    'D483': ('FALVATERRA', 'FR'),
    'D484': ('FALZES/PFALZEN', 'BZ'),
    'D486': ('FANANO', 'MO'),
    'D487': ('FANNA', 'PN'),
    'D488': ('FANO', 'PU'),
    'D489': ('FANO ADRIANO', 'TE'),
    'D490': ("FARA GERA D'ADDA", 'BG'),
    'D491': ('FARA OLIVANA CON SOLA', 'BG'),
    'D492': ('FARA NOVARESE', 'NO'),
    'D493': ('FARA IN SABINA', 'RI'),
    'D494': ('FARA FILIORUM PETRI', 'CH'),
    'D495': ('FARA SAN MARTINO', 'CH'),
    'D496': ('FARA VICENTINO', 'VI'),
    'D497': ('FARDELLA', 'PZ'),
    'D499': ('FARIGLIANO', 'CN'),
    'D501': ('FARINDOLA', 'PE'),
    'D502': ('FARINI', 'PC'),
    'D503': ('FARNESE', 'VT'),
    'D504': ("FARRA D'ISONZO", 'GO'),
    'D505': ('FARRA DI SOLIGO', 'TV'),
    'D508': ('FASANO', 'BR'),
    'D509': ('FASCIA', 'GE'),
    'D510': ('FAUGLIA', 'PI'),
    'D511': ('FAULE', 'CN'),
    'D512': ('FAVALE DI MALVARO', 'GE'),
    'D513': ('VALSINNI', 'MT'),
    'D514': ('FAVARA', 'AG'),
    'D518': ('FAVIGNANA', 'TP'),
    'D520': ('FAVRIA', 'TO'),
    'D522': ('ORCO FEGLINO', 'SV'),
    'D523': ('FEISOGLIO', 'CN'),
    'D524': ('FELETTO', 'TO'),
    'D526': ('FELINO', 'PR'),
    'D527': ('FELITTO', 'SA'),
    'D528': ('FELIZZANO', 'AL'),
    'D530': ('FELTRE', 'BL'),
    'D531': ('FENEGRÒ', 'CO'),
    'D532': ('FENESTRELLE', 'TO'),
    'D537': ('FÉNIS', 'AO'),
    'D538': ('FERENTILLO', 'TR'),
    'D539': ('FERENTINO', 'FR'),
    'D540': ('FERLA', 'SR'),
    'D541': ('FERMIGNANO', 'PU'),
    'D542': ('FERMO', 'FM'),
    'D543': ('FERNO', 'VA'),
    'D544': ('FEROLETO ANTICO', 'CZ'),
    'D545': ('FEROLETO DELLA CHIESA', 'RC'),
    'D546': ('PIANOPOLI', 'CZ'),
    'D547': ('FERRANDINA', 'MT'),
    'D548': ('FERRARA', 'FE'),
    'D549': ('FERRARA DI MONTE BALDO', 'VR'),
    'D550': ('FERRAZZANO', 'CB'),
    'D551': ('FERRERA DI VARESE', 'VA'),
    'D552': ('FERRERA ERBOGNONE', 'PV'),
    'D553': ('MONCENISIO', 'TO'),
    'D554': ('FERRERE', 'AT'),
    'D555': ('FERRIERE', 'PC'),
    'D557': ('FERRUZZANO', 'RC'),
    'D559': ('FRACONALTO', 'AL'),
    'D560': ('FIAMIGNANO', 'RI'),
    'D561': ('FIANO ROMANO', 'RM'),
    'D562': ('FIANO', 'TO'),
    'D564': ('FIASTRA', 'MC'),
    'D565': ('FIAVÈ', 'TN'),
    'D566': ('POGGIO SAN VICINO', 'MC'),
    'D567': ('FICARAZZI', 'PA'),
    'D568': ('FICAROLO', 'RO'),
    'D569': ('FICARRA', 'ME'),
    'D570': ('FICULLE', 'TR'),
    'D571': ('FIÈ ALLO SCILIAR/VÖLS AM SCHLERN', 'BZ'),
    'D573': ('FIEROZZO', 'TN'),
    'D574': ('FIESCO', 'CR'),
    'D575': ('FIESOLE', 'FI'),
    'D576': ('FIESSE', 'BS'),
    'D577': ('FIESSO UMBERTIANO', 'RO'),
    'D578': ("FIESSO D'ARTICO", 'VE'),
    'D579': ('FIGINO SERENZA', 'CO'),
    'D582': ('FIGLINE VEGLIATURO', 'CS'),
    'D585': ('GONNOSNÒ', 'OR'),
    'D586': ('FILACCIANO', 'RM'),
    'D587': ('FILADELFIA', 'VV'),
    'D588': ('FILAGO', 'BG'),
    'D589': ('FILANDARI', 'VV'),
    'D590': ('FILATTIERA', 'MS'),
    'D591': ('FILETTINO', 'FR'),
    'D592': ('FILETTO', 'CH'),
    'D593': ('FILIANO', 'PZ'),
    'D594': ('FILIGHERA', 'PV'),
    'D595': ('FILIGNANO', 'IS'),
    'D596': ('FILOGASO', 'VV'),
    'D597': ('FILOTTRANO', 'AN'),
    'D599': ('FINALE EMILIA', 'MO'),
    'D600': ('FINALE LIGURE', 'SV'),
    'D604': ('FINO DEL MONTE', 'BG'),
    'D605': ('FINO MORNASCO', 'CO'),
    'D606': ('FIORANO AL SERIO', 'BG'),
    'D607': ('FIORANO MODENESE', 'MO'),
    'D608': ('FIORANO CANAVESE', 'TO'),
    'D611': ("FIORENZUOLA D'ARDA", 'PC'),
    'D612': ('FIRENZE', 'FI'),
    'D613': ('FIRENZUOLA', 'FI'),
    'D614': ('FIRMO', 'CS'),
    'D615': ('FISCIANO', 'SA'),
    'D617': ('FIUMALBO', 'MO'),
    'D619': ('FIUMARA', 'RC'),
    'D621': ('FIUME VENETO', 'PN'),
    'D622': ('FIUMEDINISI', 'ME'),
    'D623': ('FIUMEFREDDO DI SICILIA', 'CT'),
    'D624': ('FIUMEFREDDO BRUZIO', 'CS'),
    'D628': ('FIUMINATA', 'MC'),
    'D629': ('FIVIZZANO', 'MS'),
    'D630': ('FLAIBANO', 'UD'),
    'D634': ('FLERO', 'BS'),
    'D635': ('FLORESTA', 'ME'),
    'D636': ('FLORIDIA', 'SR'),
    'D637': ('FLORINAS', 'SS'),
    'D638': ('FLUMERI', 'AV'),
    'D639': ('FLUMINIMAGGIORE', 'SU'),
    'D640': ('FLUSSIO', 'OR'),
    'D641': ('FOBELLO', 'VC'),
    'D643': ('FOGGIA', 'FG'),
    'D644': ('FOGLIANISE', 'BN'),
    'D645': ('FOGLIANO REDIPUGLIA', 'GO'),
    'D646': ('FOGLIZZO', 'TO'),
    'D649': ('FOIANO DELLA CHIANA', 'AR'),
    'D650': ('FOIANO DI VAL FORTORE', 'BN'),
    'D651': ('FOLGARIA', 'TN'),
    'D652': ('FOLIGNANO', 'AP'),
    'D653': ('FOLIGNO', 'PG'),
    'D654': ('FOLLINA', 'TV'),
    'D655': ('FOLLO', 'SP'),
    'D656': ('FOLLONICA', 'GR'),
    'D660': ('FOMBIO', 'LO'),
    'D661': ('FONDACHELLI-FANTINA', 'ME'),
    'D662': ('FONDI', 'LT'),
    'D665': ('FONNI', 'NU'),
    'D666': ('FONTAINEMORE', 'AO'),
    'D667': ('FONTANA LIRI', 'FR'),
    'D668': ('FONTANELICE', 'BO'),
    'D670': ('FONTANAFREDDA', 'PN'),
    'D671': ('FONTANAROSA', 'AV'),
    'D672': ('FONTANELLA', 'BG'),
    'D673': ('FONTANELLATO', 'PR'),
    'D674': ('FONTANELLE', 'TV'),
    'D675': ("FONTANETO D'AGOGNA", 'NO'),
    'D676': ('FONTANETTO PO', 'VC'),
    'D677': ('FONTANIGORDA', 'GE'),
    'D678': ('FONTANILE', 'AT'),
    'D679': ('FONTANIVA', 'PD'),
    'D680': ('FONTE', 'TV'),
    'D681': ('FONTECCHIO', 'AQ'),
    'D682': ('FONTECHIARI', 'FR'),
    'D683': ('FONTEGRECA', 'CE'),
    'D684': ('FONTENO', 'BG'),
    'D685': ('FONTEVIVO', 'PR'),
    'D686': ('FONZASO', 'BL'),
    'D688': ('FOPPOLO', 'BG'),
    'D689': ('FORANO', 'RI'),
    'D690': ('SAN GIOVANNI TEATINO', 'CH'),
    'D691': ('FORCE', 'AP'),
    'D693': ('FORCHIA', 'BN'),
    'D694': ('FORCOLA', 'SO'),
    'D695': ('FORDONGIANUS', 'OR'),
    'D696': ('FORENZA', 'PZ'),
    'D697': ('FORESTO SPARSO', 'BG'),
    'D700': ('FORGARIA NEL FRIULI', 'UD'),
    'D701': ('FORINO', 'AV'),
    'D702': ('FORIO', 'NA'),
    'D703': ('FORLÌ DEL SANNIO', 'IS'),
    'D704': ('FORLÌ', 'FC'),
    'D705': ('FORLIMPOPOLI', 'FC'),
    'D706': ('FORMAZZA', 'VB'),
    'D707': ('FORMELLO', 'RM'),
    'D708': ('FORMIA', 'LT'),
    'D709': ('FORMICOLA', 'CE'),
    'D710': ('FORMIGARA', 'CR'),
    'D711': ('FORMIGINE', 'MO'),
    'D712': ('FORMIGLIANA', 'VC'),
    'D714': ('FORNACE', 'TN'),
    'D715': ('FORNELLI', 'IS'),
    'D717': ('TONEZZA DEL CIMONE', 'VI'),
    'D718': ('FORNI AVOLTRI', 'UD'),
    'D719': ('FORNI DI SOPRA', 'UD'),
    'D720': ('FORNI DI SOTTO', 'UD'),
    'D725': ('FORNO CANAVESE', 'TO'),
    'D727': ('FORNOVO SAN GIOVANNI', 'BG'),
    'D728': ('FORNOVO DI TARO', 'PR'),
    'D730': ('FORTE DEI MARMI', 'LU'),
    'D731': ('FORTEZZA/FRANZENSFESTE', 'BZ'),
    'D732': ('FORTUNAGO', 'PV'),
    'D733': ("FORZA D'AGRÒ", 'ME'),
    'D734': ('FOSCIANDORA', 'LU'),
    'D735': ('FOSDINOVO', 'MS'),
    'D736': ('FOSSA', 'AQ'),
    'D737': ('FOSSALTO', 'CB'),
    'D738': ('FOSSACESIA', 'CH'),
    'D740': ('FOSSALTA DI PIAVE', 'VE'),
    'D741': ('FOSSALTA DI PORTOGRUARO', 'VE'),
    'D742': ('FOSSANO', 'CN'),
    'D744': ('FOSSATO SERRALTA', 'CZ'),
    'D745': ('FOSSATO DI VICO', 'PG'),
    'D746': ('MONTEBELLO JONICO', 'RC'),
    'D748': ('FOSSÒ', 'VE'),
    'D749': ('FOSSOMBRONE', 'PU'),
    'D750': ('FOZA', 'VI'),
    'D751': ('FRABOSA SOPRANA', 'CN'),
    'D752': ('FRABOSA SOTTANA', 'CN'),
    'D754': ('FRAGAGNANO', 'TA'),
    'D755': ("FRAGNETO L'ABATE", 'BN'),
    'D756': ('FRAGNETO MONFORTE', 'BN'),
    'D757': ('FRAINE', 'CH'),
    'D758': ('FRAMURA', 'SP'),
    'D759': ('FRANCAVILLA BISIO', 'AL'),
    'D760': ("FRANCAVILLA D'ETE", 'FM'),
    'D761': ('FRANCAVILLA FONTANA', 'BR'),
    'D762': ('FRANCAVILLA ANGITOLA', 'VV'),
    'D763': ('FRANCAVILLA AL MARE', 'CH'),
    'D764': ('FRANCAVILLA MARITTIMA', 'CS'),
    'D765': ('FRANCAVILLA DI SICILIA', 'ME'),
    'D766': ('FRANCAVILLA IN SINNI', 'PZ'),
    'D767': ('FRANCICA', 'VV'),
    'D768': ('FRANCOFONTE', 'SR'),
    'D769': ('FRANCOLISE', 'CE'),
    'D770': ('FRASCARO', 'AL'),
    'D771': ('FRASCAROLO', 'PV'),
    'D773': ('FRASCATI', 'RM'),
    'D774': ('FRASCINETO', 'CS'),
    'D775': ('FRASSILONGO', 'TN'),
    'D776': ('FRASSINELLE POLESINE', 'RO'),
    'D777': ('FRASSINELLO MONFERRATO', 'AL'),
    'D780': ('FRASSINETO PO', 'AL'),
    'D781': ('FRASSINETTO', 'TO'),
    'D782': ('FRASSINO', 'CN'),
    'D783': ('FRASSINORO', 'MO'),
    'D784': ('FRASSO TELESINO', 'BN'),
    'D785': ('FRASSO SABINO', 'RI'),
    'D786': ('UMBERTIDE', 'PG'),
    'D787': ('FRATTA TODINA', 'PG'),
    'D788': ('FRATTA POLESINE', 'RO'),
    'D789': ('FRATTAMAGGIORE', 'NA'),
    'D790': ('FRATTAMINORE', 'NA'),
    'D791': ('FRATTE ROSA', 'PU'),
    'D793': ('FRAZZANÒ', 'ME'),
    'D794': ('FREGONA', 'TV'),
    'D796': ('FRESAGRANDINARIA', 'CH'),
    'D797': ('FRESONARA', 'AL'),
    'D798': ('FRIGENTO', 'AV'),
    'D799': ('FRIGNANO', 'CE'),
    'D801': ('VILLA DI BRIANO', 'CE'),
    'D802': ('FRINCO', 'AT'),
    'D803': ('FRISA', 'CH'),
    'D804': ('FRISANCO', 'PN'),
    'D805': ('FRONT', 'TO'),
    'D807': ('FRONTINO', 'PU'),
    'D808': ('FRONTONE', 'PU'),
    'D810': ('FROSINONE', 'FR'),
    'D811': ('FROSOLONE', 'IS'),
    'D812': ('FROSSASCO', 'TO'),
    'D813': ('FRUGAROLO', 'AL'),
    'D814': ('FUBINE MONFERRATO', 'AL'),
    'D815': ('FUCECCHIO', 'FI'),
    'D817': ('FUIPIANO VALLE IMAGNA', 'BG'),
    'D818': ('FUMANE', 'VR'),
    'D819': ('FUMONE', 'FR'),
    'D821': ('FUNES/VILLNÖSS', 'BZ'),
    'D823': ('FURCI', 'CH'),
    'D824': ('FURCI SICULO', 'ME'),
    'D825': ('FURNARI', 'ME'),
    'D826': ('FURORE', 'SA'),
    'D827': ('FURTEI', 'SU'),
    'D828': ('FUSCALDO', 'CS'),
    'D829': ('FUSIGNANO', 'RA'),
    'D830': ('FUSINE', 'SO'),
    'D832': ('FUTANI', 'SA'),
    'D834': ('GABBIONETA-BINANUOVA', 'CR'),
    'D835': ('GABIANO', 'AL'),
    'D836': ('GABICCE MARE', 'PU'),
    'D839': ('GABY', 'AO'),
    'D841': ('GADESCO-PIEVE DELMONA', 'CR'),
    'D842': ('GADONI', 'NU'),
    'D843': ('GAETA', 'LT'),
    'D844': ('GAGGI', 'ME'),
    'D845': ('GAGGIANO', 'MI'),
    'D847': ('GAGGIO MONTANO', 'BO'),
    'D848': ('GAGLIANICO', 'BI'),
    'D849': ('GAGLIANO CASTELFERRATO', 'EN'),
    'D850': ('GAGLIANO ATERNO', 'AQ'),
    'D851': ('GAGLIANO DEL CAPO', 'LE'),
    'D852': ('GAGLIATO', 'CZ'),
    'D853': ('GAGLIOLE', 'MC'),
    'D854': ('GAIARINE', 'TV'),
    'D855': ('GAIBA', 'RO'),
    'D856': ('GAIOLA', 'CN'),
    'D858': ('GAIOLE IN CHIANTI', 'SI'),
    'D859': ('GAIRO', 'NU'),
    'D860': ('GAIS/GAIS', 'BZ'),
    'D861': ('GALATI MAMERTINO', 'ME'),
    'D862': ('GALATINA', 'LE'),
    'D863': ('GALATONE', 'LE'),
    'D864': ('GALATRO', 'RC'),
    'D865': ('GALBIATE', 'LC'),
    'D867': ('GALEATA', 'FC'),
    'D868': ('GALGAGNANO', 'LO'),
    'D869': ('GALLARATE', 'VA'),
    'D870': ('GALLESE', 'VT'),
    'D871': ('GALLIATE LOMBARDO', 'VA'),
    'D872': ('GALLIATE', 'NO'),
    'D873': ('GALLIAVOLA', 'PV'),
    'D874': ('GALLICANO', 'LU'),
    'D875': ('GALLICANO NEL LAZIO', 'RM'),
    'D876': ('GALLICCHIO', 'PZ'),
    'D878': ('GALLIERA', 'BO'),
    'D879': ('GALLIERA VENETA', 'PD'),
    'D881': ('GALLINARO', 'FR'),
    'D882': ('GALLIO', 'VI'),
    'D883': ('GALLIPOLI', 'LE'),
    'D884': ('GALLO MATESE', 'CE'),
    'D885': ('GALLODORO', 'ME'),
    'D886': ('GALLUCCIO', 'CE'),
    'D888': ('GALTELLÌ', 'NU'),
    'D889': ('GALZIGNANO TERME', 'PD'),
    'D890': ('GAMALERO', 'AL'),
    'D891': ('GAMBARA', 'BS'),
    'D892': ('GAMBARANA', 'PV'),
    'D894': ('GAMBASCA', 'CN'),
    'D895': ('GAMBASSI TERME', 'FI'),
    'D896': ('GAMBATESA', 'CB'),
    'D897': ('GAMBELLARA', 'VI'),
    'D898': ('GAMBERALE', 'CH'),
    'D899': ('GAMBETTOLA', 'FC'),
    'D901': ('GAMBOLÒ', 'PV'),
    'D902': ('GAMBUGLIANO', 'VI'),
    'D903': ('GANDELLINO', 'BG'),
    'D905': ('GANDINO', 'BG'),
    'D906': ('GANDOSSO', 'BG'),
    'D907': ('GANGI', 'PA'),
    'D909': ('GARAGUSO', 'MT'),
    'D910': ('GARBAGNA', 'AL'),
    'D911': ('GARBAGNA NOVARESE', 'NO'),
    'D912': ('GARBAGNATE MILANESE', 'MI'),
    'D913': ('GARBAGNATE MONASTERO', 'LC'),
    'D915': ('GARDA', 'VR'),
    'D917': ('GARDONE RIVIERA', 'BS'),
    'D918': ('GARDONE VAL TROMPIA', 'BS'),
    'D920': ('GARESSIO', 'CN'),
    'D921': ('GARGALLO', 'NO'),
    'D923': ('GARGAZZONE/GARGAZON', 'BZ'),
    'D924': ('GARGNANO', 'BS'),
    'D925': ('GARLASCO', 'PV'),
    'D926': ('GARLATE', 'LC'),
    'D927': ('GARLENDA', 'SV'),
    'D928': ('GARNIGA TERME', 'TN'),
    'D930': ('GARZENO', 'CO'),
    'D931': ('GARZIGLIANA', 'TO'),
    'D932': ('GASPERINA', 'CZ'),
    'D933': ('GASSINO TORINESE', 'TO'),
    'D934': ('GATTATICO', 'RE'),
    'D935': ('GATTEO', 'FC'),
    'D938': ('GATTINARA', 'VC'),
    'D940': ('GAVARDO', 'BS'),
    'D942': ('GAVELLO', 'RO'),
    'D943': ('GAVERINA TERME', 'BG'),
    'D944': ('GAVI', 'AL'),
    'D945': ('GAVIGNANO', 'RM'),
    'D946': ('GAVIRATE', 'VA'),
    'D947': ('GAVOI', 'NU'),
    'D948': ('GAVORRANO', 'GR'),
    'D949': ('GAZOLDO DEGLI IPPOLITI', 'MN'),
    'D951': ('GAZZADA SCHIANNO', 'VA'),
    'D952': ('GAZZANIGA', 'BG'),
    'D956': ('GAZZO', 'PD'),
    'D957': ('GAZZO VERONESE', 'VR'),
    'D958': ('GAZZOLA', 'PC'),
    'D959': ('GAZZUOLO', 'MN'),
    'D960': ('GELA', 'CL'),
    'D961': ('GEMMANO', 'RN'),
    'D962': ('GEMONA DEL FRIULI', 'UD'),
    'D963': ('GEMONIO', 'VA'),
    'D964': ('GENAZZANO', 'RM'),
    'D965': ('GENGA', 'AN'),
    'D966': ('GENIVOLTA', 'CR'),
    'D967': ('GENOLA', 'CN'),
    'D968': ('GENONI', 'SU'),
    'D969': ('GENOVA', 'GE'),
    'D970': ('GENURI', 'SU'),
    'D971': ('GENZANO DI LUCANIA', 'PZ'),
    'D972': ('GENZANO DI ROMA', 'RM'),
    'D974': ('GERA LARIO', 'CO'),
    'D975': ('GERACE', 'RC'),
    'D976': ('LOCRI', 'RC'),
    'D977': ('GERACI SICULO', 'PA'),
    'D978': ('GERANO', 'RM'),
    'D980': ('GERENZAGO', 'PV'),
    'D981': ('GERENZANO', 'VA'),
    'D982': ('GERGEI', 'SU'),
    'D983': ('GERMAGNANO', 'TO'),
    'D984': ('GERMAGNO', 'VB'),
    'D987': ('GERMIGNAGA', 'VA'),
    'D988': ('GEROCARNE', 'VV'),
    'D990': ('GEROLA ALTA', 'SO'),
    'D993': ("GERRE DE' CAPRIOLI", 'CR'),
    'D994': ('GESICO', 'SU'),
    'D995': ('GESSATE', 'MI'),
    'D996': ('GESSOPALENA', 'CH'),
    'D997': ('GESTURI', 'SU'),
    'D998': ('GESUALDO', 'AV'),
    'D999': ('GHEDI', 'BS'),
    'E001': ('GHEMME', 'NO'),
    'E003': ('GHIFFA', 'VB'),
    'E004': ('GHILARZA', 'OR'),
    'E006': ('GHISALBA', 'BG'),
    'E007': ('GHISLARENGO', 'VC'),
    'E008': ('GIACCIANO CON BARUCHELLA', 'RO'),
    'E009': ('GIAGLIONE', 'TO'),
    'E010': ('GIANICO', 'BS'),
    'E011': ('GIANO VETUSTO', 'CE'),
    'E012': ("GIANO DELL'UMBRIA", 'PG'),
    'E013': ('GIARDINELLO', 'PA'),
    'E014': ('GIARDINI-NAXOS', 'ME'),
    'E015': ('GIAROLE', 'AL'),
    'E016': ('GIARRATANA', 'RG'),
    'E017': ('GIARRE', 'CT'),
    'E019': ('GIAVE', 'SS'),
    'E020': ('GIAVENO', 'TO'),
    'E021': ('GIAVERA DEL MONTELLO', 'TV'),
    'E022': ('GIBA', 'SU'),
    'E023': ('GIBELLINA', 'TP'),
    'E024': ('GIFFLENGA', 'BI'),
    'E025': ('GIFFONE', 'RC'),
    'E026': ('GIFFONI SEI CASALI', 'SA'),
    'E027': ('GIFFONI VALLE PIANA', 'SA'),
    'E028': ('GIGNESE', 'VB'),
    'E029': ('GIGNOD', 'AO'),
    'E030': ('GILDONE', 'CB'),
    'E031': ('GIMIGLIANO', 'CZ'),
    'E033': ('GINESTRA', 'PZ'),
    'E034': ('GINESTRA DEGLI SCHIAVONI', 'BN'),
    'E036': ('GINOSA', 'TA'),
    'E037': ('GIOI', 'SA'),
    'E038': ('GIOIA DEL COLLE', 'BA'),
    'E039': ('GIOIA SANNITICA', 'CE'),
    'E040': ('GIOIA DEI MARSI', 'AQ'),
    'E041': ('GIOIA TAURO', 'RC'),
    'E043': ('GIOIOSA MAREA', 'ME'),
    'E044': ('GIOIOSA IONICA', 'RC'),
    'E045': ('GIOVE', 'TR'),
    'E047': ('GIOVINAZZO', 'BA'),
    'E048': ('GIOVO', 'TN'),
    'E049': ('GIRASOLE', 'NU'),
    'E050': ('GIRIFALCO', 'CZ'),
    'E052': ('GISSI', 'CH'),
    'E053': ('GIUGGIANELLO', 'LE'),
    'E054': ('GIUGLIANO IN CAMPANIA', 'NA'),
    'E055': ('GIULIANA', 'PA'),
    'E056': ('GIULIANO TEATINO', 'CH'),
    'E057': ('GIULIANO DI ROMA', 'FR'),
    'E058': ('GIULIANOVA', 'TE'),
    'E060': ('GIUNGANO', 'SA'),
    'E061': ('GIURDIGNANO', 'LE'),
    'E062': ('GIUSSAGO', 'PV'),
    'E063': ('GIUSSANO', 'MB'),
    'E064': ('GIUSTENICE', 'SV'),
    'E065': ('GIUSTINO', 'TN'),
    'E066': ('GIUSVALLA', 'SV'),
    'E067': ('GIVOLETTO', 'TO'),
    'E068': ('GIZZERIA', 'CZ'),
    'E069': ('GLORENZA/GLURNS', 'BZ'),
    'E070': ('SESTA GODANO', 'SP'),
    'E071': ("GODEGA DI SANT'URBANO", 'TV'),
    'E072': ('GODIASCO SALICE TERME', 'PV'),
    'E074': ('GODRANO', 'PA'),
    'E078': ('GOITO', 'MN'),
    'E079': ('GOLASECCA', 'VA'),
    'E081': ('GOLFERENZO', 'PV'),
    'E082': ('GOMBITO', 'CR'),
    'E083': ('GONARS', 'UD'),
    'E084': ('GONI', 'SU'),
    'E085': ('GONNOSFANADIGA', 'SU'),
    'E086': ('GONNESA', 'SU'),
    'E087': ('GONNOSCODINA', 'OR'),
    'E088': ('GONNOSTRAMATZA', 'OR'),
    'E089': ('GONZAGA', 'MN'),
    'E090': ('GORDONA', 'SO'),
    'E091': ('GORGA', 'RM'),
    'E092': ('GORGO AL MONTICANO', 'TV'),
    'E093': ('GORGOGLIONE', 'MT'),
    'E094': ('GORGONZOLA', 'MI'),
    'E096': ('GORIANO SICOLI', 'AQ'),
    'E098': ('GORIZIA', 'GO'),
    'E100': ('GORLAGO', 'BG'),
    'E101': ('GORLA MAGGIORE', 'VA'),
    'E102': ('GORLA MINORE', 'VA'),
    'E103': ('GORLE', 'BG'),
    'E104': ('GORNATE OLONA', 'VA'),
    'E106': ('GORNO', 'BG'),
    'E107': ('GORO', 'FE'),
    'E109': ('GORRETO', 'GE'),
    'E111': ('GORZEGNO', 'CN'),
    'E113': ('GOSALDO', 'BL'),
    'E114': ('GOSSOLENGO', 'PC'),
    'E115': ('GOTTASECCA', 'CN'),
    'E116': ('GOTTOLENGO', 'BS'),
    'E118': ('GOVONE', 'CN'),
    'E120': ('GOZZANO', 'NO'),
    'E122': ('GRADARA', 'PU'),
    'E124': ("GRADISCA D'ISONZO", 'GO'),
    'E125': ('GRADO', 'GO'),
    'E126': ('GRADOLI', 'VT'),
    'E127': ('GRAFFIGNANA', 'LO'),
    'E128': ('GRAFFIGNANO', 'VT'),
    'E130': ('GRAGLIA', 'BI'),
    'E131': ('GRAGNANO', 'NA'),
    'E132': ('GRAGNANO TREBBIENSE', 'PC'),
    'E133': ('GRAMMICHELE', 'CT'),
    'E134': ('GRANA', 'AT'),
    'E136': ("GRANAROLO DELL'EMILIA", 'BO'),
    'E139': ('GRANDATE', 'CO'),
    'E141': ('GRANDOLA ED UNITI', 'CO'),
    'E142': ('GRANITI', 'ME'),
    'E143': ('GRANOZZO CON MONTICELLO', 'NO'),
    'E144': ('GRANTOLA', 'VA'),
    'E145': ('GRANTORTO', 'PD'),
    'E146': ('GRANZE', 'PD'),
    'E147': ('GRASSANO', 'MT'),
    'E148': ('GRASSOBBIO', 'BG'),
    'E149': ('GRATTERI', 'PA'),
    'E152': ('GRAVELLONA LOMELLINA', 'PV'),
    'E153': ('GRAVELLONA TOCE', 'VB'),
    'E154': ('GRAVERE', 'TO'),
    'E155': ('GRAVINA IN PUGLIA', 'BA'),
    'E156': ('GRAVINA DI CATANIA', 'CT'),
    'E158': ('GRAZZANISE', 'CE'),
    'E159': ('GRAZZANO BADOGLIO', 'AT'),
    'E160': ('GRECCIO', 'RI'),
    'E161': ('GRECI', 'AV'),
    'E163': ('GREGGIO', 'VC'),
    'E164': ('GREMIASCO', 'AL'),
    'E165': ('GRESSAN', 'AO'),
    'E167': ('GRESSONEY-LA-TRINITÉ', 'AO'),
    'E168': ('GRESSONEY-SAINT-JEAN', 'AO'),
    'E169': ('GREVE IN CHIANTI', 'FI'),
    'E170': ('GREZZAGO', 'MI'),
    'E171': ('GREZZANA', 'VR'),
    'E172': ('GRIANTE', 'CO'),
    'E173': ('GRICIGNANO DI AVERSA', 'CE'),
    'E177': ('GRIGNASCO', 'NO'),
    'E178': ('GRIGNO', 'TN'),
    'E179': ('GRIMACCO', 'UD'),
    'E180': ('GRIMALDI', 'CS'),
    'E182': ('GRINZANE CAVOUR', 'CN'),
    'E184': ('GRISIGNANO DI ZOCCO', 'VI'),
    'E185': ('GRISOLIA', 'CS'),
    'E187': ('GRIZZANA MORANDI', 'BO'),
    'E188': ('GROGNARDO', 'AL'),
    'E189': ('GROMO', 'BG'),
    'E191': ('GRONDONA', 'AL'),
    'E192': ('GRONE', 'BG'),
    'E193': ('GRONTARDO', 'CR'),
    'E195': ('GROPELLO CAIROLI', 'PV'),
    'E196': ('GROPPARELLO', 'PC'),
    'E199': ('GROSCAVALLO', 'TO'),
    'E200': ('GROSIO', 'SO'),
    'E201': ('GROSOTTO', 'SO'),
    'E202': ('GROSSETO', 'GR'),
    'E203': ('GROSSO', 'TO'),
    'E204': ('GROTTAFERRATA', 'RM'),
    'E205': ('GROTTAGLIE', 'TA'),
    'E206': ('GROTTAMINARDA', 'AV'),
    'E207': ('GROTTAMMARE', 'AP'),
    'E208': ('GROTTAZZOLINA', 'FM'),
    'E209': ('GROTTE', 'AG'),
    'E210': ('GROTTE DI CASTRO', 'VT'),
    'E212': ('GROTTERIA', 'RC'),
    'E213': ('GROTTOLE', 'MT'),
    'E214': ('GROTTOLELLA', 'AV'),
    'E215': ('GRUARO', 'VE'),
    'E216': ('GRUGLIASCO', 'TO'),
    'E217': ('GRUMELLO CREMONESE ED UNITI', 'CR'),
    'E219': ('GRUMELLO DEL MONTE', 'BG'),
    'E221': ('GRUMENTO NOVA', 'PZ'),
    'E223': ('GRUMO APPULA', 'BA'),
    'E224': ('GRUMO NEVANO', 'NA'),
    'E226': ('GRUMOLO DELLE ABBADESSE', 'VI'),
    'E227': ('GUAGNANO', 'LE'),
    'E228': ('GUALDO', 'MC'),
    'E229': ('GUALDO CATTANEO', 'PG'),
    'E230': ('GUALDO TADINO', 'PG'),
    'E232': ('GUALTIERI', 'RE'),
    'E233': ('GUALTIERI SICAMINÒ', 'ME'),
    'E234': ('GUAMAGGIORE', 'SU'),
    'E235': ('GUANZATE', 'CO'),
    'E236': ('GUARCINO', 'FR'),
    'E237': ('GUARDABOSONE', 'VC'),
    'E238': ('GUARDAMIGLIO', 'LO'),
    'E239': ('GUARDAVALLE', 'CZ'),
    'E240': ('GUARDA VENETA', 'RO'),
    'E241': ('GUARDEA', 'TR'),
    'E242': ('GUARDIA PIEMONTESE', 'CS'),
    'E243': ('GUARDIAGRELE', 'CH'),
    'E244': ('GUARDIALFIERA', 'CB'),
    'E245': ('GUARDIA LOMBARDI', 'AV'),
    'E246': ('GUARDIA PERTICARA', 'PZ'),
    'E248': ('GUARDIAREGIA', 'CB'),
    'E249': ('GUARDIA SANFRAMONDI', 'BN'),
    'E250': ('GUARDISTALLO', 'PI'),
    'E251': ('GUARENE', 'CN'),
    'E252': ('GUASILA', 'SU'),
    'E253': ('GUASTALLA', 'RE'),
    'E255': ('GUAZZORA', 'AL'),
    'E256': ('GUBBIO', 'PG'),
    'E258': ('GUDO VISCONTI', 'MI'),
    'E259': ('GUGLIONESI', 'CB'),
    'E261': ('GUIDIZZOLO', 'MN'),
    'E263': ('GUIDONIA MONTECELIO', 'RM'),
    'E264': ('GUIGLIA', 'MO'),
    'E265': ('SIZIANO', 'PV'),
    'E266': ('GUILMI', 'CH'),
    'E269': ('GURRO', 'VB'),
    'E270': ('GUSPINI', 'SU'),
    'E271': ('GUSSAGO', 'BS'),
    'E272': ('GUSSOLA', 'CR'),
    'E273': ('HÔNE', 'AO'),
    'E274': ('JACURSO', 'CZ'),
    'E280': ('IDRO', 'BS'),
    'E281': ('IGLESIAS', 'SU'),
    'E282': ('IGLIANO', 'CN'),
    'E283': ('ILBONO', 'NU'),
    'E284': ('ILLASI', 'VR'),
    'E285': ('ILLORAI', 'SS'),
    'E287': ('IMBERSAGO', 'LC'),
    'E288': ('IMER', 'TN'),
    'E289': ('IMOLA', 'BO'),
    'E290': ('IMPERIA', 'IM'),
    'E291': ('IMPRUNETA', 'FI'),
    'E292': ('INARZO', 'VA'),
    'E295': ('INCISA SCAPACCINO', 'AT'),
    'E297': ('INCUDINE', 'BS'),
    'E299': ('INDUNO OLONA', 'VA'),
    'E301': ('INGRIA', 'TO'),
    'E304': ('INTRAGNA', 'VB'),
    'E305': ('INTROBIO', 'LC'),
    'E306': ('INTROD', 'AO'),
    'E307': ('INTRODACQUA', 'AQ'),
    'E309': ('INVERIGO', 'CO'),
    'E310': ('INVERNO E MONTELEONE', 'PV'),
    'E311': ('INVERSO PINASCA', 'TO'),
    'E313': ('INVERUNO', 'MI'),
    'E314': ('INVORIO', 'NO'),
    'E317': ('INZAGO', 'MI'),
    'E320': ('JOLANDA DI SAVOIA', 'FE'),
    'E321': ('IONADI', 'VV'),
    'E323': ('IRGOLI', 'NU'),
    'E325': ('IRMA', 'BS'),
    'E326': ('IRSINA', 'MT'),
    'E327': ('ISASCA', 'CN'),
    'E328': ('ISCA SULLO IONIO', 'CZ'),
    'E329': ('ISCHIA', 'NA'),
    'E330': ('ISCHIA DI CASTRO', 'VT'),
    'E332': ('ISCHITELLA', 'FG'),
    'E333': ('ISEO', 'BS'),
    'E334': ('ISERA', 'TN'),
    'E335': ('ISERNIA', 'IS'),
    'E336': ('ISILI', 'SU'),
    'E337': ('ISNELLO', 'PA'),
    'E338': ("ISOLA D'ASTI", 'AT'),
    'E339': ('ISOLA DI CAPO RIZZUTO', 'KR'),
    'E340': ('ISOLA DEL LIRI', 'FR'),
    'E341': ('ISOLA DEL CANTONE', 'GE'),
    'E342': ('MADESIMO', 'SO'),
    'E343': ("ISOLA DEL GRAN SASSO D'ITALIA", 'TE'),
    'E345': ('ISOLABELLA', 'TO'),
    'E346': ('ISOLABONA', 'IM'),
    'E348': ('ISOLA DEL GIGLIO', 'GR'),
    'E349': ('ISOLA DELLA SCALA', 'VR'),
    'E350': ('ISOLA DELLE FEMMINE', 'PA'),
    'E351': ('ISOLA DEL PIANO', 'PU'),
    'E353': ('ISOLA DI FONDRA', 'BG'),
    'E354': ('ISOLA VICENTINA', 'VI'),
    'E356': ('ISOLA DOVARESE', 'CR'),
    'E358': ('ISOLA RIZZA', 'VR'),
    'E360': ("ISOLA SANT'ANTONIO", 'AL'),
    'E363': ('ISOLE TREMITI', 'FG'),
    'E364': ('ISORELLA', 'BS'),
    'E365': ('ISPANI', 'SA'),
    'E366': ('ISPICA', 'RG'),
    'E367': ('ISPRA', 'VA'),
    'E368': ('ISSIGLIO', 'TO'),
    'E369': ('ISSIME', 'AO'),
    'E370': ('ISSO', 'BG'),
    'E371': ('ISSOGNE', 'AO'),
    'E372': ('VASTO', 'CH'),
    'E373': ('ISTRANA', 'TV'),
    'E374': ('ITALA', 'ME'),
    'E375': ('ITRI', 'LT'),
    'E376': ('ITTIREDDU', 'SS'),
    'E377': ('ITTIRI', 'SS'),
    'E379': ('IVREA', 'TO'),
    'E380': ('IZANO', 'CR'),
    'E381': ('JELSI', 'CB'),
    'E382': ('JENNE', 'RM'),
    'E386': ('JERAGO CON ORAGO', 'VA'),
    'E387': ('JERZU', 'NU'),
    'E388': ('JESI', 'AN'),
    'E389': ('JOPPOLO', 'VV'),
    'E390': ('JOPPOLO GIANCAXIO', 'AG'),
    'E391': ('JOVENÇAN', 'AO'),
    'E392': ('LABICO', 'RM'),
    'E393': ('LABRO', 'RI'),
    'E394': ('LA CASSA', 'TO'),
    'E395': ('LACCHIARELLA', 'MI'),
    'E396': ('LACCO AMENO', 'NA'),
    'E397': ('LACEDONIA', 'AV'),
    'E398': ('LACES/LATSCH', 'BZ'),
    'E400': ('LACONI', 'OR'),
    'E401': ('LAERRU', 'SS'),
    'E402': ('LAGANADI', 'RC'),
    'E403': ('LAGHI', 'VI'),
    'E405': ('LAGLIO', 'CO'),
    'E406': ('LAGNASCO', 'CN'),
    'E407': ('LAGO', 'CS'),
    'E409': ('LAGONEGRO', 'PZ'),
    'E410': ('LAGOSANTO', 'FE'),
    'E412': ('LAGUNDO/ALGUND', 'BZ'),
    'E413': ('LAJATICO', 'PI'),
    'E414': ('LAIGUEGLIA', 'SV'),
    'E415': ('LAINATE', 'MI'),
    'E416': ('LAINO', 'CO'),
    'E417': ('LAINO BORGO', 'CS'),
    'E419': ('LAINO CASTELLO', 'CS'),
    'E420': ('LAION/LAJEN', 'BZ'),
    'E421': ('LAIVES/LEIFERS', 'BZ'),
    'E422': ('LALLIO', 'BG'),
    'E423': ('LA LOGGIA', 'TO'),
    'E424': ('LAMA DEI PELIGNI', 'CH'),
    'E425': ('LA MADDALENA', 'SS'),
    'E426': ('LAMA MOCOGNO', 'MO'),
    'E428': ('LAMBRUGO', 'CO'),
    'E429': ('LAMON', 'BL'),
    'E430': ('LA MORRA', 'CN'),
    'E431': ('LAMPEDUSA E LINOSA', 'AG'),
    'E432': ('LAMPORECCHIO', 'PT'),
    'E433': ('LAMPORO', 'VC'),
    'E434': ('LANA/LANA', 'BZ'),
    'E435': ('LANCIANO', 'CH'),
    'E436': ('LANDIONA', 'NO'),
    'E437': ('LANDRIANO', 'PV'),
    'E438': ('LANGHIRANO', 'PR'),
    'E439': ('LANGOSCO', 'PV'),
    'E441': ('LANUSEI', 'NU'),
    'E443': ('LANZADA', 'SO'),
    'E445': ('LANZO TORINESE', 'TO'),
    'E447': ('LAPEDONA', 'FM'),
    'E448': ('LAPIO', 'AV'),
    'E450': ('LAPPANO', 'CS'),
    'E451': ('LARCIANO', 'PT'),
    'E454': ('LARDIRAGO', 'PV'),
    'E456': ('LARINO', 'CB'),
    'E457': ('LASA/LAAS', 'BZ'),
    'E458': ('LA SALLE', 'AO'),
    'E459': ('LASCARI', 'PA'),
    'E462': ('LASNIGO', 'CO'),
    'E463': ('LA SPEZIA', 'SP'),
    'E464': ('LAS PLASSAS', 'SU'),
    'E465': ('LASTEBASSE', 'VI'),
    'E466': ('LASTRA A SIGNA', 'FI'),
    'E467': ('LATERA', 'VT'),
    'E469': ('LATERZA', 'TA'),
    'E470': ('LA THUILE', 'AO'),
    'E471': ('LATIANO', 'BR'),
    'E472': ('LATINA', 'LT'),
    'E473': ('LATISANA', 'UD'),
    'E474': ('LATRONICO', 'PZ'),
    'E475': ('LATTARICO', 'CS'),
    'E476': ('LAUCO', 'UD'),
    'E479': ('LAUREANA DI BORRELLO', 'RC'),
    'E480': ('LAUREANA CILENTO', 'SA'),
    'E481': ('LAUREGNO/LAUREIN', 'BZ'),
    'E482': ('LAURENZANA', 'PZ'),
    'E483': ('LAURIA', 'PZ'),
    'E484': ('LAURIANO', 'TO'),
    'E485': ('LAURINO', 'SA'),
    'E486': ('LAURITO', 'SA'),
    'E487': ('LAURO', 'AV'),
    'E488': ('LAVAGNA', 'GE'),
    'E489': ('LAVAGNO', 'VR'),
    'E490': ('LA VALLE AGORDINA', 'BL'),
    'E491': ('LA VALLE/WENGEN', 'BZ'),
    'E492': ('LAVARONE', 'TN'),
    'E493': ('LAVELLO', 'PZ'),
    'E494': ('LAVENA PONTE TRESA', 'VA'),
    'E496': ('LAVENO-MOMBELLO', 'VA'),
    'E497': ('LAVENONE', 'BS'),
    'E498': ('LAVIANO', 'SA'),
    'E500': ('LAVIS', 'TN'),
    'E502': ('LAZISE', 'VR'),
    'E504': ('LAZZATE', 'MB'),
    'E505': ('LECCE NEI MARSI', 'AQ'),
    'E506': ('LECCE', 'LE'),
    'E507': ('LECCO', 'LC'),
    'E509': ('LEFFE', 'BG'),
    'E510': ('LEGGIUNO', 'VA'),
    'E512': ('LEGNAGO', 'VR'),
    'E514': ('LEGNANO', 'MI'),
    'E515': ('LEGNARO', 'PD'),
    'E517': ('LEI', 'NU'),
    'E518': ('LEINI', 'TO'),
    'E519': ('LEIVI', 'GE'),
    'E520': ('LEMIE', 'TO'),
    'E522': ('LENDINARA', 'RO'),
    'E523': ('LENI', 'ME'),
    'E524': ('LENNA', 'BG'),
    'E526': ('LENO', 'BS'),
    'E527': ('LENOLA', 'LT'),
    'E528': ('LENTA', 'VC'),
    'E530': ('LENTATE SUL SEVESO', 'MB'),
    'E531': ('LENTELLA', 'CH'),
    'E532': ('LENTINI', 'SR'),
    'E535': ('LEONESSA', 'RI'),
    'E536': ('LEONFORTE', 'EN'),
    'E537': ('LEPORANO', 'TA'),
    'E538': ('LEQUILE', 'LE'),
    'E539': ('LEQUIO TANARO', 'CN'),
    'E540': ('LEQUIO BERRIA', 'CN'),
    'E541': ('LERCARA FRIDDI', 'PA'),
    'E542': ('LERICI', 'SP'),
    'E543': ('LERMA', 'AL'),
    'E544': ('LESA', 'NO'),
    'E546': ('LESEGNO', 'CN'),
    'E547': ("LESIGNANO DE' BAGNI", 'PR'),
    'E548': ('TERENZO', 'PR'),
    'E549': ('LESINA', 'FG'),
    'E550': ('LESMO', 'MB'),
    'E551': ('LESSOLO', 'TO'),
    'E553': ('LESTIZZA', 'UD'),
    'E554': ('LETINO', 'CE'),
    'E555': ('LETOJANNI', 'ME'),
    'E557': ('LETTERE', 'NA'),
    'E558': ('LETTOMANOPPELLO', 'PE'),
    'E559': ('LETTOPALENA', 'CH'),
    'E560': ('LEVANTO', 'SP'),
    'E562': ('LEVATE', 'BG'),
    'E563': ('LEVERANO', 'LE'),
    'E564': ('LEVICE', 'CN'),
    'E565': ('LEVICO TERME', 'TN'),
    'E566': ('LEVONE', 'TO'),
    'E569': ('LEZZENO', 'CO'),
    'E570': ('LIBERI', 'CE'),
    'E571': ('LIBRIZZI', 'ME'),
    'E573': ('LICATA', 'AG'),
    'E574': ('LICCIANA NARDI', 'MS'),
    'E576': ('LICENZA', 'RM'),
    'E578': ('LICODIA EUBEA', 'CT'),
    'E581': ('LIERNA', 'LC'),
    'E583': ('LIGNANA', 'VC'),
    'E584': ('LIGNANO SABBIADORO', 'UD'),
    'E587': ('LILLIANES', 'AO'),
    'E588': ('LIMANA', 'BL'),
    'E589': ('LIMATOLA', 'BN'),
    'E590': ('LIMBADI', 'VV'),
    'E591': ('LIMBIATE', 'MB'),
    'E592': ('LIMENA', 'PD'),
    'E593': ('LIMIDO COMASCO', 'CO'),
    'E594': ('LIMINA', 'ME'),
    'E596': ('LIMONE SUL GARDA', 'BS'),
    'E597': ('LIMONE PIEMONTE', 'CN'),
    'E599': ('LIMOSANO', 'CB'),
    'E600': ('LINAROLO', 'PV'),
    'E602': ('LINGUAGLOSSA', 'CT'),
    'E605': ('LIONI', 'AV'),
    'E606': ('LIPARI', 'ME'),
    'E607': ('LIPOMO', 'CO'),
    'E608': ('LIRIO', 'PV'),
    'E610': ('LISCATE', 'MI'),
    'E611': ('LISCIA', 'CH'),
    'E613': ('LISCIANO NICCONE', 'PG'),
    'E615': ('LISIO', 'CN'),
    'E617': ('LISSONE', 'MB'),
    'E618': ('MILENA', 'CL'),
    'E620': ('LIVERI', 'NA'),
    'E621': ('LIVIGNO', 'SO'),
    'E622': ('LIVINALLONGO DEL COL DI LANA', 'BL'),
    'E623': ('LIVO', 'CO'),
    'E624': ('LIVO', 'TN'),
    'E625': ('LIVORNO', 'LI'),
    'E626': ('LIVORNO FERRARIS', 'VC'),
    'E627': ('LIVRAGA', 'LO'),
    'E629': ('LIZZANELLO', 'LE'),
    'E630': ('LIZZANO', 'TA'),
    'E632': ('LOANO', 'SV'),
    'E633': ('LOAZZOLO', 'AT'),
    'E635': ('LOCANA', 'TO'),
    'E638': ('LOCATE VARESINO', 'CO'),
    'E639': ('LOCATE DI TRIULZI', 'MI'),
    'E640': ('LOCATELLO', 'BG'),
    'E644': ('LOCERI', 'NU'),
    'E645': ('LOCOROTONDO', 'BA'),
    'E646': ('LOCULI', 'NU'),
    'E647': ('LODÈ', 'NU'),
    'E648': ('LODI', 'LO'),
    'E649': ('LODINE', 'NU'),
    'E651': ('LODI VECCHIO', 'LO'),
    'E652': ('LODRINO', 'BS'),
    'E654': ('LOGRATO', 'BS'),
    'E655': ('LOIANO', 'BO'),
    'E656': ('LOMAGNA', 'LC'),
    'E659': ('LOMAZZO', 'CO'),
    'E660': ('LOMBARDORE', 'TO'),
    'E661': ('LOMBRIASCO', 'TO'),
    'E662': ('LOMELLO', 'PV'),
    'E664': ('LONA-LASES', 'TN'),
    'E665': ('LONATE CEPPINO', 'VA'),
    'E666': ('LONATE POZZOLO', 'VA'),
    'E668': ('LONDA', 'FI'),
    'E669': ('LONGANO', 'IS'),
    'E671': ('LONGARE', 'VI'),
    'E673': ('LONGHENA', 'BS'),
    'E674': ('LONGI', 'ME'),
    'E675': ('LONGIANO', 'FC'),
    'E677': ('LONGOBARDI', 'CS'),
    'E678': ('LONGOBUCCO', 'CS'),
    'E679': ('LONGONE AL SEGRINO', 'CO'),
    'E680': ('PORTO AZZURRO', 'LI'),
    'E681': ('LONGONE SABINO', 'RI'),
    'E682': ('LONIGO', 'VI'),
    'E683': ('LORANZÈ', 'TO'),
    'E684': ('LOREGGIA', 'PD'),
    'E685': ('LOREGLIA', 'VB'),
    'E687': ('LORENZAGO DI CADORE', 'BL'),
    'E689': ('LOREO', 'RO'),
    'E690': ('LORETO', 'AN'),
    'E691': ('LORETO APRUTINO', 'PE'),
    'E692': ('LORIA', 'TV'),
    'E693': ('LORO CIUFFENNA', 'AR'),
    'E694': ('LORO PICENO', 'MC'),
    'E695': ('LORSICA', 'GE'),
    'E698': ('LOSINE', 'BS'),
    'E700': ('LOTZORAI', 'NU'),
    'E704': ('LOVERE', 'BG'),
    'E705': ('LOVERO', 'SO'),
    'E706': ('LOZIO', 'BS'),
    'E707': ('LOZZA', 'VA'),
    'E708': ('LOZZO DI CADORE', 'BL'),
    'E709': ('LOZZO ATESTINO', 'PD'),
    'E711': ('LOZZOLO', 'VC'),
    'E713': ('LUBRIANO', 'VT'),
    'E714': ('LUCCA SICULA', 'AG'),
    'E715': ('LUCCA', 'LU'),
    'E716': ('LUCERA', 'FG'),
    'E718': ('LUCIGNANO', 'AR'),
    'E719': ('LUCINASCO', 'IM'),
    'E722': ('LUCITO', 'CB'),
    'E723': ('LUCO DEI MARSI', 'AQ'),
    'E724': ('LUCOLI', 'AQ'),
    'E726': ("LUGAGNANO VAL D'ARDA", 'PC'),
    'E729': ('LUGNANO IN TEVERINA', 'TR'),
    'E730': ('LUGO', 'RA'),
    'E731': ('LUGO DI VICENZA', 'VI'),
    'E734': ('LUINO', 'VA'),
    'E735': ('LUISAGO', 'CO'),
    'E736': ('LULA', 'NU'),
    'E737': ('LUMARZO', 'GE'),
    'E738': ('LUMEZZANE', 'BS'),
    'E742': ('LUNAMATRONA', 'SU'),
    'E743': ('LUNANO', 'PU'),
    'E745': ('LUNGRO', 'CS'),
    'E746': ('LUOGOSANO', 'AV'),
    'E747': ('LUOGOSANTO', 'SS'),
    'E748': ('LUPARA', 'CB'),
    'E749': ("LURAGO D'ERBA", 'CO'),
    'E750': ('LURAGO MARINONE', 'CO'),
    'E751': ('LURANO', 'BG'),
    'E752': ('LURAS', 'SS'),
    'E753': ('LURATE CACCIVIO', 'CO'),
    'E754': ('LUSCIANO', 'CE'),
    'E757': ('LUSERNA', 'TN'),
    'E758': ('LUSERNA SAN GIOVANNI', 'TO'),
    'E759': ('LUSERNETTA', 'TO'),
    'E760': ('LUSEVERA', 'UD'),
    'E761': ('LUSIA', 'RO'),
    'E763': ('LUSIGLIÈ', 'TO'),
    'E764': ('LUSON/LÜSEN', 'BZ'),
    'E767': ('LUSTRA', 'SA'),
    'E769': ('LUVINATE', 'VA'),
    'E770': ('LUZZANA', 'BG'),
    'E772': ('LUZZARA', 'RE'),
    'E773': ('LUZZI', 'CS'),
    'E777': ('MACCASTORNA', 'LO'),
    'E778': ("MACCHIA D'ISERNIA", 'IS'),
    'E779': ('MACCHIAGODENA', 'IS'),
    'E780': ('MACCHIA VALFORTORE', 'CB'),
    'E782': ('MACELLO', 'TO'),
    'E783': ('MACERATA', 'MC'),
    'E784': ('MACERATA CAMPANIA', 'CE'),
    'E785': ('MACERATA FELTRIA', 'PU'),
    'E786': ('MACHERIO', 'MB'),
    'E787': ('MACLODIO', 'BS'),
    'E788': ('MACOMER', 'NU'),
    'E789': ('MACRA', 'CN'),
    'E790': ('MACUGNAGA', 'VB'),
    'E791': ('MADDALONI', 'CE'),
    'E793': ('MADIGNANO', 'CR'),
    'E794': ('MADONE', 'BG'),
    'E795': ('MADONNA DEL SASSO', 'VB'),
    'E798': ('MAENZA', 'LT'),
    'E799': ('MAFALDA', 'CB'),
    'E800': ('MAGASA', 'BS'),
    'E801': ('MAGENTA', 'MI'),
    'E803': ('MAGGIORA', 'NO'),
    'E804': ('MAGHERNO', 'PV'),
    'E805': ('MAGIONE', 'PG'),
    'E806': ('MAGISANO', 'CZ'),
    'E807': ('MAGLIANO DI TENNA', 'FM'),
    'E808': ('MAGLIANO ALPI', 'CN'),
    'E809': ('MAGLIANO ALFIERI', 'CN'),
    'E810': ('MAGLIANO IN TOSCANA', 'GR'),
    'E811': ("MAGLIANO DE' MARSI", 'AQ'),
    'E812': ('MAGLIANO SABINA', 'RI'),
    'E813': ('MAGLIANO ROMANO', 'RM'),
    'E814': ('MAGLIANO VETERE', 'SA'),
    'E815': ('MAGLIE', 'LE'),
    'E816': ('MAGLIOLO', 'SV'),
    'E817': ('MAGLIONE', 'TO'),
    'E818': ('MAGNACAVALLO', 'MN'),
    'E819': ('MAGNAGO', 'MI'),
    'E820': ('MAGNANO IN RIVIERA', 'UD'),
    'E821': ('MAGNANO', 'BI'),
    'E825': ('MAGOMADAS', 'OR'),
    'E829': ('MAGRÈ SULLA STRADA DEL VINO/MARGREID AN DER WEINSTRASSE', 'BZ'),
    'E830': ('MAGREGLIO', 'CO'),
    'E833': ('MAJANO', 'UD'),
    'E834': ('MAIDA', 'CZ'),
    'E835': ('MAIERÀ', 'CS'),
    'E836': ('MAIERATO', 'VV'),
    'E837': ('MAIOLATI SPONTINI', 'AN'),
    'E838': ('MAIOLO', 'RN'),
    'E839': ('MAIORI', 'SA'),
    'E840': ('MAIRAGO', 'LO'),
    'E841': ('MAIRANO', 'BS'),
    'E842': ('MAISSANA', 'SP'),
    'E843': ('MALAGNINO', 'CR'),
    'E844': ('MALALBERGO', 'BO'),
    'E847': ('MALBORGHETTO VALBRUNA', 'UD'),
    'E848': ('MALCESINE', 'VR'),
    'E850': ('MALÉ', 'TN'),
    'E851': ('MALEGNO', 'BS'),
    'E852': ('MALEO', 'LO'),
    'E853': ('MALESCO', 'VB'),
    'E854': ('MALETTO', 'CT'),
    'E855': ('MALFA', 'ME'),
    'E856': ('MALGESSO', 'VA'),
    'E858': ('MALGRATE', 'LC'),
    'E859': ('MALITO', 'CS'),
    'E860': ('MALLARE', 'SV'),
    'E862': ('MALLES VENOSTA/MALS', 'BZ'),
    'E863': ('MALNATE', 'VA'),
    'E864': ('MALO', 'VI'),
    'E865': ('MALONNO', 'BS'),
    'E868': ('MALTIGNANO', 'AP'),
    'E869': ('MALVAGNA', 'ME'),
    'E870': ('MALVICINO', 'AL'),
    'E872': ('MALVITO', 'CS'),
    'E873': ('MAMMOLA', 'RC'),
    'E874': ('MAMOIADA', 'NU'),
    'E875': ('MANCIANO', 'GR'),
    'E876': ('MANDANICI', 'ME'),
    'E877': ('MANDAS', 'SU'),
    'E878': ('MANDATORICCIO', 'CS'),
    'E879': ('MANDELLO DEL LARIO', 'LC'),
    'E880': ('MANDELLO VITTA', 'NO'),
    'E882': ('MANDURIA', 'TA'),
    'E883': ('MANERBA DEL GARDA', 'BS'),
    'E884': ('MANERBIO', 'BS'),
    'E885': ('MANFREDONIA', 'FG'),
    'E887': ('MANGO', 'CN'),
    'E888': ('MANGONE', 'CS'),
    'E889': ('MANIAGO', 'PN'),
    'E891': ('MANOCALZATI', 'AV'),
    'E892': ('MANOPPELLO', 'PE'),
    'E893': ('MANSUÈ', 'TV'),
    'E894': ('MANTA', 'CN'),
    'E896': ('MANTELLO', 'SO'),
    'E897': ('MANTOVA', 'MN'),
    'E899': ('MANZANO', 'UD'),
    'E900': ('MANZIANA', 'RM'),
    'E901': ('MAPELLO', 'BG'),
    'E902': ('MARA', 'SS'),
    'E903': ('MARACALAGONIS', 'CA'),
    'E904': ('MARANELLO', 'MO'),
    'E905': ('MARANO SUL PANARO', 'MO'),
    'E906': ('MARANO DI NAPOLI', 'NA'),
    'E907': ('MARANO TICINO', 'NO'),
    'E908': ('MARANO EQUO', 'RM'),
    'E910': ('MARANO LAGUNARE', 'UD'),
    'E911': ('MARANO DI VALPOLICELLA', 'VR'),
    'E912': ('MARANO VICENTINO', 'VI'),
    'E914': ('MARANO MARCHESATO', 'CS'),
    'E915': ('MARANO PRINCIPATO', 'CS'),
    'E917': ('MARANZANA', 'AT'),
    'E919': ('MARATEA', 'PZ'),
    'E921': ('MARCALLO CON CASONE', 'MI'),
    'E922': ('MARCARIA', 'MN'),
    'E923': ('MARCEDUSA', 'CZ'),
    'E924': ('MARCELLINA', 'RM'),
    'E925': ('MARCELLINARA', 'CZ'),
    'E927': ('MARCETELLI', 'RI'),
    'E928': ('MARCHENO', 'BS'),
    'E929': ('MARCHIROLO', 'VA'),
    'E930': ('MARCIANA', 'LI'),
    'E931': ('MARCIANA MARINA', 'LI'),
    'E932': ('MARCIANISE', 'CE'),
    'E933': ('MARCIANO DELLA CHIANA', 'AR'),
    'E934': ('MARCIGNAGO', 'PV'),
    'E936': ('MARCON', 'VE'),
    'E938': ('MAREBBE/ENNEBERG', 'BZ'),
    'E939': ('MARENE', 'CN'),
    'E940': ('MARENO DI PIAVE', 'TV'),
    'E941': ('MARENTINO', 'TO'),
    'E944': ('MARETTO', 'AT'),
    'E945': ('MARGARITA', 'CN'),
    'E946': ('MARGHERITA DI SAVOIA', 'BT'),
    'E947': ('MARGNO', 'LC'),
    'E949': ('MARIANA MANTOVANA', 'MN'),
    'E951': ('MARIANO COMENSE', 'CO'),
    'E952': ('MARIANO DEL FRIULI', 'GO'),
    'E953': ('MARIANOPOLI', 'CL'),
    'E954': ('MARIGLIANELLA', 'NA'),
    'E955': ('MARIGLIANO', 'NA'),
    'E956': ('MARINA DI GIOIOSA IONICA', 'RC'),
    'E957': ('MARINEO', 'PA'),
    'E958': ('MARINO', 'RM'),
    'E959': ('MARLENGO/MARLING', 'BZ'),
    'E960': ('MARLIANA', 'PT'),
    'E961': ('MARMENTINO', 'BS'),
    'E962': ('MARMIROLO', 'MN'),
    'E963': ('MARMORA', 'CN'),
    'E965': ('MARNATE', 'VA'),
    'E967': ('MARONE', 'BS'),
    'E968': ('MAROPATI', 'RC'),
    'E970': ('MAROSTICA', 'VI'),
    'E971': ('MARRADI', 'FI'),
    'E972': ('MARRUBIU', 'OR'),
    'E973': ('MARSAGLIA', 'CN'),
    'E974': ('MARSALA', 'TP'),
    'E975': ('MARSCIANO', 'PG'),
    'E976': ('MARSICO NUOVO', 'PZ'),
    'E977': ('MARSICOVETERE', 'PZ'),
    'E978': ('MARTA', 'VT'),
    'E979': ('MARTANO', 'LE'),
    'E980': ('MARTELLAGO', 'VE'),
    'E981': ('MARTELLO/MARTELL', 'BZ'),
    'E982': ('MARTIGNACCO', 'UD'),
    'E983': ('MARTIGNANA DI PO', 'CR'),
    'E984': ('MARTIGNANO', 'LE'),
    'E986': ('MARTINA FRANCA', 'TA'),
    'E987': ('MARTINENGO', 'BG'),
    'E988': ('MARTINIANA PO', 'CN'),
    'E989': ('MARTINSICURO', 'TE'),
    'E990': ('MARTIRANO', 'CZ'),
    'E991': ('MARTIRANO LOMBARDO', 'CZ'),
    'E992': ('MARTIS', 'SS'),
    'E993': ('MARTONE', 'RC'),
    'E994': ('MARUDO', 'LO'),
    'E995': ('MARUGGIO', 'TA'),
    'E997': ('MARZANO DI NOLA', 'AV'),
    'E998': ('MARZANO APPIO', 'CE'),
    'E999': ('MARZANO', 'PV'),
    'F001': ('MARZI', 'CS'),
    'F002': ('MARZIO', 'VA'),
    'F003': ('MASATE', 'MI'),
    'F004': ('MASCALI', 'CT'),
    'F005': ('MASCALUCIA', 'CT'),
    'F006': ('MASCHITO', 'PZ'),
    'F007': ('MASCIAGO PRIMO', 'VA'),
    'F009': ('MASER', 'TV'),
    'F010': ('MASERA', 'VB'),
    'F011': ('MASERÀ DI PADOVA', 'PD'),
    'F012': ('MASERADA SUL PIAVE', 'TV'),
    'F013': ('MASI', 'PD'),
    'F015': ('MASIO', 'AL'),
    'F016': ('MASI TORELLO', 'FE'),
    'F017': ('MASLIANICO', 'CO'),
    'F020': ('MASONE', 'GE'),
    'F021': ('MASSA FERMANA', 'FM'),
    'F022': ("MASSA D'ALBE", 'AQ'),
    'F023': ('MASSA', 'MS'),
    'F024': ('MASSA MARTANA', 'PG'),
    'F025': ('MASSA E COZZILE', 'PT'),
    'F027': ('MASSAFRA', 'TA'),
    'F028': ('MASSALENGO', 'LO'),
    'F029': ('MASSA LOMBARDA', 'RA'),
    'F030': ('MASSA LUBRENSE', 'NA'),
    'F032': ('MASSA MARITTIMA', 'GR'),
    'F033': ('MASSANZAGO', 'PD'),
    'F035': ('MASSAROSA', 'LU'),
    'F037': ('MASSAZZA', 'BI'),
    'F041': ('MASSELLO', 'TO'),
    'F042': ('MASSERANO', 'BI'),
    'F043': ('SAN MARCO EVANGELISTA', 'CE'),
    'F044': ('MASSIGNANO', 'AP'),
    'F045': ('MASSIMENO', 'TN'),
    'F046': ('MASSIMINO', 'SV'),
    'F047': ('MASSINO VISCONTI', 'NO'),
    'F048': ('MASSIOLA', 'VB'),
    'F050': ('MASULLAS', 'OR'),
    'F051': ('MATELICA', 'MC'),
    'F052': ('MATERA', 'MT'),
    'F053': ('MATHI', 'TO'),
    'F054': ('MATINO', 'LE'),
    'F055': ('MATRICE', 'CB'),
    'F058': ('MATTIE', 'TO'),
    'F059': ('MATTINATA', 'FG'),
    'F061': ('MAZARA DEL VALLO', 'TP'),
    'F063': ('MAZZANO', 'BS'),
    'F064': ('MAZZANO ROMANO', 'RM'),
    'F065': ('MAZZARINO', 'CL'),
    'F066': ("MAZZARRÀ SANT'ANDREA", 'ME'),
    'F067': ('MAZZÈ', 'TO'),
    'F068': ('MAZZIN', 'TN'),
    'F070': ('MAZZO DI VALTELLINA', 'SO'),
    'F073': ('MEANA SARDO', 'NU'),
    'F074': ('MEANA DI SUSA', 'TO'),
    'F078': ('MEDA', 'MB'),
    'F080': ('MEDE', 'PV'),
    'F081': ('MEDEA', 'GO'),
    'F082': ('MEDESANO', 'PR'),
    'F083': ('MEDICINA', 'BO'),
    'F084': ('MEDIGLIA', 'MI'),
    'F085': ('MEDOLAGO', 'BG'),
    'F086': ('MEDOLE', 'MN'),
    'F087': ('MEDOLLA', 'MO'),
    'F088': ('MEDUNA DI LIVENZA', 'TV'),
    'F089': ('MEDUNO', 'PN'),
    'F092': ('MEGLIADINO SAN VITALE', 'PD'),
    'F093': ('MEINA', 'NO'),
    'F095': ('MELARA', 'RO'),
    'F096': ('MELAZZO', 'AL'),
    'F097': ('MELDOLA', 'FC'),
    'F098': ('MELE', 'GE'),
    'F100': ('MELEGNANO', 'MI'),
    'F101': ('MELENDUGNO', 'LE'),
    'F102': ('MELETI', 'LO'),
    'F104': ('MELFI', 'PZ'),
    'F105': ('MELICUCCÀ', 'RC'),
    'F106': ('MELICUCCO', 'RC'),
    'F107': ('MELILLI', 'SR'),
    'F108': ('MELISSA', 'KR'),
    'F109': ('MELISSANO', 'LE'),
    'F110': ('MELITO IRPINO', 'AV'),
    'F111': ('MELITO DI NAPOLI', 'NA'),
    'F112': ('MELITO DI PORTO SALVO', 'RC'),
    'F113': ('MELIZZANO', 'BN'),
    'F114': ('MELLE', 'CN'),
    'F115': ('MELLO', 'SO'),
    'F116': ('SILEA', 'TV'),
    'F117': ('MELPIGNANO', 'LE'),
    'F118': ('MELTINA/MÖLTEN', 'BZ'),
    'F119': ('MELZO', 'MI'),
    'F120': ('MENAGGIO', 'CO'),
    'F122': ('MENCONICO', 'PV'),
    'F123': ('MENDATICA', 'IM'),
    'F125': ('MENDICINO', 'CS'),
    'F126': ('MENFI', 'AG'),
    'F127': ('MENTANA', 'RM'),
    'F130': ('MEOLO', 'VE'),
    'F131': ('MERANA', 'AL'),
    'F132': ('MERANO/MERAN', 'BZ'),
    'F133': ('MERATE', 'LC'),
    'F134': ('MERCALLO', 'VA'),
    'F135': ('MERCATELLO SUL METAURO', 'PU'),
    'F136': ('MERCATINO CONCA', 'PU'),
    'F137': ('NOVAFELTRIA', 'RN'),
    'F138': ('MERCATO SAN SEVERINO', 'SA'),
    'F139': ('MERCATO SARACENO', 'FC'),
    'F140': ('MERCENASCO', 'TO'),
    'F141': ('MERCOGLIANO', 'AV'),
    'F144': ('MERETO DI TOMBA', 'UD'),
    'F145': ('MERGO', 'AN'),
    'F146': ('MERGOZZO', 'VB'),
    'F147': ('MERÌ', 'ME'),
    'F148': ('MERLARA', 'PD'),
    'F149': ('MERLINO', 'LO'),
    'F151': ('MERONE', 'CO'),
    'F152': ('MESAGNE', 'BR'),
    'F153': ('MESE', 'SO'),
    'F154': ('MESENZANA', 'VA'),
    'F155': ('MESERO', 'MI'),
    'F156': ('MESOLA', 'FE'),
    'F157': ('MESORACA', 'KR'),
    'F158': ('MESSINA', 'ME'),
    'F161': ('MESTRINO', 'PD'),
    'F162': ('META', 'NA'),
    'F165': ('MEZZAGO', 'MB'),
    'F167': ('MEZZANA MORTIGLIENGO', 'BI'),
    'F168': ('MEZZANA', 'TN'),
    'F170': ('MEZZANA BIGLI', 'PV'),
    'F171': ('MEZZANA RABATTONE', 'PV'),
    'F172': ('MEZZANE DI SOTTO', 'VR'),
    'F173': ('MEZZANEGO', 'GE'),
    'F175': ('MEZZANINO', 'PV'),
    'F176': ('MEZZANO', 'TN'),
    'F182': ('MEZZENILE', 'TO'),
    'F183': ('MEZZOCORONA', 'TN'),
    'F184': ('MEZZOJUSO', 'PA'),
    'F186': ('MEZZOLDO', 'BG'),
    'F187': ('MEZZOLOMBARDO', 'TN'),
    'F188': ('MEZZOMERICO', 'NO'),
    'F189': ('MIAGLIANO', 'BI'),
    'F190': ('MIANE', 'TV'),
    'F191': ('MIASINO', 'NO'),
    'F192': ('MIAZZINA', 'VB'),
    'F193': ('MICIGLIANO', 'RI'),
    'F194': ('MIGGIANO', 'LE'),
    'F196': ('MIGLIANICO', 'CH'),
    'F200': ('MIGLIERINA', 'CZ'),
    'F201': ('MIGLIONICO', 'MT'),
    'F202': ('MIGNANEGO', 'GE'),
    'F203': ('MIGNANO MONTE LUNGO', 'CE'),
    'F205': ('MILANO', 'MI'),
    'F206': ('MILAZZO', 'ME'),
    'F207': ('MILETO', 'VV'),
    'F208': ('MILIS', 'OR'),
    'F209': ('MILITELLO IN VAL DI CATANIA', 'CT'),
    'F210': ('MILITELLO ROSMARINO', 'ME'),
    'F213': ('MILLESIMO', 'SV'),
    'F214': ('MILO', 'CT'),
    'F216': ('MILZANO', 'BS'),
    'F217': ('MINEO', 'CT'),
    'F218': ('MINERBE', 'VR'),
    'F219': ('MINERBIO', 'BO'),
    'F220': ('MINERVINO MURGE', 'BT'),
    'F221': ('MINERVINO DI LECCE', 'LE'),
    'F223': ('MINORI', 'SA'),
    'F224': ('MINTURNO', 'LT'),
    'F225': ('MINUCCIANO', 'LU'),
    'F226': ('MIOGLIA', 'SV'),
    'F229': ('MIRA', 'VE'),
    'F230': ('MIRABELLA ECLANO', 'AV'),
    'F231': ('MIRABELLA IMBACCARI', 'CT'),
    'F232': ('MIRABELLO MONFERRATO', 'AL'),
    'F233': ('MIRABELLO SANNITICO', 'CB'),
    'F238': ('MIRADOLO TERME', 'PV'),
    'F239': ('MIRANDA', 'IS'),
    'F240': ('MIRANDOLA', 'MO'),
    'F241': ('MIRANO', 'VE'),
    'F242': ('MIRTO', 'ME'),
    'F243': ("MISANO DI GERA D'ADDA", 'BG'),
    'F244': ('MISANO ADRIATICO', 'RN'),
    'F246': ('MISILMERI', 'PA'),
    'F247': ('MISINTO', 'MB'),
    'F248': ('MISSAGLIA', 'LC'),
    'F249': ('MISSANELLO', 'PZ'),
    'F250': ('MISTERBIANCO', 'CT'),
    'F251': ('MISTRETTA', 'ME'),
    'F254': ('MOASCA', 'AT'),
    'F256': ('MOCONESI', 'GE'),
    'F257': ('MODENA', 'MO'),
    'F258': ('MODICA', 'RG'),
    'F259': ('MODIGLIANA', 'FC'),
    'F260': ('TAVAZZANO CON VILLAVESCO', 'LO'),
    'F261': ('MODOLO', 'OR'),
    'F262': ('MODUGNO', 'BA'),
    'F263': ('MOENA', 'TN'),
    'F265': ('MOGGIO', 'LC'),
    'F266': ('MOGGIO UDINESE', 'UD'),
    'F267': ('MOGLIA', 'MN'),
    'F268': ('MOGLIANO', 'MC'),
    'F269': ('MOGLIANO VENETO', 'TV'),
    'F270': ('MOGORELLA', 'OR'),
    'F271': ('RUINAS', 'OR'),
    'F272': ('MOGORO', 'OR'),
    'F274': ('MOIANO', 'BN'),
    'F275': ('MOIMACCO', 'UD'),
    'F276': ("MOIO DE' CALVI", 'BG'),
    'F277': ('MOIO ALCANTARA', 'ME'),
    'F278': ('MOIO DELLA CIVITELLA', 'SA'),
    'F279': ('MOIOLA', 'CN'),
    'F280': ('MOLA DI BARI', 'BA'),
    'F281': ('MOLARE', 'AL'),
    'F283': ('MOLAZZANA', 'LU'),
    'F284': ('MOLFETTA', 'BA'),
    'F287': ('MOLINARA', 'BN'),
    'F288': ('MOLINELLA', 'BO'),
    'F290': ('MOLINI DI TRIORA', 'IM'),
    'F293': ('MOLINO DEI TORTI', 'AL'),
    'F294': ('MOLISE', 'CB'),
    'F295': ('MOLITERNO', 'PZ'),
    'F297': ('MOLLIA', 'VC'),
    'F299': ('PORTO EMPEDOCLE', 'AG'),
    'F301': ('MOLOCHIO', 'RC'),
    'F304': ('MOLTENO', 'LC'),
    'F305': ('MOLTRASIO', 'CO'),
    'F307': ('MOLVENO', 'TN'),
    'F308': ('MOMBALDONE', 'AT'),
    'F309': ('MOMBARCARO', 'CN'),
    'F310': ('MOMBAROCCIO', 'PU'),
    'F311': ('MOMBARUZZO', 'AT'),
    'F312': ('MOMBASIGLIO', 'CN'),
    'F313': ('MOMBELLO MONFERRATO', 'AL'),
    'F315': ('MOMBELLO DI TORINO', 'TO'),
    'F316': ('MOMBERCELLI', 'AT'),
    'F317': ('MOMO', 'NO'),
    'F318': ('MOMPANTERO', 'TO'),
    'F319': ('MOMPEO', 'RI'),
    'F320': ('MOMPERONE', 'AL'),
    'F322': ('MONACILIONI', 'CB'),
    'F323': ('MONALE', 'AT'),
    'F324': ('MONASTERACE', 'RC'),
    'F325': ('MONASTERO BORMIDA', 'AT'),
    'F326': ('MONASTERO DI VASCO', 'CN'),
    'F327': ('MONASTERO DI LANZO', 'TO'),
    'F328': ('MONASTEROLO DEL CASTELLO', 'BG'),
    'F329': ('MONASTEROLO CASOTTO', 'CN'),
    'F330': ('MONASTEROLO DI SAVIGLIANO', 'CN'),
    'F332': ('MONASTIER DI TREVISO', 'TV'),
    'F333': ('MONASTIR', 'SU'),
    'F335': ('MONCALIERI', 'TO'),
    'F336': ('MONCALVO', 'AT'),
    'F337': ('MONCESTINO', 'AL'),
    'F338': ('MONCHIERO', 'CN'),
    'F340': ('MONCHIO DELLE CORTI', 'PR'),
    'F342': ('MONCRIVELLO', 'VC'),
    'F343': ('MONCUCCO TORINESE', 'AT'),
    'F346': ('MONDAINO', 'RN'),
    'F347': ('MONDAVIO', 'PU'),
    'F348': ('MONDOLFO', 'PU'),
    'F351': ('MONDOVÌ', 'CN'),
    'F352': ('MONDRAGONE', 'CE'),
    'F354': ('MONEGLIA', 'GE'),
    'F355': ('MONESIGLIO', 'CN'),
    'F356': ('MONFALCONE', 'GO'),
    'F357': ('SERRAMAZZONI', 'MO'),
    'F358': ("MONFORTE D'ALBA", 'CN'),
    'F359': ('MONFORTE SAN GIORGIO', 'ME'),
    'F360': ('MONFUMO', 'TV'),
    'F361': ('MONGARDINO', 'AT'),
    'F363': ('MONGHIDORO', 'BO'),
    'F364': ('MONGIANA', 'VV'),
    'F365': ('MONGIARDINO LIGURE', 'AL'),
    'F367': ('MONTJOVET', 'AO'),
    'F368': ('MONGIUFFI MELIA', 'ME'),
    'F369': ('MONGRANDO', 'BI'),
    'F370': ('MONGRASSANO', 'CS'),
    'F371': ('MONGUELFO-TESIDO/WELSBERG-TAISTEN', 'BZ'),
    'F372': ('MONGUZZO', 'CO'),
    'F373': ('MONIGA DEL GARDA', 'BS'),
    'F374': ('MONLEALE', 'AL'),
    'F375': ('MONNO', 'BS'),
    'F376': ('MONOPOLI', 'BA'),
    'F377': ('MONREALE', 'PA'),
    'F378': ('MONRUPINO-REPENTABOR', 'TS'),
    'F379': ('MONSAMPIETRO MORICO', 'FM'),
    'F380': ('MONSAMPOLO DEL TRONTO', 'AP'),
    'F381': ('MONSANO', 'AN'),
    'F382': ('MONSELICE', 'PD'),
    'F383': ('MONSERRATO', 'CA'),
    'F384': ('MONSUMMANO TERME', 'PT'),
    'F385': ('MONTÀ', 'CN'),
    'F386': ('MONTABONE', 'AT'),
    'F387': ('MONTACUTO', 'AL'),
    'F390': ('MONTAFIA', 'AT'),
    'F391': ('MONTAGANO', 'CB'),
    'F392': ('MONTAGNA/MONTAN', 'BZ'),
    'F393': ('MONTAGNA IN VALTELLINA', 'SO'),
    'F394': ('MONTAGNANA', 'PD'),
    'F395': ('MONTAGNAREALE', 'ME'),
    'F397': ('MONTAGUTO', 'AV'),
    'F398': ('MONTAIONE', 'FI'),
    'F399': ('MONTALBANO JONICO', 'MT'),
    'F400': ('MONTALBANO ELICONA', 'ME'),
    'F401': ('OSTRA', 'AN'),
    'F403': ('MONTALDEO', 'AL'),
    'F404': ('MONTALDO BORMIDA', 'AL'),
    'F405': ('MONTALDO DI MONDOVÌ', 'CN'),
    'F407': ('MONTALDO TORINESE', 'TO'),
    'F408': ('MONTALDO ROERO', 'CN'),
    'F409': ('MONTALDO SCARAMPI', 'AT'),
    'F410': ('MONTALE', 'PT'),
    'F411': ('MONTALENGHE', 'TO'),
    'F414': ('MONTALLEGRO', 'AG'),
    'F415': ('MONTALTO DELLE MARCHE', 'AP'),
    'F416': ('MONTALTO UFFUGO', 'CS'),
    'F417': ('MONTALTO PAVESE', 'PV'),
    'F419': ('MONTALTO DI CASTRO', 'VT'),
    'F420': ('MONTALTO DORA', 'TO'),
    'F422': ('MONTANARO', 'TO'),
    'F423': ('MONTANASO LOMBARDO', 'LO'),
    'F424': ('MONTANERA', 'CN'),
    'F426': ('MONTANO ANTILIA', 'SA'),
    'F427': ('MONTANO LUCINO', 'CO'),
    'F428': ('MONTAPPONE', 'FM'),
    'F429': ('MONTAQUILA', 'IS'),
    'F430': ('MONTASOLA', 'RI'),
    'F432': ('MONTAURO', 'CZ'),
    'F433': ('MONTAZZOLI', 'CH'),
    'F434': ('MONTE CREMASCO', 'CR'),
    'F437': ('MONTE ARGENTARIO', 'GR'),
    'F440': ('MONTEBELLO DELLA BATTAGLIA', 'PV'),
    'F441': ('MONTEBELLO DI BERTONA', 'PE'),
    'F442': ('MONTEBELLO VICENTINO', 'VI'),
    'F443': ('MONTEBELLUNA', 'TV'),
    'F445': ('MONTEBRUNO', 'GE'),
    'F446': ('MONTEBUONO', 'RI'),
    'F448': ('MONTECALVO IRPINO', 'AV'),
    'F449': ('MONTECALVO VERSIGGIA', 'PV'),
    'F450': ('MONTECALVO IN FOGLIA', 'PU'),
    'F452': ('MONTECARLO', 'LU'),
    'F453': ('MONTECAROTTO', 'AN'),
    'F454': ('MONTECASSIANO', 'MC'),
    'F455': ('MONTECASTELLO', 'AL'),
    'F456': ('MONTE CASTELLO DI VIBIO', 'PG'),
    'F457': ('MONTECASTRILLI', 'TR'),
    'F458': ('MONTECATINI VAL DI CECINA', 'PI'),
    'F460': ('MONTE CAVALLO', 'MC'),
    'F461': ('MONTECCHIA DI CROSARA', 'VR'),
    'F462': ('MONTECCHIO', 'TR'),
    'F463': ('MONTECCHIO EMILIA', 'RE'),
    'F464': ('MONTECCHIO MAGGIORE', 'VI'),
    'F465': ('MONTECCHIO PRECALCINO', 'VI'),
    'F467': ('MONTE CERIGNONE', 'PU'),
    'F468': ("MONTECHIARO D'ASTI", 'AT'),
    'F469': ("MONTECHIARO D'ACQUI", 'AL'),
    'F471': ('MONTICHIARI', 'BS'),
    'F473': ('MONTECHIARUGOLO', 'PR'),
    'F475': ('MONTECILFONE', 'CB'),
    'F477': ('MONTE COMPATRI', 'RM'),
    'F478': ('MONTECOPIOLO', 'RN'),
    'F479': ('MONTECORICE', 'SA'),
    'F480': ('MONTECORVINO PUGLIANO', 'SA'),
    'F481': ('MONTECORVINO ROVELLA', 'SA'),
    'F482': ('MONTECOSARO', 'MC'),
    'F483': ('MONTECRESTESE', 'VB'),
    'F484': ('MONTECRETO', 'MO'),
    'F486': ('MONTE DI MALO', 'VI'),
    'F487': ('MONTEDINOVE', 'AP'),
    'F488': ('MONTE DI PROCIDA', 'NA'),
    'F489': ('MONTEDORO', 'CL'),
    'F491': ('MONTEFALCIONE', 'AV'),
    'F492': ('MONTEFALCO', 'PG'),
    'F493': ('MONTEFALCONE APPENNINO', 'FM'),
    'F494': ('MONTEFALCONE DI VAL FORTORE', 'BN'),
    'F495': ('MONTEFALCONE NEL SANNIO', 'CB'),
    'F496': ('MONTEFANO', 'MC'),
    'F497': ('MONTEFELCINO', 'PU'),
    'F498': ('MONTEFERRANTE', 'CH'),
    'F499': ('MONTEFIASCONE', 'VT'),
    'F500': ('MONTEFINO', 'TE'),
    'F501': ("MONTEFIORE DELL'ASO", 'AP'),
    'F502': ('MONTEFIORE CONCA', 'RN'),
    'F503': ('MONTEFIORINO', 'MO'),
    'F504': ('MONTEFLAVIO', 'RM'),
    'F506': ('MONTEFORTE IRPINO', 'AV'),
    'F507': ('MONTEFORTE CILENTO', 'SA'),
    'F508': ("MONTEFORTE D'ALPONE", 'VR'),
    'F509': ('MONTEFORTINO', 'FM'),
    'F510': ('MONTEFRANCO', 'TR'),
    'F511': ('MONTEFREDANE', 'AV'),
    'F512': ('MONTEFUSCO', 'AV'),
    'F513': ('MONTEGABBIONE', 'TR'),
    'F514': ('MONTEGALDA', 'VI'),
    'F515': ('MONTEGALDELLA', 'VI'),
    'F516': ('MONTEGALLO', 'AP'),
    'F517': ('MONTE GIBERTO', 'FM'),
    'F518': ('MONTEGIOCO', 'AL'),
    'F519': ('MONTEGIORDANO', 'CS'),
    'F520': ('MONTEGIORGIO', 'FM'),
    'F522': ('MONTEGRANARO', 'FM'),
    'F523': ('MONTEGRIDOLFO', 'RN'),
    'F524': ('MONTE GRIMANO TERME', 'PU'),
    'F526': ('MONTEGRINO VALTRAVAGLIA', 'VA'),
    'F527': ("MONTEGROSSO D'ASTI", 'AT'),
    'F528': ('MONTEGROSSO PIAN LATTE', 'IM'),
    'F529': ('MONTEGROTTO TERME', 'PD'),
    'F531': ('MONTEIASI', 'TA'),
    'F532': ('MONTE ISOLA', 'BS'),
    'F533': ('MONTELABBATE', 'PU'),
    'F534': ('MONTELANICO', 'RM'),
    'F535': ('MONTELAPIANO', 'CH'),
    'F536': ('MONTELEONE DI FERMO', 'FM'),
    'F537': ('VIBO VALENTIA', 'VV'),
    'F538': ('MONTELEONE DI PUGLIA', 'FG'),
    'F540': ('MONTELEONE DI SPOLETO', 'PG'),
    'F541': ('MONTELEONE SABINO', 'RI'),
    'F542': ('MONTELEONE ROCCA DORIA', 'SS'),
    'F543': ("MONTELEONE D'ORVIETO", 'TR'),
    'F544': ('MONTELEPRE', 'PA'),
    'F545': ('MONTELIBRETTI', 'RM'),
    'F546': ('MONTELLA', 'AV'),
    'F547': ('MONTELLO', 'BG'),
    'F548': ('MONTELONGO', 'CB'),
    'F549': ('MONTELPARO', 'FM'),
    'F550': ('MONTELUPO ALBESE', 'CN'),
    'F551': ('MONTELUPO FIORENTINO', 'FI'),
    'F552': ('MONTELUPONE', 'MC'),
    'F553': ('MONTEMAGGIORE BELSITO', 'PA'),
    'F556': ('MONTEMAGNO', 'AT'),
    'F557': ("SANT'ARCANGELO TRIMONTE", 'BN'),
    'F558': ('MONTEMALE DI CUNEO', 'CN'),
    'F559': ('MONTEMARANO', 'AV'),
    'F560': ('MONTEMARCIANO', 'AN'),
    'F561': ('MONTE MARENZO', 'LC'),
    'F562': ('MONTEMARZINO', 'AL'),
    'F563': ('MONTEMESOLA', 'TA'),
    'F564': ('MONTEMEZZO', 'CO'),
    'F565': ('MONTEMIGNAIO', 'AR'),
    'F566': ('MONTEMILETTO', 'AV'),
    'F567': ('POLLENZA', 'MC'),
    'F568': ('MONTEMILONE', 'PZ'),
    'F569': ('MONTEMITRO', 'CB'),
    'F570': ('MONTEMONACO', 'AP'),
    'F572': ('MONTEMURLO', 'PO'),
    'F573': ('MONTEMURRO', 'PZ'),
    'F574': ('MONTENARS', 'UD'),
    'F576': ('MONTENERO DI BISACCIA', 'CB'),
    'F578': ('MONTENERODOMO', 'CH'),
    'F579': ('MONTENERO SABINO', 'RI'),
    'F580': ('MONTENERO VAL COCCHIARA', 'IS'),
    'F581': ('OSTRA VETERE', 'AN'),
    'F582': ('MONTEODORISIO', 'CH'),
    'F585': ('ROSETO DEGLI ABRUZZI', 'TE'),
    'F586': ('MONTEPAONE', 'CZ'),
    'F587': ('MONTEPARANO', 'TA'),
    'F589': ('MONTE PORZIO', 'PU'),
    'F590': ('MONTE PORZIO CATONE', 'RM'),
    'F591': ('MONTEPRANDONE', 'AP'),
    'F592': ('MONTEPULCIANO', 'SI'),
    'F594': ('MONTERCHI', 'AR'),
    'F595': ('MONTEREALE', 'AQ'),
    'F596': ('MONTEREALE VALCELLINA', 'PN'),
    'F597': ('MONTERENZIO', 'BO'),
    'F598': ('MONTERIGGIONI', 'SI'),
    'F599': ('MONTE RINALDO', 'FM'),
    'F600': ('MONTE ROBERTO', 'AN'),
    'F601': ('MONTERODUNI', 'IS'),
    'F603': ('MONTE ROMANO', 'VT'),
    'F604': ('MONTERONI DI LECCE', 'LE'),
    'F605': ("MONTERONI D'ARBIA", 'SI'),
    'F606': ('MONTEROSI', 'VT'),
    'F607': ('MONTEROSSO CALABRO', 'VV'),
    'F608': ('MONTEROSSO GRANA', 'CN'),
    'F609': ('MONTEROSSO AL MARE', 'SP'),
    'F610': ('MONTEROSSO ALMO', 'RG'),
    'F611': ('MONTEROTONDO', 'RM'),
    'F612': ('MONTEROTONDO MARITTIMO', 'GR'),
    'F614': ('MONTERUBBIANO', 'FM'),
    'F616': ('MONTE SAN BIAGIO', 'LT'),
    'F618': ('MONTE SAN GIACOMO', 'SA'),
    'F619': ('MONTE SAN GIOVANNI IN SABINA', 'RI'),
    'F620': ('MONTE SAN GIOVANNI CAMPANO', 'FR'),
    'F621': ('MONTE SAN GIUSTO', 'MC'),
    'F622': ('MONTE SAN MARTINO', 'MC'),
    'F623': ('MONTESANO SALENTINO', 'LE'),
    'F625': ('MONTESANO SULLA MARCELLANA', 'SA'),
    'F626': ('MONTE SAN PIETRANGELI', 'FM'),
    'F627': ('MONTE SAN PIETRO', 'BO'),
    'F628': ('MONTE SAN SAVINO', 'AR'),
    'F629': ('MONTE SANTA MARIA TIBERINA', 'PG'),
    'F631': ("MONTE SANT'ANGELO", 'FG'),
    'F632': ('POTENZA PICENA', 'MC'),
    'F634': ('MONTE SAN VITO', 'AN'),
    'F636': ('MONTESARCHIO', 'BN'),
    'F637': ('MONTESCAGLIOSO', 'MT'),
    'F638': ('MONTESCANO', 'PV'),
    'F639': ('MONTESCHENO', 'VB'),
    'F640': ('MONTESCUDAIO', 'PI'),
    'F642': ('MONTESE', 'MO'),
    'F644': ('MONTESEGALE', 'PV'),
    'F646': ('MONTESILVANO', 'PE'),
    'F648': ('MONTESPERTOLI', 'FI'),
    'F651': ('MONTEU DA PO', 'TO'),
    'F653': ('MONTE URANO', 'FM'),
    'F654': ('MONTEU ROERO', 'CN'),
    'F655': ('MONTEVAGO', 'AG'),
    'F656': ('MONTEVARCHI', 'AR'),
    'F657': ('MONTEVECCHIA', 'LC'),
    'F660': ('MONTEVERDE', 'AV'),
    'F661': ('MONTEVERDI MARITTIMO', 'PI'),
    'F662': ('MONTEVIALE', 'VI'),
    'F664': ('MONTE VIDON COMBATTE', 'FM'),
    'F665': ('MONTE VIDON CORRADO', 'FM'),
    'F666': ('MONTEZEMOLO', 'CN'),
    'F667': ('MONTI', 'SS'),
    'F668': ('MONTIANO', 'FC'),
    'F669': ("MONTICELLO D'ALBA", 'CN'),
    'F670': ('MONTICELLI PAVESE', 'PV'),
    'F671': ("MONTICELLI D'ONGINA", 'PC'),
    'F672': ('MONTICELLI BRUSATI', 'BS'),
    'F674': ('MONTICELLO BRIANZA', 'LC'),
    'F675': ('MONTICELLO CONTE OTTO', 'VI'),
    'F676': ('MONTICIANO', 'SI'),
    'F677': ('MONTIERI', 'GR'),
    'F679': ('MONTIGNOSO', 'MS'),
    'F680': ('MONTIRONE', 'BS'),
    'F681': ('MONTODINE', 'CR'),
    'F682': ('MONTOGGIO', 'GE'),
    'F685': ('MONTONE', 'PG'),
    'F686': ("MONTOPOLI IN VAL D'ARNO", 'PI'),
    'F687': ('MONTOPOLI DI SABINA', 'RI'),
    'F688': ('MONTORFANO', 'CO'),
    'F689': ('MONTORIO NEI FRENTANI', 'CB'),
    'F690': ('MONTORIO AL VOMANO', 'TE'),
    'F692': ('MONTORIO ROMANO', 'RM'),
    'F696': ('MONTORSO VICENTINO', 'VI'),
    'F697': ('MONTOTTONE', 'FM'),
    'F698': ('MONTRESTA', 'OR'),
    'F701': ('MONTÙ BECCARIA', 'PV'),
    'F703': ('MONVALLE', 'VA'),
    'F704': ('MONZA', 'MB'),
    'F705': ('MONZAMBANO', 'MN'),
    'F706': ('MONZUNO', 'BO'),
    'F707': ('MORANO SUL PO', 'AL'),
    'F708': ('MORANO CALABRO', 'CS'),
    'F709': ('MORANSENGO', 'AT'),
    'F710': ('MORARO', 'GO'),
    'F711': ('MORAZZONE', 'VA'),
    'F712': ('MORBEGNO', 'SO'),
    'F713': ('MORBELLO', 'AL'),
    'F715': ('MORCIANO DI ROMAGNA', 'RN'),
    'F716': ('MORCIANO DI LEUCA', 'LE'),
    'F717': ('MORCONE', 'BN'),
    'F718': ('MORDANO', 'BO'),
    'F720': ('MORENGO', 'BG'),
    'F721': ('MORES', 'SS'),
    'F722': ('MORESCO', 'FM'),
    'F723': ('MORETTA', 'CN'),
    'F724': ('MORFASSO', 'PC'),
    'F725': ('MORGANO', 'TV'),
    'F726': ('MORGEX', 'AO'),
    'F727': ('MORGONGIORI', 'OR'),
    'F728': ('MORI', 'TN'),
    'F729': ('MORIAGO DELLA BATTAGLIA', 'TV'),
    'F730': ('MORICONE', 'RM'),
    'F731': ('MORIGERATI', 'SA'),
    'F732': ('MORINO', 'AQ'),
    'F733': ('MORIONDO TORINESE', 'TO'),
    'F734': ('MORLUPO', 'RM'),
    'F735': ('MORMANNO', 'CS'),
    'F736': ('MORNAGO', 'VA'),
    'F737': ('MORNESE', 'AL'),
    'F738': ('MORNICO AL SERIO', 'BG'),
    'F739': ('MORNICO LOSANA', 'PV'),
    'F740': ('MOROLO', 'FR'),
    'F743': ('MOROZZO', 'CN'),
    'F744': ('MORRA DE SANCTIS', 'AV'),
    'F745': ("MORRO D'ALBA", 'AN'),
    'F746': ('MORRO REATINO', 'RI'),
    'F747': ("MORRO D'ORO", 'TE'),
    'F748': ('MORRONE DEL SANNIO', 'CB'),
    'F749': ('MORROVALLE', 'MC'),
    'F750': ('MORSANO AL TAGLIAMENTO', 'PN'),
    'F751': ('MORSASCO', 'AL'),
    'F754': ('MORTARA', 'PV'),
    'F756': ('MORTEGLIANO', 'UD'),
    'F758': ('MORTERONE', 'LC'),
    'F760': ('MORUZZO', 'UD'),
    'F761': ('MOSCAZZANO', 'CR'),
    'F762': ('MOSCHIANO', 'AV'),
    'F764': ("MOSCIANO SANT'ANGELO", 'TE'),
    'F765': ('MOSCUFO', 'PE'),
    'F766': ('MOSO IN PASSIRIA/MOOS IN PASSEIER', 'BZ'),
    'F767': ('MOSSA', 'GO'),
    'F770': ('MOTTA DI LIVENZA', 'TV'),
    'F771': ('MOTTA BALUFFI', 'CR'),
    'F772': ('MOTTA CAMASTRA', 'ME'),
    'F773': ("MOTTA D'AFFERMO", 'ME'),
    'F774': ("MOTTA DE' CONTI", 'VC'),
    'F775': ('MOTTAFOLLONE', 'CS'),
    'F776': ('MOTTALCIATA', 'BI'),
    'F777': ('MOTTA MONTECORVINO', 'FG'),
    'F779': ('MOTTA SAN GIOVANNI', 'RC'),
    'F780': ('MOTTA SANTA LUCIA', 'CZ'),
    'F781': ("MOTTA SANT'ANASTASIA", 'CT'),
    'F783': ('MOTTA VISCONTI', 'MI'),
    'F784': ('MOTTOLA', 'TA'),
    'F785': ('MOZZAGROGNA', 'CH'),
    'F786': ('MOZZANICA', 'BG'),
    'F788': ('MOZZATE', 'CO'),
    'F789': ('MOZZECANE', 'VR'),
    'F791': ('MOZZO', 'BG'),
    'F793': ('MUCCIA', 'MC'),
    'F795': ('MUGGIA', 'TS'),
    'F797': ('MUGGIÒ', 'MB'),
    'F798': ('MUGNANO DEL CARDINALE', 'AV'),
    'F799': ('MUGNANO DI NAPOLI', 'NA'),
    'F801': ('MULAZZANO', 'LO'),
    'F802': ('MULAZZO', 'MS'),
    'F806': ('MURA', 'BS'),
    'F808': ('MURAVERA', 'SU'),
    'F809': ('MURAZZANO', 'CN'),
    'F810': ('SALCEDO', 'VI'),
    'F811': ('MURELLO', 'CN'),
    'F813': ('MURIALDO', 'SV'),
    'F814': ('MURISENGO', 'AL'),
    'F815': ('MURLO', 'SI'),
    'F816': ('MURO LECCESE', 'LE'),
    'F817': ('MURO LUCANO', 'PZ'),
    'F818': ('MUROS', 'SS'),
    'F820': ('MUSCOLINE', 'BS'),
    'F822': ('MUSEI', 'SU'),
    'F826': ('MUSILE DI PIAVE', 'VE'),
    'F828': ('MUSSO', 'CO'),
    'F829': ('MUSSOLENTE', 'VI'),
    'F830': ('MUSSOMELI', 'CL'),
    'F831': ('PINETO', 'TE'),
    'F832': ('MUZZANA DEL TURGNANO', 'UD'),
    'F833': ('MUZZANO', 'BI'),
    'F835': ('NAGO-TORBOLE', 'TN'),
    'F836': ('NALLES/NALS', 'BZ'),
    'F838': ('NANTO', 'VI'),
    'F839': ('NAPOLI', 'NA'),
    'F840': ('NARBOLIA', 'OR'),
    'F841': ('NARCAO', 'SU'),
    'F842': ('NARDÒ', 'LE'),
    'F843': ('NARDODIPACE', 'VV'),
    'F844': ('NARNI', 'TR'),
    'F845': ('NARO', 'AG'),
    'F846': ('NARZOLE', 'CN'),
    'F847': ('NASINO', 'SV'),
    'F848': ('NASO', 'ME'),
    'F849': ('NATURNO/NATURNS', 'BZ'),
    'F851': ('NAVE', 'BS'),
    'F852': ('NAVELLI', 'AQ'),
    'F856': ('NAZ-SCIAVES/NATZ-SCHABS', 'BZ'),
    'F857': ('NAZZANO', 'RM'),
    'F858': ('NE', 'GE'),
    'F859': ('NEBBIUNO', 'NO'),
    'F861': ('NEGRAR DI VALPOLICELLA', 'VR'),
    'F862': ('NEIRONE', 'GE'),
    'F863': ('NEIVE', 'CN'),
    'F864': ('NEMBRO', 'BG'),
    'F865': ('NEMI', 'RM'),
    'F866': ('NEMOLI', 'PZ'),
    'F867': ('NEONELI', 'OR'),
    'F868': ('NEPI', 'VT'),
    'F870': ('NERETO', 'TE'),
    'F871': ('NEROLA', 'RM'),
    'F872': ('NERVESA DELLA BATTAGLIA', 'TV'),
    'F874': ('NERVIANO', 'MI'),
    'F876': ('NESPOLO', 'RI'),
    'F877': ('NESSO', 'CO'),
    'F878': ('NETRO', 'BI'),
    'F880': ('NETTUNO', 'RM'),
    'F881': ('NEVIANO', 'LE'),
    'F882': ('NEVIANO DEGLI ARDUINI', 'PR'),
    'F883': ('NEVIGLIE', 'CN'),
    'F884': ('NIARDO', 'BS'),
    'F886': ('NIBBIOLA', 'NO'),
    'F887': ('NIBIONNO', 'LC'),
    'F889': ('NICHELINO', 'TO'),
    'F890': ('NICOLOSI', 'CT'),
    'F891': ('NICORVO', 'PV'),
    'F892': ('NICOSIA', 'EN'),
    'F893': ('NICOTERA', 'VV'),
    'F894': ('NIELLA BELBO', 'CN'),
    'F895': ('NIELLA TANARO', 'CN'),
    'F898': ('NIMIS', 'UD'),
    'F899': ('NISCEMI', 'CL'),
    'F900': ('NISSORIA', 'EN'),
    'F901': ('NIZZA DI SICILIA', 'ME'),
    'F902': ('NIZZA MONFERRATO', 'AT'),
    'F904': ('NOALE', 'VE'),
    'F906': ('NOASCA', 'TO'),
    'F907': ('NOCARA', 'CS'),
    'F908': ('NOCCIANO', 'PE'),
    'F910': ('NOCERA TERINESE', 'CZ'),
    'F911': ('NOCERA UMBRA', 'PG'),
    'F912': ('NOCERA INFERIORE', 'SA'),
    'F913': ('NOCERA SUPERIORE', 'SA'),
    'F914': ('NOCETO', 'PR'),
    'F915': ('NOCI', 'BA'),
    'F916': ('NOCIGLIA', 'LE'),
    'F917': ('NOEPOLI', 'PZ'),
    'F918': ('NOGARA', 'VR'),
    'F920': ('NOGAREDO', 'TN'),
    'F921': ('NOGAROLE ROCCA', 'VR'),
    'F922': ('NOGAROLE VICENTINO', 'VI'),
    'F923': ('NOICATTARO', 'BA'),
    'F924': ('NOLA', 'NA'),
    'F925': ('NOLE', 'TO'),
    'F926': ('NOLI', 'SV'),
    'F927': ('NOMAGLIO', 'TO'),
    'F929': ('NOMI', 'TN'),
    'F930': ('NONANTOLA', 'MO'),
    'F931': ('NONE', 'TO'),
    'F932': ('NONIO', 'VB'),
    'F933': ('NORAGUGUME', 'NU'),
    'F934': ('NORBELLO', 'OR'),
    'F935': ('NORCIA', 'PG'),
    'F937': ('NORMA', 'LT'),
    'F939': ('NOSATE', 'MI'),
    'F941': ('PONTE NOSSA', 'BG'),
    'F942': ('NOTARESCO', 'TE'),
    'F943': ('NOTO', 'SR'),
    'F944': ('NOVA MILANESE', 'MB'),
    'F947': ('NOVALEDO', 'TN'),
    'F948': ('NOVALESA', 'TO'),
    'F949': ('NOVA LEVANTE/WELSCHNOFEN', 'BZ'),
    'F950': ('NOVA PONENTE/DEUTSCHNOFEN', 'BZ'),
    'F951': ('NOVARA DI SICILIA', 'ME'),
    'F952': ('NOVARA', 'NO'),
    'F955': ('NOVATE MILANESE', 'MI'),
    'F956': ('NOVATE MEZZOLA', 'SO'),
    'F957': ('NOVE', 'VI'),
    'F958': ('NOVEDRATE', 'CO'),
    'F960': ('NOVELLARA', 'RE'),
    'F961': ('NOVELLO', 'CN'),
    'F962': ('NOVENTA PADOVANA', 'PD'),
    'F963': ('NOVENTA DI PIAVE', 'VE'),
    'F964': ('NOVENTA VICENTINA', 'VI'),
    'F965': ('NOVI LIGURE', 'AL'),
    'F966': ('NOVI DI MODENA', 'MO'),
    'F967': ('NOVI VELIA', 'SA'),
    'F968': ('NOVIGLIO', 'MI'),
    'F970': ('NOVOLI', 'LE'),
    'F972': ('NUCETTO', 'CN'),
    'F974': ('NUGHEDU SANTA VITTORIA', 'OR'),
    'F975': ('NUGHEDU SAN NICOLÒ', 'SS'),
    'F976': ('NULE', 'SS'),
    'F977': ('NULVI', 'SS'),
    'F978': ('NUMANA', 'AN'),
    'F979': ('NUORO', 'NU'),
    'F980': ('NURACHI', 'OR'),
    'F981': ('NURAGUS', 'SU'),
    'F982': ('NURALLAO', 'SU'),
    'F983': ('NURAMINIS', 'SU'),
    'F985': ('NURECI', 'OR'),
    'F986': ('NURRI', 'SU'),
    'F987': ('NUS', 'AO'),
    'F988': ('NUSCO', 'AV'),
    'F989': ('NUVOLENTO', 'BS'),
    'F990': ('NUVOLERA', 'BS'),
    'F991': ('NUXIS', 'SU'),
    'F992': ('OCCHIEPPO INFERIORE', 'BI'),
    'F993': ('OCCHIEPPO SUPERIORE', 'BI'),
    'F994': ('OCCHIOBELLO', 'RO'),
    'F995': ('OCCIMIANO', 'AL'),
    'F996': ('OCRE', 'AQ'),
    'F997': ('ODALENGO GRANDE', 'AL'),
    'F998': ('ODALENGO PICCOLO', 'AL'),
    'F999': ('ODERZO', 'TV'),
    'G001': ('ODOLO', 'BS'),
    'G002': ('OFENA', 'AQ'),
    'G003': ('OFFAGNA', 'AN'),
    'G004': ('OFFANENGO', 'CR'),
    'G005': ('OFFIDA', 'AP'),
    'G006': ('OFFLAGA', 'BS'),
    'G007': ('OGGEBBIO', 'VB'),
    'G008': ('OGGIONA CON SANTO STEFANO', 'VA'),
    'G009': ('OGGIONO', 'LC'),
    'G010': ('OGLIANICO', 'TO'),
    'G011': ('OGLIASTRO CILENTO', 'SA'),
    'G012': ('OYACE', 'AO'),
    'G015': ('OLBIA', 'SS'),
    'G016': ('OLCENENGO', 'VC'),
    'G018': ('OLDENICO', 'VC'),
    'G019': ('OLEGGIO', 'NO'),
    'G020': ('OLEGGIO CASTELLO', 'NO'),
    'G021': ('OLEVANO DI LOMELLINA', 'PV'),
    'G022': ('OLEVANO ROMANO', 'RM'),
    'G023': ('OLEVANO SUL TUSCIANO', 'SA'),
    'G025': ('OLGIATE COMASCO', 'CO'),
    'G026': ('OLGIATE MOLGORA', 'LC'),
    'G028': ('OLGIATE OLONA', 'VA'),
    'G030': ('OLGINATE', 'LC'),
    'G031': ('OLIENA', 'NU'),
    'G032': ('OLIVA GESSI', 'PV'),
    'G034': ('OLIVADI', 'CZ'),
    'G036': ('OLIVERI', 'ME'),
    'G037': ('OLIVETO LUCANO', 'MT'),
    'G039': ('OLIVETO CITRA', 'SA'),
    'G040': ('OLIVETO LARIO', 'LC'),
    'G041': ('OLIVETTA SAN MICHELE', 'IM'),
    'G042': ('OLIVOLA', 'AL'),
    'G043': ('OLLASTRA', 'OR'),
    'G044': ('OLLOLAI', 'NU'),
    'G045': ('OLLOMONT', 'AO'),
    'G046': ('OLMEDO', 'SS'),
    'G047': ('OLMENETA', 'CR'),
    'G048': ('OLMO GENTILE', 'AT'),
    'G049': ('OLMO AL BREMBO', 'BG'),
    'G050': ('OLTRE IL COLLE', 'BG'),
    'G054': ('OLTRESSENDA ALTA', 'BG'),
    'G056': ('OLTRONA DI SAN MAMETTE', 'CO'),
    'G058': ('OLZAI', 'NU'),
    'G061': ('OME', 'BS'),
    'G062': ('OMEGNA', 'VB'),
    'G063': ('OMIGNANO', 'SA'),
    'G064': ('ONANÌ', 'NU'),
    'G065': ('ONANO', 'VT'),
    'G066': ('ONCINO', 'CN'),
    'G068': ('ONETA', 'BG'),
    'G070': ('ONIFAI', 'NU'),
    'G071': ('ONIFERI', 'NU'),
    'G074': ('ONO SAN PIETRO', 'BS'),
    'G075': ('ONORE', 'BG'),
    'G076': ('ONZO', 'SV'),
    'G078': ('OPERA', 'MI'),
    'G079': ('OPI', 'AQ'),
    'G080': ('OPPEANO', 'VR'),
    'G081': ('OPPIDO LUCANO', 'PZ'),
    'G082': ('OPPIDO MAMERTINA', 'RC'),
    'G083': ('ORA/AUER', 'BZ'),
    'G084': ('ORANI', 'NU'),
    'G086': ('ORATINO', 'CB'),
    'G087': ('ORBASSANO', 'TO'),
    'G088': ('ORBETELLO', 'GR'),
    'G090': ('ORCIANO PISANO', 'PI'),
    'G093': ('ORERO', 'GE'),
    'G095': ('ORGIANO', 'VI'),
    'G096': ('PIEVE FISSIRAGA', 'LO'),
    'G097': ('ORGOSOLO', 'NU'),
    'G098': ('ORIA', 'BR'),
    'G102': ('ORICOLA', 'AQ'),
    'G103': ('ORIGGIO', 'VA'),
    'G105': ('ORINO', 'VA'),
    'G107': ('ORIO LITTA', 'LO'),
    'G108': ('ORIO AL SERIO', 'BG'),
    'G109': ('ORIO CANAVESE', 'TO'),
    'G110': ('ORIOLO', 'CS'),
    'G111': ('ORIOLO ROMANO', 'VT'),
    'G113': ('ORISTANO', 'OR'),
    'G114': ('ORMEA', 'CN'),
    'G115': ('ORMELLE', 'TV'),
    'G116': ('ORNAGO', 'MB'),
    'G117': ('ORNAVASSO', 'VB'),
    'G118': ('ORNICA', 'BG'),
    'G119': ('OROSEI', 'NU'),
    'G120': ('OROTELLI', 'NU'),
    'G121': ('ORRIA', 'SA'),
    'G122': ('ORROLI', 'SU'),
    'G123': ('ORSAGO', 'TV'),
    'G124': ('ORSARA BORMIDA', 'AL'),
    'G125': ('ORSARA DI PUGLIA', 'FG'),
    'G126': ('ORSENIGO', 'CO'),
    'G128': ('ORSOGNA', 'CH'),
    'G129': ('ORSOMARSO', 'CS'),
    'G130': ('ORTA DI ATELLA', 'CE'),
    'G131': ('ORTA NOVA', 'FG'),
    'G133': ('ORTACESUS', 'SU'),
    'G134': ('ORTA SAN GIULIO', 'NO'),
    'G135': ('ORTE', 'VT'),
    'G136': ('ORTELLE', 'LE'),
    'G137': ('ORTEZZANO', 'FM'),
    'G139': ('ORTIGNANO RAGGIOLO', 'AR'),
    'G140': ('ORTISEI/ST. ULRICH', 'BZ'),
    'G141': ('ORTONA', 'CH'),
    'G142': ('ORTONA DEI MARSI', 'AQ'),
    'G143': ('LUNI', 'SP'),
    'G144': ('ORTOVERO', 'SV'),
    'G145': ('ORTUCCHIO', 'AQ'),
    'G146': ('ORTUERI', 'NU'),
    'G147': ('ORUNE', 'NU'),
    'G148': ('ORVIETO', 'TR'),
    'G149': ('ORZINUOVI', 'BS'),
    'G150': ('ORZIVECCHI', 'BS'),
    'G151': ('OSASCO', 'TO'),
    'G152': ('OSASIO', 'TO'),
    'G153': ('OSCHIRI', 'SS'),
    'G154': ('OSIDDA', 'NU'),
    'G155': ('OSIGLIA', 'SV'),
    'G156': ('OSILO', 'SS'),
    'G157': ('OSIMO', 'AN'),
    'G158': ('OSINI', 'NU'),
    'G159': ('OSIO SOPRA', 'BG'),
    'G160': ('OSIO SOTTO', 'BG'),
    'G161': ('OSNAGO', 'LC'),
    'G163': ('OSOPPO', 'UD'),
    'G164': ('OSPEDALETTI', 'IM'),
    'G165': ("OSPEDALETTO D'ALPINOLO", 'AV'),
    'G166': ('OSPEDALETTO LODIGIANO', 'LO'),
    'G167': ('OSPEDALETTO EUGANEO', 'PD'),
    'G168': ('OSPEDALETTO', 'TN'),
    'G169': ('OSPITALE DI CADORE', 'BL'),
    'G170': ('OSPITALETTO', 'BS'),
    'G171': ('OSSAGO LODIGIANO', 'LO'),
    'G173': ('OSSANA', 'TN'),
    'G178': ('OSSI', 'SS'),
    'G179': ('OSSIMO', 'BS'),
    'G181': ('OSSONA', 'MI'),
    'G183': ('OSTANA', 'CN'),
    'G184': ('OSTELLATO', 'FE'),
    'G185': ('OSTIANO', 'CR'),
    'G186': ('OSTIGLIA', 'MN'),
    'G187': ('OSTUNI', 'BR'),
    'G188': ('OTRANTO', 'LE'),
    'G189': ('OTRICOLI', 'TR'),
    'G190': ('OTTAVIANO', 'NA'),
    'G191': ('OTTANA', 'NU'),
    'G192': ('OTTATI', 'SA'),
    'G193': ('OTTIGLIO', 'AL'),
    'G194': ('OTTOBIANO', 'PV'),
    'G195': ('OTTONE', 'PC'),
    'G196': ('OULX', 'TO'),
    'G197': ('OVADA', 'AL'),
    'G198': ('OVARO', 'UD'),
    'G199': ('OVIGLIO', 'AL'),
    'G200': ('OVINDOLI', 'AQ'),
    'G201': ('OVODDA', 'NU'),
    'G202': ('OZEGNA', 'TO'),
    'G203': ('OZIERI', 'SS'),
    'G204': ('OZZANO MONFERRATO', 'AL'),
    'G205': ("OZZANO DELL'EMILIA", 'BO'),
    'G206': ('OZZERO', 'MI'),
    'G207': ('PABILLONIS', 'SU'),
    'G208': ('PACECO', 'TP'),
    'G209': ('PACE DEL MELA', 'ME'),
    'G210': ('PACENTRO', 'AQ'),
    'G211': ('PACHINO', 'SR'),
    'G212': ('PACIANO', 'PG'),
    'G213': ('PADENGHE SUL GARDA', 'BS'),
    'G215': ('PADERNA', 'AL'),
    'G217': ('PADERNO FRANCIACORTA', 'BS'),
    'G218': ("PADERNO D'ADDA", 'LC'),
    'G220': ('PADERNO DUGNANO', 'MI'),
    'G222': ('PADERNO PONCHIELLI', 'CR'),
    'G223': ('ROBBIATE', 'LC'),
    'G224': ('PADOVA', 'PD'),
    'G225': ('PADRIA', 'SS'),
    'G226': ('PADULA', 'SA'),
    'G227': ('PADULI', 'BN'),
    'G228': ('PAESANA', 'CN'),
    'G229': ('PAESE', 'TV'),
    'G230': ('PAGANI', 'SA'),
    'G232': ('PAGANICO SABINO', 'RI'),
    'G233': ('PAGAZZANO', 'BG'),
    'G234': ('PAGLIARA', 'ME'),
    'G237': ('PAGLIETA', 'CH'),
    'G238': ('PAGNACCO', 'UD'),
    'G240': ('PAGNO', 'CN'),
    'G241': ('PAGNONA', 'LC'),
    'G242': ('PAGO DEL VALLO DI LAURO', 'AV'),
    'G243': ('PAGO VEIANO', 'BN'),
    'G247': ('PAISCO LOVENO', 'BS'),
    'G248': ('PAITONE', 'BS'),
    'G249': ('PALADINA', 'BG'),
    'G250': ('PALAGANO', 'MO'),
    'G251': ('PALAGIANELLO', 'TA'),
    'G252': ('PALAGIANO', 'TA'),
    'G253': ('PALAGONIA', 'CT'),
    'G254': ('PALAIA', 'PI'),
    'G255': ('PALANZANO', 'PR'),
    'G257': ('PALATA', 'CB'),
    'G258': ('PALAU', 'SS'),
    'G259': ('PALAZZAGO', 'BG'),
    'G260': ('PALAZZO PIGNANO', 'CR'),
    'G261': ('PALAZZO SAN GERVASIO', 'PZ'),
    'G262': ('PALAZZO CANAVESE', 'TO'),
    'G263': ('PALAZZO ADRIANO', 'PA'),
    'G264': ("PALAZZOLO SULL'OGLIO", 'BS'),
    'G266': ('PALAZZOLO VERCELLESE', 'VC'),
    'G267': ('PALAZZOLO ACREIDE', 'SR'),
    'G268': ('PALAZZOLO DELLO STELLA', 'UD'),
    'G270': ('PALAZZUOLO SUL SENIO', 'FI'),
    'G271': ('PALENA', 'CH'),
    'G272': ('PALERMITI', 'CZ'),
    'G273': ('PALERMO', 'PA'),
    'G274': ('PALESTRINA', 'RM'),
    'G275': ('PALESTRO', 'PV'),
    'G276': ('PALIANO', 'FR'),
    'G277': ('PALIZZI', 'RC'),
    'G278': ('PALLAGORIO', 'KR'),
    'G280': ('PALLANZENO', 'VB'),
    'G281': ('PALLARE', 'SV'),
    'G282': ('PALMA DI MONTECHIARO', 'AG'),
    'G283': ('PALMA CAMPANIA', 'NA'),
    'G284': ('PALMANOVA', 'UD'),
    'G285': ('PALMARIGGI', 'LE'),
    'G286': ('PALMAS ARBOREA', 'OR'),
    'G287': ('SAN GIOVANNI SUERGIU', 'SU'),
    'G288': ('PALMI', 'RC'),
    'G289': ('PALMIANO', 'AP'),
    'G290': ('PALMOLI', 'CH'),
    'G291': ('PALO DEL COLLE', 'BA'),
    'G292': ('PALOMONTE', 'SA'),
    'G293': ('PALOMBARA SABINA', 'RM'),
    'G294': ('PALOMBARO', 'CH'),
    'G295': ('PALOSCO', 'BG'),
    'G296': ('PALÙ DEL FERSINA', 'TN'),
    'G297': ('PALÙ', 'VR'),
    'G298': ('PALUDI', 'CS'),
    'G299': ('PLAUS/PLAUS', 'BZ'),
    'G300': ('PALUZZA', 'UD'),
    'G302': ('PAMPARATO', 'CN'),
    'G303': ('PANCALIERI', 'TO'),
    'G304': ('PANCARANA', 'PV'),
    'G305': ('PANCHIÀ', 'TN'),
    'G306': ('PANDINO', 'CR'),
    'G307': ('PANETTIERI', 'CS'),
    'G308': ('PANICALE', 'PG'),
    'G309': ('VILLARICCA', 'NA'),
    'G311': ('PANNARANO', 'BN'),
    'G312': ('PANNI', 'FG'),
    'G315': ('PANTELLERIA', 'TP'),
    'G316': ('PANTIGLIATE', 'MI'),
    'G317': ('PAOLA', 'CS'),
    'G318': ('PAOLISI', 'BN'),
    'G319': ('VALDERICE', 'TP'),
    'G320': ('PAPASIDERO', 'CS'),
    'G323': ('PAPOZZE', 'RO'),
    'G324': ('PARABIAGO', 'MI'),
    'G325': ('PARABITA', 'LE'),
    'G327': ('PARATICO', 'BS'),
    'G328': ('PARCINES/PARTSCHINS', 'BZ'),
    'G330': ('PARELLA', 'TO'),
    'G331': ('PARENTI', 'CS'),
    'G333': ('PARETE', 'CE'),
    'G334': ('PARETO', 'AL'),
    'G335': ('PARGHELIA', 'VV'),
    'G336': ('PARLASCO', 'LC'),
    'G337': ('PARMA', 'PR'),
    'G338': ('PARODI LIGURE', 'AL'),
    'G339': ('PAROLDO', 'CN'),
    'G340': ('PAROLISE', 'AV'),
    'G342': ('PARONA', 'PV'),
    'G344': ('PARRANO', 'TR'),
    'G346': ('PARRE', 'BG'),
    'G347': ('PARTANNA', 'TP'),
    'G348': ('PARTINICO', 'PA'),
    'G349': ('PARUZZARO', 'NO'),
    'G350': ('PARZANICA', 'BG'),
    'G352': ('PASIAN DI PRATO', 'UD'),
    'G353': ('PASIANO DI PORDENONE', 'PN'),
    'G354': ('PASPARDO', 'BS'),
    'G358': ('PASSERANO MARMORITO', 'AT'),
    'G359': ('PASSIGNANO SUL TRASIMENO', 'PG'),
    'G361': ('PASSIRANO', 'BS'),
    'G362': ('PASTENA', 'FR'),
    'G364': ('PASTORANO', 'CE'),
    'G365': ('PASTRENGO', 'VR'),
    'G367': ('PASTURANA', 'AL'),
    'G368': ('PASTURO', 'LC'),
    'G370': ('PATERNOPOLI', 'AV'),
    'G371': ('PATERNÒ', 'CT'),
    'G372': ('PATERNO CALABRO', 'CS'),
    'G374': ('PATRICA', 'FR'),
    'G376': ('PATTADA', 'SS'),
    'G377': ('PATTI', 'ME'),
    'G378': ('PATÙ', 'LE'),
    'G379': ('PAU', 'OR'),
    'G381': ('PAULARO', 'UD'),
    'G382': ('PAULI ARBAREI', 'SU'),
    'G383': ('SAN NICOLÒ GERREI', 'SU'),
    'G384': ('PAULILATINO', 'OR'),
    'G385': ('PAULLO', 'MI'),
    'G386': ('PAUPISI', 'BN'),
    'G387': ('PAVAROLO', 'TO'),
    'G388': ('PAVIA', 'PV'),
    'G389': ('PAVIA DI UDINE', 'UD'),
    'G391': ('PAVONE DEL MELLA', 'BS'),
    'G392': ('PAVONE CANAVESE', 'TO'),
    'G393': ('PAVULLO NEL FRIGNANO', 'MO'),
    'G394': ('PAZZANO', 'RC'),
    'G395': ('PECCIOLI', 'PI'),
    'G397': ('PECETTO DI VALENZA', 'AL'),
    'G398': ('PECETTO TORINESE', 'TO'),
    'G402': ('PEDARA', 'CT'),
    'G403': ('PEDASO', 'FM'),
    'G404': ('PEDAVENA', 'BL'),
    'G406': ('PEDEMONTE', 'VI'),
    'G407': ('SAN PAOLO', 'BS'),
    'G408': ('PEDEROBBA', 'TV'),
    'G410': ('PEDESINA', 'SO'),
    'G411': ('PEDIVIGLIANO', 'CS'),
    'G412': ('PEDRENGO', 'BG'),
    'G415': ('PEGLIO', 'CO'),
    'G416': ('PEGLIO', 'PU'),
    'G417': ('PEGOGNAGA', 'MN'),
    'G418': ('PEIA', 'BG'),
    'G419': ('PEIO', 'TN'),
    'G420': ('PELAGO', 'FI'),
    'G421': ('PELLA', 'NO'),
    'G424': ('PELLEGRINO PARMENSE', 'PR'),
    'G426': ('PELLEZZANO', 'SA'),
    'G428': ('PELLIZZANO', 'TN'),
    'G429': ('PELUGO', 'TN'),
    'G430': ('PENANGO', 'AT'),
    'G431': ('POGGIRIDENTI', 'SO'),
    'G432': ('PENNA IN TEVERINA', 'TR'),
    'G433': ('PENNABILLI', 'RN'),
    'G434': ('PENNADOMO', 'CH'),
    'G435': ('PENNAPIEDIMONTE', 'CH'),
    'G436': ('PENNA SAN GIOVANNI', 'MC'),
    'G437': ("PENNA SANT'ANDREA", 'TE'),
    'G438': ('PENNE', 'PE'),
    'G439': ('PENTONE', 'CZ'),
    'G441': ('PERANO', 'CH'),
    'G442': ('PERAROLO DI CADORE', 'BL'),
    'G443': ('PERCA/PERCHA', 'BZ'),
    'G444': ('PERCILE', 'RM'),
    'G445': ('PERDASDEFOGU', 'NU'),
    'G446': ('PERDAXIUS', 'SU'),
    'G447': ('PERDIFUMO', 'SA'),
    'G449': ('PERETO', 'AQ'),
    'G450': ('PERFUGAS', 'SS'),
    'G452': ('PERGINE VALSUGANA', 'TN'),
    'G453': ('PERGOLA', 'PU'),
    'G454': ('PERINALDO', 'IM'),
    'G455': ('PERITO', 'SA'),
    'G456': ('PERLEDO', 'LC'),
    'G457': ('PERLETTO', 'CN'),
    'G458': ('PERLO', 'CN'),
    'G459': ('PERLOZ', 'AO'),
    'G461': ('PERNUMIA', 'PD'),
    'G462': ('PEROSA CANAVESE', 'TO'),
    'G463': ('PEROSA ARGENTINA', 'TO'),
    'G465': ('PERRERO', 'TO'),
    'G467': ('SAN GIOVANNI IN PERSICETO', 'BO'),
    'G469': ('PERSICO DOSIMO', 'CR'),
    'G471': ('PERTENGO', 'VC'),
    'G474': ('PERTICA ALTA', 'BS'),
    'G475': ('PERTICA BASSA', 'BS'),
    'G476': ('PERTOSA', 'SA'),
    'G477': ('PERTUSIO', 'TO'),
    'G478': ('PERUGIA', 'PG'),
    'G479': ('PESARO', 'PU'),
    'G480': ('PESCAGLIA', 'LU'),
    'G481': ('PESCANTINA', 'VR'),
    'G482': ('PESCARA', 'PE'),
    'G483': ('PESCAROLO ED UNITI', 'CR'),
    'G484': ('PESCASSEROLI', 'AQ'),
    'G485': ('PESCATE', 'LC'),
    'G486': ('PESCHE', 'IS'),
    'G487': ('PESCHICI', 'FG'),
    'G488': ('PESCHIERA BORROMEO', 'MI'),
    'G489': ('PESCHIERA DEL GARDA', 'VR'),
    'G491': ('PESCIA', 'PT'),
    'G492': ('PESCINA', 'AQ'),
    'G493': ('PESCOCOSTANZO', 'AQ'),
    'G494': ('PESCO SANNITA', 'BN'),
    'G495': ('PESCOLANCIANO', 'IS'),
    'G496': ('PESCOPAGANO', 'PZ'),
    'G497': ('PESCOPENNATARO', 'IS'),
    'G498': ('PESCOROCCHIANO', 'RI'),
    'G499': ('PESCOSANSONESCO', 'PE'),
    'G500': ('PESCOSOLIDO', 'FR'),
    'G502': ('PESSANO CON BORNAGO', 'MI'),
    'G504': ('PESSINA CREMONESE', 'CR'),
    'G505': ('PESSINETTO', 'TO'),
    'G506': ('PETACCIATO', 'CB'),
    'G507': ('TURANIA', 'RI'),
    'G508': ('PETILIA POLICASTRO', 'KR'),
    'G509': ('PETINA', 'SA'),
    'G510': ('PETRALIA SOPRANA', 'PA'),
    'G511': ('PETRALIA SOTTANA', 'PA'),
    'G512': ('PETRELLA TIFERNINA', 'CB'),
    'G513': ('PETRELLA SALTO', 'RI'),
    'G514': ('PETRIANO', 'PU'),
    'G515': ('PETRIOLO', 'MC'),
    'G516': ('PETRITOLI', 'FM'),
    'G517': ('PETRIZZI', 'CZ'),
    'G518': ('PETRONÀ', 'CZ'),
    'G519': ('PETRURO IRPINO', 'AV'),
    'G520': ('PETTENASCO', 'NO'),
    'G521': ('PETTINENGO', 'BI'),
    'G522': ('PETTINEO', 'ME'),
    'G523': ('PETTORANELLO DEL MOLISE', 'IS'),
    'G524': ('PETTORANO SUL GIZIO', 'AQ'),
    'G525': ('PETTORAZZA GRIMANI', 'RO'),
    'G526': ('PEVERAGNO', 'CN'),
    'G528': ('PEZZANA', 'VC'),
    'G529': ('PEZZAZE', 'BS'),
    'G532': ('PEZZOLO VALLE UZZONE', 'CN'),
    'G534': ("PIACENZA D'ADIGE", 'PD'),
    'G535': ('PIACENZA', 'PC'),
    'G538': ('PIAGGINE', 'SA'),
    'G540': ("VALLE DELL'ANGELO", 'SA'),
    'G541': ('PIANA DI MONTE VERNA', 'CE'),
    'G542': ('PIANA CRIXIA', 'SV'),
    'G543': ('PIANA DEGLI ALBANESI', 'PA'),
    'G545': ('PONTBOSET', 'AO'),
    'G546': ('PIAN CAMUNO', 'BS'),
    'G547': ('PIANCASTAGNAIO', 'SI'),
    'G549': ('PIANCOGNO', 'BS'),
    'G551': ('PIANDIMELETO', 'PU'),
    'G553': ('PIANE CRATI', 'CS'),
    'G555': ('PIANELLA', 'PE'),
    'G556': ('PIANELLO DEL LARIO', 'CO'),
    'G557': ('PIANELLO VAL TIDONE', 'PC'),
    'G558': ('PIANENGO', 'CR'),
    'G559': ('PIANEZZA', 'TO'),
    'G560': ('PIANEZZE', 'VI'),
    'G561': ('PIANFEI', 'CN'),
    'G564': ('PIANICO', 'BG'),
    'G565': ('PIANIGA', 'VE'),
    'G566': ('SAN BENEDETTO VAL DI SAMBRO', 'BO'),
    'G568': ('PIANO DI SORRENTO', 'NA'),
    'G570': ('PIANORO', 'BO'),
    'G571': ('PIANSANO', 'VT'),
    'G572': ('PIANTEDO', 'SO'),
    'G574': ('PIARIO', 'BG'),
    'G575': ('PIASCO', 'CN'),
    'G576': ('PIATEDA', 'SO'),
    'G577': ('PIATTO', 'BI'),
    'G579': ('PIAZZA BREMBANA', 'BG'),
    'G580': ('PIAZZA ARMERINA', 'EN'),
    'G582': ('PIAZZA AL SERCHIO', 'LU'),
    'G583': ('PIAZZATORRE', 'BG'),
    'G587': ('PIAZZOLA SUL BRENTA', 'PD'),
    'G588': ('PIAZZOLO', 'BG'),
    'G589': ('PICCIANO', 'PE'),
    'G590': ('PICERNO', 'PZ'),
    'G591': ('PICINISCO', 'FR'),
    'G592': ('PICO', 'FR'),
    'G593': ('PIEA', 'AT'),
    'G594': ('PIEDICAVALLO', 'BI'),
    'G596': ('PIEDIMONTE MATESE', 'CE'),
    'G597': ('PIEDIMONTE ETNEO', 'CT'),
    'G598': ('PIEDIMONTE SAN GERMANO', 'FR'),
    'G600': ('PIEDIMULERA', 'VB'),
    'G601': ('PIEGARO', 'PG'),
    'G602': ('PIENZA', 'SI'),
    'G603': ('PIERANICA', 'CR'),
    'G604': ('PIETRAMONTECORVINO', 'FG'),
    'G605': ('PIETRA LIGURE', 'SV'),
    'G606': ('PIETRABBONDANTE', 'IS'),
    'G607': ('PIETRABRUNA', 'IM'),
    'G608': ('PIETRACAMELA', 'TE'),
    'G609': ('PIETRACATELLA', 'CB'),
    'G610': ('PIETRACUPA', 'CB'),
    'G611': ('PIETRADEFUSI', 'AV'),
    'G612': ("PIETRA DE' GIORGI", 'PV'),
    'G613': ('PIETRAFERRAZZANA', 'CH'),
    'G614': ('SATRIANO DI LUCANIA', 'PZ'),
    'G615': ('PIETRAFITTA', 'CS'),
    'G616': ('PIETRAGALLA', 'PZ'),
    'G618': ('PIETRALUNGA', 'PG'),
    'G619': ('PIETRA MARAZZI', 'AL'),
    'G620': ('PIETRAMELARA', 'CE'),
    'G621': ('PIETRANICO', 'PE'),
    'G622': ('PIETRAPAOLA', 'CS'),
    'G623': ('PIETRAPERTOSA', 'PZ'),
    'G624': ('PIETRAPERZIA', 'EN'),
    'G625': ('PIETRAPORZIO', 'CN'),
    'G626': ('PIETRAROJA', 'BN'),
    'G627': ('PIETRARUBBIA', 'PU'),
    'G628': ('PIETRASANTA', 'LU'),
    'G629': ('PIETRASTORNINA', 'AV'),
    'G630': ('PIETRAVAIRANO', 'CE'),
    'G631': ('PIETRELCINA', 'BN'),
    'G632': ('PIEVE DI TECO', 'IM'),
    'G634': ('PIEVE EMANUELE', 'MI'),
    'G635': ('PIEVE ALBIGNOLA', 'PV'),
    'G636': ('PIEVE A NIEVOLE', 'PT'),
    'G639': ('PIEVE DEL CAIRO', 'PV'),
    'G642': ('PIEVE DI CADORE', 'BL'),
    'G643': ('PIEVE DI CENTO', 'BO'),
    'G645': ('PIEVE DI SOLIGO', 'TV'),
    'G646': ('PIEVE LIGURE', 'GE'),
    'G647': ("PIEVE D'OLMI", 'CR'),
    'G648': ('PIEVE FOSCIANA', 'LU'),
    'G649': ('PIEVEPELAGO', 'MO'),
    'G650': ('PIEVE PORTO MORONE', 'PV'),
    'G651': ('PIEVE SAN GIACOMO', 'CR'),
    'G653': ('PIEVE SANTO STEFANO', 'AR'),
    'G656': ('PIEVE TESINO', 'TN'),
    'G657': ('PIEVE TORINA', 'MC'),
    'G658': ('PIEVE VERGONTE', 'VB'),
    'G659': ('PIGLIO', 'FR'),
    'G660': ('PIGNA', 'IM'),
    'G661': ('PIGNATARO MAGGIORE', 'CE'),
    'G662': ('PIGNATARO INTERAMNA', 'FR'),
    'G663': ('PIGNOLA', 'PZ'),
    'G664': ('PIGNONE', 'SP'),
    'G665': ('PIGRA', 'CO'),
    'G666': ('PILA', 'VC'),
    'G669': ('PIMENTEL', 'SU'),
    'G670': ('PIMONTE', 'NA'),
    'G671': ('PINAROLO PO', 'PV'),
    'G672': ('PINASCA', 'TO'),
    'G673': ('PINCARA', 'RO'),
    'G674': ('PINEROLO', 'TO'),
    'G676': ("PINO D'ASTI", 'AT'),
    'G678': ('PINO TORINESE', 'TO'),
    'G680': ('PINZANO AL TAGLIAMENTO', 'PN'),
    'G681': ('PINZOLO', 'TN'),
    'G682': ('PIOBBICO', 'PU'),
    'G683': ("PIOBESI D'ALBA", 'CN'),
    'G684': ('PIOBESI TORINESE', 'TO'),
    'G685': ('PIODE', 'VC'),
    'G686': ('PIOLTELLO', 'MI'),
    'G687': ('PIOMBINO', 'LI'),
    'G688': ('PIOMBINO DESE', 'PD'),
    'G690': ('PIORACO', 'MC'),
    'G691': ('PIOSSASCO', 'TO'),
    'G692': ('PIOVÀ MASSAIA', 'AT'),
    'G693': ('PIOVE DI SACCO', 'PD'),
    'G694': ('PIOVENE ROCCHETTE', 'VI'),
    'G696': ('PIOZZANO', 'PC'),
    'G697': ('PIOZZO', 'CN'),
    'G698': ('PRIVERNO', 'LT'),
    'G699': ('PIRAINO', 'ME'),
    'G702': ('PISA', 'PI'),
    'G703': ('PISANO', 'NO'),
    'G704': ('PISONIANO', 'RM'),
    'G705': ('PISCINA', 'TO'),
    'G707': ('PISCIOTTA', 'SA'),
    'G710': ('PISOGNE', 'BS'),
    'G712': ('PISTICCI', 'MT'),
    'G713': ('PISTOIA', 'PT'),
    'G716': ('PITIGLIANO', 'GR'),
    'G717': ('PIUBEGA', 'MN'),
    'G718': ('PIURO', 'SO'),
    'G719': ('PIVERONE', 'TO'),
    'G720': ('PIZZALE', 'PV'),
    'G721': ('PIZZIGHETTONE', 'CR'),
    'G722': ('PIZZO', 'VV'),
    'G724': ('PIZZOFERRATO', 'CH'),
    'G726': ('PIZZOLI', 'AQ'),
    'G727': ('PIZZONE', 'IS'),
    'G728': ('PIZZONI', 'VV'),
    'G729': ('PLACANICA', 'RC'),
    'G733': ('PLATACI', 'CS'),
    'G734': ('PLATANIA', 'CZ'),
    'G735': ('PLATÌ', 'RC'),
    'G736': ('TAIPANA', 'UD'),
    'G737': ('PLESIO', 'CO'),
    'G740': ('PLOAGHE', 'SS'),
    'G741': ('PLODIO', 'SV'),
    'G742': ('POCAPAGLIA', 'CN'),
    'G743': ('POCENIA', 'UD'),
    'G746': ('PODENZANA', 'MS'),
    'G747': ('PODENZANO', 'PC'),
    'G749': ('POFI', 'FR'),
    'G751': ('POGGIARDO', 'LE'),
    'G752': ('POGGIBONSI', 'SI'),
    'G753': ('POGGIO RUSCO', 'MN'),
    'G754': ('POGGIO A CAIANO', 'PO'),
    'G756': ('POGGIO BUSTONE', 'RI'),
    'G757': ('POGGIO CATINO', 'RI'),
    'G758': ('POGGIODOMO', 'PG'),
    'G760': ('POGGIOFIORITO', 'CH'),
    'G761': ('POGGIO IMPERIALE', 'FG'),
    'G762': ('POGGIOMARINO', 'NA'),
    'G763': ('POGGIO MIRTETO', 'RI'),
    'G764': ('POGGIO MOIANO', 'RI'),
    'G765': ('POGGIO NATIVO', 'RI'),
    'G766': ('POGGIO PICENZE', 'AQ'),
    'G767': ('POGGIOREALE', 'TP'),
    'G768': ('POGGIO RENATICO', 'FE'),
    'G769': ('POGGIORSINI', 'BA'),
    'G770': ('POGGIO SAN LORENZO', 'RI'),
    'G771': ('POGGIO SAN MARCELLO', 'AN'),
    'G772': ('POGLIANO MILANESE', 'MI'),
    'G773': ('POGNANA LARIO', 'CO'),
    'G774': ('POGNANO', 'BG'),
    'G775': ('POGNO', 'NO'),
    'G776': ('POJANA MAGGIORE', 'VI'),
    'G777': ('POIRINO', 'TO'),
    'G779': ('POLAVENO', 'BS'),
    'G780': ('POLCENIGO', 'PN'),
    'G782': ('POLESELLA', 'RO'),
    'G784': ('POLI', 'RM'),
    'G785': ('POLIA', 'VV'),
    'G786': ('POLICORO', 'MT'),
    'G787': ('POLIGNANO A MARE', 'BA'),
    'G788': ('SAN PIETRO IN CERRO', 'PC'),
    'G789': ('POLINAGO', 'MO'),
    'G790': ('POLINO', 'TR'),
    'G791': ('POLISTENA', 'RC'),
    'G792': ('POLIZZI GENEROSA', 'PA'),
    'G793': ('POLLA', 'SA'),
    'G794': ('POLLEIN', 'AO'),
    'G795': ('POLLENA TROCCHIA', 'NA'),
    'G796': ('POLLICA', 'SA'),
    'G797': ('POLLINA', 'PA'),
    'G798': ('POLLONE', 'BI'),
    'G799': ('POLLUTRI', 'CH'),
    'G800': ('POLONGHERA', 'CN'),
    'G801': ('POLPENAZZE DEL GARDA', 'BS'),
    'G802': ('POLVERARA', 'PD'),
    'G803': ('POLVERIGI', 'AN'),
    'G804': ('POMARANCE', 'PI'),
    'G805': ('POMARETTO', 'TO'),
    'G806': ('POMARICO', 'MT'),
    'G807': ('POMARO MONFERRATO', 'AL'),
    'G808': ('POMAROLO', 'TN'),
    'G809': ('POMBIA', 'NO'),
    'G811': ('POMEZIA', 'RM'),
    'G812': ("POMIGLIANO D'ARCO", 'NA'),
    'G813': ('POMPEI', 'NA'),
    'G814': ('POMPEIANA', 'IM'),
    'G815': ('POMPIANO', 'BS'),
    'G816': ('POMPONESCO', 'MN'),
    'G817': ('POMPU', 'OR'),
    'G818': ('PONCARALE', 'BS'),
    'G820': ('PONDERANO', 'BI'),
    'G821': ('PONNA', 'CO'),
    'G822': ('PONSACCO', 'PI'),
    'G823': ('PONSO', 'PD'),
    'G825': ('PONTASSIEVE', 'FI'),
    'G826': ('PONT CANAVESE', 'TO'),
    'G827': ('PONTE', 'BN'),
    'G829': ('PONTE IN VALTELLINA', 'SO'),
    'G830': ('PONTE GARDENA/WAIDBRUCK', 'BZ'),
    'G831': ('PONTEBBA', 'UD'),
    'G833': ('PONTE BUGGIANESE', 'PT'),
    'G834': ('PONTECAGNANO FAIANO', 'SA'),
    'G836': ('PONTECCHIO POLESINE', 'RO'),
    'G837': ('PONTECHIANALE', 'CN'),
    'G838': ('PONTECORVO', 'FR'),
    'G839': ('PONTECURONE', 'AL'),
    'G840': ('PONTEDASSIO', 'IM'),
    'G842': ("PONTE DELL'OLIO", 'PC'),
    'G843': ('PONTEDERA', 'PI'),
    'G844': ('PONTE DI LEGNO', 'BS'),
    'G846': ('PONTE DI PIAVE', 'TV'),
    'G847': ('PONTE LAMBRO', 'CO'),
    'G848': ('PONTELANDOLFO', 'BN'),
    'G849': ('PONTELATONE', 'CE'),
    'G850': ('PONTELONGO', 'PD'),
    'G851': ('PONTE NIZZA', 'PV'),
    'G852': ('PONTENURE', 'PC'),
    'G853': ('PONTERANICA', 'BG'),
    'G854': ('PONT-SAINT-MARTIN', 'AO'),
    'G855': ('PONTE SAN NICOLÒ', 'PD'),
    'G856': ('PONTE SAN PIETRO', 'BG'),
    'G858': ('PONTESTURA', 'AL'),
    'G859': ('PONTEVICO', 'BS'),
    'G860': ('PONTEY', 'AO'),
    'G861': ('PONTI', 'AL'),
    'G862': ('PONTI SUL MINCIO', 'MN'),
    'G864': ('PONTIDA', 'BG'),
    'G865': ('PONTINIA', 'LT'),
    'G866': ('PONTINVREA', 'SV'),
    'G867': ('PONTIROLO NUOVO', 'BG'),
    'G869': ('PONTOGLIO', 'BS'),
    'G870': ('PONTREMOLI', 'MS'),
    'G871': ('PONZA', 'LT'),
    'G872': ('PONZANO MONFERRATO', 'AL'),
    'G873': ('PONZANO DI FERMO', 'FM'),
    'G874': ('PONZANO ROMANO', 'RM'),
    'G875': ('PONZANO VENETO', 'TV'),
    'G877': ('PONZONE', 'AL'),
    'G878': ('POPOLI', 'PE'),
    'G879': ('POPPI', 'AR'),
    'G881': ('PORANO', 'TR'),
    'G882': ('PORCARI', 'LU'),
    'G886': ('PORCIA', 'PN'),
    'G887': ('STELLA CILENTO', 'SA'),
    'G888': ('PORDENONE', 'PN'),
    'G889': ('PORLEZZA', 'CO'),
    'G890': ('PORNASSIO', 'IM'),
    'G891': ('PORPETTO', 'UD'),
    'G894': ('PORTACOMARO', 'AT'),
    'G895': ('PORTALBERA', 'PV'),
    'G900': ('PORTE', 'TO'),
    'G902': ('PORTICI', 'NA'),
    'G903': ('PORTICO DI CASERTA', 'CE'),
    'G904': ('PORTICO E SAN BENEDETTO', 'FC'),
    'G905': ('PORTIGLIOLA', 'RC'),
    'G906': ('PORTO CERESIO', 'VA'),
    'G907': ('PORTO VALTRAVAGLIA', 'VA'),
    'G909': ('PORTOBUFFOLÈ', 'TV'),
    'G910': ('PORTOCANNONE', 'CB'),
    'G912': ('PORTOFERRAIO', 'LI'),
    'G913': ('PORTOFINO', 'GE'),
    'G914': ('PORTOGRUARO', 'VE'),
    'G916': ('PORTOMAGGIORE', 'FE'),
    'G917': ('PORTO MANTOVANO', 'MN'),
    'G919': ('PORTO RECANATI', 'MC'),
    'G920': ('PORTO SAN GIORGIO', 'FM'),
    'G921': ("PORTO SANT'ELPIDIO", 'FM'),
    'G922': ('PORTOSCUSO', 'SU'),
    'G923': ('PORTO TOLLE', 'RO'),
    'G924': ('PORTO TORRES', 'SS'),
    'G925': ('PORTOVENERE', 'SP'),
    'G926': ('PORTO VIRO', 'RO'),
    'G927': ('PORTULA', 'BI'),
    'G929': ('POSADA', 'NU'),
    'G931': ('POSINA', 'VI'),
    'G932': ('POSITANO', 'SA'),
    'G933': ('POSSAGNO', 'TV'),
    'G934': ('POSTA', 'RI'),
    'G935': ('POSTA FIBRENO', 'FR'),
    'G936': ('POSTAL/BURGSTALL', 'BZ'),
    'G937': ('POSTALESIO', 'SO'),
    'G939': ('POSTIGLIONE', 'SA'),
    'G940': ('POSTUA', 'VC'),
    'G942': ('POTENZA', 'PZ'),
    'G943': ('POVE DEL GRAPPA', 'VI'),
    'G944': ('POVEGLIANO', 'TV'),
    'G945': ('POVEGLIANO VERONESE', 'VR'),
    'G947': ('POVIGLIO', 'RE'),
    'G949': ('POVOLETTO', 'UD'),
    'G951': ('POZZAGLIA SABINA', 'RI'),
    'G953': ('POZZALLO', 'RG'),
    'G954': ('POZZILLI', 'IS'),
    'G955': ("POZZO D'ADDA", 'MI'),
    'G957': ('POZZOLEONE', 'VI'),
    'G959': ('POZZOLENGO', 'BS'),
    'G960': ('POZZOL GROPPO', 'AL'),
    'G961': ('POZZOLO FORMIGARO', 'AL'),
    'G962': ('POZZOMAGGIORE', 'SS'),
    'G963': ('POZZONOVO', 'PD'),
    'G964': ('POZZUOLI', 'NA'),
    'G965': ('POZZUOLO MARTESANA', 'MI'),
    'G966': ('POZZUOLO DEL FRIULI', 'UD'),
    'G968': ('PRADALUNGA', 'BG'),
    'G969': ('PRADAMANO', 'UD'),
    'G970': ('PRADLEVES', 'CN'),
    'G972': ('SASSO MARCONI', 'BO'),
    'G973': ('PRAGELATO', 'TO'),
    'G974': ('PRAY', 'BI'),
    'G975': ('PRAIA A MARE', 'CS'),
    'G976': ('PRAIANO', 'SA'),
    'G977': ('PRALBOINO', 'BS'),
    'G978': ('PRALI', 'TO'),
    'G979': ('PRALORMO', 'TO'),
    'G980': ('PRALUNGO', 'BI'),
    'G981': ('PRAMAGGIORE', 'VE'),
    'G982': ('PRAMOLLO', 'TO'),
    'G985': ('PRAROLO', 'VC'),
    'G986': ('PRAROSTINO', 'TO'),
    'G987': ('PRASCO', 'AL'),
    'G988': ('PRASCORSANO', 'TO'),
    'G990': ('PRATA DI PRINCIPATO ULTRA', 'AV'),
    'G991': ('PRATA SANNITA', 'CE'),
    'G992': ("PRATA D'ANSIDONIA", 'AQ'),
    'G993': ('PRATA CAMPORTACCIO', 'SO'),
    'G994': ('PRATA DI PORDENONE', 'PN'),
    'G995': ('PRATELLA', 'CE'),
    'G997': ('PRATIGLIONE', 'TO'),
    'G999': ('PRATO', 'PO'),
    'H001': ('PRATO SESIA', 'NO'),
    'H002': ('PRATO CARNICO', 'UD'),
    'H004': ('PRATO ALLO STELVIO/PRAD AM STILFSERJOCH', 'BZ'),
    'H006': ('PRATOLA SERRA', 'AV'),
    'H007': ('PRATOLA PELIGNA', 'AQ'),
    'H010': ('PRAVISDOMINI', 'PN'),
    'H011': ('PRAZZO', 'CN'),
    'H013': ('SAMO', 'RC'),
    'H014': ('PRECENICCO', 'UD'),
    'H015': ('PRECI', 'PG'),
    'H017': ('PREDAPPIO', 'FC'),
    'H018': ('PREDAZZO', 'TN'),
    'H019': ('PREDOI/PRETTAU', 'BZ'),
    'H020': ('PREDORE', 'BG'),
    'H021': ('PREDOSA', 'AL'),
    'H022': ('PREGANZIOL', 'TV'),
    'H026': ('PREGNANA MILANESE', 'MI'),
    'H027': ('PRELÀ', 'IM'),
    'H028': ('PREMANA', 'LC'),
    'H029': ('PREMARIACCO', 'UD'),
    'H030': ('PREMENO', 'VB'),
    'H033': ('PREMIA', 'VB'),
    'H034': ('PREMILCUORE', 'FC'),
    'H036': ('PREMOLO', 'BG'),
    'H037': ('PREMOSELLO-CHIOVENDA', 'VB'),
    'H038': ('PREONE', 'UD'),
    'H040': ('PREPOTTO', 'UD'),
    'H042': ('PRÉ-SAINT-DIDIER', 'AO'),
    'H043': ('PRESEGLIE', 'BS'),
    'H045': ('PRESENZANO', 'CE'),
    'H046': ('PRESEZZO', 'BG'),
    'H048': ('PRESSANA', 'VR'),
    'H052': ('PRETORO', 'CH'),
    'H055': ('PREVALLE', 'BS'),
    'H056': ('PREZZA', 'AQ'),
    'H059': ('PRIERO', 'CN'),
    'H061': ('PRIGNANO SULLA SECCHIA', 'MO'),
    'H062': ('PRIGNANO CILENTO', 'SA'),
    'H063': ('PRIMALUNA', 'LC'),
    'H068': ('PRIOCCA', 'CN'),
    'H069': ('PRIOLA', 'CN'),
    'H070': ('PRIZZI', 'PA'),
    'H071': ('PROCENO', 'VT'),
    'H072': ('PROCIDA', 'NA'),
    'H073': ('PROPATA', 'GE'),
    'H074': ('PROSERPIO', 'CO'),
    'H076': ('PROSSEDI', 'LT'),
    'H077': ('PROVAGLIO VAL SABBIA', 'BS'),
    'H078': ("PROVAGLIO D'ISEO", 'BS'),
    'H081': ('PROVES/PROVEIS', 'BZ'),
    'H083': ('PROVVIDENTI', 'CB'),
    'H085': ('PRUNETTO', 'CN'),
    'H086': ('PUEGNAGO DEL GARDA', 'BS'),
    'H087': ('PUGLIANELLO', 'BN'),
    'H088': ('PULA', 'CA'),
    'H089': ('PULFERO', 'UD'),
    'H090': ('PULSANO', 'TA'),
    'H091': ('PUMENENGO', 'BG'),
    'H094': ('PUSIANO', 'CO'),
    'H095': ('PUTIFIGARI', 'SS'),
    'H096': ('PUTIGNANO', 'BA'),
    'H097': ('QUADRELLE', 'AV'),
    'H098': ('QUADRI', 'CH'),
    'H100': ('QUAGLIUZZO', 'TO'),
    'H101': ('QUALIANO', 'NA'),
    'H102': ('QUARANTI', 'AT'),
    'H104': ('QUARGNENTO', 'AL'),
    'H106': ('QUARNA SOPRA', 'VB'),
    'H107': ('QUARNA SOTTO', 'VB'),
    'H108': ('QUARONA', 'VC'),
    'H109': ('QUARRATA', 'PT'),
    'H110': ('QUART', 'AO'),
    'H114': ('QUARTO', 'NA'),
    'H117': ("QUARTO D'ALTINO", 'VE'),
    'H118': ("QUARTU SANT'ELENA", 'CA'),
    'H119': ('QUARTUCCIU', 'CA'),
    'H120': ('QUASSOLO', 'TO'),
    'H121': ('QUATTORDIO', 'AL'),
    'H122': ('QUATTRO CASTELLA', 'RE'),
    'H126': ('QUILIANO', 'SV'),
    'H127': ('QUINCINETTO', 'TO'),
    'H128': ('QUINDICI', 'AV'),
    'H129': ('QUINGENTOLE', 'MN'),
    'H130': ('QUINTANO', 'CR'),
    'H131': ('QUINTO DI TREVISO', 'TV'),
    'H132': ('QUINTO VERCELLESE', 'VC'),
    'H134': ('QUINTO VICENTINO', 'VI'),
    'H140': ("QUINZANO D'OGLIO", 'BS'),
    'H143': ('QUISTELLO', 'MN'),
    'H146': ('RABBI', 'TN'),
    'H147': ('RACALE', 'LE'),
    'H148': ('RACALMUTO', 'AG'),
    'H150': ('RACCONIGI', 'CN'),
    'H151': ('RACCUJA', 'ME'),
    'H152': ('RACINES/RATSCHINGS', 'BZ'),
    'H153': ('RADDA IN CHIANTI', 'SI'),
    'H154': ('RADDUSA', 'CT'),
    'H156': ('RADICOFANI', 'SI'),
    'H157': ('RADICONDOLI', 'SI'),
    'H159': ('RAFFADALI', 'AG'),
    'H161': ('RAGOGNA', 'UD'),
    'H163': ('RAGUSA', 'RG'),
    'H165': ('RUVIANO', 'CE'),
    'H166': ('RAIANO', 'AQ'),
    'H168': ('RAMACCA', 'CT'),
    'H173': ('RANCIO VALCUVIA', 'VA'),
    'H174': ('RANCO', 'VA'),
    'H175': ('RANDAZZO', 'CT'),
    'H176': ('RANICA', 'BG'),
    'H177': ('RANZANICO', 'BG'),
    'H180': ('RANZO', 'IM'),
    'H182': ('RAPAGNANO', 'FM'),
    'H183': ('RAPALLO', 'GE'),
    'H184': ('RAPINO', 'CH'),
    'H185': ('RAPOLANO TERME', 'SI'),
    'H186': ('RAPOLLA', 'PZ'),
    'H187': ('RAPONE', 'PZ'),
    'H188': ('RASSA', 'VC'),
    'H189': ('RASUN-ANTERSELVA/RASEN-ANTHOLZ', 'BZ'),
    'H192': ('RASURA', 'SO'),
    'H194': ('RAVANUSA', 'AG'),
    'H195': ('RAVARINO', 'MO'),
    'H196': ('RAVASCLETTO', 'UD'),
    'H198': ('RAVELLO', 'SA'),
    'H199': ('RAVENNA', 'RA'),
    'H200': ('RAVEO', 'UD'),
    'H202': ('RAVISCANINA', 'CE'),
    'H203': ('RE', 'VB'),
    'H204': ('REA', 'PV'),
    'H205': ('REALMONTE', 'AG'),
    'H206': ('REANA DEL ROJALE', 'UD'),
    'H207': ('REANO', 'TO'),
    'H210': ('RECALE', 'CE'),
    'H211': ('RECANATI', 'MC'),
    'H212': ('RECCO', 'GE'),
    'H213': ('RECETTO', 'NO'),
    'H214': ('RECOARO TERME', 'VI'),
    'H216': ('REDAVALLE', 'PV'),
    'H218': ('REDONDESCO', 'MN'),
    'H219': ('REFRANCORE', 'AT'),
    'H220': ('REFRONTOLO', 'TV'),
    'H221': ('REGALBUTO', 'EN'),
    'H222': ('REGGELLO', 'FI'),
    'H223': ("REGGIO NELL'EMILIA", 'RE'),
    'H224': ('REGGIO DI CALABRIA', 'RC'),
    'H225': ('REGGIOLO', 'RE'),
    'H227': ('REINO', 'BN'),
    'H228': ('REITANO', 'ME'),
    'H229': ('REMANZACCO', 'UD'),
    'H230': ('REMEDELLO', 'BS'),
    'H233': ('RENATE', 'MB'),
    'H235': ('RENDE', 'CS'),
    'H236': ('RENON/RITTEN', 'BZ'),
    'H238': ('RESANA', 'TV'),
    'H240': ('RESCALDINA', 'MI'),
    'H242': ('RESIA', 'UD'),
    'H243': ('ERCOLANO', 'NA'),
    'H244': ('RESIUTTA', 'UD'),
    'H245': ('RESUTTANO', 'CL'),
    'H246': ('RETORBIDO', 'PV'),
    'H247': ('REVELLO', 'CN'),
    'H250': ("REVIGLIASCO D'ASTI", 'AT'),
    'H253': ('REVINE LAGO', 'TV'),
    'H255': ('REZZAGO', 'CO'),
    'H256': ('REZZATO', 'BS'),
    'H257': ('REZZO', 'IM'),
    'H258': ('REZZOAGLIO', 'GE'),
    'H259': ('VAL REZZO', 'CO'),
    'H262': ('RHÊMES-NOTRE-DAME', 'AO'),
    'H263': ('RHÊMES-SAINT-GEORGES', 'AO'),
    'H264': ('RHO', 'MI'),
    'H265': ('RIACE', 'RC'),
    'H266': ('RIALTO', 'SV'),
    'H267': ('RIANO', 'RM'),
    'H268': ('RIARDO', 'CE'),
    'H269': ('RIBERA', 'AG'),
    'H270': ('RIBORDONE', 'TO'),
    'H271': ('RICADI', 'VV'),
    'H272': ('RICALDONE', 'AL'),
    'H273': ('RICCIA', 'CB'),
    'H274': ('RICCIONE', 'RN'),
    'H275': ('RICCÒ DEL GOLFO DI SPEZIA', 'SP'),
    'H276': ('RICENGO', 'CR'),
    'H277': ('RICIGLIANO', 'SA'),
    'H280': ('RIESE PIO X', 'TV'),
    'H281': ('RIESI', 'CL'),
    'H282': ('RIETI', 'RI'),
    'H284': ('RIFIANO/RIFFIAN', 'BZ'),
    'H285': ('RIFREDDO', 'CN'),
    'H286': ("RIGNANO SULL'ARNO", 'FI'),
    'H287': ('RIGNANO GARGANICO', 'FG'),
    'H288': ('RIGNANO FLAMINIO', 'RM'),
    'H289': ('RIGOLATO', 'UD'),
    'H293': ('RIMELLA', 'VC'),
    'H294': ('RIMINI', 'RN'),
    'H298': ('RIO SALICETO', 'RE'),
    'H299': ('RIO DI PUSTERIA/MÜHLBACH', 'BZ'),
    'H300': ('RIOFREDDO', 'RM'),
    'H301': ('RIOLA SARDO', 'OR'),
    'H302': ('RIOLO TERME', 'RA'),
    'H303': ('RIOLUNATO', 'MO'),
    'H304': ('RIOMAGGIORE', 'SP'),
    'H307': ('RIONERO IN VULTURE', 'PZ'),
    'H308': ('RIONERO SANNITICO', 'IS'),
    'H311': ('RIPABOTTONI', 'CB'),
    'H312': ('RIPACANDIDA', 'PZ'),
    'H313': ('RIPALIMOSANI', 'CB'),
    'H314': ('RIPALTA ARPINA', 'CR'),
    'H315': ('RIPALTA CREMASCA', 'CR'),
    'H316': ('RIPALTA GUERINA', 'CR'),
    'H319': ('RIPARBELLA', 'PI'),
    'H320': ('RIPA TEATINA', 'CH'),
    'H321': ('RIPATRANSONE', 'AP'),
    'H323': ('RIPE SAN GINESIO', 'MC'),
    'H324': ('RIPI', 'FR'),
    'H325': ('RIPOSTO', 'CT'),
    'H326': ('RITTANA', 'CN'),
    'H327': ('RIVAMONTE AGORDINO', 'BL'),
    'H328': ('RIVA LIGURE', 'IM'),
    'H330': ('RIVA DEL GARDA', 'TN'),
    'H331': ('RIVA DI SOLTO', 'BG'),
    'H333': ('RIVALBA', 'TO'),
    'H334': ('RIVALTA BORMIDA', 'AL'),
    'H335': ('RIVALTA DI TORINO', 'TO'),
    'H336': ('RIVANAZZANO TERME', 'PV'),
    'H337': ('RIVA PRESSO CHIERI', 'TO'),
    'H338': ('RIVARA', 'TO'),
    'H340': ('RIVAROLO CANAVESE', 'TO'),
    'H341': ('RIVAROLO DEL RE ED UNITI', 'CR'),
    'H342': ('RIVAROLO MANTOVANO', 'MN'),
    'H343': ('RIVARONE', 'AL'),
    'H344': ('RIVAROSSA', 'TO'),
    'H346': ('RIVE', 'VC'),
    'H347': ("RIVE D'ARCANO", 'UD'),
    'H348': ('RIVELLO', 'PZ'),
    'H350': ('RIVERGARO', 'PC'),
    'H353': ('RIVISONDOLI', 'AQ'),
    'H354': ('RIVODUTRI', 'RI'),
    'H355': ('RIVOLI', 'TO'),
    'H356': ('RIVOLI VERONESE', 'VR'),
    'H357': ("RIVOLTA D'ADDA", 'CR'),
    'H359': ('RIZZICONI', 'RC'),
    'H361': ('ROANA', 'VI'),
    'H362': ('ROASCHIA', 'CN'),
    'H363': ('ROASCIO', 'CN'),
    'H364': ('ROVASENDA', 'VC'),
    'H365': ('ROASIO', 'VC'),
    'H366': ('ROATTO', 'AT'),
    'H367': ('ROBASSOMERO', 'TO'),
    'H369': ('ROBBIO', 'PV'),
    'H371': ('ROBECCHETTO CON INDUNO', 'MI'),
    'H372': ("ROBECCO D'OGLIO", 'CR'),
    'H373': ('ROBECCO SUL NAVIGLIO', 'MI'),
    'H375': ('ROBECCO PAVESE', 'PV'),
    'H376': ('ROBELLA', 'AT'),
    'H377': ('ROBILANTE', 'CN'),
    'H378': ('ROBURENT', 'CN'),
    'H379': ('ROCCA PIETORE', 'BL'),
    'H380': ('ROCCAVALDINA', 'ME'),
    'H382': ('ROCCABASCERANA', 'AV'),
    'H383': ('ROCCABERNARDA', 'KR'),
    'H384': ('ROCCABIANCA', 'PR'),
    'H385': ('ROCCABRUNA', 'CN'),
    'H386': ('ROCCA CANAVESE', 'TO'),
    'H387': ('ROCCA CANTERANO', 'RM'),
    'H389': ('ROCCACASALE', 'AQ'),
    'H390': ('ROCCAFLUVIONE', 'AP'),
    'H391': ('ROCCA CIGLIÈ', 'CN'),
    'H392': ("ROCCA D'ARAZZO", 'AT'),
    'H393': ("ROCCA D'ARCE", 'FR'),
    'H394': ('ROCCADASPIDE', 'SA'),
    'H395': ("ROCCA DE' BALDI", 'CN'),
    'H396': ("ROCCA DE' GIORGI", 'PV'),
    'H398': ("ROCCA D'EVANDRO", 'CE'),
    'H399': ('ROCCA DI BOTTE', 'AQ'),
    'H400': ('ROCCA DI CAMBIO', 'AQ'),
    'H401': ('ROCCA DI CAVE', 'RM'),
    'H402': ('ROCCA DI MEZZO', 'AQ'),
    'H403': ('ROCCA DI NETO', 'KR'),
    'H404': ('ROCCA DI PAPA', 'RM'),
    'H405': ('ROCCAFIORITA', 'ME'),
    'H406': ('ROCCAFORTE LIGURE', 'AL'),
    'H407': ('ROCCAFORTE MONDOVÌ', 'CN'),
    'H408': ('ROCCAFORTE DEL GRECO', 'RC'),
    'H409': ('ROCCAFORZATA', 'TA'),
    'H410': ('ROCCAFRANCA', 'BS'),
    'H411': ('ROCCAGIOVINE', 'RM'),
    'H412': ('ROCCAGLORIOSA', 'SA'),
    'H413': ('ROCCAGORGA', 'LT'),
    'H414': ('ROCCA GRIMALDA', 'AL'),
    'H416': ('ROCCA IMPERIALE', 'CS'),
    'H417': ('ROCCALBEGNA', 'GR'),
    'H418': ('ROCCALUMERA', 'ME'),
    'H420': ('ROCCAMANDOLFI', 'IS'),
    'H421': ('ROCCA MASSIMA', 'LT'),
    'H422': ('ROCCAMENA', 'PA'),
    'H423': ('ROCCAMONFINA', 'CE'),
    'H424': ('ROCCAMONTEPIANO', 'CH'),
    'H425': ('ROCCAMORICE', 'PE'),
    'H426': ('ROCCANOVA', 'PZ'),
    'H427': ('ROCCANTICA', 'RI'),
    'H428': ('ROCCAPALUMBA', 'PA'),
    'H429': ('ROCCA PIA', 'AQ'),
    'H431': ('ROCCAPIEMONTE', 'SA'),
    'H432': ('ROCCA PRIORA', 'RM'),
    'H433': ('ROCCARAINOLA', 'NA'),
    'H434': ('ROCCARASO', 'AQ'),
    'H436': ('ROCCAROMANA', 'CE'),
    'H437': ('ROCCA SAN CASCIANO', 'FC'),
    'H438': ('ROCCA SAN FELICE', 'AV'),
    'H439': ('ROCCA SAN GIOVANNI', 'CH'),
    'H440': ('ROCCA SANTA MARIA', 'TE'),
    'H441': ('ROCCA SANTO STEFANO', 'RM'),
    'H442': ('ROCCASCALEGNA', 'CH'),
    'H443': ('ROCCASECCA', 'FR'),
    'H444': ('ROCCASECCA DEI VOLSCI', 'LT'),
    'H445': ('ROCCASICURA', 'IS'),
    'H446': ('ROCCA SINIBALDA', 'RI'),
    'H447': ('ROCCASPARVERA', 'CN'),
    'H448': ('ROCCASPINALVETI', 'CH'),
    'H449': ('ROCCASTRADA', 'GR'),
    'H450': ('ROCCA SUSELLA', 'PV'),
    'H451': ('ROCCAVERANO', 'AT'),
    'H452': ('ROCCAVIGNALE', 'SV'),
    'H453': ('ROCCAVIONE', 'CN'),
    'H454': ('ROCCAVIVARA', 'CB'),
    'H455': ('ROCCELLA VALDEMONE', 'ME'),
    'H456': ('ROCCELLA IONICA', 'RC'),
    'H458': ('ROCCHETTA A VOLTURNO', 'IS'),
    'H459': ('ROCCHETTA E CROCE', 'CE'),
    'H460': ('ROCCHETTA NERVINA', 'IM'),
    'H461': ('ROCCHETTA DI VARA', 'SP'),
    'H462': ('ROCCHETTA BELBO', 'CN'),
    'H465': ('ROCCHETTA LIGURE', 'AL'),
    'H466': ('ROCCHETTA PALAFEA', 'AT'),
    'H467': ("ROCCHETTA SANT'ANTONIO", 'FG'),
    'H468': ('ROCCHETTA TANARO', 'AT'),
    'H470': ('RODANO', 'MI'),
    'H472': ('RODDI', 'CN'),
    'H473': ('RODDINO', 'CN'),
    'H474': ('RODELLO', 'CN'),
    'H475': ('RODENGO/RODENECK', 'BZ'),
    'H477': ('RODENGO SAIANO', 'BS'),
    'H478': ('RODERO', 'CO'),
    'H479': ('RODÌ MILICI', 'ME'),
    'H480': ('RODI GARGANICO', 'FG'),
    'H481': ('RODIGO', 'MN'),
    'H484': ('ROÈ VOLCIANO', 'BS'),
    'H485': ('ROFRANO', 'SA'),
    'H486': ('ROGENO', 'LC'),
    'H488': ('ROGGIANO GRAVINA', 'CS'),
    'H489': ('ROGHUDI', 'RC'),
    'H490': ('ROGLIANO', 'CS'),
    'H491': ('ROGNANO', 'PV'),
    'H492': ('ROGNO', 'BG'),
    'H493': ('ROGOLO', 'SO'),
    'H494': ('ROIATE', 'RM'),
    'H495': ('ROIO DEL SANGRO', 'CH'),
    'H497': ('ROISAN', 'AO'),
    'H498': ('ROLETTO', 'TO'),
    'H500': ('ROLO', 'RE'),
    'H501': ('ROMA', 'RM'),
    'H502': ('ROMAGNANO SESIA', 'NO'),
    'H503': ('ROMAGNANO AL MONTE', 'SA'),
    'H505': ('ROMAGNESE', 'PV'),
    'H507': ('ROMANA', 'SS'),
    'H508': ('ROMANENGO', 'CR'),
    'H509': ('ROMANO DI LOMBARDIA', 'BG'),
    'H511': ('ROMANO CANAVESE', 'TO'),
    'H512': ("ROMANO D'EZZELINO", 'VI'),
    'H514': ("ROMANS D'ISONZO", 'GO'),
    'H516': ('ROMBIOLO', 'VV'),
    'H517': ('ROMENO', 'TN'),
    'H518': ('ROMENTINO', 'NO'),
    'H519': ('ROMETTA', 'ME'),
    'H521': ('RONAGO', 'CO'),
    'H522': ('RONCÀ', 'VR'),
    'H523': ('RONCADE', 'TV'),
    'H525': ('RONCADELLE', 'BS'),
    'H527': ('RONCARO', 'PV'),
    'H528': ('RONCEGNO TERME', 'TN'),
    'H529': ('RONCELLO', 'MB'),
    'H531': ('RONCHI DEI LEGIONARI', 'GO'),
    'H532': ('RONCHI VALSUGANA', 'TN'),
    'H533': ('RONCHIS', 'UD'),
    'H534': ('RONCIGLIONE', 'VT'),
    'H535': ('RONCOBELLO', 'BG'),
    'H536': ('RONCO SCRIVIA', 'GE'),
    'H537': ('RONCO BRIANTINO', 'MB'),
    'H538': ('RONCO BIELLESE', 'BI'),
    'H539': ('RONCO CANAVESE', 'TO'),
    'H540': ("RONCO ALL'ADIGE", 'VR'),
    'H541': ('RONCOFERRARO', 'MN'),
    'H542': ('RONCOFREDDO', 'FC'),
    'H544': ('RONCOLA', 'BG'),
    'H546': ('RONDANINA', 'GE'),
    'H547': ('RONDISSONE', 'TO'),
    'H549': ('RONSECCO', 'VC'),
    'H552': ('RONZONE', 'TN'),
    'H553': ('ROPPOLO', 'BI'),
    'H554': ('RORÀ', 'TO'),
    'H555': ('ROURE', 'TO'),
    'H556': ('ROSÀ', 'VI'),
    'H558': ('ROSARNO', 'RC'),
    'H559': ('ROSASCO', 'PV'),
    'H560': ('ROSATE', 'MI'),
    'H561': ('ROSAZZA', 'BI'),
    'H562': ('ROSCIANO', 'PE'),
    'H564': ('ROSCIGNO', 'SA'),
    'H565': ('ROSE', 'CS'),
    'H566': ('ROSELLO', 'CH'),
    'H568': ('ROSETO VALFORTORE', 'FG'),
    'H569': ('ROSIGNANO MONFERRATO', 'AL'),
    'H570': ('ROSIGNANO MARITTIMO', 'LI'),
    'H572': ('ROSETO CAPO SPULICO', 'CS'),
    'H573': ('ROSOLINA', 'RO'),
    'H574': ('ROSOLINI', 'SR'),
    'H575': ('ROSORA', 'AN'),
    'H577': ('ROSSA', 'VC'),
    'H578': ('ROSSANA', 'CN'),
    'H580': ('ROSSANO VENETO', 'VI'),
    'H581': ('ROSSIGLIONE', 'GE'),
    'H583': ('ROSTA', 'TO'),
    'H584': ("ROTA D'IMAGNA", 'BG'),
    'H585': ('ROTA GRECA', 'CS'),
    'H588': ('ROTELLA', 'AP'),
    'H589': ('ROTELLO', 'CB'),
    'H590': ('ROTONDA', 'PZ'),
    'H591': ('ROTONDELLA', 'MT'),
    'H592': ('ROTONDI', 'AV'),
    'H593': ('ROTTOFRENO', 'PC'),
    'H594': ('ROTZO', 'VI'),
    'H598': ('ROVATO', 'BS'),
    'H599': ('ROVEGNO', 'GE'),
    'H601': ('ROVELLASCA', 'CO'),
    'H602': ('ROVELLO PORRO', 'CO'),
    'H604': ('ROVERBELLA', 'MN'),
    'H606': ('ROVERCHIARA', 'VR'),
    'H607': ('ROVERÈ DELLA LUNA', 'TN'),
    'H608': ('ROVERÈ VERONESE', 'VR'),
    'H609': ('ROVEREDO IN PIANO', 'PN'),
    'H610': ('ROVEREDO DI GUÀ', 'VR'),
    'H612': ('ROVERETO', 'TN'),
    'H614': ('ROVESCALA', 'PV'),
    'H615': ('ROVETTA', 'BG'),
    'H618': ('ROVIANO', 'RM'),
    'H620': ('ROVIGO', 'RO'),
    'H621': ('ROVITO', 'CS'),
    'H622': ('ROVOLON', 'PD'),
    'H623': ('ROZZANO', 'MI'),
    'H625': ('RUBANO', 'PD'),
    'H627': ('RUBIANA', 'TO'),
    'H628': ('RUBIERA', 'RE'),
    'H629': ('RUDA', 'UD'),
    'H630': ('RUDIANO', 'BS'),
    'H631': ('RUEGLIO', 'TO'),
    'H632': ('RUFFANO', 'LE'),
    'H633': ('RUFFIA', 'CN'),
    'H634': ('RUFFRÈ-MENDOLA', 'TN'),
    'H635': ('RUFINA', 'FI'),
    'H639': ('RUMO', 'TN'),
    'H641': ('RUOTI', 'PZ'),
    'H642': ('RUSSI', 'RA'),
    'H643': ('RUTIGLIANO', 'BA'),
    'H644': ('RUTINO', 'SA'),
    'H645': ('RUVO DI PUGLIA', 'BA'),
    'H646': ('RUVO DEL MONTE', 'PZ'),
    'H647': ('SABAUDIA', 'LT'),
    'H650': ('SABBIO CHIESE', 'BS'),
    'H652': ('SABBIONETA', 'MN'),
    'H654': ('SACCO', 'SA'),
    'H655': ('SACCOLONGO', 'PD'),
    'H657': ('SACILE', 'PN'),
    'H658': ('SACROFANO', 'RM'),
    'H659': ('SADALI', 'SU'),
    'H661': ('SAGAMA', 'OR'),
    'H662': ('SAGLIANO MICCA', 'BI'),
    'H665': ('SAGRADO', 'GO'),
    'H666': ('SAGRON MIS', 'TN'),
    'H669': ('SAINT-CHRISTOPHE', 'AO'),
    'H670': ('SAINT-DENIS', 'AO'),
    'H671': ('SAINT-MARCEL', 'AO'),
    'H672': ('SAINT-NICOLAS', 'AO'),
    'H673': ('SAINT-OYEN', 'AO'),
    'H674': ('SAINT-PIERRE', 'AO'),
    'H675': ('SAINT-RHÉMY-EN-BOSSES', 'AO'),
    'H676': ('SAINT-VINCENT', 'AO'),
    'H677': ('SALA MONFERRATO', 'AL'),
    'H678': ('SALA BOLOGNESE', 'BO'),
    'H679': ('SALA COMACINA', 'CO'),
    'H681': ('SALA BIELLESE', 'BI'),
    'H682': ('SALA BAGANZA', 'PR'),
    'H683': ('SALA CONSILINA', 'SA'),
    'H684': ('SALBERTRAND', 'TO'),
    'H686': ('SALENTO', 'SA'),
    'H687': ('SALANDRA', 'MT'),
    'H688': ('SALAPARUTA', 'TP'),
    'H689': ('SALARA', 'RO'),
    'H690': ('SALASCO', 'VC'),
    'H691': ('SALASSA', 'TO'),
    'H693': ('SALCITO', 'CB'),
    'H694': ('SALE', 'AL'),
    'H695': ('SALE DELLE LANGHE', 'CN'),
    'H699': ('SALE MARASINO', 'BS'),
    'H700': ('SALEMI', 'TP'),
    'H701': ('SALERANO SUL LAMBRO', 'LO'),
    'H702': ('SALERANO CANAVESE', 'TO'),
    'H703': ('SALERNO', 'SA'),
    'H704': ('SALE SAN GIOVANNI', 'CN'),
    'H706': ('SALGAREDA', 'TV'),
    'H707': ('SALI VERCELLESE', 'VC'),
    'H708': ('SALICE SALENTINO', 'LE'),
    'H710': ('SALICETO', 'CN'),
    'H712': ('SAN MAURO DI SALINE', 'VR'),
    'H713': ('SALISANO', 'RI'),
    'H714': ('SALIZZOLE', 'VR'),
    'H715': ('SALLE', 'PE'),
    'H716': ('SALMOUR', 'CN'),
    'H717': ('SALÒ', 'BS'),
    'H719': ('SALORNO SULLA STRADA DEL VINO/SALURN AN DER WEINSTRASSE', 'BZ'),
    'H720': ('SALSOMAGGIORE TERME', 'PR'),
    'H723': ('SALTRIO', 'VA'),
    'H724': ('SALUDECIO', 'RN'),
    'H725': ('SALUGGIA', 'VC'),
    'H726': ('SALUSSOLA', 'BI'),
    'H727': ('SALUZZO', 'CN'),
    'H729': ('SALVE', 'LE'),
    'H730': ('SAVOIA DI LUCANIA', 'PZ'),
    'H731': ('SALVIROLA', 'CR'),
    'H732': ('SALVITELLE', 'SA'),
    'H733': ('SALZA IRPINA', 'AV'),
    'H734': ('SALZA DI PINEROLO', 'TO'),
    'H735': ('SALZANO', 'VE'),
    'H736': ('SAMARATE', 'VA'),
    'H738': ('SAMASSI', 'SU'),
    'H739': ('SAMATZAI', 'SU'),
    'H743': ('SAMBUCA DI SICILIA', 'AG'),
    'H744': ('SAMBUCA PISTOIESE', 'PT'),
    'H745': ('SAMBUCI', 'RM'),
    'H746': ('SAMBUCO', 'CN'),
    'H749': ('SAMMICHELE DI BARI', 'BA'),
    'H752': ('SAMOLACO', 'SO'),
    'H753': ('SAMONE', 'TO'),
    'H754': ('SAMONE', 'TN'),
    'H755': ('SAMPEYRE', 'CN'),
    'H756': ('SAMUGHEO', 'OR'),
    'H757': ('SANARICA', 'LE'),
    'H760': ('SAN BARTOLOMEO VAL CAVARGNA', 'CO'),
    'H763': ('SAN BARTOLOMEO AL MARE', 'IM'),
    'H764': ('SAN BARTOLOMEO IN GALDO', 'BN'),
    'H765': ('SAN BASILE', 'CS'),
    'H766': ('SAN BASILIO', 'SU'),
    'H767': ('SAN BASSANO', 'CR'),
    'H768': ('SAN BELLINO', 'RO'),
    'H769': ('SAN BENEDETTO DEL TRONTO', 'AP'),
    'H770': ('SAN BENEDETTO BELBO', 'CN'),
    'H771': ('SAN BENEDETTO PO', 'MN'),
    'H772': ('SAN BENEDETTO DEI MARSI', 'AQ'),
    'H773': ('SAN BENEDETTO IN PERILLIS', 'AQ'),
    'H774': ('SAN BENEDETTO ULLANO', 'CS'),
    'H775': ('SAN BENIGNO CANAVESE', 'TO'),
    'H777': ('SAN BERNARDINO VERBANO', 'VB'),
    'H778': ('SAN BIAGIO PLATANI', 'AG'),
    'H779': ('SAN BIAGIO SARACINISCO', 'FR'),
    'H780': ('SAN BIAGIO DELLA CIMA', 'IM'),
    'H781': ('SAN BIAGIO DI CALLALTA', 'TV'),
    'H782': ('SAN BIASE', 'CB'),
    'H783': ('SAN BONIFACIO', 'VR'),
    'H784': ('SAN BUONO', 'CH'),
    'H785': ('SAN CALOGERO', 'VV'),
    'H786': ('SAN CANDIDO/INNICHEN', 'BZ'),
    'H787': ("SAN CANZIAN D'ISONZO", 'GO'),
    'H789': ('SAN CARLO CANAVESE', 'TO'),
    'H790': ('SAN CASCIANO DEI BAGNI', 'SI'),
    'H791': ('SAN CASCIANO IN VAL DI PESA', 'FI'),
    'H792': ('SAN CATALDO', 'CL'),
    'H793': ('SAN CESARIO DI LECCE', 'LE'),
    'H794': ('SAN CESARIO SUL PANARO', 'MO'),
    'H795': ('SAN CHIRICO NUOVO', 'PZ'),
    'H796': ('SAN CHIRICO RAPARO', 'PZ'),
    'H797': ('SAN CIPIRELLO', 'PA'),
    'H798': ("SAN CIPRIANO D'AVERSA", 'CE'),
    'H799': ('SAN CIPRIANO PO', 'PV'),
    'H800': ('SAN CIPRIANO PICENTINO', 'SA'),
    'H801': ('SAN CLEMENTE', 'RN'),
    'H802': ('SAN COLOMBANO CERTENOLI', 'GE'),
    'H803': ('SAN COLOMBANO AL LAMBRO', 'MI'),
    'H804': ('SAN COLOMBANO BELMONTE', 'TO'),
    'H805': ('SAN CONO', 'CT'),
    'H806': ('SAN COSMO ALBANESE', 'CS'),
    'H807': ('SAN COSTANTINO CALABRO', 'VV'),
    'H808': ('SAN COSTANTINO ALBANESE', 'PZ'),
    'H809': ('SAN COSTANZO', 'PU'),
    'H810': ('SAN CRISTOFORO', 'AL'),
    'H811': ("SAN DAMIANO D'ASTI", 'AT'),
    'H812': ('SAN DAMIANO MACRA', 'CN'),
    'H814': ('SAN DAMIANO AL COLLE', 'PV'),
    'H815': ('SAN DANIELE PO', 'CR'),
    'H816': ('SAN DANIELE DEL FRIULI', 'UD'),
    'H818': ('SAN DEMETRIO CORONE', 'CS'),
    'H819': ("SAN DEMETRIO NE' VESTINI", 'AQ'),
    'H820': ('SAN DIDERO', 'TO'),
    'H821': ('SANDIGLIANO', 'BI'),
    'H822': ('SAN DONACI', 'BR'),
    'H823': ('SAN DONÀ DI PIAVE', 'VE'),
    'H824': ('SAN DONATO VAL DI COMINO', 'FR'),
    'H825': ('SAN DONATO DI NINEA', 'CS'),
    'H826': ('SAN DONATO DI LECCE', 'LE'),
    'H827': ('SAN DONATO MILANESE', 'MI'),
    'H829': ('SANDRIGO', 'VI'),
    'H831': ('SAN FELE', 'PZ'),
    'H833': ('SAN FELICE DEL MOLISE', 'CB'),
    'H834': ('SAN FELICE A CANCELLO', 'CE'),
    'H835': ('SAN FELICE SUL PANARO', 'MO'),
    'H836': ('SAN FELICE CIRCEO', 'LT'),
    'H838': ('SAN FELICE DEL BENACO', 'BS'),
    'H839': ('SAN FERDINANDO DI PUGLIA', 'BT'),
    'H840': ('SAN FERMO DELLA BATTAGLIA', 'CO'),
    'H841': ('SAN FILI', 'CS'),
    'H842': ('SAN FILIPPO DEL MELA', 'ME'),
    'H843': ('SAN FIOR', 'TV'),
    'H844': ('SAN FIORANO', 'LO'),
    'H845': ('SAN FLORIANO DEL COLLIO-ŠTEVERJAN', 'GO'),
    'H846': ('SAN FLORO', 'CZ'),
    'H847': ('SAN FRANCESCO AL CAMPO', 'TO'),
    'H848': ('AGLIENTU', 'SS'),
    'H850': ('SAN FRATELLO', 'ME'),
    'H851': ('SANFRÈ', 'CN'),
    'H852': ('SANFRONT', 'CN'),
    'H855': ('SANGANO', 'TO'),
    'H856': ('SAN GAVINO MONREALE', 'SU'),
    'H857': ('SAN GEMINI', 'TR'),
    'H858': ('SAN GENESIO ATESINO/JENESIEN', 'BZ'),
    'H859': ('SAN GENESIO ED UNITI', 'PV'),
    'H860': ('SAN GENNARO VESUVIANO', 'NA'),
    'H861': ('SAN GERMANO VERCELLESE', 'VC'),
    'H862': ('SAN GERMANO CHISONE', 'TO'),
    'H865': ('SAN GERVASIO BRESCIANO', 'BS'),
    'H867': ('SAN GIACOMO DEGLI SCHIAVONI', 'CB'),
    'H868': ('SAN GIACOMO FILIPPO', 'SO'),
    'H870': ('SAN GIACOMO DELLE SEGNATE', 'MN'),
    'H872': ('SANGIANO', 'VA'),
    'H873': ('SAN GILLIO', 'TO'),
    'H875': ('SAN GIMIGNANO', 'SI'),
    'H876': ('SAN GINESIO', 'MC'),
    'H877': ('SANGINETO', 'CS'),
    'H878': ('SAN GIORGIO MONFERRATO', 'AL'),
    'H880': ('SAN GIORGIO A LIRI', 'FR'),
    'H881': ('SAN GIORGIO ALBANESE', 'CS'),
    'H882': ('SAN GIORGIO IONICO', 'TA'),
    'H883': ('SAN GIORGIO BIGARELLO', 'MN'),
    'H884': ('SAN GIORGIO SU LEGNANO', 'MI'),
    'H885': ('SAN GIORGIO DI LOMELLINA', 'PV'),
    'H887': ('SAN GIORGIO PIACENTINO', 'PC'),
    'H888': ('SAN GIORGIO LUCANO', 'MT'),
    'H889': ('SAN GIORGIO MORGETO', 'RC'),
    'H890': ('SAN GIORGIO CANAVESE', 'TO'),
    'H891': ('SAN GIORGIO DELLA RICHINVELDA', 'PN'),
    'H892': ('SAN GIORGIO A CREMANO', 'NA'),
    'H893': ('SAN GIORGIO DELLE PERTICHE', 'PD'),
    'H894': ('SAN GIORGIO DEL SANNIO', 'BN'),
    'H895': ('SAN GIORGIO DI NOGARO', 'UD'),
    'H896': ('SAN GIORGIO DI PIANO', 'BO'),
    'H897': ('SAN GIORGIO IN BOSCO', 'PD'),
    'H898': ('SAN GIORGIO LA MOLARA', 'BN'),
    'H899': ('SAN GIORGIO SCARAMPI', 'AT'),
    'H900': ('SAN GIORIO DI SUSA', 'TO'),
    'H901': ('SAN GIOVANNI VALDARNO', 'AR'),
    'H903': ('SAN GIOVANNI DI GERACE', 'RC'),
    'H906': ('SAN GIOVANNI AL NATISONE', 'UD'),
    'H907': ('SAN GIOVANNI A PIRO', 'SA'),
    'H910': ('SAN GIOVANNI BIANCO', 'BG'),
    'H912': ('SAN GIOVANNI DEL DOSSO', 'MN'),
    'H913': ('VILLA SAN GIOVANNI IN TUSCIA', 'VT'),
    'H914': ('SAN GIOVANNI GEMINI', 'AG'),
    'H916': ('SAN GIOVANNI ILARIONE', 'VR'),
    'H917': ('SAN GIOVANNI INCARICO', 'FR'),
    'H918': ('SAN GIOVANNI IN CROCE', 'CR'),
    'H919': ('SAN GIOVANNI IN FIORE', 'CS'),
    'H920': ('SAN GIOVANNI IN GALDO', 'CB'),
    'H921': ('SAN GIOVANNI IN MARIGNANO', 'RN'),
    'H922': ('SAN GIOVANNI LA PUNTA', 'CT'),
    'H923': ('SAN GIOVANNI LIPIONI', 'CH'),
    'H924': ('SAN GIOVANNI LUPATOTO', 'VR'),
    'H926': ('SAN GIOVANNI ROTONDO', 'FG'),
    'H928': ('SAN GIULIANO DEL SANNIO', 'CB'),
    'H929': ('SAN GIULIANO DI PUGLIA', 'CB'),
    'H930': ('SAN GIULIANO MILANESE', 'MI'),
    'H931': ('SAN GIUSEPPE VESUVIANO', 'NA'),
    'H933': ('SAN GIUSEPPE JATO', 'PA'),
    'H935': ('SAN GIUSTINO', 'PG'),
    'H936': ('SAN GIUSTO CANAVESE', 'TO'),
    'H937': ('SAN GODENZO', 'FI'),
    'H938': ('SAN GREGORIO NELLE ALPI', 'BL'),
    'H939': ('SAN GREGORIO MATESE', 'CE'),
    'H940': ('SAN GREGORIO DI CATANIA', 'CT'),
    'H941': ("SAN GREGORIO D'IPPONA", 'VV'),
    'H942': ('SAN GREGORIO DA SASSOLA', 'RM'),
    'H943': ('SAN GREGORIO MAGNO', 'SA'),
    'H944': ('SANGUINETTO', 'VR'),
    'H945': ('SAN LAZZARO DI SAVENA', 'BO'),
    'H949': ('SAN LEO', 'RN'),
    'H951': ('SAN LEONARDO', 'UD'),
    'H952': ('SAN LEONARDO IN PASSIRIA/ST. LEONHARD IN PASSEIER', 'BZ'),
    'H953': ('SAN LEUCIO DEL SANNIO', 'BN'),
    'H955': ('SAN LORENZELLO', 'BN'),
    'H956': ('SAN LORENZO DI SEBATO/ST. LORENZEN', 'BZ'),
    'H957': ('SAN LORENZO AL MARE', 'IM'),
    'H958': ('SAN LORENZO IN CAMPO', 'PU'),
    'H959': ('SAN LORENZO', 'RC'),
    'H961': ('SAN LORENZO BELLIZZI', 'CS'),
    'H962': ('SAN LORENZO DEL VALLO', 'CS'),
    'H964': ('SAN LORENZO ISONTINO', 'GO'),
    'H967': ('SAN LORENZO MAGGIORE', 'BN'),
    'H969': ('SAN LORENZO NUOVO', 'VT'),
    'H970': ('SAN LUCA', 'RC'),
    'H971': ('SAN LUCIDO', 'CS'),
    'H973': ('SAN LUPO', 'BN'),
    'H974': ('SANLURI', 'SU'),
    'H975': ('SAN MANGO SUL CALORE', 'AV'),
    'H976': ("SAN MANGO D'AQUINO", 'CZ'),
    'H977': ('SAN MANGO PIEMONTE', 'SA'),
    'H978': ('SAN MARCELLINO', 'CE'),
    'H979': ('SAN MARCELLO', 'AN'),
    'H981': ('SAN MARCO ARGENTANO', 'CS'),
    'H982': ("SAN MARCO D'ALUNZIO", 'ME'),
    'H984': ('SAN MARCO DEI CAVOTI', 'BN'),
    'H985': ('SAN MARCO IN LAMIS', 'FG'),
    'H986': ('SAN MARCO LA CATOLA', 'FG'),
    'H987': ('SAN MARTINO ALFIERI', 'AT'),
    'H988': ('SAN MARTINO IN BADIA/ST. MARTIN IN THURN', 'BZ'),
    'H989': ('SAN MARTINO IN PASSIRIA/ST. MARTIN IN PASSEIER', 'BZ'),
    'H990': ('SAN MARTINO IN PENSILIS', 'CB'),
    'H991': ('SAN MARTINO SULLA MARRUCINA', 'CH'),
    'H992': ('SAN MARTINO DI FINITA', 'CS'),
    'H994': ("SAN MARTINO D'AGRI", 'PZ'),
    'H996': ('SAN MARTINO DI VENEZZE', 'RO'),
    'H997': ('SAN MARTINO CANAVESE', 'TO'),
    'H999': ('SAN MARTINO AL TAGLIAMENTO', 'PN'),
    'I002': ('SAN MARTINO SANNITA', 'BN'),
    'I003': ('SAN MARTINO BUON ALBERGO', 'VR'),
    'I005': ("SAN MARTINO DALL'ARGINE", 'MN'),
    'I007': ('SAN MARTINO DEL LAGO', 'CR'),
    'I008': ('SAN MARTINO DI LUPARI', 'PD'),
    'I011': ('SAN MARTINO IN RIO', 'RE'),
    'I012': ('SAN MARTINO IN STRADA', 'LO'),
    'I014': ('SAN MARTINO SICCOMARIO', 'PV'),
    'I016': ('SAN MARTINO VALLE CAUDINA', 'AV'),
    'I017': ('SAN MARZANO OLIVETO', 'AT'),
    'I018': ('SAN MARZANO DI SAN GIUSEPPE', 'TA'),
    'I019': ('SAN MARZANO SUL SARNO', 'SA'),
    'I023': ('SAN MASSIMO', 'CB'),
    'I024': ('SAN MAURIZIO CANAVESE', 'TO'),
    'I025': ("SAN MAURIZIO D'OPAGLIO", 'NO'),
    'I026': ('SAN MAURO MARCHESATO', 'KR'),
    'I027': ('SAN MAURO PASCOLI', 'FC'),
    'I028': ('SAN MAURO CASTELVERDE', 'PA'),
    'I029': ('SAN MAURO FORTE', 'MT'),
    'I030': ('SAN MAURO TORINESE', 'TO'),
    'I031': ('SAN MAURO CILENTO', 'SA'),
    'I032': ('SAN MAURO LA BRUCA', 'SA'),
    'I034': ('SAN MICHELE DI SERINO', 'AV'),
    'I035': ('SAN MICHELE DI GANZARIA', 'CT'),
    'I037': ('SAN MICHELE MONDOVÌ', 'CN'),
    'I040': ('SAN MICHELE AL TAGLIAMENTO', 'VE'),
    'I042': ("SAN MICHELE ALL'ADIGE", 'TN'),
    'I045': ('SAN MICHELE SALENTINO', 'BR'),
    'I046': ('SAN MINIATO', 'PI'),
    'I048': ("SANNAZZARO DE' BURGONDI", 'PV'),
    'I049': ('SAN NAZZARO', 'BN'),
    'I051': ('SAN NAZZARO VAL CAVARGNA', 'CO'),
    'I052': ('SAN NAZZARO SESIA', 'NO'),
    'I053': ('SANNICANDRO DI BARI', 'BA'),
    'I054': ('SAN NICANDRO GARGANICO', 'FG'),
    'I056': ('SAN NICOLA LA STRADA', 'CE'),
    'I057': ("SAN NICOLA DELL'ALTO", 'KR'),
    'I058': ('SAN NICOLA DA CRISSA', 'VV'),
    'I059': ('SANNICOLA', 'LE'),
    'I060': ('SAN NICOLA ARCELLA', 'CS'),
    'I061': ('SAN NICOLA BARONIA', 'AV'),
    'I062': ('SAN NICOLA MANFREDI', 'BN'),
    'I063': ('SAN NICOLÒ DI COMELICO', 'BL'),
    'I065': ('SAN PANCRAZIO/ST. PANKRAZ', 'BZ'),
    'I066': ('SAN PANCRAZIO SALENTINO', 'BR'),
    'I071': ('SAN PAOLO DI JESI', 'AN'),
    'I072': ('SAN PAOLO DI CIVITATE', 'FG'),
    'I073': ('SAN PAOLO BEL SITO', 'NA'),
    'I076': ('SAN PAOLO SOLBRITO', 'AT'),
    'I079': ('SAN PELLEGRINO TERME', 'BG'),
    'I082': ("SAN PIER D'ISONZO", 'GO'),
    'I084': ('SAN PIER NICETO', 'ME'),
    'I086': ('SAN PIERO PATTI', 'ME'),
    'I088': ('SAN PIETRO DI CADORE', 'BL'),
    'I089': ('SAN PIETRO AL TANAGRO', 'SA'),
    'I090': ('SAN PIETRO VAL LEMINA', 'TO'),
    'I092': ('SAN PIETRO AL NATISONE', 'UD'),
    'I093': ('SAN PIETRO A MAIDA', 'CZ'),
    'I095': ('SAN PIETRO APOSTOLO', 'CZ'),
    'I096': ('SAN PIETRO AVELLANA', 'IS'),
    'I098': ('SAN PIETRO CLARENZA', 'CT'),
    'I102': ('SAN PIETRO DI CARIDÀ', 'RC'),
    'I103': ('SAN PIETRO DI FELETTO', 'TV'),
    'I105': ('SAN PIETRO DI MORUBIO', 'VR'),
    'I107': ('SAN PIETRO IN GU', 'PD'),
    'I108': ('SAN PIETRO IN AMANTEA', 'CS'),
    'I109': ('SAN PIETRO IN CARIANO', 'VR'),
    'I110': ('SAN PIETRO IN CASALE', 'BO'),
    'I113': ('SAN PIETRO INFINE', 'CE'),
    'I114': ('SAN PIETRO IN GUARANO', 'CS'),
    'I115': ('SAN PIETRO IN LAMA', 'LE'),
    'I116': ('SAN PIETRO MOSEZZO', 'NO'),
    'I117': ('SAN PIETRO MUSSOLINO', 'VI'),
    'I118': ('VILLA SAN PIETRO', 'CA'),
    'I119': ('SAN PIETRO VERNOTICO', 'BR'),
    'I120': ('SAN PIETRO VIMINARIO', 'PD'),
    'I121': ('SAN PIO DELLE CAMERE', 'AQ'),
    'I122': ('SAN POLO MATESE', 'CB'),
    'I123': ("SAN POLO D'ENZA", 'RE'),
    'I124': ('SAN POLO DI PIAVE', 'TV'),
    'I125': ('SAN POLO DEI CAVALIERI', 'RM'),
    'I126': ('SAN PONSO', 'TO'),
    'I128': ('SAN POSSIDONIO', 'MO'),
    'I129': ('SAN POTITO ULTRA', 'AV'),
    'I130': ('SAN POTITO SANNITICO', 'CE'),
    'I131': ('SAN PRISCO', 'CE'),
    'I132': ('SAN PROCOPIO', 'RC'),
    'I133': ('SAN PROSPERO', 'MO'),
    'I135': ("SAN QUIRICO D'ORCIA", 'SI'),
    'I136': ('SAN QUIRINO', 'PN'),
    'I137': ('SAN RAFFAELE CIMENA', 'TO'),
    'I138': ('SANREMO', 'IM'),
    'I139': ('SAN ROBERTO', 'RC'),
    'I140': ('SAN ROCCO AL PORTO', 'LO'),
    'I142': ('SAN ROMANO IN GARFAGNANA', 'LU'),
    'I143': ('SAN RUFO', 'SA'),
    'I144': ('SAN SALVATORE MONFERRATO', 'AL'),
    'I145': ('SAN SALVATORE TELESINO', 'BN'),
    'I147': ('SAN SALVATORE DI FITALIA', 'ME'),
    'I148': ('SAN SALVO', 'CH'),
    'I150': ('SAN SEBASTIANO CURONE', 'AL'),
    'I151': ('SAN SEBASTIANO AL VESUVIO', 'NA'),
    'I152': ('SAN SEBASTIANO DA PO', 'TO'),
    'I153': ('SAN SECONDO PARMENSE', 'PR'),
    'I154': ('SAN SECONDO DI PINEROLO', 'TO'),
    'I155': ('SANSEPOLCRO', 'AR'),
    'I156': ('SAN SEVERINO MARCHE', 'MC'),
    'I157': ('SAN SEVERINO LUCANO', 'PZ'),
    'I158': ('SAN SEVERO', 'FG'),
    'I162': ('SAN SIRO', 'CO'),
    'I163': ('SAN SOSSIO BARONIA', 'AV'),
    'I164': ('SAN SOSTENE', 'CZ'),
    'I165': ('SAN SOSTI', 'CS'),
    'I166': ('SAN SPERATE', 'SU'),
    'I168': ('SANTA BRIGIDA', 'BG'),
    'I169': ('SANTA CATERINA VILLARMOSA', 'CL'),
    'I170': ('SANTA CATERINA DELLO IONIO', 'CZ'),
    'I171': ('SANTA CATERINA ALBANESE', 'CS'),
    'I172': ('SANTA CESAREA TERME', 'LE'),
    'I173': ('SANTA CRISTINA VALGARDENA/ST. CHRISTINA IN GRÖDEN', 'BZ'),
    'I174': ('SANTA CRISTINA GELA', 'PA'),
    'I175': ('SANTA CRISTINA E BISSONE', 'PV'),
    'I176': ("SANTA CRISTINA D'ASPROMONTE", 'RC'),
    'I177': ("SANTA CROCE SULL'ARNO", 'PI'),
    'I178': ('SANTA CROCE CAMERINA', 'RG'),
    'I179': ('SANTA CROCE DEL SANNIO', 'BN'),
    'I181': ('SANTA CROCE DI MAGLIANO', 'CB'),
    'I182': ('SANTADI', 'SU'),
    'I183': ('SANTA DOMENICA TALAO', 'CS'),
    'I184': ('SANTA DOMENICA VITTORIA', 'ME'),
    'I185': ('SANTA ELISABETTA', 'AG'),
    'I187': ('SANTA FIORA', 'GR'),
    'I188': ('SANTA FLAVIA', 'PA'),
    'I189': ("SANT'AGAPITO", 'IS'),
    'I190': ("SANT'AGATA FOSSILI", 'AL'),
    'I191': ("SANT'AGATA BOLOGNESE", 'BO'),
    'I192': ("SANT'AGATA DI ESARO", 'CS'),
    'I193': ("SANT'AGATA DI PUGLIA", 'FG'),
    'I196': ("SANT'AGATA SUL SANTERNO", 'RA'),
    'I197': ("SANT'AGATA DE' GOTI", 'BN'),
    'I198': ("SANT'AGATA DEL BIANCO", 'RC'),
    'I199': ("SANT'AGATA DI MILITELLO", 'ME'),
    'I201': ("SANT'AGATA FELTRIA", 'RN'),
    'I202': ("SANT'AGATA LI BATTIATI", 'CT'),
    'I203': ('SANTA GIULETTA', 'PV'),
    'I205': ('SANTA GIUSTA', 'OR'),
    'I206': ('SANTA GIUSTINA', 'BL'),
    'I207': ('SANTA GIUSTINA IN COLLE', 'PD'),
    'I208': ("SANT'AGNELLO", 'NA'),
    'I210': ("SANT'ALBANO STURA", 'CN'),
    'I213': ("SANT'ALESSIO CON VIALONE", 'PV'),
    'I214': ("SANT'ALESSIO IN ASPROMONTE", 'RC'),
    'I215': ("SANT'ALESSIO SICULO", 'ME'),
    'I216': ("SANT'ALFIO", 'CT'),
    'I217': ('SANTA LUCE', 'PI'),
    'I219': ('SANTA LUCIA DI SERINO', 'AV'),
    'I220': ('SANTA LUCIA DEL MELA', 'ME'),
    'I221': ('SANTA LUCIA DI PIAVE', 'TV'),
    'I224': ('SANTA MARGHERITA DI BELICE', 'AG'),
    'I225': ('SANTA MARGHERITA LIGURE', 'GE'),
    'I230': ('SANTA MARGHERITA DI STAFFORA', 'PV'),
    'I232': ('SANTA MARIA A MONTE', 'PI'),
    'I233': ('SANTA MARIA A VICO', 'CE'),
    'I234': ('SANTA MARIA CAPUA VETERE', 'CE'),
    'I236': ('TRAVACÒ SICCOMARIO', 'PV'),
    'I237': ('SANTA MARIA DELLA VERSA', 'PV'),
    'I238': ('SANTA MARIA DEL MOLISE', 'IS'),
    'I240': ('SANTA MARIA DI LICODIA', 'CT'),
    'I242': ('SANTA MARIA DI SALA', 'VE'),
    'I243': ('SANTA MARIA HOÈ', 'LC'),
    'I244': ('SANTA MARIA IMBARO', 'CH'),
    'I247': ('SANTA MARIA LA FOSSA', 'CE'),
    'I248': ('SANTA MARIA LA LONGA', 'UD'),
    'I249': ('SANTA MARIA MAGGIORE', 'VB'),
    'I251': ('SANTA MARIA NUOVA', 'AN'),
    'I253': ('SANTA MARINA', 'SA'),
    'I254': ('SANTA MARINA SALINA', 'ME'),
    'I255': ('SANTA MARINELLA', 'RM'),
    'I256': ("SANT'AMBROGIO SUL GARIGLIANO", 'FR'),
    'I258': ("SANT'AMBROGIO DI TORINO", 'TO'),
    'I259': ("SANT'AMBROGIO DI VALPOLICELLA", 'VR'),
    'I260': ('SANTOMENNA', 'SA'),
    'I261': ('SAN TAMMARO', 'CE'),
    'I262': ("SANT'ANASTASIA", 'NA'),
    'I263': ("SANT'ANATOLIA DI NARCO", 'PG'),
    'I264': ("SANT'ANDREA DI CONZA", 'AV'),
    'I265': ("SANT'ANDREA DEL GARIGLIANO", 'FR'),
    'I266': ("SANT'ANDREA APOSTOLO DELLO IONIO", 'CZ'),
    'I271': ("SANT'ANDREA FRIUS", 'SU'),
    'I273': ("SANT'ANGELO D'ALIFE", 'CE'),
    'I274': ("SANT'ANGELO LODIGIANO", 'LO'),
    'I275': ("SANT'ANGELO DI PIOVE DI SACCO", 'PD'),
    'I276': ("SANT'ANGELO LOMELLINA", 'PV'),
    'I277': ("SANT'ANGELO A CUPOLO", 'BN'),
    'I278': ("SANT'ANGELO A FASANELLA", 'SA'),
    'I279': ("SANT'ANGELO ALL'ESCA", 'AV'),
    'I280': ("SANT'ANGELO A SCALA", 'AV'),
    'I281': ("SANT'ANGELO DEI LOMBARDI", 'AV'),
    'I282': ("SANT'ANGELO DEL PESCO", 'IS'),
    'I283': ("SANT'ANGELO DI BROLO", 'ME'),
    'I284': ("SANT'ANGELO ROMANO", 'RM'),
    'I286': ("SANT'ANGELO IN PONTANO", 'MC'),
    'I287': ("SANT'ANGELO IN VADO", 'PU'),
    'I288': ("SANT'ANGELO LE FRATTE", 'PZ'),
    'I289': ("SANT'ANGELO LIMOSANO", 'CB'),
    'I290': ("SANT'ANGELO MUXARO", 'AG'),
    'I291': ('SANTA NINFA', 'TP'),
    'I292': ("SANT'ANNA D'ALFAEDO", 'VR'),
    'I293': ("SANT'ANTIMO", 'NA'),
    'I294': ("SANT'ANTIOCO", 'SU'),
    'I296': ("SANT'ANTONINO DI SUSA", 'TO'),
    'I298': ("VILLA SANT'ANTONIO", 'OR'),
    'I300': ("SANT'ANTONIO ABATE", 'NA'),
    'I301': ('SANTA PAOLINA', 'AV'),
    'I302': ("SANT'APOLLINARE", 'FR'),
    'I304': ('SANTARCANGELO DI ROMAGNA', 'RN'),
    'I305': ("SANT'ARCANGELO", 'PZ'),
    'I306': ("SANT'ARPINO", 'CE'),
    'I307': ("SANT'ARSENIO", 'SA'),
    'I308': ('SANTA SEVERINA', 'KR'),
    'I309': ("SANTA SOFIA D'EPIRO", 'CS'),
    'I310': ('SANTA SOFIA', 'FC'),
    'I311': ('SANTA TERESA DI RIVA', 'ME'),
    'I312': ('SANTA TERESA GALLURA', 'SS'),
    'I314': ('SANTA VENERINA', 'CT'),
    'I315': ('SANTA VITTORIA IN MATENANO', 'FM'),
    'I316': ("SANTA VITTORIA D'ALBA", 'CN'),
    'I317': ("SANT'EGIDIO DEL MONTE ALBINO", 'SA'),
    'I318': ("SANT'EGIDIO ALLA VIBRATA", 'TE'),
    'I319': ("SANT'ELENA", 'PD'),
    'I320': ("SANT'ELIA A PIANISI", 'CB'),
    'I321': ("SANT'ELIA FIUMERAPIDO", 'FR'),
    'I322': ('VALLEFIORITA', 'CZ'),
    'I324': ("SANT'ELPIDIO A MARE", 'FM'),
    'I326': ('SANTE MARIE', 'AQ'),
    'I327': ('SANTENA', 'TO'),
    'I328': ('SAN TEODORO', 'ME'),
    'I329': ('SAN TEODORO', 'SS'),
    'I330': ('SANTERAMO IN COLLE', 'BA'),
    'I332': ("SANT'EUFEMIA A MAIELLA", 'PE'),
    'I333': ("SANT'EUFEMIA D'ASPROMONTE", 'RC'),
    'I335': ("SANT'EUSANIO DEL SANGRO", 'CH'),
    'I336': ("SANT'EUSANIO FORCONESE", 'AQ'),
    'I337': ('SANTHIÀ', 'VC'),
    'I339': ('SANTI COSMA E DAMIANO', 'LT'),
    'I341': ("SANT'ILARIO DELLO IONIO", 'RC'),
    'I342': ("SANT'ILARIO D'ENZA", 'RE'),
    'I344': ("SANT'IPPOLITO", 'PU'),
    'I346': ("SANT'OLCESE", 'GE'),
    'I347': ('SAN TOMASO AGORDINO', 'BL'),
    'I348': ("SANT'OMERO", 'TE'),
    'I350': ("SANT'ONOFRIO", 'VV'),
    'I351': ('SANTOPADRE', 'FR'),
    'I352': ("SANT'ORESTE", 'RM'),
    'I353': ('SANTORSO', 'VI'),
    'I354': ("SANT'ORSOLA TERME", 'TN'),
    'I356': ('SANTO STEFANO QUISQUINA', 'AG'),
    'I357': ('SANTO STEFANO DEL SOLE', 'AV'),
    'I359': ('SANTO STEFANO DI ROGLIANO', 'CS'),
    'I360': ('SANTO STEFANO DI SESSANIO', 'AQ'),
    'I361': ('SANTO STEFANO TICINO', 'MI'),
    'I362': ('SANTO STEFANO LODIGIANO', 'LO'),
    'I363': ('SANTO STEFANO DI MAGRA', 'SP'),
    'I364': ('VILLA SANTO STEFANO', 'FR'),
    'I365': ('SANTO STEFANO AL MARE', 'IM'),
    'I367': ('SANTO STEFANO BELBO', 'CN'),
    'I368': ("SANTO STEFANO D'AVETO", 'GE'),
    'I370': ('SANTO STEFANO DI CAMASTRA', 'ME'),
    'I371': ('SANTO STEFANO IN ASPROMONTE', 'RC'),
    'I372': ('SANTO STEFANO ROERO', 'CN'),
    'I373': ('SAN STINO DI LIVENZA', 'VE'),
    'I374': ('SANTU LUSSURGIU', 'OR'),
    'I375': ("SANT'URBANO", 'PD'),
    'I376': ('SAN VALENTINO IN ABRUZZO CITERIORE', 'PE'),
    'I377': ('SAN VALENTINO TORIO', 'SA'),
    'I381': ('SAN VENANZO', 'TR'),
    'I382': ('SAN VENDEMIANO', 'TV'),
    'I384': ('SAN VERO MILIS', 'OR'),
    'I388': ('SAN VINCENZO LA COSTA', 'CS'),
    'I389': ('SAN VINCENZO VALLE ROVETO', 'AQ'),
    'I390': ('SAN VINCENZO', 'LI'),
    'I391': ('SAN VITALIANO', 'NA'),
    'I392': ('SAN VITO DI CADORE', 'BL'),
    'I393': ('SAN VITO SULLO IONIO', 'CZ'),
    'I394': ('SAN VITO CHIETINO', 'CH'),
    'I396': ('SAN VITO DEI NORMANNI', 'BR'),
    'I400': ('SAN VITO ROMANO', 'RM'),
    'I401': ('SAN VITO DI LEGUZZANO', 'VI'),
    'I402': ('SAN VITO', 'SU'),
    'I403': ('SAN VITO AL TAGLIAMENTO', 'PN'),
    'I404': ('SAN VITO AL TORRE', 'UD'),
    'I405': ('SAN VITO DI FAGAGNA', 'UD'),
    'I407': ('SAN VITO LO CAPO', 'TP'),
    'I408': ('SAN VITTORE DEL LAZIO', 'FR'),
    'I409': ('SAN VITTORE OLONA', 'MI'),
    'I410': ('SANZA', 'SA'),
    'I411': ('SANZENO', 'TN'),
    'I412': ('SAN ZENO NAVIGLIO', 'BS'),
    'I414': ('SAN ZENO DI MONTAGNA', 'VR'),
    'I415': ('SAN ZENONE AL LAMBRO', 'MI'),
    'I416': ('SAN ZENONE AL PO', 'PV'),
    'I417': ('SAN ZENONE DEGLI EZZELINI', 'TV'),
    'I418': ('SAONARA', 'PD'),
    'I420': ('SAPONARA', 'ME'),
    'I421': ('SAPPADA', 'UD'),
    'I422': ('SAPRI', 'SA'),
    'I423': ('SARACENA', 'CS'),
    'I424': ('SARACINESCO', 'RM'),
    'I425': ('SARCEDO', 'VI'),
    'I426': ('SARCONI', 'PZ'),
    'I428': ('SARDARA', 'SU'),
    'I429': ('SARDIGLIANO', 'AL'),
    'I430': ('SAREGO', 'VI'),
    'I431': ('SARENTINO/SARNTAL', 'BZ'),
    'I432': ('SAREZZANO', 'AL'),
    'I433': ('SAREZZO', 'BS'),
    'I434': ('SARMATO', 'PC'),
    'I435': ('SARMEDE', 'TV'),
    'I436': ('SARNANO', 'MC'),
    'I437': ('SARNICO', 'BG'),
    'I438': ('SARNO', 'SA'),
    'I439': ('SARNONICO', 'TN'),
    'I441': ('SARONNO', 'VA'),
    'I442': ('SARRE', 'AO'),
    'I443': ('SARROCH', 'CA'),
    'I444': ('SARSINA', 'FC'),
    'I445': ('SARTEANO', 'SI'),
    'I447': ('SARTIRANA LOMELLINA', 'PV'),
    'I448': ('SARULE', 'NU'),
    'I449': ('SARZANA', 'SP'),
    'I451': ('SASSANO', 'SA'),
    'I452': ('SASSARI', 'SS'),
    'I453': ('SASSELLO', 'SV'),
    'I454': ('SASSETTA', 'LI'),
    'I455': ('SASSINORO', 'BN'),
    'I457': ('SASSO DI CASTALDA', 'PZ'),
    'I460': ('SASSOFELTRIO', 'RN'),
    'I461': ('SASSOFERRATO', 'AN'),
    'I462': ('SASSUOLO', 'MO'),
    'I463': ('SATRIANO', 'CZ'),
    'I464': ('SAURIS', 'UD'),
    'I465': ('SAUZE DI CESANA', 'TO'),
    'I466': ("SAUZE D'OULX", 'TO'),
    'I467': ('SAVA', 'TA'),
    'I468': ('SAVELLI', 'KR'),
    'I469': ('SAVIANO', 'NA'),
    'I470': ('SAVIGLIANO', 'CN'),
    'I471': ('SAVIGNANO IRPINO', 'AV'),
    'I472': ('SAVIGNANO SUL RUBICONE', 'FC'),
    'I473': ('SAVIGNANO SUL PANARO', 'MO'),
    'I475': ('SAVIGNONE', 'GE'),
    'I476': ("SAVIORE DELL'ADAMELLO", 'BS'),
    'I477': ('SAVOCA', 'ME'),
    'I478': ('SAVOGNA', 'UD'),
    'I479': ("SAVOGNA D'ISONZO-SOVODNJE OB SO?I", 'GO'),
    'I480': ('SAVONA', 'SV'),
    'I482': ('SCAFA', 'PE'),
    'I483': ('SCAFATI', 'SA'),
    'I484': ('SCAGNELLO', 'CN'),
    'I485': ('SCALA COELI', 'CS'),
    'I486': ('SCALA', 'SA'),
    'I487': ('SCALDASOLE', 'PV'),
    'I489': ('SCALEA', 'CS'),
    'I490': ('SCALENGHE', 'TO'),
    'I492': ('SCALETTA ZANCLEA', 'ME'),
    'I493': ('SCAMPITELLA', 'AV'),
    'I494': ('SCANDALE', 'KR'),
    'I496': ('SCANDIANO', 'RE'),
    'I497': ('SCANDOLARA RAVARA', 'CR'),
    'I498': ("SCANDOLARA RIPA D'OGLIO", 'CR'),
    'I499': ('SCANDRIGLIA', 'RI'),
    'I501': ('SCANNO', 'AQ'),
    'I503': ('SCANO DI MONTIFERRO', 'OR'),
    'I504': ('SCANSANO', 'GR'),
    'I506': ('SCANZOROSCIATE', 'BG'),
    'I507': ('SCAPOLI', 'IS'),
    'I510': ('SCARLINO', 'GR'),
    'I511': ('SCARMAGNO', 'TO'),
    'I512': ('SCARNAFIGI', 'CN'),
    'I519': ('SCENA/SCHENNA', 'BZ'),
    'I520': ('SCERNI', 'CH'),
    'I522': ('SCHEGGIA E PASCELUPO', 'PG'),
    'I523': ('SCHEGGINO', 'PG'),
    'I526': ('SCHIAVI DI ABRUZZO', 'CH'),
    'I527': ('SCHIAVON', 'VI'),
    'I529': ('SCHIGNANO', 'CO'),
    'I530': ('SCHILPARIO', 'BG'),
    'I531': ('SCHIO', 'VI'),
    'I532': ('SCHIVENOGLIA', 'MN'),
    'I533': ('SCIACCA', 'AG'),
    'I534': ('SCIARA', 'PA'),
    'I535': ('SCICLI', 'RG'),
    'I536': ('SCIDO', 'RC'),
    'I537': ('SCILLA', 'RC'),
    'I538': ('SCILLATO', 'PA'),
    'I539': ('SCIOLZE', 'TO'),
    'I540': ('SCISCIANO', 'NA'),
    'I541': ('SCLAFANI BAGNI', 'PA'),
    'I543': ('SCONTRONE', 'AQ'),
    'I544': ('SCOPA', 'VC'),
    'I545': ('SCOPELLO', 'VC'),
    'I546': ('SCOPPITO', 'AQ'),
    'I548': ('SCORDIA', 'CT'),
    'I549': ('SCORRANO', 'LE'),
    'I551': ('SCORZÈ', 'VE'),
    'I553': ('SCURCOLA MARSICANA', 'AQ'),
    'I554': ('SCURELLE', 'TN'),
    'I555': ('SCURZOLENGO', 'AT'),
    'I556': ('SEBORGA', 'IM'),
    'I558': ('SECINARO', 'AQ'),
    'I559': ('SECLÌ', 'LE'),
    'I561': ('SECUGNAGO', 'LO'),
    'I562': ('SEDEGLIANO', 'UD'),
    'I563': ('SEDICO', 'BL'),
    'I564': ('SEDILO', 'OR'),
    'I565': ('SEDINI', 'SS'),
    'I566': ('SEDRIANO', 'MI'),
    'I567': ('SEDRINA', 'BG'),
    'I569': ('SEFRO', 'MC'),
    'I570': ('SEGARIU', 'SU'),
    'I571': ('SEGGIANO', 'GR'),
    'I573': ('SEGNI', 'RM'),
    'I576': ('SEGONZANO', 'TN'),
    'I577': ('SEGRATE', 'MI'),
    'I578': ('SEGUSINO', 'TV'),
    'I580': ('SELARGIUS', 'CA'),
    'I581': ('SELCI', 'RI'),
    'I582': ('SELEGAS', 'SU'),
    'I585': ('SELLANO', 'PG'),
    'I588': ('SELLERO', 'BS'),
    'I589': ('SELLIA', 'CZ'),
    'I590': ('SELLIA MARINA', 'CZ'),
    'I591': ('SELVA DI VAL GARDENA/WOLKENSTEIN IN GRÖDEN', 'BZ'),
    'I592': ('SELVA DI CADORE', 'BL'),
    'I593': ('SELVA DEI MOLINI/MÜHLWALD', 'BZ'),
    'I594': ('SELVA DI PROGNO', 'VR'),
    'I595': ('SELVAZZANO DENTRO', 'PD'),
    'I597': ('SELVINO', 'BG'),
    'I598': ('SEMESTENE', 'SS'),
    'I599': ('SEMIANA', 'PV'),
    'I600': ('SEMINARA', 'RC'),
    'I601': ('SEMPRONIANO', 'GR'),
    'I602': ('SENAGO', 'MI'),
    'I603': ('SENALE-SAN FELICE/UNSERE LIEBE FRAU IM WALDE-ST. FELIX', 'BZ'),
    'I604': ('SENALES/SCHNALS', 'BZ'),
    'I605': ('SENEGHE', 'OR'),
    'I606': ('SENERCHIA', 'AV'),
    'I607': ('SENIGA', 'BS'),
    'I608': ('SENIGALLIA', 'AN'),
    'I609': ('SENIS', 'OR'),
    'I610': ('SENISE', 'PZ'),
    'I611': ('SENNA COMASCO', 'CO'),
    'I612': ('SENNA LODIGIANA', 'LO'),
    'I613': ('SENNARIOLO', 'OR'),
    'I614': ('SENNORI', 'SS'),
    'I615': ('SENORBÌ', 'SU'),
    'I618': ('SEPINO', 'CB'),
    'I621': ('SEQUALS', 'PN'),
    'I622': ('SERAVEZZA', 'LU'),
    'I624': ('SERDIANA', 'SU'),
    'I625': ('SEREGNO', 'MB'),
    'I626': ('SEREN DEL GRAPPA', 'BL'),
    'I627': ('SERGNANO', 'CR'),
    'I628': ('SERIATE', 'BG'),
    'I629': ('SERINA', 'BG'),
    'I630': ('SERINO', 'AV'),
    'I631': ('SERLE', 'BS'),
    'I632': ('SERMIDE E FELONICA', 'MN'),
    'I633': ('SIRMIONE', 'BS'),
    'I634': ('SERMONETA', 'LT'),
    'I635': ('SERNAGLIA DELLA BATTAGLIA', 'TV'),
    'I636': ('SERNIO', 'SO'),
    'I637': ('SEROLE', 'AT'),
    'I639': ('SERRA SAN BRUNO', 'VV'),
    'I640': ('SERRA RICCÒ', 'GE'),
    'I641': ('SERRACAPRIOLA', 'FG'),
    'I642': ("SERRA D'AIELLO", 'CS'),
    'I643': ("SERRA DE' CONTI", 'AN'),
    'I644': ('SERRADIFALCO', 'CL'),
    'I645': ('SERRALUNGA DI CREA', 'AL'),
    'I646': ("SERRALUNGA D'ALBA", 'CN'),
    'I647': ('SERRAMANNA', 'SU'),
    'I648': ('SERRAMEZZANA', 'SA'),
    'I649': ('SERRAMONACESCA', 'PE'),
    'I651': ('SERRAPETRONA', 'MC'),
    'I652': ('SERRARA FONTANA', 'NA'),
    'I653': ('SERRA SAN QUIRICO', 'AN'),
    'I654': ("SERRA SANT'ABBONDIO", 'PU'),
    'I655': ('SERRASTRETTA', 'CZ'),
    'I656': ('SERRATA', 'RC'),
    'I657': ('SERRAVALLE SCRIVIA', 'AL'),
    'I659': ('SERRAVALLE LANGHE', 'CN'),
    'I660': ('SERRAVALLE PISTOIESE', 'PT'),
    'I661': ('SERRAVALLE DI CHIENTI', 'MC'),
    'I662': ('SERRAVALLE A PO', 'MN'),
    'I663': ('SERRAVALLE SESIA', 'VC'),
    'I666': ('SERRE', 'SA'),
    'I667': ('SERRENTI', 'SU'),
    'I668': ('SERRI', 'SU'),
    'I669': ('SERRONE', 'FR'),
    'I671': ('SERSALE', 'CZ'),
    'I673': ('SOVRAMONTE', 'BL'),
    'I676': ('SESSA AURUNCA', 'CE'),
    'I677': ('SESSA CILENTO', 'SA'),
    'I678': ('SESSAME', 'AT'),
    'I679': ('SESSANO DEL MOLISE', 'IS'),
    'I681': ('SESTINO', 'AR'),
    'I682': ('SESTO CAMPANO', 'IS'),
    'I683': ('SESTO ED UNITI', 'CR'),
    'I684': ('SESTO FIORENTINO', 'FI'),
    'I686': ('SESTO AL REGHENA', 'PN'),
    'I687': ('SESTO/SEXTEN', 'BZ'),
    'I688': ('SESTO CALENDE', 'VA'),
    'I689': ('SESTOLA', 'MO'),
    'I690': ('SESTO SAN GIOVANNI', 'MI'),
    'I692': ('SESTRIERE', 'TO'),
    'I693': ('SESTRI LEVANTE', 'GE'),
    'I695': ('SESTU', 'CA'),
    'I696': ('SETTALA', 'MI'),
    'I697': ('SETTEFRATI', 'FR'),
    'I698': ('SETTIME', 'AT'),
    'I699': ('SETTIMO SAN PIETRO', 'CA'),
    'I700': ('SETTIMO MILANESE', 'MI'),
    'I701': ('SETTIMO ROTTARO', 'TO'),
    'I702': ('SETTIMO VITTONE', 'TO'),
    'I703': ('SETTIMO TORINESE', 'TO'),
    'I704': ('SETTINGIANO', 'CZ'),
    'I705': ('SETZU', 'SU'),
    'I706': ('SEUI', 'SU'),
    'I707': ('SEULO', 'SU'),
    'I709': ('SEVESO', 'MB'),
    'I711': ('SEZZADIO', 'AL'),
    'I712': ('SEZZE', 'LT'),
    'I714': ('SFRUZ', 'TN'),
    'I715': ('SGONICO-ZGONIK', 'TS'),
    'I716': ('SGURGOLA', 'FR'),
    'I717': ('SIAMAGGIORE', 'OR'),
    'I718': ('SIAMANNA', 'OR'),
    'I720': ('SIANO', 'SA'),
    'I721': ('SIAPICCIA', 'OR'),
    'I723': ('SICULIANA', 'AG'),
    'I724': ('SIDDI', 'SU'),
    'I725': ('SIDERNO', 'RC'),
    'I726': ('SIENA', 'SI'),
    'I727': ('SIGILLO', 'PG'),
    'I728': ('SIGNA', 'FI'),
    'I729': ('SILANDRO/SCHLANDERS', 'BZ'),
    'I730': ('SILANUS', 'NU'),
    'I732': ('SILIGO', 'SS'),
    'I734': ('SILIQUA', 'SU'),
    'I735': ('SILIUS', 'SU'),
    'I736': ('SILLAVENGO', 'NO'),
    'I738': ("SILVANO D'ORBA", 'AL'),
    'I739': ('SILVANO PIETRA', 'PV'),
    'I741': ('SILVI', 'TE'),
    'I742': ('SIMALA', 'OR'),
    'I743': ('SIMAXIS', 'OR'),
    'I744': ('SIMBARIO', 'VV'),
    'I745': ('SIMERI CRICHI', 'CZ'),
    'I747': ('SINAGRA', 'ME'),
    'I748': ('SINDIA', 'NU'),
    'I749': ('SINI', 'OR'),
    'I750': ('SINIO', 'CN'),
    'I751': ('SINISCOLA', 'NU'),
    'I752': ('SINNAI', 'CA'),
    'I753': ('SINOPOLI', 'RC'),
    'I754': ('SIRACUSA', 'SR'),
    'I756': ('SIRIGNANO', 'AV'),
    'I757': ('SIRIS', 'OR'),
    'I758': ('SIROLO', 'AN'),
    'I759': ('SIRONE', 'LC'),
    'I761': ('SIRTORI', 'LC'),
    'I765': ('SIURGUS DONIGALA', 'SU'),
    'I767': ('SIZZANO', 'NO'),
    'I771': ('SLUDERNO/SCHLUDERNS', 'BZ'),
    'I774': ('SMERILLO', 'FM'),
    'I775': ('SOAVE', 'VR'),
    'I777': ('SOCCHIEVE', 'UD'),
    'I778': ('SODDÌ', 'OR'),
    'I779': ('SOGLIANO AL RUBICONE', 'FC'),
    'I780': ('SOGLIANO CAVOUR', 'LE'),
    'I781': ('SOGLIO', 'AT'),
    'I782': ('SOIANO DEL LAGO', 'BS'),
    'I783': ('SOLAGNA', 'VI'),
    'I785': ('SOLARINO', 'SR'),
    'I786': ('SOLARO', 'MI'),
    'I787': ('SOLAROLO', 'RA'),
    'I790': ('SOLAROLO RAINERIO', 'CR'),
    'I791': ('SOLARUSSA', 'OR'),
    'I793': ('SOLBIATE ARNO', 'VA'),
    'I794': ('SOLBIATE OLONA', 'VA'),
    'I796': ('SOLDANO', 'IM'),
    'I797': ('SOLEMINIS', 'SU'),
    'I798': ('SOLERO', 'AL'),
    'I799': ('SOLESINO', 'PD'),
    'I800': ('SOLETO', 'LE'),
    'I801': ('SOLFERINO', 'MN'),
    'I802': ('SOLIERA', 'MO'),
    'I803': ('SOLIGNANO', 'PR'),
    'I804': ('SULMONA', 'AQ'),
    'I805': ('SOLOFRA', 'AV'),
    'I808': ('SOLONGHELLO', 'AL'),
    'I809': ('SOLOPACA', 'BN'),
    'I812': ('SOLTO COLLINA', 'BG'),
    'I813': ('SOLZA', 'BG'),
    'I815': ('SOMAGLIA', 'LO'),
    'I817': ('SOMANO', 'CN'),
    'I819': ('SOMMA LOMBARDO', 'VA'),
    'I820': ('SOMMA VESUVIANA', 'NA'),
    'I821': ('SOMMACAMPAGNA', 'VR'),
    'I822': ('SOMMARIVA DEL BOSCO', 'CN'),
    'I823': ('SOMMARIVA PERNO', 'CN'),
    'I824': ('SOMMATINO', 'CL'),
    'I825': ('SOMMO', 'PV'),
    'I826': ('SONA', 'VR'),
    'I827': ('SONCINO', 'CR'),
    'I828': ('SONDALO', 'SO'),
    'I829': ('SONDRIO', 'SO'),
    'I830': ('SONGAVAZZO', 'BG'),
    'I831': ('SONICO', 'BS'),
    'I832': ('SONNINO', 'LT'),
    'I838': ('SORA', 'FR'),
    'I839': ('SORAGA DI FASSA', 'TN'),
    'I840': ('SORAGNA', 'PR'),
    'I841': ('SORANO', 'GR'),
    'I843': ('SORBO SERPICO', 'AV'),
    'I844': ('SORBO SAN BASILE', 'CZ'),
    'I847': ('SORDEVOLO', 'BI'),
    'I848': ('SORDIO', 'LO'),
    'I849': ('SORESINA', 'CR'),
    'I850': ('SORGÀ', 'VR'),
    'I851': ('SORGONO', 'NU'),
    'I852': ('SORI', 'GE'),
    'I853': ('SORIANELLO', 'VV'),
    'I854': ('SORIANO CALABRO', 'VV'),
    'I855': ('SORIANO NEL CIMINO', 'VT'),
    'I856': ('SORICO', 'CO'),
    'I857': ('SORISO', 'NO'),
    'I858': ('SORISOLE', 'BG'),
    'I860': ('SORMANO', 'CO'),
    'I861': ('SORRADILE', 'OR'),
    'I862': ('SORRENTO', 'NA'),
    'I863': ('SORSO', 'SS'),
    'I864': ('SORTINO', 'SR'),
    'I865': ('SOSPIRO', 'CR'),
    'I866': ('SOSPIROLO', 'BL'),
    'I867': ('SOSSANO', 'VI'),
    'I868': ('SOSTEGNO', 'BI'),
    'I869': ('SOTTO IL MONTE GIOVANNI XXIII', 'BG'),
    'I871': ('SOVER', 'TN'),
    'I872': ('SOVERATO', 'CZ'),
    'I873': ('SOVERE', 'BG'),
    'I874': ('SOVERIA MANNELLI', 'CZ'),
    'I875': ('SOVERIA SIMERI', 'CZ'),
    'I876': ('SOVERZENE', 'BL'),
    'I877': ('SOVICILLE', 'SI'),
    'I878': ('SOVICO', 'MB'),
    'I879': ('SOVIZZO', 'VI'),
    'I880': ('SOZZAGO', 'NO'),
    'I881': ('SPADAFORA', 'ME'),
    'I884': ('SPADOLA', 'VV'),
    'I885': ('SPARANISE', 'CE'),
    'I886': ('SPARONE', 'TO'),
    'I887': ('SPECCHIA', 'LE'),
    'I888': ('SPELLO', 'PG'),
    'I891': ('SPERLINGA', 'EN'),
    'I892': ('SPERLONGA', 'LT'),
    'I893': ('SPERONE', 'AV'),
    'I894': ('SPESSA', 'PV'),
    'I895': ('SPEZZANO ALBANESE', 'CS'),
    'I896': ('SPEZZANO DELLA SILA', 'CS'),
    'I899': ('SPIAZZO', 'TN'),
    'I901': ('SPIGNO MONFERRATO', 'AL'),
    'I902': ('SPIGNO SATURNIA', 'LT'),
    'I903': ('SPILAMBERTO', 'MO'),
    'I904': ('SPILIMBERGO', 'PN'),
    'I905': ('SPILINGA', 'VV'),
    'I906': ('SPINADESCO', 'CR'),
    'I907': ('SPINAZZOLA', 'BT'),
    'I908': ('SPINEA', 'VE'),
    'I909': ('SPINEDA', 'CR'),
    'I910': ('SPINETE', 'CB'),
    'I911': ('SPINETO SCRIVIA', 'AL'),
    'I912': ('SPINETOLI', 'AP'),
    'I914': ("SPINO D'ADDA", 'CR'),
    'I916': ('SPINONE AL LAGO', 'BG'),
    'I917': ('SPINOSO', 'PZ'),
    'I919': ('SPIRANO', 'BG'),
    'I921': ('SPOLETO', 'PG'),
    'I922': ('SPOLTORE', 'PE'),
    'I923': ('SPONGANO', 'LE'),
    'I924': ('SPORMAGGIORE', 'TN'),
    'I925': ('SPORMINORE', 'TN'),
    'I926': ('SPOTORNO', 'SV'),
    'I927': ('SPRESIANO', 'TV'),
    'I928': ('SPRIANA', 'SO'),
    'I929': ('SQUILLACE', 'CZ'),
    'I930': ('SQUINZANO', 'LE'),
    'I932': ('STAFFOLO', 'AN'),
    'I935': ('STAGNO LOMBARDO', 'CR'),
    'I936': ('STAITI', 'RC'),
    'I937': ('STALETTÌ', 'CZ'),
    'I938': ('STANGHELLA', 'PD'),
    'I939': ('STARANZANO', 'GO'),
    'I941': ('STAZZANO', 'AL'),
    'I942': ('STAZZEMA', 'LU'),
    'I943': ('STAZZONA', 'CO'),
    'I945': ('STEFANACONI', 'VV'),
    'I946': ('STELLA', 'SV'),
    'I947': ('STELLANELLO', 'SV'),
    'I948': ('STELVIO/STILFS', 'BZ'),
    'I949': ('STENICO', 'TN'),
    'I950': ('STERNATIA', 'LE'),
    'I951': ('STEZZANO', 'BG'),
    'I953': ('STIENTA', 'RO'),
    'I954': ('STIGLIANO', 'MT'),
    'I955': ('STIGNANO', 'RC'),
    'I956': ('STILO', 'RC'),
    'I959': ('STIMIGLIANO', 'RI'),
    'I960': ('STIO', 'SA'),
    'I962': ('STORNARA', 'FG'),
    'I963': ('STORNARELLA', 'FG'),
    'I964': ('STORO', 'TN'),
    'I965': ('STRA', 'VE'),
    'I968': ('STRADELLA', 'PV'),
    'I969': ('STRAMBINELLO', 'TO'),
    'I970': ('STRAMBINO', 'TO'),
    'I973': ('STRANGOLAGALLI', 'FR'),
    'I974': ('STREGNA', 'UD'),
    'I975': ('STREMBO', 'TN'),
    'I976': ('STRESA', 'VB'),
    'I977': ('STREVI', 'AL'),
    'I978': ('STRIANO', 'NA'),
    'I980': ('STRONA', 'BI'),
    'I981': ('STRONCONE', 'TR'),
    'I982': ('STRONGOLI', 'KR'),
    'I984': ('STROPPIANA', 'VC'),
    'I985': ('STROPPO', 'CN'),
    'I986': ('STROZZA', 'BG'),
    'I990': ('STURNO', 'AV'),
    'I991': ('SUBBIANO', 'AR'),
    'I992': ('SUBIACO', 'RM'),
    'I993': ('SUCCIVO', 'CE'),
    'I994': ('SUEGLIO', 'LC'),
    'I995': ('SUELLI', 'SU'),
    'I996': ('SUELLO', 'LC'),
    'I997': ('SUISIO', 'BG'),
    'I998': ('SULBIATE', 'MB'),
    'L002': ('SULZANO', 'BS'),
    'L003': ('SUMIRAGO', 'VA'),
    'L004': ('SUMMONTE', 'AV'),
    'L006': ('SUNI', 'OR'),
    'L007': ('SUNO', 'NO'),
    'L008': ('SUPERSANO', 'LE'),
    'L009': ('SUPINO', 'FR'),
    'L010': ('SURANO', 'LE'),
    'L011': ('SURBO', 'LE'),
    'L013': ('SUSA', 'TO'),
    'L014': ('SUSEGANA', 'TV'),
    'L015': ('SUSTINENTE', 'MN'),
    'L016': ('SUTERA', 'CL'),
    'L017': ('SUTRI', 'VT'),
    'L018': ('SUTRIO', 'UD'),
    'L019': ('SUVERETO', 'LI'),
    'L020': ('SUZZARA', 'MN'),
    'L022': ('TACENO', 'LC'),
    'L023': ('TADASUNI', 'OR'),
    'L024': ('TAGGIA', 'IM'),
    'L025': ('TAGLIACOZZO', 'AQ'),
    'L026': ('TAGLIO DI PO', 'RO'),
    'L027': ('TAGLIOLO MONFERRATO', 'AL'),
    'L030': ('TAIBON AGORDINO', 'BL'),
    'L032': ('TAINO', 'VA'),
    'L034': ('TALAMELLO', 'RN'),
    'L035': ('TALAMONA', 'SO'),
    'L036': ('TALANA', 'NU'),
    'L037': ('TALEGGIO', 'BG'),
    'L038': ('TALLA', 'AR'),
    'L039': ('TALMASSONS', 'UD'),
    'L040': ('TAMBRE', 'BL'),
    'L042': ('TAORMINA', 'ME'),
    'L046': ('TARANO', 'RI'),
    'L047': ('TARANTA PELIGNA', 'CH'),
    'L048': ('TARANTASCA', 'CN'),
    'L049': ('TARANTO', 'TA'),
    'L050': ('TARCENTO', 'UD'),
    'L055': ('TARSIA', 'CS'),
    'L056': ('TARTANO', 'SO'),
    'L057': ('TARVISIO', 'UD'),
    'L058': ('TARZO', 'TV'),
    'L059': ('TASSAROLO', 'AL'),
    'L061': ('TAURANO', 'AV'),
    'L062': ('TAURASI', 'AV'),
    'L063': ('TAURIANOVA', 'RC'),
    'L064': ('TAURISANO', 'LE'),
    'L065': ('TAVAGNACCO', 'UD'),
    'L066': ('TAVAGNASCO', 'TO'),
    'L069': ('TAVENNA', 'CB'),
    'L070': ('TAVERNA', 'CZ'),
    'L071': ('TAVERNERIO', 'CO'),
    'L073': ('TAVERNOLA BERGAMASCA', 'BG'),
    'L074': ('TAVIANO', 'LE'),
    'L075': ('TAVIGLIANO', 'BI'),
    'L078': ('TAVOLETO', 'PU'),
    'L081': ('TAVULLIA', 'PU'),
    'L082': ('TEANA', 'PZ'),
    'L083': ('TEANO', 'CE'),
    'L084': ('TEGLIO', 'SO'),
    'L085': ('TEGLIO VENETO', 'VE'),
    'L086': ('TELESE TERME', 'BN'),
    'L087': ('TELGATE', 'BG'),
    'L088': ('TELTI', 'SS'),
    'L089': ('TELVE', 'TN'),
    'L090': ('TELVE DI SOPRA', 'TN'),
    'L093': ('TEMPIO PAUSANIA', 'SS'),
    'L094': ('TEMÙ', 'BS'),
    'L096': ('TENNA', 'TN'),
    'L097': ('TENNO', 'TN'),
    'L100': ('TEOLO', 'PD'),
    'L102': ('TEORA', 'AV'),
    'L103': ('TERAMO', 'TE'),
    'L104': ('TERDOBBIATE', 'NO'),
    'L105': ('TERELLE', 'FR'),
    'L106': ('TERENTO/TERENTEN', 'BZ'),
    'L108': ('TERLANO/TERLAN', 'BZ'),
    'L109': ('TERLIZZI', 'BA'),
    'L111': ('TERMENO SULLA STRADA DEL VINO/TRAMIN AN DER WEINSTRASSE', 'BZ'),
    'L112': ('TERMINI IMERESE', 'PA'),
    'L113': ('TERMOLI', 'CB'),
    'L115': ('TERNATE', 'VA'),
    'L116': ('TERNENGO', 'BI'),
    'L117': ('TERNI', 'TR'),
    'L118': ("TERNO D'ISOLA", 'BG'),
    'L120': ('TERRACINA', 'LT'),
    'L121': ('TERRAGNOLO', 'TN'),
    'L122': ('TERRALBA', 'OR'),
    'L123': ('TERRANUOVA BRACCIOLINI', 'AR'),
    'L124': ('TERRANOVA DA SIBARI', 'CS'),
    'L125': ('TERRANOVA DEI PASSERINI', 'LO'),
    'L126': ('TERRANOVA DI POLLINO', 'PZ'),
    'L127': ('TERRANOVA SAPPO MINULIO', 'RC'),
    'L131': ('TERRASINI', 'PA'),
    'L132': ('TERRASSA PADOVANA', 'PD'),
    'L134': ('TERRAVECCHIA', 'CS'),
    'L136': ('TERRAZZO', 'VR'),
    'L138': ('TERRICCIOLA', 'PI'),
    'L139': ('TERRUGGIA', 'AL'),
    'L140': ('TERTENIA', 'NU'),
    'L142': ('TERZIGNO', 'NA'),
    'L143': ('TERZO', 'AL'),
    'L144': ("TERZO D'AQUILEIA", 'UD'),
    'L145': ('TERZOLAS', 'TN'),
    'L146': ('TERZORIO', 'IM'),
    'L147': ('TESERO', 'TN'),
    'L149': ('TESIMO/TISENS', 'BZ'),
    'L150': ('TESSENNANO', 'VT'),
    'L152': ('TESTICO', 'SV'),
    'L153': ('TETI', 'NU'),
    'L154': ('TEULADA', 'SU'),
    'L155': ('TEVEROLA', 'CE'),
    'L156': ('TEZZE SUL BRENTA', 'VI'),
    'L157': ('THIENE', 'VI'),
    'L158': ('THIESI', 'SS'),
    'L160': ('TIANA', 'NU'),
    'L164': ('TICENGO', 'CR'),
    'L165': ('TICINETO', 'AL'),
    'L166': ('TIGGIANO', 'LE'),
    'L167': ('TIGLIETO', 'GE'),
    'L168': ('TIGLIOLE', 'AT'),
    'L169': ('TIGNALE', 'BS'),
    'L172': ('TINNURA', 'OR'),
    'L173': ('TIONE DEGLI ABRUZZI', 'AQ'),
    'L174': ('TIONE DI TRENTO', 'TN'),
    'L175': ('TIRANO', 'SO'),
    'L176': ('TIRES/TIERS', 'BZ'),
    'L177': ('TIRIOLO', 'CZ'),
    'L178': ('TIROLO/TIROL', 'BZ'),
    'L180': ('TISSI', 'SS'),
    'L181': ('TITO', 'PZ'),
    'L182': ('TIVOLI', 'RM'),
    'L183': ('TIZZANO VAL PARMA', 'PR'),
    'L184': ('TOANO', 'RE'),
    'L185': ('TOCCO CAUDIO', 'BN'),
    'L186': ('TOCCO DA CASAURIA', 'PE'),
    'L187': ('TOCENO', 'VB'),
    'L188': ('TODI', 'PG'),
    'L189': ('TOFFIA', 'RI'),
    'L190': ('TOIRANO', 'SV'),
    'L191': ('TOLENTINO', 'MC'),
    'L192': ('TOLFA', 'RM'),
    'L193': ('TOLLEGNO', 'BI'),
    'L194': ('TOLLO', 'CH'),
    'L195': ('TOLMEZZO', 'UD'),
    'L197': ('TOLVE', 'PZ'),
    'L199': ('TOMBOLO', 'PD'),
    'L200': ('TON', 'TN'),
    'L202': ('TONARA', 'NU'),
    'L203': ('TONCO', 'AT'),
    'L204': ('TONENGO', 'AT'),
    'L205': ('TORA E PICCILLI', 'CE'),
    'L206': ('TORANO CASTELLO', 'CS'),
    'L207': ('TORANO NUOVO', 'TE'),
    'L210': ('TORBOLE CASAGLIA', 'BS'),
    'L211': ('TORCEGNO', 'TN'),
    'L212': ('TORCHIARA', 'SA'),
    'L213': ('TORCHIAROLO', 'BR'),
    'L214': ('TORELLA DEI LOMBARDI', 'AV'),
    'L215': ('TORELLA DEL SANNIO', 'CB'),
    'L216': ('TORGIANO', 'PG'),
    'L217': ('TORGNON', 'AO'),
    'L218': ('TORINO DI SANGRO', 'CH'),
    'L219': ('TORINO', 'TO'),
    'L220': ('TORITTO', 'BA'),
    'L221': ('TORLINO VIMERCATI', 'CR'),
    'L223': ('TORNACO', 'NO'),
    'L224': ('TORNARECCIO', 'CH'),
    'L225': ('TORNATA', 'CR'),
    'L227': ('TORNIMPARTE', 'AQ'),
    'L228': ('TORNO', 'CO'),
    'L229': ('TORNOLO', 'PR'),
    'L230': ('TORO', 'CB'),
    'L231': ('TORPÈ', 'NU'),
    'L233': ('TORRACA', 'SA'),
    'L235': ('TORRALBA', 'SS'),
    'L237': ('TORRAZZA COSTE', 'PV'),
    'L238': ('TORRAZZA PIEMONTE', 'TO'),
    'L239': ('TORRAZZO', 'BI'),
    'L240': ('TORRE DI RUGGIERO', 'CZ'),
    'L241': ('TORRE MONDOVÌ', 'CN'),
    'L243': ('TORRE CAJETANI', 'FR'),
    'L244': ('TORRE DI SANTA MARIA', 'SO'),
    'L245': ('TORRE ANNUNZIATA', 'NA'),
    'L246': ('TORREANO', 'UD'),
    'L247': ('TORRE CANAVESE', 'TO'),
    'L248': ('TORREBELVICINO', 'VI'),
    'L250': ('TORRE BERETTI E CASTELLARO', 'PV'),
    'L251': ('TORRE BOLDONE', 'BG'),
    'L252': ('TORRE BORMIDA', 'CN'),
    'L253': ('TORREBRUNA', 'CH'),
    'L254': ('TORRECUSO', 'BN'),
    'L256': ("TORRE D'ARESE", 'PV'),
    'L257': ("TORRE DE' BUSI", 'BG'),
    'L258': ("TORRE DE' PICENARDI", 'CR'),
    'L259': ('TORRE DEL GRECO', 'NA'),
    'L262': ("TORRE DE' NEGRI", 'PV'),
    'L263': ("TORRE DE' PASSERI", 'PE'),
    'L265': ("TORRE DE' ROVERI", 'BG'),
    'L267': ('TORRE DI MOSTO', 'VE'),
    'L269': ("TORRE D'ISOLA", 'PV'),
    'L270': ('TORREGLIA', 'PD'),
    'L271': ('TORREGROTTA', 'ME'),
    'L272': ('TORRE LE NOCELLE', 'AV'),
    'L273': ('TORREMAGGIORE', 'FG'),
    'L274': ('TORRE ORSAIA', 'SA'),
    'L276': ('TORRE PALLAVICINA', 'BG'),
    'L277': ('TORRE PELLICE', 'TO'),
    'L278': ('TORRE SAN GIORGIO', 'CN'),
    'L279': ('TORRE SAN PATRIZIO', 'FM'),
    'L280': ('TORRE SANTA SUSANNA', 'BR'),
    'L281': ('TORRESINA', 'CN'),
    'L282': ('TORRETTA', 'PA'),
    'L284': ('TORREVECCHIA TEATINA', 'CH'),
    'L285': ('TORREVECCHIA PIA', 'PV'),
    'L286': ('TORRI IN SABINA', 'RI'),
    'L287': ('TORRI DEL BENACO', 'VR'),
    'L290': ('TORRICE', 'FR'),
    'L291': ('TORRICELLA PELIGNA', 'CH'),
    'L292': ('TORRICELLA VERZATE', 'PV'),
    'L293': ('TORRICELLA IN SABINA', 'RI'),
    'L294': ('TORRICELLA', 'TA'),
    'L295': ('TORRICELLA SICURA', 'TE'),
    'L296': ('TORRICELLA DEL PIZZO', 'CR'),
    'L297': ('TORRI DI QUARTESOLO', 'VI'),
    'L298': ('TORRIGLIA', 'GE'),
    'L299': ('TORRILE', 'PR'),
    'L301': ('TORRIONI', 'AV'),
    'L302': ('TORRITA TIBERINA', 'RM'),
    'L303': ('TORRITA DI SIENA', 'SI'),
    'L304': ('TORTONA', 'AL'),
    'L305': ('TORTORA', 'CS'),
    'L306': ('TORTORELLA', 'SA'),
    'L307': ('TORTORETO', 'TE'),
    'L308': ('TORTORICI', 'ME'),
    'L309': ('TORVISCOSA', 'UD'),
    'L310': ('TUSCANIA', 'VT'),
    'L312': ('TOSCOLANO-MADERNO', 'BS'),
    'L314': ('TOSSICIA', 'TE'),
    'L315': ('TOVO SAN GIACOMO', 'SV'),
    'L316': ("TOVO DI SANT'AGATA", 'SO'),
    'L317': ('TRABIA', 'PA'),
    'L319': ('TRADATE', 'VA'),
    'L321': ('TRAMATZA', 'OR'),
    'L322': ('TRAMBILENO', 'TN'),
    'L323': ('TRAMONTI', 'SA'),
    'L324': ('TRAMONTI DI SOPRA', 'PN'),
    'L325': ('TRAMONTI DI SOTTO', 'PN'),
    'L326': ('TRAMUTOLA', 'PZ'),
    'L327': ('TRANA', 'TO'),
    'L328': ('TRANI', 'BT'),
    'L330': ('TRAONA', 'SO'),
    'L331': ('TRAPANI', 'TP'),
    'L332': ('TRAPPETO', 'PA'),
    'L333': ('TRAREGO VIGGIONA', 'VB'),
    'L334': ('TRASACCO', 'AQ'),
    'L335': ('TRASAGHIS', 'UD'),
    'L336': ('TRASQUERA', 'VB'),
    'L337': ('TRATALIAS', 'SU'),
    'L339': ('TRAVAGLIATO', 'BS'),
    'L340': ('TRAVES', 'TO'),
    'L342': ('TRAVEDONA-MONATE', 'VA'),
    'L345': ('TRAVERSELLA', 'TO'),
    'L346': ('TRAVERSETOLO', 'PR'),
    'L347': ('TRAVESIO', 'PN'),
    'L348': ('TRAVO', 'PC'),
    'L349': ('TREBASELEGHE', 'PD'),
    'L353': ('TREBISACCE', 'CS'),
    'L355': ('TRECASTAGNI', 'CT'),
    'L356': ('TRECATE', 'NO'),
    'L357': ('TRECCHINA', 'PZ'),
    'L359': ('TRECENTA', 'RO'),
    'L361': ('TREDOZIO', 'FC'),
    'L363': ('TREGLIO', 'CH'),
    'L364': ('TREGNAGO', 'VR'),
    'L366': ('TREIA', 'MC'),
    'L367': ('TREISO', 'CN'),
    'L369': ('TREMESTIERI ETNEO', 'CT'),
    'L372': ('TREMOSINE SUL GARDA', 'BS'),
    'L377': ('TRENTINARA', 'SA'),
    'L378': ('TRENTO', 'TN'),
    'L379': ('TRENTOLA DUCENTA', 'CE'),
    'L380': ('TRENZANO', 'BS'),
    'L382': ('TREPPO GRANDE', 'UD'),
    'L383': ('TREPUZZI', 'LE'),
    'L384': ('TREQUANDA', 'SI'),
    'L386': ('TRESANA', 'MS'),
    'L388': ('TRESCORE BALNEARIO', 'BG'),
    'L389': ('TRESCORE CREMASCO', 'CR'),
    'L392': ('TRESIVIO', 'SO'),
    'L393': ('TRESNURAGHES', 'OR'),
    'L396': ('TREVENZUOLO', 'VR'),
    'L397': ('TREVI', 'PG'),
    'L398': ('TREVI NEL LAZIO', 'FR'),
    'L399': ('TREVICO', 'AV'),
    'L400': ('TREVIGLIO', 'BG'),
    'L401': ('TREVIGNANO ROMANO', 'RM'),
    'L402': ('TREVIGNANO', 'TV'),
    'L403': ('TREVILLE', 'AL'),
    'L404': ('TREVIOLO', 'BG'),
    'L406': ('TREVISO BRESCIANO', 'BS'),
    'L407': ('TREVISO', 'TV'),
    'L408': ('TREZZANO ROSA', 'MI'),
    'L409': ('TREZZANO SUL NAVIGLIO', 'MI'),
    'L410': ('TREZZO TINELLA', 'CN'),
    'L411': ("TREZZO SULL'ADDA", 'MI'),
    'L413': ('TREZZONE', 'CO'),
    'L414': ('TRIBANO', 'PD'),
    'L415': ('TRIBIANO', 'MI'),
    'L416': ('TRIBOGNA', 'GE'),
    'L418': ('TRICARICO', 'MT'),
    'L419': ('TRICASE', 'LE'),
    'L420': ('TRICERRO', 'VC'),
    'L421': ('TRICESIMO', 'UD'),
    'L423': ('TRIEI', 'NU'),
    'L424': ('TRIESTE', 'TS'),
    'L425': ('TRIGGIANO', 'BA'),
    'L426': ('TRIGOLO', 'CR'),
    'L427': ('TRINITÀ', 'CN'),
    'L428': ("TRINITÀ D'AGULTU E VIGNOLA", 'SS'),
    'L429': ('TRINO', 'VC'),
    'L430': ('TRIORA', 'IM'),
    'L431': ('TRIPI', 'ME'),
    'L432': ('TRISOBBIO', 'AL'),
    'L433': ('TRISSINO', 'VI'),
    'L434': ('TRIUGGIO', 'MB'),
    'L435': ('TRIVENTO', 'CB'),
    'L437': ('TRIVIGLIANO', 'FR'),
    'L438': ('TRIVIGNANO UDINESE', 'UD'),
    'L439': ('TRIVIGNO', 'PZ'),
    'L440': ('TRIVOLZIO', 'PV'),
    'L444': ('TRODENA NEL PARCO NATURALE/TRUDEN IM NATURPARK', 'BZ'),
    'L445': ('TROFARELLO', 'TO'),
    'L447': ('TROIA', 'FG'),
    'L448': ('TROINA', 'EN'),
    'L449': ('TROMELLO', 'PV'),
    'L450': ('TRONTANO', 'VB'),
    'L451': ('TRONZANO VERCELLESE', 'VC'),
    'L452': ('TROPEA', 'VV'),
    'L453': ('TROVO', 'PV'),
    'L454': ('TRUCCAZZANO', 'MI'),
    'L455': ('TUBRE/TAUFERS IM MÜNSTERTAL', 'BZ'),
    'L458': ('TUFARA', 'CB'),
    'L459': ('TUFILLO', 'CH'),
    'L460': ('TUFINO', 'NA'),
    'L461': ('TUFO', 'AV'),
    'L462': ('TUGLIE', 'LE'),
    'L463': ('TUILI', 'SU'),
    'L464': ('TULA', 'SS'),
    'L466': ('TUORO SUL TRASIMENO', 'PG'),
    'L468': ('VALVESTINO', 'BS'),
    'L469': ('TURANO LODIGIANO', 'LO'),
    'L470': ('TURATE', 'CO'),
    'L471': ('TURBIGO', 'MI'),
    'L472': ('TURI', 'BA'),
    'L473': ('TURRI', 'SU'),
    'L474': ('TURRIACO', 'GO'),
    'L475': ('TURRIVALIGNANI', 'PE'),
    'L477': ('TURSI', 'MT'),
    'L478': ('TUSA', 'ME'),
    'L480': ('UBOLDO', 'VA'),
    'L482': ('UCRIA', 'ME'),
    'L483': ('UDINE', 'UD'),
    'L484': ('UGENTO', 'LE'),
    'L485': ('UGGIANO LA CHIESA', 'LE'),
    'L487': ('UGGIATE-TREVANO', 'CO'),
    'L488': ('ULÀ TIRSO', 'OR'),
    'L489': ('ULASSAI', 'NU'),
    'L490': ('ULTIMO/ULTEN', 'BZ'),
    'L492': ('UMBRIATICO', 'KR'),
    'L494': ("URAGO D'OGLIO", 'BS'),
    'L496': ('URAS', 'OR'),
    'L497': ('URBANA', 'PD'),
    'L498': ('URBANIA', 'PU'),
    'L499': ('URBE', 'SV'),
    'L500': ('URBINO', 'PU'),
    'L501': ('URBISAGLIA', 'MC'),
    'L502': ('URGNANO', 'BG'),
    'L503': ('URI', 'SS'),
    'L505': ('URURI', 'CB'),
    'L506': ('URZULEI', 'NU'),
    'L507': ('USCIO', 'GE'),
    'L508': ('USELLUS', 'OR'),
    'L509': ('USINI', 'SS'),
    'L511': ('USMATE VELATE', 'MB'),
    'L512': ('USSANA', 'SU'),
    'L513': ('USSARAMANNA', 'SU'),
    'L514': ('USSASSAI', 'NU'),
    'L515': ('USSEAUX', 'TO'),
    'L516': ('USSEGLIO', 'TO'),
    'L517': ('USSITA', 'MC'),
    'L519': ('USTICA', 'PA'),
    'L521': ('UTA', 'CA'),
    'L522': ('UZZANO', 'PT'),
    'L524': ('VACCARIZZO ALBANESE', 'CS'),
    'L525': ('VACONE', 'RI'),
    'L526': ('VACRI', 'CH'),
    'L527': ('VADENA/PFATTEN', 'BZ'),
    'L528': ('VADO LIGURE', 'SV'),
    'L529': ('VAGLIA', 'FI'),
    'L531': ('VAGLIO SERRA', 'AT'),
    'L532': ('VAGLIO BASILICATA', 'PZ'),
    'L533': ('VAGLI SOTTO', 'LU'),
    'L535': ('VAIANO CREMASCO', 'CR'),
    'L537': ('VAIANO', 'PO'),
    'L538': ('VAIE', 'TO'),
    'L539': ('VAILATE', 'CR'),
    'L540': ('VAIRANO PATENORA', 'CE'),
    'L544': ('VALBONDIONE', 'BG'),
    'L545': ('VALBREMBO', 'BG'),
    'L546': ('VALBREVENNA', 'GE'),
    'L547': ('VALBRONA', 'CO'),
    'L551': ('VALDAGNO', 'VI'),
    'L552': ('VALDAORA/OLANG', 'BZ'),
    'L554': ('VALDASTICO', 'VI'),
    'L555': ('VAL DELLA TORRE', 'TO'),
    'L556': ('VALDENGO', 'BI'),
    'L557': ('VALDIDENTRO', 'SO'),
    'L558': ('VALDIERI', 'CN'),
    'L561': ('VALDINA', 'ME'),
    'L562': ('VAL DI NIZZA', 'PV'),
    'L563': ('VALDISOTTO', 'SO'),
    'L564': ('VAL DI VIZZE/PFITSCH', 'BZ'),
    'L565': ('VALDOBBIADENE', 'TV'),
    'L566': ('VALDUGGIA', 'VC'),
    'L567': ('VALEGGIO SUL MINCIO', 'VR'),
    'L568': ('VALEGGIO', 'PV'),
    'L569': ('VALENTANO', 'VT'),
    'L570': ('VALENZA', 'AL'),
    'L571': ('VALENZANO', 'BA'),
    'L572': ('VALERA FRATTA', 'LO'),
    'L573': ('VALFABBRICA', 'PG'),
    'L574': ('VALFENERA', 'AT'),
    'L575': ('VALFLORIANA', 'TN'),
    'L576': ('VALFURVA', 'SO'),
    'L577': ('VALGANNA', 'VA'),
    'L578': ('VALGIOIE', 'TO'),
    'L579': ('VALGOGLIO', 'BG'),
    'L580': ('VALGRANA', 'CN'),
    'L581': ('VALGREGHENTINO', 'LC'),
    'L582': ('VALGRISENCHE', 'AO'),
    'L583': ('VALGUARNERA CAROPEPE', 'EN'),
    'L584': ('VALLADA AGORDINA', 'BL'),
    'L586': ('VALLANZENGO', 'BI'),
    'L588': ('VALLARSA', 'TN'),
    'L589': ('VALLATA', 'AV'),
    'L590': ('VALLE DI CADORE', 'BL'),
    'L591': ('VALLE DI MADDALONI', 'CE'),
    'L593': ('VALLE LOMELLINA', 'PV'),
    'L594': ('VALLE AGRICOLA', 'CE'),
    'L595': ('VALLE AURINA/AHRNTAL', 'BZ'),
    'L596': ('VALLEBONA', 'IM'),
    'L597': ('VALLE CASTELLANA', 'TE'),
    'L598': ('VALLECORSA', 'FR'),
    'L599': ('VALLECROSIA', 'IM'),
    'L601': ('VALLE DI CASIES/GSIES', 'BZ'),
    'L603': ('VALLEDOLMO', 'PA'),
    'L604': ('VALLEDORIA', 'SS'),
    'L605': ('VALLEMAIO', 'FR'),
    'L607': ('VALLELONGA', 'VV'),
    'L609': ('VALLELUNGA PRATAMENO', 'CL'),
    'L611': ('VALLEPIETRA', 'RM'),
    'L612': ('VALLERANO', 'VT'),
    'L613': ('VALLERMOSA', 'SU'),
    'L614': ('VALLEROTONDA', 'FR'),
    'L616': ('VALLESACCARDA', 'AV'),
    'L617': ('VALLE SALIMBENE', 'PV'),
    'L620': ('VALLE SAN NICOLAO', 'BI'),
    'L623': ('VALLEVE', 'BG'),
    'L624': ('VALLI DEL PASUBIO', 'VI'),
    'L625': ('VALLINFREDA', 'RM'),
    'L626': ('VALLIO TERME', 'BS'),
    'L627': ('VALLO DI NERA', 'PG'),
    'L628': ('VALLO DELLA LUCANIA', 'SA'),
    'L629': ('VALLO TORINESE', 'TO'),
    'L631': ('VALLORIATE', 'CN'),
    'L633': ('VALMACCA', 'AL'),
    'L634': ('VALMADRERA', 'LC'),
    'L638': ('VAL MASINO', 'SO'),
    'L639': ('VALMONTONE', 'RM'),
    'L640': ('VALMOREA', 'CO'),
    'L641': ('VALMOZZOLA', 'PR'),
    'L642': ('VALNEGRA', 'BG'),
    'L643': ('VALPELLINE', 'AO'),
    'L644': ('VALPERGA', 'TO'),
    'L647': ('VALSAVARENCHE', 'AO'),
    'L651': ('VALSTRONA', 'VB'),
    'L653': ('VALTOPINA', 'PG'),
    'L654': ('VALTOURNENCHE', 'AO'),
    'L655': ('VALTORTA', 'BG'),
    'L656': ('VALVA', 'SA'),
    'L658': ('VALVERDE', 'CT'),
    'L660': ('VANDOIES/VINTL', 'BZ'),
    'L664': ('VANZAGHELLO', 'MI'),
    'L665': ('VANZAGO', 'MI'),
    'L666': ('VANZONE CON SAN CARLO', 'VB'),
    'L667': ("VAPRIO D'ADDA", 'MI'),
    'L668': ("VAPRIO D'AGOGNA", 'NO'),
    'L669': ('VARALLO', 'VC'),
    'L670': ('VARALLO POMBIA', 'NO'),
    'L671': ('VARANO BORGHI', 'VA'),
    'L672': ("VARANO DE' MELEGARI", 'PR'),
    'L673': ('VARAPODIO', 'RC'),
    'L675': ('VARAZZE', 'SV'),
    'L676': ('VARCO SABINO', 'RI'),
    'L677': ('VAREDO', 'MB'),
    'L680': ('VARENNA', 'LC'),
    'L681': ('VARESE LIGURE', 'SP'),
    'L682': ('VARESE', 'VA'),
    'L685': ('VARISELLA', 'TO'),
    'L686': ('VARMO', 'UD'),
    'L687': ('VARNA/VAHRN', 'BZ'),
    'L689': ('VARSI', 'PR'),
    'L690': ('VARZI', 'PV'),
    'L691': ('VARZO', 'VB'),
    'L693': ('VASIA', 'IM'),
    'L696': ('VASTOGIRARDI', 'IS'),
    'L698': ('VAUDA CANAVESE', 'TO'),
    'L699': ('VAZZANO', 'VV'),
    'L700': ('VAZZOLA', 'TV'),
    'L702': ('VECCHIANO', 'PI'),
    'L703': ('VEDANO OLONA', 'VA'),
    'L704': ('VEDANO AL LAMBRO', 'MB'),
    'L706': ('VEDELAGO', 'TV'),
    'L707': ('VEDESETA', 'BG'),
    'L709': ('VEDUGGIO CON COLZANO', 'MB'),
    'L710': ('VEGGIANO', 'PD'),
    'L711': ('VEGLIE', 'LE'),
    'L712': ('VEGLIO', 'BI'),
    'L713': ('VEJANO', 'VT'),
    'L715': ('VELESO', 'CO'),
    'L716': ('VELEZZO LOMELLINA', 'PV'),
    'L719': ('VELLETRI', 'RM'),
    'L720': ('VELLEZZO BELLINI', 'PV'),
    'L722': ('VELO VERONESE', 'VR'),
    'L723': ("VELO D'ASTICO", 'VI'),
    'L724': ('VELTURNO/FELDTHURNS', 'BZ'),
    'L725': ('VENAFRO', 'IS'),
    'L726': ('VENAUS', 'TO'),
    'L727': ('VENARIA REALE', 'TO'),
    'L728': ('VENAROTTA', 'AP'),
    'L729': ('VENASCA', 'CN'),
    'L730': ('VENDONE', 'SV'),
    'L733': ('VENEGONO INFERIORE', 'VA'),
    'L734': ('VENEGONO SUPERIORE', 'VA'),
    'L735': ('VENETICO', 'ME'),
    'L736': ('VENEZIA', 'VE'),
    'L737': ('VENIANO', 'CO'),
    'L738': ('VENOSA', 'PZ'),
    'L739': ('VENTICANO', 'AV'),
    'L740': ('VENTIMIGLIA DI SICILIA', 'PA'),
    'L741': ('VENTIMIGLIA', 'IM'),
    'L742': ('VENTOTENE', 'LT'),
    'L743': ('VENZONE', 'UD'),
    'L744': ('VERANO BRIANZA', 'MB'),
    'L745': ('VERANO/VÖRAN', 'BZ'),
    'L746': ('VERBANIA', 'VB'),
    'L747': ('VERBICARO', 'CS'),
    'L748': ('VERCANA', 'CO'),
    'L749': ('VERCEIA', 'SO'),
    'L750': ('VERCELLI', 'VC'),
    'L751': ('VERCURAGO', 'LC'),
    'L752': ('VERDELLINO', 'BG'),
    'L753': ('VERDELLO', 'BG'),
    'L758': ('VERDUNO', 'CN'),
    'L762': ('VERGATO', 'BO'),
    'L764': ('VERGHERETO', 'FC'),
    'L765': ('VERGIATE', 'VA'),
    'L769': ('VERMIGLIO', 'TN'),
    'L771': ('VERNANTE', 'CN'),
    'L772': ('VERNASCA', 'PC'),
    'L773': ('VERNATE', 'MI'),
    'L774': ('VERNAZZA', 'SP'),
    'L775': ('VERNIO', 'PO'),
    'L776': ('VERNOLE', 'LE'),
    'L777': ('VEROLANUOVA', 'BS'),
    'L778': ('VEROLAVECCHIA', 'BS'),
    'L779': ('VEROLENGO', 'TO'),
    'L780': ('VEROLI', 'FR'),
    'L781': ('VERONA', 'VR'),
    'L783': ('VERRAYES', 'AO'),
    'L784': ('VERRETTO', 'PV'),
    'L785': ('VERRONE', 'BI'),
    'L787': ('VERRUA SAVOIA', 'TO'),
    'L788': ('VERRUA PO', 'PV'),
    'L792': ('VERTEMATE CON MINOPRIO', 'CO'),
    'L795': ('VERTOVA', 'BG'),
    'L797': ('VERUCCHIO', 'RN'),
    'L799': ('VERVIO', 'SO'),
    'L801': ('VERZEGNIS', 'UD'),
    'L802': ('VERZINO', 'KR'),
    'L804': ('VERZUOLO', 'CN'),
    'L805': ('VESCOVANA', 'PD'),
    'L806': ('VESCOVATO', 'CR'),
    'L807': ('VESIME', 'AT'),
    'L808': ('VESPOLATE', 'NO'),
    'L809': ('VESSALICO', 'IM'),
    'L810': ('VESTENANOVA', 'VR'),
    'L811': ('VESTIGNÈ', 'TO'),
    'L812': ('VESTONE', 'BS'),
    'L814': ('VETRALLA', 'VT'),
    'L815': ('VETTO', 'RE'),
    'L816': ("VEZZA D'OGLIO", 'BS'),
    'L817': ("VEZZA D'ALBA", 'CN'),
    'L819': ('VEZZANO LIGURE', 'SP'),
    'L820': ('VEZZANO SUL CROSTOLO', 'RE'),
    'L823': ('VEZZI PORTIO', 'SV'),
    'L826': ('VIADANA', 'MN'),
    'L827': ('VIADANICA', 'BG'),
    'L828': ('VIAGRANDE', 'CT'),
    'L829': ('VIALE', 'AT'),
    'L830': ('VIALFRÈ', 'TO'),
    'L831': ('VIANO', 'RE'),
    'L833': ('VIAREGGIO', 'LU'),
    'L834': ('VIARIGI', 'AT'),
    'L835': ('VIBONATI', 'SA'),
    'L836': ('VICALVI', 'FR'),
    'L837': ('VICARI', 'PA'),
    'L838': ('VICCHIO', 'FI'),
    'L840': ('VICENZA', 'VI'),
    'L841': ('VICOFORTE', 'CN'),
    'L842': ('VICO DEL GARGANO', 'FG'),
    'L843': ('VICO NEL LAZIO', 'FR'),
    'L844': ('VILLA LITERNO', 'CE'),
    'L845': ('VICO EQUENSE', 'NA'),
    'L846': ('VICOLI', 'PE'),
    'L847': ('VICOLUNGO', 'NO'),
    'L848': ('ZIANO PIACENTINO', 'PC'),
    'L850': ('VICOPISANO', 'PI'),
    'L851': ('VICOVARO', 'RM'),
    'L854': ('VIDIGULFO', 'PV'),
    'L856': ('VIDOR', 'TV'),
    'L857': ('VIDRACCO', 'TO'),
    'L858': ('VIESTE', 'FG'),
    'L859': ('VIETRI DI POTENZA', 'PZ'),
    'L860': ('VIETRI SUL MARE', 'SA'),
    'L865': ('VIGANO SAN MARTINO', 'BG'),
    'L866': ('VIGANÒ', 'LC'),
    'L868': ('VIGARANO MAINARDA', 'FE'),
    'L869': ('VIGASIO', 'VR'),
    'L872': ('VIGEVANO', 'PV'),
    'L873': ('VIGGIANELLO', 'PZ'),
    'L874': ('VIGGIANO', 'PZ'),
    'L876': ('VIGGIÙ', 'VA'),
    'L878': ("VIGHIZZOLO D'ESTE", 'PD'),
    'L879': ("VIGLIANO D'ASTI", 'AT'),
    'L880': ('VIGLIANO BIELLESE', 'BI'),
    'L881': ('VIGNALE MONFERRATO', 'AL'),
    'L882': ('VIGNANELLO', 'VT'),
    'L883': ('VIGNATE', 'MI'),
    'L885': ('VIGNOLA', 'MO'),
    'L886': ('VIGNOLA-FALESINA', 'TN'),
    'L887': ('VIGNOLE BORBERA', 'AL'),
    'L888': ('VIGNOLO', 'CN'),
    'L889': ('VIGNONE', 'VB'),
    'L890': ('VIGO DI CADORE', 'BL'),
    'L892': ('VIGODARZERE', 'PD'),
    'L894': ('VIGOLO', 'BG'),
    'L897': ('VIGOLZONE', 'PC'),
    'L898': ('VIGONE', 'TO'),
    'L899': ('VIGONOVO', 'VE'),
    'L900': ('VIGONZA', 'PD'),
    'L904': ('VIGUZZOLO', 'AL'),
    'L905': ('VILLA SANTA LUCIA', 'FR'),
    'L906': ('VILLADOSSOLA', 'VB'),
    'L907': ('VILLA DI CHIAVENNA', 'SO'),
    'L908': ('VILLA DI TIRANO', 'SO'),
    'L909': ('VILLA SANTINA', 'UD'),
    'L912': ('VILLA BARTOLOMEA', 'VR'),
    'L913': ('VILLA BASILICA', 'LU'),
    'L915': ('VILLABASSA/NIEDERDORF', 'BZ'),
    'L916': ('VILLABATE', 'PA'),
    'L917': ('VILLA BISCOSSI', 'PV'),
    'L919': ('VILLA CARCINA', 'BS'),
    'L920': ('VILLA CASTELLI', 'BR'),
    'L922': ('VILLA CELIERA', 'PE'),
    'L923': ('VILLACHIARA', 'BS'),
    'L924': ('VILLACIDRO', 'SU'),
    'L926': ('VILLA COLLEMANDINA', 'LU'),
    'L928': ('VILLA CORTESE', 'MI'),
    'L929': ("VILLA D'ADDA", 'BG'),
    'L931': ('VILLADEATI', 'AL'),
    'L933': ('VILLA DEL BOSCO', 'BI'),
    'L934': ('VILLA DEL CONTE', 'PD'),
    'L936': ('VILLA DI SERIO', 'BG'),
    'L937': ('VILLA ESTENSE', 'PD'),
    'L938': ("VILLA D'OGNA", 'BG'),
    'L939': ('VILLADOSE', 'RO'),
    'L942': ('VILLAFALLETTO', 'CN'),
    'L943': ('VILLA FARALDI', 'IM'),
    'L944': ('VILLAFRANCA SICULA', 'AG'),
    'L945': ("VILLAFRANCA D'ASTI", 'AT'),
    'L946': ('VILLAFRANCA IN LUNIGIANA', 'MS'),
    'L947': ('VILLAFRANCA PADOVANA', 'PD'),
    'L948': ('VILLAFRANCA PIEMONTE', 'TO'),
    'L949': ('VILLAFRANCA DI VERONA', 'VR'),
    'L950': ('VILLAFRANCA TIRRENA', 'ME'),
    'L951': ('VILLAFRATI', 'PA'),
    'L952': ('VILLAGA', 'VI'),
    'L953': ('VILLAGRANDE STRISAILI', 'NU'),
    'L956': ('VILLA GUARDIA', 'CO'),
    'L957': ('VILLA LAGARINA', 'TN'),
    'L958': ('VILLALAGO', 'AQ'),
    'L959': ('VILLALBA', 'CL'),
    'L961': ('VILLALFONSINA', 'CH'),
    'L963': ('VILLALVERNIA', 'AL'),
    'L964': ('VILLAMAGNA', 'CH'),
    'L965': ('VILLAMAINA', 'AV'),
    'L966': ('VILLAMAR', 'SU'),
    'L967': ('VILLAMARZANA', 'RO'),
    'L968': ('VILLAMASSARGIA', 'SU'),
    'L969': ('VILLA MINOZZO', 'RE'),
    'L970': ('VILLAMIROGLIO', 'AL'),
    'L971': ('VILLANDRO/VILLANDERS', 'BZ'),
    'L972': ('VILLANOVA MONFERRATO', 'AL'),
    'L973': ('VILLANOVA DEL BATTISTA', 'AV'),
    'L974': ('VILLANOVA MONDOVÌ', 'CN'),
    'L975': ("VILLANOVA D'ALBENGA", 'SV'),
    'L977': ('VILLANOVA DEL SILLARO', 'LO'),
    'L978': ('VILLANOVA BIELLESE', 'BI'),
    'L979': ('VILLANOVA DI CAMPOSAMPIERO', 'PD'),
    'L980': ("VILLANOVA SULL'ARDA", 'PC'),
    'L981': ('VILLENEUVE', 'AO'),
    'L982': ('VILLANOVA CANAVESE', 'TO'),
    'L983': ("VILLANOVA D'ARDENGHI", 'PV'),
    'L984': ("VILLANOVA D'ASTI", 'AT'),
    'L985': ('VILLANOVA DEL GHEBBO', 'RO'),
    'L986': ('VILLANOVAFORRU', 'SU'),
    'L987': ('VILLANOVAFRANCA', 'SU'),
    'L988': ('VILLANOVA MARCHESANA', 'RO'),
    'L989': ('VILLANOVA MONTELEONE', 'SS'),
    'L990': ('VILLANOVA SOLARO', 'CN'),
    'L991': ('VILLANOVA TRUSCHEDU', 'OR'),
    'L992': ('VILLANOVA TULO', 'SU'),
    'L994': ('VILLANTERIO', 'PV'),
    'L995': ('VILLANUOVA SUL CLISI', 'BS'),
    'L998': ('VILLAPUTZU', 'SU'),
    'L999': ('VILLAR DORA', 'TO'),
    'M002': ('VILLARBASSE', 'TO'),
    'M003': ('VILLARBOIT', 'VC'),
    'M004': ('VILLAREGGIA', 'TO'),
    'M007': ('VILLAR FOCCHIARDO', 'TO'),
    'M009': ('VILLAROMAGNANO', 'AL'),
    'M011': ('VILLAROSA', 'EN'),
    'M013': ('VILLAR PELLICE', 'TO'),
    'M014': ('VILLAR PEROSA', 'TO'),
    'M015': ('VILLAR SAN COSTANZO', 'CN'),
    'M016': ('VILLASALTO', 'SU'),
    'M017': ('VILLASANTA', 'MB'),
    'M018': ('VILLA SAN GIOVANNI', 'RC'),
    'M019': ('VILLA SAN SECONDO', 'AT'),
    'M021': ('VILLA SANTA LUCIA DEGLI ABRUZZI', 'AQ'),
    'M022': ('VILLA SANTA MARIA', 'CH'),
    'M023': ("VILLA SANT'ANGELO", 'AQ'),
    'M025': ('VILLASOR', 'SU'),
    'M026': ('VILLASPECIOSA', 'SU'),
    'M027': ('VILLASTELLONE', 'TO'),
    'M028': ('VILLATA', 'VC'),
    'M030': ('VILLAURBANA', 'OR'),
    'M031': ('VILLAVALLELONGA', 'AQ'),
    'M032': ('VILLAVERLA', 'VI'),
    'M041': ('VILLETTA BARREA', 'AQ'),
    'M042': ('VILLETTE', 'VB'),
    'M043': ('VILLESSE', 'GO'),
    'M044': ('VILLIMPENTA', 'MN'),
    'M045': ('VILLONGO', 'BG'),
    'M048': ('VILLORBA', 'TV'),
    'M050': ('VILMINORE DI SCALVE', 'BG'),
    'M052': ('VIMERCATE', 'MB'),
    'M053': ('VIMODRONE', 'MI'),
    'M055': ('VINADIO', 'CN'),
    'M057': ('VINCHIATURO', 'CB'),
    'M058': ('VINCHIO', 'AT'),
    'M059': ('VINCI', 'FI'),
    'M060': ('VINOVO', 'TO'),
    'M062': ('VINZAGLIO', 'NO'),
    'M063': ('VIOLA', 'CN'),
    'M065': ('VIONE', 'BS'),
    'M067': ('VIPITENO/STERZING', 'BZ'),
    'M069': ('VIRLE PIEMONTE', 'TO'),
    'M070': ('VISANO', 'BS'),
    'M071': ('VISCHE', 'TO'),
    'M072': ('VISCIANO', 'NA'),
    'M073': ('VISCO', 'UD'),
    'M077': ('VISONE', 'AL'),
    'M078': ('VISSO', 'MC'),
    'M079': ('VISTARINO', 'PV'),
    'M080': ('VISTRORIO', 'TO'),
    'M081': ('VITA', 'TP'),
    'M082': ('VITERBO', 'VT'),
    'M083': ('VITICUSO', 'FR'),
    'M085': ("VITO D'ASIO", 'PN'),
    'M086': ('VITORCHIANO', 'VT'),
    'M088': ('VITTORIA', 'RG'),
    'M089': ('VITTORIO VENETO', 'TV'),
    'M090': ('VITTORITO', 'AQ'),
    'M091': ('VITTUONE', 'MI'),
    'M092': ('VITULAZIO', 'CE'),
    'M093': ('VITULANO', 'BN'),
    'M094': ('VIÙ', 'TO'),
    'M095': ('VIVARO ROMANO', 'RM'),
    'M096': ('VIVARO', 'PN'),
    'M098': ('VIVERONE', 'BI'),
    'M100': ('VIZZINI', 'CT'),
    'M101': ('VIZZOLA TICINO', 'VA'),
    'M102': ('VIZZOLO PREDABISSI', 'MI'),
    'M103': ("VO'", 'PD'),
    'M104': ('VOBARNO', 'BS'),
    'M105': ('VOBBIA', 'GE'),
    'M106': ('VOCCA', 'VC'),
    'M108': ('VODO CADORE', 'BL'),
    'M109': ('VOGHERA', 'PV'),
    'M110': ('VOGHIERA', 'FE'),
    'M111': ('VOGOGNA', 'VB'),
    'M113': ('VOLANO', 'TN'),
    'M115': ('VOLLA', 'NA'),
    'M116': ('VOLONGO', 'CR'),
    'M118': ('VOLPAGO DEL MONTELLO', 'TV'),
    'M119': ('VOLPARA', 'PV'),
    'M120': ('VOLPEDO', 'AL'),
    'M121': ('VOLPEGLINO', 'AL'),
    'M122': ('VOLPIANO', 'TO'),
    'M123': ('VOLTAGGIO', 'AL'),
    'M124': ('VOLTAGO AGORDINO', 'BL'),
    'M125': ('VOLTA MANTOVANA', 'MN'),
    'M126': ('VOLTERRA', 'PI'),
    'M127': ('VOLTIDO', 'CR'),
    'M130': ('VOLTURARA IRPINA', 'AV'),
    'M131': ('VOLTURARA APPULA', 'FG'),
    'M132': ('VOLTURINO', 'FG'),
    'M133': ('VOLVERA', 'TO'),
    'M136': ('VOTTIGNASCO', 'CN'),
    'M138': ('ZACCANOPOLI', 'VV'),
    'M139': ('ZAFFERANA ETNEA', 'CT'),
    'M140': ('ZAGARISE', 'CZ'),
    'M141': ('ZAGAROLO', 'RM'),
    'M143': ('ZAMBRONE', 'VV'),
    'M144': ('ZANDOBBIO', 'BG'),
    'M145': ('ZANÈ', 'VI'),
    'M147': ('ZANICA', 'BG'),
    'M150': ('ZAVATTARELLO', 'PV'),
    'M152': ('ZECCONE', 'PV'),
    'M153': ('ZEDDIANI', 'OR'),
    'M156': ('ZELBIO', 'CO'),
    'M158': ('ZELO BUON PERSICO', 'LO'),
    'M161': ('ZEME', 'PV'),
    'M162': ('ZENEVREDO', 'PV'),
    'M163': ('ZENSON DI PIAVE', 'TV'),
    'M165': ('ZERBA', 'PC'),
    'M166': ('ZERBO', 'PV'),
    'M167': ('ZERBOLÒ', 'PV'),
    'M168': ('ZERFALIU', 'OR'),
    'M169': ('ZERI', 'MS'),
    'M170': ('ZERMEGHEDO', 'VI'),
    'M171': ('ZERO BRANCO', 'TV'),
    'M172': ('ZEVIO', 'VR'),
    'M173': ('ZIANO DI FIEMME', 'TN'),
    'M176': ('ZIBIDO SAN GIACOMO', 'MI'),
    'M177': ('ZIGNAGO', 'SP'),
    'M178': ('ZIMELLA', 'VR'),
    'M179': ('ZIMONE', 'BI'),
    'M180': ('ZINASCO', 'PV'),
    'M182': ('ZOAGLI', 'GE'),
    'M183': ('ZOCCA', 'MO'),
    'M184': ('ZOGNO', 'BG'),
    'M185': ('ZOLA PREDOSA', 'BO'),
    'M187': ('ZOLLINO', 'LE'),
    'M188': ('ZONE', 'BS'),
    'M189': ('ZOPPÈ DI CADORE', 'BL'),
    'M190': ('ZOPPOLA', 'PN'),
    'M194': ('ZOVENCEDO', 'VI'),
    'M196': ('ZUBIENA', 'BI'),
    'M197': ('ZUCCARELLO', 'SV'),
    'M199': ('ZUGLIANO', 'VI'),
    'M200': ('ZUGLIO', 'UD'),
    'M201': ('ZUMAGLIA', 'BI'),
    'M202': ('ZUMPANO', 'CS'),
    'M203': ('ZUNGOLI', 'AV'),
    'M204': ('ZUNGRI', 'VV'),
    'M207': ('LARIANO', 'RM'),
    'M208': ('LAMEZIA TERME', 'CZ'),
    'M209': ("SANT'ANNA ARRESI", 'SU'),
    'M210': ('TERME VIGLIATORE', 'ME'),
    'M211': ('ACQUEDOLCI', 'ME'),
    'M212': ('LADISPOLI', 'RM'),
    'M213': ('ARDEA', 'RM'),
    'M214': ('BADESI', 'SS'),
    'M253': ('SICIGNANO DEGLI ALBURNI', 'SA'),
    'M255': ('MOLINA ATERNO', 'AQ'),
    'M256': ('SCANZANO JONICO', 'MT'),
    'M257': ('PORTOPALO DI CAPO PASSERO', 'SR'),
    'M258': ('AVIGLIANO UMBRO', 'TR'),
    'M259': ('VIDDALBA', 'SS'),
    'M260': ('CASAPESENNA', 'CE'),
    'M261': ('CASTRO', 'LE'),
    'M262': ('CELLOLE', 'CE'),
    'M263': ('PORTO CESAREO', 'LE'),
    'M264': ('SAN CASSIANO', 'LE'),
    'M265': ('VAJONT', 'PN'),
    'M266': ('ORDONA', 'FG'),
    'M267': ('ZAPPONETA', 'FG'),
    'M268': ('BLUFI', 'PA'),
    'M269': ('PATERNO', 'PZ'),
    'M270': ('MASAINAS', 'SU'),
    'M271': ('MAZZARRONE', 'CT'),
    'M272': ('CIAMPINO', 'RM'),
    'M273': ('SANTA MARIA LA CARITÀ', 'NA'),
    'M274': ('GOLFO ARANCI', 'SS'),
    'M275': ('LOIRI PORTO SAN PAOLO', 'SS'),
    'M276': ("SANT'ANTONIO DI GALLURA", 'SS'),
    'M277': ('SAN FERDINANDO', 'RC'),
    'M278': ('VILLAPERUCCIO', 'SU'),
    'M279': ('PRIOLO GARGALLO', 'SR'),
    'M280': ('TRECASE', 'NA'),
    'M281': ('PETROSINO', 'TP'),
    'M282': ('TERGU', 'SS'),
    'M283': ('MANIACE', 'CT'),
    'M284': ('SANTA MARIA COGHINAS', 'SS'),
    'M285': ('CARDEDU', 'NU'),
    'M286': ('TORRENOVA', 'ME'),
    'M287': ('RAGALNA', 'CT'),
    'M288': ('CASTIADAS', 'SU'),
    'M289': ('MASSA DI SOMMA', 'NA'),
    'M290': ('STINTINO', 'SS'),
    'M291': ('PISCINAS', 'SU'),
    'M292': ('ERULA', 'SS'),
    'M294': ('BELLIZZI', 'SA'),
    'M295': ('SAN CESAREO', 'RM'),
    'M297': ('FIUMICINO', 'RM'),
    'M298': ('STATTE', 'TA'),
    'M300': ('DUE CARRARE', 'PD'),
    'M301': ('PADRU', 'SS'),
    'M302': ('MONTIGLIO MONFERRATO', 'AT'),
    'M303': ('RONZO-CHIENIS', 'TN'),
    'M308': ('CAVALLINO-TREPORTI', 'VE'),
    'M309': ('FONTE NUOVA', 'RM'),
    'M311': ('CAMPOLONGO TAPOGLIANO', 'UD'),
    'M312': ('LONATO DEL GARDA', 'BS'),
    'M313': ('LEDRO', 'TN'),
    'M314': ('COMANO TERME', 'TN'),
    'M315': ('GRAVEDONA ED UNITI', 'CO'),
    'M316': ('MAPPANO', 'TO'),
    'M317': ('RIVIGNANO TEOR', 'UD'),
    'M318': ('TRECASTELLI', 'AN'),
    'M319': ('FABBRICHE DI VERGEMOLI', 'LU'),
    'M320': ('VALSAMOGGIA', 'BO'),
    'M321': ('FIGLINE E INCISA VALDARNO', 'FI'),
    'M322': ('CASTELFRANCO PIANDISCÒ', 'AR'),
    'M323': ('FISCAGLIA', 'FE'),
    'M324': ('POGGIO TORRIANA', 'RN'),
    'M325': ('SISSA TRECASALI', 'PR'),
    'M326': ('SCARPERIA E SAN PIERO', 'FI'),
    'M327': ('CASCIANA TERME LARI', 'PI'),
    'M328': ('CRESPINA LORENZANA', 'PI'),
    'M329': ('PRATOVECCHIO STIA', 'AR'),
    'M330': ('MONTORO', 'AV'),
    'M331': ('VALLEFOGLIA', 'PU'),
    'M332': ('QUERO VAS', 'BL'),
    'M333': ("SANT'OMOBONO TERME", 'BG'),
    'M334': ('VAL BREMBILLA', 'BG'),
    'M335': ('BELLAGIO', 'CO'),
    'M336': ('COLVERDE', 'CO'),
    'M337': ('VERDERIO', 'LC'),
    'M338': ('CORNALE E BASTIDA', 'PV'),
    'M339': ('MACCAGNO CON PINO E VEDDASCA', 'VA'),
    'M340': ('BORGO VIRGILIO', 'MN'),
    'M341': ('TREMEZZINA', 'CO'),
    'M342': ('LONGARONE', 'BL'),
    'M343': ('VALDAONE', 'TN'),
    'M344': ('PREDAIA', 'TN'),
    'M345': ('SAN LORENZO DORSINO', 'TN'),
    'M346': ('VALVASONE ARZENE', 'PN'),
    'M347': ('SILLANO GIUNCUGNANO', 'LU'),
    'M348': ('LA VALLETTA BRIANZA', 'LC'),
    'M349': ('ALTAVALLE', 'TN'),
    'M350': ('ALTOPIANO DELLA VIGOLANA', 'TN'),
    'M351': ('AMBLAR-DON', 'TN'),
    'M352': ('BORGO CHIESE', 'TN'),
    'M353': ('BORGO LARES', 'TN'),
    'M354': ('CASTEL IVANO', 'TN'),
    'M355': ('CEMBRA LISIGNAGO', 'TN'),
    'M356': ('CONTÀ', 'TN'),
    'M357': ('MADRUZZO', 'TN'),
    'M358': ('PORTE DI RENDENA', 'TN'),
    'M359': ('PRIMIERO SAN MARTINO DI CASTROZZA', 'TN'),
    'M360': ('SELLA GIUDICARIE', 'TN'),
    'M361': ('TRE VILLE', 'TN'),
    'M362': ('VALLELAGHI', 'TN'),
    'M363': ("VILLE D'ANAUNIA", 'TN'),
    'M364': ('VENTASSO', 'RE'),
    'M365': ('PIEVE DI BONO-PREZZO', 'TN'),
    'M366': ('DIMARO FOLGARIDA', 'TN'),
    'M367': ('POLESINE ZIBELLO', 'PR'),
    'M368': ('MONTESCUDO-MONTE COLOMBO', 'RN'),
    'M369': ('ALTO RENO TERME', 'BO'),
    'M370': ('BORGOMEZZAVALLE', 'VB'),
    'M371': ('LESSONA', 'BI'),
    'M372': ('CORTEOLONA E GENZONE', 'PV'),
    'M373': ('CAMPIGLIA CERVO', 'BI'),
    'M374': ('VAL DI ZOLDO', 'BL'),
    'M375': ('ALPAGO', 'BL'),
    'M376': ('ABETONE CUTIGLIANO', 'PT'),
    'M377': ('SAN MARCELLO PITEGLIO', 'PT'),
    'M378': ('MONTALCINO', 'SI'),
    'M379': ('TERRE ROVERESCHE', 'PU'),
    'M380': ('COLLI AL METAURO', 'PU'),
    'M381': ('TERRE DEL RENO', 'FE'),
    'M382': ('VALFORNACE', 'MC'),
    'M383': ('ALTA VALLE INTELVI', 'CO'),
    'M384': ('VAL LIONA', 'VI'),
    'M385': ('CASALI DEL MANCO', 'CS'),
    'M386': ('ALTA VAL TIDONE', 'PC'),
    'M387': ('MONTALTO CARPASIO', 'IM'),
    'M388': ('CASSANO SPINOLA', 'AL'),
    'M389': ('ALTO SERMENZA', 'VC'),
    'M390': ('SAN GIOVANNI DI FASSA-SÈN JAN', 'TN'),
    'M391': ('RIO', 'LI'),
    'M392': ('LATERINA PERGINE VALDARNO', 'AR'),
    'M393': ('CASTELGERUNDO', 'LO'),
    'M394': ('CENTRO VALLE INTELVI', 'CO'),
    'M395': ('VALVARRONE', 'LC'),
    'M396': ('BORGO MANTOVANO', 'MN'),
    'M397': ('ALLUVIONI PIOVERA', 'AL'),
    'M398': ('CELLIO CON BREIA', 'VC'),
    'M399': ('TREPPO LIGOSULLO', 'UD'),
    'M400': ('FIUMICELLO VILLA VICENTINA', 'UD'),
    'M401': ('BARBARANO MOSSANO', 'VI'),
    'M402': ('BORGO VENETO', 'PD'),
    'M403': ('CORIGLIANO-ROSSANO', 'CS'),
    'M404': ('VALLE CANNOBINA', 'VB'),
    'M405': ('VAL DI CHY', 'TO'),
    'M406': ('BORGOCARBONARA', 'MN'),
    'M407': ("TERRE D'ADIGE", 'TN'),
    'M408': ('BARBERINO TAVARNELLE', 'FI'),
    'M409': ('TRESIGNANA', 'FE'),
    'M410': ('RIVA DEL PO', 'FE'),
    'M411': ('SORBOLO MEZZANI', 'PR'),
    'M412': ('SOLBIATE CON CAGNO', 'CO'),
    'M413': ('SASSOCORVARO AUDITORE', 'PU'),
    'M414': ('QUAREGNA CERRETO', 'BI'),
    'M415': ('VALCHIUSA', 'TO'),
    'M416': ('GATTICO-VERUNO', 'NO'),
    'M417': ('VALDILANA', 'BI'),
    'M418': ('PIADENA DRIZZONA', 'CR'),
    'M419': ('COLLI VERDI', 'PV'),
    'M420': ('LU E CUCCARO MONFERRATO', 'AL'),
    'M421': ('BORGO VALBELLUNA', 'BL'),
    'M422': ('PIEVE DEL GRAPPA', 'TV'),
    'M423': ('VALBRENTA', 'VI'),
    'M424': ('VERMEZZO CON ZELO', 'MI'),
    'M425': ('CADREZZATE CON OSMATE', 'VA'),
    'M426': ('COLCERESA', 'VI'),
    'M427': ('LUSIANA CONCO', 'VI'),
    'M428': ('PRESICCE-ACQUARICA', 'LE'),
    'M429': ("BORGO D'ANAUNIA", 'TN'),
    'M430': ('NOVELLA', 'TN'),
    'M431': ('VILLE DI FIEMME', 'TN'),
    'M432': ('MISILISCEMI', 'TP'),
}

def get_comuni_by_province(sigla_prov):
    """Restituisce lista di (codice_belfiore, nome) per la provincia data."""
    return COMUNI_BY_PROV.get(sigla_prov.upper(), [])

def get_comune_info(codice_belfiore):
    """Restituisce (nome, sigla_prov) per il codice dato, o None."""
    return COMUNI_BY_CODE.get(codice_belfiore.upper())
