# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CatastoIT_GML_Merger_ProDialog
                                 A QGIS plugin CatastoIT_GML_Merger_Pro

 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-02-10
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Salvatore Fiandaca
        email                : Salvatore Fiandaca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import sys

sys.path.append(os.path.dirname(__file__))
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QPushButton, QListWidgetItem
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import Qt
from .regions import REGIONS, get_provinces
from .comuni import get_comuni_by_province

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'CatastoIT_GML_Merger_Pro_dialog_base.ui'), resource_suffix='')


class CatastoIT_GML_Merger_ProDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(CatastoIT_GML_Merger_ProDialog, self).__init__(parent)
        self.setupUi(self)

        self.setWindowFlags(self.windowFlags() | Qt.WindowMinimizeButtonHint)

        if not hasattr(self, 'btn_cancel'):
            self.btn_cancel = QPushButton("Annulla", self)
            self.btn_cancel.setVisible(False)
            self.btn_cancel.clicked.connect(self.cancel_operation)
            self.layout().addWidget(self.btn_cancel)

        self.le_folder.lineEdit().setPlaceholderText("ES: C:\\Users\\<nome utente>\\Downloads\\munnizza")
        self.le_temp_folder.lineEdit().setPlaceholderText("ES: /media/emanuele/extra/temp (opzionale - usa cartella di sistema se vuoto)")
        self.le_map_output.setPlaceholderText("Solo nome file (es. mappe_catastali)")
        self.le_ple_output.setPlaceholderText("Solo nome file (es. particelle_catastali)")
        self.le_url.setPlaceholderText("ES: https://wfs.cartografia.agenziaentrate.gov.it/inspire/wfs/GetDataset.php?dataset=SICILIA.zip")

        self.btn_toggle_help.clicked.connect(self.toggle_help_panel)

        self.populate_regions()

        def updateFileType():
            ext = self.cb_format.currentText().lower()
            self.le_map_output.setPlaceholderText(f"Solo nome file (es. mappe_catastali.{ext})")
            self.le_ple_output.setPlaceholderText(f"Solo nome file (es. particelle_catastali.{ext})")
            if self.le_map_output.text():
                base_path = self.le_map_output.text().split('.')[0]
                self.le_map_output.setText(f"{base_path}.{ext}")
            if self.le_ple_output.text():
                base_path = self.le_ple_output.text().split('.')[0]
                self.le_ple_output.setText(f"{base_path}.{ext}")

        self.cb_format.currentTextChanged.connect(updateFileType)
        self.cb_region.currentTextChanged.connect(self.update_provinces)
        self.list_provinces.itemSelectionChanged.connect(self.update_comuni_list)

        # Transfer widget signals
        self.le_cerca_comune.textChanged.connect(self._filter_comuni_disponibili)
        self.btn_add_comune.clicked.connect(self._add_comuni)
        self.btn_remove_comune.clicked.connect(self._remove_comuni)
        self.list_comuni_disponibili.itemDoubleClicked.connect(self._add_comune_singolo)
        self.list_comuni_selezionati.itemDoubleClicked.connect(self._remove_comune_singolo)

        self.setup_help_content()
        self.update_provinces()

    def cancel_operation(self):
        pass

    def closeEvent(self, event):
        self.le_folder.setFilePath("")
        self.le_temp_folder.setFilePath("")
        self.le_map_output.setText("")
        self.le_ple_output.setText("")
        self.list_comuni_disponibili.clear()
        self.list_comuni_selezionati.clear()
        self.label_comuni_selezionati.setText("Selezionati (0)")
        self.le_cerca_comune.clear()
        self.cb_file_type.setCurrentIndex(0)
        self.cb_format.setCurrentIndex(0)
        self.cb_region.setCurrentIndex(0)
        self.le_url.clear()
        self.text_log.clear()
        print("close!")

    def populate_regions(self):
        self.cb_region.clear()
        self.cb_region.addItems(REGIONS)

    def get_selected_region(self):
        return self.cb_region.currentText()

    def update_provinces(self):
        region = self.cb_region.currentText()
        provinces = get_provinces(region)
        self.list_provinces.clear()
        self.list_provinces.addItems(provinces)
        self._reset_comuni_widget()

    def update_comuni_list(self):
        """Popola list_comuni_disponibili con i comuni delle province selezionate.

        I comuni già presenti in list_comuni_selezionati vengono esclusi.
        """
        self.list_comuni_disponibili.clear()
        self.le_cerca_comune.clear()

        selected_provinces = self.list_provinces.selectedItems()
        if not selected_provinces:
            return

        # Codici già selezionati — non mostrarli nella lista disponibili
        selected_codes = self._get_selected_codes()

        all_comuni = []
        for prov_item in selected_provinces:
            sigla = prov_item.text().strip().upper()
            all_comuni.extend(get_comuni_by_province(sigla))

        all_comuni.sort(key=lambda x: x[1])

        for codice, nome in all_comuni:
            if codice not in selected_codes:
                item = QListWidgetItem(nome)
                item.setData(Qt.UserRole, codice)
                self.list_comuni_disponibili.addItem(item)

    # ------------------------------------------------------------------ #
    # Transfer widget helpers                                              #
    # ------------------------------------------------------------------ #

    def _get_selected_codes(self):
        """Restituisce il set dei codici Belfiore già in lista_selezionati."""
        codes = set()
        for i in range(self.list_comuni_selezionati.count()):
            codes.add(self.list_comuni_selezionati.item(i).data(Qt.UserRole))
        return codes

    def _filter_comuni_disponibili(self, text):
        """Nasconde/mostra item in lista disponibili in base al testo di ricerca."""
        text_upper = text.upper()
        for i in range(self.list_comuni_disponibili.count()):
            item = self.list_comuni_disponibili.item(i)
            item.setHidden(text_upper not in item.text().upper())

    def _move_to_selezionati(self, item):
        """Sposta un item da disponibili a selezionati."""
        self.list_comuni_disponibili.takeItem(self.list_comuni_disponibili.row(item))
        new_item = QListWidgetItem(item.text())
        new_item.setData(Qt.UserRole, item.data(Qt.UserRole))
        self.list_comuni_selezionati.addItem(new_item)
        self._update_counter()

    def _move_to_disponibili(self, item):
        """Sposta un item da selezionati a disponibili, reinserendo in ordine."""
        self.list_comuni_selezionati.takeItem(self.list_comuni_selezionati.row(item))
        new_item = QListWidgetItem(item.text())
        new_item.setData(Qt.UserRole, item.data(Qt.UserRole))
        self.list_comuni_disponibili.addItem(new_item)
        self.list_comuni_disponibili.sortItems()
        # Riapplica eventuale filtro di ricerca
        self._filter_comuni_disponibili(self.le_cerca_comune.text())
        self._update_counter()

    def _add_comuni(self):
        """Pulsante →: sposta tutti gli item selezionati in lista disponibili."""
        for item in self.list_comuni_disponibili.selectedItems():
            self._move_to_selezionati(item)

    def _remove_comuni(self):
        """Pulsante ←: rimuove tutti gli item selezionati da lista selezionati."""
        for item in self.list_comuni_selezionati.selectedItems():
            self._move_to_disponibili(item)

    def _add_comune_singolo(self, item):
        """Doppio clic su lista disponibili: sposta l'item."""
        self._move_to_selezionati(item)

    def _remove_comune_singolo(self, item):
        """Doppio clic su lista selezionati: rimuove l'item."""
        self._move_to_disponibili(item)

    def _update_counter(self):
        count = self.list_comuni_selezionati.count()
        self.label_comuni_selezionati.setText(f"Selezionati ({count})")

    def _reset_comuni_widget(self):
        """Svuota entrambe le liste e azzera il contatore."""
        self.list_comuni_disponibili.clear()
        self.list_comuni_selezionati.clear()
        self.label_comuni_selezionati.setText("Selezionati (0)")
        self.le_cerca_comune.clear()

    def toggle_help_panel(self):
        if self.help_browser.isVisible():
            self.help_browser.hide()
            self.btn_toggle_help.setIcon(QIcon(":/qt-project.org/styles/commonstyle/images/right-32.png"))
            self.btn_toggle_help.setToolTip("Mostra guida")
        else:
            self.help_browser.show()
            self.btn_toggle_help.setIcon(QIcon(":/qt-project.org/styles/commonstyle/images/left-32.png"))
            self.btn_toggle_help.setToolTip("Nascondi guida")

    def setup_help_content(self):
        help_file_path = os.path.join(os.path.dirname(__file__), 'help_content.html')
        if os.path.exists(help_file_path):
            with open(help_file_path, 'r', encoding='utf-8') as html_file:
                self.help_browser.setHtml(html_file.read())
        else:
            self.help_browser.setHtml("<p>File della guida non trovato.</p>")
