# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CatastoIT_GML_Merger_ProDialog
                                 A QGIS plugin CatastoIT_GML_Merger_Pro
                                 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-02-10
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Salvatore Fiandaca
        email                : Salvatore Fiandaca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import sys

sys.path.append(os.path.dirname(__file__))
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QProgressBar, QPushButton
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import Qt
# from qgis.gui import QgsProjectionSelectionWidget  # Aggiungi questa importazione
# from qgis.core import QgsCoordinateReferenceSystem  # Aggiungi questa importazione
from .regions import REGIONS, get_provinces

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'CatastoIT_GML_Merger_Pro_dialog_base.ui'), resource_suffix='')


class CatastoIT_GML_Merger_ProDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(CatastoIT_GML_Merger_ProDialog, self).__init__(parent)
        self.setupUi(self)
        
        # Aggiungi il pulsante di minimizzazione
        self.setWindowFlags(self.windowFlags() | Qt.WindowMinimizeButtonHint)
        
        # Aggiungi il widget di selezione CRS
        # self.mQgsProjectionSelectionWidget = QgsProjectionSelectionWidget(self)
        # self.mQgsProjectionSelectionWidget.setCrs(QgsCoordinateReferenceSystem('EPSG:6706'))
        # Aggiungi il widget al layout appropriato - modifica in base alla tua UI
        # self.layout().addWidget(self.mQgsProjectionSelectionWidget)
            
        if not hasattr(self, 'btn_cancel'):
            self.btn_cancel = QPushButton("Annulla", self)
            self.btn_cancel.setVisible(False)
            self.btn_cancel.clicked.connect(self.cancel_operation)
            self.layout().addWidget(self.btn_cancel)
        
        # Imposta il placeholder per il widget di selezione cartella
        self.le_folder.lineEdit().setPlaceholderText("ES: C:\\Users\\<nome utente>\\Downloads\\munnizza")
        
        # Imposta i placeholder direttamente sui QLineEdit (non più QgsFileWidget)
        self.le_map_output.setPlaceholderText("Solo nome file (es. mappe_catastali)")
        self.le_ple_output.setPlaceholderText("Solo nome file (es. particelle_catastali)")
        self.le_url.setPlaceholderText("ES: https://wfs.cartografia.agenziaentrate.gov.it/inspire/wfs/GetDataset.php?dataset=SICILIA.zip")
        
        # Configura il pulsante per mostrare/nascondere la guida
        self.btn_toggle_help.clicked.connect(self.toggle_help_panel)
        
        # Popola il combobox delle regioni
        self.populate_regions()
        
        # Non possiamo più usare setFilter su QLineEdit perché non è un QgsFileWidget
        # self.le_map_output.setFilter('*.gpkg')
        # self.le_ple_output.setFilter('*.gpkg')
        
        def updateFileType():
            ext = self.cb_format.currentText().lower()
            # Non possiamo più usare setFilter o filePath su QLineEdit
            # Invece, possiamo aggiornare il placeholder text per riflettere il formato
            self.le_map_output.setPlaceholderText(f"Solo nome file (es. mappe_catastali.{ext})")
            self.le_ple_output.setPlaceholderText(f"Solo nome file (es. particelle_catastali.{ext})")
            
            # Per aggiornare l'estensione nei campi esistenti, dovremmo:
            if self.le_map_output.text():
                base_path = self.le_map_output.text().split('.')[0]
                self.le_map_output.setText(f"{base_path}.{ext}")
            
            if self.le_ple_output.text():
                base_path = self.le_ple_output.text().split('.')[0]
                self.le_ple_output.setText(f"{base_path}.{ext}")
        
        # Connetti il segnale alla funzione
        self.cb_format.currentTextChanged.connect(updateFileType)
        
        # Connetti il cambio di regione all'aggiornamento delle province
        self.cb_region.currentTextChanged.connect(self.update_provinces)
        
        # Chiamare questo metodo durante l'inizializzazione del dialogo
        self.setup_help_content()
        
        # Aggiorna la lista delle province all'apertura con la regione predefinita
        self.update_provinces()
        
    def closeEvent(self, event):
        # dir_path = directory_temporanea

        # try:
            # shutil.rmtree(dir_path)
            # log_message(f"directory {dir_path} rimossa correttamente")
        # except OSError as e:
           # log_message("\nError: %s : %s" % (dir_path, e.strerror))

        self.le_folder.setFilePath("")
        # Usando setText invece di setFilePath per i QLineEdit
        self.le_map_output.setText("")
        self.le_ple_output.setText("")
        self.cb_file_type.setCurrentIndex(0)
        self.cb_format.setCurrentIndex(0)
        self.cb_region.setCurrentIndex(0)
        self.le_url.clear()
        self.text_log.clear()
        
        print("close!")

    def populate_regions(self):
        """Popola il combobox delle regioni."""
        self.cb_region.clear()
        self.cb_region.addItems(REGIONS)

    def get_selected_region(self):
        """Restituisce la regione selezionata."""
        return self.cb_region.currentText()
    
    def update_provinces(self):
        """Aggiorna il combobox delle province in base alla regione selezionata."""
        region = self.cb_region.currentText()
        provinces = get_provinces(region)
        
        self.list_provinces.clear()
        self.list_provinces.addItems(provinces)
        
    def toggle_help_panel(self):
        """Gestisce la visualizzazione/nascondimento del pannello della guida."""
        if self.help_browser.isVisible():
            self.help_browser.hide()
            self.btn_toggle_help.setIcon(QIcon(":/qt-project.org/styles/commonstyle/images/right-32.png"))
            self.btn_toggle_help.setToolTip("Mostra guida")
        else:
            self.help_browser.show()
            self.btn_toggle_help.setIcon(QIcon(":/qt-project.org/styles/commonstyle/images/left-32.png"))
            self.btn_toggle_help.setToolTip("Nascondi guida")
            
    def setup_help_content(self):
        """Carica il contenuto della guida dal file HTML esterno"""
        # Percorso del file HTML relativo alla posizione del plugin
        help_file_path = os.path.join(os.path.dirname(__file__), 'help_content.html')
        
        # Verifica se il file esiste
        if os.path.exists(help_file_path):
            with open(help_file_path, 'r', encoding='utf-8') as html_file:
                help_content = html_file.read()
                self.help_browser.setHtml(help_content)
        else:
            self.help_browser.setHtml("<p>File della guida non trovato.</p>")

