# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CatGrowing
                                 A QGIS plugin
 Region-growing algorithm for spatial analysis using categorical raster and vector data.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-01-08
        copyright            : (C) 2025 Consejo Superior de Investigaciones Científicas (CSIC), Estación Experimental de Zonas Áridas (EEZA)
        email                : arranca@eeza.csic.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   any later version.                                                    *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Developed by Alberto Ruiz-Rancaño, under contract by Gabriel del Barrio Escribano (EEZA - CSIC)'
__date__ = '2024-01-08'
__copyright__ = '(C) 2025 Consejo Superior de Investigaciones Científicas (CSIC), Estación Experimental de Zonas Áridas (EEZA)'


# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from PyQt5.QtGui import QIcon
from qgis.PyQt.QtCore import QFileInfo
from .cat_growing_algorithm import CatGrowingAlgorithm


class CatGrowingProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(CatGrowingAlgorithm())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'CatGrowing'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('CatGrowing')

    def icon(self):
        """
        Returns a QIcon for your provider inside the Processing toolbox.
        """
        plugin_dir = QFileInfo(__file__).path()  # Get the plugin directory
        icon_path = f"{plugin_dir}/icon.png"  # Path to the icon file
        return QIcon(icon_path)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
