# -*- coding: utf-8 -*-


from qgis.PyQt import QtCore, QtGui
from qgis.gui import *
from qgis.core import *


import math, copy
from .resources import *
from .mainWindow import *




class calcareaMain( QtWidgets.QWidget): # Inherits QWidget to install an Event filter
    def __init__(self,iface):

        QtWidgets.QWidget.__init__(self)

        #----------------------------------------------------------------------
        # instance variables

        # Reference to the QGIS Interface
        self.iface = iface
        self.mc = self.iface.mapCanvas()    # Map Canvas variable

        self.layer = QgsVectorLayer()

        self.maptool = QgsMapTool(self.mc)     # force a variable type
        self.grafArea = QgsDistanceArea()
        self.DialogDock = QtWidgets.QDockWidget()
        self.Dialog = QtWidgets.QDialog()
        self.cpoint_list = []
        self.end = False

        # connection tracking (?)
        self.Con_temp_vertex = False
        self.Con_layer = False


        #----------------------------------------------------------------------


    # initialize the connection to the QGIS GUI - the plugin starts from there
    def initGui(self):

        self.actionCalcArea = QtWidgets.QAction( QtGui.QIcon(":/plugins/CalcArea/CalcArea.png"),  QtCore.QCoreApplication.translate("calcareaMain", "Calculate the Area while editing. Best with Plugin Improved Polygon Capturing."),  self.iface.mainWindow() )
        self.actionCalcArea.triggered.connect(self.showMainWindow)

        self.iface.addToolBarIcon( self.actionCalcArea )
        self.iface.addPluginToVectorMenu(QtCore.QCoreApplication.translate("calcareaMain",  "Calculate area while editing"),  self.actionCalcArea)


    # the dock widget is created
    def showMainWindow(self):


        if not self.mc.mapUnits() == 0: # squaremeter!
            QtWidgets.QMessageBox.critical(None, QtCore.QCoreApplication.translate("calcareaMain","Wrong Units!"),QtCore.QCoreApplication.translate("calcareaMain",'The Plugin needs metrical Units!'))
            return

        if self.iface.mainWindow().findChild(QtWidgets.QDockWidget,'CalcArea DialogDock') == None:

            self.Dialog = CalcAreaDialog()
            self.DialogDock = QtWidgets.QDockWidget('Calc Area', self.iface.mainWindow())
            self.DialogDock.setWidget(self.Dialog)

            self.DialogDock.setObjectName('CalcArea DialogDock')
            self.Dialog.setObjectName('CalcArea Dialog')

        else:
            return

        self.iface.mainWindow().addDockWidget(QtCore.Qt.LeftDockWidgetArea, self.DialogDock)
        self.DialogDock.show()

        #self.Dialog.installEventFilter(self)
        self.DialogDock.installEventFilter(self)




        # emits a map tool change event
        self.mc.mapToolSet.connect(self.digklick)

        # emits a layer change event
        self.iface.currentLayerChanged.connect(self.switch_layer)

        # initialize the maptool object
        self.maptool = self.mc.mapTool()

        # edit session active?
        if self.mc.mapTool().action().objectName().find('AddFeature') > -1 or self.mc.mapTool().action().objectName().find('VertexTool') > -1 :
            self.digklick()

        self.switch_layer(self.mc.currentLayer())

        # fetch events before Qgis
        self.iface.mapCanvas().viewport().installEventFilter( self)


    # unload plugin from QGIS App
    def unload(self):


        # first delete the Widgets!
        self.Dialog = None
        self.iface.mainWindow().removeDockWidget(self.DialogDock)
        self.DialogDock = None

        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"&CalcArea", self.actionCalcArea)
        self.iface.removeToolBarIcon(self.actionCalcArea)


    # calculate the feature area/perimeter and
    # update the fields of the dialog widget
    def area(self,feat):

        self.Dialog.lblQuadratmeter.setText(str(round(self.grafArea.measureArea(feat),2)) + ' m²')
        self.Dialog.lblHektar.setText(str(round(self.grafArea.measureArea(feat)/10000,2)) + ' ha')
        self.Dialog.lblQuadratkilometer.setText(str(round(self.grafArea.measureArea(feat)/1000000,2)) + ' km²')


        self.Dialog.lblMeter.setText(str(round(self.grafArea.measurePerimeter(feat),2)) + ' m')
        self.Dialog.lblKilometer.setText(str(round(self.grafArea.measurePerimeter(feat)/1000,2)) + ' km')


    # slot for the 'geometryChanged' layer signal
    def seppl(self,id,feat):
        self.area(feat)
        self.cpoint_list = []    #then empty the list!


    # slot for the 'featureAdded' layer signal
    def kasperl(self,id):
        seli = QgsFeatureRequest(id)
        feat = QgsFeature()
        iti = self.layer.getFeatures(seli)
        iti.nextFeature(feat)
        self.area(feat.geometry())
        self.cpoint_list = []    # then empty the list!


    # slot for the 'selectionChanged' signal
    def switch_feature(self):

        features = self.layer.selectedFeatures()

        if not features == None:
            if len (features) == 1:
                self.area(features[0].geometry())
            if len (features) > 1:
                self.layer.removeSelection()

    # slot for the 'currentLayerChanged' signal emitted by the QGIS iface
    def switch_layer(self,layer):


        # to prevent an error when closing QGIS
        # while the plugin is still active
        if layer == None:
            return

        # if a layer is already connected -> disconnect first the reinitialize the layer object variable
        if self.Con_layer:

            self.layer.geometryChanged.disconnect(self.seppl)
            self.layer.featureAdded.disconnect(self.kasperl)
            self.layer.selectionChanged.disconnect(self.switch_feature)
            self.Con_layer = False



        # polygon layer with read/write access
        if layer.type() == 0 and layer.geometryType() == 2 and not layer.readOnly():
            self.layer = layer
            self.Dialog.lblLayer_area.setText('Layer: ' + self.layer.name())
            self.Dialog.lblLayer_perimeter.setText('Layer: ' + self.layer.name())

            self.layer.geometryChanged.connect(self.seppl)
            self.layer.featureAdded.connect(self.kasperl)
            self.layer.selectionChanged.connect(self.switch_feature)
            self.Con_layer = True

        else:   # wrong layer type
            self.layer = None
            self.Dialog.lblLayer_area.setText('Layer: ')



    # slot for the map tool change event of the map canvas
    def digklick(self):

        Aktion = self.mc.mapTool()
        self.maptool = Aktion


        # If the tool is without a name attribute
        if Aktion.action() == None :

            self.Dialog.lblQuadratmeter.setText('')
            self.Dialog.lblHektar.setText('')
            self.Dialog.lblQuadratkilometer.setText('')
            self.Dialog.lblMeter.setText('')
            self.Dialog.lblKilometer.setText('')

            if self.Con_temp_vertex:
                self.mc.xyCoordinates.disconnect(self.temp_vertex)
                self.Con_temp_vertex = False

        elif Aktion.action().objectName().find('AddFeature') > -1 :   # edit tool AddFeature

            self.mc.xyCoordinates.connect(self.temp_vertex)
            self.Con_temp_vertex = True

        elif Aktion.action().objectName().find('VertexTool') > -1 :   # edit tool NodeTool

            if self.Con_temp_vertex:
                self.mc.xyCoordinates.disconnect(self.temp_vertex)
                self.Con_temp_vertex = False

        else:   # some other tool is selected

            self.Dialog.lblQuadratmeter.setText('')
            self.Dialog.lblHektar.setText('')
            self.Dialog.lblQuadratkilometer.setText('')
            self.Dialog.lblMeter.setText('')
            self.Dialog.lblKilometer.setText('')

            if self.Con_temp_vertex:
                self.mc.xyCoordinates.disconnect(self.temp_vertex)
                self.Con_temp_vertex = False
            #self.Dialog.repaint()



    # slot for the xyCoordinates signal of the map canvas
    def temp_vertex(self,point):


        b = []
        b = self.cpoint_list[:]
        b.append(QgsPointXY(point)) # add the coordinate of the current mouse position

        if len(b) > 2:  # an area consists of at least three points
             self.area(QgsGeometry().fromPolygonXY([b]))



    # event filter
    def eventFilter(self,affe,event):

        if not event == None:


            if event.type() == QtCore.QEvent.Close: # close event

                self.mc.mapToolSet.disconnect(self.digklick)
                self.iface.currentLayerChanged.disconnect(self.switch_layer)
                if self.Con_temp_vertex:
                    self.mc.xyCoordinates.disconnect(self.temp_vertex)
                    self.Con_temp_vertex = False


                if not self.layer == None:

                    if self.Con_layer:

                        self.layer.geometryChanged.disconnect(self.seppl)
                        self.layer.featureAdded.disconnect(self.kasperl)
                        self.layer.selectionChanged.disconnect(self.switch_feature)
                        self.Con_layer = False
                    self.layer = None


                #self.Dialog.removeEventFilter(self)
                self.DialogDock.removeEventFilter(self)
                self.iface.mapCanvas().viewport().removeEventFilter( self)

                # delete the Widgets!
                self.Dialog = None  # delete
                self.iface.mainWindow().removeDockWidget(self.DialogDock)   #first remove
                self.DialogDock = None  # delete


                return True

            elif event.type() == QtCore.QEvent.MouseButtonPress: # mouse press event during edit session
                X_ = event.localPos().x()
                Y_ = event.localPos().y()
                transi = self.mc.getCoordinateTransform()

                # A Feature is edited using the NodeTool -> Generating a slection initiates the recalculation of the newly selected feature's area
                if self.maptool.action().objectName().find('VertexTool') > -1 :   # edit tool VertexTool
                    self.layer.removeSelection()
                    shift=self.mc.mapUnitsPerPixel()
                    wahlRect = QgsRectangle(transi.toMapCoordinatesF(X_-5,Y_-5),transi.toMapCoordinatesF(X_+5,Y_+5))
                    self.layer.selectByRect(wahlRect,False)

                    return False    # do not block the event
                else:
                    if event.button() == QtCore.Qt.LeftButton:
                        self.cpoint_list.append(QgsPointXY(transi.toMapCoordinatesF(X_,Y_)))
                        return False    # do not block the event
                    elif event.button() == QtCore.Qt.RightButton:
                        self.cpoint_list= []
                        return False
            else:   # everything else
                return False



# Dialog Widget Class
# inherits the QT Designer window definition
# and the QDialog definition
class CalcAreaDialog(QtWidgets.QDialog,Ui_frmMainWindow):
    def __init__(self):

        QtWidgets.QDialog.__init__(self)
        Ui_frmMainWindow.__init__(self)

        self.setupUi(self)  # creates the GUI specified with QT Designer


