# -*- coding: utf-8 -*-
"""
/***************************************************************************
 A QGIS plugin
CaigosConnector: Connect CAIGOS-GIS with QGIS
        copyright            : (C) 2026 by EZUSoft
        email                : qgis (at) makobo.de
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""








mystat = 'down'
import sys
from qgis.utils import iface
from qgis.core import QgsNetworkAccessManager
from qgis.PyQt.QtCore import QEventLoop, QTimer, QUrl, QSettings
from qgis.PyQt.QtWidgets import QApplication
from qgis.PyQt.QtNetwork import QNetworkRequest, QNetworkReply
from os import path, remove


try:

    from .qt_compat import WaitCursor, QGIS_VERSION_INT, HttpStatusCodeAttribute
    from .fnc4all import *   
    from .fnc4CaigosConnector import EZU366C2CC3BAD145709B8EEEB611D1D6AA, EZU11DE7CED39F2439E803B738E6E678716, EZUF9FB4AE0A2B44C8B8313441BFB307407
except ImportError:

    from qt_compat import WaitCursor, QGIS_VERSION_INT, HttpStatusCodeAttribute
    from fnc4all import *   
    from fnc4CaigosConnector import EZU366C2CC3BAD145709B8EEEB611D1D6AA, EZU11DE7CED39F2439E803B738E6E678716, EZUF9FB4AE0A2B44C8B8313441BFB307407


def exec_loop(loop):

    try:
        return loop.exec_()
    except AttributeError:
        return loop.exec()


def is_no_error(reply):

    try:

        return reply.error() == QNetworkReply.NetworkError.NoError
    except AttributeError:

        return reply.error() == QNetworkReply.NoError


def EZUC8D59B20568948389B1274373D8E0990(dlURL, LokFileName, timeout_ms=300000, max_redirects=5):







    def write_file(filename, content):
        if path.exists(filename):
            remove(filename)
        with open(filename, "wb") as f:
            f.write(bytes(content))

    manager = QgsNetworkAccessManager.instance()
    current_url = dlURL
    redirects = 0
    size = None
    status = None

    while redirects <= max_redirects:
        loop = QEventLoop()
        timer = QTimer()
        timer.setSingleShot(True)

        request = QNetworkRequest(QUrl(current_url))
        reply = manager.get(request)

        def on_timeout():
            reply.abort()
            loop.quit()

        def on_finished():
            loop.quit()

        timer.timeout.connect(on_timeout)
        reply.finished.connect(on_finished)

        timer.start(timeout_ms)
        exec_loop(loop)


        try:
            status = reply.attribute(QNetworkRequest.HttpStatusCodeAttribute)
        except Exception:
            status = None


        try:
            redirect_url = reply.header(QNetworkRequest.LocationHeader)
        except Exception:
            redirect_url = None


        if is_no_error(reply) and not redirect_url:
            content = reply.readAll()
            write_file(LokFileName, content)
            size = path.getsize(LokFileName) if path.exists(LokFileName) else None
            reply.deleteLater()
            break


        if redirect_url:
            current_url = str(redirect_url)
            redirects += 1
            reply.deleteLater()
            continue


        reply.deleteLater()
        break

    return size, status


def EZU1C9648848F904099A178AD545D77A882():
    s = QSettings("EZUSoft", EZU366C2CC3BAD145709B8EEEB611D1D6AA())
    if s.value("status", "") == "":

        ret = EZU39041CAE6C224B57B5E3F261A44FA369("https://www.makobo.de/")
        s.setValue("status", ret[0])
        if ret[0]:
            s.setValue("status", ret[1])



        if s.value("osversion", "") == "29130F16011C1F101411165F5641": 
            s.setValue("status", 'man')
        if s.value("osversion", "") == "2014010406051F090F1B14": 
            s.setValue("status", 'man')    


def EZU39041CAE6C224B57B5E3F261A44FA369(dlURL):
    def onfinish():
        if iface: 
            iface.messageBar().clearWidgets()
        onfinish.ret = reply.readAll()
        loop.quit()
    
    def EZU279A3D55C41548C48ADEE50C980EB2FA():
        import platform
        fncBrowserId = platform.platform()
        chkurl = "https://www.makobo.de/links/Caigos_CheckVersion.php?"
        return chkurl + EZU11DE7CED39F2439E803B738E6E678716() + "|" + str(QGIS_VERSION_INT) + ":" + EZUF9FB4AE0A2B44C8B8313441BFB307407()
    
    def EZUC39342A9E225496F8A7D38CB18529D36():
        EZUC39342A9E225496F8A7D38CB18529D36.time_to_wait += 10
        if iface: 
            iface.messageBar().clearWidgets()
        if iface: 
            iface.messageBar().pushMessage("Initialisierung", "Teste Internetverbindung ....TimeOut " + str(EZUC39342A9E225496F8A7D38CB18529D36.time_to_wait) + '%')
        if EZUC39342A9E225496F8A7D38CB18529D36.time_to_wait == 110:
            timer.stop()
            loop.quit()

    def EZUD4F3B36B8D934F04A94F67750C65AF08(self, event):
        self.timer.stop()
        event.accept()    
        

    EZUC39342A9E225496F8A7D38CB18529D36.time_to_wait = 0
    onfinish.ret = ''
    if iface: 
        iface.messageBar().pushMessage("Initialisierung", "Teste Internetverbindung ....")
    QApplication.setOverrideCursor(WaitCursor)
    request = QNetworkRequest()
    request.setUrl(QUrl(EZU279A3D55C41548C48ADEE50C980EB2FA()))
    

    manager = QgsNetworkAccessManager.instance()
    
    reply = manager.get(request)
    reply.setParent(None)
    
    loop = QEventLoop()
    timer = QTimer()
    timer.setInterval(500)
    timer.timeout.connect(EZUC39342A9E225496F8A7D38CB18529D36)
    timer.start()
    reply.finished.connect(onfinish) 
    exec_loop(loop)

    if timer.isActive():
        timer.stop()

    if iface: 
        iface.messageBar().clearWidgets()
    QApplication.restoreOverrideCursor()




    return reply.attribute(QNetworkRequest.HttpStatusCodeAttribute) == 200, onfinish.ret








