# -*- coding: utf-8 -*-
"""
/***************************************************************************
 A QGIS plugin
CaigosConnector: Connect CAIGOS-GIS with QGIS
        copyright            : (C) 2026 by EZUSoft
        email                : qgis (at) makobo.de
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""







































from osgeo import ogr 
from qgis.utils import *
import time


try:
    from .qt_compat import (
        QT6, QGIS3, QGIS4,
        WaitCursor, AlignLeft,
        exec_dialog,
        QTimer, QUrl, QByteArray,
        MsgBox_Yes, MsgBox_No,  MsgBarInfo, QGIS_VERSION_INT
    )
except ImportError:
    from qt_compat import (
        QT6, QGIS3, QGIS4,
        WaitCursor, AlignLeft,
        exec_dialog,
        QTimer, QUrl, QByteArray,
        MsgBox_Yes, MsgBox_No,  MsgBarInfo, QGIS_VERSION_INT
    )

from qgis.PyQt import QtGui, uic
from qgis.PyQt.QtCore import QSettings, QCoreApplication
from qgis.PyQt.QtWidgets import QDialog, QProgressBar, QApplication, QMessageBox
from qgis.PyQt.QtSql import QSqlDatabase, QSqlQuery, QSqlError

from qgis.core import (
    QgsProject, QgsVectorLayer,
    QgsLayerTreeLayer, QgsLayerTreeGroup, QgsVectorFileWriter,
    QgsLayerDefinition
)

try:
    from .fnc4all import *
    from .fnc4CaigosConnector import *
    from .clsDatenbank import *
    from .clsRenderingByQML import *
    from .modDownload import *
except ImportError:
    from fnc4all import *
    from fnc4CaigosConnector import *
    from clsDatenbank import *
    from clsRenderingByQML import *
    from modDownload import *


class clsQGISAction():  
    def EZU03023EF7FCAA442486B6AF6B66E6DC95(self, shpDat):
        try:
            rest = shpDat  
            for rest in glob(shpDat[0:-4] + '.*'):
                os.remove(rest)
            return True
        except OSError as e:
            EZU2CC2ED60E16A4317BA8BEBE4D6120301()
            EZUC8DCB02F1A8145AF82C8A69A43E0529B(u"Datei Löschfehler %s - %s." % (e.filename, e.strerror))
            return None
        
    def EZUFC52B0BB0EB14DA582CD889C9683B298(self):

        LayerList = QgsProject.instance().mapLayers()
        for layer in LayerList:
            QgsProject.instance().removeMapLayer(layer)
 
    def EZU36EB5B0BF324447DB03DB38A6DBEC31E(self, NameOfGroup):



        try:
            root = QgsProject.instance().layerTreeRoot()
            for child in root.children():
                if isinstance(child, QgsLayerTreeGroup):
                    if child.name() == NameOfGroup:
                        root.removeChildNode(child)
                        break
        except:
            EZU2CC2ED60E16A4317BA8BEBE4D6120301()
    
    def EZUC6B7AA70E6D148F4BA70BF8E44116329(self, NameOfGroup):



        root = QgsProject.instance().layerTreeRoot()
        for idx, child in enumerate(root.children()):
            if isinstance(child, QgsLayerTreeGroup):
                if child.name() == NameOfGroup:
                    return idx
        return None

    def EZU2E78EDB4D1D440558B77FFCE3E2724AA(self, lName):

        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == lName:
                return lyr
        return None
                    
    def EZU36BBFBA4F61246038D8E16E3CE6E2973(self):

        root = QgsProject.instance().layerTreeRoot()
        for child in root.children():
            if isinstance(child, QgsLayerTreeLayer):
                child.setCustomProperty("showFeatureCount", True)
    
    def EZU4EB57D86B4434DCEBA927278193D9F1D(self, prjNameInTree, qry):

        newparent = True
        Fachschale = None
        Thema = None
        Gruppe = None
        i = 0
        

        rNode = QgsProject.instance().layerTreeRoot()   
        for node in rNode.children():
            if isinstance(node, QgsLayerTreeGroup):
                if node.name() == prjNameInTree:
                    rNode.removeChildNode(node)


        ltgProjekt = rNode.addGroup(prjNameInTree)
        ltgProjekt.setExpanded(True) 
        ltgProjekt.setItemVisibilityChecked(True)    

        while qry.next():
            i = i + 1
            if qry.value(0) != Fachschale:
                newparent = True
                f = ltgProjekt.addGroup(qry.value(0))
                f.setExpanded(True)
                f.setItemVisibilityChecked(True)

            if newparent or qry.value(1) != Thema:
                newparent = True
                t = f.addGroup(EZU9A25B96EF34E432F8B39C40EA0D860A6(qry.value(1)))
                t.setExpanded(False)
                t.setItemVisibilityChecked(True)
            
            if newparent or qry.value(2) != Gruppe:
                newparent = True
                g = t.addGroup(EZU9A25B96EF34E432F8B39C40EA0D860A6(qry.value(2)))
                g.setItemVisibilityChecked(True)
                
            Fachschale = qry.value(0)
            Thema = qry.value(1)
            Gruppe = qry.value(2)
            newparent = False
            
        return ltgProjekt
        
    def EZU9569D8F0E36C44ACB766DB0A73364BC3(self, AktDB, User, prjNameInTree, qry4pri, qry, bGenDar, bPrjNeu, 
                  iDarGruppe, b3DDar, bDBTab, intExport, bLeer, intObjKlasse, 
                  bDarObjKl, intKeyTab, OutOfQGIS=False):

        try:
            start = time.perf_counter()
            def EZU1797DF3F28734C58A62078E9471FB2D6(prgBar, msgBar, Step, Titel, Text):

                try:
                    prgBar.setValue(Step)
                    msgBar.setTitle(Titel)
                    msgBar.setText(Text)
                    QCoreApplication.processEvents()
                    return True
                except:
                    QMessageBox.critical(None, "Abbruch", 
                                       "Vorgang durch Nutzereingriff beendet")
                    return False
                    
            idxLayer = -1

            bSHPexp = (intExport == 1)
            bGPKGexp = (intExport == 2)
            
            if bSHPexp or bGPKGexp:
                s = QSettings("EZUSoft", EZU366C2CC3BAD145709B8EEEB611D1D6AA())
                bSaveDar = True if s.value("bSaveDar", "Ja") == "Ja" else False
                bOnlyDarField = True if s.value("bOnlyDarField", "Ja") == "Ja" else False
                bNoGISDBIntern = True if s.value("bNoGISDBIntern", "Ja") == "Ja" else False
                txtCodePage = s.value("txtCodePage", 0)
                txtZielPfadOrDatei = s.value("txtSHPDir", "")
            
            if bGPKGexp:

                zielDatGPKG = EZUE7D17250C3C7421C9D8813540A672DFC(txtZielPfadOrDatei + "/" + prjNameInTree + ".gpkg")
                if os.path.exists(zielDatGPKG):
                    s = u"Die GPKG-Datei \n'" + zielDatGPKG + u"'\nexistiert bereits. \nKann diese überschrieben werden?"
                    reply = QMessageBox.question(None, u"Geopackage löschen", s, 
                                                MsgBox_Yes | MsgBox_No, MsgBox_No)
                    if reply == MsgBox_Yes:

                        rNode = QgsProject.instance().layerTreeRoot()   
                        for node in rNode.children():
                            if isinstance(node, QgsLayerTreeGroup):
                                if node.name() == prjNameInTree: 
                                    def EZUF0A7C2A1C9C842DBA4063449DC40EA81(node):
                                        for child in node.children():
                                            if isinstance(child, QgsLayerTreeLayer):
                                                QgsProject.instance().removeMapLayer(child.layer())
                                            if isinstance(child, QgsLayerTreeGroup):
                                                EZUF0A7C2A1C9C842DBA4063449DC40EA81(child)
                                    EZUF0A7C2A1C9C842DBA4063449DC40EA81(node)
                        
                        try:    
                            os.remove(zielDatGPKG)
                        except OSError as e:
                            s = u"Datei Löschfehler %s \n%s.\n\nVermutlich sind aktuell Layer aus diesem GeoPackage in QGIS eingebunden." % (e.filename, e.strerror)
                            QMessageBox.critical(None, u"Die Datei konnte nicht gelöscht werden.", s)
                            return None
                    else:
                        QMessageBox.critical(None, u"Nichts zu tun", u"Vorgang wurde abgebrochen.")
                        return None
                

            ConnInfo = AktDB.EZU0E2BDADBE2194E8B8DF502B5EE42B12C()
            
            param = str(EZU51B3FDFA62764BDA9B7CED2681A70937()) + ";" + str(User) + ";" + EZUC936D29251B44D4E994497BF023338C7(prjNameInTree) + ";" + \
                    str(bGenDar) + ";" + str(bPrjNeu) + ";" + str(iDarGruppe) + ";" + str(b3DDar) + ";" + \
                    str(bDBTab) + ";" + str(bSHPexp) + ";" + str(bLeer) + ";" + str(intObjKlasse) + ";" + \
                    str(bDarObjKl) + ";" + str(intKeyTab)
            param = param.replace("False", "F").replace("True", "T")
            Epsg = EZU07A28165B1CC4CC09B4AC9235EA3E8E9()
            cgVersion = EZU1C1D2B936A1D475D8F4C176B585F2301()


            ltgProjekt = self.EZU4EB57D86B4434DCEBA927278193D9F1D(prjNameInTree, qry)
            iface.mapCanvas().setRenderFlag(False)

            QApplication.setOverrideCursor(WaitCursor)
            step = 0
            

            GesAnz = qry4pri.size()
            if bSHPexp or bGPKGexp: 
                GesAnz = GesAnz * 2
            GesAnz = GesAnz + 1
            
            msgBar = iface.messageBar().createMessage("...")
            prgBar = QProgressBar()
            prgBar.setAlignment(AlignLeft)
            prgBar.setValue(0)
            dummy = "https://www.makobo.de/links/Caigos_CheckImport.php?"
            prgBar.setMaximum(GesAnz)           
            msgBar.layout().addWidget(prgBar)
            iface.messageBar().pushWidget(msgBar, MsgBarInfo)


            i = 0    
            while qry4pri.next():

                qry4priEbene = qry4pri.value(0)
                qry4priLayerID = qry4pri.value(1)
                qry4priLayerTyp = qry4pri.value(2)
                qry4priDBname = qry4pri.value(3)


                step = step + 1
                if not EZU1797DF3F28734C58A62078E9471FB2D6(prgBar, msgBar, step, "Laden", qry4priEbene):
                    break
                
                GISDBTabName = None
                refObjID = None

                lName = EZU9A25B96EF34E432F8B39C40EA0D860A6(qry4priEbene)
                
                if bDBTab and qry4priDBname:
                    if EZU728F99262A784CE298F08321DF84E81D(qry4priDBname):
                        if EZUCBFEA090E43A4131AD9D3EB9E69F0F02(qry4priDBname):
                            GISDBTabName = qry4priDBname.lower()
                            refObjID = EZUE2234C86576E4AFDBA184A9078854DDC(qry4priDBname)
                        else:
                            EZUC8DCB02F1A8145AF82C8A69A43E0529B("Fehler Tabellenzugriff (Tabelle:" + qry4priDBname + 
                                    ", Matchcode: like '%%\\_objid', Ebene: " + lName)
                    else:
                        EZUC8DCB02F1A8145AF82C8A69A43E0529B("Tabelle:" + qry4priDBname + " nicht gefunden (Ebene: " + lName + ")")

                vlp, LastGeoTabSpalte = EZU494640CF7D9A43E19FD083B6B034293A(qry4priLayerTyp, ConnInfo, Epsg, 
                                                        qry4priLayerID, b3DDar, GISDBTabName, 
                                                        cgVersion, bSHPexp, refObjID, 
                                                        intObjKlasse, True, intKeyTab)
                if vlp:

                    qmldat = None
                    
                    if EZU50464908A0F8417AA7B9045C4E9B1F6A() == 0:
                        Layer = QgsVectorLayer(vlp, lName, "postgres")
                        
                    if EZU50464908A0F8417AA7B9045C4E9B1F6A() == 1: 

                        crsRegParam4NewLayer1 = '/Projections/defaultBehavior' 
                        crsRegParam4NewLayer2 = '/app/projections/unknownCrsBehavior'
                        
                        m1 = QSettings().value(crsRegParam4NewLayer1)
                        m2 = QSettings().value(crsRegParam4NewLayer2)
                        mcrs = QSettings().value('/Projections/layerDefaultCrs')
                        
                        QSettings().setValue('/Projections/layerDefaultCrs', "EPSG:" + str(EZU07A28165B1CC4CC09B4AC9235EA3E8E9()))
                        QSettings().setValue(crsRegParam4NewLayer1, 'UseDefaultCrs')
                        QSettings().setValue(crsRegParam4NewLayer2, 'UseDefaultCrs')

                        Layer = QgsVectorLayer(vlp, lName, "mssql") 
                        iface.messageBar().clearWidgets()
                        iface.messageBar().pushMessage("Hinweis", "Lade " + lName)
                        

                        QSettings().setValue(crsRegParam4NewLayer1, m1)
                        QSettings().setValue(crsRegParam4NewLayer2, m2)
                        QSettings().setValue('/Projections/layerDefaultCrs', mcrs)

                    if Layer.isValid():
                        Layer.setReadOnly()
                        
                        if bLeer or Layer.featureCount() > 0:
                            bExport = bGPKGexp or bSHPexp

                            if bExport:
                                step = step + 1  
                                if not EZU1797DF3F28734C58A62078E9471FB2D6(prgBar, msgBar, step, "Speichern", qry4priEbene):
                                    break
                                    
                                options = QgsVectorFileWriter.SaveVectorOptions()
                                options.layerName = lName

                                fieldList = [field.name() for field in Layer.fields()]
                                options.attributes = EZU15346725D7EC4BE49A8C7B6A48FC2454(fieldList, bOnlyDarField, 
                                                                         bNoGISDBIntern, LastGeoTabSpalte, 
                                                                         GISDBTabName)
                                    
                                if bGPKGexp:
                                    options.driverName = 'GPKG'
                                    if os.path.exists(zielDatGPKG):
                                        options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer
                                    else:
                                        options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteFile 
                                    Antw = QgsVectorFileWriter.writeAsVectorFormat(Layer, zielDatGPKG, options) 
                            
                                if bSHPexp:
                                    expName = re.sub(r'[\\/:*?"<>|]', "_", lName)
                                    options.driverName = 'ESRI Shapefile'
                                    if self.EZU03023EF7FCAA442486B6AF6B66E6DC95(txtZielPfadOrDatei + "/" + lName + ".shp"):
                                        pShp = EZUE7D17250C3C7421C9D8813540A672DFC(txtZielPfadOrDatei + "/" + lName + ".shp")
                                        qmldat = EZUE7D17250C3C7421C9D8813540A672DFC(txtZielPfadOrDatei + "/" + lName + ".qml")
                                        
                                        Antw = QgsVectorFileWriter.writeAsVectorFormat(Layer, pShp, options) 
                                    else:
                                        Antw = 0, ''
                                        pass
                                

                                if type(Antw) != tuple:
                                    Antw = Antw, "Fehler beim EZU0F29DFD759404DC0AD7127E7983E3254 von " + lName
                                if Antw[0] != 0:
                                    EZUC8DCB02F1A8145AF82C8A69A43E0529B('QgsVectorFileWriter: ' + Antw[1])
                                

                                del(Layer)
                                
                                if not EZU1797DF3F28734C58A62078E9471FB2D6(prgBar, msgBar, step, u"Anfügen", qry4priEbene):
                                    break
                                
                                if bGPKGexp:    
                                    Layer = QgsVectorLayer(zielDatGPKG + '|layername=' + lName, lName, "ogr")                        
                                
                                if bSHPexp:    
                                    Layer = QgsVectorLayer(pShp, lName, "ogr") 

                                Layer.setProviderEncoding(txtCodePage)
                                Layer.dataProvider().setEncoding(txtCodePage) 

                            if Layer.isValid():
                                if bGenDar: 

                                    Antw = EZUBAF63C731D2043EEB63E493676BA1E93(AktDB, User, Layer, qry4priLayerTyp, 
                                                            qry4priLayerID, True, iDarGruppe, bDarObjKl)
                                    if Antw != 'ok':
                                        EZUC8DCB02F1A8145AF82C8A69A43E0529B(lName + "(" + Antw + ") konnte nicht gerendert werden")          

                                    if bSHPexp:
                                        if bSaveDar:
                                            Layer.saveNamedStyle(qmldat)
                                    if bGPKGexp:
                                        if bSaveDar:
                                            try:
                                                Layer.saveStyleToDatabase(options.layerName, 'Aus CAIGOS Export', 
                                                                        True, options.layerName, 
                                                                        '#FEHLER# saveStyleToDatabase:' + options.layerName)
                                            except:
                                                Layer.saveStyleToDatabase(options.layerName, 'Aus CAIGOS Export', 
                                                                        True, options.layerName)


                                AktFachschale, AktThema, AktGruppe, AktLayer = EZU7F7DA500B4FF409BB13A35E5F7EC2E59(qry4priLayerID, AktDB)
                                QgsProject.instance().addMapLayer(Layer, False) 

                                g = ltgProjekt.findGroup(AktFachschale)
                                g = g.findGroup(AktThema)
                                g = g.findGroup(AktGruppe)
                                g.insertLayer(0, Layer)
                            else:
                                if bGPKGexp:
                                    EZUC8DCB02F1A8145AF82C8A69A43E0529B("Fehler Layerkonvertierung nach GeoPackage: " + 
                                            zielDatGPKG + '|layername=' + lName)
                                if bSHPexp:
                                    EZUC8DCB02F1A8145AF82C8A69A43E0529B("Fehler Layerkonvertierung nach Shape: " + 
                                            pShp + '|' + lName + "|ogr")
                        else:
                            pass
                    else:
                        debuglog(vlp + "|" + lName + "|" + "postgres")
                else:
                    EZUC8DCB02F1A8145AF82C8A69A43E0529B(u"Nicht unterstützt Typ " + str(qry4priLayerTyp) + ": " + lName)


            if bSHPexp or bGPKGexp:
                if bSaveDar:
                    substPrjPath = txtZielPfadOrDatei
                    
                    tmpDat = EZUE2CC6C01835941909C82368EAB1CE1E2() + "tmpDat.qlr"
                    qlrDat = EZUE7D17250C3C7421C9D8813540A672DFC(txtZielPfadOrDatei + "/00-" + prjNameInTree + ".qlr")
                    QgsLayerDefinition.exportLayerDefinition(tmpDat, [ltgProjekt])
                    EZUAC460E6F0D4B49ABBAC60E8D53FD6A34(tmpDat, qlrDat, substPrjPath)
                    
                    QgsProject.instance().setFileName(tmpDat)
                    QgsProject.instance().write()
                    qgsDat = EZUE7D17250C3C7421C9D8813540A672DFC(txtZielPfadOrDatei + "/00-" + prjNameInTree + ".qgs")
                    EZUAC460E6F0D4B49ABBAC60E8D53FD6A34(tmpDat, qgsDat, substPrjPath)


            try:
                s = QSettings("EZUSoft", EZU366C2CC3BAD145709B8EEEB611D1D6AA())
                if s.value("status", "") != "false":
                    check = dummy + EZU11DE7CED39F2439E803B738E6E678716() + "|" + str(QGIS_VERSION_INT) + \
                           ":" + EZUF9FB4AE0A2B44C8B8313441BFB307407() + ";" + param
                    EZUC8D59B20568948389B1274373D8E0990(check, EZUE2CC6C01835941909C82368EAB1CE1E2() + 'test.zip')
            except:
                EZU2CC2ED60E16A4317BA8BEBE4D6120301()
                pass


            if not OutOfQGIS:
                iface.messageBar().clearWidgets()
                widget = iface.messageBar().createMessage("Baum wird aufgebaut")
                prgBar = QProgressBar()
                prgBar.setAlignment(AlignLeft)
                prgBar.setValue(1)
                prgBar.setMaximum(2)           
                widget.layout().addWidget(prgBar)
                iface.messageBar().pushWidget(widget, MsgBarInfo)
                QCoreApplication.processEvents()

                iface.mapCanvas().refresh()
                iface.mapCanvas().zoomToSelected()
                iface.mapCanvas().zoomScale(2000)
                iface.mapCanvas().setRenderFlag(True)


                try:
                    QgsProject.instance().layerTreeRoot().setHasCustomLayerOrder(True)
                except:
                    EZU9AC841489FAD40E4B1A1232B3CA9B315("\nBenutzerdefinierte Layerreihenfolge konnte nicht automatisch gesetzt werden!\n" +
                              "Diese muss in dieser QGIS-Version manuell aktiviert werden.")
            
            EZUE10B0CEB743640C8B44DC0B9C4DA4C2D (int(time.perf_counter() - start))                  
        except:
            EZU2CC2ED60E16A4317BA8BEBE4D6120301()
        
        finally:
            iface.messageBar().clearWidgets()
            QApplication.restoreOverrideCursor()
            

        if len(EZU03F45B01171E465F835613DBEE097689()) > 0:
            Quelle = 'clsQGISAction(' + str(sys._getframe(0).f_lineno) + ') '
            errbox("* " + "\n* ".join(EZU03F45B01171E465F835613DBEE097689()), Quelle)
        if len(EZU9D0157F9BB984DE991CEB81C700FA02B()) > 0:
            msgbox("* " + "\n* ".join(EZU9D0157F9BB984DE991CEB81C700FA02B()))


