# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CadastralDivisions
                                 A QGIS plugin
 Cadastral Divisions parcels by line
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-12-01
        copyright            : (C) 2020 by Giulio Fattori
        email                : giulio.fattori@tin.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Giulio Fattori'
__date__ = '2020-12-01'
__copyright__ = '(C) 2020 by Giulio Fattori'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from PyQt5.QtCore import QCoreApplication, QVariant
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsFeature,
                       QgsWkbTypes,
                       QgsField,
                       QgsProcessingParameterBoolean,
                       QgsProcessingParameterNumber,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink)

import processing
import datetime
import math
import sys

#questo per l'icona dell'algoritmo di processing
import os
import inspect
from qgis.PyQt.QtGui import QIcon
cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

#questo per la traduzione
from qgis.PyQt.QtCore import QSettings
settings = QSettings()
if settings.value('locale/userLocale')[0:2] == 'it':
    Help_0 = "Fraziona il poligono interessato in parti in funzione di una linea<br>\
        Produce un nuovo layer denominato 'Fraz_' seguito da data e ora\n\
        <h3 style='color:blue'>Parametri</h3>\
        <ul>\
        <li>vettore poligonale contenente gli <b>elementi da frazionare</b></li>\
        <li>vettore lineare contenente la <b>linea dividente</b></li>\
        <li><b>denominatore frazione o numero parti uguali <font color='green'>[opz 2]</font></b></li>\
        </ul>\
        <h3 style='color:green'>Opzioni</h3>\
        <ol>\
        <li>taglio con linea posizionata manualmente</li>\
        <li>frazionamento in n parti eguali</li>\
        <li>superficie da ottenere (in alternativa alla parte/i)</li>\
        <li>inversione ordine delle parti</li>\
        </ol>\
        <h4 style='color:red'>RISULTATO IMPREVEDIBILE PER POLIGONI CONCAVI</h4>\n\
        <h4 style='color:black'>Per ulteriori informazioni</h4>\
        <h5 style='color:blue'><a href='https://github.com/Korto19/Cadastral_Divisions#frazionamenti-cadastral-divisions'>https://github.com/Korto19/Cadastral_Divisions#frazionamenti-cadastral-divisions</a></h5>"
    desc_0 = 'Frazionamenti Catastali'
    desc_1 = 'Vettore poligoni' 
    desc_2 = 'Vettore linea dividente'
    desc_3 = 'Taglio con dividente posizionata manualmente'
    desc_4 = 'Denominatore frazione o 1/n parte della superficie'
    desc_5 = 'Frazionamento in parti eguali'
    desc_6 = 'Superficie da ottenere in alternativa alla frazione'
    desc_7 = 'Inverte ordine delle parti rispetto alla dividente Up/Dn - Sx/dx'
    desc_8 = 'Fraz_'
    field_1 = 'Fraz_sub'
    field_2 = 'Fraz_part'
    field_3 = 'Fraz_area'
    msg_1 = "1 !! LA LINEA TOCCA MA NON INTERSECA IL POLIGONO !!"
    msg_2 = "2 !! LA LINEA TOCCA MA NON INTERSECA IL POLIGONO !!"
    msg_3 = "!!  LA LINEA NON INTERSECA IL POLIGONO !!"
    msg_4 = "PARTE MAGGIORE DELL'INTERO"
    feed_1 = ' tagli --- residuo = '
    feed_2 = 'residuo = '
    feed_3 = 'Taglio semplice'
    feed_4 = 'Taglio a metà'
    feed_5 = 'Taglio con area obiettivo'
    feed_6 = 'Taglio 1/'
    feed_7 = ' e '
    feed_8 = 'Obiettivo tagli n 1/n'
    feed_9 = 'parti '
elif settings.value('locale/userLocale')[0:2] in ('es','ca'):
    Help_0 = "Divide el polígono en partes<br> La orientación de corte está definida por una línea<br>\
        Genera una nueva capa llamada 'Fraz_' seguida de fecha y hora\n\
        <h3 style='color:blue'><strong>Parámetros</h3>\
        <ul>\
        <li>capa polígonal que contiene los <b>elementos a fraccionar</b></li>\
        <li>capa lineal que contiene <b>la línea de orientación del corte</b></li>\
        <li><b>Denominador fracción o número de partes iguales <font color='green'>[opc 2]</font></b></li>\
        </ul>\
        <h3 style='color:green'><strong>Opciones</h3>\
        <ol>\
        <li>corte con línea posicionada manualmente</li>\
        <li>fraccionamiento en partes iguales</li>\
        <li>superficie que debe obtenerse (como alternativa a la parte/s)</li>\
        <li>inversión del orden de las partes</li>\
        </ol>\
        <h4 style='color:red'>RESULTADO IMPREDECIBLE PARA POLIGONOS CONCAVOS</h4>\
        <h4 style='color:black'>Para mas información:</h4>\
        <h5 style='color:blue'><a href='https://github.com/Korto19/Cadastral_Divisions#frazionamenti-cadastral-divisions'>https://github.com/Korto19/Cadastral_Divisions#frazionamenti-cadastral-divisions</a></h5>"
    desc_0 = 'Fraccionamiento catastral' 
    desc_1 = 'Capa polígonal de entrada'
    desc_2 = 'Capa lineal de entrada'
    desc_3 = 'Corta con la línea posicionada manualmente' 
    desc_4 = 'Denominador fracción o 1/n partes del área' 
    desc_5 = 'Fracciona en partes iguales' 
    desc_6 = 'Superficie que debe obtenerse como alternativa a la fracción' 
    desc_7 = 'Invierte las partes respecto a la línea divisora Up/Dn - Mx/Dx' 
    desc_8 = 'Fract_'
    field_1 = 'Fract_sub'
    field_2 = 'Fract_part'
    field_3 = 'Fract_area'
    msg_1 = "1 !! LA LÍNEA TOCA PERO NO CRUZA EL POLÍGONO !!"
    msg_2 = "2 !! LA LÍNEA TOCA PERO NO CRUZA EL POLÍGONO !!"
    msg_3 = "!! LA LÍNEA NO CRUZA EL POLÍGONO !!"
    msg_4 = "LA MAYOR PARTE"
    feed_1 = ' cortados --- residuo = '
    feed_2 = 'residuo = ' 
    feed_3 = 'Recorte simple'
    feed_4 = 'Recorte por la mitad'
    feed_5 = 'Recorta con el área especificada' 
    feed_6 = 'Recorte 1/'
    feed_7 = ' y '
    feed_8 = 'Recortes determinados n 1/n'
    feed_9 = 'partes '
else:
    Help_0 = "Divide the polygon into parts<br> The cutting orientation is defined by a line<br>\
            Produces a new layer named 'Fraz_' followed by date and time\n\
            <h3 style='color:blue'><strong>Parameters</h3>\
            <ul>\
            <li>polygonal layer containing <b>elements to split</b></li>\
            <li>linear layer containing the <b>cutting orientation line</b></li>\
            <li><b>fraction denominator or number of egual parts <font color='green'>[opt 2]</font></b> of target area</li>\
            </ul>\
            <h3 style='color:green'><strong>Options</h3>\
            <ol>\
            <li>cut along line positioned manually</li>\
            <li>split into n equal parts</li>\
            <li>surface area to be obtained (alternative to the part/s)</li>\
            <li>reversal order of parts</li>\
            </ol>\
            <h4 style='color:red'>UNPREDICTABLE RESULT FOR CONCAVE POLYGONS</h4>\
            <h4 style='color:black'>For more information:</h4>\
            <h5 style='color:blue'><a href='https://github.com/Korto19/Cadastral_Divisions#frazionamenti-cadastral-divisions'>https://github.com/Korto19/Cadastral_Divisions#frazionamenti-cadastral-divisions</a></h5>"
    desc_0 = 'Cadastral Divisions'
    desc_1 = 'Input Poly layer'
    desc_2 = 'Input Line layer'
    desc_3 = 'Split with divider manually positioned'
    desc_4 = 'Denominator fraction or 1/n parts of the area'
    desc_5 = 'Splitting into equal parts'
    desc_6 = 'Surface area to be obtained as an alternative to the fraction'
    desc_7 = 'Invert parts respect to the divider line Up/Dn - L/R'
    desc_8 = 'Fract_'
    field_1 = 'Fract_sub'
    field_2 = 'Fract_part'
    field_3 = 'Fract_area'
    msg_1 = "1 !! LINE TOUCH BUT NOT INTERSECTS POLY !!"
    msg_2 = "2 !! LINE TOUCH BUT NOT INTERSECTS POLY !!"
    msg_3 = "!! LINE NOT INTERSECTS POLY !!"
    msg_4 = "MAJOR PART OF THE WHOLE"
    feed_1 = ' cuts --- residue = '
    feed_2 = 'residue = '
    feed_3 = 'Trim Direct'
    feed_4 = 'Trim Fifty Fifty'
    feed_5 = 'Trim Target area'
    feed_6 = 'Trim Target 1/'
    feed_7 = ' and '
    feed_8 = 'Target n 1/n Trim'
    feed_9 = 'parts ' 


class  CadastralDivisionsAlgorithm(QgsProcessingAlgorithm):
    """
    Algorithm that fractions a poligon in n parts.
    """
    INPUTP = 'INPUTP'       #layer poligonale con la particella da tagliare
    INPUTL = 'INPUTL'       #layer lineare con una sola linea di taglio
    INPUTA = 'INPUTA'       #numero di parti
    INPUTS = 'INPUTS'       #superficie target
    INPUTV = 'INPUTV'       #verso relativamente alla linea
    INPUTT = 'INPUTT'       #taglio diretto senza calcoli
    INPUTN = 'INPUTN'       #suddivisione nelle n parti per n > 2
    
    OUTPUT = 'OUTPUT'

    def tr(self, string):
        """
        Returns a translatable string with the self.tr() function.
        """
        return QCoreApplication.translate('Processing', string)
    
    #icona dell'algoritmo di processing
    def icon(self):
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'icon.png')))
        return icon 
        
    def createInstance(self):
        return  CadastralDivisionsAlgorithm()

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return desc_0

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """ 
        return self.tr(desc_0)

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def shortHelpString(self):
        """
        Returns a localised short helper string for the algorithm. This string
        should provide a basic description about what the algorithm does and the
        parameters and outputs associated with it..
        """
        header = '''
                    <img src="'''+ os.path.join(os.path.join(cmd_folder, 'icon.png')) + '''" width="50" height="50" style="float:right">
        '''
        return self.tr(header + Help_0)
    
    def initAlgorithm(self, config=None):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """
        # We add the polygonal input vector features source
        #QgsProcessingFeatureSourceDefinition 
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUTP,
                self.tr(desc_1),
                [QgsProcessing.TypeVectorPolygon]
            )
        )

        # We add the line input vector features source
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUTL,
                self.tr(desc_2),
                [QgsProcessing.TypeVectorLine]
            )
        )
        
        #taglio diretto
        INPUTT = QgsProcessingParameterBoolean(
            self.INPUTT,
            self.tr(desc_3), 0
        )
        #INPUTT.setFlags(INPUTT.flags())# | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(INPUTT)
        
        #We add the number of parcels
        self.addParameter(
            QgsProcessingParameterNumber(
                self.INPUTA,
                self.tr(desc_4),
                QgsProcessingParameterNumber.Integer,
                2, False, 2
            )
        )
        
        #Numero parti se > 2
        INPUTN = QgsProcessingParameterBoolean(
            self.INPUTN,
            self.tr(desc_5), 0
        )
        #INPUTN.setFlags(INPUTN.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(INPUTN)
        
        #We add the superficie target
        self.addParameter(
            QgsProcessingParameterNumber(
                self.INPUTS,
                self.tr(desc_6),
                QgsProcessingParameterNumber.Double,
                0, False, 0
            )
        )
        
        #inversione taglio se occorresse
        INPUTV = QgsProcessingParameterBoolean(
            self.INPUTV,
            self.tr(desc_7), 0
        )
        #INPUTV.setFlags(INPUTV.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(INPUTV)
        
        # We add a feature sink in which to store our processed features (this usually 
        # takes the form of a newly created vector layer when the algorithm is run in QGIS)
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr(desc_8 + str((datetime.datetime.now().strftime("%d-%m-%Y %H:%M:%S"))))
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        sourceP = self.parameterAsSource(
            parameters,
            self.INPUTP,
            context)
        
        sourceL = self.parameterAsSource(
            parameters,
            self.INPUTL,
            context)
            
        parti = self.parameterAsDouble(
            parameters,
            self.INPUTA,
            context)
            
        sup_target = self.parameterAsDouble(
            parameters,
            self.INPUTS,
            context)
            
        frazioni = self.parameterAsBoolean(
            parameters,
            self.INPUTN,
            context)
        
        direct = self.parameterAsBoolean(
            parameters,
            self.INPUTT,
            context)
        
        verso = self.parameterAsBoolean(
            parameters,
            self.INPUTV,
            context)
        
        
        fields = sourceP.fields()
        fields.append(QgsField(field_1, QVariant.String))
        fields.append(QgsField(field_2, QVariant.String))
        fields.append(QgsField(field_3, QVariant.Double))

        
        (sink, dest_id) = self.parameterAsSink(
            parameters,
            self.OUTPUT,
            context, fields, QgsWkbTypes.Polygon, sourceP.sourceCrs()
        )
        
        def extend_move_line(feat_L, feat_P):
            """input 2 feature output 1 feature"""
            """estende la linea alla dimensione della diagonale dell'estensione del poligono"""
            
            xmin = feat_P.geometry().boundingBox().xMinimum()
            xmax = feat_P.geometry().boundingBox().xMaximum()
            ymin = feat_P.geometry().boundingBox().yMinimum()
            ymax = feat_P.geometry().boundingBox().yMaximum()
            l_p_diag = math.sqrt((xmin - xmax)**2 + (ymin - ymax)**2)
            delta = (l_p_diag - feat_L.geometry().length())
            feat_L.setGeometry(feat_L.geometry().extendLine(delta,delta))
            
            """sposta il centroide della linea sul centroide del poligono"""
            xp = feat_P.geometry().centroid().asPoint().x()
            yp = feat_P.geometry().centroid().asPoint().y()
            xl = feat_L.geometry().centroid().asPoint().x()
            yl = feat_L.geometry().centroid().asPoint().y()
            feat_t = feat_L.geometry()
            feat_t.translate(xp - xl,yp - yl)
            feat_L.setGeometry(feat_t)
            
            return feat_L
            
            
        def trim_poly_by_line(feat_L, feat_P, verso):
            """ trim the polygon by line and get subpolygon area """
            """first max second min"""
            
            if feat_L.geometry().intersects(feat_P.geometry()):
                success, splits, topo = feat_P.geometry().splitGeometry(feat_L.geometry().asPolyline(), True)
                if success == 0:
                    risultato = QgsFeature()
                    risultato.setGeometry(splits[0])
                else:
                    sys.exit(msg_1)
                
                feat_r = feat_L.geometry()
                feat_r.rotate(180,feat_r.centroid().asPoint())
                
                success, splits, topo = feat_P.geometry().splitGeometry(feat_r.asPolyline(), True)
                if success == 0:
                    risultato1 = QgsFeature()
                    risultato1.setGeometry(splits[0])
                else:
                    sys.exit(msg_2)
                
            else:
                sys.exit(msg_3)
            
            if risultato.geometry().area() >= risultato1.geometry().area():
                smax = risultato
                smin = risultato1
            else:
                smax = risultato1
                smin = risultato
            
            rlist = []
            rlist.extend([smax, smax.geometry().area(), smax.geometry().centroid().asPoint()])
            rlist.extend([smin, smin.geometry().area(), smin.geometry().centroid().asPoint()])
            
            return rlist
            
            
        def bisezione(feat_L, feat_P, parti, decimali, val_prec, iterazioni, verso):
            
            area_mappale = feat_P.geometry().area()            
            area_target = area_mappale / 2
            
            rlist = trim_poly_by_line(feat_L, feat_P, verso)
            residuo = round((rlist[1] - area_target), int(decimali))
          
            sign = lambda a: (a>0) - (a<0)
            n = 0
            k = 10
            while abs(residuo) >= val_prec and n < iterazioni: 
                if residuo > 0:
                    #sign = lambda a: (a>0) - (a<0)
                    sx = (rlist[2].x()-feat_L.geometry().centroid().asPoint().x())
                    d_x = sign(sx)/k
                    sy = (rlist[2].y()-feat_L.geometry().centroid().asPoint().y())
                    d_y = sign (sy)/k
                else:
                    #sign = lambda a: (a>0) - (a<0)
                    sx = (rlist[5].x()-feat_L.geometry().centroid().asPoint().x())
                    d_x = sign(sx)/k
                    sy = (rlist[5].y()-feat_L.geometry().centroid().asPoint().y())
                    d_y = sign (sy)/k
                
                #sposto la linea
                feat_t = feat_L.geometry()
                feat_t.translate(d_x, d_y)
                feat_L.setGeometry(feat_t)
                
                #taglio e calcolo residuo
                residuo_p = residuo
                rlist = trim_poly_by_line(feat_L, feat_P, verso)
                residuo = round((rlist[1] - area_target), int(decimali))
                if residuo > residuo_p:
                    k *=10
                n += 1

            
            if n < iterazioni:
                feedback.pushInfo(str(n) + feed_1 + str(round(residuo,5)) + '\n' )
            else:
                feedback.pushInfo(feed_2 + str(round(residuo,5)) + '\n' )
            return
          
        
        
        def nnsezione(feat_L, feat_P, parti, decimali, val_prec, iterazioni, verso, sup_target):
            #feedback.pushInfo(str(sup_target))
            area_mappale = feat_P.geometry().area()
            
            if sup_target != 0:
                if area_mappale > sup_target:
                    if sup_target > area_mappale / 2:
                        sup_target = area_mappale - sup_target
                    parti = area_mappale / sup_target
                    area_target = sup_target
                    feedback.pushInfo(feed_9 + str(format(1/parti,'.3%')))
                else:
                    sys.exit(msg_4)
            else:
                area_target = area_mappale / parti 
                feedback.pushInfo(feed_9 + str(format(1/parti,'.3%')))
            
            rlist = trim_poly_by_line(feat_L, feat_P, verso)
            residuo = round((rlist[1] - area_target), int(decimali))
            
            #centroide iniziale linea
            xl0 = feat_L.geometry().centroid().asPoint().x()
            yl0 = feat_L.geometry().centroid().asPoint().y()
            
            #inversione delle parti
            if verso:
                pte = 2 
            else:
                pte = 5
            #centroide iniziale parte scelta
            xc0 = xlf = rlist[pte].x() 
            yc0 = ylf = rlist[pte].y()
            
            n = 0
            while residuo > 0:
                #memorizzo il centroide della linea
                xl0 = feat_L.geometry().centroid().asPoint().x()
                yl0 = feat_L.geometry().centroid().asPoint().y()
                #calcolo spostamento sul centroide della parte
                d_x = (xc0 - feat_L.geometry().centroid().asPoint().x())/2
                d_y = (yc0 - feat_L.geometry().centroid().asPoint().y())/2
                #sposto linea sul centroide
                feat_t = feat_L.geometry()
                feat_t.translate(d_x, d_y)
                feat_L.setGeometry(feat_t)
                #nuovo taglio con linea sul centroide
                rlist = trim_poly_by_line(feat_L, feat_P, verso)
                #nuovo centoide parte minore
                xc0 = rlist[5].x()
                yc0 = rlist[5].y()
                #calcolo residuo
                residuo = round((rlist[4] - area_target), int(decimali))
                #memorizzo posizione finale centroide linea
                xlf = feat_L.geometry().centroid().asPoint().x()
                ylf = feat_L.geometry().centroid().asPoint().y()

                n += 1
            #print('----------------------------------------------------')       
            
            n = 0
            while abs(residuo) >= val_prec and n < iterazioni: 
                if residuo < 0:
                    #memorizzo posizione finale centroide linea
                    xlf = feat_L.geometry().centroid().asPoint().x()
                    ylf = feat_L.geometry().centroid().asPoint().y()
                    #calcolo spostamento
                    d_x = (xl0 - xlf)/2
                    d_y = (yl0 - ylf)/2
          
                else:
                    #memorizzo posizione finale centroide linea
                    xl0 = feat_L.geometry().centroid().asPoint().x()
                    yl0 = feat_L.geometry().centroid().asPoint().y()      
                    #calcolo spostamento
                    d_x = (xlf - xl0)/2
                    d_y = (ylf - yl0)/2
                
                #sposto la linea
                feat_t = feat_L.geometry()
                feat_t.translate(d_x, d_y)
                feat_L.setGeometry(feat_t)
                    
                #taglio e calcolo residuo
                rlist = trim_poly_by_line(feat_L, feat_P, verso)
                residuo = round((rlist[4] - area_target), int(decimali)) 
                n += 1
                
            if n < iterazioni:
                feedback.pushInfo(str(n) + feed_1 + str(round(residuo,5)) + '\n' )
            else:
                feedback.pushInfo(feed_2 + str(round(residuo,5)) + '\n' )
            return rlist
        
                
        #------------------ PARAMETRI ELABORAZIONE ------------------ 
        str_decimali = '.4f'
        decimali = 5
        val_prec = 0.000001
        iterazioni = 200
        #------------------ PARAMETRI ELABORAZIONE ------------------ 
        
        for f in sourceP.getFeatures():
            mappale = f
            area_mappale = f.geometry().area()
            
        for f in sourceL.getFeatures():
            dividente = f
         
        if not frazioni or ( frazioni and parti==2):
            if direct:
                feedback.pushInfo(feed_3)
                rlist = trim_poly_by_line(dividente, mappale, verso) 
            elif parti == 2 and sup_target == 0:
                feedback.pushInfo(feed_4)
                dividente = extend_move_line(dividente, mappale)
                bisezione(dividente, mappale, parti, decimali, val_prec, iterazioni, verso)
                rlist = trim_poly_by_line(dividente, mappale, verso)
            elif sup_target != 0:
                feedback.pushInfo(feed_5)
                dividente = extend_move_line(dividente, mappale)
                rlist = nnsezione(dividente, mappale, parti, decimali, val_prec, iterazioni, verso, sup_target)
                rlist = trim_poly_by_line(dividente, mappale, verso)
            else:
                feedback.pushInfo(feed_6 + str(int(parti)) + feed_7 + str(int(parti-1)) + '/' + str(int(parti)))
                dividente = extend_move_line(dividente, mappale)
                rlist = nnsezione(dividente, mappale, parti, decimali, val_prec, iterazioni, verso, sup_target)
                rlist = trim_poly_by_line(dividente, mappale, verso)
                
        else:
            feedback.pushInfo(feed_8)
            while parti > 2:
                feedback.pushInfo(str(parti))
                dividente = extend_move_line(dividente, mappale)
                rlist = nnsezione(dividente, mappale, parti, decimali, val_prec, iterazioni, verso, sup_target)
                for f in sourceP.getFeatures():
                    new_feature = QgsFeature()
                    new_feature.setGeometry(rlist[3].geometry())
                    new_f = f.attributes()
                    new_f.append('sub '+ str(int(parti)))
                    new_f.append(format(rlist[4]/area_mappale,'.2%'))
                    new_f.append(format(rlist[4],str_decimali))
                    new_feature.setAttributes(new_f)
                    sink.addFeature(new_feature, QgsFeatureSink.FastInsert)
                mappale = rlist[0]
                parti -= 1
            
            feedback.pushInfo('2.0')
            
            dividente = extend_move_line(dividente, mappale)
            rlist = bisezione(dividente, mappale, parti, decimali, val_prec, iterazioni, verso)
            rlist = trim_poly_by_line(dividente, mappale, verso)
            
        for i in range(0,4,3):
            for f in sourceP.getFeatures():
                new_feature = QgsFeature()
                new_feature.setGeometry(rlist[i].geometry())
                new_f = f.attributes()
                new_f.append('sub '+ str(int(i/3+1)))
                new_f.append(format(rlist[i+1]/area_mappale,'.2%'))
                new_f.append(format(rlist[i+1],str_decimali))
                new_feature.setAttributes(new_f)
                sink.addFeature(new_feature, QgsFeatureSink.FastInsert)
                p = parti - 1
                
        return {self.OUTPUT: dest_id}