# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CzmlMovingObjects
                                 A QGIS plugin
 This plugin creates CZML files for moving objects described as points
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-10-04
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Murat Kendir
        email                : muratkendir@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QVariant, QDateTime
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QErrorMessage
from qgis.core import QgsProject, Qgis, QgsCoordinateTransform, QgsCoordinateReferenceSystem, QgsVectorLayerUtils, QgsFeature, QgsGeometry, QgsPoint, QgsTileMatrix, QgsWkbTypes, QgsTileRange, QgsVectorLayer, QgsField, QgsRectangle,  QgsApplication, QgsProcessingFeedback, QgsFeatureRequest, QgsExpression

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .CzmlMovingObjects_dialog import CzmlMovingObjectsDialog
import os

# Added
from qgis.utils import *
import sys
from qgis import processing
from pytz import timezone
import pytz
import pyproj
import json
from urllib import parse
from .Metadata import Metadata
from .Vehicle import Vehicle
import math

class CzmlMovingObjects:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CzmlMovingObjects_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CZML Moving Objects')

        self.scenariosDict = {
            1:"Single CZML File"
            ,2:"Separate CZML files for every moving object"
            ,3:"CZML files within XYZ Tiles"
            #,4:"CZML files in Time Slices (T Tiles)"
            #,5:"CZML Files within XYZ Tiles in Time Slices (XYZ+T)"
            }

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CzmlMovingObjects', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToWebMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/CzmlMovingObjects/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Points to CZML Moving Objects'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginWebMenu(
                self.tr(u'&CZML Moving Objects'),
                action)
            self.iface.removeToolBarIcon(action)
    
    # Ask all available elements of an object in python terminal:

    def whoAreYou(self, objectName):
        print('Type: ', type(objectName), '\n')
        print('Directory: ', dir(objectName), '\n')
        print('Self: ', objectName, '\n')

    # Following 2 functions taken from: https://wiki.openstreetmap.org/wiki/Slippy_map_tilenames#Lon./lat._to_tile_numbers_2
    def deg2num(self, lat_deg, lon_deg, zoom):
        lat_rad = math.radians(lat_deg)
        n = 2.0 ** zoom
        xtile = int((lon_deg + 180.0) / 360.0 * n)
        ytile = int((1.0 - math.asinh(math.tan(lat_rad)) / math.pi) / 2.0 * n)
        return (xtile, ytile)

    def num2deg(self, xtile, ytile, zoom):
        n = 2.0 ** zoom
        lon_deg = xtile / n * 360.0 - 180.0
        lat_rad = math.atan(math.sinh(math.pi * (1 - 2 * ytile / n)))
        lat_deg = math.degrees(lat_rad)
        return (lon_deg, lat_deg)

    #MK Get point based vector layers with names to fill related form elements
    def getPointVectorLayers(self):
        currentLayers = QgsProject.instance().mapLayers()
        pointLayers = []
        pointLayerNames = []
        for layer in currentLayers:
            if currentLayers.get(layer).type().value == 0 and currentLayers.get(layer).geometryType() == 0:
                pointLayers.append(layer)
                pointLayerNames.append(currentLayers.get(layer).name())
        return pointLayerNames

    def fillComboBoxShowAs(self):
        showAsOptions = ('Select an option','Point')
        self.dlg.comboBoxShowAs.clear()
        self.dlg.comboBoxShowAs.addItems(showAsOptions)

    def switchComboBoxSelectScenario(self, num):
        return self.scenarioDict.get(num, "invalid input!")
        
    def fillComboBoxSelectScenario(self):
        self.dlg.comboBoxSelectScenario.clear()
        self.dlg.comboBoxSelectScenario.addItem('Select a scenario...')
        self.dlg.comboBoxSelectScenario.addItems(self.scenariosDict.values())

    #MK #Read layer attributes and populate attribute comboxes with them.
    def fill_group_by_combobox(self):
        currentLayers = QgsProject.instance().mapLayers()
        if self.dlg.select_layer_comboBox.currentIndex() != 0:
            for layer in currentLayers:
                if currentLayers.get(layer).name() == self.dlg.select_layer_comboBox.currentText():
                    selectedLayer = currentLayers.get(layer)
                    #print(selectedLayer.attributeAliases())
                    self.dlg.comboBoxGroupBy.clear()
                    self.dlg.comboBoxGroupBy.addItem('Not Selected')
                    self.dlg.comboBoxGroupBy.addItems(selectedLayer.attributeAliases())
                    self.dlg.comboBoxSeconds.clear()
                    self.dlg.comboBoxSeconds.addItem('Not Selected')
                    self.dlg.comboBoxSeconds.addItems(selectedLayer.attributeAliases())
                    self.dlg.comboBoxEpoch.clear()
                    self.dlg.comboBoxEpoch.addItem('Not Selected')
                    self.dlg.comboBoxEpoch.addItems(selectedLayer.attributeAliases())
                    self.dlg.comboBoxHeightValue.clear()
                    self.dlg.comboBoxHeightValue.addItem('Not Selected')
                    self.dlg.comboBoxHeightValue.addItems(selectedLayer.attributeAliases())
        else:
            print('Please select a valid layer.')

    #MK Selecting filename to export czml file
    def browseForFileName(self):
        fileName = QFileDialog.getSaveFileName(self.dlg,"Select output file ","", '*.czml')
        fileURL = fileName[0]
        fileExtension = fileURL[-5:] 
        if fileExtension == '.czml' or fileExtension == '.CZML':
            checkedFileURL = fileURL
        else:
            checkedFileURL = fileURL + '.czml'
        #self.dlg.browse_lineEdit.setText(checkedFileURL)
        self.dlg.lineEditFileName.setText(checkedFileURL)

    def selectFolder(self):
        folderName = QFileDialog.getExistingDirectory(self.dlg, "Select a folder", "", QFileDialog.ShowDirsOnly)
        self.dlg.lineEditFolderName.setText(folderName)

    def checkScenario(self):
        if self.dlg.comboBoxSelectScenario.currentIndex()==1:
            print('Single CZML File --> option selected.')
             # Enable 
            self.dlg.groupBoxGeneralSettings.setEnabled(1)
            self.dlg.groupBoxSingleOutput.setEnabled(1)
            # Disable
            self.dlg.groupBoxGroupBy.setDisabled(1)
            self.dlg.groupBoxFolderOutput.setDisabled(1)
            self.dlg.groupBoxZLevel.setDisabled(1)
        elif self.dlg.comboBoxSelectScenario.currentIndex()==2:
            print('Separate CZML Files for every moving object --> option selected.')
            # Enable 
            self.dlg.groupBoxGeneralSettings.setEnabled(1)
            self.dlg.groupBoxGroupBy.setEnabled(1)
            self.dlg.groupBoxFolderOutput.setEnabled(1)
            # Disable
            self.dlg.groupBoxSingleOutput.setDisabled(1)
            self.dlg.groupBoxZLevel.setDisabled(1)
        elif self.dlg.comboBoxSelectScenario.currentIndex()==3:
            print('CZML Files within XYZ Tiles --> option selected.')
            # Enable
            self.dlg.groupBoxGeneralSettings.setEnabled(1)
            self.dlg.groupBoxFolderOutput.setEnabled(1)
            self.dlg.groupBoxZLevel.setEnabled(1)
            self.dlg.groupBoxGroupBy.setEnabled(1)
            # Disable
            self.dlg.groupBoxSingleOutput.setDisabled(1)
            

        #elif self.dlg.comboBoxSelectScenario.currentIndex()==4:
        #    print('Singular CZML Files in Time Slices --> option selected.')
        #elif self.dlg.comboBoxSelectScenario.currentIndex()==5:
        #    print('Separate CZML Files within XYZ Tiles in Time Slices --> option selected.')
        else:
            print('Oh no!')

    def checkClockButton(self):
        if self.dlg.radioButtonClockConf.isChecked():
            self.dlg.dateTimeEditClockCurrent.setEnabled(1)
            self.dlg.dateTimeEditClockBeginning.setEnabled(1)
            self.dlg.dateTimeEditClockEnd.setEnabled(1)
            self.dlg.lineEditClockMultiplier.setEnabled(1)
            self.dlg.comboBoxClockRange.setEnabled(1)
            self.dlg.comboBoxClockStep.setEnabled(1)
        else:
            self.dlg.dateTimeEditClockCurrent.setDisabled(1)
            self.dlg.dateTimeEditClockBeginning.setDisabled(1)
            self.dlg.dateTimeEditClockEnd.setDisabled(1)
            self.dlg.lineEditClockMultiplier.setDisabled(1)
            self.dlg.comboBoxClockRange.setDisabled(1)
            self.dlg.comboBoxClockStep.setDisabled(1)

    def disableGroupsAtStart(self):
        # Disable
        self.dlg.groupBoxGeneralSettings.setDisabled(1)
        self.dlg.groupBoxSingleOutput.setDisabled(1)
        self.dlg.groupBoxGroupBy.setDisabled(1)
        self.dlg.groupBoxZLevel.setDisabled(1)
        self.dlg.groupBoxFolderOutput.setDisabled(1)

    def checkPointData(self, selected_layer):
        self.whoAreYou(selected_layer)

    def getRectTile(self, x, y, zoom):
            xMin, yMax = self.num2deg( x, y , zoom)
            xMax, yMin = self.num2deg( x+1, y+1 , zoom)
            rect = QgsRectangle( xMin, yMin, xMax, yMax )
            return rect

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = CzmlMovingObjectsDialog()
            self.dlg.lineEditFileName.clear()
            self.dlg.browse_pushButton.clicked.connect(self.browseForFileName)
            self.dlg.pushButtonSelectFolder.clicked.connect(self.selectFolder)
        
        self.dlg.comboBoxTimeZone.clear()
        self.dlg.comboBoxTimeZone.addItems(pytz.all_timezones)
        #print(pytz.all_timezones)
        self.dlg.comboBoxTimeZone.setCurrentText('UTC')

        self.fillComboBoxSelectScenario()

        self.disableGroupsAtStart()

        #If Configure Cesium Clock radio button element selected, then activate clock parameters and get them.
        self.dlg.radioButtonClockConf.clicked.connect(self.checkClockButton)   

        #If Fanout Dataset radio button checked, then activate "Group By Attribute" dropdown menu.
        self.dlg.comboBoxSelectScenario.currentIndexChanged.connect(self.checkScenario)   

        #MK Populate Layers ComboBox with existed poitn based vector layers

        #MK Clear first point based layers combobox, then populate with point layers.
        self.dlg.select_layer_comboBox.clear()
        #MK Set a placeholder text for layer combobox
        self.dlg.select_layer_comboBox.addItem('Select a point layer')
        self.dlg.select_layer_comboBox.addItems(self.getPointVectorLayers())

        #Fill "Show As" combo bo with options.
        self.fillComboBoxShowAs()

        #MK Fill Group By Attributes Button
        self.dlg.refresh_attributes_pushButton.clicked.connect(self.fill_group_by_combobox)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Save File after <OK> clicked.
            fileURL = self.dlg.lineEditFileName.text()
            timeZone = timezone(self.dlg.comboBoxTimeZone.currentText())
            
            #Take CZML Clock time interval options
            if self.dlg.radioButtonClockConf.isChecked():
                selectedTimeZone = self.dlg.comboBoxTimeZone.currentText()
                
                selectedClockCurrent = self.dlg.dateTimeEditClockCurrent.dateTime()
                selectedClockCurrentLocal = timeZone.localize(selectedClockCurrent.toPyDateTime()).isoformat()
                selectedClockBeginning = self.dlg.dateTimeEditClockBeginning.dateTime()
                selectedClockBeginningLocal = timeZone.localize(selectedClockBeginning.toPyDateTime()).isoformat()
                selectedClockEnd = self.dlg.dateTimeEditClockEnd.dateTime()
                selectedClockEndLocal = timeZone.localize(selectedClockEnd.toPyDateTime()).isoformat()
                selectedClockMultiplier = self.dlg.lineEditClockMultiplier.text()
                selectedClockRange = self.dlg.comboBoxClockRange.currentText()
                selectedClockStep = self.dlg.comboBoxClockStep.currentText()


            #Take Selected layer from current QGIS canvas.
            currentLayers = QgsProject.instance().mapLayers()
            if self.dlg.select_layer_comboBox.currentIndex() != 0:
                for layer in currentLayers:
                    if currentLayers.get(layer).name() == self.dlg.select_layer_comboBox.currentText():
                        selectedLayer = currentLayers.get(layer)
            layerName = selectedLayer.name()
            
            if self.dlg.radioButtonClockConf.isChecked():
                documentClock = Metadata.Clock(selectedClockCurrentLocal, selectedClockBeginningLocal, selectedClockEndLocal, selectedClockMultiplier, selectedClockRange, selectedClockStep)
                documentMetadata = Metadata("1.0", "document", layerName, documentClock)
            else:
                documentMetadata = Metadata("1.0", "document", layerName)
                #print( documentMetadata.getMetaDict() )

            beginningLines ='[\n' +  json.dumps( documentMetadata.getMetaDict(), indent=4 )

            groupByAttribute = self.dlg.comboBoxGroupBy.currentText()
            secondsAttribute = self.dlg.comboBoxSeconds.currentText()
            epochAttribute = self.dlg.comboBoxEpoch.currentText()
            fanoutPrefix = self.dlg.lineEditFileNamePrefix.text()
            fanoutFolder = self.dlg.lineEditFolderName.text()
            
            if self.dlg.comboBoxSelectScenario.currentIndex()==1:
                exportedFile = open(fileURL, mode='w', encoding='utf-8')
                idn = 'Vehicle'
                positions = []
                transform2Cartesian = pyproj.Transformer.from_crs("EPSG:4326", "EPSG:4978", always_xy = True)
                for feature in selectedLayer.getFeatures():
                    point = feature.geometry().asPoint()
                    secondz = feature[secondsAttribute]
                    cartesianPoint = (transform2Cartesian.transform(point.x(), point.y(), 0))
                    positions.append(round(secondz,1))
                    positions.append(round(cartesianPoint[0],3))
                    positions.append(round(cartesianPoint[1],3))
                    positions.append(round(cartesianPoint[2],2))
                vehicleEpoch = next(selectedLayer.getFeatures())[epochAttribute]
                self.whoAreYou(vehicleEpoch)
                vehicleEpoch = timeZone.localize(vehicleEpoch.toPyDateTime()).isoformat()
                
                vehiclePosition = Vehicle.Position(positions, vehicleEpoch)
                if self.dlg.comboBoxShowAs.currentText() == 'Point':
                    vehiclePoint = Vehicle.Point()
                else: 
                    #Change here and add other options later
                    print('Since there is no other available option yet, please get by with point object!')
                    vehiclePoint = Vehicle.Point()
                vehicleData = Vehicle(idn, vehiclePosition, vehiclePoint)
                #print(vehicleData.getVehicleDict())
                featureLines = ',\n' + json.dumps( vehicleData.getVehicleDict(), indent=4 )
                wholeDocument = beginningLines + featureLines +'\n]\n'
                #print(wholeDocument)
                exportedFile.write(wholeDocument)
                exportedFile.close()
            elif self.dlg.comboBoxSelectScenario.currentIndex()==2 and groupByAttribute != 'Not Selected':
                list_of_values = QgsVectorLayerUtils.getValues(selectedLayer, groupByAttribute)[0]
                list_of_values = list(set(list_of_values))
                for vehicle in list_of_values:
                    quotedVehicle = parse.quote_plus(str(vehicle))
                    fileURL=fanoutFolder+os.path.sep+fanoutPrefix+quotedVehicle+'.czml'
                    exportedFile = open(fileURL, mode='w', encoding='utf-8')
                    idn = 'Vehicle'+str(vehicle)
                    positions = []
                    transform2Cartesian = pyproj.Transformer.from_crs("EPSG:4326", "EPSG:4978", always_xy = True)
                    filter_expression = "{} = '{}'".format(groupByAttribute, vehicle)
                    #print(filter_expression)
                    filtered_layer = selectedLayer.getFeatures(QgsFeatureRequest().setFilterExpression(filter_expression))
                    
                    for feature in filtered_layer:
                        point = feature.geometry().asPoint()
                        secondz = feature[secondsAttribute]
                        vehicleEpoch = feature[epochAttribute]
                        cartesianPoint = (transform2Cartesian.transform(point.x(), point.y(), 0))
                        positions.append(round(secondz,1))
                        positions.append(round(cartesianPoint[0],3))
                        positions.append(round(cartesianPoint[1],3))
                        positions.append(round(cartesianPoint[2],2))
                    #vehicleEpoch = next(filtered_layer)[epochAttribute]
                    vehicleEpoch = timeZone.localize(vehicleEpoch.toPyDateTime()).isoformat()
                    vehiclePosition = Vehicle.Position(positions, vehicleEpoch)
                    if self.dlg.comboBoxShowAs.currentText() == 'Point':
                        vehiclePoint = Vehicle.Point()
                    else: 
                        #Change here and add other options later
                        print('Since there is no other available option yet, please get by with point object!')
                        vehiclePoint = Vehicle.Point()
                    vehicleData = Vehicle(idn, vehiclePosition, vehiclePoint)
                    featureLines = ',\n' + json.dumps( vehicleData.getVehicleDict(), indent=4 )
                    wholeDocument = beginningLines + featureLines +'\n]\n'
                    #print(wholeDocument)
                    exportedFile.write(wholeDocument)
                    exportedFile.close()
            elif self.dlg.comboBoxSelectScenario.currentIndex()==3 and groupByAttribute != 'Not Selected':
                
                #fileURL=fanoutFolder+os.path.sep+'test_xyz'+'.czml'
                #exportedFile = open(fileURL, mode='w', encoding='utf-8')
                
                selectedZoomLevel = self.dlg.comboBoxSelectZLevel.currentText()
                
                #transform2Cartesian = pyproj.Transformer.from_crs("EPSG:4326", "EPSG:4978", always_xy = True)
                
                
                wktTypeOfLayer = ''

                # Add temporary tiles layer into canvas
                myUri = "polygon?crs=epsg:4326&field=column_x:integer&field=column_y:integer&field=zoom_level:integer"
                myTiles  = QgsVectorLayer(myUri, "Temporary Tiles", "memory")
                editMyTiles = myTiles.dataProvider()
                QgsProject.instance().addMapLayer(myTiles)

                # Add temporary linesZ layer into canvas
                myUriLinesZ = "linestring?crs=epsg:4326&field=name:string"
                myLinesZ = QgsVectorLayer(myUriLinesZ, "Temporary Lines with Z", "memory")
                editMyLinesZ = myLinesZ.dataProvider()
                QgsProject.instance().addMapLayer(myLinesZ)
                
                list_of_values2 = QgsVectorLayerUtils.getValues(selectedLayer, groupByAttribute)[0]
                list_of_values2 = list(set(list_of_values2))
                #print(list_of_values2)
                i=0
                for vehicle in list_of_values2:
                    idn = 'Vehicle' + str(vehicle)
                    pointsArrayZ = []
                    filter_expression = "{} = '{}'".format(groupByAttribute, vehicle)
                    #print(filter_expression)
                    filtered_layer = selectedLayer.getFeatures(QgsFeatureRequest().setFilterExpression(filter_expression))
                    # Convert points into linestringZ
                    for feature in filtered_layer:
                        pointWkt = feature.geometry().asWkt()
                        pointInstance = QgsPoint()
                        pointInstance.fromWkt(pointWkt)
                        wktTypeOfLayer = pointInstance.wktTypeStr()
                        pointsArrayZ.append(pointInstance)
                    # Set LineZ from points array and calculate BBOX
                    movingObjectAsLine = QgsFeature()
                    movingObjectAsLine.setGeometry(QgsGeometry.fromPolyline(pointsArrayZ))
                    #movingObjectBB = movingObjectAsLine.geometry().boundingBox()
                    # Add lineZ into layer
                    feature_name = 'LineZ'+str(i)
                    movingObjectAsLine.setAttributes([feature_name])
                    editMyLinesZ.addFeatures( [ movingObjectAsLine ] )
                    i+=1

                # Add temporary linesM layer into canvas
                myUriLinesM = "linestring?crs=epsg:4326&field=name:string"
                myLinesM = QgsVectorLayer(myUriLinesM, "Temporary Lines with M", "memory")
                editMyLinesM = myLinesM.dataProvider()
                QgsProject.instance().addMapLayer(myLinesM)

                j=0
                for vehicle in list_of_values2:
                    idn = 'Vehicle' + str(vehicle)
                    pointsArrayM = []
                    filter_expression = "{} = '{}'".format(groupByAttribute, vehicle)
                    #print(filter_expression)
                    filtered_layer = selectedLayer.getFeatures(QgsFeatureRequest().setFilterExpression(filter_expression))
                    # Convert points into linestringM
                    for feature in filtered_layer:
                        pointWkt = feature.geometry().asWkt()
                        pointInstance = QgsPoint()
                        pointInstance.fromWkt(pointWkt)
                        secondz = feature[secondsAttribute]
                        pointInstance.setZ(secondz)
                        #print(pointInstance, secondz)
                        pointsArrayM.append(pointInstance)
                    # Set LineM from points array and calculate BBOX
                    movingObjectAsLineM = QgsFeature()
                    movingObjectAsLineM.setGeometry(QgsGeometry.fromPolyline(pointsArrayM))
                    # Add lineZ into layer
                    feature_name = 'LineM'+str(i)
                    movingObjectAsLineM.setAttributes([feature_name])
                    editMyLinesM.addFeatures( [ movingObjectAsLineM ] )
                    j+=1
                #Calculate BBOX
                myLinesZ.commitChanges()
                #print(myLinesZ.extent())
                bbox_of_layer = myLinesZ.extent()
                #tileMinimum is equal to Top-Left Tile (cause tiling starts from top left)
                #tileMaximum is equal to Right-Bottom Tile
                tileMinimum = self.deg2num(bbox_of_layer.yMaximum(), bbox_of_layer.xMinimum(), int(selectedZoomLevel))
                tileMaximum = self.deg2num(bbox_of_layer.yMinimum(), bbox_of_layer.xMaximum(), int(selectedZoomLevel))
                #print(tileMinimum, tileMaximum, wktTypeOfLayer)
                print("xmin: {}, xmax: {}, ymin: {}, ymax {}".format(bbox_of_layer.xMinimum(), bbox_of_layer.xMaximum(), bbox_of_layer.yMinimum(), bbox_of_layer.yMaximum()) )
                columnNumber = (tileMaximum[0] - tileMinimum[0]) + 1
                rowNumber = (tileMaximum[1] - tileMinimum[1]) + 1
                #print(columnNumber, rowNumber)

                for i in range(columnNumber):
                    for j in range(rowNumber):
                        #print(i,j, tileMinimum[0]+i, tileMinimum[1]+j)
                        tempoTile = QgsFeature()
                        tempoRect = self.getRectTile(tileMinimum[0]+i, tileMinimum[1]+j, int(selectedZoomLevel))
                        tempoTile.setGeometry( QgsGeometry.fromRect(tempoRect) )
                        tempoTile.setAttributes([tileMinimum[0]+i,tileMinimum[1]+j,int(selectedZoomLevel)])
                        editMyTiles.addFeatures( [ tempoTile ] )
                        j +=1
                    i += 1

                #input_layer_z = myLinesZ.source()
                #input_layer_m = myLinesM.source()
                #overlay_layer = myTiles.source()
                
                params1 = { 'INPUT' : myLinesZ, 'OVERLAY' : myTiles, 'OUTPUT' : 'memory:LineZ'}
                result1 = processing.run("native:intersection", params1)
                cutted_lines_w_z = result1['OUTPUT']
                #QgsProject.instance().addMapLayer(cutted_lines_w_z)
                #output_layer_z = cutted_lines_w_z.source()
                cutted_lines_w_z.startEditing()
                cutted_lines_w_z.dataProvider().addAttributes([QgsField("order", QVariant.Int)])
                cutted_lines_w_z.updateFields()
                order_idx = cutted_lines_w_z.fields().indexOf("order")
                for ftr in cutted_lines_w_z.getFeatures():
                    ftr_id = ftr.id()
                    cutted_lines_w_z.changeAttributeValue(ftr_id,order_idx,ftr_id)
                cutted_lines_w_z.commitChanges()


                params2 = { 'INPUT' : myLinesM, 'OVERLAY' : myTiles, 'OUTPUT' : 'memory:LineM'}
                result2 = processing.run("native:intersection", params2)
                cutted_lines_w_m = result2['OUTPUT']
                #QgsProject.instance().addMapLayer(cutted_lines_w_m)
                #output_layer_m = cutted_lines_w_m.source()
                cutted_lines_w_m.startEditing()
                cutted_lines_w_m.dataProvider().addAttributes([QgsField("order", QVariant.Int)])
                cutted_lines_w_m.updateFields()
                order_idy = cutted_lines_w_m.fields().indexOf("order")
                for ftr in cutted_lines_w_m.getFeatures():
                    ftr_id = ftr.id()
                    cutted_lines_w_m.changeAttributeValue(ftr_id,order_idy,ftr_id)
                cutted_lines_w_m.commitChanges()

                params3 = { 'INPUT' : cutted_lines_w_z, 'OUTPUT' : 'memory:PointsZ'}
                result3 = processing.run("native:extractvertices", params3)
                points_w_z_values = result3['OUTPUT']
                #QgsProject.instance().addMapLayer(points_w_z_values)
                #output_layer_pz = points_w_z_values.source()
                points_w_z_values.startEditing()
                # Take the id numbers of automatically added columns and remove them by using their field id numbers
                vertex_part_idx = points_w_z_values.fields().indexOf("vertex_part")
                vertex_part_index_idx = points_w_z_values.fields().indexOf("vertex_part_index")
                distance_idx = points_w_z_values.fields().indexOf("distance")
                angle_idx = points_w_z_values.fields().indexOf("angle")
                points_w_z_values.deleteAttributes([vertex_part_idx, vertex_part_index_idx, distance_idx, angle_idx])
                points_w_z_values.commitChanges()

                params4 = { 'INPUT' : cutted_lines_w_m, 'OUTPUT' : 'memory:PointsM'}
                result4 = processing.run("native:extractvertices", params4)
                points_w_m_values = result4['OUTPUT']
                #QgsProject.instance().addMapLayer(points_w_m_values)
                #output_layer_pm = points_w_m_values.source()
                points_w_m_values.startEditing()
                # Take the id numbers of automatically added columns and remove them by using their field id numbers
                vertex_part_idx = points_w_m_values.fields().indexOf("vertex_part")
                vertex_part_index_idx = points_w_m_values.fields().indexOf("vertex_part_index")
                distance_idx = points_w_m_values.fields().indexOf("distance")
                angle_idx = points_w_m_values.fields().indexOf("angle")
                points_w_m_values.deleteAttributes([vertex_part_idx, vertex_part_index_idx, distance_idx, angle_idx])
                points_w_m_values.commitChanges()

                params5 = {'INPUT' : points_w_z_values, 'COLUMN_PREFIX' : 'derived_z_', 'OUTPUT' : 'memory:DerivedZ'}
                result5 = processing.run("native:extractzvalues", params5)
                points_w_derived_z_values = result5['OUTPUT']
                #QgsProject.instance().addMapLayer(points_w_derived_z_values)
                #output_layer_dpz = points_w_derived_z_values.source()
                points_w_derived_z_values.startEditing()
                points_w_derived_z_values.dataProvider().addAttributes([QgsField("join_constraint", QVariant.String)])
                points_w_derived_z_values.updateFields()
                join_constraint_idx = points_w_derived_z_values.fields().indexOf("join_constraint")
                for ftr in points_w_derived_z_values.getFeatures():
                    cnstrnt = "{}-{}-{}-{}-{}".format(ftr["column_x"], ftr["column_y"], ftr["zoom_level"], ftr["order"], ftr["vertex_index"])
                    #print(cnstrnt)
                    points_w_derived_z_values.changeAttributeValue(ftr.id(),join_constraint_idx,cnstrnt)
                points_w_derived_z_values.commitChanges()

                params6 = {'INPUT' : points_w_m_values, 'COLUMN_PREFIX' : 'derived_m_', 'OUTPUT' : 'memory:DerivedM'}
                result6 = processing.run("native:extractzvalues", params6)
                points_w_derived_m_values = result6['OUTPUT']
                #QgsProject.instance().addMapLayer(points_w_derived_m_values)
                #output_layer_dpm = points_w_derived_m_values.source()
                points_w_derived_m_values.startEditing()
                points_w_derived_m_values.dataProvider().addAttributes([QgsField("join_constraint", QVariant.String)])
                points_w_derived_m_values.updateFields()
                join_constraint_idx2 = points_w_derived_m_values.fields().indexOf("join_constraint")
                for ftr in points_w_derived_m_values.getFeatures():
                    cnstrnt = "{}-{}-{}-{}-{}".format(ftr["column_x"], ftr["column_y"], ftr["zoom_level"], ftr["order"], ftr["vertex_index"])
                    #print(cnstrnt)
                    points_w_derived_m_values.changeAttributeValue(ftr.id(),join_constraint_idx,cnstrnt)
                points_w_derived_m_values.commitChanges()

                jn = 'join_constraint'
                flds = ['derived_m_first']
                params7 = {'INPUT': points_w_derived_z_values, 'FIELD': jn, 'INPUT_2': points_w_derived_m_values, 'FIELD_2': jn, 'FIELDS_TO_COPY': flds, 'METHOD': 1, 'DISCARD_NONMATCHING': False, 'PREFIX':'', 'OUTPUT': 'memory:CombinedZM'}
                result7 = processing.run("native:joinattributestable", params7)
                layer_combinedZM = result7['OUTPUT']
                QgsProject.instance().addMapLayer(layer_combinedZM)
                
                #Start to deploy files
                
                for i in range(columnNumber):
                    path1 = fanoutFolder+os.path.sep+str(i)
                    if not os.path.exists(path1):
                        os.mkdir(path1)
                    for j in range(rowNumber):
                        #print(i,j,columnNumber,rowNumber)
                        path2 = path1+os.path.sep+str(j)
                        if not os.path.exists(path2):
                            os.mkdir(path2)
                        fileURL=path2+os.path.sep+'tile.czml'
                        exportedFile = open(fileURL, mode='w', encoding='utf-8')
                        transform2Cartesian = pyproj.Transformer.from_crs("EPSG:4326", "EPSG:4978", always_xy = True)

                        filter_expression = "column_x = {} AND column_y = {}".format(tileMinimum[0]+i, tileMinimum[1]+j)
                        filtered_layer = layer_combinedZM.getFeatures(QgsFeatureRequest().setFilterExpression(filter_expression))
                        
                        
                        feature_names_in_tile = set(())
                        for f in filtered_layer:
                            feature_names_in_tile.add(f["name"])
                        #print(i, j, feature_names_in_tile)
                        featureLines = ''
                        for veh in feature_names_in_tile:
                            idn2 = 'Vehicle_'+veh
                            positions = []
                            filter_expression2 = "column_x = {} AND column_y = {} AND name = '{}'".format(tileMinimum[0]+i, tileMinimum[1]+j,veh)
                            filtered_layer2 = layer_combinedZM.getFeatures(QgsFeatureRequest().setFilterExpression(filter_expression2))
                            #print(i,j,filter_expression2,veh)
                            
                            for ftr in filtered_layer2:
                                #print(ftr.attributes())
                                point = ftr.geometry().asPoint()
                                secondz = ftr['derived_m_first']
                                cartesianPoint = (transform2Cartesian.transform(point.x(), point.y(), 3))
                                positions.append(round(secondz,1))
                                positions.append(round(cartesianPoint[0],3))
                                positions.append(round(cartesianPoint[1],3))
                                positions.append(round(cartesianPoint[2],2))
                            vehicleEpoch = next(selectedLayer.getFeatures())[epochAttribute]
                            vehicleEpoch2 = timeZone.localize(vehicleEpoch.toPyDateTime()).isoformat()
                            vehiclePosition = Vehicle.Position(positions, vehicleEpoch2)
                            if self.dlg.comboBoxShowAs.currentText() == 'Point':
                                vehiclePoint = Vehicle.Point()
                            else: 
                                #Change here and add other options later
                                print('Since there is no other available option yet, please get by with point object!')
                                vehiclePoint = Vehicle.Point()
                            vehicleData = Vehicle(idn2, vehiclePosition, vehiclePoint)
                            featureLines = featureLines + ',\n' + json.dumps( vehicleData.getVehicleDict(), indent=4 )
                            #print(featureLines)
                        wholeDocument = beginningLines + featureLines +'\n]\n'
                        exportedFile.write(wholeDocument)
                        exportedFile.close()
                        j+=1
                        
                        #print(wholeDocument)
                        '''
                        for veh in list_of_values3:
                            idn = 'Vehicle'+veh
                            positions = []
                            for ftr in filtered_layer:
                                point = ftr.geometry().asPoint()
                                secondz = ftr['derived_m_first']
                                cartesianPoint = (transform2Cartesian.transform(point.x(), point.y(), 0))
                                positions.append(round(secondz,3))
                                positions.append(cartesianPoint[0])
                                positions.append(cartesianPoint[1])
                                positions.append(cartesianPoint[2])
                            vehicleEpoch = next(selectedLayer.getFeatures())[epochAttribute]
                            vehicleEpoch2 = timeZone.localize(vehicleEpoch.toPyDateTime()).isoformat()
                            vehiclePosition = Vehicle.Position(positions, vehicleEpoch2)
                            if self.dlg.comboBoxShowAs.currentText() == 'Point':
                                vehiclePoint = Vehicle.Point()
                            else: 
                                #Change here and add other options later
                                print('Since there is no other available option yet, please get by with point object!')
                                vehiclePoint = Vehicle.Point()
                            vehicleData = Vehicle(idn, vehiclePosition, vehiclePoint)
                            featureLines = ',\n' + json.dumps( vehicleData.getVehicleDict(), indent=4 )
                        featureLines += featureLines
                        wholeDocument = beginningLines + featureLines +'\n]\n'
                        #print(wholeDocument)
                        exportedFile.write(wholeDocument)
                        '''
                    i+=1
                        
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
