# -*- coding: utf-8 -*-
"""
/***************************************************************************
 WMSLegend
                                 A QGIS plugin
 WMS Legend
                              -------------------
        begin                : 2012-12-05
        copyright            : (C) 2012 by Luca Giorio
        email                : csi@csi.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from PyQt4.QtWebKit import *
# Initialize Qt resources from file resources.py
import resources_rc
# Import the code for the dialog

import qgis
import wmstree

class DockableWebView(QDockWidget):
    def __init__(self, onClose=None):
        #pydevd.settrace()
        self.onclose=onClose
        QDockWidget.__init__(self, None)
        self.setAttribute(Qt.WA_DeleteOnClose)

        self.mainWidget = QWebView(self)
        self.setWidget(self.mainWidget)        
        self.mainWidget.page().setLinkDelegationPolicy(QWebPage.DelegateAllLinks)
        self.mainWidget.connect(self.mainWidget, SIGNAL("linkClicked(const QUrl&)"), self.linkClicked)
    def linkClicked(self, url):
        QDesktopServices.openUrl(url)
    def load(self, html):
        #mqurl = QUrl.fromUserInput(QString.fromAscii(url))
        qmhtml = QString.fromAscii(html)
        self.mainWidget.setHtml(qmhtml) #,mqurl)

    def closeEvent(self, event):
        if self.onclose!=None:
            self.onclose()

class WMSLegend:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        self.webView=None

    def initGui(self):       
        # Create action that will start plugin configuration
        plugin_dir = QFileInfo(QgsApplication.qgisUserDbFilePath()).path()
        self.action = QAction(QIcon("%s/python/plugins/CSIWMSLegend/icon.png"%plugin_dir), \
            u"CSI WMS Legend", self.iface.mainWindow())

        QObject.connect(self.action, SIGNAL("triggered()"), self.ShowLegend)
        QObject.connect(self.iface, SIGNAL("currentLayerChanged(QgsMapLayer *)"), self.CurrentLayerChanged)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu(u"&CSI WMS Legend", self.action)


    def unload(self):
        QObject.disconnect(self.action, SIGNAL("triggered()"), self.ShowLegend)
        QObject.disconnect(self.iface, SIGNAL("currentLayerChanged(QgsMapLayer *)"), self.CurrentLayerChanged)
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"&CSI WMS Legend",self.action)
        self.iface.removeToolBarIcon(self.action)
        if self.webView!=None:
            self.webView.close()
        self.webView = None

    def WebViewClosed(self):
        #pydevd.settrace()        
        self.webView=None
    def CurrentLayerChanged(self,layer):        
        #pydevd.settrace()
        if self.webView==None:
            return
        if layer==None:
            return
        if not self.webView.isVisible():
            return
        sou = str(layer.publicSource())
        if sou.startswith('url='):
            sou = sou[4:]
        if not sou.startswith('http://'):
            return
        if sou.find('?')>0:
            if sou[-1]=='&' or sou[-1]=='?':
                pass
            else:
                sou=sou+'&'
        else:
            sou = sou + '?'      
        capUrl=sou + 'service=WMS&request=getCapabilities'
        try:
            tree=wmstree.WMSTree(layer.name(),capUrl)
            
            activeLayers = []
            for l in layer.subLayers():
                activeLayers.append(str(l)) 
            
            html=tree.GetLegendHTML(activeLayers)
            self.webView.load(html)
        except:
            raise
            pass
    def ShowLegend(self):
        #pydevd.settrace()
        if self.webView==None:
            try:
                self.webView = DockableWebView(self.WebViewClosed)
                self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.webView)
            except Exception, e:
                QgsMessageLog.logMessage(str(e) , 'CSIWMSLegend')
                raise
        else:
            if self.webView.isVisible():
                self.webView.hide()
                return
            else:
                self.webView.show()
            
        self.CurrentLayerChanged(self.iface.activeLayer())