import urllib2
import xml.etree.ElementTree as ET
from qgis.core import QgsMessageLog
import sys
import cStringIO

#import pydevd

class WMSLegend:
    def __init__(self,element):
        self.format = element.find('Format').text
        onl = element.find('OnlineResource')
        for k,v in onl.items():
            if k.find('href')>0:
                self.url = v

class WMSLayer:
    def __init__(self,parentTree,parentLayer,element):
        self.parentTree=parentTree
        self.parentLayer=parentLayer
        self.name = element.find('Name').text
        self.title= element.find('Title').text
        #pydevd.settrace()
        
        self.srs=[]
        try:
            for elm in element.findall('SRS'):
                tx = elm.text
                if not tx in self.srs:
                    self.srs.append(tx)
        except:
            pass

        if len(self.srs)==0:
            try:
                for elm in element.findall('CRS'):
                    tx = elm.text
                    if not tx in self.srs:
                        self.srs.append(tx)
            except:
                pass
                
        #pydevd.settrace()
        self.style=None
        try:
            self.style = element.find('./Style/Name').text
        except:
            pass

        self.legend=None
        try:
            lg = element.find('./Style/LegendURL')
            self.legend = WMSLegend(lg)
        except:
            pass

        self.metadataurl=None
        try:
            onl = element.find('./MetadataURL/OnlineResource')
            for k,v in onl.items():
                if k.find('href')>0:
                    self.metadataurl = v
        except:
            self.metadataurl=None
            
        self.format='image/png'
        self.layers=None

        alayers = element.findall('./Layer')
        if len(alayers)>0:
            self.layers=[]
            for layer in alayers:
                self.layers.append(WMSLayer(self.parentTree,self,layer))
    def getMetadataURL(self):
        itm = self
        while itm!=None:
            if itm.metadataurl!=None and itm.metadataurl!='':
                return itm.metadataurl
            itm = itm.parentLayer
        return self.parentTree.metadataurl
    def __isNameInList(self,names):
        if names==None:
            return True
        if self.name in names:
            return True
        if self.parentLayer!=None:
            return self.parentLayer.__isNameInList(names)
        #if self.parentTree.name in names:
        #    return True
        return False
    def GetLegendHTML(self,filterLayerList):
        s=''
        if self.legend!=None:
            if self.__isNameInList(filterLayerList)==True:
                if self.metadataurl!=None:
                    s=s+"<a href='%s'><img src='%s'></a><br>\n"%(self.metadataurl,self.legend.url)
                else:
                    s=s+"<img src='%s'><br>\n"%(self.legend.url)
        if self.layers!=None:
            for l in self.layers:
                s=s+l.GetLegendHTML(filterLayerList)
        return s

class WMSTree:
    def __init__(self,name,urlCapabilities,category='',metadataurl=None):
        self.name=name
        #self.url=urlCapabilities
        self.layers=[]
        self.aformat=[]
        self.category=category
        self.metadataurl=metadataurl
        self.__ParseCapabilities(urlCapabilities)     
    def __remove_namespaces(self,doc):
        for elem in doc.getiterator():
            a=elem.tag
            if a.startswith('{'):
                elem.tag = a[a.index('}')+1:]         
    def __ParseCapabilities(self,urlCap):        
        xmlContent=''
        #import LUtils
        try:
            #LUtils.LogFile.write("urllib.urlopen %s\n"%urlCap,False)          
            filehandle = urllib2.urlopen(urlCap)
            try:
                xmlContent=filehandle.read()
            finally:
                filehandle.close()
            #LUtils.LogFile.write(xmlContent)            
        except Exception,ex:
            QgsMessageLog.logMessage( ' filehandle read error: ' + str(ex) , 'wmstree' )
            QgsMessageLog.logMessage( urlCap, 'wmstree')
            raise
     
        #LUtils.LogFile.write("\n\n")       
        logstep=1
        try:
            #import pydevd
            #pydevd.settrace()            
            tval = cStringIO.StringIO(xmlContent)
            logstep=2
            xmldoc = ET.parse(tval)
            
            logstep=3
            self.__remove_namespaces(xmldoc)

            #raise ValueError,"ok"
        except Exception, ex:

            #LUtils.LogFile.write("\nexception step %d: %s\nurlCap: %s\n\nxmlContent \n"%(logstep,ex,urlCap))
            #LUtils.LogFile.write(xmlContent)
            #LUtils.LogFile.write("\n\n")

            
            QgsMessageLog.logMessage("xml format error [%d] "%logstep + urlCap , 'wmstree' )
            QgsMessageLog.logMessage(str(ex), 'wmstree' )
            #QgsMessageLog.logMessage( xmlContent , 'wmstree' )
            #raise
            return

        msg=[]
        try:          
            cap = xmldoc.find('Capability')
            if cap==None:
                msg.append( 'Tag Capability non trovato')
            else:
                alayers = cap.findall('./Layer')
                if cap==None:
                    msg.append( 'Tag Layers non trovato')
               
                if len(alayers)==0:
                    msg.append( 'Tag Layers trovato ma di lunghezza 0')
                    #QgsMessageLog.logMessage( xmlContent , 'wmstree' )
                else:
                    for layer in alayers:
                        try:
                            self.layers.append(WMSLayer(self,None,layer))
                        except Exception, ex:
                            msg.append(str(ex))
    
                taformat = cap.findall('./Request/GetMap/Format')
                if taformat==None:
                    msg.append( 'Tag ./Request/GetMap/Format non trovato')
                else:
                    self.aformat = [t.text for t in taformat]
        except Exception,ex:
            msg.append(str(ex))
        
        if len(msg)>0:
            s = urlCap + '\n' + '\n'.join(msg)
            QgsMessageLog.logMessage( s , 'wmstree' )            
        
    def GetLegendHTML(self, filterLayerList=None):
        s="<html><body>\n"
        for l in self.layers[:]:
            s=s+l.GetLegendHTML(filterLayerList)
        s=s+"</body></html>"
        return s

