# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CPR
                                 A QGIS plugin
 CPR (Colour Pattern Regression)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-05-16
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Vielca Ingenieros
        email                : pep.j@vielca.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon, QColor
from qgis.PyQt import QtGui, uic
from qgis.PyQt.QtWidgets import QAction, QMessageBox, QTableWidgetItem, QTableWidget
from qgis.core import QgsRasterLayer,  QgsRasterBandStats, QgsProject, QgsVectorLayer, QgsFillSymbol,QgsRenderContext, QgsColorRampShader, QgsRasterShader, QgsSingleBandPseudoColorRenderer
from qgis.core import QgsMessageLog
from console import console
from osgeo import gdal, ogr



# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .CPR_dialog import CPRDialog
import os.path
from scipy.optimize import minimize
import pandas as pd


class CPR:
    """QGIS Plugin Implementation."""
    TYPE_STYLE_POLYGON  = 1
    TYPE_STYLE_POLYLINE = 2


    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CPR_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CPR')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CPR', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/CPR/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'CPR (Colour Pattern Regression)'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&CPR'),
                action)
            self.iface.removeToolBarIcon(action)
    
    
    def run(self):
        """Run method that performs all the real work"""

        if self.first_start == True:
            self.first_start = False
            self.dlg = CPRDialog()
            header_columns=["NNSE", "KGE", "PBIAS"]
            header_rows=["Very good", "Good", "Satisfactory", "Unsatisfactory"]
            self.dlg.cpr_adjust.setRowCount(len(header_rows))
            self.dlg.cpr_adjust.setColumnCount(len(header_columns))

            self.dlg.cpr_adjust.setHorizontalHeaderLabels(header_columns)
            self.dlg.cpr_adjust.setVerticalHeaderLabels(header_rows)

            result_nnse_input=["[0.4;1]", "[0.3;0.4]", "[0.2;0.3]", "[0.2]"]
            result_kge_input=["[0;1]", "[-0.5;0]", "[-2;-0.5]", "[-2]"]
            result_pbias_input=["[+-25]", "[+-25;+-40]", "[+-40;+-70]", "[+-70]"]

            for x in range(0, len(result_nnse_input)):
                label = QTableWidgetItem()
                label.setText(result_nnse_input[x])
                self.dlg.cpr_adjust.setItem(x,0,label)

            for x in range(0, len(result_kge_input)):
                label = QTableWidgetItem()
                label.setText(result_kge_input[x])
                self.dlg.cpr_adjust.setItem(x,1,label)

            for x in range(0, len(result_pbias_input)):

                label = QTableWidgetItem()
                label.setText(result_pbias_input[x])
                self.dlg.cpr_adjust.setItem(x,2,label)


        self.dlg.show()
        self.dlg.cpr_calc.clicked.connect(self.cpr_func_calc)
        self.dlg.cpr_close.clicked.connect(self.cpr_func_close)
        

        header_columns=["NNSE", "KGE", "PBIAS"]
        header_rows=["Very good", "Good", "Satisfactory", "Unsatisfactory"]

        self.dlg.cpr_result.setRowCount(len(header_rows))
        self.dlg.cpr_result.setColumnCount(len(header_columns))

        self.dlg.cpr_result.setHorizontalHeaderLabels(header_columns)
        self.dlg.cpr_result.setVerticalHeaderLabels(header_rows)
          
        result_nnse=["0","0","0","0",]
        result_kge=["0","0","0","0",]
        result_pbias=["0","0","0","0",]

        for x in range(0, len(result_nnse)):
            label = QTableWidgetItem()
            label.setText(result_nnse[x])
            self.dlg.cpr_result.setItem(x,0,label)

        for x in range(0, len(result_kge)):
            label = QTableWidgetItem()
            label.setText(result_kge[x])
            self.dlg.cpr_result.setItem(x,1,label)

        for x in range(0, len(result_pbias)):
            label = QTableWidgetItem()
            label.setText(result_pbias[x])
            self.dlg.cpr_result.setItem(x,2,label)

        self.dlg.cpr_progress.setValue(0)
        
        result = self.dlg.exec_()
        
        if result:
            pass
        
    def cpr_func_calc(self):
        import warnings
        warnings.filterwarnings("ignore")
        import numpy as np
        from osgeo import gdal, ogr
        import time
        import os
                
        cpr_raster_input = self.dlg.cpr_raster_input.filePath()
        cpr_image_input = self.dlg.cpr_image_input.filePath()
        cpr_interest_area = self.dlg.cpr_interest_area.filePath()
        cpr_result_destination = self.dlg.cpr_result_destination.filePath()
        self.dlg.cpr_progress.setValue(0)

        root = QgsProject.instance().layerTreeRoot()
        QgsProject.instance().removeAllMapLayers()
        groups = []
        groups.append(root.findGroup('Input Data'))
        groups.append(root.findGroup('Statistics'))
        groups.append(root.findGroup('Results'))
        for group in groups:
            if group is not None:
                for child in group.children():
                    QgsProject.instance().removeMapLayer(child.layerId())
                root.removeChildNode(group)

        group_input_data = root.insertGroup(0, "Input Data")
        group_statistics = root.insertGroup(1, "Statistics")
        group_results = root.insertGroup(2, "Results")
        
        color = list(np.random.choice(range(256), size=3))
        self.cpr_cpr_load_vector_map_in_group(cpr_interest_area, self.TYPE_STYLE_POLYLINE, group_input_data, color)
        
        self.cpr_load_map_raster_in_group(cpr_image_input, group_input_data)
        self.cpr_load_map_raster_in_group(cpr_raster_input, group_input_data)

        NODATA = -3.4028235e+37

        cpr_dst_raster = os.path.join(cpr_result_destination, "raster.tif")
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True)            
        gdal.Warp(srcDSOrSrcDSTab=cpr_raster_input,
                    destNameOrDestDS=cpr_dst_raster,
                    options=options)  

        cpr_dst_image = os.path.join(cpr_result_destination, "origin_rgb.tif")
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True)
        gdal.Warp (srcDSOrSrcDSTab=cpr_image_input,
                    destNameOrDestDS=cpr_dst_image,
                    options=options) 

        cpr_in_ds_raster = gdal.Open(cpr_dst_raster)
        DIM_X_raster = int(cpr_in_ds_raster.RasterXSize)
        DIM_Y_raster = int(cpr_in_ds_raster.RasterYSize)
        
        cpr_in_ds_image = gdal.Open(cpr_dst_image)
        DIM_X_image = int(cpr_in_ds_image.RasterXSize)
        DIM_Y_image = int(cpr_in_ds_image.RasterYSize)
        
        highres = max(DIM_X_raster*DIM_Y_raster, DIM_X_image*DIM_Y_image)
        lowres = min(DIM_X_raster*DIM_Y_raster, DIM_X_image*DIM_Y_image)
        
        if DIM_X_raster*DIM_Y_raster == highres:
            width_highres = DIM_X_raster
            height_highres = DIM_Y_raster
        else:
            width_highres = DIM_X_image
            height_highres = DIM_Y_image
        
        if DIM_X_raster*DIM_Y_raster == lowres:
            width_lowres = DIM_X_raster
            height_lowres = DIM_Y_raster
        else:
            width_lowres = DIM_X_image
            height_lowres = DIM_Y_image
           
        
        cpr_dst_raster_highres= os.path.join(cpr_result_destination, "raster_highres.tif")      
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True, width = width_highres, height=height_highres)   
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_raster, 
                    destNameOrDestDS=cpr_dst_raster_highres,
                    options=options)

        cpr_in_ds_raster_highres = gdal.Open(cpr_dst_raster_highres)
        cpr_bnd_raster_highres = cpr_in_ds_raster_highres.GetRasterBand(1)
        cpr_data_raster_highres = cpr_bnd_raster_highres.ReadAsArray()
        #cpr_data_raster_highres[cpr_data_raster_highres <= NODATA] = np.nan
        
        cpr_dst_raster_lowres= os.path.join(cpr_result_destination, "raster_lowres.tif")
        
        options = gdal.WarpOptions(width = width_lowres, height=height_lowres)
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_raster, 
                    destNameOrDestDS=cpr_dst_raster_lowres, 
                    options=options)

        if cpr_bnd_raster_highres.GetMinimum() is None or cpr_bnd_raster_highres.GetMaximum() is None:
            cpr_bnd_raster_highres.ComputeStatistics(0)
    
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True, width = width_highres, height=height_highres)   
        cpr_dst_image_highres= os.path.join(cpr_result_destination, "origin_rgb_highres.tif")
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_image, 
                    destNameOrDestDS=cpr_dst_image_highres,
                    options=options)
        
        cpr_in_ds_image_highres  = gdal.Open(cpr_dst_image_highres)
        cpr_matrix_red_image_highres = cpr_in_ds_image_highres.GetRasterBand(1)
        cpr_data_red_image_highres = cpr_matrix_red_image_highres.ReadAsArray()
        cpr_matrix_green_image_highres = cpr_in_ds_image_highres.GetRasterBand(2)
        cpr_data_green_image_highres = cpr_matrix_green_image_highres.ReadAsArray()
        cpr_matrix_blue_image_highres = cpr_in_ds_image_highres.GetRasterBand(3)
        cpr_data_blue_image_highres = cpr_matrix_blue_image_highres.ReadAsArray()

        options = gdal.WarpOptions(width = width_lowres, height=height_lowres)
        cpr_dst_image_lowres= os.path.join(cpr_result_destination, "origin_rgb_lowres.tif")
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_image, 
                    destNameOrDestDS=cpr_dst_image_lowres
                    ,options=options)

        cpr_in_ds_image_lowres  = gdal.Open(cpr_dst_image_lowres)
        cpr_matrix_red_image_lowres = cpr_in_ds_image_lowres.GetRasterBand(1)
        cpr_data_red_image_lowres = cpr_matrix_red_image_lowres.ReadAsArray()
        cpr_matrix_green_image_lowres = cpr_in_ds_image_lowres.GetRasterBand(2)
        cpr_data_green_image_lowres = cpr_matrix_green_image_lowres.ReadAsArray()
        cpr_matrix_blue_image_lowres = cpr_in_ds_image_lowres.GetRasterBand(3)
        cpr_data_blue_image_lowres = cpr_matrix_blue_image_lowres.ReadAsArray()

        cpr_in_ds_raster_lowres = gdal.Open(cpr_dst_raster_lowres)
        cpr_bnd_raster_lowres = cpr_in_ds_raster_lowres.GetRasterBand(1)
        cpr_data_raster_lowres = cpr_bnd_raster_lowres.ReadAsArray()
        cpr_data_raster_lowres[cpr_data_raster_lowres <= NODATA] = np.nan


        #rgb_interest_area
        cpr_in_ds_rgb_lowres  = gdal.Open(cpr_dst_image_lowres)
        cpr_matrix_red_rgb_lowres = cpr_in_ds_rgb_lowres.GetRasterBand(1)
        cpr_data_red_rgb_lowres = cpr_matrix_red_rgb_lowres.ReadAsArray()
        cpr_matrix_green_rgb_lowres = cpr_in_ds_rgb_lowres.GetRasterBand(2)
        cpr_data_green_rgb_lowres = cpr_matrix_green_rgb_lowres.ReadAsArray()
        cpr_matrix_blue_rgb_lowres = cpr_in_ds_rgb_lowres.GetRasterBand(3)
        cpr_data_blue_rgb_lowres = cpr_matrix_blue_rgb_lowres.ReadAsArray()
        
        cpr_in_ds_rgb_highres  = gdal.Open(cpr_dst_image_highres)
        cpr_matrix_red_rgb_highres = cpr_in_ds_rgb_highres.GetRasterBand(1)
        cpr_data_red_rgb_highres = cpr_matrix_red_rgb_highres.ReadAsArray()
        cpr_matrix_green_rgb_highres = cpr_in_ds_rgb_highres.GetRasterBand(2)
        cpr_data_green_rgb_highres = cpr_matrix_green_rgb_highres.ReadAsArray()
        cpr_matrix_blue_rgb_highres = cpr_in_ds_rgb_highres.GetRasterBand(3)
        cpr_data_blue_rgb_highres = cpr_matrix_blue_rgb_highres.ReadAsArray()

        objetive = 1e+300
    
        coefficient_red=0
        coefficient_green=0 
        coefficient_blue=0
                
        position_red=0
        position_blue=0
        position_green=0

        self.dlg.cpr_progress.setValue(20)

        
        def objective_function(params):
            coefficient_red_cnt, coefficient_green_cnt, coefficient_blue_cnt = params
            image = (coefficient_red_cnt * cpr_data_red_image_lowres + 
                coefficient_green_cnt * cpr_data_green_image_lowres + 
                coefficient_blue_cnt * cpr_data_blue_image_lowres).astype(np.float64)
            image = np.ma.masked_invalid(image)
            diff_obj = np.square(image - cpr_data_raster_lowres).astype(np.float64)
            diff_obj = np.nansum(diff_obj)
            diff_obj = np.sqrt(diff_obj)
        
            return diff_obj
        
        x0 = np.array([0, 0, 0])
        bnds=[(0,None), (0,None), (0,None)]
        res = minimize(objective_function, x0,  bounds=bnds, method='L-BFGS-B', options={'xatol': 1e-8, 'disp': False})
        x_min = res.x

        # Coeficientes óptimos
        coefficient_red = x_min[0]
        coefficient_green = x_min[1]
        coefficient_blue = x_min[2]

      
        self.dlg.cpr_progress.setValue(40)
        

        self.dlg.cpr_red_coefficient.setPlainText("{:.5f}".format(coefficient_red))
        self.dlg.cpr_green_coefficient.setPlainText("{:.5f}".format(coefficient_green))
        self.dlg.cpr_blue_coefficient.setPlainText("{:.5f}".format(coefficient_blue))        

        self.dlg.cpr_progress.setValue(60)
        
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True,  width = width_highres, height = height_highres)
        cpr_dst_raster_stats = os.path.join(cpr_result_destination, "raster_stats.tif")

        gdal.Warp(srcDSOrSrcDSTab=cpr_raster_input,
                    destNameOrDestDS=cpr_dst_raster_stats,
                    options=options) 
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True ,  width = width_highres, height = height_highres)            
        cpr_dst_image_stats = os.path.join(cpr_result_destination, "origin_rgb_stats.tif")

        gdal.Warp(srcDSOrSrcDSTab=cpr_image_input,
                    destNameOrDestDS=cpr_dst_image_stats,
                    options=options) 


        cpr_dst_raster_stats_lowres = os.path.join(cpr_result_destination, "raster_stats_lowres.tif")
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True, width = width_lowres, height = height_lowres)
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_raster_stats, 
                    destNameOrDestDS=cpr_dst_raster_stats_lowres, 
                    options=options)

        cpr_in_ds_raster_stats_lowres = gdal.Open(cpr_dst_raster_stats_lowres)

        cpr_bnd_raster_stats_lowres = cpr_in_ds_raster_stats_lowres.GetRasterBand(1)
        cpr_data_raster_stats_lowres = cpr_bnd_raster_stats_lowres.ReadAsArray()
        cpr_data_raster_stats_lowres[cpr_data_raster_stats_lowres <= NODATA] = np.nan
        
        options = gdal.WarpOptions(width = width_highres, height = height_highres)
        cpr_dst_raster_stats_highres = os.path.join(cpr_result_destination, "raster_stats_highres.tif")
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_raster_stats, 
                    destNameOrDestDS=cpr_dst_raster_stats_highres, 
                    options=options)
         
        cpr_dst_image_stats_lowres= os.path.join(cpr_result_destination, "origin_rgb_stats_lowres.tif")
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True,  width = width_lowres, height = height_lowres)
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_image_stats, 
                    destNameOrDestDS=cpr_dst_image_stats_lowres, 
                    options=options)

        cpr_in_ds_image_stats_lowres  = gdal.Open(cpr_dst_image_stats_lowres)

        cpr_matrix_red_image_stats_lowres = cpr_in_ds_image_stats_lowres.GetRasterBand(1)
        cpr_data_red_image_stats_lowres = cpr_matrix_red_image_stats_lowres.ReadAsArray()
        cpr_matrix_green_image_stats_lowres = cpr_in_ds_image_stats_lowres.GetRasterBand(2)
        cpr_data_green_image_stats_lowres = cpr_matrix_green_image_stats_lowres.ReadAsArray()
        cpr_matrix_blue_image_stats_lowres = cpr_in_ds_image_stats_lowres.GetRasterBand(3)
        cpr_data_blue_image_stats_lowres = cpr_matrix_blue_image_stats_lowres.ReadAsArray()

        options = gdal.WarpOptions(width = width_highres, height = height_highres)
        
        cpr_dst_image_stats_highres= os.path.join(cpr_result_destination, "origin_rgb_stats_highres.tif")

        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_image_stats, 
                    destNameOrDestDS=cpr_dst_image_stats_highres, 
                    options=options)

        cpr_in_ds_image_stats_highres  = gdal.Open(cpr_dst_image_stats_highres)

        cpr_matrix_red_image_stats_highres = cpr_in_ds_image_stats_highres.GetRasterBand(1)
        cpr_data_red_image_stats_highres = cpr_matrix_red_image_stats_highres.ReadAsArray()
        cpr_matrix_green_image_stats_highres = cpr_in_ds_image_stats_highres.GetRasterBand(2)
        cpr_data_green_image_stats_highres = cpr_matrix_green_image_stats_highres.ReadAsArray()
        cpr_matrix_blue_image_stats_highres = cpr_in_ds_image_stats_highres.GetRasterBand(3)
        cpr_data_blue_image_stats_highres = cpr_matrix_blue_image_stats_highres.ReadAsArray()

        self.cpr_load_map_raster_in_group(cpr_dst_raster_highres, group_results)

        cpr_in_ds_raster_stats_highres = gdal.Open(cpr_dst_raster_stats_highres)
        cpr_bnd_raster_stats_highres = cpr_in_ds_raster_stats_highres.GetRasterBand(1)
        cpr_data_raster_stats_highres = cpr_bnd_raster_stats_highres.ReadAsArray()
        cpr_data_raster_stats_highres[cpr_data_raster_stats_highres <= NODATA] = np.nan

        vector_image_normalized_stats_lowres = coefficient_red * cpr_data_red_image_stats_lowres + coefficient_green * cpr_data_green_image_stats_lowres + coefficient_blue * cpr_data_blue_image_stats_lowres

        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_vector_image_normalized_stats_lowres= os.path.join(cpr_result_destination, "vector_image_normalized_stats_lowres.tif")

        out_ds = gtiff_driver.Create(cpr_dst_vector_image_normalized_stats_lowres, cpr_in_ds_image_stats_lowres.RasterXSize, cpr_in_ds_image_stats_lowres.RasterYSize, 1, gdal.GDT_Float32)

        out_ds.SetGeoTransform(cpr_in_ds_image_stats_lowres.GetGeoTransform())     
        out_ds.SetProjection(cpr_in_ds_image_stats_lowres.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(vector_image_normalized_stats_lowres)
        out_band.FlushCache()

        del out_ds
        vector_image_normalized_stats_highres = coefficient_red * cpr_data_red_image_stats_highres + coefficient_green * cpr_data_green_image_stats_highres + coefficient_blue * cpr_data_blue_image_stats_highres

        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_vector_image_normalized_stats_highres= os.path.join(cpr_result_destination, "vector_image_normalized_stats_highres.tif")        

        out_ds = gtiff_driver.Create(cpr_dst_vector_image_normalized_stats_highres, width_highres,  height_highres, 1, gdal.GDT_Float32)

        out_ds.SetGeoTransform(cpr_in_ds_image_stats_highres.GetGeoTransform())     
        out_ds.SetProjection(cpr_in_ds_image_stats_highres.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(vector_image_normalized_stats_highres)
        out_band.FlushCache()

        del out_ds
        
        SCALE = 10       
       
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True, width = width_lowres, height = height_lowres, resampleAlg='near')
        cpr_dst_raster_stats_resamp = os.path.join(cpr_result_destination, "raster_stats_resamp.tif")
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_raster_stats_lowres, 
                    destNameOrDestDS=cpr_dst_raster_stats_resamp, 
                    options=options)
        
        dim_resamp = gdal.Open("raster_stats_resamp.tif")
        
        DIM_X_RAST_RESAMP = dim_resamp.RasterXSize
        DIM_Y_RAST_RESAMP = dim_resamp.RasterYSize
        
        width_resamp = SCALE*DIM_X_RAST_RESAMP
        height_resamp = SCALE*DIM_Y_RAST_RESAMP
        
        options = gdal.WarpOptions(cutlineDSName=cpr_interest_area, cropToCutline=True)
        cpr_dst_image_stats_cut = os.path.join(cpr_result_destination, "image_stats_cut.tif")
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_vector_image_normalized_stats_lowres, 
                    destNameOrDestDS=cpr_dst_image_stats_cut, 
                    options=options)
        
        options = gdal.WarpOptions(width = width_resamp, height = height_resamp, resampleAlg='near')
        cpr_dst_image_stats_resamp = os.path.join(cpr_result_destination, "image_stats_resamp.tif")
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_image_stats_cut, 
                    destNameOrDestDS=cpr_dst_image_stats_resamp, 
                    options=options)
        
        options = gdal.WarpOptions(width = width_resamp, height = height_resamp, resampleAlg='near')
        cpr_dst_raster_stats_resamp_calc = os.path.join(cpr_result_destination, "raster_stats_resamp_calc.tif")
        gdal.Warp(srcDSOrSrcDSTab=cpr_dst_raster_stats_resamp, 
                    destNameOrDestDS=cpr_dst_raster_stats_resamp_calc, 
                    options=options)

        cpr_data_raster_stats_corr_NNSE_lowres = np.empty((DIM_Y_RAST_RESAMP, DIM_X_RAST_RESAMP), np.float32)
        cpr_data_raster_stats_corr_NNSE_lowres[:] = np.nan
        cpr_data_raster_stats_corr_PBIAS_lowres = np.empty((DIM_Y_RAST_RESAMP, DIM_X_RAST_RESAMP), np.float32)
        cpr_data_raster_stats_corr_PBIAS_lowres[:] = np.nan
        cpr_data_raster_stats_corr_KGE_lowres = np.empty((DIM_Y_RAST_RESAMP, DIM_X_RAST_RESAMP), np.float32)     
        cpr_data_raster_stats_corr_KGE_lowres[:] = np.nan  
        
        cpr_data_raster_stats_corr_NNSE_highres = np.empty((height_resamp, width_resamp), np.float32)
        cpr_data_raster_stats_corr_NNSE_highres[:] = np.nan
        cpr_data_raster_stats_corr_PBIAS_highres = np.empty((height_resamp, width_resamp), np.float32)
        cpr_data_raster_stats_corr_PBIAS_highres[:] = np.nan
        cpr_data_raster_stats_corr_KGE_highres = np.empty((height_resamp, width_resamp), np.float32)     
        cpr_data_raster_stats_corr_KGE_highres[:] = np.nan  
        
        cpr_nnse_vg = 0
        cpr_kge_vg = 0
        cpr_pbias_vg = 0

        cpr_nnse_g = 0
        cpr_kge_g = 0
        cpr_pbias_g = 0
        
        cpr_nnse_s = 0
        cpr_kge_s = 0
        cpr_pbias_s = 0

        cpr_nnse_us = 0
        cpr_kge_us = 0
        cpr_pbias_us = 0

        cpr_pbias_total = 0
        cpr_kge_total = 0
        cpr_nnse_total = 0

        self.dlg.cpr_progress.setValue(80)  
        media_obs = np.nanmean(cpr_data_raster_stats_highres)
                
        result_nnse_input=[]
        result_kge_input=[]
        result_pbias_input=[]
        
        get_nnse_input=[]
        get_kge_input=[]
        get_pbias_input=[]
        
        for x in range(0, 4):
            get_nnse_input.append(self.dlg.cpr_adjust.item(x, 0).text())
            
        for x in range(0, 4):
            get_kge_input.append(self.dlg.cpr_adjust.item(x, 1).text())
            
        for x in range(0, 4):
            get_pbias_input.append(self.dlg.cpr_adjust.item(x, 2).text())           

        for x in range(0, 4):
            result_nnse_input.append(self.dlg.cpr_adjust.item(x, 0).text())

        for x in range(0, 4):
            result_kge_input.append(self.dlg.cpr_adjust.item(x, 1).text())

        for x in range(0, 4):
            string_aux = self.dlg.cpr_adjust.item(x, 2).text().replace('+', '')
            string_aux = string_aux.replace('-', '')
            result_pbias_input.append(string_aux)
        
        cpr_img = gdal.Open(cpr_dst_image_stats_resamp)
        cpr_bnd_img = cpr_img.GetRasterBand(1)
        cpr_data_img = cpr_bnd_img.ReadAsArray()
        #cpr_data_img[cpr_data_img <= NODATA] = np.nan
        
        cpr_rast = gdal.Open(cpr_dst_raster_stats_resamp_calc)
        cpr_bnd_rast = cpr_rast.GetRasterBand(1)
        cpr_data_rast = cpr_bnd_rast.ReadAsArray()
        #cpr_data_rast[cpr_data_rast <= NODATA] = np.nan

        result_nnse_p1 = 0
        result_nnse_p2 = 0
        result_nnse_p3 = 0
        result_nnse_p4 = 0
        result_kge_p1 = 0
        result_kge_p2 = 0
        result_kge_p3 = 0
        result_kge_p4 = 0
        result_pbias_p1 = 0
        result_pbias_p2 = 0
        result_pbias_p3 = 0
        result_pbias_p4 = 0
        
        kge_fuera_rango = []
        nnse_fuera_rango = []
        pbias_fuera_rango = []
        
        
        total_recorrido = 0
        
        for slc_rows  in range(0, int(DIM_Y_RAST_RESAMP) , 1):
            for slc_cols  in range(0, int(DIM_X_RAST_RESAMP), 1):
            
                size_col_init = (slc_cols * SCALE) 
                size_col_end = (slc_cols * SCALE) + (SCALE - 1)
                size_row_init = (slc_rows * SCALE) 
                size_row_end = (slc_rows * SCALE) + (SCALE - 1)
                matrix_image = []
                matrix_raster = []
                #print(slc_cols,slc_rows,'-> [',size_col_init, size_col_end, size_row_init, size_row_end, ']')
             
                for col in range(size_col_init , size_col_end + 1, 1):           
                    for row in range(size_row_init, size_row_end + 1, 1):  
                       matrix_raster.append(cpr_data_rast[row, col])
                       matrix_image.append(cpr_data_img[row, col])
                
                matrix_raster_flatten = np.array(matrix_raster).flatten()
                total_recorrido += 1
        
                if (np.nansum(matrix_raster_flatten) == 0):
                    nnse = np.nan
                    kge_ = np.nan
                    pbias = np.nan
                    cpr_data_raster_stats_corr_NNSE_lowres[slc_rows, slc_cols] = nnse
                    cpr_data_raster_stats_corr_KGE_lowres[slc_rows, slc_cols] = kge_
                    cpr_data_raster_stats_corr_PBIAS_lowres[slc_rows, slc_cols] = pbias
                    #continue
                else:
                
        
                    matrix_image_flatten = np.array(matrix_image).flatten()
                        
                    nse_pablo = 1 - ((np.nansum(matrix_raster_flatten - matrix_image_flatten) ** 2) / np.nansum((matrix_raster_flatten - media_obs) ** 2))
                    nnse = 1/(2-nse_pablo)                
                    
                    # kge inicio
                    sim_mean = np.nanmean(matrix_image_flatten)
                    obs_mean = np.nanmean(matrix_raster_flatten)
                    obs_var = np.nanstd(matrix_raster_flatten)
                    alpha = (np.nanstd(matrix_image_flatten) / obs_var)
                    beta = sim_mean / obs_mean
                    r_num = np.nansum((matrix_raster_flatten - obs_mean) * (matrix_image_flatten - sim_mean))
                    r_den = np.sqrt(np.nansum((matrix_raster_flatten - obs_mean) ** 2)) * np.sqrt(np.nansum((matrix_image_flatten - sim_mean) ** 2))                
                    r = r_num / r_den
                    kge_ = 1 - np.sqrt((r - 1) ** 2 + (alpha - 1) ** 2 + (beta - 1) ** 2)
                    values_kge = np.vstack((kge_, r, alpha, beta))
                    pbias = (100 * (np.nansum(matrix_raster_flatten - matrix_image_flatten) / (len(matrix_raster_flatten) * obs_mean)))
            
            
                    cpr_data_raster_stats_corr_NNSE_lowres[slc_rows, slc_cols] = nnse
                    cpr_data_raster_stats_corr_KGE_lowres[slc_rows, slc_cols] = kge_
                    cpr_data_raster_stats_corr_PBIAS_lowres[slc_rows, slc_cols] = pbias
                
                #matrix_image_flatten = np.array(matrix_image).flatten()
                #    
                #nse_pablo = 1 - ((np.nansum(matrix_raster_flatten - matrix_image_flatten) ** 2) / np.nansum((matrix_raster_flatten - media_obs) ** 2))
                #nnse = 1/(2-nse_pablo)                
                #
                ## kge inicio
                #sim_mean = np.nanmean(matrix_image_flatten)
                #obs_mean = np.nanmean(matrix_raster_flatten)
                #obs_var = np.nanstd(matrix_raster_flatten)
                #alpha = (np.nanstd(matrix_image_flatten) / obs_var)
                #beta = sim_mean / obs_mean
                #r_num = np.nansum((matrix_raster_flatten - obs_mean) * (matrix_image_flatten - sim_mean))
                #r_den = np.sqrt(np.nansum((matrix_raster_flatten - obs_mean) ** 2)) * np.sqrt(np.nansum((matrix_image_flatten - sim_mean) ** 2))                
                #r = r_num / r_den
                #kge_ = 1 - np.sqrt((r - 1) ** 2 + (alpha - 1) ** 2 + (beta - 1) ** 2)
                #values_kge = np.vstack((kge_, r, alpha, beta))
                #pbias = (100 * (np.nansum(matrix_raster_flatten - matrix_image_flatten) / (len(matrix_raster_flatten) * obs_mean)))
        #
        #
                #cpr_data_raster_stats_corr_NNSE_lowres[slc_rows, slc_cols] = nnse
                #cpr_data_raster_stats_corr_KGE_lowres[slc_rows, slc_cols] = kge_
                #cpr_data_raster_stats_corr_PBIAS_lowres[slc_rows, slc_cols] = pbias

                nnse_vg_max = float(result_nnse_input[0].replace('[','').replace(']','').split(';')[1])
                nnse_vg_min = float(result_nnse_input[0].replace('[','').replace(']','').split(';')[0])
                nnse_g_max = float(result_nnse_input[1].replace('[','').replace(']','').split(';')[1])
                nnse_g_min = float(result_nnse_input[1].replace('[','').replace(']','').split(';')[0])
                nnse_s_max = float(result_nnse_input[2].replace('[','').replace(']','').split(';')[1])
                nnse_s_min = float(result_nnse_input[2].replace('[','').replace(']','').split(';')[0])
                nnse_u_min = float(result_nnse_input[3].replace('[','').replace(']',''))
                   
                if nnse > nnse_vg_min and nnse <= nnse_vg_max:
                   result_nnse_p1 += 1
                 
                elif nnse > nnse_g_min and nnse <= nnse_g_max:
                   result_nnse_p2 += 1
                  
                elif nnse > nnse_s_min and nnse <= nnse_s_max:
                   result_nnse_p3 += 1
                                      
                elif nnse <= nnse_u_min:
                   result_nnse_p4 += 1
                   
                else:
                   nnse_fuera_rango.append(nnse)
                   
                   
                kge_vg_max = float(result_kge_input[0].replace('[','').replace(']','').split(';')[1])
                kge_vg_min = float(result_kge_input[0].replace('[','').replace(']','').split(';')[0])
                kge_g_max = float(result_kge_input[1].replace('[','').replace(']','').split(';')[1])
                kge_g_min = float(result_kge_input[1].replace('[','').replace(']','').split(';')[0])
                kge_s_max = float(result_kge_input[2].replace('[','').replace(']','').split(';')[1])
                kge_s_min = float(result_kge_input[2].replace('[','').replace(']','').split(';')[0])
                kge_u_min = float(result_kge_input[3].replace('[','').replace(']',''))
                
                if kge_ > kge_vg_min and kge_ <= kge_vg_max:
                   result_kge_p1 += 1
                   cpr_kge_vg += 1
                   cpr_kge_total += 1                    
                elif kge_ > kge_g_min and kge_ <= kge_g_max:
                   result_kge_p2 += 1
                   cpr_kge_g += 1
                   cpr_kge_total += 1
                elif kge_ > kge_s_min and kge_ <= kge_s_max:
                   result_kge_p3 += 1
                   cpr_kge_s += 1
                   cpr_kge_total += 1
                elif kge_ <= kge_u_min:
                   result_kge_p4 += 1
                   cpr_kge_us += 1
                   cpr_kge_total += 1
                else:
                   kge_fuera_rango.append(kge_)
        
                if pbias < float(result_pbias_input[0].replace('[','').replace(']','')) and pbias > -float(result_pbias_input[0].replace('[','').replace(']','')):
                   result_pbias_p1 += 1
                   cpr_pbias_vg += 1
                   cpr_pbias_total += 1
                elif (pbias >= float(result_pbias_input[1].replace('[','').replace(']','').split(';')[0]) and pbias < float(result_pbias_input[1].replace('[','').replace(']','').split(';')[1])) or pbias <= -float(result_pbias_input[1].replace('[','').replace(']','').split(';')[0]) and pbias > -float(result_pbias_input[1].replace('[','').replace(']','').split(';')[1]):
                   result_pbias_p2 += 1
                   cpr_pbias_g += 1
                   cpr_pbias_total += 1
                elif (pbias >= float(result_pbias_input[2].replace('[','').replace(']','').split(';')[0])  and pbias < float(result_pbias_input[2].replace('[','').replace(']','').split(';')[1])) or pbias <= -float(result_pbias_input[2].replace('[','').replace(']','').split(';')[0])  and pbias > -float(result_pbias_input[2].replace('[','').replace(']','').split(';')[1]):
                   result_pbias_p3 += 1
                   cpr_pbias_s += 1
                   cpr_pbias_total += 1
                elif pbias >= float(result_pbias_input[3].replace('[','').replace(']','')) or pbias <= -float(result_pbias_input[3].replace('[','').replace(']','')):
                   result_pbias_p4 += 1
                   cpr_pbias_us += 1
                   cpr_pbias_total += 1
                else:
                   pbias_fuera_rango.append(pbias)
        
        
        result_nnse_vg = result_nnse_p1 / (total_recorrido - len(nnse_fuera_rango)) * 100
        result_nnse_g = result_nnse_p2 / (total_recorrido - len(nnse_fuera_rango)) * 100
        result_nnse_s = result_nnse_p3 / (total_recorrido - len(nnse_fuera_rango)) * 100
        result_nnse_us = result_nnse_p4 / (total_recorrido - len(nnse_fuera_rango)) * 100
        result_kge_vg = result_kge_p1 / (total_recorrido - len(kge_fuera_rango)) * 100
        result_kge_g = result_kge_p2 / (total_recorrido - len(kge_fuera_rango)) * 100
        result_kge_s = result_kge_p3 / (total_recorrido - len(kge_fuera_rango)) * 100
        result_kge_us = result_kge_p4 / (total_recorrido - len(kge_fuera_rango)) * 100
        result_pbias_vg = result_pbias_p1 / (total_recorrido - len(pbias_fuera_rango)) * 100
        result_pbias_g = result_pbias_p2 / (total_recorrido - len(pbias_fuera_rango)) * 100
        result_pbias_s = result_pbias_p3 / (total_recorrido - len(pbias_fuera_rango)) * 100
        result_pbias_us = result_pbias_p4 / (total_recorrido - len(pbias_fuera_rango)) * 100
        
        result_nnse=["{:.2f}%".format(result_nnse_vg), "{:.2f}%".format(result_nnse_g), "{:.2f}%".format(result_nnse_s), "{:.2f}%".format(result_nnse_us)]
        result_kge=["{:.2f}%".format(result_kge_vg), "{:.2f}%".format(result_kge_g), "{:.2f}%".format(result_kge_s), "{:.2f}%".format(result_kge_us)]
        result_pbias=["{:.2f}%".format(result_pbias_vg), "{:.2f}%".format(result_pbias_g), "{:.2f}%".format(result_pbias_s), "{:.2f}%".format(result_pbias_us)]

        for x in range(0, len(result_nnse)):
            label = QTableWidgetItem()
            label.setText(result_nnse[x])
            self.dlg.cpr_result.setItem(x,0,label)

        for x in range(0, len(result_kge)):
            label = QTableWidgetItem()
            label.setText(result_kge[x])
            self.dlg.cpr_result.setItem(x,1,label)

        for x in range(0, len(result_pbias)):
            label = QTableWidgetItem()
            label.setText(result_pbias[x])
            self.dlg.cpr_result.setItem(x,2,label)

        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_nnse= os.path.join(cpr_result_destination, "nnse.tif")

        out_ds = gtiff_driver.Create(cpr_dst_nnse, dim_resamp.RasterXSize, dim_resamp.RasterYSize, 1, gdal.GDT_Float32)
        out_ds.GetRasterBand(1).ComputeStatistics(False)
        
        out_ds.SetGeoTransform(dim_resamp.GetGeoTransform())     
        out_ds.SetProjection(dim_resamp.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(cpr_data_raster_stats_corr_NNSE_lowres)
        out_band.FlushCache()
        out_band.ComputeStatistics(False)

        del out_ds
        
        self.cpr_load_map_raster_in_group_colour(cpr_dst_nnse, 
                                                group_statistics, 
                                                [                                                    
                                                    float(result_nnse_input[0].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_nnse_input[1].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_nnse_input[2].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_nnse_input[3].replace('[','').replace(']',''))])
                       
        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_kge= os.path.join(cpr_result_destination, "kge.tif")
        out_ds = gtiff_driver.Create(cpr_dst_kge, dim_resamp.RasterXSize, dim_resamp.RasterYSize, 1, gdal.GDT_Float32)
        out_ds.GetRasterBand(1).ComputeStatistics(False)
        
        out_ds.SetGeoTransform(dim_resamp.GetGeoTransform())     
        out_ds.SetProjection(dim_resamp.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(cpr_data_raster_stats_corr_KGE_lowres)
        out_band.FlushCache()
        out_band.ComputeStatistics(False)

        del out_ds
        self.cpr_load_map_raster_in_group_colour(cpr_dst_kge, 
                                                group_statistics,  
                                                 [
                                                    float(result_kge_input[0].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_kge_input[1].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_kge_input[2].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_kge_input[3].replace('[','').replace(']',''))])
        
        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_pbias= os.path.join(cpr_result_destination, "pbias.tif")

        out_ds = gtiff_driver.Create(cpr_dst_pbias, dim_resamp.RasterXSize, dim_resamp.RasterYSize, 1, gdal.GDT_Float32)
        out_ds.GetRasterBand(1).ComputeStatistics(False)

        out_ds.SetGeoTransform(dim_resamp.GetGeoTransform())     
        out_ds.SetProjection(dim_resamp.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(cpr_data_raster_stats_corr_PBIAS_lowres)
        out_band.FlushCache()
        out_band.ComputeStatistics(False) 

        del out_ds
        self.cpr_load_map_raster_in_group_colour_pbias(cpr_dst_pbias, 
                                                group_statistics,  
                                                [
                                                    -float(result_pbias_input[3].replace('[','').replace(']','')),
                                                    -float(result_pbias_input[1].replace('[','').replace(']','').split(';')[1]),
                                                    -float(result_pbias_input[0].replace('[','').replace(']','')),
                                                    float(result_pbias_input[0].replace('[','').replace(']','')),
                                                    float(result_pbias_input[1].replace('[','').replace(']','').split(';')[1]),
                                                    float(result_pbias_input[3].replace('[','').replace(']','')),
                                                    float(1000000.0)])
        
        
        cpr_data_to_raster = cpr_data_red_rgb_highres * coefficient_red + cpr_data_green_rgb_highres * coefficient_green + cpr_data_blue_rgb_highres * coefficient_blue

        
        gtiff_driver = gdal.GetDriverByName('GTiff')
        cpr_dst_rgb_highres= os.path.join(cpr_result_destination, "rgb_highres.tif")
        out_ds = gtiff_driver.Create(cpr_dst_rgb_highres, cpr_in_ds_rgb_highres.RasterXSize, cpr_in_ds_rgb_highres.RasterYSize, 1, gdal.GDT_Float32)
        out_ds.GetRasterBand(1).ComputeStatistics(False)
        
        out_ds.SetGeoTransform(cpr_in_ds_rgb_highres.GetGeoTransform())     
        out_ds.SetProjection(cpr_in_ds_rgb_highres.GetProjection())

        out_band = out_ds.GetRasterBand(1)
        out_band.WriteArray(cpr_data_to_raster)
        out_band.FlushCache()
        out_band.ComputeStatistics(False)
        
        del out_ds
        self.cpr_load_map_raster_in_group(cpr_dst_rgb_highres, group_results)
        
        
        
        self.dlg.cpr_progress.setValue(100)
        
        for x in range(0, len(get_nnse_input)):
            label = QTableWidgetItem()
            label.setText(get_nnse_input[x])
            self.dlg.cpr_adjust.setItem(x,0,label)
            
        for x in range(0, len(get_kge_input)):
            label = QTableWidgetItem()
            label.setText(get_kge_input[x])
            self.dlg.cpr_adjust.setItem(x,1,label)
            
        for x in range(0, len(get_pbias_input)):
            label = QTableWidgetItem()
            label.setText(get_pbias_input[x])
            self.dlg.cpr_adjust.setItem(x,2,label)
            
    def cpr_func_close(self):    
        self.dlg.close()

    def cpr_load_map_raster(self,pathRasterMap):
        
        if self.cpr_exists(pathRasterMap):
            return True
        returnIsValidRasterMap = False
        pathRasterMap = pathRasterMap.strip()
    
        if (os.path.exists (pathRasterMap)):
    
            baseNameRasterMap   = os.path.basename (pathRasterMap)
            baseNameRasterMap = os.path.splitext(baseNameRasterMap)[0]
            layerRasterMap = QgsRasterLayer(pathRasterMap, baseNameRasterMap)
            QgsProject.instance().addMapLayer(layerRasterMap)
    
            returnIsValidRasterMap = layerRasterMap.isValid()
        return returnIsValidRasterMap

    def cpr_load_map_raster_in_group(self,pathRasterMap, group):
        if self.cpr_exists(pathRasterMap):
            return True
        returnIsValidRasterMap = False
        pathRasterMap = pathRasterMap.strip()    
    
        if (os.path.exists (pathRasterMap)):    
            baseNameRasterMap   = os.path.basename (pathRasterMap)
            baseNameRasterMap = os.path.splitext(baseNameRasterMap)[0]
            layerRasterMap = QgsRasterLayer(pathRasterMap, baseNameRasterMap)
            QgsProject.instance().addMapLayer(layerRasterMap, False)
            group.addLayer(layerRasterMap)
            returnIsValidRasterMap = layerRasterMap.isValid()
    
        return returnIsValidRasterMap 
    def cpr_load_map_raster_in_group_colour(self, pathRasterMap, group , interval):
        if self.cpr_exists(pathRasterMap):
            return True
        returnIsValidRasterMap = False
        pathRasterMap = pathRasterMap.strip()
        if (os.path.exists (pathRasterMap)):
    
            baseNameRasterMap   = os.path.basename (pathRasterMap)
            baseNameRasterMap = os.path.splitext(baseNameRasterMap)[0]
            layerRasterMap = QgsRasterLayer(pathRasterMap, baseNameRasterMap)
            QgsProject.instance().addMapLayer(layerRasterMap, False)
            group.addLayer(layerRasterMap)
            returnIsValidRasterMap = layerRasterMap.isValid()

            rasterShader = QgsRasterShader()
            colourRamp = QgsColorRampShader(interval[3], interval[0])
            
            
            colourRamp.setColorRampType(QgsColorRampShader.Discrete)
            colourRamp.setColorRampItemList([ QgsColorRampShader.ColorRampItem(interval[3], QColor(175, 25, 28), "Unsatisfactory"),
                    QgsColorRampShader.ColorRampItem(interval[2], QColor(205, 20, 216), "Satisfactory"),
                    QgsColorRampShader.ColorRampItem(interval[1], QColor(30, 45, 177), "Good"), 
                    QgsColorRampShader.ColorRampItem(interval[0], QColor(30, 177, 107), "Very good") ])
            
            rasterShader.setRasterShaderFunction(colourRamp)
            pseudoRenderer = QgsSingleBandPseudoColorRenderer(
                layerRasterMap.dataProvider(), layerRasterMap.type(),  rasterShader)

            layerRasterMap.setRenderer(pseudoRenderer)

            layerRasterMap.triggerRepaint()
            self.iface.layerTreeView().refreshLayerSymbology(layerRasterMap.id())
 
    
        return returnIsValidRasterMap
    
    def cpr_load_map_raster_in_group_colour_pbias(self, pathRasterMap, group , interval):
        if self.cpr_exists(pathRasterMap):
            return True
        returnIsValidRasterMap = False
        pathRasterMap = pathRasterMap.strip()
        if (os.path.exists (pathRasterMap)):
    
            baseNameRasterMap   = os.path.basename (pathRasterMap)
            baseNameRasterMap = os.path.splitext(baseNameRasterMap)[0]
            layerRasterMap = QgsRasterLayer(pathRasterMap, baseNameRasterMap)
            QgsProject.instance().addMapLayer(layerRasterMap, False)
            group.addLayer(layerRasterMap)
            returnIsValidRasterMap = layerRasterMap.isValid()

            rasterShader = QgsRasterShader()
            colourRamp = QgsColorRampShader(interval[3], interval[0])
            
            
            colourRamp.setColorRampType(QgsColorRampShader.Discrete)
            colourRamp.setColorRampItemList([ QgsColorRampShader.ColorRampItem(interval[0], QColor(175, 25, 28), "Unsatisfactory"),
                    QgsColorRampShader.ColorRampItem(interval[1], QColor(205, 20, 216), "Satisfactory"),
                    QgsColorRampShader.ColorRampItem(interval[2], QColor(30, 45, 177), "Good"), 
                    QgsColorRampShader.ColorRampItem(interval[3], QColor(30, 177, 107), "Very good"),
                    QgsColorRampShader.ColorRampItem(interval[4], QColor(30, 45, 177), "Good"),
                    QgsColorRampShader.ColorRampItem(interval[5], QColor(205, 20, 216), "Satisfactory"),
                    QgsColorRampShader.ColorRampItem(interval[6], QColor(175, 25, 28), "Unsatisfactory") ])
            
            rasterShader.setRasterShaderFunction(colourRamp)
            pseudoRenderer = QgsSingleBandPseudoColorRenderer(
                layerRasterMap.dataProvider(), layerRasterMap.type(),  rasterShader)

            layerRasterMap.setRenderer(pseudoRenderer)

            layerRasterMap.triggerRepaint()
            self.iface.layerTreeView().refreshLayerSymbology(layerRasterMap.id())
 
    
        return returnIsValidRasterMap 
     
    def cpr_exists(self, pathRasterMap):
        baseNameRasterMap   = os.path.basename(pathRasterMap)
        baseNameRasterMap = os.path.splitext(baseNameRasterMap)[0]
        layer_names = [layer.name() for layer in QgsProject.instance().mapLayers().values()]
        if baseNameRasterMap in layer_names:
            return True
        else:
            return False


    def cpr_cpr_load_vector_map_in_group(self, pathVectorMap, type_style, group, colour = (50,50,250)):
        returnLoadVectorMap = False
        pathVectorMap = pathVectorMap.strip()
        if os.path.exists(pathVectorMap):

            baseNameMapaVector = os.path.basename(pathVectorMap)
            baseNameMapaVector = os.path.splitext(baseNameMapaVector)[0]
            layerVectorMap = QgsVectorLayer(pathVectorMap, baseNameMapaVector, 'ogr')
            QgsProject.instance().addMapLayer(layerVectorMap, False)
            group.addLayer(layerVectorMap)

            if type_style == self.TYPE_STYLE_POLYLINE:

                symbols = layerVectorMap.renderer().symbols(QgsRenderContext())
                symbol = symbols[0]
                symbol.setColor(QtGui.QColor.fromRgb(colour[0],colour[1],colour[2]))


            elif type_style == self.TYPE_STYLE_POLYGON:

                Render = layerVectorMap.renderer()
                mySymbol = QgsFillSymbol.createSimple({'color':'blue', 
                                                          'color_border':'#%02x%02x%02x' % colour,
                                                          'style':'no',
                                                          'style_border':'solid'})

                Render.setSymbol(mySymbol)
                layerVectorMap.triggerRepaint()

            returnLoadVectorMap = layerVectorMap.isValid()
        return returnLoadVectorMap, layerVectorMap
    
    def cpr_load_vector_map(self, pathVectorMap, type_style, colour = (50,50,250), width = 0.5):
        returnLoadVectorMap = False
        pathVectorMap = pathVectorMap.strip()

        if os.path.exists(pathVectorMap):

            baseNameVectorMap = os.path.basename(pathVectorMap)
            baseNameVectorMap = os.path.splitext(baseNameVectorMap)[0]
            layerVectorMap = QgsVectorLayer(pathVectorMap, baseNameVectorMap, 'ogr')
            QgsProject.instance().addMapLayer(layerVectorMap)

            if type_style == self.TYPE_STYLE_POLYLINE:

                symbols = layerVectorMap.renderer().symbols(QgsRenderContext())
                symbol = symbols[0]
                symbol.setColor(QtGui.QColor.fromRgb(colour[0],colour[1],colour[2]))
                symbol.setWidth(width)

            elif type_style == self.TYPE_STYLE_POLYGON:

                Render = layerVectorMap.renderer()
                mySymbol = QgsFillSymbol.createSimple({'color':'blue', 
                                                          'color_border':'#%02x%02x%02x' % colour,
                                                          'width_border':str(width),
                                                          'style':'no',
                                                          'style_border':'solid'})

                Render.setSymbol(mySymbol)
                layerVectorMap.triggerRepaint()

            returnLoadVectorMap = layerVectorMap.isValid()
        return returnLoadVectorMap, layerVectorMap
    